# Copyright Spack Project Developers. See COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)


# NOTE: spack-completion.bash is auto-generated by:
#
#   $ spack commands --aliases --format=bash
#       --header=bash/spack-completion.bash --update=spack-completion.bash
#
# Please do not manually modify this file.


# The following global variables are set by Bash programmable completion:
#
#     COMP_CWORD:      An index into ${COMP_WORDS} of the word containing the
#                      current cursor position
#     COMP_KEY:        The key (or final key of a key sequence) used to invoke
#                      the current completion function
#     COMP_LINE:       The current command line
#     COMP_POINT:      The index of the current cursor position relative to the
#                      beginning of the current command
#     COMP_TYPE:       Set to an integer value corresponding to the type of
#                      completion attempted that caused a completion function
#                      to be called
#     COMP_WORDBREAKS: The set of characters that the readline library treats
#                      as word separators when performing word completion
#     COMP_WORDS:      An array variable consisting of the individual words in
#                      the current command line
#
# The following global variable is used by Bash programmable completion:
#
#     COMPREPLY:       An array variable from which bash reads the possible
#                      completions generated by a shell function invoked by the
#                      programmable completion facility
#
# See `man bash` for more details.

if test -n "${ZSH_VERSION:-}" ; then
  if [[ "$(emulate)" = zsh ]] ; then
    if ! typeset -f compdef >& /dev/null ; then
        # ensure base completion support is enabled, ignore insecure directories
        autoload -U +X compinit && compinit -i
    fi
    if ! typeset -f complete >& /dev/null ; then
        # ensure bash compatible completion support is enabled
        autoload -U +X bashcompinit && bashcompinit
    fi
    emulate sh -c "source '$0:A'"
    return # stop interpreting file
  fi
fi

# compgen -W doesn't work in some versions of zsh, so use this instead.
# see https://www.zsh.org/mla/workers/2011/msg00582.html
_compgen_w() {
    if test -n "${ZSH_VERSION:-}" ; then
        typeset -a words
        words=( ${~=1} )
        local find="$2"
        results=(${(M)words[@]:#$find*})
        echo "${results[@]}"
    else
        compgen -W "$1" -- "$2"
    fi
}

# Bash programmable completion for Spack
_bash_completion_spack() {
    # In all following examples, let the cursor be denoted by brackets, i.e. []

    # For our purposes, flags should not affect tab completion. For instance,
    # `spack install []` and `spack -d install --jobs 8 []` should both give the same
    # possible completions. Therefore, we need to ignore any flags in COMP_WORDS.
    local -a COMP_WORDS_NO_FLAGS
    local index=0
    while [[ "$index" -lt "$COMP_CWORD" ]]
    do
        if [[ "${COMP_WORDS[$index]}" == [a-z]* ]]
        then
            COMP_WORDS_NO_FLAGS+=("${COMP_WORDS[$index]}")
        fi
        let index++
    done

    # Options will be listed by a subfunction named after non-flag arguments.
    # For example, `spack -d install []` will call _spack_install
    # and `spack compiler add []` will call _spack_compiler_add
    local subfunction=$(IFS='_'; echo "_${COMP_WORDS_NO_FLAGS[*]}")

    # Translate dashes to underscores, as dashes are not permitted in
    # compatibility mode. See https://github.com/spack/spack/pull/4079
    subfunction=${subfunction//-/_}

    # However, the word containing the current cursor position needs to be
    # added regardless of whether or not it is a flag. This allows us to
    # complete something like `spack install --keep-st[]`
    COMP_WORDS_NO_FLAGS+=("${COMP_WORDS[$COMP_CWORD]}")

    # Since we have removed all words after COMP_CWORD, we can safely assume
    # that COMP_CWORD_NO_FLAGS is simply the index of the last element
    local COMP_CWORD_NO_FLAGS=$((${#COMP_WORDS_NO_FLAGS[@]} - 1))

    # There is no guarantee that the cursor is at the end of the command line
    # when tab completion is envoked. For example, in the following situation:
    #     `spack -d [] install`
    # if the user presses the TAB key, a list of valid flags should be listed.
    # Note that we cannot simply ignore everything after the cursor. In the
    # previous scenario, the user should expect to see a list of flags, but
    # not of other subcommands. Obviously, `spack -d list install` would be
    # invalid syntax. To accomplish this, we use the variable list_options
    # which is true if the current word starts with '-' or if the cursor is
    # not at the end of the line.
    local list_options=false
    if [[ "${COMP_WORDS[$COMP_CWORD]}" == -* || "$COMP_POINT" -ne "${#COMP_LINE}" ]]
    then
        list_options=true
    fi

    # In general, when envoking tab completion, the user is not expecting to
    # see optional flags mixed in with subcommands or package names. Tab
    # completion is used by those who are either lazy or just bad at spelling.
    # If someone doesn't remember what flag to use, seeing single letter flags
    # in their results won't help them, and they should instead consult the
    # documentation. However, if the user explicitly declares that they are
    # looking for a flag, we can certainly help them out.
    #     `spack install -[]`
    # and
    #     `spack install --[]`
    # should list all flags and long flags, respectively. Furthermore, if a
    # subcommand has no non-flag completions, such as `spack arch []`, it
    # should list flag completions.

    local cur=${COMP_WORDS_NO_FLAGS[$COMP_CWORD_NO_FLAGS]}

    # If the cursor is in the middle of the line, like:
    #     `spack -d [] install`
    # COMP_WORDS will not contain the empty character, so we have to add it.
    if [[ "${COMP_LINE:$COMP_POINT-1:1}" == " " ]]
    then
        cur=""
    fi

    # Uncomment this line to enable logging
    #_test_vars >> temp

    # Make sure function exists before calling it
    local rgx #this dance is necessary to cover bash and zsh regex
    rgx="$subfunction.*function.* "
    if [[ "$(LC_ALL=C type $subfunction 2>&1)" =~ $rgx ]]
    then
        $subfunction
        COMPREPLY=($(_compgen_w "$SPACK_COMPREPLY" "$cur"))
    fi

    # if every completion is an alias for the same thing, just return that thing.
    _spack_compress_aliases
}

# Helper functions for subcommands
# Results of each query are cached via environment variables

_subcommands() {
    if [[ -z "${SPACK_SUBCOMMANDS:-}" ]]
    then
        SPACK_SUBCOMMANDS="$(spack commands)"
    fi
    SPACK_COMPREPLY="$SPACK_SUBCOMMANDS"
}

_all_packages() {
    if [[ -z "${SPACK_ALL_PACKAGES:-}" ]]
    then
        SPACK_ALL_PACKAGES="$(spack list)"
    fi
    SPACK_COMPREPLY="$SPACK_ALL_PACKAGES"
}

_all_resource_hashes() {
    if [[ -z "${SPACK_ALL_RESOURCES_HASHES:-}" ]]
    then
        SPACK_ALL_RESOURCE_HASHES="$(spack resource list --only-hashes)"
    fi
    SPACK_COMPREPLY="$SPACK_ALL_RESOURCE_HASHES"
}

_installed_packages() {
    if [[ -z "${SPACK_INSTALLED_PACKAGES:-}" ]]
    then
        SPACK_INSTALLED_PACKAGES="$(spack --color=never find --no-groups)"
    fi
    SPACK_COMPREPLY="$SPACK_INSTALLED_PACKAGES"
}

_installed_compilers() {
    if [[ -z "${SPACK_INSTALLED_COMPILERS:-}" ]]
    then
        SPACK_INSTALLED_COMPILERS="$(spack compilers | egrep -v "^(-|=)")"
    fi
    SPACK_COMPREPLY="$SPACK_INSTALLED_COMPILERS"
}

_providers() {
    if [[ -z "${SPACK_PROVIDERS:-}" ]]
    then
        SPACK_PROVIDERS="$(spack providers)"
    fi
    SPACK_COMPREPLY="$SPACK_PROVIDERS"
}

_mirrors() {
    if [[ -z "${SPACK_MIRRORS:-}" ]]
    then
        SPACK_MIRRORS="$(spack mirror list | awk '{print $1}')"
    fi
    SPACK_COMPREPLY="$SPACK_MIRRORS"
}

_repos() {
    if [[ -z "${SPACK_REPOS:-}" ]]
    then
        SPACK_REPOS="$(spack repo list --names)"
    fi
    SPACK_COMPREPLY="$SPACK_REPOS"
}

_unit_tests() {
    if [[ -z "${SPACK_TESTS:-}" ]]
    then
        SPACK_TESTS="$(spack unit-test -l)"
    fi
    SPACK_COMPREPLY="$SPACK_TESTS"
}

_environments() {
    if [[ -z "${SPACK_ENVIRONMENTS:-}" ]]
    then
        SPACK_ENVIRONMENTS="$(spack env list)"
    fi
    SPACK_COMPREPLY="$SPACK_ENVIRONMENTS"
}

_keys() {
    if [[ -z "${SPACK_KEYS:-}" ]]
    then
        SPACK_KEYS="$(spack gpg list)"
    fi
    SPACK_COMPREPLY="$SPACK_KEYS"
}

_config_sections() {
    if [[ -z "${SPACK_CONFIG_SECTIONS:-}" ]]
    then
        SPACK_CONFIG_SECTIONS="$(spack config list)"
    fi
    SPACK_COMPREPLY="$SPACK_CONFIG_SECTIONS"
}

_extensions() {
    if [[ -z "${SPACK_EXTENSIONS:-}" ]]
    then
        SPACK_EXTENSIONS="$(spack extensions)"
    fi
    SPACK_COMPREPLY="$SPACK_EXTENSIONS"
}

# Testing functions

# Function for unit testing tab completion
# Syntax: _spack_completions spack install py-
_spack_completions() {
    local COMP_CWORD COMP_KEY COMP_LINE COMP_POINT COMP_TYPE COMP_WORDS COMPREPLY

    # Set each variable the way bash would
    COMP_LINE="$*"
    COMP_POINT=${#COMP_LINE}
    COMP_WORDS=("$@")
    if [[ ${COMP_LINE: -1} == ' ' ]]
    then
        COMP_WORDS+=('')
    fi
    COMP_CWORD=$((${#COMP_WORDS[@]} - 1))
    COMP_KEY=9    # ASCII 09: Horizontal Tab
    COMP_TYPE=64  # ASCII 64: '@', to list completions if the word is not unmodified

    # Run Spack's tab completion function
    _bash_completion_spack

    # Return the result
    echo "${COMPREPLY[@]:-}"
}

# Log the environment variables used
# Syntax: _test_vars >> temp
_test_vars() {
    echo "-----------------------------------------------------"
    echo "Variables set by bash:"
    echo
    echo "COMP_LINE:                '$COMP_LINE'"
    echo "# COMP_LINE:              '${#COMP_LINE}'"
    echo "COMP_WORDS:               $(_pretty_print COMP_WORDS[@])"
    echo "# COMP_WORDS:             '${#COMP_WORDS[@]}'"
    echo "COMP_CWORD:               '$COMP_CWORD'"
    echo "COMP_KEY:                 '$COMP_KEY'"
    echo "COMP_POINT:               '$COMP_POINT'"
    echo "COMP_TYPE:                '$COMP_TYPE'"
    echo "COMP_WORDBREAKS:          '$COMP_WORDBREAKS'"
    echo
    echo "Intermediate variables:"
    echo
    echo "COMP_WORDS_NO_FLAGS:      $(_pretty_print COMP_WORDS_NO_FLAGS[@])"
    echo "# COMP_WORDS_NO_FLAGS:    '${#COMP_WORDS_NO_FLAGS[@]}'"
    echo "COMP_CWORD_NO_FLAGS:      '$COMP_CWORD_NO_FLAGS'"
    echo
    echo "Subfunction:              '$subfunction'"
    if $list_options
    then
        echo "List options:             'True'"
    else
        echo "List options:             'False'"
    fi
    echo "Current word:             '$cur'"
}

# Pretty-prints one or more arrays
# Syntax: _pretty_print array1[@] ...
_pretty_print() {
    for arg in $@
    do
        local array=("${!arg}")
        printf "$arg: ["
        printf   "'%s'" "${array[0]}"
        printf ", '%s'" "${array[@]:1}"
        echo "]"
    done
}

complete -o bashdefault -o default -F _bash_completion_spack spack

# Completion for spacktivate
complete -o bashdefault -o default -F _bash_completion_spack spacktivate

_spacktivate() {
  _spack_env_activate
}

# Simple function to get the spack alias for a command
_spack_get_alias() {
    local possible_alias="${1-}"
    local IFS=";"

    # spack aliases are a ;-separated list of :-separated pairs
    for item in $SPACK_ALIASES; do
        # maps a possible alias to its command
        eval "local real_command=\"\${item#*${possible_alias}:}\""
        if [ "$real_command" != "$item" ]; then
            SPACK_ALIAS="$real_command"
            return
        fi
    done

    # no alias found -- just return $1
    SPACK_ALIAS="$possible_alias"
}

# If all commands in COMPREPLY alias to the same thing, set COMPREPLY to
# just the real command, not the aliases.
_spack_compress_aliases() {
    # If there are zero or one completions, don't do anything
    # If this isn't the first argument, bail because aliases currently only apply
    # to top-level commands.
    if [ "${#COMPREPLY[@]}" -le "1" ] || [ "$COMP_CWORD_NO_FLAGS" != "1" ]; then
        return
    fi

    # get the alias of the first thing in the list of completions
    _spack_get_alias "${COMPREPLY[@]:0:1}"
    local first_alias="$SPACK_ALIAS"

    # if anything in the list would alias to something different, stop
    for comp in "${COMPREPLY[@]:1}"; do
        _spack_get_alias "$comp"
        if [ "$SPACK_ALIAS" != "$first_alias" ]; then
            return
        fi
    done

    # all commands alias to first alias; just return that
    COMPREPLY=("$first_alias")
}

# Spack commands
#
# Everything below here is auto-generated.
SPACK_ALIASES="concretise:concretize;containerise:containerize;rm:remove"


_spack() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -H --all-help --color -c --config -C --config-scope -d --debug --timestamp --pdb -e --env -D --env-dir -E --no-env --use-env-repo -k --insecure -l --enable-locks -L --disable-locks -m --mock -b --bootstrap -p --profile --sorted-profile --lines -v --verbose --stacktrace -t --backtrace -V --version --print-shell-vars"
    else
        SPACK_COMPREPLY="add arch audit blame bootstrap build-env buildcache cd change checksum ci clean commands compiler compilers concretize concretise config containerize containerise create debug deconcretize dependencies dependents deprecate dev-build develop diff docs edit env extensions external fetch find gc gpg graph help info install license list load location log-parse logs maintainers make-installer mark mirror module patch pkg providers pydoc python reindex remove rm repo resource restage solve spec stage style tags test test-env tutorial undevelop uninstall unit-test unload url verify versions view"
    fi
}

_spack_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -l --list-name"
    else
        _all_packages
    fi
}

_spack_arch() {
    SPACK_COMPREPLY="-h --help -g --generic-target --known-targets --family --generic -p --platform -o --operating-system -t --target -f --frontend -b --backend"
}

_spack_audit() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="configs externals packages-https packages list"
    fi
}

_spack_audit_configs() {
    SPACK_COMPREPLY="-h --help"
}

_spack_audit_externals() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --list"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_audit_packages_https() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --all"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_audit_packages() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_audit_list() {
    SPACK_COMPREPLY="-h --help"
}

_spack_blame() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -t --time -p --percent -g --git --json"
    else
        _all_packages
    fi
}

_spack_bootstrap() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="now status enable disable reset root list add remove mirror"
    fi
}

_spack_bootstrap_now() {
    SPACK_COMPREPLY="-h --help --dev"
}

_spack_bootstrap_status() {
    SPACK_COMPREPLY="-h --help --optional --dev"
}

_spack_bootstrap_enable() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_bootstrap_disable() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_bootstrap_reset() {
    SPACK_COMPREPLY="-h --help -y --yes-to-all"
}

_spack_bootstrap_root() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_bootstrap_list() {
    SPACK_COMPREPLY="-h --help --scope"
}

_spack_bootstrap_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope --trust"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_bootstrap_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_bootstrap_mirror() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --binary-packages --dev"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_build_env() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --clean --dirty -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated --dump --pickle"
    else
        _all_packages
    fi
}

_spack_buildcache() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="push create install list keys check download prune save-specfile sync update-index rebuild-index migrate"
    fi
}

_spack_buildcache_push() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -f --force --unsigned -u --signed --key -k --update-index --rebuild-index --only --with-build-dependencies --without-build-dependencies --fail-fast --base-image --tag -t --private -j --jobs"
    else
        _mirrors
    fi
}

_spack_buildcache_create() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -f --force --unsigned -u --signed --key -k --update-index --rebuild-index --only --with-build-dependencies --without-build-dependencies --fail-fast --base-image --tag -t --private -j --jobs"
    else
        _mirrors
    fi
}

_spack_buildcache_install() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -f --force -m --multiple -u --unsigned -o --otherarch"
    else
        _all_packages
    fi
}

_spack_buildcache_list() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -l --long -L --very-long -N --namespaces -v --variants -a --allarch"
    else
        _all_packages
    fi
}

_spack_buildcache_keys() {
    SPACK_COMPREPLY="-h --help -i --install -t --trust -f --force"
}

_spack_buildcache_check() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -m --mirror-url -o --output-file --scope"
    else
        _all_packages
    fi
}

_spack_buildcache_download() {
    SPACK_COMPREPLY="-h --help -s --spec -p --path"
}

_spack_buildcache_prune() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --dry-run"
    else
        _mirrors
    fi
}

_spack_buildcache_save_specfile() {
    SPACK_COMPREPLY="-h --help --root-spec -s --specs --specfile-dir"
}

_spack_buildcache_sync() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --manifest-glob"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_buildcache_update_index() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -k --keys"
    else
        _mirrors
    fi
}

_spack_buildcache_rebuild_index() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -k --keys"
    else
        _mirrors
    fi
}

_spack_buildcache_migrate() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -u --unsigned -d --delete-existing -y --yes-to-all"
    else
        _mirrors
    fi
}

_spack_cd() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -m --module-dir -r --spack-root -i --install-dir -p --package-dir --repo --packages -P -s --stage-dir -S --stages -c --source-dir -b --build-dir -e --env --first"
    else
        _all_packages
    fi
}

_spack_change() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -l --list-name --match-spec -a --all"
    else
        _all_packages
    fi
}

_spack_checksum() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --keep-stage --batch -b --latest -l --preferred -p --add-to-package -a --verify -j --jobs"
    else
        _all_packages
    fi
}

_spack_ci() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="generate rebuild-index rebuild reproduce-build verify-versions"
    fi
}

_spack_ci_generate() {
    SPACK_COMPREPLY="-h --help --output-file --prune-dag --no-prune-dag --prune-unaffected --no-prune-unaffected --prune-externals --no-prune-externals --check-index-only --artifacts-root -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated -j --jobs"
}

_spack_ci_rebuild_index() {
    SPACK_COMPREPLY="-h --help"
}

_spack_ci_rebuild() {
    SPACK_COMPREPLY="-h --help -t --tests --fail-fast --timeout -j --jobs"
}

_spack_ci_reproduce_build() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --runtime --working-dir -s --autostart --use-local-head --gpg-file --gpg-url"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_ci_verify_versions() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_clean() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -s --stage -d --downloads -f --failures -m --misc-cache -p --python-cache -b --bootstrap -a --all"
    else
        _all_packages
    fi
}

_spack_commands() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --update-completion -a --aliases --format --header --update"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_compiler() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="find add remove rm list ls info"
    fi
}

_spack_compiler_find() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --mixed-toolchain --no-mixed-toolchain --scope -j --jobs"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_compiler_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --mixed-toolchain --no-mixed-toolchain --scope -j --jobs"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_compiler_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all --scope"
    else
        _installed_compilers
    fi
}

_spack_compiler_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all --scope"
    else
        _installed_compilers
    fi
}

_spack_compiler_list() {
    SPACK_COMPREPLY="-h --help --scope --remote"
}

_spack_compiler_ls() {
    SPACK_COMPREPLY="-h --help --scope --remote"
}

_spack_compiler_info() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        _installed_compilers
    fi
}

_spack_compilers() {
    SPACK_COMPREPLY="-h --help --scope --remote"
}

_spack_concretize() {
    SPACK_COMPREPLY="-h --help --test -q --quiet -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated -j --jobs"
}

_spack_concretise() {
    SPACK_COMPREPLY="-h --help --test -q --quiet -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated -j --jobs"
}

_spack_config() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        SPACK_COMPREPLY="get blame edit list scopes add change prefer-upstream remove rm update revert"
    fi
}

_spack_config_get() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _config_sections
    fi
}

_spack_config_blame() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _config_sections
    fi
}

_spack_config_edit() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --print-file"
    else
        _config_sections
    fi
}

_spack_config_list() {
    SPACK_COMPREPLY="-h --help"
}

_spack_config_scopes() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -p --paths -t --type"
    else
        _config_sections
    fi
}

_spack_config_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -f --file"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_config_change() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --match-spec"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_config_prefer_upstream() {
    SPACK_COMPREPLY="-h --help --local"
}

_spack_config_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_config_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_config_update() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all"
    else
        _config_sections
    fi
}

_spack_config_revert() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all"
    else
        _config_sections
    fi
}

_spack_containerize() {
    SPACK_COMPREPLY="-h --help --list-os --last-stage"
}

_spack_containerise() {
    SPACK_COMPREPLY="-h --help --list-os --last-stage"
}

_spack_create() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --keep-stage -n --name -t --template -r --repo -N --namespace -f --force --skip-editor -b --batch"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_debug() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="report"
    fi
}

_spack_debug_report() {
    SPACK_COMPREPLY="-h --help"
}

_spack_deconcretize() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --root -y --yes-to-all -a --all"
    else
        _all_packages
    fi
}

_spack_dependencies() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -i --installed -t --transitive --deptype -V --no-expand-virtuals"
    else
        _all_packages
    fi
}

_spack_dependents() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -i --installed -t --transitive"
    else
        _all_packages
    fi
}

_spack_deprecate() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all -d --dependencies -D --no-dependencies -i --install-deprecator -I --no-install-deprecator -l --link-type"
    else
        _all_packages
    fi
}

_spack_dev_build() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -j --jobs -n --no-checksum -d --source-path -i --ignore-dependencies --keep-prefix --skip-patch -q --quiet --drop-in --test -b --before -u --until --clean --dirty -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_develop() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -p --path -b --build-directory --no-clone --clone -f --force -r --recursive"
    else
        _all_packages
    fi
}

_spack_diff() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --json --first -a --attribute --ignore"
    else
        _all_packages
    fi
}

_spack_docs() {
    SPACK_COMPREPLY="-h --help"
}

_spack_edit() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -b --build-system -c --command -d --docs -t --test -m --module -r --repo -N --namespace"
    else
        _all_packages
    fi
}

_spack_env() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="activate deactivate create remove rm rename mv list ls status st loads view update revert depfile track untrack"
    fi
}

_spack_env_activate() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --sh --csh --fish --bat --pwsh -v --with-view -V --without-view -p --prompt --temp --create --envfile --keep-relative -d --dir"
    else
        _environments
    fi
}

_spack_env_deactivate() {
    SPACK_COMPREPLY="-h --help --sh --csh --fish --bat --pwsh"
}

_spack_env_create() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -d --dir --keep-relative --without-view --with-view --include-concrete"
    else
        _environments
    fi
}

_spack_env_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all -f --force"
    else
        _environments
    fi
}

_spack_env_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all -f --force"
    else
        _environments
    fi
}

_spack_env_rename() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -d --dir -f --force"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_env_mv() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -d --dir -f --force"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_env_list() {
    SPACK_COMPREPLY="-h --help"
}

_spack_env_ls() {
    SPACK_COMPREPLY="-h --help"
}

_spack_env_status() {
    SPACK_COMPREPLY="-h --help"
}

_spack_env_st() {
    SPACK_COMPREPLY="-h --help"
}

_spack_env_loads() {
    SPACK_COMPREPLY="-h --help -n --module-set-name -m --module-type --input-only -p --prefix -x --exclude -r --dependencies"
}

_spack_env_view() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_env_update() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all"
    else
        _environments
    fi
}

_spack_env_revert() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all"
    else
        _environments
    fi
}

_spack_env_depfile() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --make-prefix --make-target-prefix --make-disable-jobserver --use-buildcache -o --output -G --generator"
    else
        _all_packages
    fi
}

_spack_env_track() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -n --name -y --yes-to-all"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_env_untrack() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -f --force -y --yes-to-all"
    else
        _environments
    fi
}

_spack_extensions() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -l --long -L --very-long -d --deps -p --paths -s --show"
    else
        _extensions
    fi
}

_spack_external() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="find list ls read-cray-manifest"
    fi
}

_spack_external_find() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --not-buildable --exclude -p --path --scope --all -t --tag -j --jobs"
    else
        _all_packages
    fi
}

_spack_external_list() {
    SPACK_COMPREPLY="-h --help"
}

_spack_external_ls() {
    SPACK_COMPREPLY="-h --help"
}

_spack_external_read_cray_manifest() {
    SPACK_COMPREPLY="-h --help --file --directory --ignore-default-dir --dry-run --fail-on-error"
}

_spack_fetch() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -n --no-checksum -m --missing -D --dependencies -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_find() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --format -H --hashes --json -I --install-status --specfile-format -d --deps -p --paths --groups --no-groups -l --long -L --very-long -t --tag -N --namespaces -r --only-roots -c --show-concretized -f --show-flags --show-full-compiler -x --explicit -X --implicit -u --unknown -m --missing -v --variants --loaded -M --only-missing --only-deprecated --deprecated --install-tree --start-date --end-date"
    else
        _installed_packages
    fi
}

_spack_gc() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -E --except-any-environment -e --except-environment -b --keep-build-dependencies -y --yes-to-all"
    else
        _installed_packages
    fi
}

_spack_gpg() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="verify trust untrust sign create list init export publish"
    fi
}

_spack_gpg_verify() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _installed_packages
    fi
}

_spack_gpg_trust() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_gpg_untrust() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --signing"
    else
        _keys
    fi
}

_spack_gpg_sign() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --output --key --clearsign"
    else
        _installed_packages
    fi
}

_spack_gpg_create() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --comment --expires --export --export-secret"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_gpg_list() {
    SPACK_COMPREPLY="-h --help --trusted --signing"
}

_spack_gpg_init() {
    SPACK_COMPREPLY="-h --help --from"
}

_spack_gpg_export() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --secret"
    else
        _keys
    fi
}

_spack_gpg_publish() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -d --directory -m --mirror-name --mirror-url --update-index --rebuild-index"
    else
        _keys
    fi
}

_spack_graph() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --ascii -d --dot -s --static -c --color -i --installed --deptype"
    else
        _all_packages
    fi
}

_spack_help() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all --spec"
    else
        _subcommands
    fi
}

_spack_info() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all --detectable --maintainers --namespace --no-dependencies --no-variants --no-versions --phases --tags --tests --virtuals --variants-by-name"
    else
        _all_packages
    fi
}

_spack_install() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --only -u --until -p --concurrent-packages -j --jobs --overwrite --fail-fast --keep-prefix --keep-stage --dont-restage --use-cache --no-cache --cache-only --use-buildcache --include-build-deps --no-check-signature --show-log-on-error --source -n --no-checksum -v --verbose --fake --only-concrete --add --no-add --clean --dirty --test --log-format --log-file --help-cdash --cdash-upload-url --cdash-build --cdash-site --cdash-track --cdash-buildstamp -y --yes-to-all -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_license() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --root"
    else
        SPACK_COMPREPLY="list-files verify"
    fi
}

_spack_license_list_files() {
    SPACK_COMPREPLY="-h --help"
}

_spack_license_verify() {
    SPACK_COMPREPLY="-h --help"
}

_spack_list() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -r --repo -N --namespace -d --search-description --format -v --virtuals -t --tag --count --update"
    else
        _all_packages
    fi
}

_spack_load() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --sh --csh --fish --bat --pwsh --first --list"
    else
        _installed_packages
    fi
}

_spack_location() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -m --module-dir -r --spack-root -i --install-dir -p --package-dir --repo --packages -P -s --stage-dir -S --stages -c --source-dir -b --build-dir -e --env --first"
    else
        _all_packages
    fi
}

_spack_log_parse() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --show -c --context -p --profile -w --width -j --jobs"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_logs() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}

_spack_maintainers() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --maintained --unmaintained -a --all --by-user"
    else
        _all_packages
    fi
}

_spack_make_installer() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -v --spack-version -s --spack-source -g --git-installer-verbosity"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_mark() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all -e --explicit -i --implicit"
    else
        _installed_packages
    fi
}

_spack_mirror() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -n --no-checksum"
    else
        SPACK_COMPREPLY="create destroy add remove rm set-url set list ls"
    fi
}

_spack_mirror_create() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -d --directory -a --all --file --exclude-file --exclude-specs --skip-unstable-versions -D --dependencies -n --versions-per-spec --private -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_mirror_destroy() {
    SPACK_COMPREPLY="-h --help -m --mirror-name --mirror-url"
}

_spack_mirror_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope --type --autopush --unsigned --signed --s3-access-key-id --s3-access-key-id-variable --s3-access-key-secret --s3-access-key-secret-variable --s3-access-token --s3-access-token-variable --s3-profile --s3-endpoint-url --oci-username --oci-username-variable --oci-password --oci-password-variable"
    else
        _mirrors
    fi
}

_spack_mirror_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        _mirrors
    fi
}

_spack_mirror_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        _mirrors
    fi
}

_spack_mirror_set_url() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --push --fetch --scope --s3-access-key-id --s3-access-key-id-variable --s3-access-key-secret --s3-access-key-secret-variable --s3-access-token --s3-access-token-variable --s3-profile --s3-endpoint-url --oci-username --oci-username-variable --oci-password --oci-password-variable"
    else
        _mirrors
    fi
}

_spack_mirror_set() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --push --fetch --type --url --autopush --no-autopush --unsigned --signed --scope --s3-access-key-id --s3-access-key-id-variable --s3-access-key-secret --s3-access-key-secret-variable --s3-access-token --s3-access-token-variable --s3-profile --s3-endpoint-url --oci-username --oci-username-variable --oci-password --oci-password-variable"
    else
        _mirrors
    fi
}

_spack_mirror_list() {
    SPACK_COMPREPLY="-h --help --scope"
}

_spack_mirror_ls() {
    SPACK_COMPREPLY="-h --help --scope"
}

_spack_module() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="lmod tcl"
    fi
}

_spack_module_lmod() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -n --name"
    else
        SPACK_COMPREPLY="refresh find rm loads setdefault"
    fi
}

_spack_module_lmod_refresh() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --delete-tree --upstream-modules -y --yes-to-all"
    else
        _installed_packages
    fi
}

_spack_module_lmod_find() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --full-path -r --dependencies"
    else
        _installed_packages
    fi
}

_spack_module_lmod_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all"
    else
        _installed_packages
    fi
}

_spack_module_lmod_loads() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --input-only -p --prefix -x --exclude -r --dependencies"
    else
        _installed_packages
    fi
}

_spack_module_lmod_setdefault() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _installed_packages
    fi
}

_spack_module_tcl() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -n --name"
    else
        SPACK_COMPREPLY="refresh find rm loads setdefault"
    fi
}

_spack_module_tcl_refresh() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --delete-tree --upstream-modules -y --yes-to-all"
    else
        _installed_packages
    fi
}

_spack_module_tcl_find() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --full-path -r --dependencies"
    else
        _installed_packages
    fi
}

_spack_module_tcl_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all"
    else
        _installed_packages
    fi
}

_spack_module_tcl_loads() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --input-only -p --prefix -x --exclude -r --dependencies"
    else
        _installed_packages
    fi
}

_spack_module_tcl_setdefault() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _installed_packages
    fi
}

_spack_patch() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -n --no-checksum -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_pkg() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="add list diff added changed removed grep source hash"
    fi
}

_spack_pkg_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}

_spack_pkg_list() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_pkg_diff() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_pkg_added() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_pkg_changed() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -t --type"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_pkg_removed() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_pkg_grep() {
    if $list_options
    then
        SPACK_COMPREPLY="--help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_pkg_source() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -c --canonical"
    else
        _all_packages
    fi
}

_spack_pkg_hash() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}

_spack_providers() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _providers
    fi
}

_spack_pydoc() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_python() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -V --version -c -u -i -m --path"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_reindex() {
    SPACK_COMPREPLY="-h --help"
}

_spack_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all -l --list-name -f --force"
    else
        _all_packages
    fi
}

_spack_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all -l --list-name -f --force"
    else
        _all_packages
    fi
}

_spack_repo() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="create list ls add set remove rm migrate update"
    fi
}

_spack_repo_create() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -d --subdirectory"
    else
        _repos
    fi
}

_spack_repo_list() {
    SPACK_COMPREPLY="-h --help --scope --names --namespaces"
}

_spack_repo_ls() {
    SPACK_COMPREPLY="-h --help --scope --names --namespaces"
}

_spack_repo_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --name --path --scope"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_repo_set() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --destination --path --scope"
    else
        _repos
    fi
}

_spack_repo_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        _repos
    fi
}

_spack_repo_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --scope"
    else
        _repos
    fi
}

_spack_repo_migrate() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --dry-run --fix"
    else
        _repos
    fi
}

_spack_repo_update() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --remote -r --scope --branch -b --tag -t --commit -c"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_resource() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="list show"
    fi
}

_spack_resource_list() {
    SPACK_COMPREPLY="-h --help --only-hashes"
}

_spack_resource_show() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_resource_hashes
    fi
}

_spack_restage() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}

_spack_solve() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --show --timers --stats -l --long -L --very-long -N --namespaces -I --install-status --no-install-status -y --yaml -j --json --format -c --cover -t --types -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_spec() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -l --long -L --very-long -N --namespaces -I --install-status --no-install-status -y --yaml -j --json --format -c --cover -t --types -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_stage() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -n --no-checksum -p --path -e --exclude -s --skip-installed -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated"
    else
        _all_packages
    fi
}

_spack_style() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -b --base -a --all -r --root-relative -U --no-untracked -f --fix --root -t --tool -s --skip --spec-strings"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_tags() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -i --installed -a --all"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_test() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="run list find status results remove"
    fi
}

_spack_test_run() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --alias --fail-fast --fail-first --externals -x --explicit --keep-stage --log-format --log-file --cdash-upload-url --cdash-build --cdash-site --cdash-track --cdash-buildstamp --help-cdash --timeout --clean --dirty"
    else
        _installed_packages
    fi
}

_spack_test_list() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_test_find() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}

_spack_test_status() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_test_results() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -l --logs -f --failed"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_test_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -y --yes-to-all"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_test_env() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --clean --dirty -f --force -U --fresh --reuse --fresh-roots --reuse-deps --deprecated --dump --pickle"
    else
        _all_packages
    fi
}

_spack_tutorial() {
    SPACK_COMPREPLY="-h --help -y --yes-to-all"
}

_spack_undevelop() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -a --all"
    else
        _all_packages
    fi
}

_spack_uninstall() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -f --force --remove -R --dependents -y --yes-to-all -a --all --origin"
    else
        _installed_packages
    fi
}

_spack_unit_test() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -H --pytest-help -n --numprocesses -l --list -L --list-long -N --list-names --extension -s -k --showlocals"
    else
        _unit_tests
    fi
}

_spack_unload() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --sh --csh --fish --bat --pwsh -a --all"
    else
        _installed_packages
    fi
}

_spack_url() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="parse list summary stats"
    fi
}

_spack_url_parse() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -s --spider"
    else
        SPACK_COMPREPLY=""
    fi
}

_spack_url_list() {
    SPACK_COMPREPLY="-h --help -c --color -e --extrapolation -n --incorrect-name -N --correct-name -v --incorrect-version -V --correct-version"
}

_spack_url_summary() {
    SPACK_COMPREPLY="-h --help"
}

_spack_url_stats() {
    SPACK_COMPREPLY="-h --help --show-issues"
}

_spack_verify() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        SPACK_COMPREPLY="manifest libraries"
    fi
}

_spack_verify_manifest() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -l --local -j --json -a --all -s --specs -f --files"
    else
        _all_packages
    fi
}

_spack_verify_libraries() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _installed_packages
    fi
}

_spack_versions() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -s --safe -r --remote -n --new -j --jobs"
    else
        _all_packages
    fi
}

_spack_view() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help -v --verbose -e --exclude -d --dependencies"
    else
        SPACK_COMPREPLY="symlink add soft hardlink hard copy relocate remove rm statlink status check"
    fi
}

_spack_view_symlink() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --projection-file -i --ignore-conflicts"
    else
        _all_packages
    fi
}

_spack_view_add() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --projection-file -i --ignore-conflicts"
    else
        _all_packages
    fi
}

_spack_view_soft() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --projection-file -i --ignore-conflicts"
    else
        _all_packages
    fi
}

_spack_view_hardlink() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --projection-file -i --ignore-conflicts"
    else
        _all_packages
    fi
}

_spack_view_hard() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --projection-file -i --ignore-conflicts"
    else
        _all_packages
    fi
}

_spack_view_copy() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --projection-file -i --ignore-conflicts"
    else
        _all_packages
    fi
}

_spack_view_relocate() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --projection-file -i --ignore-conflicts"
    else
        _all_packages
    fi
}

_spack_view_remove() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --no-remove-dependents -a --all"
    else
        _all_packages
    fi
}

_spack_view_rm() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help --no-remove-dependents -a --all"
    else
        _all_packages
    fi
}

_spack_view_statlink() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}

_spack_view_status() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}

_spack_view_check() {
    if $list_options
    then
        SPACK_COMPREPLY="-h --help"
    else
        _all_packages
    fi
}
