import { a as attr, c as attr_class, d as clsx, b as bind_props, h as slot } from "./index.js";
import { Y as fallback, Z as getContext } from "./context.js";
import "dequal";
import "./create.js";
import "clsx";
import { L as Link_preview, b as Link_preview_trigger, U as UserStatusLinkPreview } from "./Collapsible.js";
import "./index2.js";
import "./client.js";
import "dompurify";
function ChevronRight($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function ProfilePreview($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    getContext("i18n");
    let user = fallback($$props["user"], null);
    let align = fallback($$props["align"], "center");
    let side = fallback($$props["side"], "right");
    let sideOffset = fallback($$props["sideOffset"], 8);
    let openPreview = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Link_preview($$renderer3, {
        openDelay: 0,
        closeDelay: 200,
        get open() {
          return openPreview;
        },
        set open($$value) {
          openPreview = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          Link_preview_trigger($$renderer4, {
            class: "flex items-center",
            children: ($$renderer5) => {
              $$renderer5.push(`<button type="button" class="cursor-pointer no-underline! font-normal!"><!--[-->`);
              slot($$renderer5, $$props, "default", {}, null);
              $$renderer5.push(`<!--]--></button>`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          UserStatusLinkPreview($$renderer4, { id: user?.id, side, align, sideOffset });
          $$renderer4.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { user, align, side, sideOffset });
  });
}
export {
  ChevronRight as C,
  ProfilePreview as P
};
//# sourceMappingURL=ProfilePreview.js.map
