import "clsx";
import { s as store_get, u as unsubscribe_stores, b as bind_props, a as attr, j as escape_html } from "../../../../../../chunks/index.js";
import Fuse from "fuse.js";
import { o as onDestroy } from "../../../../../../chunks/client.js";
import { a as toast } from "../../../../../../chunks/Toaster.svelte_svelte_type_style_lang.js";
import { v4 } from "uuid";
import { o as config, g as settings } from "../../../../../../chunks/index2.js";
import { u as uploadFile, b as addFileToKnowledgeById } from "../../../../../../chunks/index13.js";
import "../../../../../../chunks/index4.js";
import { S as Spinner } from "../../../../../../chunks/Spinner.js";
/* empty css                                                           */
import "dequal";
import "../../../../../../chunks/create.js";
import "dompurify";
import "dayjs";
import { Z as getContext, Y as fallback } from "../../../../../../chunks/context.js";
import { M as Modal } from "../../../../../../chunks/Modal.js";
import { R as RichTextInput, M as MicSolid } from "../../../../../../chunks/MicSolid.js";
import { X as XMark } from "../../../../../../chunks/XMark.js";
import { T as Tooltip } from "../../../../../../chunks/Tooltip.js";
import "dayjs/plugin/localizedFormat.js";
import "../../../../../../chunks/listDragHandlePlugin.js";
import { C as ConfirmDialog } from "../../../../../../chunks/ConfirmDialog.js";
import "marked";
import "turndown";
import "@joplin/turndown-plugin-gfm";
import "@tiptap/starter-kit";
import "@tiptap/extension-table";
import "@tiptap/extension-list";
import "@tiptap/extensions";
import "@tiptap/extension-file-handler";
import "@tiptap/extension-typography";
import "@tiptap/extension-highlight";
import "@tiptap/extension-code-block-lowlight";
import "@tiptap/extension-mention";
/* empty css                                                            */
import { F as FilesOverlay } from "../../../../../../chunks/FilesOverlay.js";
function AddTextContentModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let name = store_get($$store_subs ??= {}, "$i18n", i18n).t("Untitled");
    let content = "";
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        size: "full",
        containerClassName: "",
        className: "h-full bg-white dark:bg-gray-900",
        get show() {
          return show;
        },
        set show($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="absolute top-0 right-0 p-5"><button class="self-center dark:text-white" type="button">`);
          XMark($$renderer4, { className: "size-3.5" });
          $$renderer4.push(`<!----></button></div> <div class="flex flex-col md:flex-row w-full h-full md:space-x-4 dark:text-gray-200"><form class="flex flex-col w-full h-full"><div class="flex-1 w-full h-full flex justify-center overflow-auto px-5 py-4"><div class="max-w-3xl py-2 md:py-10 w-full flex flex-col gap-2"><div class="shrink-0 w-full flex justify-between items-center"><div class="w-full"><input class="w-full text-3xl font-semibold bg-transparent outline-hidden svelte-1bctwft" type="text"${attr("value", name)}${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Title"))} required/></div></div> <div class="flex-1 w-full h-full">`);
          RichTextInput($$renderer4, {
            placeholder: store_get($$store_subs ??= {}, "$i18n", i18n).t("Write something..."),
            preserveBreaks: true,
            get value() {
              return content;
            },
            set value($$value) {
              content = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----></div></div></div> <div class="flex flex-row items-center justify-end text-sm font-medium shrink-0 mt-1 p-4 gap-1.5"><div>`);
          {
            $$renderer4.push("<!--[!-->");
            Tooltip($$renderer4, {
              content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Voice Input"),
              children: ($$renderer5) => {
                $$renderer5.push(`<button class="p-2 bg-gray-50 text-gray-700 dark:bg-gray-700 dark:text-white transition rounded-full" type="button">`);
                MicSolid($$renderer5, { className: "size-5" });
                $$renderer5.push(`<!----></button>`);
              },
              $$slots: { default: true }
            });
          }
          $$renderer4.push(`<!--]--></div> <div class="shrink-0">`);
          Tooltip($$renderer4, {
            content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Save"),
            children: ($$renderer5) => {
              $$renderer5.push(`<button class="px-3.5 py-2 bg-black text-white dark:bg-white dark:text-black transition rounded-full" type="submit">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Save"))}</button>`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></div></div></form></div>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show });
  });
}
function KnowledgeBase($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let id = null;
    let knowledge = null;
    let showAddTextContentModal = false;
    let showSyncConfirmModal = false;
    let fuse = null;
    let dragged = false;
    const uploadFileHandler = async (file) => {
      /* @__PURE__ */ console.log(file);
      const tempItemId = v4();
      const fileItem = {
        type: "file",
        file: "",
        id: null,
        url: "",
        name: file.name,
        size: file.size,
        status: "uploading",
        error: "",
        itemId: tempItemId
      };
      if (fileItem.size == 0) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("You cannot upload an empty file."));
        return null;
      }
      if ((store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? null) !== null && file.size > (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024) {
        /* @__PURE__ */ console.log("File exceeds max size limit:", {
          fileSize: file.size,
          maxSize: (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024
        });
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`File size should not exceed {{maxSize}} MB.`, {
          maxSize: store_get($$store_subs ??= {}, "$config", config)?.file?.max_size
        }));
        return;
      }
      knowledge.files = [...knowledge.files ?? [], fileItem];
      try {
        let metadata = null;
        if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language) {
          metadata = {
            language: store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language
          };
        }
        const uploadedFile = await uploadFile(localStorage.token, file, metadata).catch((e) => {
          toast.error(`${e}`);
          return null;
        });
        if (uploadedFile) {
          /* @__PURE__ */ console.log(uploadedFile);
          knowledge.files = knowledge.files.map((item) => {
            if (item.itemId === tempItemId) {
              item.id = uploadedFile.id;
            }
            delete item.itemId;
            return item;
          });
          if (uploadedFile.error) {
            console.warn("File upload warning:", uploadedFile.error);
            toast.warning(uploadedFile.error);
            knowledge.files = knowledge.files.filter((file2) => file2.id !== uploadedFile.id);
          } else {
            await addFileHandler(uploadedFile.id);
          }
        } else {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to upload file."));
        }
      } catch (e) {
        toast.error(`${e}`);
      }
    };
    const addFileHandler = async (fileId) => {
      const updatedKnowledge = await addFileToKnowledgeById(localStorage.token, id, fileId).catch((e) => {
        toast.error(`${e}`);
        return null;
      });
      if (updatedKnowledge) {
        knowledge = updatedKnowledge;
        toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("File added successfully."));
      } else {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to add file."));
        knowledge.files = knowledge.files.filter((file) => file.id !== fileId);
      }
    };
    const onDragOver = (e) => {
      e.preventDefault();
      if (e.dataTransfer?.types?.includes("Files")) {
        dragged = true;
      } else {
        dragged = false;
      }
    };
    const onDragLeave = () => {
      dragged = false;
    };
    const onDrop = async (e) => {
      e.preventDefault();
      dragged = false;
      if (e.dataTransfer?.types?.includes("Files")) {
        if (e.dataTransfer?.files) {
          const inputFiles = e.dataTransfer?.files;
          if (inputFiles && inputFiles.length > 0) {
            for (const file of inputFiles) {
              await uploadFileHandler(file);
            }
          } else {
            toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`File not found.`));
          }
        }
      }
    };
    onDestroy(() => {
      const dropZone = document.querySelector("body");
      dropZone?.removeEventListener("dragover", onDragOver);
      dropZone?.removeEventListener("drop", onDrop);
      dropZone?.removeEventListener("dragleave", onDragLeave);
    });
    if (knowledge && knowledge.files) {
      fuse = new Fuse(knowledge.files, { keys: ["meta.name", "meta.description"] });
    }
    if (fuse) {
      knowledge?.files ?? [];
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      FilesOverlay($$renderer3, { show: dragged });
      $$renderer3.push(`<!----> `);
      ConfirmDialog($$renderer3, {
        message: store_get($$store_subs ??= {}, "$i18n", i18n).t("This will reset the knowledge base and sync all files. Do you wish to continue?"),
        get show() {
          return showSyncConfirmModal;
        },
        set show($$value) {
          showSyncConfirmModal = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      AddTextContentModal($$renderer3, {
        get show() {
          return showAddTextContentModal;
        },
        set show($$value) {
          showAddTextContentModal = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> <input id="files-input" type="file" multiple hidden=""/> <div class="flex flex-col w-full h-full translate-y-1" id="collection-container">`);
      {
        $$renderer3.push("<!--[!-->");
        Spinner($$renderer3, { className: "size-5" });
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer) {
  KnowledgeBase($$renderer);
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
