import { s as store_get, u as unsubscribe_stores, n as head, j as escape_html, c as attr_class, o as stringify, a as attr } from "../../../../chunks/index.js";
import { W as WEBUI_NAME, i as showSidebar, h as mobile, u as user } from "../../../../chunks/index2.js";
import { Z as getContext } from "../../../../chunks/context.js";
import { U as UserMenu } from "../../../../chunks/UserMenu.js";
import { marked } from "marked";
import { o as onDestroy } from "../../../../chunks/client.js";
import { a as toast } from "../../../../chunks/Toaster.svelte_svelte_type_style_lang.js";
import "clsx";
import "file-saver";
import Fuse from "fuse.js";
import dayjs from "dayjs";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import duration from "dayjs/plugin/duration.js";
import relativeTime from "dayjs/plugin/relativeTime.js";
import { c as createNewNote, g as getNotes } from "../../../../chunks/index14.js";
import { p as getTimeRange } from "../../../../chunks/index4.js";
import "dompurify";
/* empty css                                                             */
import { S as Spinner } from "../../../../chunks/Spinner.js";
import "dequal";
import "../../../../chunks/create.js";
import { F as FilesOverlay } from "../../../../chunks/FilesOverlay.js";
import { T as Tooltip } from "../../../../chunks/Tooltip.js";
import { S as Sidebar } from "../../../../chunks/Sidebar.js";
function Notes($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    dayjs.extend(duration);
    dayjs.extend(relativeTime);
    async function loadLocale(locales) {
      for (const locale of locales) {
        try {
          dayjs.locale(locale);
          break;
        } catch (error) {
          /* @__PURE__ */ console.error(`Could not load locale '${locale}':`, error);
        }
      }
    }
    const i18n = getContext("i18n");
    let noteItems = [];
    let fuse = null;
    const groupNotes = (res) => {
      /* @__PURE__ */ console.log(res);
      if (!Array.isArray(res)) {
        return {};
      }
      const grouped = {};
      for (const note of res) {
        const timeRange = getTimeRange(note.updated_at / 1e9);
        if (!grouped[timeRange]) {
          grouped[timeRange] = [];
        }
        grouped[timeRange].push({ ...note, timeRange });
      }
      return grouped;
    };
    const init = async () => {
      noteItems = await getNotes(localStorage.token, true);
      fuse = new Fuse(noteItems, { keys: ["title"] });
    };
    const inputFilesHandler = async (inputFiles) => {
      for (const file of inputFiles) {
        if (file.type !== "text/markdown") {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Only markdown files are allowed"));
          return;
        }
        const reader = new FileReader();
        reader.onload = async (event) => {
          const content = event.target.result;
          let name = file.name.replace(/\.md$/, "");
          if (typeof content !== "string") {
            toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Invalid file content"));
            return;
          }
          const res = await createNewNote(localStorage.token, {
            title: name,
            data: {
              content: { json: null, html: marked.parse(content ?? ""), md: content }
            },
            meta: null,
            access_control: {}
          }).catch((error) => {
            toast.error(`${error}`);
            return null;
          });
          if (res) {
            init();
          }
        };
        reader.readAsText(file);
      }
    };
    let dragged = false;
    const onDragOver = (e) => {
      e.preventDefault();
      if (e.dataTransfer?.types?.includes("Files")) {
        dragged = true;
      } else {
        dragged = false;
      }
    };
    const onDragLeave = () => {
      dragged = false;
    };
    const onDrop = async (e) => {
      e.preventDefault();
      /* @__PURE__ */ console.log(e);
      if (e.dataTransfer?.files) {
        const inputFiles = Array.from(e.dataTransfer?.files);
        if (inputFiles && inputFiles.length > 0) {
          /* @__PURE__ */ console.log(inputFiles);
          inputFilesHandler(inputFiles);
        }
      }
      dragged = false;
    };
    onDestroy(() => {
      /* @__PURE__ */ console.log("destroy");
      const dropzoneElement = document.getElementById("notes-container");
      if (dropzoneElement) {
        dropzoneElement?.removeEventListener("dragover", onDragOver);
        dropzoneElement?.removeEventListener("drop", onDrop);
        dropzoneElement?.removeEventListener("dragleave", onDragLeave);
      }
    });
    loadLocale(store_get($$store_subs ??= {}, "$i18n", i18n).languages);
    if (fuse) {
      groupNotes(noteItems);
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>
		${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Notes"))} • ${escape_html(store_get($$store_subs ??= {}, "$WEBUI_NAME", WEBUI_NAME))}
	</title>`);
        });
      });
      FilesOverlay($$renderer3, { show: dragged });
      $$renderer3.push(`<!----> <div id="notes-container" class="w-full min-h-full h-full">`);
      {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="w-full h-full flex justify-center items-center">`);
        Spinner($$renderer3, { className: "size-5" });
        $$renderer3.push(`<!----></div>`);
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    $$renderer2.push(`<div${attr_class(` flex flex-col w-full h-screen max-h-[100dvh] transition-width duration-200 ease-in-out ${stringify(store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? "md:max-w-[calc(100%-260px)]" : "")} max-w-full`)}><nav class="px-2 pt-1.5 backdrop-blur-xl w-full drag-region"><div class="flex items-center">`);
    if (store_get($$store_subs ??= {}, "$mobile", mobile)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class(`${stringify(store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? "md:hidden" : "")} flex flex-none items-center`)}>`);
      Tooltip($$renderer2, {
        content: store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Close Sidebar") : store_get($$store_subs ??= {}, "$i18n", i18n).t("Open Sidebar"),
        interactive: true,
        children: ($$renderer3) => {
          $$renderer3.push(`<button id="sidebar-toggle-button" class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition cursor-"><div class="self-center p-1.5">`);
          Sidebar($$renderer3, {});
          $$renderer3.push(`<!----></div></button>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="ml-2 py-0.5 self-center flex items-center justify-between w-full"><div><div class="flex gap-1 scrollbar-none overflow-x-auto w-fit text-center text-sm font-medium bg-transparent py-1 touch-auto pointer-events-auto"><a class="min-w-fit transition" href="/notes">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Notes"))}</a></div></div> <div class="self-center flex items-center gap-1">`);
    if (store_get($$store_subs ??= {}, "$user", user) !== void 0 && store_get($$store_subs ??= {}, "$user", user) !== null) {
      $$renderer2.push("<!--[-->");
      UserMenu($$renderer2, {
        className: "max-w-[240px]",
        role: store_get($$store_subs ??= {}, "$user", user)?.role,
        help: true,
        children: ($$renderer3) => {
          $$renderer3.push(`<button class="select-none flex rounded-xl p-1.5 w-full hover:bg-gray-50 dark:hover:bg-gray-850 transition" aria-label="User Menu"><div class="self-center"><img${attr("src", store_get($$store_subs ??= {}, "$user", user)?.profile_image_url)} class="size-6 object-cover rounded-full" alt="User profile" draggable="false"/></div></button>`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div></div></div></nav> <div class="pb-1 flex-1 max-h-full overflow-y-auto @container">`);
    Notes($$renderer2);
    $$renderer2.push(`<!----></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
