import { a as attr, c as attr_class, d as clsx, b as bind_props, e as ensure_array_like, f as attr_style, o as stringify, j as escape_html, s as store_get, u as unsubscribe_stores, h as slot, n as head } from "../../../../../chunks/index.js";
import { p as page } from "../../../../../chunks/stores.js";
import { o as config, g as settings, m as models, a as WEBUI_BASE_URL, k as socket, W as WEBUI_NAME, h as mobile, i as showSidebar, u as user, z as WEBUI_API_BASE_URL } from "../../../../../chunks/index2.js";
import { o as onDestroy, t as tick, g as goto } from "../../../../../chunks/client.js";
import { v4 } from "uuid";
import fileSaver from "file-saver";
import { marked } from "marked";
import { a as toast } from "../../../../../chunks/Toaster.svelte_svelte_type_style_lang.js";
import { Y as fallback, Z as getContext } from "../../../../../chunks/context.js";
import dayjs from "dayjs";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import calendar from "dayjs/plugin/calendar.js";
import duration from "dayjs/plugin/duration.js";
import relativeTime from "dayjs/plugin/relativeTime.js";
import { D as Drawer, P as Pane, a as Pane_group } from "../../../../../chunks/Drawer.js";
import { o as blobToFile, y as splitStream, a as copyToClipboard, l as convertHeicToJpeg, n as compressImage } from "../../../../../chunks/index4.js";
import { u as uploadFile } from "../../../../../chunks/index13.js";
import { c as chatCompletion } from "../../../../../chunks/index11.js";
import { X as XMark } from "../../../../../chunks/XMark.js";
import "clsx";
import { I as Image, M as Markdown } from "../../../../../chunks/Collapsible.js";
import "panzoom";
import "dompurify";
import "dequal";
import "../../../../../chunks/create.js";
import { a as FileItem, S as Skeleton } from "../../../../../chunks/FileItem.js";
import { P as Pencil } from "../../../../../chunks/Pencil.js";
import { T as Textarea } from "../../../../../chunks/Textarea.js";
import { T as Tooltip } from "../../../../../chunks/Tooltip.js";
import { M as MessageInput } from "../../../../../chunks/MessageInput.js";
import { D as DocumentDuplicate, P as PencilSquare } from "../../../../../chunks/PencilSquare.js";
import { t as transcribeAudio, P as Pane_resizer } from "../../../../../chunks/pane-resizer.js";
import { A as AccessControlModal } from "../../../../../chunks/AccessControlModal.js";
import { a as getNoteById, u as updateNoteById } from "../../../../../chunks/index14.js";
import { R as RichTextInput, M as MicSolid } from "../../../../../chunks/MicSolid.js";
import { S as Spinner } from "../../../../../chunks/Spinner.js";
import localizedFormat from "dayjs/plugin/localizedFormat.js";
import "../../../../../chunks/listDragHandlePlugin.js";
import { C as ConfirmDialog } from "../../../../../chunks/ConfirmDialog.js";
/* empty css                                                        */
import { F as FilesOverlay } from "../../../../../chunks/FilesOverlay.js";
import { b as Menu, c as Menu_trigger, M as Menu_content, a as Menu_item } from "../../../../../chunks/menu-trigger.js";
import { f as fade } from "../../../../../chunks/index15.js";
import { M as Menu_sub, a as Menu_sub_trigger, b as Menu_sub_content, S as Share } from "../../../../../chunks/Share.js";
import { f as flyAndScale } from "../../../../../chunks/index5.js";
import { D as Download } from "../../../../../chunks/Download.js";
import { G as GarbageBin } from "../../../../../chunks/GarbageBin.js";
import { L as Link } from "../../../../../chunks/Link.js";
import { E as EllipsisHorizontal } from "../../../../../chunks/EllipsisHorizontal.js";
import { S as Sidebar } from "../../../../../chunks/Sidebar.js";
import { S as Sparkles } from "../../../../../chunks/Sparkles.js";
function ChatBubbleOval($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor" aria-hidden="true"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M12 20.25c4.97 0 9-3.694 9-8.25s-4.03-8.25-9-8.25S3 7.444 3 12c0 2.104.859 4.023 2.273 5.48.432.447.74 1.04.586 1.641a4.483 4.483 0 0 1-.923 1.785A5.969 5.969 0 0 0 6 21c1.282 0 2.47-.402 3.445-1.087.81.22 1.668.337 2.555.337Z"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function VoiceRecording($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    dayjs.extend(localizedFormat);
    const i18n = getContext("i18n");
    let recording = fallback($$props["recording"], false);
    let transcribe = fallback($$props["transcribe"], true);
    let displayMedia = fallback($$props["displayMedia"], false);
    let echoCancellation = fallback($$props["echoCancellation"], true);
    let noiseSuppression = fallback($$props["noiseSuppression"], true);
    let autoGainControl = fallback($$props["autoGainControl"], true);
    let className = fallback($$props["className"], " p-2.5 w-full max-w-full");
    let onCancel = fallback($$props["onCancel"], () => {
    });
    let onConfirm = fallback($$props["onConfirm"], (data) => {
    });
    let loading = false;
    let confirmed = false;
    let durationSeconds = 0;
    let durationCounter = null;
    let transcription = "";
    const startDurationCounter = () => {
      durationCounter = setInterval(
        () => {
          durationSeconds++;
        },
        1e3
      );
    };
    const stopDurationCounter = () => {
      clearInterval(durationCounter);
      durationSeconds = 0;
    };
    const formatSeconds = (seconds) => {
      const minutes = Math.floor(seconds / 60);
      const remainingSeconds = seconds % 60;
      const formattedSeconds = remainingSeconds < 10 ? `0${remainingSeconds}` : remainingSeconds;
      return `${minutes}:${formattedSeconds}`;
    };
    let stream;
    let speechRecognition;
    let mediaRecorder;
    let audioChunks = [];
    const MIN_DECIBELS = -45;
    let VISUALIZER_BUFFER_LENGTH = 300;
    let visualizerData = Array(VISUALIZER_BUFFER_LENGTH).fill(0);
    const calculateRMS = (data) => {
      let sumSquares = 0;
      for (let i = 0; i < data.length; i++) {
        const normalizedValue = (data[i] - 128) / 128;
        sumSquares += normalizedValue * normalizedValue;
      }
      return Math.sqrt(sumSquares / data.length);
    };
    const normalizeRMS = (rms) => {
      rms = rms * 10;
      const exp = 1.5;
      const scaledRMS = Math.pow(rms, exp);
      return Math.min(1, Math.max(0.01, scaledRMS));
    };
    const analyseAudio = (stream2) => {
      const audioContext = new AudioContext();
      const audioStreamSource = audioContext.createMediaStreamSource(stream2);
      const analyser = audioContext.createAnalyser();
      analyser.minDecibels = MIN_DECIBELS;
      audioStreamSource.connect(analyser);
      const bufferLength = analyser.frequencyBinCount;
      const domainData = new Uint8Array(bufferLength);
      const timeDomainData = new Uint8Array(analyser.fftSize);
      const detectSound = () => {
        const processFrame = () => {
          if (!recording || loading) return;
          if (recording && !loading) {
            analyser.getByteTimeDomainData(timeDomainData);
            analyser.getByteFrequencyData(domainData);
            const rmsLevel = calculateRMS(timeDomainData);
            visualizerData.push(normalizeRMS(rmsLevel));
            if (visualizerData.length >= VISUALIZER_BUFFER_LENGTH) {
              visualizerData.shift();
            }
            visualizerData = visualizerData;
          }
          window.requestAnimationFrame(processFrame);
        };
        window.requestAnimationFrame(processFrame);
      };
      detectSound();
    };
    const onStopHandler = async (audioBlob, ext = "wav") => {
      await tick();
      const file = blobToFile(audioBlob, `Recording-${dayjs().format("L LT")}.${ext}`);
      if (transcribe) {
        if (store_get($$store_subs ??= {}, "$config", config).audio.stt.engine === "web" || (store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.engine ?? "") === "web") {
          return;
        }
        const res = await transcribeAudio(localStorage.token, file, store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
        if (res) {
          /* @__PURE__ */ console.log(res);
          onConfirm(res);
        }
      } else {
        onConfirm({ file, blob: audioBlob });
      }
    };
    const startRecording = async () => {
      loading = true;
      try {
        if (displayMedia) {
          const mediaStream = await navigator.mediaDevices.getDisplayMedia({ audio: true });
          stream = new MediaStream();
          for (const track of mediaStream.getAudioTracks()) {
            stream.addTrack(track);
          }
          for (const track of mediaStream.getVideoTracks()) {
            track.stop();
          }
        } else {
          stream = await navigator.mediaDevices.getUserMedia({
            audio: { echoCancellation, noiseSuppression, autoGainControl }
          });
        }
      } catch (err) {
        /* @__PURE__ */ console.error("Error accessing media devices.", err);
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Error accessing media devices."));
        loading = false;
        recording = false;
        return;
      }
      const mineTypes = ["audio/webm; codecs=opus", "audio/mp4"];
      mediaRecorder = new MediaRecorder(stream, {
        mimeType: mineTypes.find((type) => MediaRecorder.isTypeSupported(type))
      });
      mediaRecorder.onstart = () => {
        /* @__PURE__ */ console.log("Recording started");
        loading = false;
        startDurationCounter();
        audioChunks = [];
        analyseAudio(stream);
      };
      mediaRecorder.ondataavailable = (event) => audioChunks.push(event.data);
      mediaRecorder.onstop = async () => {
        /* @__PURE__ */ console.log("Recording stopped");
        if (confirmed) {
          let type = audioChunks[0]?.type || mediaRecorder.mimeType || "audio/webm";
          let ext = type.split("/")[1].split(";")[0] || "webm";
          if (!type.startsWith("audio/")) {
            ext = "webm";
          }
          const audioBlob = new Blob(audioChunks, { type });
          await onStopHandler(audioBlob, ext);
          confirmed = false;
          loading = false;
        }
        audioChunks = [];
        recording = false;
      };
      try {
        mediaRecorder.start();
      } catch (error) {
        /* @__PURE__ */ console.error("Error starting recording:", error);
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Error starting recording."));
        loading = false;
        recording = false;
        return;
      }
      if (transcribe) {
        if (store_get($$store_subs ??= {}, "$config", config).audio.stt.engine === "web" || (store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.engine ?? "") === "web") {
          if ("SpeechRecognition" in window || "webkitSpeechRecognition" in window) {
            speechRecognition = new (window.SpeechRecognition || window.webkitSpeechRecognition)();
            speechRecognition.continuous = true;
            const inactivityTimeout = 2e3;
            let timeoutId;
            speechRecognition.start();
            speechRecognition.onresult = async (event) => {
              clearTimeout(timeoutId);
              /* @__PURE__ */ console.log(event);
              const transcript = event.results[Object.keys(event.results).length - 1][0].transcript;
              transcription = `${transcription}${transcript}`;
              await tick();
              document.getElementById("chat-input")?.focus();
              timeoutId = setTimeout(
                () => {
                  /* @__PURE__ */ console.log("Speech recognition turned off due to inactivity.");
                  speechRecognition.stop();
                },
                inactivityTimeout
              );
            };
            speechRecognition.onend = function() {
              /* @__PURE__ */ console.log("recognition ended");
              confirmRecording();
              onConfirm({ text: transcription });
              confirmed = false;
              loading = false;
            };
            speechRecognition.onerror = function(event) {
              /* @__PURE__ */ console.log(event);
              toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`Speech recognition error: {{error}}`, { error: event.error }));
              onCancel();
              stopRecording();
            };
          }
        }
      }
    };
    const stopRecording = async () => {
      if (recording && mediaRecorder) {
        await mediaRecorder.stop();
      }
      if (speechRecognition) {
        speechRecognition.stop();
      }
      stopDurationCounter();
      audioChunks = [];
      visualizerData = Array(VISUALIZER_BUFFER_LENGTH).fill(0);
      if (stream) {
        const tracks = stream.getTracks();
        tracks.forEach((track) => track.stop());
      }
      stream = null;
    };
    const confirmRecording = async () => {
      loading = true;
      confirmed = true;
      if (recording && mediaRecorder) {
        await mediaRecorder.stop();
      }
      clearInterval(durationCounter);
      if (stream) {
        const tracks = stream.getTracks();
        tracks.forEach((track) => track.stop());
      }
      stream = null;
    };
    let resizeObserver;
    onDestroy(() => {
      resizeObserver.disconnect();
    });
    if (recording) {
      startRecording();
    } else {
      stopRecording();
    }
    $$renderer2.push(`<div${attr_class(
      `${stringify(
        // 2px width + 0.5px gap
        // listen to width changes
        // remove resize observer
        loading ? " bg-gray-100/50 dark:bg-gray-850/50" : "bg-indigo-300/10 dark:bg-indigo-500/10 "
      )} rounded-full flex justify-between ${stringify(className)}`,
      "svelte-nkn4fu"
    )}><div class="flex items-center mr-1"><button type="button"${attr_class(`p-1.5 ${stringify(loading ? " bg-gray-200 dark:bg-gray-700/50" : "bg-indigo-400/20 text-indigo-600 dark:text-indigo-300 ")} rounded-full`)}>`);
    XMark($$renderer2, { className: "size-4" });
    $$renderer2.push(`<!----></button></div> <div class="flex flex-1 self-center items-center justify-between ml-2 mx-1 overflow-hidden h-6" dir="rtl"><div class="flex items-center gap-0.5 h-6 w-full max-w-full overflow-hidden overflow-x-hidden flex-wrap"><!--[-->`);
    const each_array = ensure_array_like(visualizerData.slice().reverse());
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let rms = each_array[$$index];
      $$renderer2.push(`<div class="flex items-center h-full"><div${attr_class(`w-[2px] shrink-0 ${stringify(loading ? " bg-gray-500 dark:bg-gray-400   " : "bg-indigo-500 dark:bg-indigo-400  ")} inline-block h-full`)}${attr_style(`height: ${stringify(Math.min(100, Math.max(14, rms * 100)))}%;`)}></div></div>`);
    }
    $$renderer2.push(`<!--]--></div></div> <div class="flex"><div class="mx-1.5 pr-1 flex justify-center items-center"><div${attr_class(`text-sm ${stringify(loading ? " text-gray-500  dark:text-gray-400  " : " text-indigo-400 ")} font-medium flex-1 mx-auto text-center`)}>${escape_html(formatSeconds(durationSeconds))}</div></div> <div class="flex items-center">`);
    if (loading) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="text-gray-500 rounded-full cursor-not-allowed"><svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="currentColor"><style>
							.spinner_OSmW {
								transform-origin: center;
								animation: spinner_T6mA 0.75s step-end infinite;
							}
							@keyframes spinner_T6mA {
								8.3% {
									transform: rotate(30deg);
								}
								16.6% {
									transform: rotate(60deg);
								}
								25% {
									transform: rotate(90deg);
								}
								33.3% {
									transform: rotate(120deg);
								}
								41.6% {
									transform: rotate(150deg);
								}
								50% {
									transform: rotate(180deg);
								}
								58.3% {
									transform: rotate(210deg);
								}
								66.6% {
									transform: rotate(240deg);
								}
								75% {
									transform: rotate(270deg);
								}
								83.3% {
									transform: rotate(300deg);
								}
								91.6% {
									transform: rotate(330deg);
								}
								100% {
									transform: rotate(360deg);
								}
							}
						</style><g class="spinner_OSmW"><rect x="11" y="1" width="2" height="5" opacity=".14"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(30 12 12)" opacity=".29"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(60 12 12)" opacity=".43"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(90 12 12)" opacity=".57"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(120 12 12)" opacity=".71"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(150 12 12)" opacity=".86"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(180 12 12)"></rect></g></svg></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<button type="button" class="p-1.5 bg-indigo-500 text-white dark:bg-indigo-500 dark:text-blue-950 rounded-full"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor" class="size-4"><path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5"></path></svg></button>`);
    }
    $$renderer2.push(`<!--]--></div></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      recording,
      transcribe,
      displayMedia,
      echoCancellation,
      noiseSuppression,
      autoGainControl,
      className,
      onCancel,
      onConfirm
    });
  });
}
function CloudArrowUp($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M12 16.5V9.75m0 0 3 3m-3-3-3 3M6.75 19.5a4.5 4.5 0 0 1-1.41-8.775 5.25 5.25 0 0 1 10.233-2.33 3 3 0 0 1 3.758 3.848A3.752 3.752 0 0 1 18 19.5H6.75Z"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
const downloadPdf = async (note) => {
  const [{ default: jsPDF }, { default: html2canvas }] = await Promise.all([
    import("jspdf"),
    import("html2canvas-pro")
  ]);
  const virtualWidth = 1024;
  const virtualHeight = 1400;
  const html = note.data?.content?.html ?? "";
  const isDarkMode = document.documentElement.classList.contains("dark");
  let node;
  if (html instanceof HTMLElement) {
    node = html;
  } else {
    const virtualWidth2 = 800;
    node = document.createElement("div");
    const titleNode = document.createElement("div");
    titleNode.textContent = note.title;
    titleNode.style.fontSize = "24px";
    titleNode.style.fontWeight = "medium";
    titleNode.style.paddingBottom = "20px";
    titleNode.style.color = isDarkMode ? "white" : "black";
    node.appendChild(titleNode);
    const contentNode = document.createElement("div");
    contentNode.innerHTML = html;
    node.appendChild(contentNode);
    node.classList.add("text-black");
    node.classList.add("dark:text-white");
    node.style.width = `${virtualWidth2}px`;
    node.style.position = "absolute";
    node.style.left = "-9999px";
    node.style.height = "auto";
    node.style.padding = "40px 40px";
    document.body.appendChild(node);
  }
  const canvas = await html2canvas(node, {
    useCORS: true,
    backgroundColor: isDarkMode ? "#000" : "#fff",
    scale: 2,
    // Keep at 1x to avoid unexpected enlargements
    width: virtualWidth,
    // Set fixed virtual screen width
    windowWidth: virtualWidth,
    // Ensure consistent rendering
    windowHeight: virtualHeight
  });
  if (!(html instanceof HTMLElement)) {
    document.body.removeChild(node);
  }
  const imgData = canvas.toDataURL("image/jpeg", 0.7);
  const pdf = new jsPDF("p", "mm", "a4");
  const imgWidth = 210;
  const pageWidthMM = 210;
  const pageHeight = 297;
  const pageHeightMM = 297;
  if (isDarkMode) {
    pdf.setFillColor(0, 0, 0);
    pdf.rect(0, 0, pageWidthMM, pageHeightMM, "F");
  }
  const imgHeight = canvas.height * imgWidth / canvas.width;
  let heightLeft = imgHeight;
  let position = 0;
  pdf.addImage(imgData, "JPEG", 0, position, imgWidth, imgHeight);
  heightLeft -= pageHeight;
  while (heightLeft > 0) {
    position -= pageHeight;
    pdf.addPage();
    if (isDarkMode) {
      pdf.setFillColor(0, 0, 0);
      pdf.rect(0, 0, pageWidthMM, pageHeightMM, "F");
    }
    pdf.addImage(imgData, "JPEG", 0, position, imgWidth, imgHeight);
    heightLeft -= pageHeight;
  }
  pdf.save(`${note.title}.pdf`);
};
function NoteMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let className = fallback($$props["className"], "max-w-[180px]");
    let onDownload = fallback($$props["onDownload"], (type) => {
    });
    let onDelete = fallback($$props["onDelete"], () => {
    });
    let onCopyLink = fallback($$props["onCopyLink"], null);
    let onCopyToClipboard = fallback($$props["onCopyToClipboard"], null);
    let onChange = fallback($$props["onChange"], () => {
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Menu($$renderer3, {
        onOpenChange: (state) => {
          onChange(state);
        },
        get open() {
          return show;
        },
        set open($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          Menu_trigger($$renderer4, {
            children: ($$renderer5) => {
              $$renderer5.push(`<!--[-->`);
              slot($$renderer5, $$props, "default", {}, null);
              $$renderer5.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> <!--[-->`);
          slot($$renderer4, $$props, "content", {}, () => {
            Menu_content($$renderer4, {
              class: `w-full ${stringify(className)} text-sm rounded-2xl px-1 py-1 border border-gray-100  dark:border-gray-800  z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg`,
              sideOffset: 6,
              side: "bottom",
              align: "end",
              transition: (e) => fade(e, { duration: 100 }),
              children: ($$renderer5) => {
                Menu_sub($$renderer5, {
                  children: ($$renderer6) => {
                    Menu_sub_trigger($$renderer6, {
                      class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                      children: ($$renderer7) => {
                        Download($$renderer7, { strokeWidth: "2" });
                        $$renderer7.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Download"))}</div>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Menu_sub_content($$renderer6, {
                      class: "w-full rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg",
                      transition: flyAndScale,
                      sideOffset: 8,
                      align: "end",
                      children: ($$renderer7) => {
                        Menu_item($$renderer7, {
                          class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                          children: ($$renderer8) => {
                            $$renderer8.push(`<div class="flex items-center line-clamp-1">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Plain text (.txt)"))}</div>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Menu_item($$renderer7, {
                          class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                          children: ($$renderer8) => {
                            $$renderer8.push(`<div class="flex items-center line-clamp-1">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Plain text (.md)"))}</div>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Menu_item($$renderer7, {
                          class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                          children: ($$renderer8) => {
                            $$renderer8.push(`<div class="flex items-center line-clamp-1">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("PDF document (.pdf)"))}</div>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                if (onCopyLink || onCopyToClipboard) {
                  $$renderer5.push("<!--[-->");
                  Menu_sub($$renderer5, {
                    children: ($$renderer6) => {
                      Menu_sub_trigger($$renderer6, {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                        children: ($$renderer7) => {
                          Share($$renderer7, { strokeWidth: "2" });
                          $$renderer7.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Share"))}</div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Menu_sub_content($$renderer6, {
                        class: "w-full rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg",
                        transition: flyAndScale,
                        sideOffset: 8,
                        align: "end",
                        children: ($$renderer7) => {
                          if (onCopyLink) {
                            $$renderer7.push("<!--[-->");
                            Menu_item($$renderer7, {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                              children: ($$renderer8) => {
                                Link($$renderer8, {});
                                $$renderer8.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Copy link"))}</div>`);
                              },
                              $$slots: { default: true }
                            });
                          } else {
                            $$renderer7.push("<!--[!-->");
                          }
                          $$renderer7.push(`<!--]--> `);
                          if (onCopyToClipboard) {
                            $$renderer7.push("<!--[-->");
                            Menu_item($$renderer7, {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                              children: ($$renderer8) => {
                                DocumentDuplicate($$renderer8, { strokeWidth: "2" });
                                $$renderer8.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Copy to clipboard"))}</div>`);
                              },
                              $$slots: { default: true }
                            });
                          } else {
                            $$renderer7.push("<!--[!-->");
                          }
                          $$renderer7.push(`<!--]-->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!---->`);
                    },
                    $$slots: { default: true }
                  });
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> `);
                Menu_item($$renderer5, {
                  class: "flex  gap-2  items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                  children: ($$renderer6) => {
                    GarbageBin($$renderer6, {});
                    $$renderer6.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Delete"))}</div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          });
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      show,
      className,
      onDownload,
      onDelete,
      onCopyLink,
      onCopyToClipboard,
      onChange
    });
  });
}
function Controls($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let selectedModelId = fallback($$props["selectedModelId"], "");
    let files = fallback($$props["files"], () => [], true);
    let onUpdate = fallback($$props["onUpdate"], (files2) => {
    });
    $$renderer2.push(`<div class="flex items-center mb-1.5 pt-1.5"><div class="mr-1 flex items-center"><button class="p-0.5 bg-transparent transition rounded-lg">`);
    XMark($$renderer2, { className: "size-5", strokeWidth: "2.5" });
    $$renderer2.push(`<!----></button></div> <div class="font-medium text-base flex items-center gap-1"><div>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Controls"))}</div></div></div> <div class="mt-1 px-1.5"><div class="pb-10">`);
    if (files.length > 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="text-xs font-medium mb-2">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Files"))}</div> <div class="flex flex-col gap-1"><!--[-->`);
      const each_array = ensure_array_like(files.filter((file) => file.type !== "image"));
      for (let fileIdx = 0, $$length = each_array.length; fileIdx < $$length; fileIdx++) {
        let file = each_array[fileIdx];
        FileItem($$renderer2, {
          className: "w-full",
          item: file,
          small: true,
          edit: true,
          dismissible: true,
          url: file.url,
          name: file.name,
          type: file.type,
          size: file?.size,
          loading: file.status === "uploading"
        });
      }
      $$renderer2.push(`<!--]--> <div class="flex items-center flex-wrap gap-2 mt-1.5"><!--[-->`);
      const each_array_1 = ensure_array_like(files.filter((file) => file.type === "image"));
      for (let fileIdx = 0, $$length = each_array_1.length; fileIdx < $$length; fileIdx++) {
        let file = each_array_1[fileIdx];
        Image($$renderer2, {
          src: file.url,
          imageClassName: " size-14 rounded-xl object-cover",
          dismissible: true,
          onDismiss: () => {
            files = files.filter((item) => item.id !== file.id);
            files = files;
            onUpdate(files);
          }
        });
      }
      $$renderer2.push(`<!--]--></div></div> <hr class="my-2 border-gray-50 dark:border-gray-700/10"/>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="text-xs font-medium mb-1">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Model"))}</div> <div class="w-full">`);
    $$renderer2.select(
      {
        class: "w-full bg-transparent text-sm outline-hidden",
        value: selectedModelId
      },
      ($$renderer3) => {
        $$renderer3.option(
          {
            value: "",
            class: "bg-gray-50 dark:bg-gray-700",
            disabled: true
          },
          ($$renderer4) => {
            $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Select a model"))}`);
          }
        );
        $$renderer3.push(`<!--[-->`);
        const each_array_2 = ensure_array_like(store_get($$store_subs ??= {}, "$models", models).filter((model) => !(model?.info?.meta?.hidden ?? false)));
        for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
          let model = each_array_2[$$index_2];
          $$renderer3.option({ value: model.id, class: "bg-gray-50 dark:bg-gray-700" }, ($$renderer4) => {
            $$renderer4.push(`${escape_html(model.name)}`);
          });
        }
        $$renderer3.push(`<!--]-->`);
      }
    );
    $$renderer2.push(`</div></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, selectedModelId, files, onUpdate });
  });
}
function ArrowUpLeft($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="m19.5 19.5-15-15m0 0v11.25m0-11.25h11.25"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function Message($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let message = $$props["message"];
    let idx = $$props["idx"];
    let onDelete = $$props["onDelete"];
    let onEdit = $$props["onEdit"];
    let onInsert = $$props["onInsert"];
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="flex flex-col gap-1 group"><div class="flex items-center justify-between pt-1"><div class="py-1 text-sm font-semibold uppercase min-w-[6rem] text-left rounded-lg transition">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t(message.role))}</div> <div class="flex items-center gap-2">`);
      Tooltip($$renderer3, {
        placement: "top",
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Insert"),
        children: ($$renderer4) => {
          $$renderer4.push(`<button class="text-transparent group-hover:text-gray-500 dark:hover:text-gray-300 transition">`);
          ArrowUpLeft($$renderer4, { className: "size-3.5", strokeWidth: "2" });
          $$renderer4.push(`<!----></button>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Tooltip($$renderer3, {
        placement: "top",
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Edit"),
        children: ($$renderer4) => {
          $$renderer4.push(`<button class="text-transparent group-hover:text-gray-500 dark:hover:text-gray-300 transition">`);
          Pencil($$renderer4, { className: "size-3.5", strokeWidth: "2" });
          $$renderer4.push(`<!----></button>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Tooltip($$renderer3, {
        placement: "top",
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Delete"),
        children: ($$renderer4) => {
          $$renderer4.push(`<button class="text-transparent group-hover:text-gray-500 dark:hover:text-gray-300 transition"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="size-4"><path stroke-linecap="round" stroke-linejoin="round" d="M15 12H9m12 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path></svg></button>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div></div> <div class="flex-1">`);
      if (!(message?.done ?? true) && message?.content === "") {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div>`);
        Skeleton($$renderer3, { size: "sm" });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
        if (message?.edit === true) {
          $$renderer3.push("<!--[-->");
          Textarea($$renderer3, {
            className: "w-full bg-transparent outline-hidden text-sm resize-none overflow-hidden",
            placeholder: store_get($$store_subs ??= {}, "$i18n", i18n).t(`Enter {{role}} message here`, {
              role: message.role === "user" ? store_get($$store_subs ??= {}, "$i18n", i18n).t("a user") : store_get($$store_subs ??= {}, "$i18n", i18n).t("an assistant")
            }),
            onBlur: () => {
              message.edit = false;
            },
            get value() {
              return message.content;
            },
            set value($$value) {
              message.content = $$value;
              $$settled = false;
            }
          });
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<div class="markdown-prose-sm text-sm">`);
          Markdown($$renderer3, { id: `note-message-${idx}`, content: message.content });
          $$renderer3.push(`<!----></div>`);
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]--></div></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { message, idx, onDelete, onEdit, onInsert });
  });
}
function Messages($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    getContext("i18n");
    let messages = fallback($$props["messages"], () => [], true);
    let onInsert = fallback($$props["onInsert"], (content) => {
    });
    $$renderer2.push(`<div class="space-y-3 pb-12"><!--[-->`);
    const each_array = ensure_array_like(messages);
    for (let idx = 0, $$length = each_array.length; idx < $$length; idx++) {
      let message = each_array[idx];
      Message($$renderer2, {
        message,
        idx,
        onInsert: () => {
          onInsert(message?.content ?? "");
        },
        onEdit: () => {
          messages = messages.map((msg, messageIdx) => {
            if (messageIdx === idx) {
              return { ...msg, edit: true };
            }
            return msg;
          });
        },
        onDelete: () => {
          messages = messages.filter((message2, messageIdx) => messageIdx !== idx);
        }
      });
    }
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { messages, onInsert });
  });
}
function Chat($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let show = fallback($$props["show"], false);
    let selectedModelId = fallback($$props["selectedModelId"], "");
    marked.use({
      breaks: true,
      gfm: true,
      renderer: {
        list(body, ordered, start) {
          const isTaskList = body.includes("data-checked=");
          if (isTaskList) {
            return `<ul data-type="taskList">${body}</ul>`;
          }
          const type = ordered ? "ol" : "ul";
          const startatt = ordered && start !== 1 ? ` start="${start}"` : "";
          return `<${type}${startatt}>${body}</${type}>`;
        },
        listitem(text, task, checked) {
          if (task) {
            const checkedAttr = checked ? "true" : "false";
            return `<li data-type="taskItem" data-checked="${checkedAttr}">${text}</li>`;
          }
          return `<li>${text}</li>`;
        }
      }
    });
    const i18n = getContext("i18n");
    let editor = fallback($$props["editor"], null);
    let editing = fallback($$props["editing"], false);
    let streaming = fallback($$props["streaming"], false);
    let stopResponseFlag = fallback($$props["stopResponseFlag"], false);
    let note = fallback($$props["note"], null);
    let selectedContent = fallback($$props["selectedContent"], null);
    let files = fallback($$props["files"], () => [], true);
    let messages = fallback($$props["messages"], () => [], true);
    let onInsert = fallback($$props["onInsert"], (content) => {
    });
    let onStop = fallback($$props["onStop"], () => {
    });
    let onEdited = fallback($$props["onEdited"], () => {
    });
    let insertNoteHandler = fallback($$props["insertNoteHandler"], () => {
    });
    let scrollToBottomHandler = fallback($$props["scrollToBottomHandler"], () => {
    });
    let loading = false;
    let system = "";
    let editEnabled = false;
    let chatInputElement = null;
    const chatCompletionHandler = async () => {
      if (selectedModelId === "") {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Please select a model."));
        return;
      }
      const model = store_get($$store_subs ??= {}, "$models", models).find((model2) => model2.id === selectedModelId);
      if (!model) {
        selectedModelId = "";
        return;
      }
      let responseMessage;
      if (messages.at(-1)?.role === "assistant") {
        responseMessage = messages.at(-1);
      } else {
        responseMessage = { role: "assistant", content: "", done: false };
        messages.push(responseMessage);
        messages = messages;
      }
      await tick();
      stopResponseFlag = false;
      let enhancedContent = { json: null, html: "", md: "" };
      system = "";
      {
        system = `You are a helpful assistant. Please answer the user's questions based on the context provided.

`;
      }
      system += `<notes>${note?.data?.content?.md ?? ""}</notes>` + (files && files.length > 0 ? `
<context>${files.map((file) => `${file.name}: ${file?.file?.data?.content ?? "Could not extract content"}
`).join("")}</context>` : "") + (selectedContent ? `
<selection>${selectedContent?.text}</selection>` : "");
      const chatMessages = JSON.parse(JSON.stringify([{ role: "system", content: `${system}` }, ...messages]));
      const [res, controller] = await chatCompletion(
        localStorage.token,
        {
          model: model.id,
          stream: true,
          messages: chatMessages
          // ...(files && files.length > 0 ? { files } : {}) // TODO: Decide whether to use native file handling or not
        },
        `${WEBUI_BASE_URL}/api`
      );
      await tick();
      let messageContent = "";
      if (res && res.ok) {
        const reader = res.body.pipeThrough(new TextDecoderStream()).pipeThrough(splitStream("\n")).getReader();
        while (true) {
          const { value, done } = await reader.read();
          if (done || stopResponseFlag) {
            if (stopResponseFlag) {
              controller.abort("User: Stop Response");
            }
            break;
          }
          try {
            let lines = value.split("\n");
            for (const line of lines) {
              if (line !== "") {
                /* @__PURE__ */ console.log(line);
                if (line === "data: [DONE]") {
                  if (editEnabled) ;
                  responseMessage.done = true;
                  messages = messages;
                } else {
                  let data = JSON.parse(line.replace(/^data: /, ""));
                  /* @__PURE__ */ console.log(data);
                  let deltaContent = data.choices[0]?.delta?.content ?? "";
                  if (responseMessage.content == "" && deltaContent == "\n") {
                    continue;
                  } else {
                    if (editEnabled) ;
                    else {
                      messageContent += deltaContent;
                      responseMessage.content = messageContent;
                      messages = messages;
                    }
                    await tick();
                  }
                }
              }
            }
          } catch (error) {
            /* @__PURE__ */ console.log(error);
          }
        }
      }
    };
    const submitHandler = async (e) => {
      const { content, data } = e;
      if (selectedModelId && content) {
        messages.push({ role: "user", content });
        messages = messages;
        await tick();
        loading = true;
        await chatCompletionHandler();
        messages = messages.map((message) => {
          message.done = true;
          return message;
        });
        loading = false;
        stopResponseFlag = false;
      }
    };
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="flex items-center mb-1.5 pt-1.5"><div class="flex items-center mr-1"><button class="p-0.5 bg-transparent transition rounded-lg">`);
      XMark($$renderer3, { className: "size-5", strokeWidth: "2.5" });
      $$renderer3.push(`<!----></button></div> <div class="font-medium text-base flex items-center gap-1"><div>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Chat"))}</div> <div>`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("This feature is experimental and may be modified or discontinued without notice."),
        position: "top",
        className: "inline-block",
        children: ($$renderer4) => {
          $$renderer4.push(`<span class="text-gray-500 text-sm">(${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Experimental"))})</span>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div></div></div> <div class="flex flex-col items-center flex-1 @container"><div class="flex flex-col justify-between w-full overflow-y-auto h-full"><div class="mx-auto w-full md:px-0 h-full relative"><div class="flex flex-col h-full"><div class="pb-2.5 flex flex-col justify-between w-full flex-auto overflow-auto h-0 scrollbar-hidden" id="messages-container"><div class="h-full w-full flex flex-col"><div class="flex-1 p-1">`);
      Messages($$renderer3, {
        onInsert,
        get messages() {
          return messages;
        },
        set messages($$value) {
          messages = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></div></div></div> <div class="pb-[1rem]">`);
      if (selectedContent) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="text-xs rounded-xl px-2.5 py-3 w-full markdown-prose-xs"><blockquote><div class="line-clamp-3">${escape_html(selectedContent?.text)}</div></blockquote></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      MessageInput($$renderer3, {
        acceptFiles: false,
        inputLoading: loading,
        showFormattingToolbar: false,
        onSubmit: submitHandler,
        onStop,
        get chatInputElement() {
          return chatInputElement;
        },
        set chatInputElement($$value) {
          chatInputElement = $$value;
          $$settled = false;
        },
        $$slots: {
          menu: ($$renderer4) => {
            $$renderer4.push(`<div slot="menu" class="flex items-center justify-between gap-2 w-full pr-1"><div>`);
            Tooltip($$renderer4, {
              content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Edit"),
              placement: "top",
              children: ($$renderer5) => {
                $$renderer5.push(`<button${attr("disabled", streaming || loading, true)} type="button"${attr_class(`px-2 @xl:px-2.5 py-2 flex gap-1.5 items-center text-sm rounded-full transition-colors duration-300 focus:outline-hidden max-w-full overflow-hidden hover:bg-gray-50 dark:hover:bg-gray-800 ${stringify("bg-transparent text-gray-600 dark:text-gray-300 ")} disabled:opacity-50 disabled:pointer-events-none`)}>`);
                PencilSquare($$renderer5, { className: "size-4", strokeWidth: "1.75" });
                $$renderer5.push(`<!----> <span class="block whitespace-nowrap overflow-hidden text-ellipsis leading-none pr-0.5">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Edit"))}</span></button>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div> `);
            Tooltip($$renderer4, {
              content: selectedModelId,
              children: ($$renderer5) => {
                $$renderer5.select(
                  {
                    class: "bg-transparent rounded-lg py-1 px-2 -mx-0.5 text-sm outline-hidden w-full text-right pr-5",
                    value: selectedModelId
                  },
                  ($$renderer6) => {
                    $$renderer6.push(`<!--[-->`);
                    const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$models", models).filter((model) => !(model?.info?.meta?.hidden ?? false)));
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let model = each_array[$$index];
                      $$renderer6.option({ value: model.id, class: "bg-gray-50 dark:bg-gray-700" }, ($$renderer7) => {
                        $$renderer7.push(`${escape_html(model.name)}`);
                      });
                    }
                    $$renderer6.push(`<!--]-->`);
                  }
                );
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div>`);
          }
        }
      });
      $$renderer3.push(`<!----></div></div></div></div></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      show,
      selectedModelId,
      editor,
      editing,
      streaming,
      stopResponseFlag,
      note,
      selectedContent,
      files,
      messages,
      onInsert,
      onStop,
      onEdited,
      insertNoteHandler,
      scrollToBottomHandler
    });
  });
}
function NotePanel($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let show = fallback($$props["show"], false);
    let pane = fallback($$props["pane"], null);
    let containerId = fallback($$props["containerId"], "note-container");
    let mediaQuery;
    let largeScreen = false;
    let minSize = 0;
    const handleMediaQuery = async (e) => {
      if (e.matches) {
        largeScreen = true;
      } else {
        largeScreen = false;
        pane = null;
      }
    };
    onDestroy(() => {
      mediaQuery.removeEventListener("change", handleMediaQuery);
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (!largeScreen) {
        $$renderer3.push("<!--[-->");
        if (show) {
          $$renderer3.push("<!--[-->");
          Drawer($$renderer3, {
            show,
            onClose: () => {
              show = false;
            },
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="px-3.5 py-2.5 h-screen max-h-dvh flex flex-col"><!--[-->`);
              slot($$renderer4, $$props, "default", {}, null);
              $$renderer4.push(`<!--]--></div>`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
        if (show) {
          $$renderer3.push("<!--[-->");
          Pane_resizer($$renderer3, {
            class: "relative flex items-center justify-center group border-l border-gray-50 dark:border-gray-850 hover:border-gray-200 dark:hover:border-gray-800  transition z-20",
            id: "controls-resizer",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="absolute -left-1.5 -right-1.5 -top-0 -bottom-0 z-20 cursor-col-resize bg-transparent"></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Pane($$renderer3, {
            defaultSize: Math.max(20, minSize),
            minSize,
            onCollapse: () => {
              show = false;
            },
            collapsible: true,
            class: " z-10 ",
            get pane() {
              return pane;
            },
            set pane($$value) {
              pane = $$value;
              $$settled = false;
            },
            children: ($$renderer4) => {
              if (show) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="flex max-h-full min-h-full"><div class="w-full pt-2 bg-white dark:shadow-lg dark:bg-gray-850 z-40 pointer-events-auto overflow-y-auto scrollbar-hidden flex flex-col px-2"><!--[-->`);
                slot($$renderer4, $$props, "default", {}, null);
                $$renderer4.push(`<!--]--></div></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { show, pane, containerId });
  });
}
function Calendar($$renderer, $$props) {
  let className = fallback($$props["className"], "size-3");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function Users($$renderer, $$props) {
  let className = fallback($$props["className"], "size-3");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function Mic($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M12 18.75a6 6 0 0 0 6-6v-1.5m-6 7.5a6 6 0 0 1-6-6v-1.5m6 7.5v3.75m-3.75 0h7.5M12 15.75a3 3 0 0 1-3-3V4.5a3 3 0 1 1 6 0v8.25a3 3 0 0 1-3 3Z"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function CursorArrowRays($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M15.042 21.672 13.684 16.6m0 0-2.51 2.225.569-9.47 5.227 7.917-3.286-.672ZM12 2.25V4.5m5.834.166-1.591 1.591M20.25 10.5H18M7.757 14.743l-1.59 1.59M6 10.5H3.75m4.007-4.243-1.59-1.59"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function RecordMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let className = fallback($$props["className"], "max-w-[170px]");
    let onRecord = fallback($$props["onRecord"], () => {
    });
    let onCaptureAudio = fallback($$props["onCaptureAudio"], () => {
    });
    let onUpload = fallback($$props["onUpload"], () => {
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Menu($$renderer3, {
        onOpenChange: (state) => {
        },
        get open() {
          return show;
        },
        set open($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          Menu_trigger($$renderer4, {
            children: ($$renderer5) => {
              $$renderer5.push(`<!--[-->`);
              slot($$renderer5, $$props, "default", {}, null);
              $$renderer5.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> <!--[-->`);
          slot($$renderer4, $$props, "content", {}, () => {
            Menu_content($$renderer4, {
              class: `w-full ${stringify(className)} text-sm rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg font-primary`,
              sideOffset: 8,
              side: "bottom",
              align: "start",
              transition: (e) => fade(e, { duration: 100 }),
              children: ($$renderer5) => {
                $$renderer5.push(`<button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">`);
                Mic($$renderer5, { className: "size-4", strokeWidth: "2" });
                $$renderer5.push(`<!----></div> <div class="self-center truncate">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Record"))}</div></button> <button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">`);
                CursorArrowRays($$renderer5, { className: "size-4", strokeWidth: "2" });
                $$renderer5.push(`<!----></div> <div class="self-center truncate">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Capture Audio"))}</div></button> <button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">`);
                CloudArrowUp($$renderer5, { className: "size-4", strokeWidth: "2" });
                $$renderer5.push(`<!----></div> <div class="self-center truncate">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Upload Audio"))}</div></button>`);
              },
              $$slots: { default: true }
            });
          });
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, className, onRecord, onCaptureAudio, onUpload });
  });
}
function SparklesSolid($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"${attr_class(clsx(className))}><path fill-rule="evenodd" d="M9 4.5a.75.75 0 0 1 .721.544l.813 2.846a3.75 3.75 0 0 0 2.576 2.576l2.846.813a.75.75 0 0 1 0 1.442l-2.846.813a3.75 3.75 0 0 0-2.576 2.576l-.813 2.846a.75.75 0 0 1-1.442 0l-.813-2.846a3.75 3.75 0 0 0-2.576-2.576l-2.846-.813a.75.75 0 0 1 0-1.442l2.846-.813A3.75 3.75 0 0 0 7.466 7.89l.813-2.846A.75.75 0 0 1 9 4.5ZM18 1.5a.75.75 0 0 1 .728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 0 1 0 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 0 1-1.456 0l-.258-1.036a2.625 2.625 0 0 0-1.91-1.91l-1.036-.258a.75.75 0 0 1 0-1.456l1.036-.258a2.625 2.625 0 0 0 1.91-1.91l.258-1.036A.75.75 0 0 1 18 1.5ZM16.5 15a.75.75 0 0 1 .712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 0 1 0 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 0 1-1.422 0l-.395-1.183a1.5 1.5 0 0 0-.948-.948l-1.183-.395a.75.75 0 0 1 0-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0 1 16.5 15Z" clip-rule="evenodd"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function ArrowUturnLeft($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function ArrowUturnRight($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function AIMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let className = fallback($$props["className"], "max-w-[170px]");
    let onEdit = fallback($$props["onEdit"], () => {
    });
    let onChat = fallback($$props["onChat"], () => {
    });
    let onChange = fallback($$props["onChange"], () => {
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Menu($$renderer3, {
        onOpenChange: onChange,
        get open() {
          return show;
        },
        set open($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          Menu_trigger($$renderer4, {
            children: ($$renderer5) => {
              $$renderer5.push(`<!--[-->`);
              slot($$renderer5, $$props, "default", {}, null);
              $$renderer5.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> <!--[-->`);
          slot($$renderer4, $$props, "content", {}, () => {
            Menu_content($$renderer4, {
              class: `w-full ${stringify(className)} text-sm rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg font-primary`,
              sideOffset: 8,
              side: "bottom",
              align: "end",
              transition: (e) => fade(e, { duration: 100 }),
              children: ($$renderer5) => {
                $$renderer5.push(`<button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">`);
                Sparkles($$renderer5, { className: "size-4", strokeWidth: "2" });
                $$renderer5.push(`<!----></div> <div class="self-center truncate">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Enhance"))}</div></button> <button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">`);
                ChatBubbleOval($$renderer5, { className: "size-4", strokeWidth: "2" });
                $$renderer5.push(`<!----></div> <div class="self-center truncate">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Chat"))}</div></button>`);
              },
              $$slots: { default: true }
            });
          });
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, className, onEdit, onChat, onChange });
  });
}
function AdjustmentsHorizontalOutline($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 1 1-3 0m3 0a1.5 1.5 0 1 0-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-9.75 0h9.75"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function NoteEditor($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const { saveAs } = fileSaver;
    const i18n = getContext("i18n");
    dayjs.extend(calendar);
    dayjs.extend(duration);
    dayjs.extend(relativeTime);
    async function loadLocale(locales) {
      for (const locale of locales) {
        try {
          dayjs.locale(locale);
          break;
        } catch (error) {
          /* @__PURE__ */ console.error(`Could not load locale '${locale}':`, error);
        }
      }
    }
    let id = fallback($$props["id"], null);
    let editor = null;
    let note = null;
    let files = [];
    let messages = [];
    let wordCount = 0;
    let charCount = 0;
    let versionIdx = null;
    let selectedModelId = null;
    let recording = false;
    let displayMediaRecord = false;
    let showPanel = false;
    let selectedPanel = "chat";
    let selectedContent = null;
    let showDeleteConfirm = false;
    let showAccessControlModal = false;
    let titleGenerating = false;
    let dragged = false;
    let loading = false;
    let editing = false;
    let streaming = false;
    let stopResponseFlag = false;
    let inputElement = null;
    const init = async () => {
      loading = true;
      const res = await getNoteById(localStorage.token, id).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      messages = [];
      if (res) {
        note = res;
        files = res.data.files || [];
      } else {
        goto();
        return;
      }
      loading = false;
    };
    let debounceTimeout = null;
    const changeDebounceHandler = () => {
      if (debounceTimeout) {
        clearTimeout(debounceTimeout);
      }
      debounceTimeout = setTimeout(
        async () => {
          await updateNoteById(localStorage.token, id, {
            title: note?.title === "" ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Untitled") : note.title,
            data: { files },
            access_control: note?.access_control
          }).catch((e) => {
            toast.error(`${e}`);
          });
        },
        200
      );
    };
    function areContentsEqual(a, b) {
      return JSON.stringify(a) === JSON.stringify(b);
    }
    function insertNoteVersion(note2) {
      const current = {
        json: note2.data.content.json,
        html: note2.data.content.html,
        md: note2.data.content.md
      };
      const lastVersion = note2.data.versions?.at(-1);
      if (!lastVersion || !areContentsEqual(lastVersion, current)) {
        note2.data.versions = (note2.data.versions ?? []).concat(current);
        return true;
      }
      return false;
    }
    const onEdited = async () => {
      if (!editor) return;
      editor.commands.setContent(note.data.content.html);
    };
    async function enhanceNoteHandler() {
      if (selectedModelId === "") {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Please select a model."));
        return;
      }
      const model = store_get($$store_subs ??= {}, "$models", models).filter((model2) => model2.id === selectedModelId && !(model2?.info?.meta?.hidden ?? false)).find((model2) => model2.id === selectedModelId);
      if (!model) {
        selectedModelId = "";
        return;
      }
      editing = true;
      await enhanceCompletionHandler(model);
      editing = false;
      onEdited();
      versionIdx = null;
    }
    const stopResponseHandler = async () => {
      stopResponseFlag = true;
      /* @__PURE__ */ console.log("stopResponse", stopResponseFlag);
    };
    const uploadFileHandler = async (file) => {
      const tempItemId = v4();
      const fileItem = {
        type: "file",
        file: "",
        id: null,
        url: "",
        name: file.name,
        collection_name: "",
        status: "uploading",
        size: file.size,
        error: "",
        itemId: tempItemId
      };
      if (fileItem.size == 0) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("You cannot upload an empty file."));
        return null;
      }
      files = [...files, fileItem];
      selectedPanel = "settings";
      if (!showPanel) {
        showPanel = true;
      }
      try {
        let metadata = null;
        if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language) {
          metadata = {
            language: store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language
          };
        }
        const uploadedFile = await uploadFile(localStorage.token, file, metadata);
        if (uploadedFile) {
          /* @__PURE__ */ console.log("File upload completed:", {
            id: uploadedFile.id,
            name: fileItem.name,
            collection: uploadedFile?.meta?.collection_name
          });
          if (uploadedFile.error) {
            console.warn("File upload warning:", uploadedFile.error);
            toast.warning(uploadedFile.error);
          }
          fileItem.status = "uploaded";
          fileItem.file = uploadedFile;
          fileItem.id = uploadedFile.id;
          fileItem.collection_name = uploadedFile?.meta?.collection_name || uploadedFile?.collection_name;
          fileItem.url = `${WEBUI_API_BASE_URL}/files/${uploadedFile.id}`;
          files = files;
        } else {
          files = files.filter((item) => item?.itemId !== tempItemId);
        }
      } catch (e) {
        toast.error(`${e}`);
        files = files.filter((item) => item?.itemId !== tempItemId);
      }
      if (files.length > 0) {
        note.data.files = files;
      } else {
        note.data.files = null;
      }
      editor.storage.files = files;
      changeDebounceHandler();
      return fileItem;
    };
    const compressImageHandler = async (imageUrl, settings2 = {}, config2 = {}) => {
      const settingsCompression = settings2?.imageCompression ?? false;
      const configWidth = config2?.file?.image_compression?.width ?? null;
      const configHeight = config2?.file?.image_compression?.height ?? null;
      if (!settingsCompression && !configWidth && !configHeight) {
        return imageUrl;
      }
      let width = null;
      let height = null;
      if (settingsCompression) {
        width = settings2?.imageCompressionSize?.width ?? null;
        height = settings2?.imageCompressionSize?.height ?? null;
      }
      if (configWidth && (width === null || width > configWidth)) {
        width = configWidth;
      }
      if (configHeight && (height === null || height > configHeight)) {
        height = configHeight;
      }
      if (width || height) {
        return await compressImage(imageUrl, width, height);
      }
      return imageUrl;
    };
    const inputFileHandler = async (file) => {
      /* @__PURE__ */ console.log("Processing file:", {
        name: file.name,
        type: file.type,
        size: file.size,
        extension: file.name.split(".").at(-1)
      });
      if ((store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? null) !== null && file.size > (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024) {
        /* @__PURE__ */ console.log("File exceeds max size limit:", {
          fileSize: file.size,
          maxSize: (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024
        });
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`File size should not exceed {{maxSize}} MB.`, {
          maxSize: store_get($$store_subs ??= {}, "$config", config)?.file?.max_size
        }));
        return;
      }
      if (file["type"].startsWith("image/")) {
        const uploadImagePromise = new Promise(async (resolve, reject) => {
          let reader = new FileReader();
          reader.onload = async (event) => {
            try {
              let imageUrl = event.target.result;
              imageUrl = await compressImageHandler(imageUrl, store_get($$store_subs ??= {}, "$settings", settings), store_get($$store_subs ??= {}, "$config", config));
              const fileId = v4();
              const fileItem = { id: fileId, type: "image", url: `${imageUrl}` };
              files = [...files, fileItem];
              note.data.files = files;
              editor.storage.files = files;
              changeDebounceHandler();
              resolve(fileItem);
            } catch (err) {
              reject(err);
            }
          };
          reader.readAsDataURL(file["type"] === "image/heic" ? await convertHeicToJpeg(file) : file);
        });
        return await uploadImagePromise;
      } else {
        return await uploadFileHandler(file);
      }
    };
    const downloadHandler = async (type) => {
      /* @__PURE__ */ console.log("downloadHandler", type);
      if (type === "txt") {
        const blob = new Blob([note.data.content.md], { type: "text/plain" });
        saveAs(blob, `${note.title}.txt`);
      } else if (type === "md") {
        const blob = new Blob([note.data.content.md], { type: "text/markdown" });
        saveAs(blob, `${note.title}.md`);
      } else if (type === "pdf") {
        try {
          await downloadPdf(note);
        } catch (error) {
          toast.error(`${error}`);
        }
      }
    };
    const scrollToBottom = () => {
      const element = document.getElementById("note-content-container");
      if (element) {
        element.scrollTop = element?.scrollHeight;
      }
    };
    const enhanceCompletionHandler = async (model) => {
      stopResponseFlag = false;
      let enhancedContent = { json: null, html: "", md: "" };
      const systemPrompt = `Enhance existing notes using additional context provided from audio transcription or uploaded file content in the content's primary language. Your task is to make the notes more useful and comprehensive by incorporating relevant information from the provided context.

Input will be provided within <notes> and <context> XML tags, providing a structure for the existing notes and context respectively.

# Output Format

Provide the enhanced notes in markdown format. Use markdown syntax for headings, lists, task lists ([ ]) where tasks or checklists are strongly implied, and emphasis to improve clarity and presentation. Ensure that all integrated content from the context is accurately reflected. Return only the markdown formatted note.
`;
      const [res, controller] = await chatCompletion(
        localStorage.token,
        {
          model: model.id,
          stream: true,
          messages: [
            { role: "system", content: systemPrompt },
            {
              role: "user",
              content: `<notes>${note.data.content.md}</notes>` + (files && files.length > 0 ? `
<context>${files.map((file) => `${file.name}: ${file?.file?.data?.content ?? "Could not extract content"}
`).join("")}</context>` : "")
            }
          ]
        },
        `${WEBUI_BASE_URL}/api`
      );
      await tick();
      streaming = true;
      if (res && res.ok) {
        const reader = res.body.pipeThrough(new TextDecoderStream()).pipeThrough(splitStream("\n")).getReader();
        while (true) {
          const { value, done } = await reader.read();
          if (done || stopResponseFlag) {
            if (stopResponseFlag) {
              controller.abort("User: Stop Response");
            }
            editing = false;
            streaming = false;
            break;
          }
          try {
            let lines = value.split("\n");
            for (const line of lines) {
              if (line !== "") {
                /* @__PURE__ */ console.log(line);
                if (line === "data: [DONE]") {
                  /* @__PURE__ */ console.log(line);
                } else {
                  let data = JSON.parse(line.replace(/^data: /, ""));
                  /* @__PURE__ */ console.log(data);
                  if (data.choices && data.choices.length > 0) {
                    const choice = data.choices[0];
                    if (choice.delta && choice.delta.content) {
                      enhancedContent.md += choice.delta.content;
                      enhancedContent.html = marked.parse(enhancedContent.md);
                      note.data.content.md = enhancedContent.md;
                      note.data.content.html = enhancedContent.html;
                      note.data.content.json = null;
                      scrollToBottom();
                    }
                  }
                }
              }
            }
          } catch (error) {
            /* @__PURE__ */ console.log(error);
          }
        }
      }
      streaming = false;
    };
    const insertHandler = (content) => {
      insertNoteVersion(note);
    };
    const noteEventHandler = async (_note) => {
      /* @__PURE__ */ console.log("noteEventHandler", _note);
      if (_note.id !== id) return;
      if (_note.access_control && _note.access_control !== note.access_control) {
        note.access_control = _note.access_control;
      }
      if (_note.data && _note.data.files) {
        files = _note.data.files;
        note.data.files = files;
      }
      if (_note.title && _note.title) {
        note.title = _note.title;
      }
      editor.storage.files = files;
      await tick();
      for (const file of files) {
        if (file.type === "image") {
          const e = new CustomEvent("data", { files });
          const img = document.getElementById(`image:${file.id}`);
          if (img) {
            img.dispatchEvent(e);
          }
        }
      }
    };
    onDestroy(() => {
      /* @__PURE__ */ console.log("destroy");
      store_get($$store_subs ??= {}, "$socket", socket)?.off("note-events", noteEventHandler);
      document.getElementById("note-editor");
    });
    loadLocale(store_get($$store_subs ??= {}, "$i18n", i18n).languages);
    if (id) {
      init();
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>
		${escape_html(note?.title ? `${note?.title.length > 30 ? `${note?.title.slice(0, 30)}...` : note?.title} • ${store_get($$store_subs ??= {}, "$WEBUI_NAME", WEBUI_NAME)}` : `${store_get($$store_subs ??= {}, "$WEBUI_NAME", WEBUI_NAME)}`)}
	</title>`);
        });
      });
      if (note) {
        $$renderer3.push("<!--[-->");
        AccessControlModal($$renderer3, {
          accessRoles: ["read", "write"],
          onChange: () => {
            changeDebounceHandler();
          },
          get show() {
            return showAccessControlModal;
          },
          set show($$value) {
            showAccessControlModal = $$value;
            $$settled = false;
          },
          get accessControl() {
            return note.access_control;
          },
          set accessControl($$value) {
            note.access_control = $$value;
            $$settled = false;
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      FilesOverlay($$renderer3, { show: dragged });
      $$renderer3.push(`<!----> `);
      ConfirmDialog($$renderer3, {
        title: store_get($$store_subs ??= {}, "$i18n", i18n).t("Delete note?"),
        get show() {
          return showDeleteConfirm;
        },
        set show($$value) {
          showDeleteConfirm = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="text-sm text-gray-500">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("This will delete"))} <span class="font-semibold">${escape_html(note.title)}</span>.</div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Pane_group($$renderer3, {
        direction: "horizontal",
        class: "w-full h-full",
        children: ($$renderer4) => {
          Pane($$renderer4, {
            defaultSize: 70,
            minSize: 30,
            class: "h-full flex flex-col w-full relative",
            children: ($$renderer5) => {
              $$renderer5.push(`<div class="relative flex-1 w-full h-full flex justify-center pt-[11px]" id="note-editor">`);
              if (loading) {
                $$renderer5.push("<!--[-->");
                $$renderer5.push(`<div class="absolute top-0 bottom-0 left-0 right-0 flex"><div class="m-auto">`);
                Spinner($$renderer5, { className: "size-5" });
                $$renderer5.push(`<!----></div></div>`);
              } else {
                $$renderer5.push("<!--[!-->");
                $$renderer5.push(`<div${attr_class(` w-full flex flex-col ${stringify(loading ? "opacity-20" : "")}`)}><div class="shrink-0 w-full flex justify-between items-center px-3.5 mb-1.5"><div class="w-full flex items-center">`);
                if (store_get($$store_subs ??= {}, "$mobile", mobile)) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<div${attr_class(`${stringify(store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? "md:hidden pl-0.5" : "")} flex flex-none items-center pr-1 -translate-x-1`)}>`);
                  Tooltip($$renderer5, {
                    content: store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Close Sidebar") : store_get($$store_subs ??= {}, "$i18n", i18n).t("Open Sidebar"),
                    children: ($$renderer6) => {
                      $$renderer6.push(`<button id="sidebar-toggle-button" class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition cursor-"><div class="self-center p-1.5">`);
                      Sidebar($$renderer6, {});
                      $$renderer6.push(`<!----></div></button>`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> <input class="w-full text-2xl font-medium bg-transparent outline-hidden" type="text"${attr("value", note.title)}${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Title"))}${attr("disabled", note?.user_id !== store_get($$store_subs ??= {}, "$user", user)?.id && store_get($$store_subs ??= {}, "$user", user)?.role !== "admin" || titleGenerating, true)} required/> `);
                {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> <div class="flex items-center gap-0.5 translate-x-1">`);
                if (editor) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<div><div class="flex items-center gap-0.5 self-center min-w-fit" dir="ltr"><button class="self-center p-1 hover:enabled:bg-black/5 dark:hover:enabled:bg-white/5 dark:hover:enabled:text-white hover:enabled:text-black rounded-md transition disabled:cursor-not-allowed disabled:text-gray-500 disabled:hover:text-gray-500"${attr("disabled", !editor.can().undo(), true)}>`);
                  ArrowUturnLeft($$renderer5, { className: "size-4" });
                  $$renderer5.push(`<!----></button> <button class="self-center p-1 hover:enabled:bg-black/5 dark:hover:enabled:bg-white/5 dark:hover:enabled:text-white hover:enabled:text-black rounded-md transition disabled:cursor-not-allowed disabled:text-gray-500 disabled:hover:text-gray-500"${attr("disabled", !editor.can().redo(), true)}>`);
                  ArrowUturnRight($$renderer5, { className: "size-4" });
                  $$renderer5.push(`<!----></button></div></div>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> `);
                Tooltip($$renderer5, {
                  placement: "top",
                  content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Chat"),
                  className: "cursor-pointer",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<button class="p-1.5 bg-transparent hover:bg-white/5 transition rounded-lg">`);
                    ChatBubbleOval($$renderer6, {});
                    $$renderer6.push(`<!----></button>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Tooltip($$renderer5, {
                  placement: "top",
                  content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Controls"),
                  className: "cursor-pointer",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<button class="p-1.5 bg-transparent hover:bg-white/5 transition rounded-lg">`);
                    AdjustmentsHorizontalOutline($$renderer6, {});
                    $$renderer6.push(`<!----></button>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                NoteMenu($$renderer5, {
                  onDownload: (type) => {
                    downloadHandler(type);
                  },
                  onCopyLink: async () => {
                    const baseUrl = window.location.origin;
                    const res = await copyToClipboard(`${baseUrl}/notes/${note.id}`);
                    if (res) {
                      toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("Copied link to clipboard"));
                    } else {
                      toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to copy link"));
                    }
                  },
                  onCopyToClipboard: async () => {
                    const res = await copyToClipboard(note.data.content.md, note.data.content.html, true).catch((error) => {
                      toast.error(`${error}`);
                      return null;
                    });
                    if (res) {
                      toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("Copied to clipboard"));
                    }
                  },
                  onDelete: () => {
                    showDeleteConfirm = true;
                  },
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="p-1 bg-transparent hover:bg-white/5 transition rounded-lg">`);
                    EllipsisHorizontal($$renderer6, { className: "size-5" });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div></div></div> <div class="px-2.5"><div class="flex w-full bg-transparent overflow-x-auto scrollbar-none"><div class="flex gap-1 items-center text-xs font-medium text-gray-500 dark:text-gray-500 w-fit"><button class="flex items-center gap-1 w-fit py-1 px-1.5 rounded-lg min-w-fit">`);
                Calendar($$renderer5, { className: "size-3.5", strokeWidth: "2" });
                $$renderer5.push(`<!----> `);
                if (dayjs(note.created_at / 1e6).isSame(dayjs(), "day")) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<span>${escape_html(dayjs(note.created_at / 1e6).format(store_get($$store_subs ??= {}, "$i18n", i18n).t("[Today at] h:mm A")))}</span>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                  if (dayjs(note.created_at / 1e6).isSame(dayjs().subtract(1, "day"), "day")) {
                    $$renderer5.push("<!--[-->");
                    $$renderer5.push(`<span>${escape_html(dayjs(note.created_at / 1e6).format(store_get($$store_subs ??= {}, "$i18n", i18n).t("[Yesterday at] h:mm A")))}</span>`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                    if (dayjs(note.created_at / 1e6).isSame(dayjs().subtract(1, "week"), "week")) {
                      $$renderer5.push("<!--[-->");
                      $$renderer5.push(`<span>${escape_html(dayjs(note.created_at / 1e6).format(store_get($$store_subs ??= {}, "$i18n", i18n).t("[Last] dddd [at] h:mm A")))}</span>`);
                    } else {
                      $$renderer5.push("<!--[!-->");
                      $$renderer5.push(`<span>${escape_html(dayjs(note.created_at / 1e6).format(store_get($$store_subs ??= {}, "$i18n", i18n).t("DD/MM/YYYY")))}</span>`);
                    }
                    $$renderer5.push(`<!--]-->`);
                  }
                  $$renderer5.push(`<!--]-->`);
                }
                $$renderer5.push(`<!--]--></button> <button class="flex items-center gap-1 w-fit py-1 px-1.5 rounded-lg min-w-fit"${attr("disabled", note?.user_id !== store_get($$store_subs ??= {}, "$user", user)?.id && store_get($$store_subs ??= {}, "$user", user)?.role !== "admin", true)}>`);
                Users($$renderer5, { className: "size-3.5", strokeWidth: "2" });
                $$renderer5.push(`<!----> <span>${escape_html(note?.access_control ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Private") : store_get($$store_subs ??= {}, "$i18n", i18n).t("Everyone"))}</span></button> `);
                if (editor) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<div class="flex items-center gap-1 px-1 min-w-fit"><div>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("{{COUNT}} words", { COUNT: wordCount }))}</div> <div>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("{{COUNT}} characters", { COUNT: charCount }))}</div></div>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--></div></div></div> <div class="flex-1 w-full h-full overflow-auto px-3.5 pb-20 relative pt-2.5" id="note-content-container">`);
                if (editing) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<div${attr_class(`w-full h-full fixed top-0 left-0 ${stringify(streaming ? "" : " backdrop-blur-xs  bg-white/10 dark:bg-gray-900/10")} flex items-center justify-center z-10 cursor-not-allowed`)}></div>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> `);
                RichTextInput($$renderer5, {
                  id: `note-${note.id}`,
                  className: "input-prose-sm px-0.5",
                  json: true,
                  html: note.data?.content?.html,
                  documentId: `note:${note.id}`,
                  collaboration: true,
                  socket: store_get($$store_subs ??= {}, "$socket", socket),
                  user: store_get($$store_subs ??= {}, "$user", user),
                  dragHandle: true,
                  link: true,
                  image: true,
                  files,
                  placeholder: store_get($$store_subs ??= {}, "$i18n", i18n).t("Write something..."),
                  editable: versionIdx === null && !editing,
                  onSelectionUpdate: ({ editor: editor2 }) => {
                    const { from, to } = editor2.state.selection;
                    const selectedText = editor2.state.doc.textBetween(from, to, " ");
                    if (selectedText.length === 0) {
                      selectedContent = null;
                    } else {
                      selectedContent = { text: selectedText, from, to };
                    }
                  },
                  onChange: (content) => {
                    note.data.content.html = content.html;
                    note.data.content.md = content.md;
                    if (editor) {
                      wordCount = editor.storage.characterCount.words();
                      charCount = editor.storage.characterCount.characters();
                    }
                  },
                  fileHandler: true,
                  onFileDrop: (currentEditor, files2, pos) => {
                    files2.forEach(async (file) => {
                      const fileItem = await inputFileHandler(file).catch((error) => {
                        return null;
                      });
                      if (fileItem.type === "image") {
                        currentEditor.chain().insertContentAt(pos, { type: "image", attrs: { src: `data://${fileItem.id}` } }).focus().run();
                      }
                    });
                  },
                  onFilePaste: () => {
                  },
                  get editor() {
                    return editor;
                  },
                  set editor($$value) {
                    editor = $$value;
                    $$settled = false;
                  },
                  get value() {
                    return note.data.content.json;
                  },
                  set value($$value) {
                    note.data.content.json = $$value;
                    $$settled = false;
                  }
                });
                $$renderer5.push(`<!----></div></div>`);
              }
              $$renderer5.push(`<!--]--></div> <div class="absolute z-20 bottom-0 right-0 p-3.5 max-w-full w-full flex"><div class="flex gap-1 w-full min-w-full justify-between">`);
              if (recording) {
                $$renderer5.push("<!--[-->");
                $$renderer5.push(`<div class="flex-1 w-full">`);
                VoiceRecording($$renderer5, {
                  className: "p-1 w-full max-w-full",
                  transcribe: false,
                  displayMedia: displayMediaRecord,
                  echoCancellation: false,
                  noiseSuppression: false,
                  onCancel: () => {
                    recording = false;
                    displayMediaRecord = false;
                  },
                  onConfirm: (data) => {
                    if (data?.file) {
                      uploadFileHandler(data?.file);
                    }
                    recording = false;
                    displayMediaRecord = false;
                  },
                  get recording() {
                    return recording;
                  },
                  set recording($$value) {
                    recording = $$value;
                    $$settled = false;
                  }
                });
                $$renderer5.push(`<!----></div>`);
              } else {
                $$renderer5.push("<!--[!-->");
                RecordMenu($$renderer5, {
                  onRecord: async () => {
                    displayMediaRecord = false;
                    try {
                      let stream = await navigator.mediaDevices.getUserMedia({ audio: true }).catch(function(err) {
                        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`Permission denied when accessing microphone: {{error}}`, { error: err }));
                        return null;
                      });
                      if (stream) {
                        recording = true;
                        const tracks = stream.getTracks();
                        tracks.forEach((track) => track.stop());
                      }
                      stream = null;
                    } catch {
                      toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Permission denied when accessing microphone"));
                    }
                  },
                  onCaptureAudio: async () => {
                    displayMediaRecord = true;
                    recording = true;
                  },
                  onUpload: async () => {
                    const input = document.createElement("input");
                    input.type = "file";
                    input.accept = "audio/*";
                    input.multiple = false;
                    input.click();
                    input.onchange = async (e) => {
                      const files2 = e.target.files;
                      if (files2 && files2.length > 0) {
                        await uploadFileHandler(files2[0]);
                      }
                    };
                  },
                  children: ($$renderer6) => {
                    Tooltip($$renderer6, {
                      content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Record"),
                      placement: "top",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<div class="cursor-pointer p-2.5 flex rounded-full border border-gray-50 bg-white dark:border-none dark:bg-gray-850 hover:bg-gray-50 dark:hover:bg-gray-800 transition shadow-xl">`);
                        MicSolid($$renderer7, { className: "size-4.5" });
                        $$renderer7.push(`<!----></div>`);
                      },
                      $$slots: { default: true }
                    });
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> <div class="cursor-pointer flex gap-0.5 rounded-full border border-gray-50 dark:border-gray-850 dark:bg-gray-850 transition shadow-xl">`);
                Tooltip($$renderer5, {
                  content: store_get($$store_subs ??= {}, "$i18n", i18n).t("AI"),
                  placement: "top",
                  children: ($$renderer6) => {
                    if (editing) {
                      $$renderer6.push("<!--[-->");
                      $$renderer6.push(`<button class="p-2 flex justify-center items-center hover:bg-gray-50 dark:hover:bg-gray-800 rounded-full transition shrink-0" type="button">`);
                      Spinner($$renderer6, { className: "size-5" });
                      $$renderer6.push(`<!----></button>`);
                    } else {
                      $$renderer6.push("<!--[!-->");
                      AIMenu($$renderer6, {
                        onEdit: () => {
                          enhanceNoteHandler();
                        },
                        onChat: () => {
                          showPanel = true;
                          selectedPanel = "chat";
                        },
                        children: ($$renderer7) => {
                          $$renderer7.push(`<div class="cursor-pointer p-2.5 flex rounded-full border border-gray-50 bg-white dark:border-none dark:bg-gray-850 hover:bg-gray-50 dark:hover:bg-gray-800 transition shadow-xl">`);
                          SparklesSolid($$renderer7, {});
                          $$renderer7.push(`<!----></div>`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]-->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              }
              $$renderer5.push(`<!--]--></div></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          NotePanel($$renderer4, {
            get show() {
              return showPanel;
            },
            set show($$value) {
              showPanel = $$value;
              $$settled = false;
            },
            children: ($$renderer5) => {
              if (selectedPanel === "chat") {
                $$renderer5.push("<!--[-->");
                Chat($$renderer5, {
                  editor,
                  inputElement,
                  selectedContent,
                  files,
                  onInsert: insertHandler,
                  onStop: stopResponseHandler,
                  onEdited,
                  insertNoteHandler: () => {
                    insertNoteVersion(note);
                  },
                  scrollToBottomHandler: scrollToBottom,
                  get show() {
                    return showPanel;
                  },
                  set show($$value) {
                    showPanel = $$value;
                    $$settled = false;
                  },
                  get selectedModelId() {
                    return selectedModelId;
                  },
                  set selectedModelId($$value) {
                    selectedModelId = $$value;
                    $$settled = false;
                  },
                  get messages() {
                    return messages;
                  },
                  set messages($$value) {
                    messages = $$value;
                    $$settled = false;
                  },
                  get note() {
                    return note;
                  },
                  set note($$value) {
                    note = $$value;
                    $$settled = false;
                  },
                  get editing() {
                    return editing;
                  },
                  set editing($$value) {
                    editing = $$value;
                    $$settled = false;
                  },
                  get streaming() {
                    return streaming;
                  },
                  set streaming($$value) {
                    streaming = $$value;
                    $$settled = false;
                  },
                  get stopResponseFlag() {
                    return stopResponseFlag;
                  },
                  set stopResponseFlag($$value) {
                    stopResponseFlag = $$value;
                    $$settled = false;
                  }
                });
              } else {
                $$renderer5.push("<!--[!-->");
                if (selectedPanel === "settings") {
                  $$renderer5.push("<!--[-->");
                  Controls($$renderer5, {
                    onUpdate: () => {
                      changeDebounceHandler();
                    },
                    get show() {
                      return showPanel;
                    },
                    set show($$value) {
                      showPanel = $$value;
                      $$settled = false;
                    },
                    get selectedModelId() {
                      return selectedModelId;
                    },
                    set selectedModelId($$value) {
                      selectedModelId = $$value;
                      $$settled = false;
                    },
                    get files() {
                      return files;
                    },
                    set files($$value) {
                      files = $$value;
                      $$settled = false;
                    }
                  });
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]-->`);
              }
              $$renderer5.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!---->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { id });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    $$renderer2.push(`<div id="note-container"${attr_class(`w-full h-full ${stringify(store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? "md:max-w-[calc(100%-260px)]" : "")}`)}>`);
    NoteEditor($$renderer2, {
      id: store_get($$store_subs ??= {}, "$page", page).params.id
    });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
