import { Q as AUDIO_API_BASE_URL } from "./index2.js";
import { l as rest_props, s as store_get, m as attributes, h as slot, u as unsubscribe_stores, b as bind_props, k as sanitize_props } from "./index.js";
import { Y as fallback } from "./context.js";
import "clsx";
import { b as getCtx, c as generateId, s as styleToString, d as getCursorStyle } from "./Drawer.js";
const transcribeAudio = async (token, file, language) => {
  const data = new FormData();
  data.append("file", file);
  if (language) {
    data.append("language", language);
  }
  let error = null;
  const res = await fetch(`${AUDIO_API_BASE_URL}/transcriptions`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      authorization: `Bearer ${token}`
    },
    body: data
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const synthesizeOpenAISpeech = async (token = "", speaker = "alloy", text = "", model) => {
  let error = null;
  const res = await fetch(`${AUDIO_API_BASE_URL}/speech`, {
    method: "POST",
    headers: {
      Authorization: `Bearer ${token}`,
      "Content-Type": "application/json"
    },
    body: JSON.stringify({
      input: text,
      voice: speaker,
      ...model
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
function Pane_resizer($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "disabled",
    "onDraggingChange",
    "tabIndex",
    "el",
    "id",
    "style"
  ]);
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let isDragging, style, attrs;
    let disabled = fallback($$props["disabled"], false);
    let onDraggingChange = fallback($$props["onDraggingChange"], () => void 0, true);
    let tabIndex = fallback($$props["tabIndex"], 0);
    let el = fallback($$props["el"], null);
    let idFromProps = fallback($$props["id"], () => void 0, true);
    let styleFromProps = fallback($$props["style"], () => void 0, true);
    const {
      methods: { registerResizeHandle, startDragging, stopDragging },
      states: { direction, dragState, groupId }
    } = getCtx("PaneResizer");
    const resizeHandleId = generateId(idFromProps);
    isDragging = store_get($$store_subs ??= {}, "$dragState", dragState)?.dragHandleId === resizeHandleId;
    if (disabled) ;
    else {
      registerResizeHandle(resizeHandleId);
    }
    style = styleToString({
      cursor: getCursorStyle(store_get($$store_subs ??= {}, "$direction", direction)),
      "touch-action": "none",
      "user-select": "none",
      "-webkit-user-select": "none",
      "-webkit-touch-callout": "none"
    }) + styleFromProps;
    attrs = {
      "data-direction": store_get($$store_subs ??= {}, "$direction", direction),
      "data-pane-group-id": store_get($$store_subs ??= {}, "$groupId", groupId),
      "data-active": isDragging ? "pointer" : void 0,
      "data-enabled": !disabled,
      "data-pane-resizer-id": resizeHandleId,
      "data-pane-resizer": ""
    };
    $$renderer2.push(`<div${attributes({
      role: "separator",
      style,
      tabindex: tabIndex,
      ...attrs,
      ...$$restProps
    })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      disabled,
      onDraggingChange,
      tabIndex,
      el,
      id: idFromProps,
      style: styleFromProps
    });
  });
}
export {
  Pane_resizer as P,
  synthesizeOpenAISpeech as s,
  transcribeAudio as t
};
//# sourceMappingURL=pane-resizer.js.map
