import { a as WEBUI_BASE_URL } from "./index2.js";
const getOpenAIModelsDirect = async (url, key) => {
  let error = null;
  const res = await fetch(`${url}/models`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...key && { authorization: `Bearer ${key}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = `OpenAI: ${err?.error?.message ?? "Network Problem"}`;
    return [];
  });
  if (error) {
    throw error;
  }
  return res;
};
const chatCompletion = async (token = "", body, url = `${WEBUI_BASE_URL}/api`) => {
  const controller = new AbortController();
  let error = null;
  const res = await fetch(`${url}/chat/completions`, {
    signal: controller.signal,
    method: "POST",
    headers: {
      Authorization: `Bearer ${token}`,
      "Content-Type": "application/json"
    },
    body: JSON.stringify(body)
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return [res, controller];
};
const generateOpenAIChatCompletion = async (token = "", body, url = `${WEBUI_BASE_URL}/api`) => {
  let error = null;
  const res = await fetch(`${url}/chat/completions`, {
    method: "POST",
    headers: {
      Authorization: `Bearer ${token}`,
      "Content-Type": "application/json"
    },
    credentials: "include",
    body: JSON.stringify(body)
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err?.detail ?? err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
export {
  getOpenAIModelsDirect as a,
  chatCompletion as c,
  generateOpenAIChatCompletion as g
};
//# sourceMappingURL=index11.js.map
