import { h as slot, a as attr, c as attr_class, b as bind_props, o as stringify } from "./index.js";
import { o as onDestroy } from "./client.js";
import { a as WEBUI_BASE_URL } from "./index2.js";
import { Y as fallback } from "./context.js";
function Loader($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    onDestroy(() => {
    });
    $$renderer2.push(`<div><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
  });
}
function Name($$renderer, $$props) {
  $$renderer.push(`<div class="self-center font-semibold line-clamp-1 flex gap-1 items-center"><!--[-->`);
  slot($$renderer, $$props, "default", {}, null);
  $$renderer.push(`<!--]--></div>`);
}
function ProfileImage($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let className = fallback($$props["className"], "size-8");
    let src = fallback($$props["src"], () => `${WEBUI_BASE_URL}/static/favicon.png`, true);
    $$renderer2.push(`<img crossorigin="anonymous" aria-hidden="true"${attr("src", src === "" ? `${WEBUI_BASE_URL}/static/favicon.png` : src.startsWith(WEBUI_BASE_URL) || src.startsWith("https://www.gravatar.com/avatar/") || src.startsWith("data:") || src.startsWith("/") ? src : `${WEBUI_BASE_URL}/user.png`)}${attr_class(` ${stringify(className)} object-cover rounded-full`)} alt="profile" draggable="false"/>`);
    bind_props($$props, { className, src });
  });
}
export {
  Loader as L,
  Name as N,
  ProfileImage as P
};
//# sourceMappingURL=ProfileImage.js.map
