import { s as store_get, u as unsubscribe_stores, b as bind_props } from "./index.js";
import { o as onDestroy, t as tick } from "./client.js";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { Z as getContext, Y as fallback } from "./context.js";
import "clsx";
import { v4 } from "uuid";
import { o as config, g as settings, z as WEBUI_API_BASE_URL } from "./index2.js";
import { e as extractInputVariables, b as getUserPosition, d as getAge, f as getFormattedDate, h as getFormattedTime, i as getCurrentDateTime, j as getUserTimezone, k as getWeekday, l as convertHeicToJpeg, n as compressImage } from "./index4.js";
import { g as getSessionUser } from "./Drawer.js";
import { u as uploadFile } from "./index13.js";
import "dompurify";
import "dayjs";
import "dayjs/plugin/relativeTime.js";
import "dequal";
import "./create.js";
import "marked";
import "turndown";
import "@joplin/turndown-plugin-gfm";
import "./listDragHandlePlugin.js";
import "@tiptap/starter-kit";
import "@tiptap/extension-table";
import "@tiptap/extension-list";
import "@tiptap/extensions";
import "@tiptap/extension-file-handler";
import "@tiptap/extension-typography";
import "@tiptap/extension-highlight";
import "@tiptap/extension-code-block-lowlight";
import "@tiptap/extension-mention";
import "dayjs/plugin/localizedFormat.js";
/* empty css                                    */
import "panzoom";
import "file-saver";
import "./FileItem.js";
function MessageInput($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let placeholder = fallback($$props["placeholder"], () => store_get($$store_subs ??= {}, "$i18n", i18n).t("Type here..."), true);
    let id = fallback($$props["id"], null);
    let chatInputElement = $$props["chatInputElement"];
    let typingUsers = fallback($$props["typingUsers"], () => [], true);
    let inputLoading = fallback($$props["inputLoading"], false);
    let onSubmit = fallback($$props["onSubmit"], (e) => {
    });
    let onChange = fallback($$props["onChange"], (e) => {
    });
    let onStop = fallback($$props["onStop"], (e) => {
    });
    let scrollEnd = fallback($$props["scrollEnd"], true);
    let scrollToBottom = fallback($$props["scrollToBottom"], () => {
    });
    let disabled = fallback($$props["disabled"], false);
    let acceptFiles = fallback($$props["acceptFiles"], true);
    let showFormattingToolbar = fallback($$props["showFormattingToolbar"], true);
    let userSuggestions = fallback($$props["userSuggestions"], false);
    let channelSuggestions = fallback($$props["channelSuggestions"], false);
    let replyToMessage = fallback($$props["replyToMessage"], null);
    let typingUsersClassName = fallback($$props["typingUsersClassName"], "from-white dark:from-gray-900");
    let files = [];
    let inputVariables = {};
    const inputVariableHandler = async (text) => {
      inputVariables = extractInputVariables(text);
      if (Object.keys(inputVariables).length === 0) {
        return text;
      }
      return await new Promise((resolve) => {
      });
    };
    const textVariableHandler = async (text) => {
      if (text.includes("{{CLIPBOARD}}")) {
        const clipboardText = await navigator.clipboard.readText().catch((err) => {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to read clipboard contents"));
          return "{{CLIPBOARD}}";
        });
        const clipboardItems = await navigator.clipboard.read();
        let imageUrl = null;
        for (const item of clipboardItems) {
          for (const type of item.types) {
            if (type.startsWith("image/")) {
              const blob = await item.getType(type);
              imageUrl = URL.createObjectURL(blob);
            }
          }
        }
        if (imageUrl) {
          files = [...files, { type: "image", url: imageUrl }];
        }
        text = text.replaceAll("{{CLIPBOARD}}", clipboardText);
      }
      if (text.includes("{{USER_LOCATION}}")) {
        let location;
        try {
          location = await getUserPosition();
        } catch (error) {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Location access not allowed"));
          location = "LOCATION_UNKNOWN";
        }
        text = text.replaceAll("{{USER_LOCATION}}", String(location));
      }
      const sessionUser = await getSessionUser(localStorage.token);
      if (text.includes("{{USER_NAME}}")) {
        const name = sessionUser?.name || "User";
        text = text.replaceAll("{{USER_NAME}}", name);
      }
      if (text.includes("{{USER_BIO}}")) {
        const bio = sessionUser?.bio || "";
        if (bio) {
          text = text.replaceAll("{{USER_BIO}}", bio);
        }
      }
      if (text.includes("{{USER_GENDER}}")) {
        const gender = sessionUser?.gender || "";
        if (gender) {
          text = text.replaceAll("{{USER_GENDER}}", gender);
        }
      }
      if (text.includes("{{USER_BIRTH_DATE}}")) {
        const birthDate = sessionUser?.date_of_birth || "";
        if (birthDate) {
          text = text.replaceAll("{{USER_BIRTH_DATE}}", birthDate);
        }
      }
      if (text.includes("{{USER_AGE}}")) {
        const birthDate = sessionUser?.date_of_birth || "";
        if (birthDate) {
          const age = getAge(birthDate);
          text = text.replaceAll("{{USER_AGE}}", age);
        }
      }
      if (text.includes("{{USER_LANGUAGE}}")) {
        const language = localStorage.getItem("locale") || "en-US";
        text = text.replaceAll("{{USER_LANGUAGE}}", language);
      }
      if (text.includes("{{CURRENT_DATE}}")) {
        const date = getFormattedDate();
        text = text.replaceAll("{{CURRENT_DATE}}", date);
      }
      if (text.includes("{{CURRENT_TIME}}")) {
        const time = getFormattedTime();
        text = text.replaceAll("{{CURRENT_TIME}}", time);
      }
      if (text.includes("{{CURRENT_DATETIME}}")) {
        const dateTime = getCurrentDateTime();
        text = text.replaceAll("{{CURRENT_DATETIME}}", dateTime);
      }
      if (text.includes("{{CURRENT_TIMEZONE}}")) {
        const timezone = getUserTimezone();
        text = text.replaceAll("{{CURRENT_TIMEZONE}}", timezone);
      }
      if (text.includes("{{CURRENT_WEEKDAY}}")) {
        const weekday = getWeekday();
        text = text.replaceAll("{{CURRENT_WEEKDAY}}", weekday);
      }
      return text;
    };
    const setText = async (text, cb) => {
      const chatInput = document.getElementById("chat-input");
      if (chatInput) {
        if (text !== "") {
          text = await textVariableHandler(text || "");
        }
        chatInputElement?.setText(text);
        chatInputElement?.focus();
        if (text !== "") {
          text = await inputVariableHandler(text);
        }
        await tick();
        if (cb) await cb(text);
      }
    };
    let command = "";
    let showCommands = fallback($$props["showCommands"], false);
    const inputFilesHandler = async (inputFiles) => {
      inputFiles.forEach(async (file) => {
        console.info("Processing file:", {
          name: file.name,
          type: file.type,
          size: file.size,
          extension: file.name.split(".").at(-1)
        });
        if ((store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? null) !== null && file.size > (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024) {
          /* @__PURE__ */ console.error("File exceeds max size limit:", {
            fileSize: file.size,
            maxSize: (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024
          });
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`File size should not exceed {{maxSize}} MB.`, {
            maxSize: store_get($$store_subs ??= {}, "$config", config)?.file?.max_size
          }));
          return;
        }
        if (file["type"].startsWith("image/")) {
          const compressImageHandler = async (imageUrl, settings2 = {}, config2 = {}) => {
            const settingsCompression = settings2?.imageCompression ?? false;
            const configWidth = config2?.file?.image_compression?.width ?? null;
            const configHeight = config2?.file?.image_compression?.height ?? null;
            if (!settingsCompression && !configWidth && !configHeight) {
              return imageUrl;
            }
            let width = null;
            let height = null;
            if (settingsCompression) {
              width = settings2?.imageCompressionSize?.width ?? null;
              height = settings2?.imageCompressionSize?.height ?? null;
            }
            if (configWidth && (width === null || width > configWidth)) {
              width = configWidth;
            }
            if (configHeight && (height === null || height > configHeight)) {
              height = configHeight;
            }
            if (width || height) {
              return await compressImage(imageUrl, width, height);
            }
            return imageUrl;
          };
          let reader = new FileReader();
          reader.onload = async (event) => {
            let imageUrl = event.target.result;
            if (store_get($$store_subs ??= {}, "$settings", settings)?.imageCompression && store_get($$store_subs ??= {}, "$settings", settings)?.imageCompressionInChannels) {
              imageUrl = await compressImageHandler(imageUrl, store_get($$store_subs ??= {}, "$settings", settings), store_get($$store_subs ??= {}, "$config", config));
            }
            files = [...files, { type: "image", url: `${imageUrl}` }];
          };
          reader.readAsDataURL(file["type"] === "image/heic" ? await convertHeicToJpeg(file) : file);
        } else {
          uploadFileHandler(file);
        }
      });
    };
    const uploadFileHandler = async (file) => {
      const tempItemId = v4();
      const fileItem = {
        type: "file",
        file: "",
        id: null,
        url: "",
        name: file.name,
        collection_name: "",
        status: "uploading",
        size: file.size,
        error: "",
        itemId: tempItemId
      };
      if (fileItem.size == 0) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("You cannot upload an empty file."));
        return null;
      }
      files = [...files, fileItem];
      try {
        let metadata = null;
        if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language) {
          metadata = {
            language: store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language
          };
        }
        const uploadedFile = await uploadFile(localStorage.token, file, metadata);
        if (uploadedFile) {
          console.info("File upload completed:", {
            id: uploadedFile.id,
            name: fileItem.name,
            collection: uploadedFile?.meta?.collection_name
          });
          if (uploadedFile.error) {
            /* @__PURE__ */ console.error("File upload warning:", uploadedFile.error);
            toast.warning(uploadedFile.error);
          }
          fileItem.status = "uploaded";
          fileItem.file = uploadedFile;
          fileItem.id = uploadedFile.id;
          fileItem.collection_name = uploadedFile?.meta?.collection_name || uploadedFile?.collection_name;
          fileItem.url = `${WEBUI_API_BASE_URL}/files/${uploadedFile.id}`;
          files = files;
        } else {
          files = files.filter((item) => item?.itemId !== tempItemId);
        }
      } catch (e) {
        toast.error(`${e}`);
        files = files.filter((item) => item?.itemId !== tempItemId);
      }
    };
    const handleKeyDown = (event) => {
      if (event.key === "Escape") ;
    };
    const onDragOver = (e) => {
      e.preventDefault();
      if (e.dataTransfer?.types?.includes("Files")) ;
    };
    const onDragLeave = () => {
    };
    const onDrop = async (e) => {
      e.preventDefault();
      if (e.dataTransfer?.files && acceptFiles) {
        const inputFiles = Array.from(e.dataTransfer?.files);
        if (inputFiles && inputFiles.length > 0) {
          /* @__PURE__ */ console.log(inputFiles);
          inputFilesHandler(inputFiles);
        }
      }
    };
    onDestroy(() => {
      window.removeEventListener("keydown", handleKeyDown);
      const dropzoneElement = document.getElementById("channel-container");
      if (dropzoneElement) {
        dropzoneElement?.removeEventListener("dragover", onDragOver);
        dropzoneElement?.removeEventListener("drop", onDrop);
        dropzoneElement?.removeEventListener("dragleave", onDragLeave);
      }
    });
    showCommands = ["/"].includes(command?.charAt(0));
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      placeholder,
      id,
      chatInputElement,
      typingUsers,
      inputLoading,
      onSubmit,
      onChange,
      onStop,
      scrollEnd,
      scrollToBottom,
      disabled,
      acceptFiles,
      showFormattingToolbar,
      userSuggestions,
      channelSuggestions,
      replyToMessage,
      typingUsersClassName,
      showCommands,
      setText
    });
  });
}
export {
  MessageInput as M
};
//# sourceMappingURL=MessageInput.js.map
