import { s as store_get, a as attr, o as stringify, c as attr_class, d as clsx, j as escape_html, u as unsubscribe_stores, b as bind_props } from "./index.js";
import { O as shortCodesToEmojis, a as WEBUI_BASE_URL } from "./index2.js";
import { Y as fallback } from "./context.js";
function Emoji($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let shortCode = $$props["shortCode"];
    let className = fallback($$props["className"], "size-4");
    if (store_get($$store_subs ??= {}, "$shortCodesToEmojis", shortCodesToEmojis)[shortCode]) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<img${attr("src", `${stringify(WEBUI_BASE_URL)}/assets/emojis/${stringify(store_get($$store_subs ??= {}, "$shortCodesToEmojis", shortCodesToEmojis)[shortCode].toLowerCase())}.svg`)}${attr("alt", shortCode)}${attr_class(clsx(className))} loading="lazy"/>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div>${escape_html(shortCode)}</div>`);
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { shortCode, className });
  });
}
export {
  Emoji as E
};
//# sourceMappingURL=Emoji.js.map
