import { b as bind_props, j as escape_html, s as store_get, u as unsubscribe_stores } from "./index.js";
import { Z as getContext, Y as fallback } from "./context.js";
import { M as Modal } from "./Modal.js";
import { A as AccessControl } from "./AccessControl.js";
import { X as XMark } from "./XMark.js";
function AccessControlModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let accessControl = fallback($$props["accessControl"], () => ({}), true);
    let accessRoles = fallback($$props["accessRoles"], () => ["read"], true);
    let allowPublic = fallback($$props["allowPublic"], true);
    let onChange = fallback($$props["onChange"], () => {
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        size: "sm",
        get show() {
          return show;
        },
        set show($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div><div class="flex justify-between dark:text-gray-100 px-5 pt-3 pb-1"><div class="text-lg font-medium self-center font-primary">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Access Control"))}</div> <button class="self-center">`);
          XMark($$renderer4, { className: "size-5" });
          $$renderer4.push(`<!----></button></div> <div class="w-full px-5 pb-4 dark:text-white">`);
          AccessControl($$renderer4, {
            onChange,
            accessRoles,
            allowPublic,
            get accessControl() {
              return accessControl;
            },
            set accessControl($$value) {
              accessControl = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----></div></div>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, accessControl, accessRoles, allowPublic, onChange });
  });
}
export {
  AccessControlModal as A
};
//# sourceMappingURL=AccessControlModal.js.map
