
// this file is generated — do not edit it


/// <reference types="@sveltejs/kit" />

/**
 * Environment variables [loaded by Vite](https://vitejs.dev/guide/env-and-mode.html#env-files) from `.env` files and `process.env`. Like [`$env/dynamic/private`](https://svelte.dev/docs/kit/$env-dynamic-private), this module cannot be imported into client-side code. This module only includes variables that _do not_ begin with [`config.kit.env.publicPrefix`](https://svelte.dev/docs/kit/configuration#env) _and do_ start with [`config.kit.env.privatePrefix`](https://svelte.dev/docs/kit/configuration#env) (if configured).
 * 
 * _Unlike_ [`$env/dynamic/private`](https://svelte.dev/docs/kit/$env-dynamic-private), the values exported from this module are statically injected into your bundle at build time, enabling optimisations like dead code elimination.
 * 
 * ```ts
 * import { API_KEY } from '$env/static/private';
 * ```
 * 
 * Note that all environment variables referenced in your code should be declared (for example in an `.env` file), even if they don't have a value until the app is deployed:
 * 
 * ```
 * MY_FEATURE_FLAG=""
 * ```
 * 
 * You can override `.env` values from the command line like so:
 * 
 * ```bash
 * MY_FEATURE_FLAG="enabled" npm run dev
 * ```
 */
declare module '$env/static/private' {
	export const SHELL: string;
	export const npm_command: string;
	export const DEBUG_FFLAGS: string;
	export const BUILDTOOL: string;
	export const NVM_RC_VERSION: string;
	export const npm_config_userconfig: string;
	export const npm_config_cache: string;
	export const SUDO_GID: string;
	export const NVM_INC: string;
	export const NODE: string;
	export const NODE_OPTIONS: string;
	export const PYTHONHASHSEED: string;
	export const TEXTDOMAINDIR: string;
	export const npm_package_engines_npm: string;
	export const COLOR: string;
	export const npm_config_local_prefix: string;
	export const SUDO_COMMAND: string;
	export const SUDO_USER: string;
	export const npm_config_globalconfig: string;
	export const EDITOR: string;
	export const FFLAGS: string;
	export const PWD: string;
	export const SOURCE_DATE_EPOCH: string;
	export const LOGNAME: string;
	export const npm_config_init_module: string;
	export const CXXFLAGS: string;
	export const _: string;
	export const SUDO_HOME: string;
	export const DEBUG_RUSTFLAGS: string;
	export const COMMAND_MODE: string;
	export const LDFLAGS: string;
	export const HOME: string;
	export const LANG: string;
	export const npm_package_version: string;
	export const RUSTFLAGS: string;
	export const INIT_CWD: string;
	export const npm_lifecycle_script: string;
	export const NVM_DIR: string;
	export const npm_config_npm_version: string;
	export const FCFLAGS: string;
	export const MAKEFLAGS: string;
	export const TERM: string;
	export const npm_package_name: string;
	export const npm_config_prefix: string;
	export const USER: string;
	export const npm_lifecycle_event: string;
	export const SHLVL: string;
	export const NVM_CD_FLAGS: string;
	export const npm_config_user_agent: string;
	export const npm_execpath: string;
	export const DEBUGINFOD_URLS: string;
	export const npm_package_json: string;
	export const CHOST: string;
	export const npm_config_noproxy: string;
	export const PATH: string;
	export const npm_config_node_gyp: string;
	export const CFLAGS: string;
	export const SUDO_UID: string;
	export const npm_config_global_prefix: string;
	export const MAIL: string;
	export const NVM_BIN: string;
	export const BUILDTOOLVER: string;
	export const npm_node_execpath: string;
	export const npm_config_engine_strict: string;
	export const OLDPWD: string;
	export const npm_package_engines_node: string;
	export const TEXTDOMAIN: string;
	export const TEST: string;
	export const VITEST: string;
	export const NODE_ENV: string;
	export const PROD: string;
	export const DEV: string;
	export const BASE_URL: string;
	export const MODE: string;
}

/**
 * Similar to [`$env/static/private`](https://svelte.dev/docs/kit/$env-static-private), except that it only includes environment variables that begin with [`config.kit.env.publicPrefix`](https://svelte.dev/docs/kit/configuration#env) (which defaults to `PUBLIC_`), and can therefore safely be exposed to client-side code.
 * 
 * Values are replaced statically at build time.
 * 
 * ```ts
 * import { PUBLIC_BASE_URL } from '$env/static/public';
 * ```
 */
declare module '$env/static/public' {
	
}

/**
 * This module provides access to runtime environment variables, as defined by the platform you're running on. For example if you're using [`adapter-node`](https://github.com/sveltejs/kit/tree/main/packages/adapter-node) (or running [`vite preview`](https://svelte.dev/docs/kit/cli)), this is equivalent to `process.env`. This module only includes variables that _do not_ begin with [`config.kit.env.publicPrefix`](https://svelte.dev/docs/kit/configuration#env) _and do_ start with [`config.kit.env.privatePrefix`](https://svelte.dev/docs/kit/configuration#env) (if configured).
 * 
 * This module cannot be imported into client-side code.
 * 
 * Dynamic environment variables cannot be used during prerendering.
 * 
 * ```ts
 * import { env } from '$env/dynamic/private';
 * console.log(env.DEPLOYMENT_SPECIFIC_VARIABLE);
 * ```
 * 
 * > In `dev`, `$env/dynamic` always includes environment variables from `.env`. In `prod`, this behavior will depend on your adapter.
 */
declare module '$env/dynamic/private' {
	export const env: {
		SHELL: string;
		npm_command: string;
		DEBUG_FFLAGS: string;
		BUILDTOOL: string;
		NVM_RC_VERSION: string;
		npm_config_userconfig: string;
		npm_config_cache: string;
		SUDO_GID: string;
		NVM_INC: string;
		NODE: string;
		NODE_OPTIONS: string;
		PYTHONHASHSEED: string;
		TEXTDOMAINDIR: string;
		npm_package_engines_npm: string;
		COLOR: string;
		npm_config_local_prefix: string;
		SUDO_COMMAND: string;
		SUDO_USER: string;
		npm_config_globalconfig: string;
		EDITOR: string;
		FFLAGS: string;
		PWD: string;
		SOURCE_DATE_EPOCH: string;
		LOGNAME: string;
		npm_config_init_module: string;
		CXXFLAGS: string;
		_: string;
		SUDO_HOME: string;
		DEBUG_RUSTFLAGS: string;
		COMMAND_MODE: string;
		LDFLAGS: string;
		HOME: string;
		LANG: string;
		npm_package_version: string;
		RUSTFLAGS: string;
		INIT_CWD: string;
		npm_lifecycle_script: string;
		NVM_DIR: string;
		npm_config_npm_version: string;
		FCFLAGS: string;
		MAKEFLAGS: string;
		TERM: string;
		npm_package_name: string;
		npm_config_prefix: string;
		USER: string;
		npm_lifecycle_event: string;
		SHLVL: string;
		NVM_CD_FLAGS: string;
		npm_config_user_agent: string;
		npm_execpath: string;
		DEBUGINFOD_URLS: string;
		npm_package_json: string;
		CHOST: string;
		npm_config_noproxy: string;
		PATH: string;
		npm_config_node_gyp: string;
		CFLAGS: string;
		SUDO_UID: string;
		npm_config_global_prefix: string;
		MAIL: string;
		NVM_BIN: string;
		BUILDTOOLVER: string;
		npm_node_execpath: string;
		npm_config_engine_strict: string;
		OLDPWD: string;
		npm_package_engines_node: string;
		TEXTDOMAIN: string;
		TEST: string;
		VITEST: string;
		NODE_ENV: string;
		PROD: string;
		DEV: string;
		BASE_URL: string;
		MODE: string;
		[key: `PUBLIC_${string}`]: undefined;
		[key: `${string}`]: string | undefined;
	}
}

/**
 * Similar to [`$env/dynamic/private`](https://svelte.dev/docs/kit/$env-dynamic-private), but only includes variables that begin with [`config.kit.env.publicPrefix`](https://svelte.dev/docs/kit/configuration#env) (which defaults to `PUBLIC_`), and can therefore safely be exposed to client-side code.
 * 
 * Note that public dynamic environment variables must all be sent from the server to the client, causing larger network requests — when possible, use `$env/static/public` instead.
 * 
 * Dynamic environment variables cannot be used during prerendering.
 * 
 * ```ts
 * import { env } from '$env/dynamic/public';
 * console.log(env.PUBLIC_DEPLOYMENT_SPECIFIC_VARIABLE);
 * ```
 */
declare module '$env/dynamic/public' {
	export const env: {
		[key: `PUBLIC_${string}`]: string | undefined;
	}
}
