import { c as create_ssr_component, b as subscribe, l as getContext, o as onDestroy, g as escape, v as validate_component, a as add_attribute } from "../../../../chunks/ssr.js";
import { W as WEBUI_NAME, n as showSidebar, m as mobile, u as user } from "../../../../chunks/index.js";
import { U as UserMenu } from "../../../../chunks/UserMenu.js";
import { marked } from "marked";
import { a as toast } from "../../../../chunks/Toaster.svelte_svelte_type_style_lang.js";
import "file-saver";
import Fuse from "fuse.js";
import dayjs from "dayjs";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import duration from "dayjs/plugin/duration.js";
import relativeTime from "dayjs/plugin/relativeTime.js";
import { p as page } from "../../../../chunks/stores.js";
import "../../../../chunks/client.js";
import { c as createNewNote, g as getNotes } from "../../../../chunks/index13.js";
import { p as getTimeRange } from "../../../../chunks/index2.js";
import "dompurify";
/* empty css                                                             */
import { S as Spinner } from "../../../../chunks/Spinner.js";
import "dequal";
import "../../../../chunks/create.js";
import { F as FilesOverlay } from "../../../../chunks/FilesOverlay.js";
import { T as Tooltip } from "../../../../chunks/Tooltip.js";
import { S as Sidebar } from "../../../../chunks/Sidebar.js";
const Notes = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_page;
  let $i18n, $$unsubscribe_i18n;
  let $WEBUI_NAME, $$unsubscribe_WEBUI_NAME;
  $$unsubscribe_page = subscribe(page, (value) => value);
  $$unsubscribe_WEBUI_NAME = subscribe(WEBUI_NAME, (value) => $WEBUI_NAME = value);
  dayjs.extend(duration);
  dayjs.extend(relativeTime);
  async function loadLocale(locales) {
    for (const locale of locales) {
      try {
        dayjs.locale(locale);
        break;
      } catch (error) {
        /* @__PURE__ */ console.error(`Could not load locale '${locale}':`, error);
      }
    }
  }
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let noteItems = [];
  let fuse = null;
  const groupNotes = (res) => {
    /* @__PURE__ */ console.log(res);
    if (!Array.isArray(res)) {
      return {};
    }
    const grouped = {};
    for (const note of res) {
      const timeRange = getTimeRange(note.updated_at / 1e9);
      if (!grouped[timeRange]) {
        grouped[timeRange] = [];
      }
      grouped[timeRange].push({ ...note, timeRange });
    }
    return grouped;
  };
  const init = async () => {
    noteItems = await getNotes(localStorage.token, true);
    fuse = new Fuse(noteItems, { keys: ["title"] });
  };
  const inputFilesHandler = async (inputFiles) => {
    for (const file of inputFiles) {
      if (file.type !== "text/markdown") {
        toast.error($i18n.t("Only markdown files are allowed"));
        return;
      }
      const reader = new FileReader();
      reader.onload = async (event) => {
        const content = event.target.result;
        let name = file.name.replace(/\.md$/, "");
        if (typeof content !== "string") {
          toast.error($i18n.t("Invalid file content"));
          return;
        }
        const res = await createNewNote(localStorage.token, {
          title: name,
          data: {
            content: {
              json: null,
              html: marked.parse(content ?? ""),
              md: content
            }
          },
          meta: null,
          access_control: {}
        }).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
        if (res) {
          init();
        }
      };
      reader.readAsText(file);
    }
  };
  let dragged = false;
  const onDragOver = (e) => {
    e.preventDefault();
    if (e.dataTransfer?.types?.includes("Files")) {
      dragged = true;
    } else {
      dragged = false;
    }
  };
  const onDragLeave = () => {
    dragged = false;
  };
  const onDrop = async (e) => {
    e.preventDefault();
    /* @__PURE__ */ console.log(e);
    if (e.dataTransfer?.files) {
      const inputFiles = Array.from(e.dataTransfer?.files);
      if (inputFiles && inputFiles.length > 0) {
        /* @__PURE__ */ console.log(inputFiles);
        inputFilesHandler(inputFiles);
      }
    }
    dragged = false;
  };
  onDestroy(() => {
    /* @__PURE__ */ console.log("destroy");
    const dropzoneElement = document.getElementById("notes-container");
    if (dropzoneElement) {
      dropzoneElement?.removeEventListener("dragover", onDragOver);
      dropzoneElement?.removeEventListener("drop", onDrop);
      dropzoneElement?.removeEventListener("dragleave", onDragLeave);
    }
  });
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      loadLocale($i18n.languages);
    }
    {
      if (fuse) {
        groupNotes(noteItems);
      }
    }
    $$rendered = `${$$result.head += `<!-- HEAD_svelte-16ir3op_START -->${$$result.title = `<title> ${escape($i18n.t("Notes"))} • ${escape($WEBUI_NAME)} </title>`, ""}<!-- HEAD_svelte-16ir3op_END -->`, ""} ${validate_component(FilesOverlay, "FilesOverlay").$$render($$result, { show: dragged }, {}, {})} <div id="notes-container" class="w-full min-h-full h-full">${`<div class="w-full h-full flex justify-center items-center">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</div>`}</div>`;
  } while (!$$settled);
  $$unsubscribe_page();
  $$unsubscribe_i18n();
  $$unsubscribe_WEBUI_NAME();
  return $$rendered;
});
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $showSidebar, $$unsubscribe_showSidebar;
  let $mobile, $$unsubscribe_mobile;
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  $$unsubscribe_showSidebar();
  $$unsubscribe_mobile();
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  return `<div class="${"flex flex-col w-full h-screen max-h-[100dvh] transition-width duration-200 ease-in-out " + escape($showSidebar ? "md:max-w-[calc(100%-260px)]" : "", true) + " max-w-full"}"><nav class="px-2 pt-1.5 backdrop-blur-xl w-full drag-region"><div class="flex items-center">${$mobile ? `<div class="${escape($showSidebar ? "md:hidden" : "", true) + " flex flex-none items-center"}">${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      content: $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar"),
      interactive: true
    },
    {},
    {
      default: () => {
        return `<button id="sidebar-toggle-button" class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition cursor-"><div class="self-center p-1.5">${validate_component(Sidebar, "Sidebar").$$render($$result, {}, {}, {})}</div></button>`;
      }
    }
  )}</div>` : ``} <div class="ml-2 py-0.5 self-center flex items-center justify-between w-full"><div class=""><div class="flex gap-1 scrollbar-none overflow-x-auto w-fit text-center text-sm font-medium bg-transparent py-1 touch-auto pointer-events-auto"><a class="min-w-fit transition" href="/notes">${escape($i18n.t("Notes"))}</a></div></div> <div class="self-center flex items-center gap-1">${$user !== void 0 && $user !== null ? `${validate_component(UserMenu, "UserMenu").$$render(
    $$result,
    {
      className: "max-w-[240px]",
      role: $user?.role,
      help: true
    },
    {},
    {
      default: () => {
        return `<button class="select-none flex rounded-xl p-1.5 w-full hover:bg-gray-50 dark:hover:bg-gray-850 transition" aria-label="User Menu"><div class="self-center"><img${add_attribute("src", $user?.profile_image_url, 0)} class="size-6 object-cover rounded-full" alt="User profile" draggable="false"></div></button>`;
      }
    }
  )}` : ``}</div></div></div></nav> <div class="pb-1 flex-1 max-h-full overflow-y-auto @container">${validate_component(Notes, "Notes").$$render($$result, {}, {}, {})}</div></div>`;
});
export {
  Page as default
};
//# sourceMappingURL=_page.svelte.js.map
