import { Q as AUDIO_API_BASE_URL } from "./index.js";
import { c as create_ssr_component, h as compute_rest_props, b as subscribe, i as spread, j as escape_attribute_value, k as escape_object, a as add_attribute } from "./ssr.js";
import { b as getCtx, c as generateId, s as styleToString, d as getCursorStyle } from "./Drawer.js";
const transcribeAudio = async (token, file, language) => {
  const data = new FormData();
  data.append("file", file);
  if (language) {
    data.append("language", language);
  }
  let error = null;
  const res = await fetch(`${AUDIO_API_BASE_URL}/transcriptions`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      authorization: `Bearer ${token}`
    },
    body: data
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const synthesizeOpenAISpeech = async (token = "", speaker = "alloy", text = "", model) => {
  let error = null;
  const res = await fetch(`${AUDIO_API_BASE_URL}/speech`, {
    method: "POST",
    headers: {
      Authorization: `Bearer ${token}`,
      "Content-Type": "application/json"
    },
    body: JSON.stringify({
      input: text,
      voice: speaker,
      ...model
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const Pane_resizer = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let isDragging;
  let style;
  let attrs;
  let $$restProps = compute_rest_props($$props, ["disabled", "onDraggingChange", "tabIndex", "el", "id", "style"]);
  let $groupId, $$unsubscribe_groupId;
  let $direction, $$unsubscribe_direction;
  let $dragState, $$unsubscribe_dragState;
  let { disabled = false } = $$props;
  let { onDraggingChange = void 0 } = $$props;
  let { tabIndex = 0 } = $$props;
  let { el = null } = $$props;
  let { id: idFromProps = void 0 } = $$props;
  let { style: styleFromProps = void 0 } = $$props;
  const { methods: { registerResizeHandle, startDragging, stopDragging }, states: { direction, dragState, groupId } } = getCtx("PaneResizer");
  $$unsubscribe_direction = subscribe(direction, (value) => $direction = value);
  $$unsubscribe_dragState = subscribe(dragState, (value) => $dragState = value);
  $$unsubscribe_groupId = subscribe(groupId, (value) => $groupId = value);
  const resizeHandleId = generateId(idFromProps);
  if ($$props.disabled === void 0 && $$bindings.disabled && disabled !== void 0) $$bindings.disabled(disabled);
  if ($$props.onDraggingChange === void 0 && $$bindings.onDraggingChange && onDraggingChange !== void 0) $$bindings.onDraggingChange(onDraggingChange);
  if ($$props.tabIndex === void 0 && $$bindings.tabIndex && tabIndex !== void 0) $$bindings.tabIndex(tabIndex);
  if ($$props.el === void 0 && $$bindings.el && el !== void 0) $$bindings.el(el);
  if ($$props.id === void 0 && $$bindings.id && idFromProps !== void 0) $$bindings.id(idFromProps);
  if ($$props.style === void 0 && $$bindings.style && styleFromProps !== void 0) $$bindings.style(styleFromProps);
  isDragging = $dragState?.dragHandleId === resizeHandleId;
  {
    if (disabled) ;
    else {
      registerResizeHandle(resizeHandleId);
    }
  }
  style = styleToString({
    cursor: getCursorStyle($direction),
    "touch-action": "none",
    "user-select": "none",
    "-webkit-user-select": "none",
    "-webkit-touch-callout": "none"
  }) + styleFromProps;
  attrs = {
    "data-direction": $direction,
    "data-pane-group-id": $groupId,
    "data-active": isDragging ? "pointer" : void 0,
    "data-enabled": !disabled,
    "data-pane-resizer-id": resizeHandleId,
    "data-pane-resizer": ""
  };
  $$unsubscribe_groupId();
  $$unsubscribe_direction();
  $$unsubscribe_dragState();
  return `   <div${spread(
    [
      { role: "separator" },
      { style: escape_attribute_value(style) },
      {
        tabindex: escape_attribute_value(tabIndex)
      },
      escape_object(attrs),
      escape_object($$restProps)
    ],
    {}
  )}${add_attribute("this", el, 0)}>${slots.default ? slots.default({}) : ``}</div>`;
});
export {
  Pane_resizer as P,
  synthesizeOpenAISpeech as s,
  transcribeAudio as t
};
//# sourceMappingURL=pane-resizer.js.map
