import { c as create_ssr_component, l as getContext, b as subscribe, p as createEventDispatcher, v as validate_component, g as escape, a as add_attribute, e as each } from "./ssr.js";
import "dequal";
import "./create.js";
import { b as Menu, c as Menu_trigger, M as Menu_content, a as Menu_item } from "./menu-trigger.js";
import { f as flyAndScale } from "./index4.js";
import { o as tags } from "./index.js";
import "./Toaster.svelte_svelte_type_style_lang.js";
import { T as Tooltip } from "./Tooltip.js";
import { X as XMark } from "./XMark.js";
const Dropdown = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { side = "bottom" } = $$props;
  let { align = "start" } = $$props;
  let { closeOnOutsideClick = true } = $$props;
  const dispatch = createEventDispatcher();
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.side === void 0 && $$bindings.side && side !== void 0) $$bindings.side(side);
  if ($$props.align === void 0 && $$bindings.align && align !== void 0) $$bindings.align(align);
  if ($$props.closeOnOutsideClick === void 0 && $$bindings.closeOnOutsideClick && closeOnOutsideClick !== void 0) $$bindings.closeOnOutsideClick(closeOnOutsideClick);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Menu, "DropdownMenu.Root").$$render(
      $$result,
      {
        closeFocus: false,
        closeOnOutsideClick,
        onOpenChange: (state) => {
          dispatch("change", state);
        },
        typeahead: false,
        open: show
      },
      {
        open: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `${validate_component(Menu_trigger, "DropdownMenu.Trigger").$$render($$result, {}, {}, {
            default: () => {
              return `${slots.default ? slots.default({}) : ``}`;
            }
          })} ${slots.content ? slots.content({}) : ` ${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full max-w-[130px] rounded-lg p-1 border border-gray-900 z-50 bg-gray-850 text-white",
              sideOffset: 8,
              side,
              align,
              transition: flyAndScale
            },
            {},
            {
              default: () => {
                return `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex items-center px-3 py-2 text-sm  font-medium"
                  },
                  {},
                  {
                    default: () => {
                      return `<div class="flex items-center">${escape($i18n.t("Profile"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex items-center px-3 py-2 text-sm  font-medium"
                  },
                  {},
                  {
                    default: () => {
                      return `<div class="flex items-center">${escape($i18n.t("Profile"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex items-center px-3 py-2 text-sm  font-medium"
                  },
                  {},
                  {
                    default: () => {
                      return `<div class="flex items-center">${escape($i18n.t("Profile"))}</div>`;
                    }
                  }
                )}`;
              }
            }
          )} `}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const TagInput = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $$unsubscribe_tags;
  $$unsubscribe_tags = subscribe(tags, (value) => value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { label = "" } = $$props;
  let showTagInput = false;
  if ($$props.label === void 0 && $$bindings.label && label !== void 0) $$bindings.label(label);
  $$unsubscribe_i18n();
  $$unsubscribe_tags();
  return `<div class="${"px-0.5 flex " + escape("", true)}">${``} <button class="cursor-pointer self-center p-0.5 flex h-fit items-center rounded-full transition border dark:border-gray-600 border-dashed" type="button"${add_attribute("aria-label", $i18n.t("Add Tag"), 0)}><div class="m-auto self-center"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" aria-hidden="true" fill="currentColor" class="${"size-2.5 " + escape("", true) + " transition-all transform"}"><path d="M8.75 3.75a.75.75 0 0 0-1.5 0v3.5h-3.5a.75.75 0 0 0 0 1.5h3.5v3.5a.75.75 0 0 0 1.5 0v-3.5h3.5a.75.75 0 0 0 0-1.5h-3.5v-3.5Z"></path></svg></div></button> ${label && !showTagInput ? `<span class="text-xs pl-2 self-center">${escape(label)}</span>` : ``}</div>`;
});
const TagItem = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { tag } = $$props;
  let { onDelete = () => {
  } } = $$props;
  if ($$props.tag === void 0 && $$bindings.tag && tag !== void 0) $$bindings.tag(tag);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  $$unsubscribe_i18n();
  return `${tag ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: tag.name }, {}, {
    default: () => {
      return `<button${add_attribute("aria-label", $i18n.t("Remove this tag from list"), 0)} class="relative group/tags px-1.5 py-[0.5px] gap-0.5 flex justify-between h-fit max-h-fit w-fit items-center rounded-lg bg-gray-500/20 text-gray-700 dark:text-gray-200 transition cursor-pointer"><div class="text-[0.7rem] font-medium self-center line-clamp-1 w-fit">${escape(tag.name)}</div> <div class="hidden group-hover/tags:block transition"><div class="rounded-full pl-[1px] backdrop-blur-sm h-full flex self-center cursor-pointer">${validate_component(XMark, "XMark").$$render($$result, { className: "size-3", strokeWidth: "2.5" }, {}, {})}</div></div></button>`;
    }
  })}` : ``}`;
});
const TagList = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  const dispatch = createEventDispatcher();
  let { tags: tags2 = [] } = $$props;
  if ($$props.tags === void 0 && $$bindings.tags && tags2 !== void 0) $$bindings.tags(tags2);
  return `${each(tags2, (tag) => {
    return `${validate_component(TagItem, "TagItem").$$render(
      $$result,
      {
        tag,
        onDelete: () => {
          dispatch("delete", tag.name);
        }
      },
      {},
      {}
    )}`;
  })}`;
});
const Tags = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { tags: tags2 = [] } = $$props;
  if ($$props.tags === void 0 && $$bindings.tags && tags2 !== void 0) $$bindings.tags(tags2);
  $$unsubscribe_i18n();
  return `<ul class="flex flex-row flex-wrap gap-[0.3rem] line-clamp-1">${validate_component(TagList, "TagList").$$render($$result, { tags: tags2 }, {}, {})} ${validate_component(TagInput, "TagInput").$$render(
    $$result,
    {
      label: tags2.length == 0 ? $i18n.t("Add Tags") : ""
    },
    {},
    {}
  )}</ul>`;
});
export {
  Dropdown as D,
  Tags as T
};
//# sourceMappingURL=Tags.js.map
