import { c as create_ssr_component, b as subscribe, l as getContext, a as add_attribute, g as escape } from "./ssr.js";
import { a as settings } from "./index.js";
const SensitiveInput = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $settings, $$unsubscribe_settings;
  $$unsubscribe_settings = subscribe(settings, (value2) => $settings = value2);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value2) => $i18n = value2);
  let { id = "password-input" } = $$props;
  let { value = "" } = $$props;
  let { placeholder = "" } = $$props;
  let { type = "text" } = $$props;
  let { required = true } = $$props;
  let { readOnly = false } = $$props;
  let { outerClassName = "flex flex-1 bg-transparent" } = $$props;
  let { inputClassName = "w-full text-sm py-0.5 bg-transparent" } = $$props;
  let { showButtonClassName = "pl-1.5  transition bg-transparent" } = $$props;
  let show = false;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.value === void 0 && $$bindings.value && value !== void 0) $$bindings.value(value);
  if ($$props.placeholder === void 0 && $$bindings.placeholder && placeholder !== void 0) $$bindings.placeholder(placeholder);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.required === void 0 && $$bindings.required && required !== void 0) $$bindings.required(required);
  if ($$props.readOnly === void 0 && $$bindings.readOnly && readOnly !== void 0) $$bindings.readOnly(readOnly);
  if ($$props.outerClassName === void 0 && $$bindings.outerClassName && outerClassName !== void 0) $$bindings.outerClassName(outerClassName);
  if ($$props.inputClassName === void 0 && $$bindings.inputClassName && inputClassName !== void 0) $$bindings.inputClassName(inputClassName);
  if ($$props.showButtonClassName === void 0 && $$bindings.showButtonClassName && showButtonClassName !== void 0) $$bindings.showButtonClassName(showButtonClassName);
  $$unsubscribe_i18n();
  $$unsubscribe_settings();
  return `<div${add_attribute("class", outerClassName, 0)}><label class="sr-only"${add_attribute("for", id, 0)}>${escape(placeholder || $i18n.t("Password"))}</label> <input${add_attribute("id", id, 0)}${add_attribute(
    "class",
    `${inputClassName} ${"password"} ${$settings?.highContrastMode ?? false ? "placeholder:text-gray-700 dark:placeholder:text-gray-100" : " outline-hidden placeholder:text-gray-300 dark:placeholder:text-gray-600"}`,
    0
  )}${add_attribute("placeholder", placeholder, 0)}${add_attribute("type", type === "password" && !show ? "password" : "text", 0)}${add_attribute("value", value, 0)} ${required && !readOnly ? "required" : ""} ${readOnly ? "disabled" : ""} autocomplete="off"> <button${add_attribute("class", showButtonClassName, 0)} type="button"${add_attribute("aria-pressed", show, 0)}${add_attribute("aria-label", $i18n.t("Make password visible in the user interface"), 0)}>${`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-4" aria-hidden="true"><path d="M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z"></path><path fill-rule="evenodd" d="M1.38 8.28a.87.87 0 0 1 0-.566 7.003 7.003 0 0 1 13.238.006.87.87 0 0 1 0 .566A7.003 7.003 0 0 1 1.379 8.28ZM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" clip-rule="evenodd"></path></svg>`}</button></div>`;
});
export {
  SensitiveInput as S
};
//# sourceMappingURL=SensitiveInput.js.map
