import { c as create_ssr_component, a as add_attribute, l as getContext, b as subscribe, v as validate_component, g as escape, p as createEventDispatcher, o as onDestroy } from "./ssr.js";
import { t as tick } from "./ssr2.js";
import { marked } from "marked";
import TurndownService from "turndown";
import { gfm } from "@joplin/turndown-plugin-gfm";
import { DOMParser, Fragment } from "prosemirror-model";
import { Plugin, PluginKey, Selection, TextSelection } from "prosemirror-state";
import { DecorationSet, Decoration } from "prosemirror-view";
import { Extension } from "@tiptap/core";
import { l as listDragHandlePlugin } from "./Drawer.svelte_svelte_type_style_lang.js";
import "@tiptap/starter-kit";
import "@tiptap/extension-table";
import "@tiptap/extension-list";
import "@tiptap/extensions";
import "@tiptap/extension-file-handler";
import "@tiptap/extension-typography";
import "@tiptap/extension-highlight";
import "@tiptap/extension-code-block-lowlight";
import "@tiptap/extension-mention";
import { T as Tooltip } from "./Tooltip.js";
import { createLowlight } from "lowlight";
import hljs from "highlight.js";
const Bold = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linejoin="round" d="M6.75 3.744h-.753v8.25h7.125a4.125 4.125 0 0 0 0-8.25H6.75Zm0 0v.38m0 16.122h6.747a4.5 4.5 0 0 0 0-9.001h-7.5v9h.753Zm0 0v-.37m0-15.751h6a3.75 3.75 0 1 1 0 7.5h-6m0-7.5v7.5m0 0v8.25m0-8.25h6.375a4.125 4.125 0 0 1 0 8.25H6.75m.747-15.38h4.875a3.375 3.375 0 0 1 0 6.75H7.497v-6.75Zm0 7.5h5.25a3.75 3.75 0 0 1 0 7.5h-5.25v-7.5Z"></path></svg>`;
});
const CodeBracket = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M17.25 6.75 22.5 12l-5.25 5.25m-10.5 0L1.5 12l5.25-5.25m7.5-3-4.5 16.5"></path></svg>`;
});
const H1 = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M2.243 4.493v7.5m0 0v7.502m0-7.501h10.5m0-7.5v7.5m0 0v7.501m4.501-8.627 2.25-1.5v10.126m0 0h-2.25m2.25 0h2.25"></path></svg>`;
});
const H2 = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M21.75 19.5H16.5v-1.609a2.25 2.25 0 0 1 1.244-2.012l2.89-1.445c.651-.326 1.116-.955 1.116-1.683 0-.498-.04-.987-.118-1.463-.135-.825-.835-1.422-1.668-1.489a15.202 15.202 0 0 0-3.464.12M2.243 4.492v7.5m0 0v7.502m0-7.501h10.5m0-7.5v7.5m0 0v7.501"></path></svg>`;
});
const H3 = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M20.905 14.626a4.52 4.52 0 0 1 .738 3.603c-.154.695-.794 1.143-1.504 1.208a15.194 15.194 0 0 1-3.639-.104m4.405-4.707a4.52 4.52 0 0 0 .738-3.603c-.154-.696-.794-1.144-1.504-1.209a15.19 15.19 0 0 0-3.639.104m4.405 4.708H18M2.243 4.493v7.5m0 0v7.502m0-7.501h10.5m0-7.5v7.5m0 0v7.501"></path></svg>`;
});
const Italic = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M5.248 20.246H9.05m0 0h3.696m-3.696 0 5.893-16.502m0 0h-3.697m3.697 0h3.803"></path></svg>`;
});
const ListBullet = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M8.25 6.75h12M8.25 12h12m-12 5.25h12M3.75 6.75h.007v.008H3.75V6.75Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0ZM3.75 12h.007v.008H3.75V12Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm-.375 5.25h.007v.008H3.75v-.008Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z"></path></svg>`;
});
const NumberedList = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M8.242 5.992h12m-12 6.003H20.24m-12 5.999h12M4.117 7.495v-3.75H2.99m1.125 3.75H2.99m1.125 0H5.24m-1.92 2.577a1.125 1.125 0 1 1 1.591 1.59l-1.83 1.83h2.16M2.99 15.745h1.125a1.125 1.125 0 0 1 0 2.25H3.74m0-.002h.375a1.125 1.125 0 0 1 0 2.25H2.99"></path></svg>`;
});
const Strikethrough = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M12 12a8.912 8.912 0 0 1-.318-.079c-1.585-.424-2.904-1.247-3.76-2.236-.873-1.009-1.265-2.19-.968-3.301.59-2.2 3.663-3.29 6.863-2.432A8.186 8.186 0 0 1 16.5 5.21M6.42 17.81c.857.99 2.176 1.812 3.761 2.237 3.2.858 6.274-.23 6.863-2.431.233-.868.044-1.779-.465-2.617M3.75 12h16.5"></path></svg>`;
});
const Underline = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M17.995 3.744v7.5a6 6 0 1 1-12 0v-7.5m-2.25 16.502h16.5"></path></svg>`;
});
const CheckBox = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M3 20.4V3.6C3 3.26863 3.26863 3 3.6 3H20.4C20.7314 3 21 3.26863 21 3.6V20.4C21 20.7314 20.7314 21 20.4 21H3.6C3.26863 21 3 20.7314 3 20.4Z" stroke-width="1.5"></path><path d="M7 12.5L10 15.5L17 8.5" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const ArrowLeftTag = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M16.75 12H6.75M6.75 12L9.5 14.75M6.75 12L9.5 9.25" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2 15V9C2 6.79086 3.79086 5 6 5H18C20.2091 5 22 6.79086 22 9V15C22 17.2091 20.2091 19 18 19H6C3.79086 19 2 17.2091 2 15Z"></path></svg>`;
});
const ArrowRightTag = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M6.75 12H16.75M16.75 12L14 14.75M16.75 12L14 9.25" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2 15V9C2 6.79086 3.79086 5 6 5H18C20.2091 5 22 6.79086 22 9V15C22 17.2091 20.2091 19 18 19H6C3.79086 19 2 17.2091 2 15Z"></path></svg>`;
});
const FormattingButtons = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { editor = null } = $$props;
  if ($$props.editor === void 0 && $$bindings.editor && editor !== void 0) $$bindings.editor(editor);
  $$unsubscribe_i18n();
  return `<div class="flex gap-0.5 p-0.5 rounded-xl shadow-lg bg-white text-gray-800 dark:text-white dark:bg-gray-850 min-w-fit border border-gray-100 dark:border-gray-800">${validate_component(Tooltip, "Tooltip").$$render($$result, { placement: "top", content: $i18n.t("H1") }, {}, {
    default: () => {
      return `<button class="${escape(
        editor?.isActive("heading", { level: 1 }) ? "bg-gray-50 dark:bg-gray-700" : "",
        true
      ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(H1, "H1").$$render($$result, {}, {}, {})}</button>`;
    }
  })} ${validate_component(Tooltip, "Tooltip").$$render($$result, { placement: "top", content: $i18n.t("H2") }, {}, {
    default: () => {
      return `<button class="${escape(
        editor?.isActive("heading", { level: 2 }) ? "bg-gray-50 dark:bg-gray-700" : "",
        true
      ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(H2, "H2").$$render($$result, {}, {}, {})}</button>`;
    }
  })} ${validate_component(Tooltip, "Tooltip").$$render($$result, { placement: "top", content: $i18n.t("H3") }, {}, {
    default: () => {
      return `<button class="${escape(
        editor?.isActive("heading", { level: 3 }) ? "bg-gray-50 dark:bg-gray-700" : "",
        true
      ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(H3, "H3").$$render($$result, {}, {}, {})}</button>`;
    }
  })} ${editor?.isActive("bulletList") || editor?.isActive("orderedList") || editor?.isActive("taskList") ? `${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Lift List")
    },
    {},
    {
      default: () => {
        return `<button class="hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all" type="button">${validate_component(ArrowLeftTag, "ArrowLeftTag").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Sink List")
    },
    {},
    {
      default: () => {
        return `<button class="hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all" type="button">${validate_component(ArrowRightTag, "ArrowRightTag").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )}` : ``} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Bullet List")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("bulletList") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(ListBullet, "ListBullet").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Ordered List")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("orderedList") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(NumberedList, "NumberedList").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Task List")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("taskList") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(CheckBox, "CheckBox").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Bold")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("bold") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(Bold, "Bold").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Italic")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("italic") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(Italic, "Italic").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Underline")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("underline") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(Underline, "Underline").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Strikethrough")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("strike") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(Strikethrough, "Strikethrough").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )} ${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      placement: "top",
      content: $i18n.t("Code Block")
    },
    {},
    {
      default: () => {
        return `<button class="${escape(
          editor?.isActive("codeBlock") ? "bg-gray-50 dark:bg-gray-700" : "",
          true
        ) + " hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg p-1.5 transition-all"}" type="button">${validate_component(CodeBracket, "CodeBracket").$$render($$result, {}, {}, {})}</button>`;
      }
    }
  )}</div>`;
});
function getWordBoundsAtPos(doc, pos) {
  const resolvedPos = doc.resolve(pos);
  const textBlock = resolvedPos.parent;
  const paraStart = resolvedPos.start();
  const text = textBlock.textContent;
  const offset = resolvedPos.parentOffset;
  let wordStart = offset, wordEnd = offset;
  while (wordStart > 0 && !/\s/.test(text[wordStart - 1])) wordStart--;
  while (wordEnd < text.length && !/\s/.test(text[wordEnd])) wordEnd++;
  return {
    start: paraStart + wordStart,
    end: paraStart + wordEnd
  };
}
function findNextTemplate(doc, from = 0) {
  const patterns = [{ start: "{{", end: "}}" }];
  let result = null;
  doc.nodesBetween(from, doc.content.size, (node, pos) => {
    if (result) return false;
    if (node.isText) {
      const text = node.text;
      let index = Math.max(0, from - pos);
      while (index < text.length) {
        for (const pattern of patterns) {
          if (text.startsWith(pattern.start, index)) {
            const endIndex = text.indexOf(pattern.end, index + pattern.start.length);
            if (endIndex !== -1) {
              result = {
                from: pos + index,
                to: pos + endIndex + pattern.end.length
              };
              return false;
            }
          }
        }
        index++;
      }
    }
  });
  return result;
}
const RichTextInput = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  marked.use({
    breaks: true,
    gfm: true,
    renderer: {
      list(body, ordered, start) {
        const isTaskList = body.includes("data-checked=");
        if (isTaskList) {
          return `<ul data-type="taskList">${body}</ul>`;
        }
        const type = ordered ? "ol" : "ul";
        const startatt = ordered && start !== 1 ? ` start="${start}"` : "";
        return `<${type}${startatt}>${body}</${type}>`;
      },
      listitem(text, task, checked) {
        if (task) {
          const checkedAttr = checked ? "true" : "false";
          return `<li data-type="taskItem" data-checked="${checkedAttr}">${text}</li>`;
        }
        return `<li>${text}</li>`;
      }
    }
  });
  const turndownService = new TurndownService({
    codeBlockStyle: "fenced",
    headingStyle: "atx"
  });
  turndownService.escape = (string) => string;
  turndownService.use(gfm);
  turndownService.addRule("tableHeaders", {
    filter: "th",
    replacement(content2, node) {
      return content2;
    }
  });
  turndownService.addRule("tables", {
    filter: "table",
    replacement(content2, node) {
      const rows = Array.from(node.querySelectorAll("tr"));
      if (rows.length === 0) return content2;
      let markdown = "\n";
      rows.forEach((row, rowIndex) => {
        const cells = Array.from(row.querySelectorAll("th, td"));
        const cellContents = cells.map((cell) => {
          let cellContent = turndownService.turndown(cell.innerHTML).trim();
          cellContent = cellContent.replace(/^\n+|\n+$/g, "");
          return cellContent;
        });
        markdown += "| " + cellContents.join(" | ") + " |\n";
        if (rowIndex === 0) {
          const separator = cells.map(() => "---").join(" | ");
          markdown += "| " + separator + " |\n";
        }
      });
      return markdown + "\n";
    }
  });
  turndownService.addRule("taskListItems", {
    filter: (node) => node.nodeName === "LI" && (node.getAttribute("data-checked") === "true" || node.getAttribute("data-checked") === "false"),
    replacement(content2, node) {
      const checked = node.getAttribute("data-checked") === "true";
      content2 = content2.replace(/^\s+/, "");
      return `- [${checked ? "x" : " "}] ${content2}
`;
    }
  });
  turndownService.addRule("mentions", {
    filter: (node) => node.nodeName === "SPAN" && node.getAttribute("data-type") === "mention",
    replacement: (_content, node) => {
      const id2 = node.getAttribute("data-id") || "";
      const ch = node.getAttribute("data-mention-suggestion-char") || "@";
      return `<${ch}${id2}>`;
    }
  });
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value2) => $i18n = value2);
  createEventDispatcher();
  let { oncompositionstart = (e) => {
  } } = $$props;
  let { oncompositionend = (e) => {
  } } = $$props;
  let { onChange = (e) => {
  } } = $$props;
  createLowlight(hljs.listLanguages().reduce(
    (obj, lang) => {
      obj[lang] = () => hljs.getLanguage(lang);
      return obj;
    },
    {}
  ));
  let { editor = null } = $$props;
  let { socket = null } = $$props;
  let { user = null } = $$props;
  let { files = [] } = $$props;
  let { documentId = "" } = $$props;
  let { className = "input-prose" } = $$props;
  let { placeholder = $i18n.t("Type here...") } = $$props;
  let _placeholder = placeholder;
  const setPlaceholder = () => {
    _placeholder = placeholder;
    if (editor) {
      editor?.view.dispatch(editor.state.tr);
    }
  };
  let { richText = true } = $$props;
  let { dragHandle = false } = $$props;
  let { link = false } = $$props;
  let { image = false } = $$props;
  let { fileHandler = false } = $$props;
  let { suggestions = null } = $$props;
  let { onFileDrop = (currentEditor, files2, pos) => {
    files2.forEach((file) => {
      const fileReader = new FileReader();
      fileReader.readAsDataURL(file);
      fileReader.onload = () => {
        currentEditor.chain().insertContentAt(pos, {
          type: "image",
          attrs: { src: fileReader.result }
        }).focus().run();
      };
    });
  } } = $$props;
  let { onFilePaste = (currentEditor, files2, htmlContent) => {
    files2.forEach((file) => {
      if (htmlContent) {
        /* @__PURE__ */ console.log(htmlContent);
        return false;
      }
      const fileReader = new FileReader();
      fileReader.readAsDataURL(file);
      fileReader.onload = () => {
        currentEditor.chain().insertContentAt(currentEditor.state.selection.anchor, {
          type: "image",
          attrs: { src: fileReader.result }
        }).focus().run();
      };
    });
  } } = $$props;
  let { onSelectionUpdate = (e) => {
  } } = $$props;
  let { id = "" } = $$props;
  let { value = "" } = $$props;
  let { html = "" } = $$props;
  let { json = false } = $$props;
  let { raw = false } = $$props;
  let { editable = true } = $$props;
  let { collaboration = false } = $$props;
  let { showFormattingToolbar = true } = $$props;
  let { preserveBreaks = false } = $$props;
  let { generateAutoCompletion = async () => null } = $$props;
  let { autocomplete = false } = $$props;
  let { messageInput = false } = $$props;
  let { shiftEnter = false } = $$props;
  let { largeTextAsFile = false } = $$props;
  let { insertPromptAsRichText = false } = $$props;
  let { floatingMenuPlacement = "bottom-start" } = $$props;
  let floatingMenuElement = null;
  let bubbleMenuElement = null;
  let element = null;
  const getWordAtDocPos = () => {
    if (!editor) return "";
    const { state } = editor.view;
    const pos = state.selection.from;
    const doc = state.doc;
    const resolvedPos = doc.resolve(pos);
    const textBlock = resolvedPos.parent;
    resolvedPos.start();
    const text = textBlock.textContent;
    const offset = resolvedPos.parentOffset;
    let wordStart = offset, wordEnd = offset;
    while (wordStart > 0 && !/\s/.test(text[wordStart - 1])) wordStart--;
    while (wordEnd < text.length && !/\s/.test(text[wordEnd])) wordEnd++;
    const word = text.slice(wordStart, wordEnd);
    return word;
  };
  const replaceCommandWithText = async (text) => {
    const { state, dispatch } = editor.view;
    const { selection } = state;
    const pos = selection.from;
    const { start, end } = getWordBoundsAtPos(state.doc, pos);
    let tr = state.tr;
    if (insertPromptAsRichText) {
      const htmlContent = marked.parse(text, { breaks: true, gfm: true }).trim();
      const tempDiv = document.createElement("div");
      tempDiv.innerHTML = htmlContent;
      const fragment = DOMParser.fromSchema(state.schema).parse(tempDiv);
      const content2 = fragment.content;
      let nodesToInsert = [];
      content2.forEach((node) => {
        if (node.type.name === "paragraph") {
          nodesToInsert.push(...node.content.content);
        } else {
          nodesToInsert.push(node);
        }
      });
      tr = tr.replaceWith(start, end, nodesToInsert);
      const newPos = start + nodesToInsert.reduce((sum, node) => sum + node.nodeSize, 0);
      tr = tr.setSelection(Selection.near(tr.doc.resolve(newPos)));
    } else {
      if (text.includes("\n")) {
        const lines = text.split("\n");
        const nodes = lines.map((line, index) => index === 0 ? state.schema.text(line ? line : []) : state.schema.nodes.paragraph.create({}, line ? state.schema.text(line) : void 0));
        tr = tr.replaceWith(start, end, nodes);
        let newSelectionPos;
        let lastPos = start;
        for (let i = 0; i < nodes.length; i++) {
          lastPos += nodes[i].nodeSize;
        }
        newSelectionPos = lastPos;
        tr = tr.setSelection(TextSelection.near(tr.doc.resolve(newSelectionPos)));
      } else {
        tr = tr.replaceWith(
          start,
          end,
          // replace this range
          text !== "" ? state.schema.text(text) : []
        );
        tr = tr.setSelection(state.selection.constructor.near(tr.doc.resolve(start + text.length + 1)));
      }
    }
    dispatch(tr);
    await tick();
  };
  const setText = (text) => {
    if (!editor) return;
    text = text.replaceAll("\n\n", "\n");
    editor.commands.clearContent();
    const { state, view } = editor;
    const { schema, tr } = state;
    if (text.includes("\n")) {
      const lines = text.split("\n");
      const nodes = lines.map((line) => schema.nodes.paragraph.create({}, line ? schema.text(line) : void 0));
      const fragment = Fragment.fromArray(nodes);
      tr.replaceSelectionWith(fragment, false);
      view.dispatch(tr);
    } else if (text === "") {
      editor.commands.clearContent();
    } else {
      const paragraph = schema.nodes.paragraph.create({}, schema.text(text));
      tr.replaceSelectionWith(paragraph, false);
      view.dispatch(tr);
    }
    selectNextTemplate(editor.view.state, editor.view.dispatch);
    focus();
  };
  const insertContent = (content2) => {
    if (!editor) return;
    const htmlContent = marked.parse(content2);
    editor.commands.insertContent(htmlContent);
    focus();
  };
  const replaceVariables = (variables) => {
    if (!editor) return;
    const { state, view } = editor;
    const { doc } = state;
    let tr = state.tr;
    const replacements = [];
    doc.descendants((node, pos) => {
      if (node.isText && node.text) {
        const text = node.text;
        const replacedText = text.replace(/{{\s*([^|}]+)(?:\|[^}]*)?\s*}}/g, (match, varName) => {
          const trimmedVarName = varName.trim();
          return variables.hasOwnProperty(trimmedVarName) ? String(variables[trimmedVarName]) : match;
        });
        if (replacedText !== text) {
          replacements.push({
            from: pos,
            to: pos + text.length,
            text: replacedText
          });
        }
      }
    });
    replacements.reverse().forEach(({ from, to, text }) => {
      tr = tr.replaceWith(from, to, text !== "" ? state.schema.text(text) : []);
    });
    if (replacements.length > 0) {
      view.dispatch(tr);
    }
  };
  const focus = () => {
    if (editor) {
      try {
        editor.view?.focus();
        editor.view?.dispatch(editor.view.state.tr.scrollIntoView());
      } catch (e) {
        console.warn("Error focusing editor", e);
      }
    }
  };
  function selectNextTemplate(state, dispatch) {
    const { doc, selection } = state;
    const from = selection.to;
    let template = findNextTemplate(doc, from);
    if (!template) {
      template = findNextTemplate(doc, 0);
    }
    if (template) {
      if (dispatch) {
        const tr = state.tr.setSelection(TextSelection.create(doc, template.from, template.to));
        dispatch(tr);
        dispatch(tr.scrollIntoView().setMeta("preventScroll", true));
      }
      return true;
    }
    return false;
  }
  const setContent = (content2) => {
    editor.commands.setContent(content2);
  };
  const selectTemplate = () => {
    if (value !== "") {
      setTimeout(
        () => {
          const templateFound = selectNextTemplate(editor.view.state, editor.view.dispatch);
          if (!templateFound) {
            editor.commands.focus("end");
          }
        },
        0
      );
    }
  };
  Extension.create({
    name: "selectionDecoration",
    addProseMirrorPlugins() {
      return [
        new Plugin({
          key: new PluginKey("selection"),
          props: {
            decorations: (state) => {
              const { selection } = state;
              const { focused } = this.editor;
              if (focused || selection.empty) {
                return null;
              }
              return DecorationSet.create(state.doc, [
                Decoration.inline(selection.from, selection.to, { class: "editor-selection" })
              ]);
            }
          }
        })
      ];
    }
  });
  Extension.create({
    name: "listItemDragHandle",
    addProseMirrorPlugins() {
      return [
        listDragHandlePlugin({
          itemTypeNames: ["listItem", "taskItem"],
          getEditor: () => this.editor
        })
      ];
    }
  });
  onDestroy(() => {
    if (editor) {
      editor.destroy();
    }
  });
  const onValueChange = () => {
    if (!editor) return;
    const jsonValue2 = editor.getJSON();
    const htmlValue2 = editor.getHTML();
    let mdValue2 = turndownService.turndown((preserveBreaks ? htmlValue2.replace(/<p><\/p>/g, "<br/>") : htmlValue2).replace(/ {2,}/g, (m) => m.replace(/ /g, " "))).replace(/\u00a0/g, " ");
    if (value === "") {
      editor.commands.clearContent();
      selectTemplate();
      return;
    }
    if (json) {
      if (JSON.stringify(value) !== JSON.stringify(jsonValue2)) {
        editor.commands.setContent(value);
        selectTemplate();
      }
    } else {
      if (raw) {
        if (value !== htmlValue2) {
          editor.commands.setContent(value);
          selectTemplate();
        }
      } else {
        if (value !== mdValue2) {
          editor.commands.setContent(preserveBreaks ? value : marked.parse(
            value.replaceAll(
              `
<br/>`,
              `<br/>`
            ),
            { breaks: false }
          ));
          selectTemplate();
        }
      }
    }
  };
  if ($$props.oncompositionstart === void 0 && $$bindings.oncompositionstart && oncompositionstart !== void 0) $$bindings.oncompositionstart(oncompositionstart);
  if ($$props.oncompositionend === void 0 && $$bindings.oncompositionend && oncompositionend !== void 0) $$bindings.oncompositionend(oncompositionend);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  if ($$props.editor === void 0 && $$bindings.editor && editor !== void 0) $$bindings.editor(editor);
  if ($$props.socket === void 0 && $$bindings.socket && socket !== void 0) $$bindings.socket(socket);
  if ($$props.user === void 0 && $$bindings.user && user !== void 0) $$bindings.user(user);
  if ($$props.files === void 0 && $$bindings.files && files !== void 0) $$bindings.files(files);
  if ($$props.documentId === void 0 && $$bindings.documentId && documentId !== void 0) $$bindings.documentId(documentId);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.placeholder === void 0 && $$bindings.placeholder && placeholder !== void 0) $$bindings.placeholder(placeholder);
  if ($$props.richText === void 0 && $$bindings.richText && richText !== void 0) $$bindings.richText(richText);
  if ($$props.dragHandle === void 0 && $$bindings.dragHandle && dragHandle !== void 0) $$bindings.dragHandle(dragHandle);
  if ($$props.link === void 0 && $$bindings.link && link !== void 0) $$bindings.link(link);
  if ($$props.image === void 0 && $$bindings.image && image !== void 0) $$bindings.image(image);
  if ($$props.fileHandler === void 0 && $$bindings.fileHandler && fileHandler !== void 0) $$bindings.fileHandler(fileHandler);
  if ($$props.suggestions === void 0 && $$bindings.suggestions && suggestions !== void 0) $$bindings.suggestions(suggestions);
  if ($$props.onFileDrop === void 0 && $$bindings.onFileDrop && onFileDrop !== void 0) $$bindings.onFileDrop(onFileDrop);
  if ($$props.onFilePaste === void 0 && $$bindings.onFilePaste && onFilePaste !== void 0) $$bindings.onFilePaste(onFilePaste);
  if ($$props.onSelectionUpdate === void 0 && $$bindings.onSelectionUpdate && onSelectionUpdate !== void 0) $$bindings.onSelectionUpdate(onSelectionUpdate);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.value === void 0 && $$bindings.value && value !== void 0) $$bindings.value(value);
  if ($$props.html === void 0 && $$bindings.html && html !== void 0) $$bindings.html(html);
  if ($$props.json === void 0 && $$bindings.json && json !== void 0) $$bindings.json(json);
  if ($$props.raw === void 0 && $$bindings.raw && raw !== void 0) $$bindings.raw(raw);
  if ($$props.editable === void 0 && $$bindings.editable && editable !== void 0) $$bindings.editable(editable);
  if ($$props.collaboration === void 0 && $$bindings.collaboration && collaboration !== void 0) $$bindings.collaboration(collaboration);
  if ($$props.showFormattingToolbar === void 0 && $$bindings.showFormattingToolbar && showFormattingToolbar !== void 0) $$bindings.showFormattingToolbar(showFormattingToolbar);
  if ($$props.preserveBreaks === void 0 && $$bindings.preserveBreaks && preserveBreaks !== void 0) $$bindings.preserveBreaks(preserveBreaks);
  if ($$props.generateAutoCompletion === void 0 && $$bindings.generateAutoCompletion && generateAutoCompletion !== void 0) $$bindings.generateAutoCompletion(generateAutoCompletion);
  if ($$props.autocomplete === void 0 && $$bindings.autocomplete && autocomplete !== void 0) $$bindings.autocomplete(autocomplete);
  if ($$props.messageInput === void 0 && $$bindings.messageInput && messageInput !== void 0) $$bindings.messageInput(messageInput);
  if ($$props.shiftEnter === void 0 && $$bindings.shiftEnter && shiftEnter !== void 0) $$bindings.shiftEnter(shiftEnter);
  if ($$props.largeTextAsFile === void 0 && $$bindings.largeTextAsFile && largeTextAsFile !== void 0) $$bindings.largeTextAsFile(largeTextAsFile);
  if ($$props.insertPromptAsRichText === void 0 && $$bindings.insertPromptAsRichText && insertPromptAsRichText !== void 0) $$bindings.insertPromptAsRichText(insertPromptAsRichText);
  if ($$props.floatingMenuPlacement === void 0 && $$bindings.floatingMenuPlacement && floatingMenuPlacement !== void 0) $$bindings.floatingMenuPlacement(floatingMenuPlacement);
  if ($$props.getWordAtDocPos === void 0 && $$bindings.getWordAtDocPos && getWordAtDocPos !== void 0) $$bindings.getWordAtDocPos(getWordAtDocPos);
  if ($$props.replaceCommandWithText === void 0 && $$bindings.replaceCommandWithText && replaceCommandWithText !== void 0) $$bindings.replaceCommandWithText(replaceCommandWithText);
  if ($$props.setText === void 0 && $$bindings.setText && setText !== void 0) $$bindings.setText(setText);
  if ($$props.insertContent === void 0 && $$bindings.insertContent && insertContent !== void 0) $$bindings.insertContent(insertContent);
  if ($$props.replaceVariables === void 0 && $$bindings.replaceVariables && replaceVariables !== void 0) $$bindings.replaceVariables(replaceVariables);
  if ($$props.focus === void 0 && $$bindings.focus && focus !== void 0) $$bindings.focus(focus);
  if ($$props.setContent === void 0 && $$bindings.setContent && setContent !== void 0) $$bindings.setContent(setContent);
  {
    if (placeholder !== _placeholder) {
      setPlaceholder();
    }
  }
  {
    if (editor) {
      editor.setOptions({ editable });
    }
  }
  {
    if (value === null && html !== null && editor) {
      editor.commands.setContent(html);
    }
  }
  {
    if (value !== null && editor && !collaboration) {
      onValueChange();
    }
  }
  $$unsubscribe_i18n();
  return `${richText && showFormattingToolbar ? `<div id="bubble-menu" class="${"p-0 " + escape(editor ? "" : "hidden", true)}"${add_attribute("this", bubbleMenuElement, 0)}>${validate_component(FormattingButtons, "FormattingButtons").$$render($$result, { editor }, {}, {})}</div> <div id="floating-menu" class="${"p-0 " + escape(editor ? "" : "hidden", true)}"${add_attribute("this", floatingMenuElement, 0)}>${validate_component(FormattingButtons, "FormattingButtons").$$render($$result, { editor }, {}, {})}</div>` : ``} <div class="${"relative w-full min-w-full h-full min-h-fit " + escape(className, true) + " " + escape(!editable ? "cursor-not-allowed" : "", true)}"${add_attribute("this", element, 0)}></div>`;
});
const MicSolid = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"${add_attribute("class", className, 0)}><path d="M7 4a3 3 0 0 1 6 0v6a3 3 0 1 1-6 0V4Z"></path><path d="M5.5 9.643a.75.75 0 0 0-1.5 0V10c0 3.06 2.29 5.585 5.25 5.954V17.5h-1.5a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-1.5v-1.546A6.001 6.001 0 0 0 16 10v-.357a.75.75 0 0 0-1.5 0V10a4.5 4.5 0 0 1-9 0v-.357Z"></path></svg>`;
});
export {
  MicSolid as M,
  RichTextInput as R
};
//# sourceMappingURL=MicSolid.js.map
