import { c as create_ssr_component, b as subscribe, l as getContext, p as createEventDispatcher, g as escape, v as validate_component, e as each, a as add_attribute, o as onDestroy, m as missing_component, q as null_to_empty } from "./ssr.js";
import { t as tick } from "./ssr2.js";
import { v4 } from "uuid";
import { D as WEBUI_API_BASE_URL, q as models, F as showControls, L as showEmbeds, J as embed, d as chatId, s as socket, m as mobile, a as settings, I as showArtifacts, V as artifactCode, K as showOverview, c as config, T as TTSWorker, u as user, t as temporaryChatEnabled, h as WEBUI_BASE_URL, W as WEBUI_NAME, y as WEBUI_VERSION, b as currentChatPage, l as chats } from "./index.js";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { p as getTimeRange, c as createMessagesList, w as formatDate, s as sanitizeResponseContent } from "./index2.js";
import dayjs from "dayjs";
import "yaml";
import { C as ChatBubble, S as Skeleton, a as FileItem } from "./FileItem.js";
import "panzoom";
import "file-saver";
import "dompurify";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import "dayjs/plugin/duration.js";
import "dayjs/plugin/relativeTime.js";
import { C as Collapsible, c as Info, d as CodeBlock, e as LightBulb, M as Markdown, I as Image, F as FullHeightIframe, B as Bolt } from "./Collapsible.js";
import { marked } from "marked";
import "dequal";
import "./create.js";
import "./client.js";
/* empty css                                            */
/* empty css                                    */
import "i18next";
import localizedFormat from "dayjs/plugin/localizedFormat.js";
import { P as ProfileImage, N as Name, L as Loader } from "./ProfileImage.js";
import { T as Tooltip } from "./Tooltip.js";
import { T as Tags, D as Dropdown } from "./Tags.js";
import { X as XMark } from "./XMark.js";
import { S as Sparkles } from "./Sparkles.js";
import { C as ConfirmDialog } from "./ConfirmDialog.js";
import { M as Modal } from "./Modal.js";
import { T as Textarea } from "./Textarea.js";
import { S as Spinner } from "./Spinner.js";
import { B as Badge } from "./Badge.js";
import { C as Check, E as EyeSlash } from "./EyeSlash.js";
import { E as EllipsisHorizontal } from "./EllipsisHorizontal.js";
import { M as Menu_content, a as Menu_item } from "./menu-trigger.js";
import { f as flyAndScale } from "./index4.js";
import { C as ChevronDown } from "./ChevronDown.js";
import { C as ChevronUp } from "./Download.js";
import { S as Search } from "./Search.js";
import Fuse from "fuse.js";
const createNewChat = async (token, chat, folderId) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/new`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    },
    body: JSON.stringify({
      chat,
      folder_id: folderId ?? null
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const importChat = async (token, chat, meta, pinned, folderId, createdAt = null, updatedAt = null) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/import`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    },
    body: JSON.stringify({
      chat,
      meta: meta ?? {},
      pinned,
      folder_id: folderId,
      created_at: createdAt ?? null,
      updated_at: updatedAt ?? null
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getChatList = async (token = "", page = null, include_pinned = false, include_folders = false) => {
  let error = null;
  const searchParams = new URLSearchParams();
  if (page !== null) {
    searchParams.append("page", `${page}`);
  }
  if (include_folders) {
    searchParams.append("include_folders", "true");
  }
  if (include_pinned) {
    searchParams.append("include_pinned", "true");
  }
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/?${searchParams.toString()}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res.map((chat) => ({
    ...chat,
    time_range: getTimeRange(chat.updated_at)
  }));
};
const getArchivedChatList = async (token = "", page = 1, filter) => {
  let error = null;
  const searchParams = new URLSearchParams();
  searchParams.append("page", `${page}`);
  if (filter) {
    Object.entries(filter).forEach(([key, value]) => {
      if (value !== void 0 && value !== null) {
        searchParams.append(key, value.toString());
      }
    });
  }
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/archived?${searchParams.toString()}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res.map((chat) => ({
    ...chat,
    time_range: getTimeRange(chat.updated_at)
  }));
};
const getChatListBySearchText = async (token, text, page = 1) => {
  let error = null;
  const searchParams = new URLSearchParams();
  searchParams.append("text", text);
  searchParams.append("page", `${page}`);
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/search?${searchParams.toString()}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res.map((chat) => ({
    ...chat,
    time_range: getTimeRange(chat.updated_at)
  }));
};
const getChatsByFolderId = async (token, folderId) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/folder/${folderId}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getChatListByFolderId = async (token, folderId, page = 1) => {
  let error = null;
  const searchParams = new URLSearchParams();
  if (page !== null) {
    searchParams.append("page", `${page}`);
  }
  const res = await fetch(
    `${WEBUI_API_BASE_URL}/chats/folder/${folderId}/list?${searchParams.toString()}`,
    {
      method: "GET",
      headers: {
        Accept: "application/json",
        "Content-Type": "application/json",
        ...token && { authorization: `Bearer ${token}` }
      }
    }
  ).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getAllTags = async (token) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/all/tags`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getPinnedChatList = async (token = "") => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/pinned`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res.map((chat) => ({
    ...chat,
    time_range: getTimeRange(chat.updated_at)
  }));
};
const getChatById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/${id}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getChatByShareId = async (token, share_id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/share/${share_id}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getChatPinnedStatusById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/${id}/pinned`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    if ("detail" in err) {
      error = err.detail;
    } else {
      error = err;
    }
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const cloneChatById = async (token, id, title) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/${id}/clone`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    },
    body: JSON.stringify({
      ...title && { title }
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    if ("detail" in err) {
      error = err.detail;
    } else {
      error = err;
    }
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const updateChatFolderIdById = async (token, id, folderId) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/${id}/folder`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    },
    body: JSON.stringify({
      folder_id: folderId
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const archiveChatById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/${id}/archive`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const updateChatById = async (token, id, chat) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/${id}`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    },
    body: JSON.stringify({
      chat
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getTagsById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/chats/${id}/tags`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      ...token && { authorization: `Bearer ${token}` }
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const RateComment = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $$unsubscribe_models;
  $$unsubscribe_models = subscribe(models, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  createEventDispatcher();
  let { message } = $$props;
  let { show = false } = $$props;
  let LIKE_REASONS = [
    "accurate_information",
    "followed_instructions_perfectly",
    "showcased_creativity",
    "positive_attitude",
    "attention_to_detail",
    "thorough_explanation",
    "other"
  ];
  let DISLIKE_REASONS = [
    "dont_like_the_style",
    "too_verbose",
    "not_helpful",
    "not_factually_correct",
    "didnt_fully_follow_instructions",
    "refused_when_it_shouldnt_have",
    "being_lazy",
    "other"
  ];
  let tags = [];
  let reasons = [];
  let selectedReason = null;
  let comment = "";
  let detailedRating = null;
  const init = () => {
    if (!selectedReason) {
      selectedReason = message?.annotation?.reason ?? "";
    }
    if (!comment) {
      comment = message?.annotation?.comment ?? "";
    }
    tags = (message?.annotation?.tags ?? []).map((tag) => ({ name: tag }));
    if (!detailedRating) {
      detailedRating = message?.annotation?.details?.rating ?? null;
    }
  };
  if ($$props.message === void 0 && $$bindings.message && message !== void 0) $$bindings.message(message);
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  {
    if (message?.annotation?.rating === 1) {
      reasons = LIKE_REASONS;
    } else if (message?.annotation?.rating === -1) {
      reasons = DISLIKE_REASONS;
    }
  }
  {
    if (message) {
      init();
    }
  }
  $$unsubscribe_i18n();
  $$unsubscribe_models();
  return `${message?.arena ? `<div class="text-xs font-medium pt-1.5 -mb-0.5">${escape($i18n.t('This response was generated by "{{model}}"', {
    model: message.selectedModelId
  }))}</div>` : ``} <div class="my-2.5 rounded-xl px-4 py-3 border border-gray-100 dark:border-gray-850" id="${"message-feedback-" + escape(message.id, true)}"><div class="flex justify-between items-center"><div class="text-sm font-medium">${escape($i18n.t("How would you rate this response?"))}</div>  <button>${validate_component(XMark, "XMark").$$render($$result, { className: "size-4" }, {}, {})}</button></div> <div class="w-full flex justify-center"><div class="relative w-fit overflow-x-auto scrollbar-none"><div class="mt-1.5 w-fit flex gap-1 pb-2"> ${each(Array.from({ length: 10 }).map((_, i) => i + 1), (rating) => {
    return `<button class="${"size-7 text-sm border border-gray-100 dark:border-gray-850 hover:bg-gray-50 dark:hover:bg-gray-850 " + escape(
      detailedRating === rating ? "bg-gray-100 dark:bg-gray-800" : "",
      true
    ) + " transition rounded-full disabled:cursor-not-allowed disabled:text-gray-500 disabled:bg-white dark:disabled:bg-gray-900"}" ${(message?.annotation?.rating === -1 ? rating > 5 : rating < 6) ? "disabled" : ""}>${escape(rating)} </button>`;
  })}</div> <div class="sticky top-0 bottom-0 left-0 right-0 flex justify-between text-xs"><div>1 - ${escape($i18n.t("Awful"))}</div> <div>10 - ${escape($i18n.t("Amazing"))}</div></div></div></div> <div>${reasons.length > 0 ? `<div class="text-sm mt-1.5 font-medium">${escape($i18n.t("Why?"))}</div> <div class="flex flex-wrap gap-1.5 text-sm mt-1.5">${each(reasons, (reason) => {
    return `<button class="${"px-3 py-0.5 border border-gray-100 dark:border-gray-850 hover:bg-gray-50 dark:hover:bg-gray-850 " + escape(
      selectedReason === reason ? "bg-gray-100 dark:bg-gray-800" : "",
      true
    ) + " transition rounded-xl"}">${reason === "accurate_information" ? `${escape($i18n.t("Accurate information"))}` : `${reason === "followed_instructions_perfectly" ? `${escape($i18n.t("Followed instructions perfectly"))}` : `${reason === "showcased_creativity" ? `${escape($i18n.t("Showcased creativity"))}` : `${reason === "positive_attitude" ? `${escape($i18n.t("Positive attitude"))}` : `${reason === "attention_to_detail" ? `${escape($i18n.t("Attention to detail"))}` : `${reason === "thorough_explanation" ? `${escape($i18n.t("Thorough explanation"))}` : `${reason === "dont_like_the_style" ? `${escape($i18n.t("Don't like the style"))}` : `${reason === "too_verbose" ? `${escape($i18n.t("Too verbose"))}` : `${reason === "not_helpful" ? `${escape($i18n.t("Not helpful"))}` : `${reason === "not_factually_correct" ? `${escape($i18n.t("Not factually correct"))}` : `${reason === "didnt_fully_follow_instructions" ? `${escape($i18n.t("Didn't fully follow instructions"))}` : `${reason === "refused_when_it_shouldnt_have" ? `${escape($i18n.t("Refused when it shouldn't have"))}` : `${reason === "being_lazy" ? `${escape($i18n.t("Being lazy"))}` : `${reason === "other" ? `${escape($i18n.t("Other"))}` : `${escape(reason)}`}`}`}`}`}`}`}`}`}`}`}`}`}`} </button>`;
  })}</div>` : ``}</div> <div class="mt-2"><textarea class="w-full text-sm px-1 py-2 bg-transparent outline-hidden resize-none rounded-xl"${add_attribute("placeholder", $i18n.t("Feel free to add specific details"), 0)} rows="3">${escape(comment || "")}</textarea></div> <div class="mt-2 gap-1.5 flex justify-between"><div class="flex items-end group">${validate_component(Tags, "Tags").$$render($$result, { tags }, {}, {})}</div> <button class="px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full">${escape($i18n.t("Save"))}</button></div></div>`;
});
const WebSearchResults = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { status = { urls: [], query: "" } } = $$props;
  let state = false;
  if ($$props.status === void 0 && $$bindings.status && status !== void 0) $$bindings.status(status);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        grow: true,
        className: "w-full",
        buttonClassName: "w-full",
        open: state
      },
      {
        open: ($$value) => {
          state = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div class="text-sm border border-gray-50 dark:border-gray-850 rounded-xl my-1.5 p-2 w-full" slot="content">${status?.query ? `<a href="${"https://www.google.com/search?q=" + escape(status.query, true)}" target="_blank" class="flex w-full items-center p-1 px-3 group/item justify-between text-gray-800 dark:text-gray-300 font-normal! no-underline!"><div class="flex gap-2 items-center">${validate_component(Search, "Search").$$render($$result, {}, {}, {})} <div class="line-clamp-1">${escape(status.query)}</div></div> <div class="ml-1 text-white dark:text-gray-900 group-hover/item:text-gray-600 dark:group-hover/item:text-white transition" data-svelte-h="svelte-14xjows"> <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-4"><path fill-rule="evenodd" d="M4.22 11.78a.75.75 0 0 1 0-1.06L9.44 5.5H5.75a.75.75 0 0 1 0-1.5h5.5a.75.75 0 0 1 .75.75v5.5a.75.75 0 0 1-1.5 0V6.56l-5.22 5.22a.75.75 0 0 1-1.06 0Z" clip-rule="evenodd"></path></svg></div></a>` : ``} ${status?.items ? `${each(status.items, (item, itemIdx) => {
            return `<a${add_attribute("href", item.link, 0)} target="_blank" class="flex w-full items-center p-1 px-3 group/item justify-between text-gray-800 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-850 rounded-lg font-normal! no-underline! mb-1"><div class="flex justify-center items-center gap-3"><div class="w-fit"><img src="${"https://www.google.com/s2/favicons?sz=32&amp;domain=" + escape(item.link, true)}" alt="favicon" class="size-3.5"></div> <div class="w-full text-sm line-clamp-1">${escape(item?.title ?? item.link)} </div></div> <div class="ml-1 text-white dark:text-gray-900 group-hover/item:text-gray-600 dark:group-hover/item:text-white transition" data-svelte-h="svelte-ar5qfw"> <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-4"><path fill-rule="evenodd" d="M4.22 11.78a.75.75 0 0 1 0-1.06L9.44 5.5H5.75a.75.75 0 0 1 0-1.5h5.5a.75.75 0 0 1 .75.75v5.5a.75.75 0 0 1-1.5 0V6.56l-5.22 5.22a.75.75 0 0 1-1.06 0Z" clip-rule="evenodd"></path></svg></div> </a>`;
          })}` : `${status?.urls ? `${each(status.urls, (url, urlIdx) => {
            return `<a${add_attribute("href", url, 0)} target="_blank" class="flex w-full items-center p-1 px-3 group/item justify-between text-gray-800 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-850 rounded-lg no-underline mb-1"><div class="flex justify-center items-center gap-3"><div class="w-fit"><img src="${"https://www.google.com/s2/favicons?sz=32&amp;domain=" + escape(url, true)}" alt="favicon" class="size-3.5"></div> <div class="w-full text-sm line-clamp-1">${escape(url)} </div></div> <div class="ml-1 text-white dark:text-gray-900 group-hover/item:text-gray-600 dark:group-hover/item:text-white transition" data-svelte-h="svelte-ar5qfw"> <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-4"><path fill-rule="evenodd" d="M4.22 11.78a.75.75 0 0 1 0-1.06L9.44 5.5H5.75a.75.75 0 0 1 0-1.5h5.5a.75.75 0 0 1 .75.75v5.5a.75.75 0 0 1-1.5 0V6.56l-5.22 5.22a.75.75 0 0 1-1.06 0Z" clip-rule="evenodd"></path></svg></div> </a>`;
          })}` : ``}`}</div>`;
        },
        default: () => {
          return `<div class="flex items-center gap-2 text-gray-500 transition">${slots.default ? slots.default({}) : ``} ${state ? `${validate_component(ChevronUp, "ChevronUp").$$render(
            $$result,
            {
              strokeWidth: "2.5",
              className: "size-3.5 "
            },
            {},
            {}
          )}` : `${validate_component(ChevronDown, "ChevronDown").$$render(
            $$result,
            {
              strokeWidth: "2.5",
              className: "size-3.5 "
            },
            {},
            {}
          )}`}</div>`;
        }
      }
    )}`;
  } while (!$$settled);
  return $$rendered;
});
const Error = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { content = "" } = $$props;
  if ($$props.content === void 0 && $$bindings.content && content !== void 0) $$bindings.content(content);
  return `<div class="flex my-2 gap-2.5 border px-4 py-3 border-red-600/10 bg-red-600/10 rounded-lg"><div class="self-start mt-0.5">${validate_component(Info, "Info").$$render(
    $$result,
    {
      className: "size-5 text-red-700 dark:text-red-400"
    },
    {},
    {}
  )}</div> <div class="self-center text-sm">${typeof content === "string" ? `${escape(content)}` : `${typeof content === "object" && content !== null ? `${content?.error && content?.error?.message ? `${escape(content.error.message)}` : `${content?.detail ? `${escape(content.detail)}` : `${content?.message ? `${escape(content.message)}` : `${escape(JSON.stringify(content))}`}`}`}` : `${escape(JSON.stringify(content))}`}`}</div></div>`;
});
function calculatePercentage(distance) {
  if (typeof distance !== "number") return null;
  if (distance < 0) return 0;
  if (distance > 1) return 100;
  return Math.round(distance * 1e4) / 100;
}
function getRelevanceColor(percentage) {
  if (percentage >= 80) return "bg-green-200 dark:bg-green-800 text-green-800 dark:text-green-200";
  if (percentage >= 60) return "bg-yellow-200 dark:bg-yellow-800 text-yellow-800 dark:text-yellow-200";
  if (percentage >= 40) return "bg-orange-200 dark:bg-orange-800 text-orange-800 dark:text-orange-200";
  return "bg-red-200 dark:bg-red-800 text-red-800 dark:text-red-200";
}
const CitationModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { citation } = $$props;
  let { showPercentage = false } = $$props;
  let { showRelevance = true } = $$props;
  let mergedDocuments = [];
  const decodeString = (str) => {
    try {
      return decodeURIComponent(str);
    } catch (e) {
      return str;
    }
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.citation === void 0 && $$bindings.citation && citation !== void 0) $$bindings.citation(citation);
  if ($$props.showPercentage === void 0 && $$bindings.showPercentage && showPercentage !== void 0) $$bindings.showPercentage(showPercentage);
  if ($$props.showRelevance === void 0 && $$bindings.showRelevance && showRelevance !== void 0) $$bindings.showRelevance(showRelevance);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (citation) {
        mergedDocuments = citation.document?.map((c, i) => {
          return {
            source: citation.source,
            document: c,
            metadata: citation.metadata?.[i],
            distance: citation.distances?.[i]
          };
        });
        if (mergedDocuments.every((doc) => doc.distance !== void 0)) {
          mergedDocuments = mergedDocuments.sort((a, b) => (b.distance ?? Infinity) - (a.distance ?? Infinity));
        }
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "lg", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-4.5 pt-3 pb-2"><div class="text-lg font-medium self-center flex items-center">${citation?.source?.name ? (() => {
            let document2 = mergedDocuments?.[0];
            return ` ${document2?.metadata?.file_id || document2.source?.url?.includes("http") ? `${validate_component(Tooltip, "Tooltip").$$render(
              $$result,
              {
                className: "w-fit",
                content: document2.source?.url?.includes("http") ? $i18n.t("Open link") : $i18n.t("Open file"),
                placement: "top-start",
                tippyOptions: { duration: [500, 0] }
              },
              {},
              {
                default: () => {
                  return `<a class="hover:text-gray-500 dark:hover:text-gray-100 underline grow line-clamp-1"${add_attribute(
                    "href",
                    document2?.metadata?.file_id ? `${WEBUI_API_BASE_URL}/files/${document2?.metadata?.file_id}/content${document2?.metadata?.page !== void 0 ? `#page=${document2.metadata.page + 1}` : ""}` : document2.source?.url?.includes("http") ? document2.source.url : `#`,
                    0
                  )} target="_blank">${escape(decodeString(citation?.source?.name))}</a>`;
                }
              }
            )}` : `${escape(decodeString(citation?.source?.name))}`}`;
          })() : `${escape($i18n.t("Citation"))}`}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-5 md:space-x-4"><div class="flex flex-col w-full dark:text-gray-200 overflow-y-scroll max-h-[22rem] scrollbar-thin gap-1">${each(mergedDocuments, (document2, documentIdx) => {
            return `<div class="flex flex-col w-full gap-2">${document2.metadata?.parameters ? `<div><div class="text-sm font-medium dark:text-gray-300 mb-1">${escape($i18n.t("Parameters"))}</div> ${validate_component(Textarea, "Textarea").$$render(
              $$result,
              {
                readonly: true,
                value: JSON.stringify(document2.metadata.parameters, null, 2)
              },
              {},
              {}
            )} </div>` : ``} <div><div class="text-sm font-medium dark:text-gray-300 flex items-center gap-2 w-fit mb-1">${escape($i18n.t("Content"))} ${showRelevance && document2.distance !== void 0 ? `${validate_component(Tooltip, "Tooltip").$$render(
              $$result,
              {
                className: "w-fit",
                content: $i18n.t("Relevance"),
                placement: "top-start",
                tippyOptions: { duration: [500, 0] }
              },
              {},
              {
                default: () => {
                  return `<div class="text-sm my-1 dark:text-gray-400 flex items-center gap-2 w-fit">${showPercentage ? (() => {
                    let percentage = calculatePercentage(document2.distance);
                    return ` ${typeof percentage === "number" ? `<span${add_attribute("class", `px-1 rounded-sm font-medium ${getRelevanceColor(percentage)}`, 0)}>${escape(percentage.toFixed(2))}%
													</span>` : ``}`;
                  })() : `${typeof document2?.distance === "number" ? `<span class="text-gray-500 dark:text-gray-500">(${escape((document2?.distance ?? 0).toFixed(4))})
												</span>` : ``}`}</div> `;
                }
              }
            )}` : ``} ${Number.isInteger(document2?.metadata?.page) ? `<span class="text-sm text-gray-500 dark:text-gray-400">(${escape($i18n.t("page"))} ${escape(document2.metadata.page + 1)})
									</span>` : ``}</div> ${document2.metadata?.html ? `<iframe class="w-full border-0 h-auto rounded-none" sandbox="allow-scripts allow-forms allow-same-origin"${add_attribute("srcdoc", document2.document, 0)}${add_attribute("title", $i18n.t("Content"), 0)}></iframe>` : `<pre class="text-sm dark:text-gray-400 whitespace-pre-line">                ${escape(document2.document)}
              </pre>`}</div> </div>`;
          })}</div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
function calculateShowRelevance(sources2) {
  const distances = sources2.flatMap((citation) => citation.distances ?? []);
  const inRange = distances.filter((d) => d !== void 0 && d >= -1 && d <= 1).length;
  const outOfRange = distances.filter((d) => d !== void 0 && (d < -1 || d > 1)).length;
  if (distances.length === 0) {
    return false;
  }
  if (inRange === distances.length - 1 && outOfRange === 1 || outOfRange === distances.length - 1 && inRange === 1) {
    return false;
  }
  return true;
}
function shouldShowPercentage(sources2) {
  const distances = sources2.flatMap((citation) => citation.distances ?? []);
  return distances.every((d) => d !== void 0 && d >= -1 && d <= 1);
}
const Citations = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { id = "" } = $$props;
  let { sources = [] } = $$props;
  let { readOnly = false } = $$props;
  let citations = [];
  let showPercentage = false;
  let showRelevance = true;
  let showCitationModal = false;
  let selectedCitation = null;
  const showSourceModal = (sourceIdx) => {
    if (citations[sourceIdx]) {
      /* @__PURE__ */ console.log("Showing citation modal for:", citations[sourceIdx]);
      if (citations[sourceIdx]?.source?.embed_url) {
        const embedUrl = citations[sourceIdx].source.embed_url;
        if (embedUrl) {
          if (readOnly) {
            window.open(embedUrl, "_blank");
            return;
          } else {
            showControls.set(true);
            showEmbeds.set(true);
            embed.set({
              title: citations[sourceIdx]?.source?.name || "Embedded Content",
              url: embedUrl
            });
          }
        } else {
          selectedCitation = citations[sourceIdx];
          showCitationModal = true;
        }
      } else {
        selectedCitation = citations[sourceIdx];
        showCitationModal = true;
      }
    }
  };
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.sources === void 0 && $$bindings.sources && sources !== void 0) $$bindings.sources(sources);
  if ($$props.readOnly === void 0 && $$bindings.readOnly && readOnly !== void 0) $$bindings.readOnly(readOnly);
  if ($$props.showSourceModal === void 0 && $$bindings.showSourceModal && showSourceModal !== void 0) $$bindings.showSourceModal(showSourceModal);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      {
        citations = sources.reduce(
          (acc, source) => {
            if (Object.keys(source).length === 0) {
              return acc;
            }
            source?.document?.forEach((document2, index) => {
              const metadata = source?.metadata?.[index];
              const distance = source?.distances?.[index];
              const id2 = metadata?.source ?? source?.source?.id ?? "N/A";
              let _source = source?.source;
              if (metadata?.name) {
                _source = { ..._source, name: metadata.name };
              }
              if (id2.startsWith("http://") || id2.startsWith("https://")) {
                _source = { ..._source, name: id2, url: id2 };
              }
              const existingSource = acc.find((item) => item.id === id2);
              if (existingSource) {
                existingSource.document.push(document2);
                existingSource.metadata.push(metadata);
                if (distance !== void 0) existingSource.distances.push(distance);
              } else {
                acc.push({
                  id: id2,
                  source: _source,
                  document: [document2],
                  metadata: metadata ? [metadata] : [],
                  distances: distance !== void 0 ? [distance] : void 0
                });
              }
            });
            return acc;
          },
          []
        );
        /* @__PURE__ */ console.log("citations", citations);
        showRelevance = calculateShowRelevance(citations);
        showPercentage = shouldShowPercentage(citations);
      }
    }
    $$rendered = `${validate_component(CitationModal, "CitationModal").$$render(
      $$result,
      {
        citation: selectedCitation,
        showPercentage,
        showRelevance,
        show: showCitationModal
      },
      {
        show: ($$value) => {
          showCitationModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${citations.length > 0 ? (() => {
      let urlCitations = citations.filter((c) => c?.source?.name?.startsWith("http"));
      return ` <div class="py-1 -mx-0.5 w-full flex gap-1 items-center flex-wrap"><button class="text-xs font-medium text-gray-600 dark:text-gray-300 px-3.5 h-8 rounded-full hover:bg-gray-100 dark:hover:bg-gray-800 transition flex items-center gap-1 border border-gray-50 dark:border-gray-850">${urlCitations.length > 0 ? `<div class="flex -space-x-1 items-center">${each(urlCitations.slice(0, 3), (citation, idx) => {
        return `<img src="${"https://www.google.com/s2/favicons?sz=32&amp;domain=" + escape(citation.source.name, true)}" alt="favicon" class="size-4 rounded-full shrink-0 border border-white dark:border-gray-850 bg-white dark:bg-gray-900">`;
      })}</div>` : ``} <div>${citations.length === 1 ? `${escape($i18n.t("1 Source"))}` : `${escape($i18n.t("{{COUNT}} Sources", { COUNT: citations.length }))}`}</div></button></div>`;
    })() : ``} ${``}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const CodeExecutionModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { codeExecution = null } = $$props;
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.codeExecution === void 0 && $$bindings.codeExecution && codeExecution !== void 0) $$bindings.codeExecution(codeExecution);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "lg", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-2"><div class="text-lg font-medium self-center flex flex-col gap-0.5 capitalize">${codeExecution?.result ? `<div>${codeExecution.result?.error ? `${validate_component(Badge, "Badge").$$render($$result, { type: "error", content: "error" }, {}, {})}` : `${codeExecution.result?.output ? `${validate_component(Badge, "Badge").$$render($$result, { type: "success", content: "success" }, {}, {})}` : `${validate_component(Badge, "Badge").$$render($$result, { type: "warning", content: "incomplete" }, {}, {})}`}`}</div>` : ``} <div class="flex gap-2 items-center">${!codeExecution?.result ? `<div>${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-4" }, {}, {})}</div>` : ``} <div>${codeExecution?.name ? `${escape($i18n.t("Code execution"))}: ${escape(codeExecution?.name)}` : `${escape($i18n.t("Code execution"))}`}</div></div></div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full px-4 pb-5"><div class="flex flex-col w-full dark:text-gray-200 overflow-y-scroll max-h-[22rem] scrollbar-hidden"><div class="flex flex-col w-full">${validate_component(CodeBlock, "CodeBlock").$$render(
            $$result,
            {
              id: "code-exec-" + codeExecution?.id + "-code",
              lang: codeExecution?.language ?? "",
              code: codeExecution?.code ?? "",
              className: "",
              editorClassName: codeExecution?.result && (codeExecution?.result?.error || codeExecution?.result?.output) ? "rounded-b-none" : "",
              run: false
            },
            {},
            {}
          )}</div> ${codeExecution?.result && (codeExecution?.result?.error || codeExecution?.result?.output) ? `<div class="dark:bg-[#202123] dark:text-white px-4 py-4 rounded-b-lg flex flex-col gap-3">${codeExecution?.result?.error ? `<div><div class="text-gray-500 text-xs mb-1">${escape($i18n.t("ERROR"))}</div> <div class="text-sm">${escape(codeExecution?.result?.error)}</div></div>` : ``} ${codeExecution?.result?.output ? `<div><div class="text-gray-500 text-xs mb-1">${escape($i18n.t("OUTPUT"))}</div> <div class="text-sm">${escape(codeExecution?.result?.output)}</div></div>` : ``}</div>` : ``} ${codeExecution?.result?.files && codeExecution?.result?.files.length > 0 ? `<div class="flex flex-col w-full"><hr class="border-gray-100 dark:border-gray-850 my-2"> <div class="text-sm font-medium dark:text-gray-300">${escape($i18n.t("Files"))}</div> <ul class="mt-1 list-disc pl-4 text-xs">${each(codeExecution?.result?.files, (file) => {
            return `<li><a${add_attribute("href", file.url, 0)} target="_blank">${escape(file.name)}</a> </li>`;
          })}</ul></div>` : ``}</div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const css$2 = {
  code: "@keyframes svelte-1gvtig2-pulse{0%,100%{opacity:1}50%{opacity:0.6}}.pulse.svelte-1gvtig2{opacity:1;animation:svelte-1gvtig2-pulse 1.5s ease}",
  map: `{"version":3,"file":"CodeExecutions.svelte","sources":["CodeExecutions.svelte"],"sourcesContent":["<script lang=\\"ts\\">import CodeExecutionModal from \\"./CodeExecutionModal.svelte\\";\\nimport Spinner from \\"$lib/components/common/Spinner.svelte\\";\\nimport Check from \\"$lib/components/icons/Check.svelte\\";\\nimport XMark from \\"$lib/components/icons/XMark.svelte\\";\\nimport EllipsisHorizontal from \\"$lib/components/icons/EllipsisHorizontal.svelte\\";\\nexport let codeExecutions = [];\\nlet selectedCodeExecution = null;\\nlet showCodeExecutionModal = false;\\n$: if (codeExecutions) {\\n  updateSelectedCodeExecution();\\n}\\nconst updateSelectedCodeExecution = () => {\\n  if (selectedCodeExecution) {\\n    selectedCodeExecution = codeExecutions.find(\\n      (execution) => execution.id === selectedCodeExecution.id\\n    );\\n  }\\n};\\n<\/script>\\n\\n<CodeExecutionModal bind:show={showCodeExecutionModal} codeExecution={selectedCodeExecution} />\\n\\n{#if codeExecutions.length > 0}\\n\\t<div class=\\"mt-1 mb-2 w-full flex gap-1 items-center flex-wrap\\">\\n\\t\\t{#each codeExecutions as execution (execution.id)}\\n\\t\\t\\t<div class=\\"flex gap-1 text-xs font-semibold\\">\\n\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\tclass=\\"flex dark:text-gray-300 py-1 px-1 bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-xl max-w-96\\"\\n\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\tselectedCodeExecution = execution;\\n\\t\\t\\t\\t\\t\\tshowCodeExecutionModal = true;\\n\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\tclass=\\"bg-white dark:bg-gray-700 rounded-full size-4 flex items-center justify-center\\"\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t{#if execution?.result}\\n\\t\\t\\t\\t\\t\\t\\t{#if execution.result?.error}\\n\\t\\t\\t\\t\\t\\t\\t\\t<XMark />\\n\\t\\t\\t\\t\\t\\t\\t{:else if execution.result?.output}\\n\\t\\t\\t\\t\\t\\t\\t\\t<Check strokeWidth=\\"3\\" className=\\"size-3\\" />\\n\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t<EllipsisHorizontal />\\n\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t<Spinner className=\\"size-4\\" />\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\tclass=\\"flex-1 mx-2 line-clamp-1 code-execution-name {execution?.result ? '' : 'pulse'}\\"\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t{execution.name}\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t</button>\\n\\t\\t\\t</div>\\n\\t\\t{/each}\\n\\t</div>\\n{/if}\\n\\n<style>\\n\\t@keyframes pulse {\\n\\t\\t0%,\\n\\t\\t100% {\\n\\t\\t\\topacity: 1;\\n\\t\\t}\\n\\t\\t50% {\\n\\t\\t\\topacity: 0.6;\\n\\t\\t}\\n\\t}\\n\\n\\t.pulse {\\n\\t\\topacity: 1;\\n\\t\\tanimation: pulse 1.5s ease;\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AA4DC,WAAW,oBAAM,CAChB,EAAE,CACF,IAAK,CACJ,OAAO,CAAE,CACV,CACA,GAAI,CACH,OAAO,CAAE,GACV,CACD,CAEA,qBAAO,CACN,OAAO,CAAE,CAAC,CACV,SAAS,CAAE,oBAAK,CAAC,IAAI,CAAC,IACvB"}`
};
const CodeExecutions = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { codeExecutions = [] } = $$props;
  let selectedCodeExecution = null;
  let showCodeExecutionModal = false;
  if ($$props.codeExecutions === void 0 && $$bindings.codeExecutions && codeExecutions !== void 0) $$bindings.codeExecutions(codeExecutions);
  $$result.css.add(css$2);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(CodeExecutionModal, "CodeExecutionModal").$$render(
      $$result,
      {
        codeExecution: selectedCodeExecution,
        show: showCodeExecutionModal
      },
      {
        show: ($$value) => {
          showCodeExecutionModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${codeExecutions.length > 0 ? `<div class="mt-1 mb-2 w-full flex gap-1 items-center flex-wrap">${each(codeExecutions, (execution) => {
      return `<div class="flex gap-1 text-xs font-semibold"><button class="flex dark:text-gray-300 py-1 px-1 bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-xl max-w-96"><div class="bg-white dark:bg-gray-700 rounded-full size-4 flex items-center justify-center">${execution?.result ? `${execution.result?.error ? `${validate_component(XMark, "XMark").$$render($$result, {}, {}, {})}` : `${execution.result?.output ? `${validate_component(Check, "Check").$$render($$result, { strokeWidth: "3", className: "size-3" }, {}, {})}` : `${validate_component(EllipsisHorizontal, "EllipsisHorizontal").$$render($$result, {}, {}, {})}`}`}` : `${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-4" }, {}, {})}`}</div> <div class="${"flex-1 mx-2 line-clamp-1 code-execution-name " + escape(execution?.result ? "" : "pulse", true) + " svelte-1gvtig2"}">${escape(execution.name)} </div></button> </div>`;
    })}</div>` : ``}`;
  } while (!$$settled);
  return $$rendered;
});
const FloatingButtons = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $$unsubscribe_chatId;
  let $$unsubscribe_socket;
  let $$unsubscribe_models;
  $$unsubscribe_chatId = subscribe(chatId, (value) => value);
  $$unsubscribe_socket = subscribe(socket, (value) => value);
  $$unsubscribe_models = subscribe(models, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { id = "" } = $$props;
  let { messageId = "" } = $$props;
  let { model = null } = $$props;
  let { messages = [] } = $$props;
  let { actions = [] } = $$props;
  let { onAdd = (e) => {
  } } = $$props;
  let floatingInput = false;
  let floatingInputValue = "";
  let content = "";
  let responseContent = null;
  let responseDone = false;
  const DEFAULT_ACTIONS = [
    {
      id: "ask",
      label: $i18n.t("Ask"),
      icon: ChatBubble,
      input: true,
      prompt: `{{SELECTED_CONTENT}}


{{INPUT_CONTENT}}`
    },
    {
      id: "explain",
      label: $i18n.t("Explain"),
      icon: LightBulb,
      prompt: `{{SELECTED_CONTENT}}


${$i18n.t("Explain")}`
    }
  ];
  const closeHandler = () => {
    responseContent = null;
    responseDone = false;
    floatingInput = false;
    floatingInputValue = "";
  };
  onDestroy(() => {
  });
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.messageId === void 0 && $$bindings.messageId && messageId !== void 0) $$bindings.messageId(messageId);
  if ($$props.model === void 0 && $$bindings.model && model !== void 0) $$bindings.model(model);
  if ($$props.messages === void 0 && $$bindings.messages && messages !== void 0) $$bindings.messages(messages);
  if ($$props.actions === void 0 && $$bindings.actions && actions !== void 0) $$bindings.actions(actions);
  if ($$props.onAdd === void 0 && $$bindings.onAdd && onAdd !== void 0) $$bindings.onAdd(onAdd);
  if ($$props.closeHandler === void 0 && $$bindings.closeHandler && closeHandler !== void 0) $$bindings.closeHandler(closeHandler);
  {
    if (actions.length === 0) {
      actions = DEFAULT_ACTIONS;
    }
  }
  $$unsubscribe_i18n();
  $$unsubscribe_chatId();
  $$unsubscribe_socket();
  $$unsubscribe_models();
  return `<div${add_attribute("id", `floating-buttons-${id}`, 0)} class="absolute rounded-lg mt-1 text-xs z-9999" style="display: none">${responseContent === null ? `${!floatingInput ? `<div class="flex flex-row shrink-0 p-0.5 bg-white dark:bg-gray-850 dark:text-gray-100 text-medium rounded-xl shadow-xl border border-gray-100 dark:border-gray-800">${each(actions, (action) => {
    return `<button class="px-1.5 py-[1px] hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl flex items-center gap-1 min-w-fit transition">${action.icon ? `${validate_component(action.icon || missing_component, "svelte:component").$$render($$result, { className: "size-3 shrink-0" }, {}, {})}` : ``} <div class="shrink-0">${escape(action.label)}</div> </button>`;
  })}</div>` : `<div class="py-1 flex dark:text-gray-100 bg-white dark:bg-gray-850 border border-gray-100 dark:border-gray-800 w-72 rounded-full shadow-xl"><input type="text" id="floating-message-input" class="ml-5 bg-transparent outline-hidden w-full flex-1 text-sm"${add_attribute("placeholder", $i18n.t("Ask a question"), 0)}${add_attribute("value", floatingInputValue, 0)}> <div class="ml-1 mr-1"><button class="${escape(
    floatingInputValue !== "" ? "bg-black text-white hover:bg-gray-900 dark:bg-white dark:text-black dark:hover:bg-gray-100 " : "text-white bg-gray-200 dark:text-gray-900 dark:bg-gray-700 disabled",
    true
  ) + " transition rounded-full p-1.5 m-0.5 self-center"}"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-4"><path fill-rule="evenodd" d="M8 14a.75.75 0 0 1-.75-.75V4.56L4.03 7.78a.75.75 0 0 1-1.06-1.06l4.5-4.5a.75.75 0 0 1 1.06 0l4.5 4.5a.75.75 0 0 1-1.06 1.06L8.75 4.56v8.69A.75.75 0 0 1 8 14Z" clip-rule="evenodd"></path></svg></button></div></div>`}` : `<div class="bg-white dark:bg-gray-850 dark:text-gray-100 rounded-3xl shadow-xl w-80 max-w-full border border-gray-100 dark:border-gray-800"><div class="bg-white dark:bg-gray-850 dark:text-gray-100 text-medium rounded-3xl px-3.5 pt-3 w-full"><div class="font-medium">${validate_component(Markdown, "Markdown").$$render($$result, { id: `${id}-float-prompt`, content }, {}, {})}</div></div> <div class="bg-white dark:bg-gray-850 dark:text-gray-100 text-medium rounded-4xl w-full"><div class="max-h-80 overflow-y-auto w-full markdown-prose-xs px-3.5 py-3" id="response-container">${!responseContent || responseContent?.trim() === "" ? `${validate_component(Skeleton, "Skeleton").$$render($$result, { size: "sm" }, {}, {})}` : `${validate_component(Markdown, "Markdown").$$render(
    $$result,
    {
      id: `${id}-float-response`,
      content: responseContent
    },
    {},
    {}
  )}`} ${responseDone ? `<div class="flex justify-end pt-3 text-sm font-medium"><button class="px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full">${escape($i18n.t("Add"))}</button></div>` : ``}</div></div></div>`}</div>`;
});
const ContentRenderer = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $mobile, $$unsubscribe_mobile;
  let $settings, $$unsubscribe_settings;
  let $chatId, $$unsubscribe_chatId;
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_chatId = subscribe(chatId, (value) => $chatId = value);
  getContext("i18n");
  let { id } = $$props;
  let { content } = $$props;
  let { history } = $$props;
  let { messageId } = $$props;
  let { selectedModels = [] } = $$props;
  let { done = true } = $$props;
  let { model = null } = $$props;
  let { sources = null } = $$props;
  let { save = false } = $$props;
  let { preview = false } = $$props;
  let { floatingButtons = true } = $$props;
  let { editCodeBlock = true } = $$props;
  let { topPadding = false } = $$props;
  let { onSave = (e) => {
  } } = $$props;
  let { onSourceClick = (e) => {
  } } = $$props;
  let { onTaskClick = (e) => {
  } } = $$props;
  let { onAddMessages = (e) => {
  } } = $$props;
  let contentContainerElement;
  let floatingButtonsElement;
  const updateButtonPosition = (event) => {
    const buttonsContainerElement = document.getElementById(`floating-buttons-${id}`);
    if (!buttonsContainerElement?.contains(event.target)) {
      closeFloatingButtons();
      return;
    }
    setTimeout(
      async () => {
        await tick();
        return;
      },
      0
    );
  };
  const closeFloatingButtons = () => {
    const buttonsContainerElement = document.getElementById(`floating-buttons-${id}`);
    if (buttonsContainerElement) {
      buttonsContainerElement.style.display = "none";
    }
    if (floatingButtonsElement) {
      if (typeof floatingButtonsElement?.closeHandler === "function") {
        floatingButtonsElement?.closeHandler();
      }
    }
  };
  const keydownHandler = (e) => {
    if (e.key === "Escape") {
      closeFloatingButtons();
    }
  };
  onDestroy(() => {
    if (floatingButtons) {
      document.removeEventListener("mouseup", updateButtonPosition);
      document.removeEventListener("keydown", keydownHandler);
    }
  });
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.content === void 0 && $$bindings.content && content !== void 0) $$bindings.content(content);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.messageId === void 0 && $$bindings.messageId && messageId !== void 0) $$bindings.messageId(messageId);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.done === void 0 && $$bindings.done && done !== void 0) $$bindings.done(done);
  if ($$props.model === void 0 && $$bindings.model && model !== void 0) $$bindings.model(model);
  if ($$props.sources === void 0 && $$bindings.sources && sources !== void 0) $$bindings.sources(sources);
  if ($$props.save === void 0 && $$bindings.save && save !== void 0) $$bindings.save(save);
  if ($$props.preview === void 0 && $$bindings.preview && preview !== void 0) $$bindings.preview(preview);
  if ($$props.floatingButtons === void 0 && $$bindings.floatingButtons && floatingButtons !== void 0) $$bindings.floatingButtons(floatingButtons);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  if ($$props.onSave === void 0 && $$bindings.onSave && onSave !== void 0) $$bindings.onSave(onSave);
  if ($$props.onSourceClick === void 0 && $$bindings.onSourceClick && onSourceClick !== void 0) $$bindings.onSourceClick(onSourceClick);
  if ($$props.onTaskClick === void 0 && $$bindings.onTaskClick && onTaskClick !== void 0) $$bindings.onTaskClick(onTaskClick);
  if ($$props.onAddMessages === void 0 && $$bindings.onAddMessages && onAddMessages !== void 0) $$bindings.onAddMessages(onAddMessages);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `<div${add_attribute("this", contentContainerElement, 0)}>${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id,
        content,
        model,
        save,
        preview,
        done,
        editCodeBlock,
        topPadding,
        sourceIds: (sources ?? []).reduce(
          (acc, source) => {
            let ids = [];
            source.document.forEach((document2, index) => {
              if (model?.info?.meta?.capabilities?.citations == false) {
                ids.push("N/A");
                return ids;
              }
              const metadata = source.metadata?.[index];
              const id2 = metadata?.source ?? "N/A";
              if (metadata?.name) {
                ids.push(metadata.name);
                return ids;
              }
              if (id2.startsWith("http://") || id2.startsWith("https://")) {
                ids.push(id2);
              } else {
                ids.push(source?.source?.name ?? id2);
              }
              return ids;
            });
            acc = [...acc, ...ids];
            return acc.filter((item, index) => acc.indexOf(item) === index);
          },
          []
        ),
        onSourceClick,
        onTaskClick,
        onSave,
        onUpdate: (token) => {
          const { lang, text: code } = token;
          if (($settings?.detectArtifacts ?? true) && (["html", "svg"].includes(lang) || lang === "xml" && code.includes("svg")) && !$mobile && $chatId) {
            showArtifacts.set(true);
            showControls.set(true);
          }
        },
        onPreview: async (value) => {
          /* @__PURE__ */ console.log("Preview", value);
          await artifactCode.set(value);
          await showControls.set(true);
          await showArtifacts.set(true);
          await showOverview.set(false);
          await showEmbeds.set(false);
        }
      },
      {},
      {}
    )}</div> ${floatingButtons && model ? `${validate_component(FloatingButtons, "FloatingButtons").$$render(
      $$result,
      {
        id,
        messageId,
        actions: $settings?.floatingActionButtons ?? [],
        model: (selectedModels ?? []).includes(model?.id) ? model?.id : (selectedModels ?? []).length > 0 ? selectedModels.at(0) : model?.id,
        messages: createMessagesList(history, messageId),
        onAdd: ({ modelId, parentId, messages }) => {
          /* @__PURE__ */ console.log(modelId, parentId, messages);
          onAddMessages({ modelId, parentId, messages });
          closeFloatingButtons();
        },
        this: floatingButtonsElement
      },
      {
        this: ($$value) => {
          floatingButtonsElement = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : ``}`;
  } while (!$$settled);
  $$unsubscribe_mobile();
  $$unsubscribe_settings();
  $$unsubscribe_chatId();
  return $$rendered;
});
const FollowUps = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { followUps = [] } = $$props;
  let { onClick = () => {
  } } = $$props;
  if ($$props.followUps === void 0 && $$bindings.followUps && followUps !== void 0) $$bindings.followUps(followUps);
  if ($$props.onClick === void 0 && $$bindings.onClick && onClick !== void 0) $$bindings.onClick(onClick);
  $$unsubscribe_i18n();
  return `<div class="mt-4"><div class="text-sm font-medium">${escape($i18n.t("Follow up"))}</div> <div class="flex flex-col text-left gap-1 mt-1.5">${each(followUps, (followUp, idx) => {
    return `  ${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: followUp,
        placement: "top-start",
        className: "line-clamp-1"
      },
      {},
      {
        default: () => {
          return `<div class="py-1.5 bg-transparent text-left text-sm flex items-center gap-2 text-gray-500 dark:text-gray-400 hover:text-black dark:hover:text-white transition cursor-pointer"${add_attribute("aria-label", followUp, 0)}><div class="line-clamp-1">${escape(followUp)} </div></div> `;
        }
      }
    )} ${idx < followUps.length - 1 ? `<hr class="border-gray-50 dark:border-gray-850">` : ``}`;
  })}</div></div>`;
});
const LineSpace = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M11 6H21" stroke-linecap="round" stroke-linejoin="round"></path><path d="M11 12H21" stroke-linecap="round" stroke-linejoin="round"></path><path d="M11 18H21" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5 19V5M5 19L3 16.5M5 19L7 16.5M5 5L3 7M5 5L7 7" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const LineSpaceSmaller = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M11 6H21" stroke-linecap="round" stroke-linejoin="round"></path><path d="M11 12H21" stroke-linecap="round" stroke-linejoin="round"></path><path d="M11 18H21" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5 19V5M5 10L3 8M5 10L7 8M5 14L3 16M5 14L7 16" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const RegenerateMenu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { onRegenerate = (prompt = null) => {
  } } = $$props;
  let { onClose = () => {
  } } = $$props;
  let show = false;
  let inputValue = "";
  if ($$props.onRegenerate === void 0 && $$bindings.onRegenerate && onRegenerate !== void 0) $$bindings.onRegenerate(onRegenerate);
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Dropdown, "Dropdown").$$render(
      $$result,
      { align: "end", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div slot="content">${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full max-w-[200px] rounded-2xl px-1 py-1 border border-gray-100 dark:border-gray-800 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg transition",
              sideOffset: -2,
              side: "bottom",
              align: "start",
              transition: flyAndScale
            },
            {},
            {
              default: () => {
                return `<div class="py-1.5 px-2.5 flex dark:text-gray-100"><input type="text" id="floating-message-input" class="bg-transparent outline-hidden w-full flex-1 text-sm"${add_attribute("placeholder", $i18n.t("Suggest a change"), 0)} autocomplete="off"${add_attribute("value", inputValue, 0)}> <div class="ml-2 self-center flex items-center"><button class="${escape(
                  "text-white bg-gray-200 dark:text-gray-900 dark:bg-gray-700 disabled",
                  true
                ) + " transition rounded-full p-1 self-center"}"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-3.5"><path fill-rule="evenodd" d="M8 14a.75.75 0 0 1-.75-.75V4.56L4.03 7.78a.75.75 0 0 1-1.06-1.06l4.5-4.5a.75.75 0 0 1 1.06 0l4.5 4.5a.75.75 0 0 1-1.06 1.06L8.75 4.56v8.69A.75.75 0 0 1 8 14Z" clip-rule="evenodd"></path></svg></button></div></div> <hr class="border-gray-50 dark:border-gray-800 my-1 mx-2"> ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex  gap-2  items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" aria-hidden="true" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99"></path></svg> <div class="flex items-center">${escape($i18n.t("Try Again"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex  gap-2  items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(LineSpace, "LineSpace").$$render($$result, { strokeWidth: "2" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Add Details"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex  gap-2  items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(LineSpaceSmaller, "LineSpaceSmaller").$$render($$result, { strokeWidth: "2" }, {}, {})} <div class="flex items-center">${escape($i18n.t("More Concise"))}</div>`;
                    }
                  }
                )}`;
              }
            }
          )}</div>`;
        },
        default: () => {
          return `${slots.default ? slots.default({}) : ``}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const StatusItem = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { status = null } = $$props;
  let { done = false } = $$props;
  if ($$props.status === void 0 && $$bindings.status && status !== void 0) $$bindings.status(status);
  if ($$props.done === void 0 && $$bindings.done && done !== void 0) $$bindings.done(done);
  $$unsubscribe_i18n();
  return `${!status?.hidden ? `<div class="status-description flex items-center gap-2 py-0.5 w-full text-left">${status?.action === "web_search" && (status?.urls || status?.items) ? `${validate_component(WebSearchResults, "WebSearchResults").$$render($$result, { status }, {}, {
    default: () => {
      return `<div class="flex flex-col justify-center -space-y-0.5"><div class="${escape((done || status?.done) === false ? "shimmer" : "", true) + " text-base line-clamp-1 text-wrap"}">   ${status?.description?.includes("{{count}}") ? `${escape($i18n.t(status?.description, {
        count: (status?.urls || status?.items).length
      }))}` : `${status?.description === "No search query generated" ? `${escape($i18n.t("No search query generated"))}` : `${status?.description === "Generating search query" ? `${escape($i18n.t("Generating search query"))}` : `${escape(status?.description)}`}`}`}</div></div>`;
    }
  })}` : `${status?.action === "knowledge_search" ? `<div class="flex flex-col justify-center -space-y-0.5"><div class="${escape((done || status?.done) === false ? "shimmer" : "", true) + " text-gray-500 dark:text-gray-500 text-base line-clamp-1 text-wrap"}">${escape($i18n.t(`Searching Knowledge for "{{searchQuery}}"`, { searchQuery: status.query }))}</div></div>` : `${status?.action === "web_search_queries_generated" && status?.queries ? `<div class="flex flex-col justify-center -space-y-0.5"><div class="${escape((done || status?.done) === false ? "shimmer" : "", true) + " text-gray-500 dark:text-gray-500 text-base line-clamp-1 text-wrap"}">${escape($i18n.t(`Searching`))}</div> <div class="flex gap-1 flex-wrap mt-2">${each(status.queries, (query, idx) => {
    return `<div class="bg-gray-50 dark:bg-gray-850 flex rounded-lg py-1 px-2 items-center gap-1 text-xs"><div>${validate_component(Search, "Search").$$render($$result, { className: "size-3" }, {}, {})}</div> <span class="line-clamp-1">${escape(query)}</span> </div>`;
  })}</div></div>` : `${status?.action === "queries_generated" && status?.queries ? `<div class="flex flex-col justify-center -space-y-0.5"><div class="${escape((done || status?.done) === false ? "shimmer" : "", true) + " text-gray-500 dark:text-gray-500 text-base line-clamp-1 text-wrap"}">${escape($i18n.t(`Querying`))}</div> <div class="flex gap-1 flex-wrap mt-2">${each(status.queries, (query, idx) => {
    return `<div class="bg-gray-50 dark:bg-gray-850 flex rounded-lg py-1 px-2 items-center gap-1 text-xs"><div>${validate_component(Search, "Search").$$render($$result, { className: "size-3" }, {}, {})}</div> <span class="line-clamp-1">${escape(query)}</span> </div>`;
  })}</div></div>` : `${status?.action === "sources_retrieved" && status?.count !== void 0 ? `<div class="flex flex-col justify-center -space-y-0.5"><div class="${escape((done || status?.done) === false ? "shimmer" : "", true) + " text-gray-500 dark:text-gray-500 text-base line-clamp-1 text-wrap"}">${status.count === 0 ? `${escape($i18n.t("No sources found"))}` : `${status.count === 1 ? `${escape($i18n.t("Retrieved 1 source"))}` : `    ${escape($i18n.t("Retrieved {{count}} sources", { count: status.count }))}`}`}</div></div>` : `<div class="flex flex-col justify-center -space-y-0.5"><div class="${escape((done || status?.done) === false ? "shimmer" : "", true) + " text-gray-500 dark:text-gray-500 text-base line-clamp-1 text-wrap"}"> ${status?.description?.includes("{{searchQuery}}") ? `${escape($i18n.t(status?.description, { searchQuery: status?.query }))}` : `${status?.description === "No search query generated" ? `${escape($i18n.t("No search query generated"))}` : `${status?.description === "Generating search query" ? `${escape($i18n.t("Generating search query"))}` : `${status?.description === "Searching the web" ? `${escape($i18n.t("Searching the web"))}` : `${escape(status?.description)}`}`}`}`}</div></div>`}`}`}`}`}</div>` : ``}`;
});
const StatusHistory = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  let { statusHistory = [] } = $$props;
  let { expand = false } = $$props;
  let showHistory = true;
  let history = [];
  let status = null;
  if ($$props.statusHistory === void 0 && $$bindings.statusHistory && statusHistory !== void 0) $$bindings.statusHistory(statusHistory);
  if ($$props.expand === void 0 && $$bindings.expand && expand !== void 0) $$bindings.expand(expand);
  {
    if (expand) {
      showHistory = true;
    } else {
      showHistory = false;
    }
  }
  {
    if (JSON.stringify(statusHistory) !== JSON.stringify(history)) {
      history = statusHistory;
    }
  }
  {
    if (history && history.length > 0) {
      status = history.at(-1);
    }
  }
  return `${history && history.length > 0 ? `${status?.hidden !== true ? `<div class="text-sm flex flex-col w-full">${showHistory ? `<div class="flex flex-row">${history.length > 1 ? `<div class="w-full">${each(history, (status2, idx) => {
    return `${idx !== history.length - 1 ? `<div class="flex items-stretch gap-2 mb-1"><div class="" data-svelte-h="svelte-r0z7dq"><div class="pt-3 px-1 mb-1.5"><span class="relative flex size-1.5 rounded-full justify-center items-center"><span class="relative inline-flex size-1.5 rounded-full bg-gray-500 dark:bg-gray-300"></span> </span></div> <div class="w-[0.5px] ml-[6.5px] h-[calc(100%-14px)] bg-gray-300 dark:bg-gray-700"></div></div> ${validate_component(StatusItem, "StatusItem").$$render($$result, { status: status2, done: true }, {}, {})} </div>` : ``}`;
  })}</div>` : ``}</div>` : ``} <button class="w-full"><div class="flex items-start gap-2">${history.length > 1 ? `<div class="pt-3 px-1"><span class="relative flex size-1.5 rounded-full justify-center items-center">${status?.done === false ? `<span class="absolute inline-flex h-full w-full animate-ping rounded-full bg-gray-500 dark:bg-gray-300 opacity-75"></span>` : ``} <span class="relative inline-flex size-1.5 rounded-full bg-gray-500 dark:bg-gray-300"></span></span></div>` : ``} ${validate_component(StatusItem, "StatusItem").$$render($$result, { status }, {}, {})}</div></button></div>` : ``}` : ``}`;
});
const css$1 = {
  code: ".buttons.svelte-1u5gq5j::-webkit-scrollbar{display:none}.buttons.svelte-1u5gq5j{-ms-overflow-style:none;scrollbar-width:none}",
  map: `{"version":3,"file":"ResponseMessage.svelte","sources":["ResponseMessage.svelte"],"sourcesContent":["<script lang=\\"ts\\">import { toast } from \\"svelte-sonner\\";\\nimport dayjs from \\"dayjs\\";\\nimport { createEventDispatcher } from \\"svelte\\";\\nimport { onMount, tick, getContext } from \\"svelte\\";\\nconst i18n = getContext(\\"i18n\\");\\nconst dispatch = createEventDispatcher();\\nimport { createNewFeedback, getFeedbackById, updateFeedbackById } from \\"$lib/apis/evaluations\\";\\nimport { getChatById } from \\"$lib/apis/chats\\";\\nimport { generateTags } from \\"$lib/apis\\";\\nimport { config, models, settings, temporaryChatEnabled, TTSWorker, user } from \\"$lib/stores\\";\\nimport { synthesizeOpenAISpeech } from \\"$lib/apis/audio\\";\\nimport { imageGenerations } from \\"$lib/apis/images\\";\\nimport {\\n  copyToClipboard as _copyToClipboard,\\n  approximateToHumanReadable,\\n  getMessageContentParts,\\n  sanitizeResponseContent,\\n  createMessagesList,\\n  formatDate,\\n  removeDetails,\\n  removeAllDetails\\n} from \\"$lib/utils\\";\\nimport { WEBUI_BASE_URL } from \\"$lib/constants\\";\\nimport Name from \\"./Name.svelte\\";\\nimport ProfileImage from \\"./ProfileImage.svelte\\";\\nimport Skeleton from \\"./Skeleton.svelte\\";\\nimport Image from \\"$lib/components/common/Image.svelte\\";\\nimport Tooltip from \\"$lib/components/common/Tooltip.svelte\\";\\nimport RateComment from \\"./RateComment.svelte\\";\\nimport Spinner from \\"$lib/components/common/Spinner.svelte\\";\\nimport WebSearchResults from \\"./ResponseMessage/WebSearchResults.svelte\\";\\nimport Sparkles from \\"$lib/components/icons/Sparkles.svelte\\";\\nimport DeleteConfirmDialog from \\"$lib/components/common/ConfirmDialog.svelte\\";\\nimport Error from \\"./Error.svelte\\";\\nimport Citations from \\"./Citations.svelte\\";\\nimport CodeExecutions from \\"./CodeExecutions.svelte\\";\\nimport ContentRenderer from \\"./ContentRenderer.svelte\\";\\nimport { KokoroWorker } from \\"$lib/workers/KokoroWorker\\";\\nimport FileItem from \\"$lib/components/common/FileItem.svelte\\";\\nimport FollowUps from \\"./ResponseMessage/FollowUps.svelte\\";\\nimport { fade } from \\"svelte/transition\\";\\nimport { flyAndScale } from \\"$lib/utils/transitions\\";\\nimport RegenerateMenu from \\"./ResponseMessage/RegenerateMenu.svelte\\";\\nimport StatusHistory from \\"./ResponseMessage/StatusHistory.svelte\\";\\nimport FullHeightIframe from \\"$lib/components/common/FullHeightIframe.svelte\\";\\nexport let chatId = \\"\\";\\nexport let history;\\nexport let messageId;\\nexport let selectedModels = [];\\nlet message = JSON.parse(JSON.stringify(history.messages[messageId]));\\n$: if (history.messages) {\\n  if (JSON.stringify(message) !== JSON.stringify(history.messages[messageId])) {\\n    message = JSON.parse(JSON.stringify(history.messages[messageId]));\\n  }\\n}\\nexport let siblings;\\nexport let setInputText = () => {\\n};\\nexport let gotoMessage = () => {\\n};\\nexport let showPreviousMessage;\\nexport let showNextMessage;\\nexport let updateChat;\\nexport let editMessage;\\nexport let saveMessage;\\nexport let rateMessage;\\nexport let actionMessage;\\nexport let deleteMessage;\\nexport let submitMessage;\\nexport let continueResponse;\\nexport let regenerateResponse;\\nexport let addMessages;\\nexport let isLastMessage = true;\\nexport let readOnly = false;\\nexport let editCodeBlock = true;\\nexport let topPadding = false;\\nlet citationsElement;\\nlet buttonsContainerElement;\\nlet showDeleteConfirm = false;\\nlet model = null;\\n$: model = $models.find((m) => m.id === message.model);\\nlet edit = false;\\nlet editedContent = \\"\\";\\nlet editTextAreaElement;\\nlet messageIndexEdit = false;\\nlet audioParts = {};\\nlet speaking = false;\\nlet speakingIdx;\\nlet loadingSpeech = false;\\nlet generatingImage = false;\\nlet showRateComment = false;\\nconst copyToClipboard = async (text) => {\\n  text = removeAllDetails(text);\\n  if (($config?.ui?.response_watermark ?? \\"\\").trim() !== \\"\\") {\\n    text = \`\${text}\\n\\n\${$config?.ui?.response_watermark}\`;\\n  }\\n  const res = await _copyToClipboard(text, null, $settings?.copyFormatted ?? false);\\n  if (res) {\\n    toast.success($i18n.t(\\"Copying to clipboard was successful!\\"));\\n  }\\n};\\nconst playAudio = (idx) => {\\n  return new Promise((res) => {\\n    speakingIdx = idx;\\n    const audio = audioParts[idx];\\n    if (!audio) {\\n      return res();\\n    }\\n    audio.play();\\n    audio.onended = async () => {\\n      await new Promise((r) => setTimeout(r, 300));\\n      if (Object.keys(audioParts).length - 1 === idx) {\\n        speaking = false;\\n      }\\n      res();\\n    };\\n  });\\n};\\nconst toggleSpeakMessage = async () => {\\n  if (speaking) {\\n    try {\\n      speechSynthesis.cancel();\\n      if (speakingIdx !== void 0 && audioParts[speakingIdx]) {\\n        audioParts[speakingIdx].pause();\\n        audioParts[speakingIdx].currentTime = 0;\\n      }\\n    } catch {\\n    }\\n    speaking = false;\\n    speakingIdx = void 0;\\n    return;\\n  }\\n  if (!(message?.content ?? \\"\\").trim().length) {\\n    toast.info($i18n.t(\\"No content to speak\\"));\\n    return;\\n  }\\n  speaking = true;\\n  const content = removeAllDetails(message.content);\\n  if ($config.audio.tts.engine === \\"\\") {\\n    let voices = [];\\n    const getVoicesLoop = setInterval(() => {\\n      voices = speechSynthesis.getVoices();\\n      if (voices.length > 0) {\\n        clearInterval(getVoicesLoop);\\n        const voice = voices?.filter(\\n          (v) => v.voiceURI === ($settings?.audio?.tts?.voice ?? $config?.audio?.tts?.voice)\\n        )?.at(0) ?? void 0;\\n        console.log(voice);\\n        const speak = new SpeechSynthesisUtterance(content);\\n        speak.rate = $settings.audio?.tts?.playbackRate ?? 1;\\n        console.log(speak);\\n        speak.onend = () => {\\n          speaking = false;\\n          if ($settings.conversationMode) {\\n            document.getElementById(\\"voice-input-button\\")?.click();\\n          }\\n        };\\n        if (voice) {\\n          speak.voice = voice;\\n        }\\n        speechSynthesis.speak(speak);\\n      }\\n    }, 100);\\n  } else {\\n    loadingSpeech = true;\\n    const messageContentParts = getMessageContentParts(\\n      content,\\n      $config?.audio?.tts?.split_on ?? \\"punctuation\\"\\n    );\\n    if (!messageContentParts.length) {\\n      console.log(\\"No content to speak\\");\\n      toast.info($i18n.t(\\"No content to speak\\"));\\n      speaking = false;\\n      loadingSpeech = false;\\n      return;\\n    }\\n    console.debug(\\"Prepared message content for TTS\\", messageContentParts);\\n    audioParts = messageContentParts.reduce(\\n      (acc, _sentence, idx) => {\\n        acc[idx] = null;\\n        return acc;\\n      },\\n      {}\\n    );\\n    let lastPlayedAudioPromise = Promise.resolve();\\n    if ($settings.audio?.tts?.engine === \\"browser-kokoro\\") {\\n      if (!$TTSWorker) {\\n        await TTSWorker.set(\\n          new KokoroWorker({\\n            dtype: $settings.audio?.tts?.engineConfig?.dtype ?? \\"fp32\\"\\n          })\\n        );\\n        await $TTSWorker.init();\\n      }\\n      for (const [idx, sentence] of messageContentParts.entries()) {\\n        const blob = await $TTSWorker.generate({\\n          text: sentence,\\n          voice: $settings?.audio?.tts?.voice ?? $config?.audio?.tts?.voice\\n        }).catch((error) => {\\n          console.error(error);\\n          toast.error(\`\${error}\`);\\n          speaking = false;\\n          loadingSpeech = false;\\n        });\\n        if (blob) {\\n          const audio = new Audio(blob);\\n          audio.playbackRate = $settings.audio?.tts?.playbackRate ?? 1;\\n          audioParts[idx] = audio;\\n          loadingSpeech = false;\\n          lastPlayedAudioPromise = lastPlayedAudioPromise.then(() => playAudio(idx));\\n        }\\n      }\\n    } else {\\n      for (const [idx, sentence] of messageContentParts.entries()) {\\n        const res = await synthesizeOpenAISpeech(\\n          localStorage.token,\\n          $settings?.audio?.tts?.defaultVoice === $config.audio.tts.voice ? $settings?.audio?.tts?.voice ?? $config?.audio?.tts?.voice : $config?.audio?.tts?.voice,\\n          sentence\\n        ).catch((error) => {\\n          console.error(error);\\n          toast.error(\`\${error}\`);\\n          speaking = false;\\n          loadingSpeech = false;\\n        });\\n        if (res) {\\n          const blob = await res.blob();\\n          const blobUrl = URL.createObjectURL(blob);\\n          const audio = new Audio(blobUrl);\\n          audio.playbackRate = $settings.audio?.tts?.playbackRate ?? 1;\\n          audioParts[idx] = audio;\\n          loadingSpeech = false;\\n          lastPlayedAudioPromise = lastPlayedAudioPromise.then(() => playAudio(idx));\\n        }\\n      }\\n    }\\n  }\\n};\\nlet preprocessedDetailsCache = [];\\nfunction preprocessForEditing(content) {\\n  const detailsBlocks = [];\\n  let i = 0;\\n  content = content.replace(/<details[\\\\s\\\\S]*?<\\\\/details>/gi, (match) => {\\n    detailsBlocks.push(match);\\n    return \`<details id=\\"__DETAIL_\${i++}__\\"/>\`;\\n  });\\n  preprocessedDetailsCache = detailsBlocks;\\n  return content;\\n}\\nfunction postprocessAfterEditing(content) {\\n  const restoredContent = content.replace(\\n    /<details id=\\"__DETAIL_(\\\\d+)__\\"\\\\/>/g,\\n    (_, index) => preprocessedDetailsCache[parseInt(index)] || \\"\\"\\n  );\\n  return restoredContent;\\n}\\nconst editMessageHandler = async () => {\\n  edit = true;\\n  editedContent = preprocessForEditing(message.content);\\n  await tick();\\n  editTextAreaElement.style.height = \\"\\";\\n  editTextAreaElement.style.height = \`\${editTextAreaElement.scrollHeight}px\`;\\n};\\nconst editMessageConfirmHandler = async () => {\\n  const messageContent = postprocessAfterEditing(editedContent ? editedContent : \\"\\");\\n  editMessage(message.id, { content: messageContent }, false);\\n  edit = false;\\n  editedContent = \\"\\";\\n  await tick();\\n};\\nconst saveAsCopyHandler = async () => {\\n  const messageContent = postprocessAfterEditing(editedContent ? editedContent : \\"\\");\\n  editMessage(message.id, { content: messageContent });\\n  edit = false;\\n  editedContent = \\"\\";\\n  await tick();\\n};\\nconst cancelEditMessage = async () => {\\n  edit = false;\\n  editedContent = \\"\\";\\n  await tick();\\n};\\nconst generateImage = async (message2) => {\\n  generatingImage = true;\\n  const res = await imageGenerations(localStorage.token, message2.content).catch((error) => {\\n    toast.error(\`\${error}\`);\\n  });\\n  console.log(res);\\n  if (res) {\\n    const files = res.map((image) => ({\\n      type: \\"image\\",\\n      url: \`\${image.url}\`\\n    }));\\n    saveMessage(message2.id, {\\n      ...message2,\\n      files\\n    });\\n  }\\n  generatingImage = false;\\n};\\nlet feedbackLoading = false;\\nconst feedbackHandler = async (rating = null, details = null) => {\\n  feedbackLoading = true;\\n  console.log(\\"Feedback\\", rating, details);\\n  const updatedMessage = {\\n    ...message,\\n    annotation: {\\n      ...message?.annotation ?? {},\\n      ...rating !== null ? { rating } : {},\\n      ...details ? details : {}\\n    }\\n  };\\n  const chat = await getChatById(localStorage.token, chatId).catch((error) => {\\n    toast.error(\`\${error}\`);\\n  });\\n  if (!chat) {\\n    return;\\n  }\\n  const messages = createMessagesList(history, message.id);\\n  let feedbackItem = {\\n    type: \\"rating\\",\\n    data: {\\n      ...updatedMessage?.annotation ? updatedMessage.annotation : {},\\n      model_id: message?.selectedModelId ?? message.model,\\n      ...history.messages[message.parentId].childrenIds.length > 1 ? {\\n        sibling_model_ids: history.messages[message.parentId].childrenIds.filter((id) => id !== message.id).map((id) => history.messages[id]?.selectedModelId ?? history.messages[id].model)\\n      } : {}\\n    },\\n    meta: {\\n      arena: message ? message.arena : false,\\n      model_id: message.model,\\n      message_id: message.id,\\n      message_index: messages.length,\\n      chat_id: chatId\\n    },\\n    snapshot: {\\n      chat\\n    }\\n  };\\n  const baseModels = [\\n    feedbackItem.data.model_id,\\n    ...feedbackItem.data.sibling_model_ids ?? []\\n  ].reduce((acc, modelId) => {\\n    const model2 = $models.find((m) => m.id === modelId);\\n    if (model2) {\\n      acc[model2.id] = model2?.info?.base_model_id ?? null;\\n    } else {\\n      console.warn(\`Model with ID \${modelId} not found\`);\\n    }\\n    return acc;\\n  }, {});\\n  feedbackItem.meta.base_models = baseModels;\\n  let feedback = null;\\n  if (message?.feedbackId) {\\n    feedback = await updateFeedbackById(\\n      localStorage.token,\\n      message.feedbackId,\\n      feedbackItem\\n    ).catch((error) => {\\n      toast.error(\`\${error}\`);\\n    });\\n  } else {\\n    feedback = await createNewFeedback(localStorage.token, feedbackItem).catch((error) => {\\n      toast.error(\`\${error}\`);\\n    });\\n    if (feedback) {\\n      updatedMessage.feedbackId = feedback.id;\\n    }\\n  }\\n  console.log(updatedMessage);\\n  saveMessage(message.id, updatedMessage);\\n  await tick();\\n  if (!details) {\\n    showRateComment = true;\\n    if (!updatedMessage.annotation?.tags && (message?.content ?? \\"\\") !== \\"\\") {\\n      const tags = await generateTags(localStorage.token, message.model, messages, chatId).catch(\\n        (error) => {\\n          console.error(error);\\n          return [];\\n        }\\n      );\\n      console.log(tags);\\n      if (tags) {\\n        updatedMessage.annotation.tags = tags;\\n        feedbackItem.data.tags = tags;\\n        saveMessage(message.id, updatedMessage);\\n        await updateFeedbackById(\\n          localStorage.token,\\n          updatedMessage.feedbackId,\\n          feedbackItem\\n        ).catch((error) => {\\n          toast.error(\`\${error}\`);\\n        });\\n      }\\n    }\\n  }\\n  feedbackLoading = false;\\n};\\nconst deleteMessageHandler = async () => {\\n  deleteMessage(message.id);\\n};\\n$: if (!edit) {\\n  (async () => {\\n    await tick();\\n  })();\\n}\\nonMount(async () => {\\n  await tick();\\n  if (buttonsContainerElement) {\\n    buttonsContainerElement.addEventListener(\\"wheel\\", function(event) {\\n      if (buttonsContainerElement.scrollWidth <= buttonsContainerElement.clientWidth) {\\n        return;\\n      } else {\\n        event.preventDefault();\\n        if (event.deltaY !== 0) {\\n          buttonsContainerElement.scrollLeft += event.deltaY;\\n        }\\n      }\\n    });\\n  }\\n});\\n<\/script>\\n\\n<DeleteConfirmDialog\\n\\tbind:show={showDeleteConfirm}\\n\\ttitle={$i18n.t('Delete message?')}\\n\\ton:confirm={() => {\\n\\t\\tdeleteMessageHandler();\\n\\t}}\\n/>\\n\\n{#key message.id}\\n\\t<div\\n\\t\\tclass=\\" flex w-full message-{message.id}\\"\\n\\t\\tid=\\"message-{message.id}\\"\\n\\t\\tdir={$settings.chatDirection}\\n\\t>\\n\\t\\t<div class={\`shrink-0 ltr:mr-3 rtl:ml-3 hidden @lg:flex mt-1 \`}>\\n\\t\\t\\t<ProfileImage\\n\\t\\t\\t\\tsrc={model?.info?.meta?.profile_image_url ??\\n\\t\\t\\t\\t\\t($i18n.language === 'dg-DG'\\n\\t\\t\\t\\t\\t\\t? \`\${WEBUI_BASE_URL}/doge.png\`\\n\\t\\t\\t\\t\\t\\t: \`\${WEBUI_BASE_URL}/favicon.png\`)}\\n\\t\\t\\t\\tclassName={'size-8 assistant-message-profile-image'}\\n\\t\\t\\t/>\\n\\t\\t</div>\\n\\n\\t\\t<div class=\\"flex-auto w-0 pl-1 relative\\">\\n\\t\\t\\t<Name>\\n\\t\\t\\t\\t<Tooltip content={model?.name ?? message.model} placement=\\"top-start\\">\\n\\t\\t\\t\\t\\t<span class=\\"line-clamp-1 text-black dark:text-white\\">\\n\\t\\t\\t\\t\\t\\t{model?.name ?? message.model}\\n\\t\\t\\t\\t\\t</span>\\n\\t\\t\\t\\t</Tooltip>\\n\\n\\t\\t\\t\\t{#if message.timestamp}\\n\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\tclass=\\"self-center text-xs font-medium first-letter:capitalize ml-0.5 translate-y-[1px] {($settings?.highContrastMode ??\\n\\t\\t\\t\\t\\t\\tfalse)\\n\\t\\t\\t\\t\\t\\t\\t? 'dark:text-gray-100 text-gray-900'\\n\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible transition text-gray-400'}\\"\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t<Tooltip content={dayjs(message.timestamp * 1000).format('LLLL')}>\\n\\t\\t\\t\\t\\t\\t\\t<span class=\\"line-clamp-1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t>{$i18n.t(formatDate(message.timestamp * 1000), {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tLOCALIZED_TIME: dayjs(message.timestamp * 1000).format('LT'),\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tLOCALIZED_DATE: dayjs(message.timestamp * 1000).format('L')\\n\\t\\t\\t\\t\\t\\t\\t\\t})}</span\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t</Name>\\n\\n\\t\\t\\t<div>\\n\\t\\t\\t\\t<div class=\\"chat-{message.role} w-full min-w-full markdown-prose\\">\\n\\t\\t\\t\\t\\t<div>\\n\\t\\t\\t\\t\\t\\t{#if model?.info?.meta?.capabilities?.status_updates ?? true}\\n\\t\\t\\t\\t\\t\\t\\t<StatusHistory\\n\\t\\t\\t\\t\\t\\t\\t\\tstatusHistory={message?.statusHistory}\\n\\t\\t\\t\\t\\t\\t\\t\\texpand={message?.content === ''}\\n\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t{#if message?.files && message.files?.filter((f) => f.type === 'image').length > 0}\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"my-1 w-full flex overflow-x-auto gap-2 flex-wrap\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t{#each message.files as file}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if file.type === 'image'}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Image src={file.url} alt={message.content} />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<FileItem\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\titem={file}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\turl={file.url}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tname={file.name}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype={file.type}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsize={file?.size}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsmall={true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/each}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t{#if message?.embeds && message.embeds.length > 0}\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"my-1 w-full flex overflow-x-auto gap-2 flex-wrap\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t{#each message.embeds as embed, idx}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\"my-2 w-full\\" id={\`\${message.id}-embeds-\${idx}\`}>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<FullHeightIframe\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsrc={embed}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tallowScripts={true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tallowForms={true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tallowSameOrigin={true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tallowPopups={true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/each}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t{#if edit === true}\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"w-full bg-gray-50 dark:bg-gray-800 rounded-3xl px-5 py-3 my-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t<textarea\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"message-edit-{message.id}\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tbind:this={editTextAreaElement}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\" bg-transparent outline-hidden w-full resize-none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tbind:value={editedContent}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ton:input={(e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\te.target.style.height = '';\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\te.target.style.height = \`\${e.target.scrollHeight}px\`;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ton:keydown={(e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tif (e.key === 'Escape') {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdocument.getElementById('close-edit-message-button')?.click();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tconst isCmdOrCtrlPressed = e.metaKey || e.ctrlKey;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tconst isEnterPressed = e.key === 'Enter';\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tif (isCmdOrCtrlPressed && isEnterPressed) {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdocument.getElementById('confirm-edit-message-button')?.click();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" mt-2 mb-1 flex justify-between text-sm font-medium\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"save-new-message-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"px-3.5 py-1.5 bg-gray-50 hover:bg-gray-100 dark:bg-gray-800 dark:hover:bg-gray-700 border border-gray-100 dark:border-gray-700 text-gray-700 dark:text-gray-200 transition rounded-3xl\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsaveAsCopyHandler();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Save As Copy')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\"flex space-x-1.5\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"close-edit-message-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"px-3.5 py-1.5 bg-white dark:bg-gray-900 hover:bg-gray-100 text-gray-800 dark:text-gray-100 transition rounded-3xl\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tcancelEditMessage();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Cancel')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"confirm-edit-message-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"px-3.5 py-1.5 bg-gray-900 dark:bg-white hover:bg-gray-850 text-gray-100 dark:text-gray-800 transition rounded-3xl\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\teditMessageConfirmHandler();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Save')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"w-full flex flex-col relative\\" id=\\"response-content-container\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if message.content === '' && !message.error && ((model?.info?.meta?.capabilities?.status_updates ?? true) ? (message?.statusHistory ?? [...(message?.status ? [message?.status] : [])]).length === 0 || (message?.statusHistory?.at(-1)?.hidden ?? false) : true)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Skeleton />\\n\\t\\t\\t\\t\\t\\t\\t\\t{:else if message.content && message.error !== true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<!-- always show message contents even if there's an error -->\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<!-- unless message.error === true which is legacy error handling, where the error message is stored in message.content -->\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<ContentRenderer\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid={\`\${chatId}-\${message.id}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessageId={message.id}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{history}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{selectedModels}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tcontent={message.content}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsources={message.sources}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfloatingButtons={message?.done &&\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t!readOnly &&\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t($settings?.showFloatingActionButtons ?? true)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsave={!readOnly}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tpreview={!readOnly}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{editCodeBlock}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{topPadding}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdone={($settings?.chatFadeStreamingText ?? true)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? (message?.done ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{model}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonTaskClick={async (e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tconsole.log(e);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonSourceClick={async (id, idx) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tconsole.log(id, idx);\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tif (citationsElement) {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tcitationsElement?.showSourceModal(idx - 1);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonAddMessages={({ modelId, parentId, messages }) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taddMessages({ modelId, parentId, messages });\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonSave={({ raw, oldContent, newContent }) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\thistory.messages[message.id].content = history.messages[\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessage.id\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t].content.replace(raw, raw.replace(oldContent, newContent));\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tupdateChat();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if message?.error}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Error content={message?.error?.content ?? message.content} />\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if (message?.sources || message?.citations) && (model?.info?.meta?.capabilities?.citations ?? true)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Citations\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tbind:this={citationsElement}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid={message?.id}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsources={message?.sources ?? message?.citations}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{readOnly}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if message.code_executions}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<CodeExecutions codeExecutions={message.code_executions} />\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t{#if !edit}\\n\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\tbind:this={buttonsContainerElement}\\n\\t\\t\\t\\t\\t\\tclass=\\"flex justify-start overflow-x-auto buttons text-gray-600 dark:text-gray-500 mt-0.5\\"\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t{#if message.done || siblings.length > 1}\\n\\t\\t\\t\\t\\t\\t\\t{#if siblings.length > 1}\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\"flex self-center min-w-fit\\" dir=\\"ltr\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Previous message')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tshowPreviousMessage(message);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"size-3.5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M15.75 19.5 8.25 12l7.5-7.5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if messageIndexEdit}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"text-sm flex justify-center font-semibold self-center dark:text-gray-100 min-w-fit\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<input\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"message-index-input-{message.id}\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype=\\"number\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tvalue={siblings.indexOf(message.id) + 1}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmin=\\"1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmax={siblings.length}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:focus={(e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\te.target.select();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:blur={(e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tgotoMessage(message, e.target.value - 1);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessageIndexEdit = false;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:keydown={(e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tif (e.key === 'Enter') {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tgotoMessage(message, e.target.value - 1);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessageIndexEdit = false;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"bg-transparent font-semibold self-center dark:text-gray-100 min-w-fit outline-hidden\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>/{siblings.length}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<!-- svelte-ignore a11y-no-static-element-interactions -->\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"text-sm tracking-widest font-semibold self-center dark:text-gray-100 min-w-fit\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:dblclick={async () => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessageIndexEdit = true;\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tawait tick();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tconst input = document.getElementById(\`message-index-input-\${message.id}\`);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tif (input) {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tinput.focus();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tinput.select();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{siblings.indexOf(message.id) + 1}/{siblings.length}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tshowNextMessage(message);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Next message')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"size-3.5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"m8.25 4.5 7.5 7.5-7.5 7.5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t{#if message.done}\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if !readOnly}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if $user?.role === 'user' ? ($user?.permissions?.chat?.edit ?? true) : true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Edit')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Edit')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\teditMessageHandler();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Copy')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Copy')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition copy-response-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tcopyToClipboard(message.content);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M15.666 3.888A2.25 2.25 0 0013.5 2.25h-3c-1.03 0-1.9.693-2.166 1.638m7.332 0c.055.194.084.4.084.612v0a.75.75 0 01-.75.75H9a.75.75 0 01-.75-.75v0c0-.212.03-.418.084-.612m7.332 0c.646.049 1.288.11 1.927.184 1.1.128 1.907 1.077 1.907 2.185V19.5a2.25 2.25 0 01-2.25 2.25H6.75A2.25 2.25 0 014.5 19.5V6.257c0-1.108.806-2.057 1.907-2.185a48.208 48.208 0 011.927-.184\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if $user?.role === 'admin' || ($user?.permissions?.chat?.tts ?? true)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Read Aloud')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Read Aloud')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"speak-button-{message.id}\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tif (!loadingSpeech) {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttoggleSpeakMessage();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if loadingSpeech}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\" w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<style>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.spinner_S1WN {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation: spinner_MGfb 0.8s linear infinite;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation-delay: -0.8s;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.spinner_Km9P {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation-delay: -0.65s;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.spinner_JApP {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation-delay: -0.5s;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t@keyframes spinner_MGfb {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t93.75%,\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t100% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\topacity: 0.2;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</style>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<circle class=\\"spinner_S1WN\\" cx=\\"4\\" cy=\\"12\\" r=\\"3\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<circle class=\\"spinner_S1WN spinner_Km9P\\" cx=\\"12\\" cy=\\"12\\" r=\\"3\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<circle class=\\"spinner_S1WN spinner_JApP\\" cx=\\"20\\" cy=\\"12\\" r=\\"3\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{:else if speaking}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M17.25 9.75 19.5 12m0 0 2.25 2.25M19.5 12l2.25-2.25M19.5 12l-2.25 2.25m-10.5-6 4.72-4.72a.75.75 0 0 1 1.28.53v15.88a.75.75 0 0 1-1.28.53l-4.72-4.72H4.51c-.88 0-1.704-.507-1.938-1.354A9.009 9.009 0 0 1 2.25 12c0-.83.112-1.633.322-2.396C2.806 8.756 3.63 8.25 4.51 8.25H6.75Z\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M19.114 5.636a9 9 0 010 12.728M16.463 8.288a5.25 5.25 0 010 7.424M6.75 8.25l4.72-4.72a.75.75 0 011.28.53v15.88a.75.75 0 01-1.28.53l-4.72-4.72H4.51c-.88 0-1.704-.507-1.938-1.354A9.01 9.01 0 012.25 12c0-.83.112-1.633.322-2.396C2.806 8.756 3.63 8.25 4.51 8.25H6.75z\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if $config?.features.enable_image_generation && ($user?.role === 'admin' || $user?.permissions?.features?.image_generation) && !readOnly}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Generate Image')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Generate Image')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'}  p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tif (!generatingImage) {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tgenerateImage(message);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if generatingImage}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\" w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<style>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.spinner_S1WN {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation: spinner_MGfb 0.8s linear infinite;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation-delay: -0.8s;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.spinner_Km9P {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation-delay: -0.65s;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.spinner_JApP {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tanimation-delay: -0.5s;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t@keyframes spinner_MGfb {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t93.75%,\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t100% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\topacity: 0.2;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</style>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<circle class=\\"spinner_S1WN\\" cx=\\"4\\" cy=\\"12\\" r=\\"3\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<circle class=\\"spinner_S1WN spinner_Km9P\\" cx=\\"12\\" cy=\\"12\\" r=\\"3\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<circle class=\\"spinner_S1WN spinner_JApP\\" cx=\\"20\\" cy=\\"12\\" r=\\"3\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if message.usage}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tcontent={message.usage\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? \`<pre>\${sanitizeResponseContent(\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tJSON.stringify(message.usage, null, 2)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.replace(/\\"([^(\\")\\"]+)\\":/g, '$1:')\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.slice(1, -1)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.split('\\\\n')\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.map((line) => line.slice(2))\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.map((line) => (line.endsWith(',') ? line.slice(0, -1) : line))\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.join('\\\\n')\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t)}</pre>\`\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tplacement=\\"bottom\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\" {isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition whitespace-pre-wrap\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tconsole.log(message);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"info-{message.id}\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if !readOnly}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if !$temporaryChatEnabled && ($config?.features.enable_message_rating ?? true) && ($user?.role === 'admin' || ($user?.permissions?.chat?.rate_response ?? true))}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Good Response')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Good Response')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg {(\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessage?.annotation?.rating ?? ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t).toString() === '1'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'bg-gray-100 dark:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''} dark:hover:text-white hover:text-black transition disabled:cursor-progress disabled:hover:bg-transparent\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdisabled={feedbackLoading}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={async () => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tawait feedbackHandler(1);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\twindow.setTimeout(() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdocument\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.getElementById(\`message-feedback-\${message.id}\`)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t?.scrollIntoView();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}, 0);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Bad Response')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Bad Response')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg {(\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessage?.annotation?.rating ?? ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t).toString() === '-1'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'bg-gray-100 dark:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''} dark:hover:text-white hover:text-black transition disabled:cursor-progress disabled:hover:bg-transparent\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdisabled={feedbackLoading}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={async () => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tawait feedbackHandler(-1);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\twindow.setTimeout(() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdocument\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t.getElementById(\`message-feedback-\${message.id}\`)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t?.scrollIntoView();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}, 0);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M10 15v4a3 3 0 0 0 3 3l4-9V2H5.72a2 2 0 0 0-2 1.7l-1.38 9a2 2 0 0 0 2 2.3zm7-13h2.67A2.31 2.31 0 0 1 22 4v7a2.31 2.31 0 0 1-2.33 2H17\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if isLastMessage && ($user?.role === 'admin' || ($user?.permissions?.chat?.continue_response ?? true))}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Continue Response')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Continue Response')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype=\\"button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"continue-response-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tcontinueResponse();\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M15.91 11.672a.375.375 0 0 1 0 .656l-5.603 3.113a.375.375 0 0 1-.557-.328V8.887c0-.286.307-.466.557-.327l5.603 3.112Z\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if $user?.role === 'admin' || ($user?.permissions?.chat?.regenerate_response ?? true)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if $settings?.regenerateMenu ?? true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype=\\"button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"hidden regenerate-response-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tshowRateComment = false;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tregenerateResponse(message);\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t(model?.actions ?? []).forEach((action) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdispatch('action', {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid: action.id,\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tevent: {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid: 'regenerate-response',\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdata: {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessageId: message.id\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<RegenerateMenu\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonRegenerate={(prompt = null) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tshowRateComment = false;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tregenerateResponse(message, prompt);\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t(model?.actions ?? []).forEach((action) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdispatch('action', {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid: action.id,\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tevent: {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid: 'regenerate-response',\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdata: {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessageId: message.id\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Regenerate')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Regenerate')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</RegenerateMenu>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Regenerate')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype=\\"button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Regenerate')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition regenerate-response-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tshowRateComment = false;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tregenerateResponse(message);\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t(model?.actions ?? []).forEach((action) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdispatch('action', {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid: action.id,\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tevent: {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid: 'regenerate-response',\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tdata: {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tmessageId: message.id\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2.3\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if $user?.role === 'admin' || ($user?.permissions?.chat?.delete_message ?? true)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if siblings.length > 1}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Delete')} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype=\\"button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={$i18n.t('Delete')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"delete-response-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tshowDeleteConfirm = true;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-width=\\"2\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-hidden=\\"true\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<path\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linecap=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstroke-linejoin=\\"round\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\td=\\"m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if isLastMessage}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#each model?.actions ?? [] as action}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={action.name} placement=\\"bottom\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype=\\"button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\taria-label={action.name}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"{isLastMessage || ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'visible'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'invisible group-hover:visible'} p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tactionMessage(action.id, message);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if action?.icon}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\"size-4\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<img\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsrc={action.icon}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"w-4 h-4 {action.icon.includes('svg')\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:invert-[80%]'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''}\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tstyle=\\"fill: currentColor;\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\talt={action.name}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Sparkles strokeWidth=\\"2.1\\" className=\\"size-4\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/each}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t\\t{#if message.done && showRateComment}\\n\\t\\t\\t\\t\\t\\t<RateComment\\n\\t\\t\\t\\t\\t\\t\\tbind:message\\n\\t\\t\\t\\t\\t\\t\\tbind:show={showRateComment}\\n\\t\\t\\t\\t\\t\\t\\ton:save={async (e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\tawait feedbackHandler(null, {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t...e.detail\\n\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t{#if (isLastMessage || ($settings?.keepFollowUpPrompts ?? false)) && message.done && !readOnly && (message?.followUps ?? []).length > 0}\\n\\t\\t\\t\\t\\t\\t<div class=\\"mt-2.5\\" in:fade={{ duration: 100 }}>\\n\\t\\t\\t\\t\\t\\t\\t<FollowUps\\n\\t\\t\\t\\t\\t\\t\\t\\tfollowUps={message?.followUps}\\n\\t\\t\\t\\t\\t\\t\\t\\tonClick={(prompt) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tif ($settings?.insertFollowUpPrompt ?? false) {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t// Insert the follow-up prompt into the input box\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsetInputText(prompt);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t// Submit the follow-up prompt directly\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsubmitMessage(message?.id, prompt);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t</div>\\n\\t\\t</div>\\n\\t</div>\\n{/key}\\n\\n<style>\\n\\t.buttons::-webkit-scrollbar {\\n\\t\\tdisplay: none; /* for Chrome, Safari and Opera */\\n\\t}\\n\\n\\t.buttons {\\n\\t\\t-ms-overflow-style: none; /* IE and Edge */\\n\\t\\tscrollbar-width: none; /* Firefox */\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AA+zCC,uBAAQ,mBAAoB,CAC3B,OAAO,CAAE,IACV,CAEA,uBAAS,CACR,kBAAkB,CAAE,IAAI,CACxB,eAAe,CAAE,IAClB"}`
};
const ResponseMessage = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $models, $$unsubscribe_models;
  let $settings, $$unsubscribe_settings;
  let $config, $$unsubscribe_config;
  let $$unsubscribe_TTSWorker;
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_TTSWorker = subscribe(TTSWorker, (value) => value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  const dispatch = createEventDispatcher();
  let { chatId: chatId2 = "" } = $$props;
  let { history } = $$props;
  let { messageId } = $$props;
  let { selectedModels = [] } = $$props;
  let message = JSON.parse(JSON.stringify(history.messages[messageId]));
  let { siblings } = $$props;
  let { setInputText = () => {
  } } = $$props;
  let { gotoMessage = () => {
  } } = $$props;
  let { showPreviousMessage } = $$props;
  let { showNextMessage } = $$props;
  let { updateChat } = $$props;
  let { editMessage } = $$props;
  let { saveMessage } = $$props;
  let { rateMessage } = $$props;
  let { actionMessage } = $$props;
  let { deleteMessage } = $$props;
  let { submitMessage } = $$props;
  let { continueResponse } = $$props;
  let { regenerateResponse } = $$props;
  let { addMessages } = $$props;
  let { isLastMessage = true } = $$props;
  let { readOnly = false } = $$props;
  let { editCodeBlock = true } = $$props;
  let { topPadding = false } = $$props;
  let citationsElement;
  let buttonsContainerElement;
  let showDeleteConfirm = false;
  let model = null;
  let showRateComment = false;
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.messageId === void 0 && $$bindings.messageId && messageId !== void 0) $$bindings.messageId(messageId);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.siblings === void 0 && $$bindings.siblings && siblings !== void 0) $$bindings.siblings(siblings);
  if ($$props.setInputText === void 0 && $$bindings.setInputText && setInputText !== void 0) $$bindings.setInputText(setInputText);
  if ($$props.gotoMessage === void 0 && $$bindings.gotoMessage && gotoMessage !== void 0) $$bindings.gotoMessage(gotoMessage);
  if ($$props.showPreviousMessage === void 0 && $$bindings.showPreviousMessage && showPreviousMessage !== void 0) $$bindings.showPreviousMessage(showPreviousMessage);
  if ($$props.showNextMessage === void 0 && $$bindings.showNextMessage && showNextMessage !== void 0) $$bindings.showNextMessage(showNextMessage);
  if ($$props.updateChat === void 0 && $$bindings.updateChat && updateChat !== void 0) $$bindings.updateChat(updateChat);
  if ($$props.editMessage === void 0 && $$bindings.editMessage && editMessage !== void 0) $$bindings.editMessage(editMessage);
  if ($$props.saveMessage === void 0 && $$bindings.saveMessage && saveMessage !== void 0) $$bindings.saveMessage(saveMessage);
  if ($$props.rateMessage === void 0 && $$bindings.rateMessage && rateMessage !== void 0) $$bindings.rateMessage(rateMessage);
  if ($$props.actionMessage === void 0 && $$bindings.actionMessage && actionMessage !== void 0) $$bindings.actionMessage(actionMessage);
  if ($$props.deleteMessage === void 0 && $$bindings.deleteMessage && deleteMessage !== void 0) $$bindings.deleteMessage(deleteMessage);
  if ($$props.submitMessage === void 0 && $$bindings.submitMessage && submitMessage !== void 0) $$bindings.submitMessage(submitMessage);
  if ($$props.continueResponse === void 0 && $$bindings.continueResponse && continueResponse !== void 0) $$bindings.continueResponse(continueResponse);
  if ($$props.regenerateResponse === void 0 && $$bindings.regenerateResponse && regenerateResponse !== void 0) $$bindings.regenerateResponse(regenerateResponse);
  if ($$props.addMessages === void 0 && $$bindings.addMessages && addMessages !== void 0) $$bindings.addMessages(addMessages);
  if ($$props.isLastMessage === void 0 && $$bindings.isLastMessage && isLastMessage !== void 0) $$bindings.isLastMessage(isLastMessage);
  if ($$props.readOnly === void 0 && $$bindings.readOnly && readOnly !== void 0) $$bindings.readOnly(readOnly);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  $$result.css.add(css$1);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (history.messages) {
        if (JSON.stringify(message) !== JSON.stringify(history.messages[messageId])) {
          message = JSON.parse(JSON.stringify(history.messages[messageId]));
        }
      }
    }
    model = $models.find((m) => m.id === message.model);
    {
      {
        (async () => {
          await tick();
        })();
      }
    }
    $$rendered = `${validate_component(ConfirmDialog, "DeleteConfirmDialog").$$render(
      $$result,
      {
        title: $i18n.t("Delete message?"),
        show: showDeleteConfirm
      },
      {
        show: ($$value) => {
          showDeleteConfirm = $$value;
          $$settled = false;
        }
      },
      {}
    )} <div class="${"flex w-full message-" + escape(message.id, true) + " svelte-1u5gq5j"}" id="${"message-" + escape(message.id, true)}"${add_attribute("dir", $settings.chatDirection, 0)}><div class="${escape(null_to_empty(`shrink-0 ltr:mr-3 rtl:ml-3 hidden @lg:flex mt-1 `), true) + " svelte-1u5gq5j"}">${validate_component(ProfileImage, "ProfileImage").$$render(
      $$result,
      {
        src: model?.info?.meta?.profile_image_url ?? ($i18n.language === "dg-DG" ? `${WEBUI_BASE_URL}/doge.png` : `${WEBUI_BASE_URL}/favicon.png`),
        className: "size-8 assistant-message-profile-image"
      },
      {},
      {}
    )}</div> <div class="flex-auto w-0 pl-1 relative">${validate_component(Name, "Name").$$render($$result, {}, {}, {
      default: () => {
        return `${validate_component(Tooltip, "Tooltip").$$render(
          $$result,
          {
            content: model?.name ?? message.model,
            placement: "top-start"
          },
          {},
          {
            default: () => {
              return `<span class="line-clamp-1 text-black dark:text-white">${escape(model?.name ?? message.model)}</span>`;
            }
          }
        )} ${message.timestamp ? `<div class="${"self-center text-xs font-medium first-letter:capitalize ml-0.5 translate-y-[1px] " + escape(
          $settings?.highContrastMode ?? false ? "dark:text-gray-100 text-gray-900" : "invisible group-hover:visible transition text-gray-400",
          true
        )}">${validate_component(Tooltip, "Tooltip").$$render(
          $$result,
          {
            content: dayjs(message.timestamp * 1e3).format("LLLL")
          },
          {},
          {
            default: () => {
              return `<span class="line-clamp-1">${escape($i18n.t(formatDate(message.timestamp * 1e3), {
                LOCALIZED_TIME: dayjs(message.timestamp * 1e3).format("LT"),
                LOCALIZED_DATE: dayjs(message.timestamp * 1e3).format("L")
              }))}</span>`;
            }
          }
        )}</div>` : ``}`;
      }
    })} <div><div class="${"chat-" + escape(message.role, true) + " w-full min-w-full markdown-prose svelte-1u5gq5j"}"><div>${model?.info?.meta?.capabilities?.status_updates ?? true ? `${validate_component(StatusHistory, "StatusHistory").$$render(
      $$result,
      {
        statusHistory: message?.statusHistory,
        expand: message?.content === ""
      },
      {},
      {}
    )}` : ``} ${message?.files && message.files?.filter((f) => f.type === "image").length > 0 ? `<div class="my-1 w-full flex overflow-x-auto gap-2 flex-wrap">${each(message.files, (file) => {
      return `<div>${file.type === "image" ? `${validate_component(Image, "Image").$$render($$result, { src: file.url, alt: message.content }, {}, {})}` : `${validate_component(FileItem, "FileItem").$$render(
        $$result,
        {
          item: file,
          url: file.url,
          name: file.name,
          type: file.type,
          size: file?.size,
          small: true
        },
        {},
        {}
      )}`} </div>`;
    })}</div>` : ``} ${message?.embeds && message.embeds.length > 0 ? `<div class="my-1 w-full flex overflow-x-auto gap-2 flex-wrap">${each(message.embeds, (embed2, idx) => {
      return `<div class="my-2 w-full"${add_attribute("id", `${message.id}-embeds-${idx}`, 0)}>${validate_component(FullHeightIframe, "FullHeightIframe").$$render(
        $$result,
        {
          src: embed2,
          allowScripts: true,
          allowForms: true,
          allowSameOrigin: true,
          allowPopups: true
        },
        {},
        {}
      )} </div>`;
    })}</div>` : ``} ${`<div class="w-full flex flex-col relative" id="response-content-container">${message.content === "" && !message.error && (model?.info?.meta?.capabilities?.status_updates ?? true ? (message?.statusHistory ?? [...message?.status ? [message?.status] : []]).length === 0 || (message?.statusHistory?.at(-1)?.hidden ?? false) : true) ? `${validate_component(Skeleton, "Skeleton").$$render($$result, {}, {}, {})}` : `${message.content && message.error !== true ? `  ${validate_component(ContentRenderer, "ContentRenderer").$$render(
      $$result,
      {
        id: `${chatId2}-${message.id}`,
        messageId: message.id,
        history,
        selectedModels,
        content: message.content,
        sources: message.sources,
        floatingButtons: message?.done && !readOnly && ($settings?.showFloatingActionButtons ?? true),
        save: !readOnly,
        preview: !readOnly,
        editCodeBlock,
        topPadding,
        done: $settings?.chatFadeStreamingText ?? true ? message?.done ?? false : true,
        model,
        onTaskClick: async (e) => {
          /* @__PURE__ */ console.log(e);
        },
        onSourceClick: async (id, idx) => {
          /* @__PURE__ */ console.log(id, idx);
          if (citationsElement) {
            citationsElement?.showSourceModal(idx - 1);
          }
        },
        onAddMessages: ({ modelId, parentId, messages }) => {
          addMessages({ modelId, parentId, messages });
        },
        onSave: ({ raw, oldContent, newContent }) => {
          history.messages[message.id].content = history.messages[message.id].content.replace(raw, raw.replace(oldContent, newContent));
          updateChat();
        }
      },
      {},
      {}
    )}` : ``}`} ${message?.error ? `${validate_component(Error, "Error").$$render(
      $$result,
      {
        content: message?.error?.content ?? message.content
      },
      {},
      {}
    )}` : ``} ${(message?.sources || message?.citations) && (model?.info?.meta?.capabilities?.citations ?? true) ? `${validate_component(Citations, "Citations").$$render(
      $$result,
      {
        id: message?.id,
        sources: message?.sources ?? message?.citations,
        readOnly,
        this: citationsElement
      },
      {
        this: ($$value) => {
          citationsElement = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : ``} ${message.code_executions ? `${validate_component(CodeExecutions, "CodeExecutions").$$render($$result, { codeExecutions: message.code_executions }, {}, {})}` : ``}</div>`}</div></div> ${`<div class="flex justify-start overflow-x-auto buttons text-gray-600 dark:text-gray-500 mt-0.5 svelte-1u5gq5j"${add_attribute("this", buttonsContainerElement, 0)}>${message.done || siblings.length > 1 ? `${siblings.length > 1 ? `<div class="flex self-center min-w-fit" dir="ltr"><button${add_attribute("aria-label", $i18n.t("Previous message"), 0)} class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition"><svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5"></path></svg></button> ${` <div class="text-sm tracking-widest font-semibold self-center dark:text-gray-100 min-w-fit">${escape(siblings.indexOf(message.id) + 1)}/${escape(siblings.length)}</div>`} <button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition"${add_attribute("aria-label", $i18n.t("Next message"), 0)}><svg xmlns="http://www.w3.org/2000/svg" fill="none" aria-hidden="true" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5"></path></svg></button></div>` : ``} ${message.done ? `${!readOnly ? `${($user?.role === "user" ? $user?.permissions?.chat?.edit ?? true : true) ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Edit"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button${add_attribute("aria-label", $i18n.t("Edit"), 0)} class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.3" aria-hidden="true" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125"></path></svg></button>`;
        }
      }
    )}` : ``}` : ``} ${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Copy"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button${add_attribute("aria-label", $i18n.t("Copy"), 0)} class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition copy-response-button"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" aria-hidden="true" viewBox="0 0 24 24" stroke-width="2.3" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M15.666 3.888A2.25 2.25 0 0013.5 2.25h-3c-1.03 0-1.9.693-2.166 1.638m7.332 0c.055.194.084.4.084.612v0a.75.75 0 01-.75.75H9a.75.75 0 01-.75-.75v0c0-.212.03-.418.084-.612m7.332 0c.646.049 1.288.11 1.927.184 1.1.128 1.907 1.077 1.907 2.185V19.5a2.25 2.25 0 01-2.25 2.25H6.75A2.25 2.25 0 014.5 19.5V6.257c0-1.108.806-2.057 1.907-2.185a48.208 48.208 0 011.927-.184"></path></svg></button>`;
        }
      }
    )} ${$user?.role === "admin" || ($user?.permissions?.chat?.tts ?? true) ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Read Aloud"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button${add_attribute("aria-label", $i18n.t("Read Aloud"), 0)} id="${"speak-button-" + escape(message.id, true)}" class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}">${`${`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" aria-hidden="true" stroke-width="2.3" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M19.114 5.636a9 9 0 010 12.728M16.463 8.288a5.25 5.25 0 010 7.424M6.75 8.25l4.72-4.72a.75.75 0 011.28.53v15.88a.75.75 0 01-1.28.53l-4.72-4.72H4.51c-.88 0-1.704-.507-1.938-1.354A9.01 9.01 0 012.25 12c0-.83.112-1.633.322-2.396C2.806 8.756 3.63 8.25 4.51 8.25H6.75z"></path></svg>`}`}</button>`;
        }
      }
    )}` : ``} ${$config?.features.enable_image_generation && ($user?.role === "admin" || $user?.permissions?.features?.image_generation) && !readOnly ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Generate Image"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button${add_attribute("aria-label", $i18n.t("Generate Image"), 0)} class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}">${`<svg xmlns="http://www.w3.org/2000/svg" fill="none" aria-hidden="true" viewBox="0 0 24 24" stroke-width="2.3" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z"></path></svg>`}</button>`;
        }
      }
    )}` : ``} ${message.usage ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: message.usage ? `<pre>${sanitizeResponseContent(JSON.stringify(message.usage, null, 2).replace(/"([^(")"]+)":/g, "$1:").slice(1, -1).split("\n").map((line) => line.slice(2)).map((line) => line.endsWith(",") ? line.slice(0, -1) : line).join("\n"))}</pre>` : "",
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button aria-hidden="true" class="${"" + escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition whitespace-pre-wrap"}" id="${"info-" + escape(message.id, true)}"><svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.3" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z"></path></svg></button>`;
        }
      }
    )}` : ``} ${!readOnly ? `${!$temporaryChatEnabled && ($config?.features.enable_message_rating ?? true) && ($user?.role === "admin" || ($user?.permissions?.chat?.rate_response ?? true)) ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Good Response"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button${add_attribute("aria-label", $i18n.t("Good Response"), 0)} class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg " + escape(
            (message?.annotation?.rating ?? "").toString() === "1" ? "bg-gray-100 dark:bg-gray-800" : "",
            true
          ) + " dark:hover:text-white hover:text-black transition disabled:cursor-progress disabled:hover:bg-transparent"}" ${""}><svg aria-hidden="true" stroke="currentColor" fill="none" stroke-width="2.3" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4" xmlns="http://www.w3.org/2000/svg"><path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path></svg></button>`;
        }
      }
    )} ${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Bad Response"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button${add_attribute("aria-label", $i18n.t("Bad Response"), 0)} class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg " + escape(
            (message?.annotation?.rating ?? "").toString() === "-1" ? "bg-gray-100 dark:bg-gray-800" : "",
            true
          ) + " dark:hover:text-white hover:text-black transition disabled:cursor-progress disabled:hover:bg-transparent"}" ${""}><svg aria-hidden="true" stroke="currentColor" fill="none" stroke-width="2.3" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4" xmlns="http://www.w3.org/2000/svg"><path d="M10 15v4a3 3 0 0 0 3 3l4-9V2H5.72a2 2 0 0 0-2 1.7l-1.38 9a2 2 0 0 0 2 2.3zm7-13h2.67A2.31 2.31 0 0 1 22 4v7a2.31 2.31 0 0 1-2.33 2H17"></path></svg></button>`;
        }
      }
    )}` : ``} ${isLastMessage && ($user?.role === "admin" || ($user?.permissions?.chat?.continue_response ?? true)) ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Continue Response"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button${add_attribute("aria-label", $i18n.t("Continue Response"), 0)} type="button" id="continue-response-button" class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}"><svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.3" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path><path stroke-linecap="round" stroke-linejoin="round" d="M15.91 11.672a.375.375 0 0 1 0 .656l-5.603 3.113a.375.375 0 0 1-.557-.328V8.887c0-.286.307-.466.557-.327l5.603 3.112Z"></path></svg></button>`;
        }
      }
    )}` : ``} ${$user?.role === "admin" || ($user?.permissions?.chat?.regenerate_response ?? true) ? `${$settings?.regenerateMenu ?? true ? `<button type="button" class="hidden regenerate-response-button"></button> ${validate_component(RegenerateMenu, "RegenerateMenu").$$render(
      $$result,
      {
        onRegenerate: (prompt = null) => {
          showRateComment = false;
          regenerateResponse(message, prompt);
          (model?.actions ?? []).forEach((action) => {
            dispatch("action", {
              id: action.id,
              event: {
                id: "regenerate-response",
                data: { messageId: message.id }
              }
            });
          });
        }
      },
      {},
      {
        default: () => {
          return `${validate_component(Tooltip, "Tooltip").$$render(
            $$result,
            {
              content: $i18n.t("Regenerate"),
              placement: "bottom"
            },
            {},
            {
              default: () => {
                return `<div${add_attribute("aria-label", $i18n.t("Regenerate"), 0)} class="${escape(
                  isLastMessage ? "visible" : "invisible group-hover:visible",
                  true
                ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.3" aria-hidden="true" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99"></path></svg></div>`;
              }
            }
          )}`;
        }
      }
    )}` : `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Regenerate"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button type="button"${add_attribute("aria-label", $i18n.t("Regenerate"), 0)} class="${escape(
            isLastMessage ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition regenerate-response-button"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.3" aria-hidden="true" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99"></path></svg></button>`;
        }
      }
    )}`}` : ``} ${$user?.role === "admin" || ($user?.permissions?.chat?.delete_message ?? true) ? `${siblings.length > 1 ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Delete"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button type="button"${add_attribute("aria-label", $i18n.t("Delete"), 0)} id="delete-response-button" class="${escape(
            isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" aria-hidden="true" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path></svg></button>`;
        }
      }
    )}` : ``}` : ``} ${isLastMessage ? `${each(model?.actions ?? [], (action) => {
      return `${validate_component(Tooltip, "Tooltip").$$render(
        $$result,
        {
          content: action.name,
          placement: "bottom"
        },
        {},
        {
          default: () => {
            return `<button type="button"${add_attribute("aria-label", action.name, 0)} class="${escape(
              isLastMessage || ($settings?.highContrastMode ?? false) ? "visible" : "invisible group-hover:visible",
              true
            ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}">${action?.icon ? `<div class="size-4"><img${add_attribute("src", action.icon, 0)} class="${"w-4 h-4 " + escape(action.icon.includes("svg") ? "dark:invert-[80%]" : "", true)}" style="fill: currentColor;"${add_attribute("alt", action.name, 0)}> </div>` : `${validate_component(Sparkles, "Sparkles").$$render($$result, { strokeWidth: "2.1", className: "size-4" }, {}, {})}`}</button> `;
          }
        }
      )}`;
    })}` : ``}` : ``}` : ``}` : ``}</div> ${message.done && showRateComment ? `${validate_component(RateComment, "RateComment").$$render(
      $$result,
      { message, show: showRateComment },
      {
        message: ($$value) => {
          message = $$value;
          $$settled = false;
        },
        show: ($$value) => {
          showRateComment = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : ``} ${(isLastMessage || ($settings?.keepFollowUpPrompts ?? false)) && message.done && !readOnly && (message?.followUps ?? []).length > 0 ? `<div class="mt-2.5">${validate_component(FollowUps, "FollowUps").$$render(
      $$result,
      {
        followUps: message?.followUps,
        onClick: (prompt) => {
          if ($settings?.insertFollowUpPrompt ?? false) {
            setInputText(prompt);
          } else {
            submitMessage(message?.id, prompt);
          }
        }
      },
      {},
      {}
    )}</div>` : ``}`}</div></div></div>`;
  } while (!$$settled);
  $$unsubscribe_models();
  $$unsubscribe_settings();
  $$unsubscribe_config();
  $$unsubscribe_TTSWorker();
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  $$unsubscribe_temporaryChatEnabled();
  return $$rendered;
});
const MultiResponseMessages = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_settings;
  let $$unsubscribe_models;
  let $$unsubscribe_mobile;
  let $$unsubscribe_i18n;
  $$unsubscribe_settings = subscribe(settings, (value) => value);
  $$unsubscribe_models = subscribe(models, (value) => value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => value);
  dayjs.extend(localizedFormat);
  let { chatId: chatId2 } = $$props;
  let { history } = $$props;
  let { messageId } = $$props;
  let { selectedModels = [] } = $$props;
  let { isLastMessage } = $$props;
  let { readOnly = false } = $$props;
  let { editCodeBlock = true } = $$props;
  let { setInputText = () => {
  } } = $$props;
  let { updateChat } = $$props;
  let { editMessage } = $$props;
  let { saveMessage } = $$props;
  let { rateMessage } = $$props;
  let { actionMessage } = $$props;
  let { submitMessage } = $$props;
  let { deleteMessage } = $$props;
  let { continueResponse } = $$props;
  let { regenerateResponse } = $$props;
  let { mergeResponses } = $$props;
  let { addMessages } = $$props;
  let { triggerScroll } = $$props;
  let { topPadding = false } = $$props;
  createEventDispatcher();
  let message = JSON.parse(JSON.stringify(history.messages[messageId]));
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.messageId === void 0 && $$bindings.messageId && messageId !== void 0) $$bindings.messageId(messageId);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.isLastMessage === void 0 && $$bindings.isLastMessage && isLastMessage !== void 0) $$bindings.isLastMessage(isLastMessage);
  if ($$props.readOnly === void 0 && $$bindings.readOnly && readOnly !== void 0) $$bindings.readOnly(readOnly);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.setInputText === void 0 && $$bindings.setInputText && setInputText !== void 0) $$bindings.setInputText(setInputText);
  if ($$props.updateChat === void 0 && $$bindings.updateChat && updateChat !== void 0) $$bindings.updateChat(updateChat);
  if ($$props.editMessage === void 0 && $$bindings.editMessage && editMessage !== void 0) $$bindings.editMessage(editMessage);
  if ($$props.saveMessage === void 0 && $$bindings.saveMessage && saveMessage !== void 0) $$bindings.saveMessage(saveMessage);
  if ($$props.rateMessage === void 0 && $$bindings.rateMessage && rateMessage !== void 0) $$bindings.rateMessage(rateMessage);
  if ($$props.actionMessage === void 0 && $$bindings.actionMessage && actionMessage !== void 0) $$bindings.actionMessage(actionMessage);
  if ($$props.submitMessage === void 0 && $$bindings.submitMessage && submitMessage !== void 0) $$bindings.submitMessage(submitMessage);
  if ($$props.deleteMessage === void 0 && $$bindings.deleteMessage && deleteMessage !== void 0) $$bindings.deleteMessage(deleteMessage);
  if ($$props.continueResponse === void 0 && $$bindings.continueResponse && continueResponse !== void 0) $$bindings.continueResponse(continueResponse);
  if ($$props.regenerateResponse === void 0 && $$bindings.regenerateResponse && regenerateResponse !== void 0) $$bindings.regenerateResponse(regenerateResponse);
  if ($$props.mergeResponses === void 0 && $$bindings.mergeResponses && mergeResponses !== void 0) $$bindings.mergeResponses(mergeResponses);
  if ($$props.addMessages === void 0 && $$bindings.addMessages && addMessages !== void 0) $$bindings.addMessages(addMessages);
  if ($$props.triggerScroll === void 0 && $$bindings.triggerScroll && triggerScroll !== void 0) $$bindings.triggerScroll(triggerScroll);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  {
    if (history.messages) {
      if (JSON.stringify(message) !== JSON.stringify(history.messages[messageId])) {
        message = JSON.parse(JSON.stringify(history.messages[messageId]));
      }
    }
  }
  $$unsubscribe_settings();
  $$unsubscribe_models();
  $$unsubscribe_mobile();
  $$unsubscribe_i18n();
  return `${``}`;
});
const UserMessage = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $settings, $$unsubscribe_settings;
  let $models, $$unsubscribe_models;
  let $_user, $$unsubscribe__user;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe__user = subscribe(user, (value) => $_user = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  dayjs.extend(localizedFormat);
  let { user: user$1 } = $$props;
  let { chatId: chatId2 } = $$props;
  let { history } = $$props;
  let { messageId } = $$props;
  let { siblings } = $$props;
  let { gotoMessage } = $$props;
  let { showPreviousMessage } = $$props;
  let { showNextMessage } = $$props;
  let { editMessage } = $$props;
  let { deleteMessage } = $$props;
  let { isFirstMessage } = $$props;
  let { readOnly } = $$props;
  let { editCodeBlock = true } = $$props;
  let { topPadding = false } = $$props;
  let showDeleteConfirm = false;
  let message = JSON.parse(JSON.stringify(history.messages[messageId]));
  if ($$props.user === void 0 && $$bindings.user && user$1 !== void 0) $$bindings.user(user$1);
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.messageId === void 0 && $$bindings.messageId && messageId !== void 0) $$bindings.messageId(messageId);
  if ($$props.siblings === void 0 && $$bindings.siblings && siblings !== void 0) $$bindings.siblings(siblings);
  if ($$props.gotoMessage === void 0 && $$bindings.gotoMessage && gotoMessage !== void 0) $$bindings.gotoMessage(gotoMessage);
  if ($$props.showPreviousMessage === void 0 && $$bindings.showPreviousMessage && showPreviousMessage !== void 0) $$bindings.showPreviousMessage(showPreviousMessage);
  if ($$props.showNextMessage === void 0 && $$bindings.showNextMessage && showNextMessage !== void 0) $$bindings.showNextMessage(showNextMessage);
  if ($$props.editMessage === void 0 && $$bindings.editMessage && editMessage !== void 0) $$bindings.editMessage(editMessage);
  if ($$props.deleteMessage === void 0 && $$bindings.deleteMessage && deleteMessage !== void 0) $$bindings.deleteMessage(deleteMessage);
  if ($$props.isFirstMessage === void 0 && $$bindings.isFirstMessage && isFirstMessage !== void 0) $$bindings.isFirstMessage(isFirstMessage);
  if ($$props.readOnly === void 0 && $$bindings.readOnly && readOnly !== void 0) $$bindings.readOnly(readOnly);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (history.messages) {
        if (JSON.stringify(message) !== JSON.stringify(history.messages[messageId])) {
          message = JSON.parse(JSON.stringify(history.messages[messageId]));
        }
      }
    }
    $$rendered = `${validate_component(ConfirmDialog, "DeleteConfirmDialog").$$render(
      $$result,
      {
        title: $i18n.t("Delete message?"),
        show: showDeleteConfirm
      },
      {
        show: ($$value) => {
          showDeleteConfirm = $$value;
          $$settled = false;
        }
      },
      {}
    )} <div class="flex w-full user-message group"${add_attribute("dir", $settings.chatDirection, 0)} id="${"message-" + escape(message.id, true)}">${!($settings?.chatBubble ?? true) ? `<div${add_attribute("class", `shrink-0 ltr:mr-3 rtl:ml-3 mt-1`, 0)}>${validate_component(ProfileImage, "ProfileImage").$$render(
      $$result,
      {
        src: message.user ? $models.find((m) => m.id === message.user)?.info?.meta?.profile_image_url ?? `${WEBUI_BASE_URL}/user.png` : user$1?.profile_image_url ?? `${WEBUI_BASE_URL}/user.png`,
        className: "size-8 user-message-profile-image"
      },
      {},
      {}
    )}</div>` : ``} <div class="flex-auto w-0 max-w-full pl-1">${!($settings?.chatBubble ?? true) ? `<div>${validate_component(Name, "Name").$$render($$result, {}, {}, {
      default: () => {
        return `${message.user ? `${escape($i18n.t("You"))} <span class="text-gray-500 text-sm font-medium">${escape(message?.user ?? "")}</span>` : `${$settings.showUsername || $_user.name !== user$1.name ? `${escape(user$1.name)}` : `${escape($i18n.t("You"))}`}`} ${message.timestamp ? `<div class="${"self-center text-xs font-medium first-letter:capitalize ml-0.5 translate-y-[1px] " + escape(
          $settings?.highContrastMode ?? false ? "dark:text-gray-900 text-gray-100" : "invisible group-hover:visible transition",
          true
        )}">${validate_component(Tooltip, "Tooltip").$$render(
          $$result,
          {
            content: dayjs(message.timestamp * 1e3).format("LLLL")
          },
          {},
          {
            default: () => {
              return `   <span class="line-clamp-1">${escape($i18n.t(formatDate(message.timestamp * 1e3), {
                LOCALIZED_TIME: dayjs(message.timestamp * 1e3).format("LT"),
                LOCALIZED_DATE: dayjs(message.timestamp * 1e3).format("L")
              }))}</span>`;
            }
          }
        )}</div>` : ``}`;
      }
    })}</div>` : `${message.timestamp ? `<div class="flex justify-end pr-2 text-xs"><div class="${"text-[0.65rem] font-medium first-letter:capitalize mb-0.5 " + escape(
      $settings?.highContrastMode ?? false ? "dark:text-gray-100 text-gray-900" : "invisible group-hover:visible transition text-gray-400",
      true
    )}">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: dayjs(message.timestamp * 1e3).format("LLLL")
      },
      {},
      {
        default: () => {
          return `<span class="line-clamp-1">${escape($i18n.t(formatDate(message.timestamp * 1e3), {
            LOCALIZED_TIME: dayjs(message.timestamp * 1e3).format("LT"),
            LOCALIZED_DATE: dayjs(message.timestamp * 1e3).format("L")
          }))}</span>`;
        }
      }
    )}</div></div>` : ``}`} <div class="${"chat-" + escape(message.role, true) + " w-full min-w-full markdown-prose"}">${`${message.files ? `<div class="mb-1 w-full flex flex-col justify-end overflow-x-auto gap-1 flex-wrap">${each(message.files, (file) => {
      return `<div${add_attribute("class", $settings?.chatBubble ?? true ? "self-end" : "", 0)}>${file.type === "image" ? `${validate_component(Image, "Image").$$render(
        $$result,
        {
          src: file.url,
          imageClassName: " max-h-96 rounded-lg"
        },
        {},
        {}
      )}` : `${validate_component(FileItem, "FileItem").$$render(
        $$result,
        {
          item: file,
          url: file.url,
          name: file.name,
          type: file.type,
          size: file?.size,
          small: true
        },
        {},
        {}
      )}`} </div>`;
    })}</div>` : ``}`} ${`${message.content !== "" ? `<div class="w-full"><div class="${"flex " + escape(
      $settings?.chatBubble ?? true ? "justify-end pb-1" : "w-full",
      true
    )}"><div class="${"rounded-3xl " + escape(
      $settings?.chatBubble ?? true ? `max-w-[90%] px-4 py-1.5  bg-gray-50 dark:bg-gray-850 ${message.files ? "rounded-tr-lg" : ""}` : " w-full",
      true
    )}">${message.content ? `${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id: `${chatId2}-${message.id}`,
        content: message.content,
        editCodeBlock,
        topPadding
      },
      {},
      {}
    )}` : ``}</div></div></div>` : ``}`} ${`<div class="${"flex " + escape($settings?.chatBubble ?? true ? "justify-end" : "", true) + " text-gray-600 dark:text-gray-500"}">${!($settings?.chatBubble ?? true) ? `${siblings.length > 1 ? `<div class="flex self-center" dir="ltr"><button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition" data-svelte-h="svelte-15wwmqh"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5"></path></svg></button> ${` <div class="text-sm tracking-widest font-semibold self-center dark:text-gray-100 min-w-fit">${escape(siblings.indexOf(message.id) + 1)}/${escape(siblings.length)}</div>`} <button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition" data-svelte-h="svelte-1jzf6aa"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5"></path></svg></button></div>` : ``}` : ``} ${!readOnly ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Edit"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button class="${escape(
            $settings?.highContrastMode ?? false ? "" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition edit-user-message-button"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.3" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125"></path></svg></button>`;
        }
      }
    )}` : ``} ${message?.content ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Copy"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button class="${escape(
            $settings?.highContrastMode ?? false ? "" : "invisible group-hover:visible",
            true
          ) + " p-1.5 hover:bg-black/5 dark:hover:bg-white/5 rounded-lg dark:hover:text-white hover:text-black transition"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.3" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M15.666 3.888A2.25 2.25 0 0013.5 2.25h-3c-1.03 0-1.9.693-2.166 1.638m7.332 0c.055.194.084.4.084.612v0a.75.75 0 01-.75.75H9a.75.75 0 01-.75-.75v0c0-.212.03-.418.084-.612m7.332 0c.646.049 1.288.11 1.927.184 1.1.128 1.907 1.077 1.907 2.185V19.5a2.25 2.25 0 01-2.25 2.25H6.75A2.25 2.25 0 014.5 19.5V6.257c0-1.108.806-2.057 1.907-2.185a48.208 48.208 0 011.927-.184"></path></svg></button>`;
        }
      }
    )}` : ``} ${$_user?.role === "admin" || ($_user?.permissions?.chat?.delete_message ?? false) ? `${!readOnly && (!isFirstMessage || siblings.length > 1) ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Delete"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button class="${escape(
            $settings?.highContrastMode ?? false ? "" : "invisible group-hover:visible",
            true
          ) + " p-1 rounded-sm dark:hover:text-white hover:text-black transition"}"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path></svg></button>`;
        }
      }
    )}` : ``}` : ``} ${$settings?.chatBubble ?? true ? `${siblings.length > 1 ? `<div class="flex self-center" dir="ltr"><button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition" data-svelte-h="svelte-15wwmqh"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5"></path></svg></button> ${` <div class="text-sm tracking-widest font-semibold self-center dark:text-gray-100 min-w-fit">${escape(siblings.indexOf(message.id) + 1)}/${escape(siblings.length)}</div>`} <button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition" data-svelte-h="svelte-1jzf6aa"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5"></path></svg></button></div>` : ``}` : ``}</div>`}</div></div></div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_settings();
  $$unsubscribe_models();
  $$unsubscribe__user();
  return $$rendered;
});
const Message = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  createEventDispatcher();
  getContext("i18n");
  let { chatId: chatId2 } = $$props;
  let { selectedModels = [] } = $$props;
  let { idx = 0 } = $$props;
  let { history } = $$props;
  let { messageId } = $$props;
  let { user: user2 } = $$props;
  let { setInputText = () => {
  } } = $$props;
  let { gotoMessage } = $$props;
  let { showPreviousMessage } = $$props;
  let { showNextMessage } = $$props;
  let { updateChat } = $$props;
  let { editMessage } = $$props;
  let { saveMessage } = $$props;
  let { deleteMessage } = $$props;
  let { rateMessage } = $$props;
  let { actionMessage } = $$props;
  let { submitMessage } = $$props;
  let { regenerateResponse } = $$props;
  let { continueResponse } = $$props;
  let { mergeResponses } = $$props;
  let { addMessages } = $$props;
  let { triggerScroll } = $$props;
  let { readOnly = false } = $$props;
  let { editCodeBlock = true } = $$props;
  let { topPadding = false } = $$props;
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.idx === void 0 && $$bindings.idx && idx !== void 0) $$bindings.idx(idx);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.messageId === void 0 && $$bindings.messageId && messageId !== void 0) $$bindings.messageId(messageId);
  if ($$props.user === void 0 && $$bindings.user && user2 !== void 0) $$bindings.user(user2);
  if ($$props.setInputText === void 0 && $$bindings.setInputText && setInputText !== void 0) $$bindings.setInputText(setInputText);
  if ($$props.gotoMessage === void 0 && $$bindings.gotoMessage && gotoMessage !== void 0) $$bindings.gotoMessage(gotoMessage);
  if ($$props.showPreviousMessage === void 0 && $$bindings.showPreviousMessage && showPreviousMessage !== void 0) $$bindings.showPreviousMessage(showPreviousMessage);
  if ($$props.showNextMessage === void 0 && $$bindings.showNextMessage && showNextMessage !== void 0) $$bindings.showNextMessage(showNextMessage);
  if ($$props.updateChat === void 0 && $$bindings.updateChat && updateChat !== void 0) $$bindings.updateChat(updateChat);
  if ($$props.editMessage === void 0 && $$bindings.editMessage && editMessage !== void 0) $$bindings.editMessage(editMessage);
  if ($$props.saveMessage === void 0 && $$bindings.saveMessage && saveMessage !== void 0) $$bindings.saveMessage(saveMessage);
  if ($$props.deleteMessage === void 0 && $$bindings.deleteMessage && deleteMessage !== void 0) $$bindings.deleteMessage(deleteMessage);
  if ($$props.rateMessage === void 0 && $$bindings.rateMessage && rateMessage !== void 0) $$bindings.rateMessage(rateMessage);
  if ($$props.actionMessage === void 0 && $$bindings.actionMessage && actionMessage !== void 0) $$bindings.actionMessage(actionMessage);
  if ($$props.submitMessage === void 0 && $$bindings.submitMessage && submitMessage !== void 0) $$bindings.submitMessage(submitMessage);
  if ($$props.regenerateResponse === void 0 && $$bindings.regenerateResponse && regenerateResponse !== void 0) $$bindings.regenerateResponse(regenerateResponse);
  if ($$props.continueResponse === void 0 && $$bindings.continueResponse && continueResponse !== void 0) $$bindings.continueResponse(continueResponse);
  if ($$props.mergeResponses === void 0 && $$bindings.mergeResponses && mergeResponses !== void 0) $$bindings.mergeResponses(mergeResponses);
  if ($$props.addMessages === void 0 && $$bindings.addMessages && addMessages !== void 0) $$bindings.addMessages(addMessages);
  if ($$props.triggerScroll === void 0 && $$bindings.triggerScroll && triggerScroll !== void 0) $$bindings.triggerScroll(triggerScroll);
  if ($$props.readOnly === void 0 && $$bindings.readOnly && readOnly !== void 0) $$bindings.readOnly(readOnly);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `<div class="${"flex flex-col justify-between px-5 mb-3 w-full " + escape(
      $settings?.widescreenMode ?? null ? "max-w-full" : "max-w-5xl",
      true
    ) + " mx-auto rounded-lg group"}">${history.messages[messageId] ? `${history.messages[messageId].role === "user" ? `${validate_component(UserMessage, "UserMessage").$$render(
      $$result,
      {
        user: user2,
        chatId: chatId2,
        history,
        messageId,
        isFirstMessage: idx === 0,
        siblings: history.messages[messageId].parentId !== null ? history.messages[history.messages[messageId].parentId]?.childrenIds ?? [] : Object.values(history.messages).filter((message) => message.parentId === null).map((message) => message.id) ?? [],
        gotoMessage,
        showPreviousMessage,
        showNextMessage,
        editMessage,
        deleteMessage,
        readOnly,
        editCodeBlock,
        topPadding
      },
      {},
      {}
    )}` : `${(history.messages[history.messages[messageId].parentId]?.models?.length ?? 1) === 1 ? `${validate_component(ResponseMessage, "ResponseMessage").$$render(
      $$result,
      {
        chatId: chatId2,
        history,
        messageId,
        selectedModels,
        isLastMessage: messageId === history.currentId,
        siblings: history.messages[history.messages[messageId].parentId]?.childrenIds ?? [],
        setInputText,
        gotoMessage,
        showPreviousMessage,
        showNextMessage,
        updateChat,
        editMessage,
        saveMessage,
        rateMessage,
        actionMessage,
        submitMessage,
        deleteMessage,
        continueResponse,
        regenerateResponse,
        addMessages,
        readOnly,
        editCodeBlock,
        topPadding
      },
      {},
      {}
    )}` : `${validate_component(MultiResponseMessages, "MultiResponseMessages").$$render(
      $$result,
      {
        chatId: chatId2,
        messageId,
        selectedModels,
        isLastMessage: messageId === history?.currentId,
        setInputText,
        updateChat,
        editMessage,
        saveMessage,
        rateMessage,
        actionMessage,
        submitMessage,
        deleteMessage,
        continueResponse,
        regenerateResponse,
        mergeResponses,
        triggerScroll,
        addMessages,
        readOnly,
        editCodeBlock,
        topPadding,
        history
      },
      {
        history: ($$value) => {
          history = $$value;
          $$settled = false;
        }
      },
      {}
    )}`}`}` : ``}</div>`;
  } while (!$$settled);
  $$unsubscribe_settings();
  return $$rendered;
});
const css = {
  code: "@keyframes svelte-1co34if-fadeInUp{0%{opacity:0;transform:translateY(20px)}100%{opacity:1;transform:translateY(0)}}.waterfall.svelte-1co34if{opacity:0;animation-name:svelte-1co34if-fadeInUp;animation-duration:200ms;animation-fill-mode:forwards;animation-timing-function:ease}",
  map: `{"version":3,"file":"Suggestions.svelte","sources":["Suggestions.svelte"],"sourcesContent":["<script lang=\\"ts\\">import Fuse from \\"fuse.js\\";\\nimport Bolt from \\"$lib/components/icons/Bolt.svelte\\";\\nimport { onMount, getContext } from \\"svelte\\";\\nimport { settings, WEBUI_NAME } from \\"$lib/stores\\";\\nimport { WEBUI_VERSION } from \\"$lib/constants\\";\\nconst i18n = getContext(\\"i18n\\");\\nexport let suggestionPrompts = [];\\nexport let className = \\"\\";\\nexport let inputValue = \\"\\";\\nexport let onSelect = (e) => {\\n};\\nlet sortedPrompts = [];\\nconst fuseOptions = {\\n  keys: [\\"content\\", \\"title\\"],\\n  threshold: 0.5\\n};\\nlet fuse;\\nlet filteredPrompts = [];\\n$: fuse = new Fuse(sortedPrompts, fuseOptions);\\n$: getFilteredPrompts(inputValue);\\nfunction arraysEqual(a, b) {\\n  if (a.length !== b.length) return false;\\n  for (let i = 0; i < a.length; i++) {\\n    if ((a[i].id ?? a[i].content) !== (b[i].id ?? b[i].content)) {\\n      return false;\\n    }\\n  }\\n  return true;\\n}\\nconst getFilteredPrompts = (inputValue2) => {\\n  if (inputValue2.length > 500) {\\n    filteredPrompts = [];\\n  } else {\\n    const newFilteredPrompts = inputValue2.trim() && fuse ? fuse.search(inputValue2.trim()).map((result) => result.item) : sortedPrompts;\\n    if (!arraysEqual(filteredPrompts, newFilteredPrompts)) {\\n      filteredPrompts = newFilteredPrompts;\\n    }\\n  }\\n};\\n$: if (suggestionPrompts) {\\n  sortedPrompts = [...suggestionPrompts ?? []].sort(() => Math.random() - 0.5);\\n  getFilteredPrompts(inputValue);\\n}\\n<\/script>\\n\\n<div class=\\"mb-1 flex gap-1 text-xs font-medium items-center text-gray-600 dark:text-gray-400\\">\\n\\t{#if filteredPrompts.length > 0}\\n\\t\\t<Bolt />\\n\\t\\t{$i18n.t('Suggested')}\\n\\t{:else}\\n\\t\\t<!-- Keine Vorschläge -->\\n\\n\\t\\t<div\\n\\t\\t\\tclass=\\"flex w-full {$settings?.landingPageMode === 'chat'\\n\\t\\t\\t\\t? ' -mt-1'\\n\\t\\t\\t\\t: 'text-center items-center justify-center'}  self-start text-gray-600 dark:text-gray-400\\"\\n\\t\\t>\\n\\t\\t\\t{$WEBUI_NAME} ‧ v{WEBUI_VERSION}\\n\\t\\t</div>\\n\\t{/if}\\n</div>\\n\\n<div class=\\"h-40 w-full\\">\\n\\t{#if filteredPrompts.length > 0}\\n\\t\\t<div role=\\"list\\" class=\\"max-h-40 overflow-auto scrollbar-none items-start {className}\\">\\n\\t\\t\\t{#each filteredPrompts as prompt, idx (prompt.id || prompt.content)}\\n\\t\\t\\t\\t<!-- svelte-ignore a11y-no-interactive-element-to-noninteractive-role -->\\n\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\trole=\\"listitem\\"\\n\\t\\t\\t\\t\\tclass=\\"waterfall flex flex-col flex-1 shrink-0 w-full justify-between\\n\\t\\t\\t\\t       px-3 py-2 rounded-xl bg-transparent hover:bg-black/5\\n\\t\\t\\t\\t       dark:hover:bg-white/5 transition group\\"\\n\\t\\t\\t\\t\\tstyle=\\"animation-delay: {idx * 60}ms\\"\\n\\t\\t\\t\\t\\ton:click={() => onSelect({ type: 'prompt', data: prompt.content })}\\n\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t<div class=\\"flex flex-col text-left\\">\\n\\t\\t\\t\\t\\t\\t{#if prompt.title && prompt.title[0] !== ''}\\n\\t\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"font-medium dark:text-gray-300 dark:group-hover:text-gray-200 transition line-clamp-1\\"\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t{prompt.title[0]}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"text-xs text-gray-600 dark:text-gray-400 font-normal line-clamp-1\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t{prompt.title[1]}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"font-medium dark:text-gray-300 dark:group-hover:text-gray-200 transition line-clamp-1\\"\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t{prompt.content}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"text-xs text-gray-600 dark:text-gray-400 font-normal line-clamp-1\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Prompt')}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t</button>\\n\\t\\t\\t{/each}\\n\\t\\t</div>\\n\\t{/if}\\n</div>\\n\\n<style>\\n\\t/* Waterfall animation for the suggestions */\\n\\t@keyframes fadeInUp {\\n\\t\\t0% {\\n\\t\\t\\topacity: 0;\\n\\t\\t\\ttransform: translateY(20px);\\n\\t\\t}\\n\\t\\t100% {\\n\\t\\t\\topacity: 1;\\n\\t\\t\\ttransform: translateY(0);\\n\\t\\t}\\n\\t}\\n\\n\\t.waterfall {\\n\\t\\topacity: 0;\\n\\t\\tanimation-name: fadeInUp;\\n\\t\\tanimation-duration: 200ms;\\n\\t\\tanimation-fill-mode: forwards;\\n\\t\\tanimation-timing-function: ease;\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AAwGC,WAAW,uBAAS,CACnB,EAAG,CACF,OAAO,CAAE,CAAC,CACV,SAAS,CAAE,WAAW,IAAI,CAC3B,CACA,IAAK,CACJ,OAAO,CAAE,CAAC,CACV,SAAS,CAAE,WAAW,CAAC,CACxB,CACD,CAEA,yBAAW,CACV,OAAO,CAAE,CAAC,CACV,cAAc,CAAE,uBAAQ,CACxB,kBAAkB,CAAE,KAAK,CACzB,mBAAmB,CAAE,QAAQ,CAC7B,yBAAyB,CAAE,IAC5B"}`
};
function arraysEqual(a, b) {
  if (a.length !== b.length) return false;
  for (let i = 0; i < a.length; i++) {
    if ((a[i].id ?? a[i].content) !== (b[i].id ?? b[i].content)) {
      return false;
    }
  }
  return true;
}
const Suggestions = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $settings, $$unsubscribe_settings;
  let $WEBUI_NAME, $$unsubscribe_WEBUI_NAME;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_WEBUI_NAME = subscribe(WEBUI_NAME, (value) => $WEBUI_NAME = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { suggestionPrompts = [] } = $$props;
  let { className = "" } = $$props;
  let { inputValue = "" } = $$props;
  let { onSelect = (e) => {
  } } = $$props;
  let sortedPrompts = [];
  const fuseOptions = {
    keys: ["content", "title"],
    threshold: 0.5
  };
  let fuse;
  let filteredPrompts = [];
  const getFilteredPrompts = (inputValue2) => {
    if (inputValue2.length > 500) {
      filteredPrompts = [];
    } else {
      const newFilteredPrompts = inputValue2.trim() && fuse ? fuse.search(inputValue2.trim()).map((result) => result.item) : sortedPrompts;
      if (!arraysEqual(filteredPrompts, newFilteredPrompts)) {
        filteredPrompts = newFilteredPrompts;
      }
    }
  };
  if ($$props.suggestionPrompts === void 0 && $$bindings.suggestionPrompts && suggestionPrompts !== void 0) $$bindings.suggestionPrompts(suggestionPrompts);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.inputValue === void 0 && $$bindings.inputValue && inputValue !== void 0) $$bindings.inputValue(inputValue);
  if ($$props.onSelect === void 0 && $$bindings.onSelect && onSelect !== void 0) $$bindings.onSelect(onSelect);
  $$result.css.add(css);
  {
    if (suggestionPrompts) {
      sortedPrompts = [...suggestionPrompts ?? []].sort(() => Math.random() - 0.5);
      getFilteredPrompts(inputValue);
    }
  }
  fuse = new Fuse(sortedPrompts, fuseOptions);
  {
    getFilteredPrompts(inputValue);
  }
  $$unsubscribe_i18n();
  $$unsubscribe_settings();
  $$unsubscribe_WEBUI_NAME();
  return `<div class="mb-1 flex gap-1 text-xs font-medium items-center text-gray-600 dark:text-gray-400">${filteredPrompts.length > 0 ? `${validate_component(Bolt, "Bolt").$$render($$result, {}, {}, {})} ${escape($i18n.t("Suggested"))}` : ` <div class="${"flex w-full " + escape(
    $settings?.landingPageMode === "chat" ? " -mt-1" : "text-center items-center justify-center",
    true
  ) + " self-start text-gray-600 dark:text-gray-400"}">${escape($WEBUI_NAME)} ‧ v${escape(WEBUI_VERSION)}</div>`}</div> <div class="h-40 w-full">${filteredPrompts.length > 0 ? `<div role="list" class="${"max-h-40 overflow-auto scrollbar-none items-start " + escape(className, true) + " svelte-1co34if"}">${each(filteredPrompts, (prompt, idx) => {
    return ` <button role="listitem" class="waterfall flex flex-col flex-1 shrink-0 w-full justify-between px-3 py-2 rounded-xl bg-transparent hover:bg-black/5 dark:hover:bg-white/5 transition group svelte-1co34if" style="${"animation-delay: " + escape(idx * 60, true) + "ms"}"><div class="flex flex-col text-left">${prompt.title && prompt.title[0] !== "" ? `<div class="font-medium dark:text-gray-300 dark:group-hover:text-gray-200 transition line-clamp-1">${escape(prompt.title[0])}</div> <div class="text-xs text-gray-600 dark:text-gray-400 font-normal line-clamp-1">${escape(prompt.title[1])} </div>` : `<div class="font-medium dark:text-gray-300 dark:group-hover:text-gray-200 transition line-clamp-1">${escape(prompt.content)}</div> <div class="text-xs text-gray-600 dark:text-gray-400 font-normal line-clamp-1">${escape($i18n.t("Prompt"))} </div>`}</div> </button>`;
  })}</div>` : ``} </div>`;
});
const ChatPlaceholder = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $_models, $$unsubscribe__models;
  let $i18n, $$unsubscribe_i18n;
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  let $user, $$unsubscribe_user;
  let $config, $$unsubscribe_config;
  $$unsubscribe__models = subscribe(models, (value) => $_models = value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { modelIds = [] } = $$props;
  let { models: models$1 = [] } = $$props;
  let { atSelectedModel } = $$props;
  let { onSelect = (e) => {
  } } = $$props;
  let selectedModelIdx = 0;
  if ($$props.modelIds === void 0 && $$bindings.modelIds && modelIds !== void 0) $$bindings.modelIds(modelIds);
  if ($$props.models === void 0 && $$bindings.models && models$1 !== void 0) $$bindings.models(models$1);
  if ($$props.atSelectedModel === void 0 && $$bindings.atSelectedModel && atSelectedModel !== void 0) $$bindings.atSelectedModel(atSelectedModel);
  if ($$props.onSelect === void 0 && $$bindings.onSelect && onSelect !== void 0) $$bindings.onSelect(onSelect);
  models$1 = modelIds.map((id) => $_models.find((m) => m.id === id));
  {
    if (modelIds.length > 0) {
      selectedModelIdx = models$1.length - 1;
    }
  }
  $$unsubscribe__models();
  $$unsubscribe_i18n();
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe_user();
  $$unsubscribe_config();
  return `<div class="m-auto w-full max-w-6xl px-8 lg:px-20"><div class="flex justify-start"><div class="flex -space-x-4 mb-0.5">${each(models$1, (model, modelIdx) => {
    return `<button>${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: marked.parse(sanitizeResponseContent(models$1[selectedModelIdx]?.info?.meta?.description ?? "").replaceAll("\n", "<br>")),
        placement: "right"
      },
      {},
      {
        default: () => {
          return `<img crossorigin="anonymous"${add_attribute(
            "src",
            model?.info?.meta?.profile_image_url ?? ($i18n.language === "dg-DG" ? `${WEBUI_BASE_URL}/doge.png` : `${WEBUI_BASE_URL}/static/favicon.png`),
            0
          )} class="size-[2.7rem] rounded-full border-[1px] border-gray-100 dark:border-none" alt="logo" draggable="false"> `;
        }
      }
    )} </button>`;
  })}</div></div> ${$temporaryChatEnabled ? `${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      content: $i18n.t("This chat won't appear in history and your messages will not be saved."),
      className: "w-full flex justify-start mb-0.5",
      placement: "top"
    },
    {},
    {
      default: () => {
        return `<div class="flex items-center gap-2 text-gray-500 text-lg mt-2 w-fit">${validate_component(EyeSlash, "EyeSlash").$$render($$result, { strokeWidth: "2.5", className: "size-5" }, {}, {})}${escape($i18n.t("Temporary Chat"))}</div>`;
      }
    }
  )}` : ``} <div class="mt-2 mb-4 text-3xl text-gray-800 dark:text-gray-100 text-left flex items-center gap-4 font-primary"><div><div class="capitalize line-clamp-1">${models$1[selectedModelIdx]?.name ? `${escape(models$1[selectedModelIdx]?.name)}` : `${escape($i18n.t("Hello, {{name}}", { name: $user?.name }))}`}</div> <div>${models$1[selectedModelIdx]?.info?.meta?.description ?? null ? `<div class="mt-0.5 text-base font-normal text-gray-500 dark:text-gray-400 line-clamp-3 markdown"><!-- HTML_TAG_START -->${marked.parse(sanitizeResponseContent(models$1[selectedModelIdx]?.info?.meta?.description).replaceAll("\n", "<br>"))}<!-- HTML_TAG_END --></div> ${models$1[selectedModelIdx]?.info?.meta?.user ? `<div class="mt-0.5 text-sm font-normal text-gray-400 dark:text-gray-500">By
								${models$1[selectedModelIdx]?.info?.meta?.user.community ? `<a href="${"https://openwebui.com/m/" + escape(models$1[selectedModelIdx]?.info?.meta?.user.username, true)}">${escape(models$1[selectedModelIdx]?.info?.meta?.user.name ? models$1[selectedModelIdx]?.info?.meta?.user.name : `@${models$1[selectedModelIdx]?.info?.meta?.user.username}`)}</a>` : `${escape(models$1[selectedModelIdx]?.info?.meta?.user.name)}`}</div>` : ``}` : `<div class="text-gray-400 dark:text-gray-500 line-clamp-1 font-p">${escape($i18n.t("How can I help you today?"))}</div>`}</div></div></div> <div class="w-full font-primary">${validate_component(Suggestions, "Suggestions").$$render(
    $$result,
    {
      className: "grid grid-cols-2",
      suggestionPrompts: atSelectedModel?.info?.meta?.suggestion_prompts ?? models$1[selectedModelIdx]?.info?.meta?.suggestion_prompts ?? $config?.default_prompt_suggestions ?? [],
      onSelect
    },
    {},
    {}
  )}</div></div>`;
});
const Messages = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $settings, $$unsubscribe_settings;
  let $currentChatPage, $$unsubscribe_currentChatPage;
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  let $_user, $$unsubscribe__user;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_currentChatPage = subscribe(currentChatPage, (value) => $currentChatPage = value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  $$unsubscribe__user = subscribe(user, (value) => $_user = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { className = "h-full flex pt-8" } = $$props;
  let { chatId: chatId2 = "" } = $$props;
  let { user: user$1 = $_user } = $$props;
  let { prompt } = $$props;
  let { history = {} } = $$props;
  let { selectedModels } = $$props;
  let { atSelectedModel } = $$props;
  let messages = [];
  let { setInputText = () => {
  } } = $$props;
  let { sendMessage } = $$props;
  let { continueResponse } = $$props;
  let { regenerateResponse } = $$props;
  let { mergeResponses } = $$props;
  let { chatActionHandler } = $$props;
  let { showMessage = () => {
  } } = $$props;
  let { submitMessage = () => {
  } } = $$props;
  let { addMessages = () => {
  } } = $$props;
  let { readOnly = false } = $$props;
  let { editCodeBlock = true } = $$props;
  let { topPadding = false } = $$props;
  let { bottomPadding = false } = $$props;
  let { autoScroll } = $$props;
  let { onSelect = (e) => {
  } } = $$props;
  let { messagesCount = 20 } = $$props;
  const scrollToBottom = () => {
    const element = document.getElementById("messages-container");
    element.scrollTop = element.scrollHeight;
  };
  const updateChat = async () => {
    if (!$temporaryChatEnabled) {
      history = history;
      await tick();
      await updateChatById(localStorage.token, chatId2, { history, messages });
      currentChatPage.set(1);
      await chats.set(await getChatList(localStorage.token, $currentChatPage));
    }
  };
  const gotoMessage = async (message, idx) => {
    let siblings;
    if (message.parentId !== null) {
      siblings = history.messages[message.parentId].childrenIds;
    } else {
      siblings = Object.values(history.messages).filter((msg) => msg.parentId === null).map((msg) => msg.id);
    }
    idx = Math.max(0, Math.min(idx, siblings.length - 1));
    let messageId = siblings[idx];
    if (message.id !== messageId) {
      let messageChildrenIds = history.messages[messageId].childrenIds;
      while (messageChildrenIds.length !== 0) {
        messageId = messageChildrenIds.at(-1);
        messageChildrenIds = history.messages[messageId].childrenIds;
      }
      history.currentId = messageId;
    }
    await tick();
    if ($settings?.scrollOnBranchChange ?? true) {
      const element = document.getElementById("messages-container");
      autoScroll = element.scrollHeight - element.scrollTop <= element.clientHeight + 50;
      setTimeout(
        () => {
          scrollToBottom();
        },
        100
      );
    }
  };
  const showPreviousMessage = async (message) => {
    if (message.parentId !== null) {
      let messageId = history.messages[message.parentId].childrenIds[Math.max(history.messages[message.parentId].childrenIds.indexOf(message.id) - 1, 0)];
      if (message.id !== messageId) {
        let messageChildrenIds = history.messages[messageId].childrenIds;
        while (messageChildrenIds.length !== 0) {
          messageId = messageChildrenIds.at(-1);
          messageChildrenIds = history.messages[messageId].childrenIds;
        }
        history.currentId = messageId;
      }
    } else {
      let childrenIds = Object.values(history.messages).filter((message2) => message2.parentId === null).map((message2) => message2.id);
      let messageId = childrenIds[Math.max(childrenIds.indexOf(message.id) - 1, 0)];
      if (message.id !== messageId) {
        let messageChildrenIds = history.messages[messageId].childrenIds;
        while (messageChildrenIds.length !== 0) {
          messageId = messageChildrenIds.at(-1);
          messageChildrenIds = history.messages[messageId].childrenIds;
        }
        history.currentId = messageId;
      }
    }
    await tick();
    if ($settings?.scrollOnBranchChange ?? true) {
      const element = document.getElementById("messages-container");
      autoScroll = element.scrollHeight - element.scrollTop <= element.clientHeight + 50;
      setTimeout(
        () => {
          scrollToBottom();
        },
        100
      );
    }
  };
  const showNextMessage = async (message) => {
    if (message.parentId !== null) {
      let messageId = history.messages[message.parentId].childrenIds[Math.min(history.messages[message.parentId].childrenIds.indexOf(message.id) + 1, history.messages[message.parentId].childrenIds.length - 1)];
      if (message.id !== messageId) {
        let messageChildrenIds = history.messages[messageId].childrenIds;
        while (messageChildrenIds.length !== 0) {
          messageId = messageChildrenIds.at(-1);
          messageChildrenIds = history.messages[messageId].childrenIds;
        }
        history.currentId = messageId;
      }
    } else {
      let childrenIds = Object.values(history.messages).filter((message2) => message2.parentId === null).map((message2) => message2.id);
      let messageId = childrenIds[Math.min(childrenIds.indexOf(message.id) + 1, childrenIds.length - 1)];
      if (message.id !== messageId) {
        let messageChildrenIds = history.messages[messageId].childrenIds;
        while (messageChildrenIds.length !== 0) {
          messageId = messageChildrenIds.at(-1);
          messageChildrenIds = history.messages[messageId].childrenIds;
        }
        history.currentId = messageId;
      }
    }
    await tick();
    if ($settings?.scrollOnBranchChange ?? true) {
      const element = document.getElementById("messages-container");
      autoScroll = element.scrollHeight - element.scrollTop <= element.clientHeight + 50;
      setTimeout(
        () => {
          scrollToBottom();
        },
        100
      );
    }
  };
  const rateMessage = async (messageId, rating) => {
    history.messages[messageId].annotation = {
      ...history.messages[messageId].annotation,
      rating
    };
    await updateChat();
  };
  const editMessage = async (messageId, { content, files }, submit = true) => {
    if ((selectedModels ?? []).filter((id) => id).length === 0) {
      toast.error($i18n.t("Model not selected"));
      return;
    }
    if (history.messages[messageId].role === "user") {
      if (submit) {
        let userPrompt = content;
        let userMessageId = v4();
        let userMessage = {
          id: userMessageId,
          parentId: history.messages[messageId].parentId,
          childrenIds: [],
          role: "user",
          content: userPrompt,
          ...files && { files },
          models: selectedModels,
          timestamp: Math.floor(Date.now() / 1e3)
        };
        let messageParentId = history.messages[messageId].parentId;
        if (messageParentId !== null) {
          history.messages[messageParentId].childrenIds = [...history.messages[messageParentId].childrenIds, userMessageId];
        }
        history.messages[userMessageId] = userMessage;
        history.currentId = userMessageId;
        await tick();
        await sendMessage(history, userMessageId);
      } else {
        history.messages[messageId].content = content;
        history.messages[messageId].files = files;
        await updateChat();
      }
    } else {
      if (submit) {
        const responseMessageId = v4();
        const message = history.messages[messageId];
        const parentId = message.parentId;
        const responseMessage = {
          ...message,
          id: responseMessageId,
          parentId,
          childrenIds: [],
          files: void 0,
          content,
          timestamp: Math.floor(Date.now() / 1e3)
        };
        history.messages[responseMessageId] = responseMessage;
        history.currentId = responseMessageId;
        if (parentId !== null) {
          history.messages[parentId].childrenIds = [...history.messages[parentId].childrenIds, responseMessageId];
        }
        await updateChat();
      } else {
        history.messages[messageId].originalContent = history.messages[messageId].content;
        history.messages[messageId].content = content;
        await updateChat();
      }
    }
  };
  const actionMessage = async (actionId, message, event = null) => {
    await chatActionHandler(chatId2, actionId, message.model, message.id, event);
  };
  const saveMessage = async (messageId, message) => {
    history.messages[messageId] = message;
    await updateChat();
  };
  const deleteMessage = async (messageId) => {
    const messageToDelete = history.messages[messageId];
    const parentMessageId = messageToDelete.parentId;
    const childMessageIds = messageToDelete.childrenIds ?? [];
    const grandchildrenIds = childMessageIds.flatMap((childId) => history.messages[childId]?.childrenIds ?? []);
    if (parentMessageId && history.messages[parentMessageId]) {
      history.messages[parentMessageId].childrenIds = [
        ...history.messages[parentMessageId].childrenIds.filter((id) => id !== messageId),
        ...grandchildrenIds
      ];
    }
    grandchildrenIds.forEach((grandchildId) => {
      if (history.messages[grandchildId]) {
        history.messages[grandchildId].parentId = parentMessageId;
      }
    });
    [messageId, ...childMessageIds].forEach((id) => {
      delete history.messages[id];
    });
    await tick();
    showMessage({ id: parentMessageId });
    await updateChat();
  };
  const triggerScroll = () => {
    if (autoScroll) {
      const element = document.getElementById("messages-container");
      autoScroll = element.scrollHeight - element.scrollTop <= element.clientHeight + 50;
      setTimeout(
        () => {
          scrollToBottom();
        },
        100
      );
    }
  };
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  if ($$props.user === void 0 && $$bindings.user && user$1 !== void 0) $$bindings.user(user$1);
  if ($$props.prompt === void 0 && $$bindings.prompt && prompt !== void 0) $$bindings.prompt(prompt);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.atSelectedModel === void 0 && $$bindings.atSelectedModel && atSelectedModel !== void 0) $$bindings.atSelectedModel(atSelectedModel);
  if ($$props.setInputText === void 0 && $$bindings.setInputText && setInputText !== void 0) $$bindings.setInputText(setInputText);
  if ($$props.sendMessage === void 0 && $$bindings.sendMessage && sendMessage !== void 0) $$bindings.sendMessage(sendMessage);
  if ($$props.continueResponse === void 0 && $$bindings.continueResponse && continueResponse !== void 0) $$bindings.continueResponse(continueResponse);
  if ($$props.regenerateResponse === void 0 && $$bindings.regenerateResponse && regenerateResponse !== void 0) $$bindings.regenerateResponse(regenerateResponse);
  if ($$props.mergeResponses === void 0 && $$bindings.mergeResponses && mergeResponses !== void 0) $$bindings.mergeResponses(mergeResponses);
  if ($$props.chatActionHandler === void 0 && $$bindings.chatActionHandler && chatActionHandler !== void 0) $$bindings.chatActionHandler(chatActionHandler);
  if ($$props.showMessage === void 0 && $$bindings.showMessage && showMessage !== void 0) $$bindings.showMessage(showMessage);
  if ($$props.submitMessage === void 0 && $$bindings.submitMessage && submitMessage !== void 0) $$bindings.submitMessage(submitMessage);
  if ($$props.addMessages === void 0 && $$bindings.addMessages && addMessages !== void 0) $$bindings.addMessages(addMessages);
  if ($$props.readOnly === void 0 && $$bindings.readOnly && readOnly !== void 0) $$bindings.readOnly(readOnly);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  if ($$props.bottomPadding === void 0 && $$bindings.bottomPadding && bottomPadding !== void 0) $$bindings.bottomPadding(bottomPadding);
  if ($$props.autoScroll === void 0 && $$bindings.autoScroll && autoScroll !== void 0) $$bindings.autoScroll(autoScroll);
  if ($$props.onSelect === void 0 && $$bindings.onSelect && onSelect !== void 0) $$bindings.onSelect(onSelect);
  if ($$props.messagesCount === void 0 && $$bindings.messagesCount && messagesCount !== void 0) $$bindings.messagesCount(messagesCount);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (history.currentId) {
        let _messages = [];
        let message = history.messages[history.currentId];
        while (message && (messagesCount !== null ? _messages.length <= messagesCount : true)) {
          _messages.unshift({ ...message });
          message = message.parentId !== null ? history.messages[message.parentId] : null;
        }
        messages = _messages;
      } else {
        messages = [];
      }
    }
    {
      if (autoScroll && bottomPadding) {
        (async () => {
          await tick();
          scrollToBottom();
        })();
      }
    }
    $$rendered = `<div${add_attribute("class", className, 0)}>${Object.keys(history?.messages ?? {}).length == 0 ? `${validate_component(ChatPlaceholder, "ChatPlaceholder").$$render(
      $$result,
      {
        modelIds: selectedModels,
        atSelectedModel,
        onSelect
      },
      {},
      {}
    )}` : `<div class="w-full pt-2"><section class="w-full" aria-labelledby="chat-conversation"><h2 class="sr-only" id="chat-conversation">${escape($i18n.t("Chat Conversation"))}</h2> ${messages.at(0)?.parentId !== null ? `${validate_component(Loader, "Loader").$$render($$result, {}, {}, {
      default: () => {
        return `<div class="w-full flex justify-center py-1 text-xs animate-pulse items-center gap-2">${validate_component(Spinner, "Spinner").$$render($$result, { className: " size-4" }, {}, {})} <div class="">${escape($i18n.t("Loading..."))}</div></div>`;
      }
    })}` : ``} <ul role="log" aria-live="polite" aria-relevant="additions" aria-atomic="false">${each(messages, (message, messageIdx) => {
      return `${validate_component(Message, "Message").$$render(
        $$result,
        {
          chatId: chatId2,
          selectedModels,
          messageId: message.id,
          idx: messageIdx,
          user: user$1,
          setInputText,
          gotoMessage,
          showPreviousMessage,
          showNextMessage,
          updateChat,
          editMessage,
          deleteMessage,
          rateMessage,
          actionMessage,
          saveMessage,
          submitMessage,
          regenerateResponse,
          continueResponse,
          mergeResponses,
          addMessages,
          triggerScroll,
          readOnly,
          editCodeBlock,
          topPadding,
          history
        },
        {
          history: ($$value) => {
            history = $$value;
            $$settled = false;
          }
        },
        {}
      )}`;
    })}</ul></section> <div class="pb-18"></div> ${bottomPadding ? `<div class="pb-6"></div>` : ``}</div>`}</div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_settings();
  $$unsubscribe_currentChatPage();
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe__user();
  return $$rendered;
});
export {
  Messages as M,
  Suggestions as S,
  archiveChatById as a,
  getChatPinnedStatusById as b,
  cloneChatById as c,
  getChatList as d,
  getPinnedChatList as e,
  getChatListByFolderId as f,
  getArchivedChatList as g,
  getChatsByFolderId as h,
  getChatListBySearchText as i,
  getChatById as j,
  getAllTags as k,
  importChat as l,
  getTagsById as m,
  createNewChat as n,
  updateChatById as o,
  getChatByShareId as p,
  updateChatFolderIdById as u
};
//# sourceMappingURL=Messages.js.map
