import { c as create_ssr_component, p as createEventDispatcher, v as validate_component, a as add_attribute, l as getContext, b as subscribe, g as escape, e as each, o as onDestroy, i as spread, k as escape_object, j as escape_attribute_value, r as is_promise, n as noop } from "./ssr.js";
import { t as tick } from "./ssr2.js";
import { v4 } from "uuid";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { g as getSessionUser, D as Drawer, P as Pane, a as Pane_group } from "./Drawer.js";
import { g as goto } from "./client.js";
import { p as page$1 } from "./stores.js";
import { R as RETRIEVAL_API_BASE_URL, E as tools, e as toolServers, c as config, a as settings, t as temporaryChatEnabled, u as user, q as models, m as mobile, T as TTSWorker, D as WEBUI_API_BASE_URL, j as folders, d as chatId, n as showSidebar, F as showControls, G as banners, C as functions, H as showCallOverlay, I as showArtifacts, J as embed, K as showOverview, L as showEmbeds, k as selectedFolder, b as currentChatPage, l as chats, h as WEBUI_BASE_URL, s as socket, M as chatTitle, W as WEBUI_NAME, o as tags, p as pinnedChats } from "./index.js";
import { e as extractInputVariables, b as getUserPosition, d as getAge, f as getFormattedDate, h as getFormattedTime, i as getCurrentDateTime, j as getUserTimezone, k as getWeekday, l as convertHeicToJpeg, m as extractContentFromFile, n as compressImage, o as blobToFile, c as createMessagesList, p as getTimeRange, s as sanitizeResponseContent, q as convertMessagesToHistory, r as getMessageContentParts, t as removeAllDetails, a as copyToClipboard, u as processDetails, v as getPromptVariables } from "./index2.js";
import { f as getChatListByFolderId, h as getChatsByFolderId, d as getChatList, S as Suggestions, j as getChatById, m as getTagsById, n as createNewChat, M as Messages, k as getAllTags, o as updateChatById, u as updateChatFolderIdById, e as getPinnedChatList } from "./Messages.js";
import { g as generateOpenAIChatCompletion } from "./index10.js";
import { u as updateUserSettings, a as getUserSettings, b as getAndUpdateUserLocation } from "./index6.js";
import { c as generateEmoji, d as getTaskIdsByChatId, e as chatAction, s as stopTask, f as generateMoACompletion, h as chatCompleted } from "./index7.js";
import { g as getUserValvesById, a as getUserValvesSpecById, b as getToolValvesById, c as getToolValvesSpecById, d as getTools } from "./index11.js";
import { EventSourceParserStream } from "eventsource-parser/stream";
import DOMPurify from "dompurify";
import { marked } from "marked";
import { u as uploadFile } from "./index12.js";
import "yaml";
import "dequal";
import "./create.js";
import dayjs from "dayjs";
/* empty css                                    */
import localizedFormat from "dayjs/plugin/localizedFormat.js";
import "./Drawer.svelte_svelte_type_style_lang.js";
import { F as FilesOverlay } from "./FilesOverlay.js";
import { M as Modal } from "./Modal.js";
import { C as Collapsible, a as Clipboard, S as SVGPanZoom, F as FullHeightIframe } from "./Collapsible.js";
import { X as XMark } from "./XMark.js";
import "turndown";
import "@joplin/turndown-plugin-gfm";
import "@tiptap/starter-kit";
import "@tiptap/extension-table";
import "@tiptap/extension-list";
import "@tiptap/extensions";
import "@tiptap/extension-file-handler";
import "@tiptap/extension-typography";
import "@tiptap/extension-highlight";
import "@tiptap/extension-code-block-lowlight";
import "@tiptap/extension-mention";
import "panzoom";
import fileSaver from "file-saver";
import { S as Spinner } from "./Spinner.js";
import "dayjs/plugin/relativeTime.js";
import { g as getUserValvesById$1, a as getUserValvesSpecById$1, b as getFunctionValvesById, c as getFunctionValvesSpecById, d as getFunctions } from "./index8.js";
import { S as Switch_1 } from "./Switch.js";
import "postcss/lib/list";
import { S as ShareChatModal, F as FolderModal, a as FolderMenu, u as updateFolderById, g as getFolderById } from "./FolderModal.js";
import { S as Selector } from "./Selector.js";
import { T as Tooltip } from "./Tooltip.js";
import { S as Share, M as Menu_sub, a as Menu_sub_trigger, b as Menu_sub_content } from "./Share.js";
import { M as Menu_content, a as Menu_item } from "./menu-trigger.js";
import { f as flyAndScale } from "./index4.js";
import { T as Tags, D as Dropdown } from "./Tags.js";
import { M as Map$1, A as ArchiveBox, U as UserMenu } from "./UserMenu.js";
import { F as Folder, a as FileItem } from "./FileItem.js";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import "dayjs/plugin/duration.js";
import { D as Download, C as ChevronUp } from "./Download.js";
/* empty css                                            */
import "i18next";
import { B as Banner } from "./Banner.js";
import { S as Sidebar } from "./Sidebar.js";
import { E as EllipsisHorizontal } from "./EllipsisHorizontal.js";
import { s as synthesizeOpenAISpeech, t as transcribeAudio, P as Pane_resizer } from "./pane-resizer.js";
import { T as Textarea } from "./Textarea.js";
import { P as Plus } from "./Plus.js";
import { C as ConfirmDialog } from "./ConfirmDialog.js";
import { E as EyeSlash } from "./EyeSlash.js";
import { C as ChevronDown } from "./ChevronDown.js";
import { E as Emoji } from "./Emoji.js";
import { E as EmojiPicker } from "./EmojiPicker.js";
const Tags_1 = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  createEventDispatcher();
  let { chatId: chatId2 = "" } = $$props;
  let tags$1 = [];
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  return `${validate_component(Tags, "Tags").$$render($$result, { tags: tags$1 }, {}, {})}`;
});
async function createOpenAITextStream(responseBody, splitLargeDeltas) {
  const eventStream = responseBody.pipeThrough(new TextDecoderStream()).pipeThrough(new EventSourceParserStream()).getReader();
  let iterator = openAIStreamToIterator(eventStream);
  if (splitLargeDeltas) {
    iterator = streamLargeDeltasAsRandomChunks(iterator);
  }
  return iterator;
}
async function* openAIStreamToIterator(reader) {
  while (true) {
    const { value, done } = await reader.read();
    if (done) {
      yield { done: true, value: "" };
      break;
    }
    if (!value) {
      continue;
    }
    const data = value.data;
    if (data.startsWith("[DONE]")) {
      yield { done: true, value: "" };
      break;
    }
    try {
      const parsedData = JSON.parse(data);
      /* @__PURE__ */ console.log(parsedData);
      if (parsedData.error) {
        yield { done: true, value: "", error: parsedData.error };
        break;
      }
      if (parsedData.sources) {
        yield { done: false, value: "", sources: parsedData.sources };
        continue;
      }
      if (parsedData.selected_model_id) {
        yield { done: false, value: "", selectedModelId: parsedData.selected_model_id };
        continue;
      }
      if (parsedData.usage) {
        yield { done: false, value: "", usage: parsedData.usage };
        continue;
      }
      yield {
        done: false,
        value: parsedData.choices?.[0]?.delta?.content ?? ""
      };
    } catch (e) {
    }
  }
}
async function* streamLargeDeltasAsRandomChunks(iterator) {
  for await (const textStreamUpdate of iterator) {
    if (textStreamUpdate.done) {
      yield textStreamUpdate;
      return;
    }
    if (textStreamUpdate.error) {
      yield textStreamUpdate;
      continue;
    }
    if (textStreamUpdate.sources) {
      yield textStreamUpdate;
      continue;
    }
    if (textStreamUpdate.selectedModelId) {
      yield textStreamUpdate;
      continue;
    }
    if (textStreamUpdate.usage) {
      yield textStreamUpdate;
      continue;
    }
    let content = textStreamUpdate.value;
    if (content.length < 5) {
      yield { done: false, value: content };
      continue;
    }
    while (content != "") {
      const chunkSize = Math.min(Math.floor(Math.random() * 3) + 1, content.length);
      const chunk = content.slice(0, chunkSize);
      yield { done: false, value: chunk };
      if (document?.visibilityState !== "hidden") {
        await sleep(5);
      }
      content = content.slice(chunkSize);
    }
  }
}
const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
const Cube = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "2" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="m21 7.5-9-5.25L3 7.5m18 0-9 5.25m9-5.25v9l-9 5.25M3 7.5l9 5.25M3 7.5v9l9 5.25m0-9v9"></path></svg>`;
});
const AdvancedParams = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { onChange = () => {
  } } = $$props;
  let { admin = false } = $$props;
  let { custom = false } = $$props;
  const defaultParams = {
    // Advanced
    stream_response: null,
    // Set stream responses for this model individually
    stream_delta_chunk_size: null,
    // Set the chunk size for streaming responses
    function_calling: null,
    reasoning_tags: null,
    seed: null,
    stop: null,
    temperature: null,
    reasoning_effort: null,
    logit_bias: null,
    max_tokens: null,
    top_k: null,
    top_p: null,
    min_p: null,
    frequency_penalty: null,
    presence_penalty: null,
    mirostat: null,
    mirostat_eta: null,
    mirostat_tau: null,
    repeat_last_n: null,
    tfs_z: null,
    repeat_penalty: null,
    use_mmap: null,
    use_mlock: null,
    think: null,
    format: null,
    keep_alive: null,
    num_keep: null,
    num_ctx: null,
    num_batch: null,
    num_thread: null,
    num_gpu: null
  };
  let { params = defaultParams } = $$props;
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  if ($$props.admin === void 0 && $$bindings.admin && admin !== void 0) $$bindings.admin(admin);
  if ($$props.custom === void 0 && $$bindings.custom && custom !== void 0) $$bindings.custom(custom);
  if ($$props.params === void 0 && $$bindings.params && params !== void 0) $$bindings.params(params);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (params) {
        onChange(params);
      }
    }
    $$rendered = `<div class="space-y-1 text-xs pb-safe-bottom"><div>${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("When enabled, the model will respond to each chat message in real-time, generating a response as soon as the user sends a message. This mode is useful for live chat applications, but may impact performance on slower hardware."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Stream Chat Response"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${params.stream_response === true ? `<span class="ml-2 self-center">${escape($i18n.t("On"))}</span>` : `${params.stream_response === false ? `<span class="ml-2 self-center">${escape($i18n.t("Off"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>`}`}</button></div>`;
        }
      }
    )}</div> ${admin ? `<div>${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("The stream delta chunk size for the model. Increasing the chunk size will make the model respond with larger pieces of text at once."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Stream Delta Chunk Size"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.stream_delta_chunk_size ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.stream_delta_chunk_size ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="1" max="128" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.stream_delta_chunk_size, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="1" step="any"${add_attribute("value", params.stream_delta_chunk_size, 0)}></div></div>` : ``}</div>` : ``} <div>${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Default mode works with a wider range of models by calling tools once before execution. Native mode leverages the model's built-in tool-calling capabilities, but requires the model to inherently support this feature."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Function Calling"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${params.function_calling === "native" ? `<span class="ml-2 self-center">${escape($i18n.t("Native"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>`}</button></div>`;
        }
      }
    )}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t('Enable, disable, or customize the reasoning tags used by the model. "Enabled" uses default tags, "Disabled" turns off reasoning tags, and "Custom" lets you specify your own start and end tags.'),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Reasoning Tags"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.reasoning_tags ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `${(params?.reasoning_tags ?? null) === true ? `<span class="ml-2 self-center">${escape($i18n.t("Enabled"))}</span>` : `${(params?.reasoning_tags ?? null) === false ? `<span class="ml-2 self-center">${escape($i18n.t("Disabled"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}`}`}</button></div>`;
        }
      }
    )} ${![true, false, null].includes(params?.reasoning_tags ?? null) && (params?.reasoning_tags ?? []).length === 2 ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${add_attribute("placeholder", $i18n.t("Start Tag"), 0)} autocomplete="off"${add_attribute("value", params.reasoning_tags[0], 0)}></div> <div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${add_attribute("placeholder", $i18n.t("End Tag"), 0)} autocomplete="off"${add_attribute("value", params.reasoning_tags[1], 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Sets the random number seed to use for generation. Setting this to a specific number will make the model generate the same text for the same prompt."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Seed"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.seed ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.seed ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="number"${add_attribute("placeholder", $i18n.t("Enter Seed"), 0)} autocomplete="off" min="0"${add_attribute("value", params.seed, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Sets the stop sequences to use. When this pattern is encountered, the LLM will stop generating text and return. Multiple stop patterns may be set by specifying multiple separate stop parameters in a modelfile."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Stop Sequence"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.stop ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.stop ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${add_attribute("placeholder", $i18n.t("Enter stop sequence"), 0)} autocomplete="off"${add_attribute("value", params.stop, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("The temperature of the model. Increasing the temperature will make the model answer more creatively."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Temperature"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.temperature ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.temperature ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="2" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.temperature, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="2" step="any"${add_attribute("value", params.temperature, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Constrains effort on reasoning for reasoning models. Only applicable to reasoning models from specific providers that support reasoning effort."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Reasoning Effort"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.reasoning_effort ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.reasoning_effort ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${add_attribute("placeholder", $i18n.t("Enter reasoning effort"), 0)} autocomplete="off"${add_attribute("value", params.reasoning_effort, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Boosting or penalizing specific tokens for constrained responses. Bias values will be clamped between -100 and 100 (inclusive). (Default: none)"),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("logit_bias")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.logit_bias ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.logit_bias ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${add_attribute("placeholder", $i18n.t('Enter comma-separated "token:bias_value" pairs (example: 5432:100, 413:-100)'), 0)} autocomplete="off"${add_attribute("value", params.logit_bias, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("This option sets the maximum number of tokens the model can generate in its response. Increasing this limit allows the model to provide longer answers, but it may also increase the likelihood of unhelpful or irrelevant content being generated."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("max_tokens")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.max_tokens ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.max_tokens ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="131072" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.max_tokens, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="-2" step="1"${add_attribute("value", params.max_tokens, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Reduces the probability of generating nonsense. A higher value (e.g. 100) will give more diverse answers, while a lower value (e.g. 10) will be more conservative."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("top_k")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.top_k ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.top_k ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1000" step="0.5" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.top_k, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="100" step="any"${add_attribute("value", params.top_k, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Works together with top-k. A higher value (e.g., 0.95) will lead to more diverse text, while a lower value (e.g., 0.5) will generate more focused and conservative text."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("top_p")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.top_p ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.top_p ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.top_p, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="1" step="any"${add_attribute("value", params.top_p, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Alternative to the top_p, and aims to ensure a balance of quality and variety. The parameter p represents the minimum probability for a token to be considered, relative to the probability of the most likely token. For example, with p=0.05 and the most likely token having a probability of 0.9, logits with a value less than 0.045 are filtered out."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("min_p")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.min_p ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.min_p ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.min_p, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="1" step="any"${add_attribute("value", params.min_p, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Sets a scaling bias against tokens to penalize repetitions, based on how many times they have appeared. A higher value (e.g., 1.5) will penalize repetitions more strongly, while a lower value (e.g., 0.9) will be more lenient. At 0, it is disabled."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("frequency_penalty")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.frequency_penalty ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.frequency_penalty ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="2" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.frequency_penalty, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="-2" max="2" step="any"${add_attribute("value", params.frequency_penalty, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Sets a flat bias against tokens that have appeared at least once. A higher value (e.g., 1.5) will penalize repetitions more strongly, while a lower value (e.g., 0.9) will be more lenient. At 0, it is disabled."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("presence_penalty")}</div> <button class="p-1 px-3 text-xs flex rounded transition flex-shrink-0 outline-none" type="button">${(params?.presence_penalty ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.presence_penalty ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="2" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.presence_penalty, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="-2" max="2" step="any"${add_attribute("value", params.presence_penalty, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Enable Mirostat sampling for controlling perplexity."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("mirostat")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.mirostat ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.mirostat ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="2" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.mirostat, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="2" step="1"${add_attribute("value", params.mirostat, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Influences how quickly the algorithm responds to feedback from the generated text. A lower learning rate will result in slower adjustments, while a higher learning rate will make the algorithm more responsive."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("mirostat_eta")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.mirostat_eta ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.mirostat_eta ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.mirostat_eta, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="1" step="any"${add_attribute("value", params.mirostat_eta, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Controls the balance between coherence and diversity of the output. A lower value will result in more focused and coherent text."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("mirostat_tau")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.mirostat_tau ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.mirostat_tau ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="10" step="0.5" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.mirostat_tau, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="10" step="any"${add_attribute("value", params.mirostat_tau, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Sets how far back for the model to look back to prevent repetition."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("repeat_last_n")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.repeat_last_n ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.repeat_last_n ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-1" max="128" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.repeat_last_n, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="-1" max="128" step="1"${add_attribute("value", params.repeat_last_n, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Tail free sampling is used to reduce the impact of less probable tokens from the output. A higher value (e.g., 2.0) will reduce the impact more, while a value of 1.0 disables this setting."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("tfs_z")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.tfs_z ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.tfs_z ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="2" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.tfs_z, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="0" max="2" step="any"${add_attribute("value", params.tfs_z, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Control the repetition of token sequences in the generated text. A higher value (e.g., 1.5) will penalize repetitions more strongly, while a lower value (e.g., 1.1) will be more lenient. At 1, it is disabled."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("repeat_penalty")}</div> <button class="p-1 px-3 text-xs flex rounded transition flex-shrink-0 outline-none" type="button">${(params?.repeat_penalty ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.repeat_penalty ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="2" step="0.05" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.repeat_penalty, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="-2" max="2" step="any"${add_attribute("value", params.repeat_penalty, 0)}></div></div>` : ``}</div> ${admin ? `<div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Enable Memory Mapping (mmap) to load model data. This option allows the system to use disk storage as an extension of RAM by treating disk files as if they were in RAM. This can improve model performance by allowing for faster data access. However, it may not work correctly with all systems and can consume a significant amount of disk space."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("use_mmap")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.use_mmap ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.use_mmap ?? null) !== null ? `<div class="flex justify-between items-center mt-1"><div class="text-xs text-gray-500">${escape(params.use_mmap ? $i18n.t("Enabled") : $i18n.t("Disabled"))}</div> <div class="pr-2">${validate_component(Switch_1, "Switch").$$render(
      $$result,
      { state: params.use_mmap },
      {
        state: ($$value) => {
          params.use_mmap = $$value;
          $$settled = false;
        }
      },
      {}
    )}</div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Enable Memory Locking (mlock) to prevent model data from being swapped out of RAM. This option locks the model's working set of pages into RAM, ensuring that they will not be swapped out to disk. This can help maintain performance by avoiding page faults and ensuring fast data access."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("use_mlock")}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.use_mlock ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.use_mlock ?? null) !== null ? `<div class="flex justify-between items-center mt-1"><div class="text-xs text-gray-500">${escape(params.use_mlock ? $i18n.t("Enabled") : $i18n.t("Disabled"))}</div> <div class="pr-2">${validate_component(Switch_1, "Switch").$$render(
      $$result,
      { state: params.use_mlock },
      {
        state: ($$value) => {
          params.use_mlock = $$value;
          $$settled = false;
        }
      },
      {}
    )}</div></div>` : ``}</div>` : ``} <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("This option enables or disables the use of the reasoning feature in Ollama, which allows the model to think before generating a response. When enabled, the model can take a moment to process the conversation context and generate a more thoughtful response."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("think")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${params.think === true ? `<span class="ml-2 self-center">${escape($i18n.t("On"))}</span>` : `${params.think === false ? `<span class="ml-2 self-center">${escape($i18n.t("Off"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>`}`}</button></div>`;
        }
      }
    )}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("The format to return a response in. Format can be json or a JSON schema."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("format")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${(params?.format ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("JSON"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.format ?? null) !== null ? `<div class="flex mt-0.5 space-x-2">${validate_component(Textarea, "Textarea").$$render(
      $$result,
      {
        className: "w-full  text-sm bg-transparent outline-hidden",
        placeholder: $i18n.t('e.g. "json" or a JSON schema'),
        value: params.format
      },
      {
        value: ($$value) => {
          params.format = $$value;
          $$settled = false;
        }
      },
      {}
    )}</div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("This option controls how many tokens are preserved when refreshing the context. For example, if set to 2, the last 2 tokens of the conversation context will be retained. Preserving context can help maintain the continuity of a conversation, but it may reduce the ability to respond to new topics."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("num_keep")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.num_keep ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.num_keep ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-1" max="10240000" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.num_keep, 0)}></div> <div class=""><input type="number" class="bg-transparent text-center w-14" min="-1" step="1"${add_attribute("value", params.num_keep, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Sets the size of the context window used to generate the next token."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("num_ctx")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.num_ctx ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.num_ctx ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-1" max="10240000" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.num_ctx, 0)}></div> <div class=""><input type="number" class="bg-transparent text-center w-14" min="-1" step="1"${add_attribute("value", params.num_ctx, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("The batch size determines how many text requests are processed together at once. A higher batch size can increase the performance and speed of the model, but it also requires more memory."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("num_batch")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.num_batch ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.num_batch ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="256" max="8192" step="256" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.num_batch, 0)}></div> <div><input type="number" class="bg-transparent text-center w-14" min="256" step="256"${add_attribute("value", params.num_batch, 0)}></div></div>` : ``}</div> ${admin ? `<div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Set the number of worker threads used for computation. This option controls how many threads are used to process incoming requests concurrently. Increasing this value can improve performance under high concurrency workloads but may also consume more CPU resources."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("num_thread")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.num_thread ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.num_thread ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="1" max="256" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.num_thread, 0)}></div> <div class=""><input type="number" class="bg-transparent text-center w-14" min="1" max="256" step="1"${add_attribute("value", params.num_thread, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Set the number of layers, which will be off-loaded to GPU. Increasing this value can significantly improve performance for models that are optimized for GPU acceleration but may also consume more power and GPU resources."),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("num_gpu")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${(params?.num_gpu ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.num_gpu ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="256" step="1" class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"${add_attribute("value", params.num_gpu, 0)}></div> <div class=""><input type="number" class="bg-transparent text-center w-14" min="0" max="256" step="1"${add_attribute("value", params.num_gpu, 0)}></div></div>` : ``}</div> <div class="py-0.5 w-full justify-between">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("This option controls how long the model will stay loaded into memory following the request (default: 5m)"),
        placement: "top-start",
        className: "inline-tooltip"
      },
      {},
      {
        default: () => {
          return `<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape("keep_alive")} (${escape($i18n.t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${(params?.keep_alive ?? null) === null ? `<span class="ml-2 self-center">${escape($i18n.t("Default"))}</span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))}</span>`}</button></div>`;
        }
      }
    )} ${(params?.keep_alive ?? null) !== null ? `<div class="flex mt-0.5 space-x-2"><input class="w-full text-sm bg-transparent outline-hidden" type="text"${add_attribute("placeholder", $i18n.t("e.g. '30s','10m'. Valid time units are 's', 'm', 'h'."), 0)}${add_attribute("value", params.keep_alive, 0)}></div>` : ``}</div> ${custom && admin ? `<div class="flex flex-col justify-center">${each(Object.keys(params?.custom_params ?? {}), (key) => {
      return `<div class="py-0.5 w-full justify-between mb-1"><div class="flex w-full justify-between"><div class="self-center text-xs font-medium"><input type="text" class="text-xs w-full bg-transparent outline-none"${add_attribute("placeholder", $i18n.t("Custom Parameter Name"), 0)}${add_attribute("value", key, 0)}></div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${escape($i18n.t("Remove"))} </button></div> <div class="flex mt-0.5 space-x-2"><div class="flex-1"><input type="text" class="text-sm w-full bg-transparent outline-hidden outline-none"${add_attribute("placeholder", $i18n.t("Custom Parameter Value"), 0)}${add_attribute("value", params.custom_params[key], 0)}> </div></div> </div>`;
    })} <button class="flex gap-2 items-center w-full text-center justify-center mt-1 mb-5" type="button"><div>${validate_component(Plus, "Plus").$$render($$result, {}, {}, {})}</div> <div>${escape($i18n.t("Add Custom Parameter"))}</div></button></div>` : ``}` : ``}</div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const processYoutubeVideo = async (token, url) => {
  let error = null;
  const res = await fetch(`${RETRIEVAL_API_BASE_URL}/process/youtube`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    },
    body: JSON.stringify({
      url
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const processWeb = async (token, collection_name, url) => {
  let error = null;
  const res = await fetch(`${RETRIEVAL_API_BASE_URL}/process/web`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    },
    body: JSON.stringify({
      url,
      collection_name
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const ToolServersModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $tools, $$unsubscribe_tools;
  let $i18n, $$unsubscribe_i18n;
  let $toolServers, $$unsubscribe_toolServers;
  $$unsubscribe_tools = subscribe(tools, (value) => $tools = value);
  $$unsubscribe_toolServers = subscribe(toolServers, (value) => $toolServers = value);
  let { show = false } = $$props;
  let { selectedToolIds = [] } = $$props;
  let selectedTools = [];
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.selectedToolIds === void 0 && $$bindings.selectedToolIds && selectedToolIds !== void 0) $$bindings.selectedToolIds(selectedToolIds);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    selectedTools = ($tools ?? []).filter((tool) => selectedToolIds.includes(tool.id));
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "md", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-0.5"><div class="text-lg font-medium self-center">${escape($i18n.t("Available Tools"))}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> ${selectedTools.length > 0 ? `${$toolServers.length > 0 ? `<div class="flex justify-between dark:text-gray-300 px-5 pb-1"><div class="text-base font-medium self-center">${escape($i18n.t("Tools"))}</div></div>` : ``} <div class="px-5 pb-3 w-full flex flex-col justify-center"><div class="text-sm dark:text-gray-300 mb-1">${each(selectedTools, (tool) => {
            return `${validate_component(Collapsible, "Collapsible").$$render($$result, { buttonClassName: "w-full mb-0.5" }, {}, {
              default: () => {
                return `<div class="truncate"><div class="text-sm font-medium dark:text-gray-100 text-gray-800 truncate">${escape(tool?.name)}</div> ${tool?.meta?.description ? `<div class="text-xs text-gray-500">${escape(tool?.meta?.description)} </div>` : ``}</div>  `;
              }
            })}`;
          })}</div></div>` : ``} ${$toolServers.length > 0 ? `<div class="flex justify-between dark:text-gray-300 px-5 pb-0.5"><div class="text-base font-medium self-center">${escape($i18n.t("Tool Servers"))}</div></div> <div class="px-5 pb-5 w-full flex flex-col justify-center"><div class="text-xs text-gray-600 dark:text-gray-300 mb-2">${escape($i18n.t("Open WebUI can use tools provided by any OpenAPI server."))} <br><a class="underline" href="https://github.com/open-webui/openapi-servers" target="_blank">${escape($i18n.t("Learn more about OpenAPI tool servers."))}</a></div> <div class="text-sm dark:text-gray-300 mb-1">${each($toolServers, (toolServer) => {
            return `${validate_component(Collapsible, "Collapsible").$$render($$result, { buttonClassName: "w-full", chevron: true }, {}, {
              content: () => {
                return `<div slot="content">${each(toolServer?.specs ?? [], (tool_spec) => {
                  return `<div class="my-1"><div class="font-medium text-gray-800 dark:text-gray-100">${escape(tool_spec?.name)}</div> <div>${escape(tool_spec?.description)}</div> </div>`;
                })} </div>`;
              },
              default: () => {
                return `<div><div class="text-sm font-medium dark:text-gray-100 text-gray-800">${escape(toolServer?.openapi?.info?.title)} - v${escape(toolServer?.openapi?.info?.version)}</div> <div class="text-xs text-gray-500">${escape(toolServer?.openapi?.info?.description)}</div> <div class="text-xs text-gray-500">${escape(toolServer?.url)} </div></div> `;
              }
            })}`;
          })}</div></div>` : ``}</div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_tools();
  $$unsubscribe_i18n();
  $$unsubscribe_toolServers();
  return $$rendered;
});
const MapSelector = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let mapElement;
  let { setViewLocation = [51.505, -0.09] } = $$props;
  let { points = [] } = $$props;
  let { onClick = (e) => {
  } } = $$props;
  onDestroy(async () => {
  });
  if ($$props.setViewLocation === void 0 && $$bindings.setViewLocation && setViewLocation !== void 0) $$bindings.setViewLocation(setViewLocation);
  if ($$props.points === void 0 && $$bindings.points && points !== void 0) $$bindings.points(points);
  if ($$props.onClick === void 0 && $$bindings.onClick && onClick !== void 0) $$bindings.onClick(onClick);
  return `<div class="z-10 w-full"><div class="h-96 z-10"${add_attribute("this", mapElement, 0)}></div></div>`;
});
const InputVariablesModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { variables = {} } = $$props;
  let { onSave = (e) => {
  } } = $$props;
  let loading = false;
  let variableValues = {};
  const init = async () => {
    loading = true;
    variableValues = {};
    for (const variable of Object.keys(variables)) {
      if (variables[variable]?.default !== void 0) {
        variableValues[variable] = variables[variable].default;
      } else {
        variableValues[variable] = "";
      }
    }
    loading = false;
    await tick();
    const firstInputElement = document.getElementById("input-variable-0");
    if (firstInputElement) {
      /* @__PURE__ */ console.log("Focusing first input element:", firstInputElement);
      firstInputElement.focus();
    }
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.variables === void 0 && $$bindings.variables && variables !== void 0) $$bindings.variables(variables);
  if ($$props.onSave === void 0 && $$bindings.onSave && onSave !== void 0) $$bindings.onSave(onSave);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        init();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "md", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-2"><div class="text-lg font-medium self-center">${escape($i18n.t("Input Variables"))}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-4 md:space-x-4 dark:text-gray-200"><div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6"><form class="flex flex-col w-full"><div class="px-1">${!loading ? `<div class="flex flex-col gap-1">${each(Object.keys(variables), (variable, idx) => {
            let { type, ...variableAttributes } = variables[variable] ?? {};
            return ` <div class="py-0.5 w-full justify-between"><div class="flex w-full justify-between mb-1.5"><div class="self-center text-xs font-medium">${escape(variable)} ${variables[variable]?.required ?? false ? `<span class="text-gray-500">*${escape($i18n.t("required"))}</span>` : ``} </div></div> <div class="flex mt-0.5 mb-0.5 space-x-2"><div class="flex-1">${variables[variable]?.type === "select" ? (() => {
              let options = variableAttributes?.options ?? [], placeholder = variableAttributes?.placeholder ?? "";
              return `  <select class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850" id="${"input-variable-" + escape(idx, true)}">${placeholder ? `<option value="" disabled selected>${escape(placeholder)} </option>` : ``}${each(options, (option) => {
                return `<option${add_attribute("value", option, 0)} ${option === variableValues[variable] ? "selected" : ""}>${escape(option)} </option>`;
              })}</select>`;
            })() : `${variables[variable]?.type === "checkbox" ? `<div class="flex items-center space-x-2"><div class="relative flex justify-center items-center gap-2"><input${spread(
              [
                { type: "checkbox" },
                {
                  class: "size-3.5 rounded cursor-pointer border border-gray-200 dark:border-gray-700"
                },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("checked", variableValues[variable], 1)}> <label for="${"input-variable-" + escape(idx, true)}" class="text-sm">${escape(variables[variable]?.label ?? variable)}</label></div> <input type="text" class="flex-1 py-1 text-sm dark:text-gray-300 bg-transparent outline-hidden"${add_attribute("placeholder", $i18n.t("Enter value (true/false)"), 0)} autocomplete="off" ${variables[variable]?.required ?? false ? "required" : ""}${add_attribute("value", variableValues[variable], 0)}> </div>` : `${variables[variable]?.type === "color" ? `<div class="flex items-center space-x-2"><div class="relative size-6"><input${spread(
              [
                { type: "color" },
                {
                  class: "size-6 rounded cursor-pointer border border-gray-200 dark:border-gray-700"
                },
                {
                  value: escape_attribute_value(variableValues[variable])
                },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                escape_object(variableAttributes)
              ],
              {}
            )}></div> <input type="text" class="flex-1 py-2 text-sm dark:text-gray-300 bg-transparent outline-hidden"${add_attribute("placeholder", $i18n.t("Enter hex color (e.g. #FF0000)"), 0)} autocomplete="off" ${variables[variable]?.required ?? false ? "required" : ""}${add_attribute("value", variableValues[variable], 0)}> </div>` : `${variables[variable]?.type === "date" ? `<input${spread(
              [
                { type: "date" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "datetime-local" ? `<input${spread(
              [
                { type: "datetime-local" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "email" ? `<input${spread(
              [
                { type: "email" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "month" ? `<input${spread(
              [
                { type: "month" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "number" ? `<input${spread(
              [
                { type: "number" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "range" ? `<div class="flex items-center space-x-2"><div class="relative flex justify-center items-center gap-2 flex-1"><input${spread(
              [
                { type: "range" },
                {
                  class: "w-full rounded-lg py-1 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}></div> <input type="text" class="py-1 text-sm dark:text-gray-300 bg-transparent outline-hidden text-right"${add_attribute("placeholder", $i18n.t("Enter value"), 0)} autocomplete="off" ${variables[variable]?.required ?? false ? "required" : ""}${add_attribute("value", variableValues[variable], 0)}></div> ` : `${variables[variable]?.type === "tel" ? `<input${spread(
              [
                { type: "tel" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "text" ? `<input${spread(
              [
                { type: "text" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "time" ? `<input${spread(
              [
                { type: "time" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "url" ? `<input${spread(
              [
                { type: "url" },
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"
                },
                {
                  placeholder: escape_attribute_value(variables[variable]?.placeholder ?? "")
                },
                { autocomplete: "off" },
                {
                  id: "input-variable-" + escape(idx, true)
                },
                {
                  required: (variables[variable]?.required ?? false) || null
                },
                escape_object(variableAttributes)
              ],
              {}
            )}${add_attribute("value", variableValues[variable], 0)}>` : `${variables[variable]?.type === "map" ? ` <div class="flex flex-col items-center gap-1">${validate_component(MapSelector, "MapSelector").$$render(
              $$result,
              {
                setViewLocation: (variableValues[variable] ?? "").includes(",") ?? false ? variableValues[variable].split(",") : null,
                onClick: (value) => {
                  variableValues[variable] = value;
                }
              },
              {},
              {}
            )} <input type="text" class="w-full py-1 text-left text-sm dark:text-gray-300 bg-transparent outline-hidden"${add_attribute("placeholder", $i18n.t("Enter coordinates (e.g. 51.505, -0.09)"), 0)} autocomplete="off" ${variables[variable]?.required ?? false ? "required" : ""}${add_attribute("value", variableValues[variable], 0)}> </div>` : `<textarea class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"${add_attribute("placeholder", variables[variable]?.placeholder ?? "", 0)} autocomplete="off" id="${"input-variable-" + escape(idx, true)}" ${variables[variable]?.required ?? false ? "required" : ""}>${escape(variableValues[variable] || "")}</textarea>`}`}`}`}`}`}`}`}`}`}`}`}`}`} </div></div>  </div>`;
          })}</div>` : `${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}`}</div> <div class="flex justify-end pt-3 text-sm font-medium"><button class="px-3.5 py-1.5 text-sm font-medium bg-white hover:bg-gray-100 text-black dark:bg-black dark:text-white dark:hover:bg-gray-900 transition rounded-full" type="button">${escape($i18n.t("Cancel"))}</button> <button class="px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full" type="submit">${escape($i18n.t("Save"))}</button></div></form></div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const Knobs = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg"${add_attribute("class", className, 0)} aria-hidden="true"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 1 1-3 0m3 0a1.5 1.5 0 1 0-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-9.75 0h9.75"></path></svg>`;
});
const Valves = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const dispatch = createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { valvesSpec = null } = $$props;
  let { valves = {} } = $$props;
  if ($$props.valvesSpec === void 0 && $$bindings.valvesSpec && valvesSpec !== void 0) $$bindings.valvesSpec(valvesSpec);
  if ($$props.valves === void 0 && $$bindings.valves && valves !== void 0) $$bindings.valves(valves);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${valvesSpec && Object.keys(valvesSpec?.properties ?? {}).length ? `${each(Object.keys(valvesSpec.properties), (property, idx) => {
      return `<div class="py-0.5 w-full justify-between"><div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape(valvesSpec.properties[property].title)} ${(valvesSpec?.required ?? []).includes(property) ? `<span class="text-gray-500" data-svelte-h="svelte-1pjo6rv">*required</span>` : ``}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${(valves[property] ?? null) === null ? `<span class="ml-2 self-center">${(valvesSpec?.required ?? []).includes(property) ? `${escape($i18n.t("None"))}` : `${escape($i18n.t("Default"))}`} </span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))} </span>`} </button></div> ${(valves[property] ?? null) !== null ? ` <div class="flex mt-0.5 mb-0.5 space-x-2"><div class="flex-1">${valvesSpec.properties[property]?.enum ?? null ? `<select class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850">${each(valvesSpec.properties[property].enum, (option) => {
        return `<option${add_attribute("value", option, 0)} ${option === valves[property] ? "selected" : ""}>${escape(option)} </option>`;
      })}</select>` : `${(valvesSpec.properties[property]?.type ?? null) === "boolean" ? `<div class="flex justify-between items-center"><div class="text-xs text-gray-500">${escape(valves[property] ? $i18n.t("Enabled") : $i18n.t("Disabled"))}</div> <div class="pr-2">${validate_component(Switch_1, "Switch").$$render(
        $$result,
        { state: valves[property] },
        {
          state: ($$value) => {
            valves[property] = $$value;
            $$settled = false;
          }
        },
        {}
      )}</div> </div>` : `${(valvesSpec.properties[property]?.type ?? null) !== "string" ? `<input class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850" type="text"${add_attribute("placeholder", valvesSpec.properties[property].title, 0)} autocomplete="off" required${add_attribute("value", valves[property], 0)}>` : `${valvesSpec.properties[property]?.input ?? null ? `${valvesSpec.properties[property]?.input?.type === "color" ? `<div class="flex items-center space-x-2"><div class="relative size-6"><input type="color" class="size-6 rounded cursor-pointer border border-gray-200 dark:border-gray-700"${add_attribute("value", valves[property] ?? "#000000", 0)}></div> <input type="text" class="flex-1 rounded-lg py-2 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"${add_attribute("placeholder", $i18n.t("Enter hex color (e.g. #FF0000)"), 0)} autocomplete="off" disabled${add_attribute("value", valves[property], 0)}> </div>` : `${valvesSpec.properties[property]?.input?.type === "map" ? ` <div class="flex flex-col items-center gap-1">${validate_component(MapSelector, "MapSelector").$$render(
        $$result,
        {
          setViewLocation: (valves[property] ?? "").includes(",") ?? false ? valves[property].split(",") : null,
          onClick: (value) => {
            valves[property] = value;
            dispatch("change");
          }
        },
        {},
        {}
      )} ${valves[property] ? `<input type="text" class="w-full rounded-lg py-1 text-left text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"${add_attribute("placeholder", $i18n.t("Enter coordinates (e.g. 51.505, -0.09)"), 0)} autocomplete="off"${add_attribute("value", valves[property], 0)}>` : ``} </div>` : ``}`}` : `<textarea class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"${add_attribute("placeholder", valvesSpec.properties[property].title, 0)} autocomplete="off" required>${escape(valves[property] || "")}</textarea>`}`}`}`}</div> </div>` : ``} ${(valvesSpec.properties[property]?.description ?? null) !== null ? `<div class="text-xs text-gray-500">${escape(valvesSpec.properties[property].description)} </div>` : ``} </div>`;
    })}` : `<div class="text-xs">${escape($i18n.t("No valves"))}</div>`}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const ValvesModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  createEventDispatcher();
  let { show = false } = $$props;
  let { type = "tool" } = $$props;
  let { id = null } = $$props;
  let { userValves = false } = $$props;
  let loading = false;
  let valvesSpec = null;
  let valves = {};
  const initHandler = async () => {
    loading = true;
    valves = {};
    valvesSpec = null;
    try {
      if (userValves) {
        if (type === "tool") {
          valves = await getUserValvesById(localStorage.token, id);
          valvesSpec = await getUserValvesSpecById(localStorage.token, id);
        } else if (type === "function") {
          valves = await getUserValvesById$1(localStorage.token, id);
          valvesSpec = await getUserValvesSpecById$1(localStorage.token, id);
        }
      } else {
        if (type === "tool") {
          valves = await getToolValvesById(localStorage.token, id);
          valvesSpec = await getToolValvesSpecById(localStorage.token, id);
        } else if (type === "function") {
          valves = await getFunctionValvesById(localStorage.token, id);
          valvesSpec = await getFunctionValvesSpecById(localStorage.token, id);
        }
      }
      if (!valves) {
        valves = {};
      }
      if (valvesSpec) {
        for (const property in valvesSpec.properties) {
          if (valvesSpec.properties[property]?.type === "array") {
            if (valves[property] != null) {
              valves[property] = (Array.isArray(valves[property]) ? valves[property] : []).join(",");
            } else {
              valves[property] = null;
            }
          }
        }
      }
      loading = false;
    } catch (e) {
      toast.error(`Error fetching valves`);
      show = false;
    }
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.userValves === void 0 && $$bindings.userValves && userValves !== void 0) $$bindings.userValves(userValves);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        initHandler();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "sm", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-2"><div class="text-lg font-medium self-center">${escape($i18n.t("Valves"))}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-4 md:space-x-4 dark:text-gray-200"><div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6"><form class="flex flex-col w-full"><div class="px-1">${!loading ? `${validate_component(Valves, "Valves").$$render(
            $$result,
            { valvesSpec, valves },
            {
              valves: ($$value) => {
                valves = $$value;
                $$settled = false;
              }
            },
            {}
          )}` : `${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}`}</div> <div class="flex justify-end pt-3 text-sm font-medium"><button class="${"px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full " + escape("", true)}" type="submit" ${""}>${escape($i18n.t("Save"))} ${``}</button></div></form></div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const MessageInput = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $config, $$unsubscribe_config;
  let $settings, $$unsubscribe_settings;
  let $i18n, $$unsubscribe_i18n;
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  let $_user, $$unsubscribe__user;
  let $toolServers, $$unsubscribe_toolServers;
  let $tools, $$unsubscribe_tools;
  let $models, $$unsubscribe_models;
  let $$unsubscribe_mobile;
  let $$unsubscribe_TTSWorker;
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  $$unsubscribe__user = subscribe(user, (value) => $_user = value);
  $$unsubscribe_toolServers = subscribe(toolServers, (value) => $toolServers = value);
  $$unsubscribe_tools = subscribe(tools, (value) => $tools = value);
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => value);
  $$unsubscribe_TTSWorker = subscribe(TTSWorker, (value) => value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { onChange = () => {
  } } = $$props;
  let { createMessagePair } = $$props;
  let { stopResponse } = $$props;
  let { autoScroll = false } = $$props;
  let { generating = false } = $$props;
  let { atSelectedModel = void 0 } = $$props;
  let { selectedModels } = $$props;
  let { history } = $$props;
  let { taskIds = null } = $$props;
  let { prompt = "" } = $$props;
  let { files = [] } = $$props;
  let { selectedToolIds = [] } = $$props;
  let { selectedFilterIds = [] } = $$props;
  let { imageGenerationEnabled = false } = $$props;
  let { webSearchEnabled = false } = $$props;
  let { codeInterpreterEnabled = false } = $$props;
  let showInputVariablesModal = false;
  let inputVariablesModalCallback = (variableValues) => {
  };
  let inputVariables = {};
  let inputVariableValues = {};
  let showValvesModal = false;
  let selectedValvesType = "tool";
  const inputVariableHandler = async (text) => {
    inputVariables = extractInputVariables(text);
    if (Object.keys(inputVariables).length === 0) {
      return text;
    }
    showInputVariablesModal = true;
    return await new Promise((resolve) => {
      inputVariablesModalCallback = (variableValues) => {
        inputVariableValues = {
          ...inputVariableValues,
          ...variableValues
        };
        replaceVariables(inputVariableValues);
        showInputVariablesModal = false;
        resolve(text);
      };
    });
  };
  const textVariableHandler = async (text) => {
    if (text.includes("{{CLIPBOARD}}")) {
      const clipboardText = await navigator.clipboard.readText().catch((err) => {
        toast.error($i18n.t("Failed to read clipboard contents"));
        return "{{CLIPBOARD}}";
      });
      const clipboardItems = await navigator.clipboard.read();
      let imageUrl = null;
      for (const item of clipboardItems) {
        for (const type of item.types) {
          if (type.startsWith("image/")) {
            const blob = await item.getType(type);
            imageUrl = URL.createObjectURL(blob);
          }
        }
      }
      if (imageUrl) {
        files = [...files, { type: "image", url: imageUrl }];
      }
      text = text.replaceAll("{{CLIPBOARD}}", clipboardText);
    }
    if (text.includes("{{USER_LOCATION}}")) {
      let location;
      try {
        location = await getUserPosition();
      } catch (error) {
        toast.error($i18n.t("Location access not allowed"));
        location = "LOCATION_UNKNOWN";
      }
      text = text.replaceAll("{{USER_LOCATION}}", String(location));
    }
    const sessionUser = await getSessionUser(localStorage.token);
    if (text.includes("{{USER_NAME}}")) {
      const name = sessionUser?.name || "User";
      text = text.replaceAll("{{USER_NAME}}", name);
    }
    if (text.includes("{{USER_BIO}}")) {
      const bio = sessionUser?.bio || "";
      if (bio) {
        text = text.replaceAll("{{USER_BIO}}", bio);
      }
    }
    if (text.includes("{{USER_GENDER}}")) {
      const gender = sessionUser?.gender || "";
      if (gender) {
        text = text.replaceAll("{{USER_GENDER}}", gender);
      }
    }
    if (text.includes("{{USER_BIRTH_DATE}}")) {
      const birthDate = sessionUser?.date_of_birth || "";
      if (birthDate) {
        text = text.replaceAll("{{USER_BIRTH_DATE}}", birthDate);
      }
    }
    if (text.includes("{{USER_AGE}}")) {
      const birthDate = sessionUser?.date_of_birth || "";
      if (birthDate) {
        const age = getAge(birthDate);
        text = text.replaceAll("{{USER_AGE}}", age);
      }
    }
    if (text.includes("{{USER_LANGUAGE}}")) {
      const language = localStorage.getItem("locale") || "en-US";
      text = text.replaceAll("{{USER_LANGUAGE}}", language);
    }
    if (text.includes("{{CURRENT_DATE}}")) {
      const date = getFormattedDate();
      text = text.replaceAll("{{CURRENT_DATE}}", date);
    }
    if (text.includes("{{CURRENT_TIME}}")) {
      const time = getFormattedTime();
      text = text.replaceAll("{{CURRENT_TIME}}", time);
    }
    if (text.includes("{{CURRENT_DATETIME}}")) {
      const dateTime = getCurrentDateTime();
      text = text.replaceAll("{{CURRENT_DATETIME}}", dateTime);
    }
    if (text.includes("{{CURRENT_TIMEZONE}}")) {
      const timezone = getUserTimezone();
      text = text.replaceAll("{{CURRENT_TIMEZONE}}", timezone);
    }
    if (text.includes("{{CURRENT_WEEKDAY}}")) {
      const weekday = getWeekday();
      text = text.replaceAll("{{CURRENT_WEEKDAY}}", weekday);
    }
    return text;
  };
  const replaceVariables = (variables) => {
    /* @__PURE__ */ console.log("Replacing variables:", variables);
    const chatInput = document.getElementById("chat-input");
    if (chatInput) {
      chatInputElement.replaceVariables(variables);
      chatInputElement.focus();
    }
  };
  const setText = async (text, cb) => {
    const chatInput = document.getElementById("chat-input");
    if (chatInput) {
      if (text !== "") {
        text = await textVariableHandler(text || "");
      }
      if (text !== "") {
        text = await inputVariableHandler(text);
      }
      await tick();
      if (cb) await cb(text);
    }
  };
  let command = "";
  let { showCommands = false } = $$props;
  let showTools = false;
  let chatInputElement;
  let dragged = false;
  let { placeholder = "" } = $$props;
  let visionCapableModels = [];
  let fileUploadCapableModels = [];
  let webSearchCapableModels = [];
  let imageGenerationCapableModels = [];
  let codeInterpreterCapableModels = [];
  const uploadFileHandler = async (file, fullContext = false) => {
    if ($_user?.role !== "admin" && !($_user?.permissions?.chat?.file_upload ?? true)) {
      toast.error($i18n.t("You do not have permission to upload files."));
      return null;
    }
    if (fileUploadCapableModels.length !== selectedModels.length) {
      toast.error($i18n.t("Model(s) do not support file upload"));
      return null;
    }
    const tempItemId = v4();
    const fileItem = {
      type: "file",
      file: "",
      id: null,
      url: "",
      name: file.name,
      collection_name: "",
      status: "uploading",
      size: file.size,
      error: "",
      itemId: tempItemId,
      ...fullContext ? { context: "full" } : {}
    };
    if (fileItem.size == 0) {
      toast.error($i18n.t("You cannot upload an empty file."));
      return null;
    }
    files = [...files, fileItem];
    if (!$temporaryChatEnabled) {
      try {
        let metadata = null;
        if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && $settings?.audio?.stt?.language) {
          metadata = {
            language: $settings?.audio?.stt?.language
          };
        }
        const uploadedFile = await uploadFile(localStorage.token, file, metadata);
        if (uploadedFile) {
          /* @__PURE__ */ console.log("File upload completed:", {
            id: uploadedFile.id,
            name: fileItem.name,
            collection: uploadedFile?.meta?.collection_name
          });
          if (uploadedFile.error) {
            console.warn("File upload warning:", uploadedFile.error);
            toast.warning(uploadedFile.error);
          }
          fileItem.status = "uploaded";
          fileItem.file = uploadedFile;
          fileItem.id = uploadedFile.id;
          fileItem.collection_name = uploadedFile?.meta?.collection_name || uploadedFile?.collection_name;
          fileItem.url = `${WEBUI_API_BASE_URL}/files/${uploadedFile.id}`;
          files = files;
        } else {
          files = files.filter((item) => item?.itemId !== tempItemId);
        }
      } catch (e) {
        toast.error(`${e}`);
        files = files.filter((item) => item?.itemId !== tempItemId);
      }
    } else {
      const content = await extractContentFromFile(file).catch((error) => {
        toast.error($i18n.t("Failed to extract content from the file: {{error}}", { error }));
        return null;
      });
      if (content === null) {
        toast.error($i18n.t("Failed to extract content from the file."));
        files = files.filter((item) => item?.itemId !== tempItemId);
        return null;
      } else {
        /* @__PURE__ */ console.log("Extracted content from file:", {
          name: file.name,
          size: file.size,
          content
        });
        fileItem.status = "uploaded";
        fileItem.type = "text";
        fileItem.content = content;
        fileItem.id = v4();
        files = files;
      }
    }
  };
  const inputFilesHandler = async (inputFiles2) => {
    /* @__PURE__ */ console.log("Input files handler called with:", inputFiles2);
    if (($config?.file?.max_count ?? null) !== null && files.length + inputFiles2.length > $config?.file?.max_count) {
      toast.error($i18n.t(`You can only chat with a maximum of {{maxCount}} file(s) at a time.`, { maxCount: $config?.file?.max_count }));
      return;
    }
    inputFiles2.forEach(async (file) => {
      /* @__PURE__ */ console.log("Processing file:", {
        name: file.name,
        type: file.type,
        size: file.size,
        extension: file.name.split(".").at(-1)
      });
      if (($config?.file?.max_size ?? null) !== null && file.size > ($config?.file?.max_size ?? 0) * 1024 * 1024) {
        /* @__PURE__ */ console.log("File exceeds max size limit:", {
          fileSize: file.size,
          maxSize: ($config?.file?.max_size ?? 0) * 1024 * 1024
        });
        toast.error($i18n.t(`File size should not exceed {{maxSize}} MB.`, { maxSize: $config?.file?.max_size }));
        return;
      }
      if (file["type"].startsWith("image/")) {
        if (visionCapableModels.length === 0) {
          toast.error($i18n.t("Selected model(s) do not support image inputs"));
          return;
        }
        const compressImageHandler = async (imageUrl, settings2 = {}, config2 = {}) => {
          const settingsCompression = settings2?.imageCompression ?? false;
          const configWidth = config2?.file?.image_compression?.width ?? null;
          const configHeight = config2?.file?.image_compression?.height ?? null;
          if (!settingsCompression && !configWidth && !configHeight) {
            return imageUrl;
          }
          let width = null;
          let height = null;
          if (settingsCompression) {
            width = settings2?.imageCompressionSize?.width ?? null;
            height = settings2?.imageCompressionSize?.height ?? null;
          }
          if (configWidth && (width === null || width > configWidth)) {
            width = configWidth;
          }
          if (configHeight && (height === null || height > configHeight)) {
            height = configHeight;
          }
          if (width || height) {
            return await compressImage(imageUrl, width, height);
          }
          return imageUrl;
        };
        let reader = new FileReader();
        reader.onload = async (event) => {
          let imageUrl = event.target.result;
          imageUrl = await compressImageHandler(imageUrl, $settings, $config);
          files = [...files, { type: "image", url: `${imageUrl}` }];
        };
        reader.readAsDataURL(file["type"] === "image/heic" ? await convertHeicToJpeg(file) : file);
      } else {
        uploadFileHandler(file);
      }
    });
  };
  const onDragOver = (e) => {
    e.preventDefault();
    if (e.dataTransfer?.types?.includes("Files")) {
      dragged = true;
    } else {
      dragged = false;
    }
  };
  const onDragLeave = () => {
    dragged = false;
  };
  const onDrop = async (e) => {
    e.preventDefault();
    /* @__PURE__ */ console.log(e);
    if (e.dataTransfer?.files) {
      const inputFiles2 = Array.from(e.dataTransfer?.files);
      if (inputFiles2 && inputFiles2.length > 0) {
        /* @__PURE__ */ console.log(inputFiles2);
        inputFilesHandler(inputFiles2);
      }
    }
    dragged = false;
  };
  const onKeyDown = (e) => {
    if (e.key === "Shift") ;
    if (e.key === "Escape") {
      /* @__PURE__ */ console.log("Escape");
      dragged = false;
    }
  };
  const onKeyUp = (e) => {
    if (e.key === "Shift") ;
  };
  const onFocus = () => {
  };
  const onBlur = () => {
  };
  onDestroy(() => {
    /* @__PURE__ */ console.log("destroy");
    window.removeEventListener("keydown", onKeyDown);
    window.removeEventListener("keyup", onKeyUp);
    window.removeEventListener("focus", onFocus);
    window.removeEventListener("blur", onBlur);
    const dropzoneElement = document.getElementById("chat-container");
    if (dropzoneElement) {
      dropzoneElement?.removeEventListener("dragover", onDragOver);
      dropzoneElement?.removeEventListener("drop", onDrop);
      dropzoneElement?.removeEventListener("dragleave", onDragLeave);
    }
  });
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  if ($$props.createMessagePair === void 0 && $$bindings.createMessagePair && createMessagePair !== void 0) $$bindings.createMessagePair(createMessagePair);
  if ($$props.stopResponse === void 0 && $$bindings.stopResponse && stopResponse !== void 0) $$bindings.stopResponse(stopResponse);
  if ($$props.autoScroll === void 0 && $$bindings.autoScroll && autoScroll !== void 0) $$bindings.autoScroll(autoScroll);
  if ($$props.generating === void 0 && $$bindings.generating && generating !== void 0) $$bindings.generating(generating);
  if ($$props.atSelectedModel === void 0 && $$bindings.atSelectedModel && atSelectedModel !== void 0) $$bindings.atSelectedModel(atSelectedModel);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.taskIds === void 0 && $$bindings.taskIds && taskIds !== void 0) $$bindings.taskIds(taskIds);
  if ($$props.prompt === void 0 && $$bindings.prompt && prompt !== void 0) $$bindings.prompt(prompt);
  if ($$props.files === void 0 && $$bindings.files && files !== void 0) $$bindings.files(files);
  if ($$props.selectedToolIds === void 0 && $$bindings.selectedToolIds && selectedToolIds !== void 0) $$bindings.selectedToolIds(selectedToolIds);
  if ($$props.selectedFilterIds === void 0 && $$bindings.selectedFilterIds && selectedFilterIds !== void 0) $$bindings.selectedFilterIds(selectedFilterIds);
  if ($$props.imageGenerationEnabled === void 0 && $$bindings.imageGenerationEnabled && imageGenerationEnabled !== void 0) $$bindings.imageGenerationEnabled(imageGenerationEnabled);
  if ($$props.webSearchEnabled === void 0 && $$bindings.webSearchEnabled && webSearchEnabled !== void 0) $$bindings.webSearchEnabled(webSearchEnabled);
  if ($$props.codeInterpreterEnabled === void 0 && $$bindings.codeInterpreterEnabled && codeInterpreterEnabled !== void 0) $$bindings.codeInterpreterEnabled(codeInterpreterEnabled);
  if ($$props.setText === void 0 && $$bindings.setText && setText !== void 0) $$bindings.setText(setText);
  if ($$props.showCommands === void 0 && $$bindings.showCommands && showCommands !== void 0) $$bindings.showCommands(showCommands);
  if ($$props.placeholder === void 0 && $$bindings.placeholder && placeholder !== void 0) $$bindings.placeholder(placeholder);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    atSelectedModel !== void 0 ? [atSelectedModel.id] : selectedModels;
    {
      onChange({
        prompt,
        files: files.filter((file) => file.type !== "image").map((file) => {
          return {
            ...file,
            user: void 0,
            access_control: void 0
          };
        }),
        selectedToolIds,
        selectedFilterIds,
        imageGenerationEnabled,
        webSearchEnabled,
        codeInterpreterEnabled
      });
    }
    showCommands = ["/", "#", "@"].includes(command?.charAt(0)) || "\\#" === command?.slice(0, 2);
    visionCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => $models.find((m) => m.id === model)?.info?.meta?.capabilities?.vision ?? true);
    fileUploadCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => $models.find((m) => m.id === model)?.info?.meta?.capabilities?.file_upload ?? true);
    webSearchCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => $models.find((m) => m.id === model)?.info?.meta?.capabilities?.web_search ?? true);
    imageGenerationCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => $models.find((m) => m.id === model)?.info?.meta?.capabilities?.image_generation ?? true);
    codeInterpreterCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => $models.find((m) => m.id === model)?.info?.meta?.capabilities?.code_interpreter ?? true);
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).map((id) => ($models.find((model) => model.id === id) || {})?.filters ?? []).reduce((acc, filters) => acc.filter((f1) => filters.some((f2) => f2.id === f1.id)));
    ($tools ?? []).length > 0 || ($toolServers ?? []).length > 0;
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).length === webSearchCapableModels.length && $config?.features?.enable_web_search && ($_user.role === "admin" || $_user?.permissions?.features?.web_search);
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).length === imageGenerationCapableModels.length && $config?.features?.enable_image_generation && ($_user.role === "admin" || $_user?.permissions?.features?.image_generation);
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).length === codeInterpreterCapableModels.length && $config?.features?.enable_code_interpreter && ($_user.role === "admin" || $_user?.permissions?.features?.code_interpreter);
    $$rendered = `${validate_component(FilesOverlay, "FilesOverlay").$$render($$result, { show: dragged }, {}, {})} ${validate_component(ToolServersModal, "ToolServersModal").$$render(
      $$result,
      { selectedToolIds, show: showTools },
      {
        show: ($$value) => {
          showTools = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(InputVariablesModal, "InputVariablesModal").$$render(
      $$result,
      {
        variables: inputVariables,
        onSave: inputVariablesModalCallback,
        show: showInputVariablesModal
      },
      {
        show: ($$value) => {
          showInputVariablesModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(ValvesModal, "ValvesModal").$$render(
      $$result,
      {
        userValves: true,
        type: selectedValvesType,
        id: null,
        show: showValvesModal
      },
      {
        show: ($$value) => {
          showValvesModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${``}`;
  } while (!$$settled);
  $$unsubscribe_config();
  $$unsubscribe_settings();
  $$unsubscribe_i18n();
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe__user();
  $$unsubscribe_toolServers();
  $$unsubscribe_tools();
  $$unsubscribe_models();
  $$unsubscribe_mobile();
  $$unsubscribe_TTSWorker();
  return $$rendered;
});
const ModelSelector = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $models, $$unsubscribe_models;
  let $settings, $$unsubscribe_settings;
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { selectedModels = [""] } = $$props;
  let { disabled = false } = $$props;
  let { showSetDefault = true } = $$props;
  const pinModelHandler = async (modelId) => {
    let pinnedModels = $settings?.pinnedModels ?? [];
    if (pinnedModels.includes(modelId)) {
      pinnedModels = pinnedModels.filter((id) => id !== modelId);
    } else {
      pinnedModels = [.../* @__PURE__ */ new Set([...pinnedModels, modelId])];
    }
    settings.set({ ...$settings, pinnedModels });
    await updateUserSettings(localStorage.token, { ui: $settings });
  };
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.disabled === void 0 && $$bindings.disabled && disabled !== void 0) $$bindings.disabled(disabled);
  if ($$props.showSetDefault === void 0 && $$bindings.showSetDefault && showSetDefault !== void 0) $$bindings.showSetDefault(showSetDefault);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (selectedModels.length > 0 && $models.length > 0) {
        const _selectedModels = selectedModels.map((model) => $models.map((m) => m.id).includes(model) ? model : "");
        if (JSON.stringify(_selectedModels) !== JSON.stringify(selectedModels)) {
          selectedModels = _selectedModels;
        }
      }
    }
    $$rendered = `<div class="flex flex-col w-full items-start">${each(selectedModels, (selectedModel, selectedModelIdx) => {
      return `<div class="flex w-full max-w-fit"><div class="overflow-hidden w-full"><div class="${"max-w-full " + escape($settings?.highContrastMode ?? false ? "m-1" : "mr-1", true)}">${validate_component(Selector, "Selector").$$render(
        $$result,
        {
          id: `${selectedModelIdx}`,
          placeholder: $i18n.t("Select a model"),
          items: $models.map((model) => ({
            value: model.id,
            label: model.name,
            model
          })),
          pinModelHandler,
          value: selectedModel
        },
        {
          value: ($$value) => {
            selectedModel = $$value;
            $$settled = false;
          }
        },
        {}
      )} </div></div> ${$user?.role === "admin" || ($user?.permissions?.chat?.multiple_models ?? true) ? `${selectedModelIdx === 0 ? `<div class="self-center mx-1 disabled:text-gray-600 disabled:hover:text-gray-600 -translate-y-[0.5px]">${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Add Model") }, {}, {
        default: () => {
          return `<button class="" ${disabled ? "disabled" : ""} aria-label="Add Model"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="M12 6v12m6-6H6"></path></svg></button> `;
        }
      })} </div>` : `<div class="self-center mx-1 disabled:text-gray-600 disabled:hover:text-gray-600 -translate-y-[0.5px]">${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Remove Model") }, {}, {
        default: () => {
          return `<button ${disabled ? "disabled" : ""} aria-label="Remove Model"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="size-3"><path stroke-linecap="round" stroke-linejoin="round" d="M19.5 12h-15"></path></svg></button> `;
        }
      })} </div>`}` : ``} </div>`;
    })}</div> ${showSetDefault ? `<div class="relative text-left mt-[1px] ml-1 text-[0.7rem] text-gray-600 dark:text-gray-400 font-primary"><button>${escape($i18n.t("Set as default"))}</button></div>` : ``}`;
  } while (!$$settled);
  $$unsubscribe_models();
  $$unsubscribe_settings();
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  return $$rendered;
});
const AdjustmentsHorizontal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke="currentColor" fill="currentColor"${add_attribute("class", className, 0)}${add_attribute("stroke-width", strokeWidth, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 1 1-3 0m3 0a1.5 1.5 0 1 0-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-9.75 0h9.75"></path></svg>`;
});
const Menu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  let $$unsubscribe_settings;
  let $user, $$unsubscribe_user;
  let $mobile, $$unsubscribe_mobile;
  let $i18n, $$unsubscribe_i18n;
  let $folders, $$unsubscribe_folders;
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  $$unsubscribe_settings = subscribe(settings, (value) => value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_folders = subscribe(folders, (value) => $folders = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { shareEnabled = false } = $$props;
  let { shareHandler } = $$props;
  let { moveChatHandler } = $$props;
  let { archiveChatHandler } = $$props;
  let { chat } = $$props;
  let { onClose = () => {
  } } = $$props;
  if ($$props.shareEnabled === void 0 && $$bindings.shareEnabled && shareEnabled !== void 0) $$bindings.shareEnabled(shareEnabled);
  if ($$props.shareHandler === void 0 && $$bindings.shareHandler && shareHandler !== void 0) $$bindings.shareHandler(shareHandler);
  if ($$props.moveChatHandler === void 0 && $$bindings.moveChatHandler && moveChatHandler !== void 0) $$bindings.moveChatHandler(moveChatHandler);
  if ($$props.archiveChatHandler === void 0 && $$bindings.archiveChatHandler && archiveChatHandler !== void 0) $$bindings.archiveChatHandler(archiveChatHandler);
  if ($$props.chat === void 0 && $$bindings.chat && chat !== void 0) $$bindings.chat(chat);
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe_settings();
  $$unsubscribe_user();
  $$unsubscribe_mobile();
  $$unsubscribe_i18n();
  $$unsubscribe_folders();
  return `${``} ${validate_component(Dropdown, "Dropdown").$$render($$result, {}, {}, {
    content: () => {
      return `<div slot="content">${validate_component(Menu_content, "DropdownMenu.Content").$$render(
        $$result,
        {
          class: "w-full max-w-[200px] rounded-2xl px-1 py-1  border border-gray-100  dark:border-gray-800 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg transition",
          sideOffset: 8,
          side: "bottom",
          align: "end",
          transition: flyAndScale
        },
        {},
        {
          default: () => {
            return ` ${$mobile ? `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
              $$result,
              {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                id: "chat-controls-button"
              },
              {},
              {
                default: () => {
                  return `${validate_component(AdjustmentsHorizontal, "AdjustmentsHorizontal").$$render($$result, { className: " size-4", strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Controls"))}</div>`;
                }
              }
            )}` : ``} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
              $$result,
              {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                id: "chat-overview-button"
              },
              {},
              {
                default: () => {
                  return `${validate_component(Map$1, "Map").$$render($$result, { className: " size-4", strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Overview"))}</div>`;
                }
              }
            )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
              $$result,
              {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                id: "chat-overview-button"
              },
              {},
              {
                default: () => {
                  return `${validate_component(Cube, "Cube").$$render($$result, { className: " size-4", strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Artifacts"))}</div>`;
                }
              }
            )} <hr class="border-gray-50 dark:border-gray-800 my-1"> ${!$temporaryChatEnabled && ($user?.role === "admin" || ($user.permissions?.chat?.share ?? true)) ? `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
              $$result,
              {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                id: "chat-share-button"
              },
              {},
              {
                default: () => {
                  return `${validate_component(Share, "Share").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Share"))}</div>`;
                }
              }
            )}` : ``} ${validate_component(Menu_sub, "DropdownMenu.Sub").$$render($$result, {}, {}, {
              default: () => {
                return `${validate_component(Menu_sub_trigger, "DropdownMenu.SubTrigger").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(Download, "Download").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Download"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_sub_content, "DropdownMenu.SubContent").$$render(
                  $$result,
                  {
                    class: "w-full rounded-2xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white border border-gray-100  dark:border-gray-800 shadow-lg max-h-52 overflow-y-auto scrollbar-hidden",
                    transition: flyAndScale,
                    sideOffset: 8
                  },
                  {},
                  {
                    default: () => {
                      return `${$user?.role === "admin" || ($user.permissions?.chat?.export ?? true) ? `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                        $$result,
                        {
                          class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full"
                        },
                        {},
                        {
                          default: () => {
                            return `<div class="flex items-center line-clamp-1">${escape($i18n.t("Export chat (.json)"))}</div>`;
                          }
                        }
                      )}` : ``} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                        $$result,
                        {
                          class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full"
                        },
                        {},
                        {
                          default: () => {
                            return `<div class="flex items-center line-clamp-1">${escape($i18n.t("Plain text (.txt)"))}</div>`;
                          }
                        }
                      )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                        $$result,
                        {
                          class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full"
                        },
                        {},
                        {
                          default: () => {
                            return `<div class="flex items-center line-clamp-1">${escape($i18n.t("PDF document (.pdf)"))}</div>`;
                          }
                        }
                      )}`;
                    }
                  }
                )}`;
              }
            })} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
              $$result,
              {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                id: "chat-copy-button"
              },
              {},
              {
                default: () => {
                  return `${validate_component(Clipboard, "Clipboard").$$render($$result, { className: " size-4", strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Copy"))}</div>`;
                }
              }
            )} ${!$temporaryChatEnabled && chat?.id ? `<hr class="border-gray-50 dark:border-gray-800 my-1"> ${validate_component(Menu_sub, "DropdownMenu.Sub").$$render($$result, {}, {}, {
              default: () => {
                return `${validate_component(Menu_sub_trigger, "DropdownMenu.SubTrigger").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(Folder, "Folder").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Move"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_sub_content, "DropdownMenu.SubContent").$$render(
                  $$result,
                  {
                    class: "w-full rounded-2xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white border border-gray-100  dark:border-gray-800 shadow-lg max-h-52 overflow-y-auto scrollbar-hidden",
                    transition: flyAndScale,
                    sideOffset: 8
                  },
                  {},
                  {
                    default: () => {
                      return `${each($folders.sort((a, b) => b.updated_at - a.updated_at), (folder) => {
                        return `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                          $$result,
                          {
                            class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                          },
                          {},
                          {
                            default: () => {
                              return `${validate_component(Folder, "Folder").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape(folder?.name ?? "Folder")}</div> `;
                            }
                          }
                        )}`;
                      })}`;
                    }
                  }
                )}`;
              }
            })} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
              $$result,
              {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
              },
              {},
              {
                default: () => {
                  return `${validate_component(ArchiveBox, "ArchiveBox").$$render($$result, { className: "size-4", strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Archive"))}</div>`;
                }
              }
            )} <hr class="border-gray-50 dark:border-gray-800 my-1"> <div class="flex p-1">${validate_component(Tags_1, "Tags").$$render($$result, { chatId: chat.id }, {}, {})}</div>` : ``}`;
          }
        }
      )}</div>`;
    },
    default: () => {
      return `${slots.default ? slots.default({}) : ``}`;
    }
  })}`;
});
const ChatBubbleDotted = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="2.5 3.5"></path></svg>`;
});
const ChatBubbleDottedChecked = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M8 12L11 15L16 10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="2.5 3.5"></path></svg>`;
});
const ChatPlus = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M9 12H12M15 12H12M12 12V9M12 12V15" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const ChatCheck = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M8 12L11 15L16 10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const Navbar = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $chatId, $$unsubscribe_chatId;
  let $mobile, $$unsubscribe_mobile;
  let $showSidebar, $$unsubscribe_showSidebar;
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  let $$unsubscribe_settings;
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  let $$unsubscribe_showControls;
  let $banners, $$unsubscribe_banners;
  let $config, $$unsubscribe_config;
  $$unsubscribe_chatId = subscribe(chatId, (value) => $chatId = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_settings = subscribe(settings, (value) => value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  $$unsubscribe_showControls = subscribe(showControls, (value) => value);
  $$unsubscribe_banners = subscribe(banners, (value) => $banners = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { initNewChat } = $$props;
  let { shareEnabled = false } = $$props;
  let { chat } = $$props;
  let { history } = $$props;
  let { selectedModels } = $$props;
  let { showModelSelector = true } = $$props;
  let { onSaveTempChat } = $$props;
  let { archiveChatHandler } = $$props;
  let { moveChatHandler } = $$props;
  let closedBannerIds = [];
  let showShareChatModal = false;
  if ($$props.initNewChat === void 0 && $$bindings.initNewChat && initNewChat !== void 0) $$bindings.initNewChat(initNewChat);
  if ($$props.shareEnabled === void 0 && $$bindings.shareEnabled && shareEnabled !== void 0) $$bindings.shareEnabled(shareEnabled);
  if ($$props.chat === void 0 && $$bindings.chat && chat !== void 0) $$bindings.chat(chat);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.showModelSelector === void 0 && $$bindings.showModelSelector && showModelSelector !== void 0) $$bindings.showModelSelector(showModelSelector);
  if ($$props.onSaveTempChat === void 0 && $$bindings.onSaveTempChat && onSaveTempChat !== void 0) $$bindings.onSaveTempChat(onSaveTempChat);
  if ($$props.archiveChatHandler === void 0 && $$bindings.archiveChatHandler && archiveChatHandler !== void 0) $$bindings.archiveChatHandler(archiveChatHandler);
  if ($$props.moveChatHandler === void 0 && $$bindings.moveChatHandler && moveChatHandler !== void 0) $$bindings.moveChatHandler(moveChatHandler);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(ShareChatModal, "ShareChatModal").$$render(
      $$result,
      {
        chatId: $chatId,
        show: showShareChatModal
      },
      {
        show: ($$value) => {
          showShareChatModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} <button id="new-chat-button" class="hidden" aria-label="New Chat"></button> <nav class="sticky top-0 z-30 w-full py-1 -mb-8 flex flex-col items-center drag-region"><div class="flex items-center w-full pl-1.5 pr-1"><div class="bg-linear-to-b via-40% to-97% from-white via-white to-transparent dark:from-gray-900 dark:via-gray-900 dark:to-transparent pointer-events-none absolute inset-0 -bottom-7 z-[-1]"></div> <div class="flex max-w-full w-full mx-auto px-1.5 md:px-2 pt-0.5 bg-transparent"><div class="flex items-center w-full max-w-full">${$mobile && !$showSidebar ? `<div class="-translate-x-0.5 mr-1 mt-1 self-start flex flex-none items-center text-gray-600 dark:text-gray-400">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar")
      },
      {},
      {
        default: () => {
          return `<button class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition"><div class="self-center p-1.5">${validate_component(Sidebar, "Sidebar").$$render($$result, {}, {}, {})}</div></button>`;
        }
      }
    )}</div>` : ``} <div class="${"flex-1 overflow-hidden max-w-full py-0.5 " + escape($showSidebar ? "ml-1" : "", true)}">${showModelSelector ? `${validate_component(ModelSelector, "ModelSelector").$$render(
      $$result,
      {
        showSetDefault: !shareEnabled,
        selectedModels
      },
      {
        selectedModels: ($$value) => {
          selectedModels = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : ``}</div> <div class="self-start flex flex-none items-center text-gray-600 dark:text-gray-400"> ${($user?.role === "user" ? ($user?.permissions?.chat?.temporary ?? true) && !($user?.permissions?.chat?.temporary_enforced ?? false) : true) ? `${!chat?.id ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t(`Temporary Chat`) }, {}, {
      default: () => {
        return `<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" id="temporary-chat-button"><div class="m-auto self-center">${$temporaryChatEnabled ? `${validate_component(ChatBubbleDottedChecked, "ChatBubbleDottedChecked").$$render(
          $$result,
          {
            className: " size-4.5",
            strokeWidth: "1.5"
          },
          {},
          {}
        )}` : `${validate_component(ChatBubbleDotted, "ChatBubbleDotted").$$render(
          $$result,
          {
            className: " size-4.5",
            strokeWidth: "1.5"
          },
          {},
          {}
        )}`}</div></button>`;
      }
    })}` : `${$temporaryChatEnabled ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t(`Save Chat`) }, {}, {
      default: () => {
        return `<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" id="save-temporary-chat-button"><div class="m-auto self-center">${validate_component(ChatCheck, "ChatCheck").$$render(
          $$result,
          {
            className: " size-4.5",
            strokeWidth: "1.5"
          },
          {},
          {}
        )}</div></button>`;
      }
    })}` : ``}`}` : ``} ${$mobile && !$temporaryChatEnabled && chat && chat.id ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("New Chat") }, {}, {
      default: () => {
        return `<button class="${"flex " + escape($showSidebar ? "md:hidden" : "", true) + " cursor-pointer px-2 py-2 rounded-xl text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-gray-850 transition"}" aria-label="New Chat"><div class="m-auto self-center">${validate_component(ChatPlus, "ChatPlus").$$render(
          $$result,
          {
            className: " size-4.5",
            strokeWidth: "1.5"
          },
          {},
          {}
        )}</div></button>`;
      }
    })}` : ``} ${shareEnabled && chat && (chat.id || $temporaryChatEnabled) ? `${validate_component(Menu, "Menu").$$render(
      $$result,
      {
        chat,
        shareEnabled,
        shareHandler: () => {
          showShareChatModal = !showShareChatModal;
        },
        archiveChatHandler: () => {
          archiveChatHandler(chat.id);
        },
        moveChatHandler
      },
      {},
      {
        default: () => {
          return `<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" id="chat-context-menu-button"><div class="m-auto self-center">${validate_component(EllipsisHorizontal, "EllipsisHorizontal").$$render($$result, { className: " size-5", strokeWidth: "1.5" }, {}, {})}</div></button>`;
        }
      }
    )}` : ``} ${$user?.role === "admin" || ($user?.permissions.chat?.controls ?? true) ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Controls") }, {}, {
      default: () => {
        return `<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" aria-label="Controls"><div class="m-auto self-center">${validate_component(Knobs, "Knobs").$$render($$result, { className: " size-5", strokeWidth: "1" }, {}, {})}</div></button>`;
      }
    })}` : ``} ${$user !== void 0 && $user !== null ? `${validate_component(UserMenu, "UserMenu").$$render(
      $$result,
      {
        className: "max-w-[240px]",
        role: $user?.role,
        help: true
      },
      {},
      {
        default: () => {
          return `<div class="select-none flex rounded-xl p-1.5 w-full hover:bg-gray-50 dark:hover:bg-gray-850 transition"><div class="self-center"><span class="sr-only">${escape($i18n.t("User menu"))}</span> <img${add_attribute("src", $user?.profile_image_url, 0)} class="size-6 object-cover rounded-full" alt="" draggable="false"></div></div>`;
        }
      }
    )}` : ``}</div></div></div></div> ${$temporaryChatEnabled && ($chatId ?? "").startsWith("local:") ? `<div class="w-full z-30 text-center"><div class="text-xs text-gray-500">${escape($i18n.t("Temporary Chat"))}</div></div>` : ``} <div class="absolute top-[100%] left-0 right-0 h-fit">${!history.currentId && !$chatId && ($banners.length > 0 || ($config?.license_metadata?.type ?? null) === "trial" || ($config?.license_metadata?.seats ?? null) !== null && $config?.user_count > $config?.license_metadata?.seats) ? `<div class="w-full z-30"><div class="flex flex-col gap-1 w-full">${($config?.license_metadata?.type ?? null) === "trial" ? `${validate_component(Banner, "Banner").$$render(
      $$result,
      {
        banner: {
          type: "info",
          title: "Trial License",
          content: $i18n.t("You are currently using a trial license. Please contact support to upgrade your license.")
        }
      },
      {},
      {}
    )}` : ``} ${($config?.license_metadata?.seats ?? null) !== null && $config?.user_count > $config?.license_metadata?.seats ? `${validate_component(Banner, "Banner").$$render(
      $$result,
      {
        banner: {
          type: "error",
          title: "License Error",
          content: $i18n.t("Exceeded the number of seats in your license. Please contact support to increase the number of seats.")
        }
      },
      {},
      {}
    )}` : ``} ${each(
      $banners.filter((b) => ![
        ...JSON.parse(localStorage.getItem("dismissedBannerIds") ?? "[]"),
        ...closedBannerIds
      ].includes(b.id)),
      (banner) => {
        return `${validate_component(Banner, "Banner").$$render($$result, { banner }, {}, {})}`;
      }
    )}</div></div>` : ``}</div></nav>`;
  } while (!$$settled);
  $$unsubscribe_chatId();
  $$unsubscribe_mobile();
  $$unsubscribe_showSidebar();
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  $$unsubscribe_settings();
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe_showControls();
  $$unsubscribe_banners();
  $$unsubscribe_config();
  return $$rendered;
});
const Valves_1 = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $tools, $$unsubscribe_tools;
  let $functions, $$unsubscribe_functions;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_tools = subscribe(tools, (value) => $tools = value);
  $$unsubscribe_functions = subscribe(functions, (value) => $functions = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let selectedId = "";
  let loading = false;
  let valvesSpec = null;
  let valves = {};
  const getUserValves = async () => {
    loading = true;
    {
      valves = await getUserValvesById(localStorage.token, selectedId);
      valvesSpec = await getUserValvesSpecById(localStorage.token, selectedId);
    }
    if (valvesSpec) {
      for (const property in valvesSpec.properties) {
        if (valvesSpec.properties[property]?.type === "array") {
          valves[property] = (valves[property] ?? []).join(",");
        }
      }
    }
    loading = false;
  };
  const init = async () => {
    loading = true;
    if ($functions === null) {
      functions.set(await getFunctions(localStorage.token));
    }
    if ($tools === null) {
      tools.set(await getTools(localStorage.token));
    }
    loading = false;
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      {
        selectedId = "";
      }
    }
    {
      if (selectedId) {
        getUserValves();
      }
    }
    {
      if (show) {
        init();
      }
    }
    $$rendered = `${show && !loading ? `<form class="flex flex-col h-full justify-between space-y-3 text-sm"><div class="flex flex-col"><div class="space-y-1"><div class="flex gap-2"><div class="flex-1"><select class="w-full rounded-sm text-xs py-2 px-1 bg-transparent outline-hidden"${add_attribute("placeholder", $i18n.t("Select"), 0)}><option value="tools" class="bg-gray-100 dark:bg-gray-800">${escape($i18n.t("Tools"))}</option><option value="functions" class="bg-gray-100 dark:bg-gray-800">${escape($i18n.t("Functions"))}</option></select></div> <div class="flex-1"><select class="w-full rounded-sm py-2 px-1 text-xs bg-transparent outline-hidden">${`<option value="" selected disabled class="bg-gray-100 dark:bg-gray-800">${escape($i18n.t("Select a tool"))}</option> ${each($tools.filter((tool) => !tool?.id?.startsWith("server:")), (tool, toolIdx) => {
      return `<option${add_attribute("value", tool.id, 0)} class="bg-gray-100 dark:bg-gray-800">${escape(tool.name)}</option>`;
    })}`}</select></div></div></div> ${selectedId ? `<hr class="border-gray-50 dark:border-gray-800 my-1 w-full"> <div class="my-2 text-xs">${!loading ? `${validate_component(Valves, "Valves").$$render(
      $$result,
      { valvesSpec, valves },
      {
        valves: ($$value) => {
          valves = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : `${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}`}</div>` : ``}</div></form>` : `${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-4" }, {}, {})}`}`;
  } while (!$$settled);
  $$unsubscribe_tools();
  $$unsubscribe_functions();
  $$unsubscribe_i18n();
  return $$rendered;
});
const Controls = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  let $settings, $$unsubscribe_settings;
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { models: models2 = [] } = $$props;
  let { chatFiles = [] } = $$props;
  let { params = {} } = $$props;
  let showValves = false;
  if ($$props.models === void 0 && $$bindings.models && models2 !== void 0) $$bindings.models(models2);
  if ($$props.chatFiles === void 0 && $$bindings.chatFiles && chatFiles !== void 0) $$bindings.chatFiles(chatFiles);
  if ($$props.params === void 0 && $$bindings.params && params !== void 0) $$bindings.params(params);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `<div class="dark:text-white"><div class="flex items-center justify-between dark:text-gray-100 mb-2"><div class="text-lg font-medium self-center font-primary">${escape($i18n.t("Chat Controls"))}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-3.5" }, {}, {})}</button></div> ${$user?.role === "admin" || ($user?.permissions.chat?.controls ?? true) ? `<div class="dark:text-gray-200 text-sm font-primary py-0.5 px-0.5">${chatFiles.length > 0 ? `${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        title: $i18n.t("Files"),
        open: true,
        buttonClassName: "w-full"
      },
      {},
      {
        content: () => {
          return `<div class="flex flex-col gap-1 mt-1.5" slot="content">${each(chatFiles, (file, fileIdx) => {
            return `${validate_component(FileItem, "FileItem").$$render(
              $$result,
              {
                className: "w-full",
                item: file,
                edit: true,
                url: file?.url ? file.url : null,
                name: file.name,
                type: file.type,
                size: file?.size,
                dismissible: true,
                small: true
              },
              {},
              {}
            )}`;
          })}</div>`;
        }
      }
    )} <hr class="my-2 border-gray-50 dark:border-gray-700/10">` : ``} ${$user?.role === "admin" || ($user?.permissions.chat?.valves ?? true) ? `${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        title: $i18n.t("Valves"),
        buttonClassName: "w-full",
        open: showValves
      },
      {
        open: ($$value) => {
          showValves = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div class="text-sm" slot="content">${validate_component(Valves_1, "Valves").$$render($$result, { show: showValves }, {}, {})}</div>`;
        }
      }
    )} <hr class="my-2 border-gray-50 dark:border-gray-700/10">` : ``} ${$user?.role === "admin" || ($user?.permissions.chat?.system_prompt ?? true) ? `${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        title: $i18n.t("System Prompt"),
        open: true,
        buttonClassName: "w-full"
      },
      {},
      {
        content: () => {
          return `<div class="" slot="content"><textarea class="${"w-full text-xs outline-hidden resize-vertical " + escape(
            $settings.highContrastMode ? "border-2 border-gray-300 dark:border-gray-700 rounded-lg bg-gray-50 dark:bg-gray-800 p-2.5" : "py-1.5 bg-transparent",
            true
          )}" rows="4"${add_attribute("placeholder", $i18n.t("Enter system prompt"), 0)}>${escape(params.system || "")}</textarea></div>`;
        }
      }
    )} <hr class="my-2 border-gray-50 dark:border-gray-700/10">` : ``} ${$user?.role === "admin" || ($user?.permissions.chat?.params ?? true) ? `${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        title: $i18n.t("Advanced Params"),
        open: true,
        buttonClassName: "w-full"
      },
      {},
      {
        content: () => {
          return `<div class="text-sm mt-1.5" slot="content"><div>${validate_component(AdvancedParams, "AdvancedParams").$$render(
            $$result,
            {
              admin: $user?.role === "admin",
              custom: true,
              params
            },
            {
              params: ($$value) => {
                params = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div></div>`;
        }
      }
    )}` : ``}</div>` : ``}</div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  $$unsubscribe_settings();
  return $$rendered;
});
const VideoInputMenu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  createEventDispatcher();
  let { onClose = () => {
  } } = $$props;
  let { devices } = $$props;
  let show = false;
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  if ($$props.devices === void 0 && $$bindings.devices && devices !== void 0) $$bindings.devices(devices);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Dropdown, "Dropdown").$$render(
      $$result,
      { show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div slot="content">${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full max-w-[180px] rounded-lg p-1 border border-gray-100  dark:border-gray-800 z-9999 bg-white dark:bg-gray-900 dark:text-white shadow-xs",
              sideOffset: 6,
              side: "top",
              align: "start",
              transition: flyAndScale
            },
            {},
            {
              default: () => {
                return `${each(devices, (device) => {
                  return `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                    $$result,
                    {
                      class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-md"
                    },
                    {},
                    {
                      default: () => {
                        return `<div class="flex items-center"><div class="line-clamp-1">${escape(device?.label ?? "Camera")} </div></div> `;
                      }
                    }
                  )}`;
                })}`;
              }
            }
          )}</div>`;
        },
        default: () => {
          return `${slots.default ? slots.default({}) : ``}`;
        }
      }
    )}`;
  } while (!$$settled);
  return $$rendered;
});
const CallOverlay = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_models;
  let $config, $$unsubscribe_config;
  let $settings, $$unsubscribe_settings;
  let $TTSWorker, $$unsubscribe_TTSWorker;
  let $showCallOverlay, $$unsubscribe_showCallOverlay;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_models = subscribe(models, (value) => value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_TTSWorker = subscribe(TTSWorker, (value) => $TTSWorker = value);
  $$unsubscribe_showCallOverlay = subscribe(showCallOverlay, (value) => $showCallOverlay = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { eventTarget } = $$props;
  let { submitPrompt } = $$props;
  let { stopResponse } = $$props;
  let { files } = $$props;
  let { chatId: chatId2 } = $$props;
  let { modelId } = $$props;
  let loading = false;
  let confirmed = false;
  let assistantSpeaking = false;
  let emoji = null;
  let camera = false;
  let cameraStream = null;
  let chatStreaming = false;
  let rmsLevel = 0;
  let hasStartedSpeaking = false;
  let mediaRecorder;
  let audioStream = null;
  let audioChunks = [];
  let videoInputDevices = [];
  const stopVideoStream = async () => {
    if (cameraStream) {
      const tracks = cameraStream.getTracks();
      tracks.forEach((track) => track.stop());
    }
    cameraStream = null;
  };
  const takeScreenshot = () => {
    const video = document.getElementById("camera-feed");
    const canvas = document.getElementById("camera-canvas");
    if (!canvas) {
      return;
    }
    const context = canvas.getContext("2d");
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    context.drawImage(video, 0, 0, video.videoWidth, video.videoHeight);
    const dataURL = canvas.toDataURL("image/png");
    /* @__PURE__ */ console.log(dataURL);
    return dataURL;
  };
  const stopCamera = async () => {
    await stopVideoStream();
    camera = false;
  };
  const MIN_DECIBELS = -55;
  const transcribeHandler = async (audioBlob) => {
    await tick();
    const file = blobToFile(audioBlob, "recording.wav");
    const res = await transcribeAudio(localStorage.token, file, $settings?.audio?.stt?.language).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    if (res) {
      /* @__PURE__ */ console.log(res.text);
      if (res.text !== "") {
        const _responses = await submitPrompt(res.text, { _raw: true });
        /* @__PURE__ */ console.log(_responses);
      }
    }
  };
  const stopRecordingCallback = async (_continue = true) => {
    if ($showCallOverlay) {
      /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", "🚨 stopRecordingCallback 🚨");
      const _audioChunks = audioChunks.slice(0);
      audioChunks = [];
      mediaRecorder = false;
      if (_continue) {
        startRecording();
      }
      if (confirmed) {
        loading = true;
        emoji = null;
        if (cameraStream) {
          const imageUrl = takeScreenshot();
          files = [{ type: "image", url: imageUrl }];
        }
        const audioBlob = new Blob(_audioChunks, { type: "audio/wav" });
        await transcribeHandler(audioBlob);
        confirmed = false;
        loading = false;
      }
    } else {
      audioChunks = [];
      mediaRecorder = false;
      if (audioStream) {
        const tracks = audioStream.getTracks();
        tracks.forEach((track) => track.stop());
      }
      audioStream = null;
    }
  };
  const startRecording = async () => {
    if ($showCallOverlay) {
      if (!audioStream) {
        audioStream = await navigator.mediaDevices.getUserMedia({
          audio: {
            echoCancellation: true,
            noiseSuppression: true,
            autoGainControl: true
          }
        });
      }
      mediaRecorder = new MediaRecorder(audioStream);
      mediaRecorder.onstart = () => {
        /* @__PURE__ */ console.log("Recording started");
        audioChunks = [];
      };
      mediaRecorder.ondataavailable = (event) => {
        if (hasStartedSpeaking) {
          audioChunks.push(event.data);
        }
      };
      mediaRecorder.onstop = (e) => {
        /* @__PURE__ */ console.log("Recording stopped", audioStream, e);
        stopRecordingCallback();
      };
      analyseAudio(audioStream);
    }
  };
  const stopAudioStream = async () => {
    try {
      if (mediaRecorder) {
        mediaRecorder.stop();
      }
    } catch (error) {
      /* @__PURE__ */ console.log("Error stopping audio stream:", error);
    }
    if (!audioStream) return;
    audioStream.getAudioTracks().forEach(function(track) {
      track.stop();
    });
    audioStream = null;
  };
  const calculateRMS = (data) => {
    let sumSquares = 0;
    for (let i = 0; i < data.length; i++) {
      const normalizedValue = (data[i] - 128) / 128;
      sumSquares += normalizedValue * normalizedValue;
    }
    return Math.sqrt(sumSquares / data.length);
  };
  const analyseAudio = (stream) => {
    const audioContext = new AudioContext();
    const audioStreamSource = audioContext.createMediaStreamSource(stream);
    const analyser = audioContext.createAnalyser();
    analyser.minDecibels = MIN_DECIBELS;
    audioStreamSource.connect(analyser);
    const bufferLength = analyser.frequencyBinCount;
    const domainData = new Uint8Array(bufferLength);
    const timeDomainData = new Uint8Array(analyser.fftSize);
    let lastSoundTime = Date.now();
    hasStartedSpeaking = false;
    /* @__PURE__ */ console.log("🔊 Sound detection started", lastSoundTime, hasStartedSpeaking);
    const detectSound = () => {
      const processFrame = () => {
        if (!mediaRecorder || !$showCallOverlay) {
          return;
        }
        if (assistantSpeaking && !($settings?.voiceInterruption ?? false)) {
          analyser.maxDecibels = 0;
          analyser.minDecibels = -1;
        } else {
          analyser.minDecibels = MIN_DECIBELS;
          analyser.maxDecibels = -30;
        }
        analyser.getByteTimeDomainData(timeDomainData);
        analyser.getByteFrequencyData(domainData);
        rmsLevel = calculateRMS(timeDomainData);
        const hasSound = domainData.some((value) => value > 0);
        if (hasSound) {
          /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", "🔊 Sound detected");
          if (mediaRecorder && mediaRecorder.state !== "recording") {
            mediaRecorder.start();
          }
          if (!hasStartedSpeaking) {
            hasStartedSpeaking = true;
            stopAllAudio();
          }
          lastSoundTime = Date.now();
        }
        if (hasStartedSpeaking) {
          if (Date.now() - lastSoundTime > 2e3) {
            confirmed = true;
            if (mediaRecorder) {
              /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", "🔇 Silence detected");
              mediaRecorder.stop();
              return;
            }
          }
        }
        window.requestAnimationFrame(processFrame);
      };
      window.requestAnimationFrame(processFrame);
    };
    detectSound();
  };
  let finishedMessages = {};
  let currentMessageId = null;
  let currentUtterance = null;
  const speakSpeechSynthesisHandler = (content) => {
    if ($showCallOverlay) {
      return new Promise((resolve) => {
        let voices = [];
        const getVoicesLoop = setInterval(
          async () => {
            voices = await speechSynthesis.getVoices();
            if (voices.length > 0) {
              clearInterval(getVoicesLoop);
              const voice = voices?.filter((v) => v.voiceURI === ($settings?.audio?.tts?.voice ?? $config?.audio?.tts?.voice))?.at(0) ?? void 0;
              currentUtterance = new SpeechSynthesisUtterance(content);
              currentUtterance.rate = $settings.audio?.tts?.playbackRate ?? 1;
              if (voice) {
                currentUtterance.voice = voice;
              }
              speechSynthesis.speak(currentUtterance);
              currentUtterance.onend = async (e) => {
                await new Promise((r) => setTimeout(r, 200));
                resolve(e);
              };
            }
          },
          100
        );
      });
    } else {
      return Promise.resolve();
    }
  };
  const playAudio = (audio) => {
    if ($showCallOverlay) {
      return new Promise((resolve) => {
        const audioElement = document.getElementById("audioElement");
        if (audioElement) {
          audioElement.src = audio.src;
          audioElement.muted = true;
          audioElement.playbackRate = $settings.audio?.tts?.playbackRate ?? 1;
          audioElement.play().then(() => {
            audioElement.muted = false;
          }).catch((error) => {
            /* @__PURE__ */ console.error(error);
          });
          audioElement.onended = async (e) => {
            await new Promise((r) => setTimeout(r, 100));
            resolve(e);
          };
        }
      });
    } else {
      return Promise.resolve();
    }
  };
  const stopAllAudio = async () => {
    assistantSpeaking = false;
    if (chatStreaming) {
      stopResponse();
    }
    if (currentUtterance) {
      speechSynthesis.cancel();
      currentUtterance = null;
    }
    const audioElement = document.getElementById("audioElement");
    if (audioElement) {
      audioElement.muted = true;
      audioElement.pause();
      audioElement.currentTime = 0;
    }
  };
  let audioAbortController = new AbortController();
  const audioCache = /* @__PURE__ */ new Map();
  const emojiCache = /* @__PURE__ */ new Map();
  const fetchAudio = async (content) => {
    if (!audioCache.has(content)) {
      try {
        if ($settings?.showEmojiInCall ?? false) {
          const emoji2 = await generateEmoji(localStorage.token, modelId, content, chatId2);
          if (emoji2) {
            emojiCache.set(content, emoji2);
          }
        }
        if ($settings.audio?.tts?.engine === "browser-kokoro") {
          const blob = await $TTSWorker.generate({
            text: content,
            voice: $settings?.audio?.tts?.voice ?? $config?.audio?.tts?.voice
          }).catch((error) => {
            /* @__PURE__ */ console.error(error);
            toast.error(`${error}`);
          });
          if (blob) {
            audioCache.set(content, new Audio(blob));
          }
        } else if ($config.audio.tts.engine !== "") {
          const res = await synthesizeOpenAISpeech(
            localStorage.token,
            $settings?.audio?.tts?.defaultVoice === $config.audio.tts.voice ? $settings?.audio?.tts?.voice ?? $config?.audio?.tts?.voice : $config?.audio?.tts?.voice,
            content
          ).catch((error) => {
            /* @__PURE__ */ console.error(error);
            return null;
          });
          if (res) {
            const blob = await res.blob();
            const blobUrl = URL.createObjectURL(blob);
            audioCache.set(content, new Audio(blobUrl));
          }
        } else {
          audioCache.set(content, true);
        }
      } catch (error) {
        /* @__PURE__ */ console.error("Error synthesizing speech:", error);
      }
    }
    return audioCache.get(content);
  };
  let messages = {};
  const monitorAndPlayAudio = async (id, signal) => {
    while (!signal.aborted) {
      if (messages[id] && messages[id].length > 0) {
        const content = messages[id].shift();
        if (audioCache.has(content)) {
          if (($settings?.showEmojiInCall ?? false) && emojiCache.has(content)) {
            emoji = emojiCache.get(content);
          } else {
            emoji = null;
          }
          if ($config.audio.tts.engine !== "") {
            try {
              /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", `Playing audio for content: ${content}`);
              const audio = audioCache.get(content);
              await playAudio(audio);
              /* @__PURE__ */ console.log(`Played audio for content: ${content}`);
              await new Promise((resolve) => setTimeout(resolve, 200));
            } catch (error) {
              /* @__PURE__ */ console.error("Error playing audio:", error);
            }
          } else {
            await speakSpeechSynthesisHandler(content);
          }
        } else {
          messages[id].unshift(content);
          /* @__PURE__ */ console.log(`Audio for "${content}" not yet available in the cache, re-queued...`);
          await new Promise((resolve) => setTimeout(resolve, 200));
        }
      } else if (finishedMessages[id] && messages[id] && messages[id].length === 0) {
        assistantSpeaking = false;
        break;
      } else {
        await new Promise((resolve) => setTimeout(resolve, 200));
      }
    }
    /* @__PURE__ */ console.log(`Audio monitoring and playing stopped for message ID ${id}`);
  };
  const chatStartHandler = async (e) => {
    const { id } = e.detail;
    chatStreaming = true;
    if (currentMessageId !== id) {
      /* @__PURE__ */ console.log(`Received chat start event for message ID ${id}`);
      currentMessageId = id;
      if (audioAbortController) {
        audioAbortController.abort();
      }
      audioAbortController = new AbortController();
      assistantSpeaking = true;
      monitorAndPlayAudio(id, audioAbortController.signal);
    }
  };
  const chatEventHandler = async (e) => {
    const { id, content } = e.detail;
    if (currentMessageId === id) {
      /* @__PURE__ */ console.log(`Received chat event for message ID ${id}: ${content}`);
      try {
        if (messages[id] === void 0) {
          messages[id] = [content];
        } else {
          messages[id].push(content);
        }
        /* @__PURE__ */ console.log(content);
        fetchAudio(content);
      } catch (error) {
        /* @__PURE__ */ console.error("Failed to fetch or play audio:", error);
      }
    }
  };
  const chatFinishHandler = async (e) => {
    const { id, content } = e.detail;
    finishedMessages[id] = true;
    chatStreaming = false;
  };
  onDestroy(async () => {
    await stopAllAudio();
    await stopRecordingCallback(false);
    await stopCamera();
    await stopAudioStream();
    eventTarget.removeEventListener("chat:start", chatStartHandler);
    eventTarget.removeEventListener("chat", chatEventHandler);
    eventTarget.removeEventListener("chat:finish", chatFinishHandler);
    audioAbortController.abort();
    await tick();
    await stopAllAudio();
  });
  if ($$props.eventTarget === void 0 && $$bindings.eventTarget && eventTarget !== void 0) $$bindings.eventTarget(eventTarget);
  if ($$props.submitPrompt === void 0 && $$bindings.submitPrompt && submitPrompt !== void 0) $$bindings.submitPrompt(submitPrompt);
  if ($$props.stopResponse === void 0 && $$bindings.stopResponse && stopResponse !== void 0) $$bindings.stopResponse(stopResponse);
  if ($$props.files === void 0 && $$bindings.files && files !== void 0) $$bindings.files(files);
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  if ($$props.modelId === void 0 && $$bindings.modelId && modelId !== void 0) $$bindings.modelId(modelId);
  $$unsubscribe_models();
  $$unsubscribe_config();
  $$unsubscribe_settings();
  $$unsubscribe_TTSWorker();
  $$unsubscribe_showCallOverlay();
  $$unsubscribe_i18n();
  return `${$showCallOverlay ? `<div class="max-w-lg w-full h-full max-h-[100dvh] flex flex-col justify-between p-3 md:p-6">${camera ? `<button type="button" class="flex justify-center items-center w-full h-20 min-h-20">${emoji ? `<div class="transition-all rounded-full" style="${"font-size:" + escape(
    rmsLevel * 100 > 4 ? "4.5" : rmsLevel * 100 > 2 ? "4.25" : rmsLevel * 100 > 1 ? "3.75" : "3.5",
    true
  ) + "rem;width: 100%; text-align:center;"}">${escape(emoji)}</div>` : `${loading || assistantSpeaking ? `<svg class="size-12 text-gray-900 dark:text-gray-400" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><style>.spinner_qM83 {
								animation: spinner_8HQG 1.05s infinite;
							}
							.spinner_oXPr {
								animation-delay: 0.1s;
							}
							.spinner_ZTLf {
								animation-delay: 0.2s;
							}
							@keyframes spinner_8HQG {
								0%,
								57.14% {
									animation-timing-function: cubic-bezier(0.33, 0.66, 0.66, 1);
									transform: translate(0);
								}
								28.57% {
									animation-timing-function: cubic-bezier(0.33, 0, 0.66, 0.33);
									transform: translateY(-6px);
								}
								100% {
									transform: translate(0);
								}
							}
						</style><circle class="spinner_qM83" cx="4" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_oXPr" cx="12" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_ZTLf" cx="20" cy="12" r="3"></circle></svg>` : `<div class="${"" + escape(
    rmsLevel * 100 > 4 ? " size-[4.5rem]" : rmsLevel * 100 > 2 ? " size-16" : rmsLevel * 100 > 1 ? "size-14" : "size-12",
    true
  ) + " transition-all rounded-full " + escape(
    "bg-black dark:bg-white",
    true
  ) + " bg-black dark:bg-white"}"${add_attribute(
    "style",
    "",
    0
  )}></div>`}`} </button>` : ``} <div class="flex justify-center items-center flex-1 h-full w-full max-h-full">${!camera ? `<button type="button">${emoji ? `<div class="transition-all rounded-full" style="${"font-size:" + escape(
    rmsLevel * 100 > 4 ? "13" : rmsLevel * 100 > 2 ? "12" : rmsLevel * 100 > 1 ? "11.5" : "11",
    true
  ) + "rem;width:100%;text-align:center;"}">${escape(emoji)}</div>` : `${loading || assistantSpeaking ? `<svg class="size-44 text-gray-900 dark:text-gray-400" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><style>.spinner_qM83 {
									animation: spinner_8HQG 1.05s infinite;
								}
								.spinner_oXPr {
									animation-delay: 0.1s;
								}
								.spinner_ZTLf {
									animation-delay: 0.2s;
								}
								@keyframes spinner_8HQG {
									0%,
									57.14% {
										animation-timing-function: cubic-bezier(0.33, 0.66, 0.66, 1);
										transform: translate(0);
									}
									28.57% {
										animation-timing-function: cubic-bezier(0.33, 0, 0.66, 0.33);
										transform: translateY(-6px);
									}
									100% {
										transform: translate(0);
									}
								}
							</style><circle class="spinner_qM83" cx="4" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_oXPr" cx="12" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_ZTLf" cx="20" cy="12" r="3"></circle></svg>` : `<div class="${"" + escape(
    rmsLevel * 100 > 4 ? " size-52" : rmsLevel * 100 > 2 ? "size-48" : rmsLevel * 100 > 1 ? "size-44" : "size-40",
    true
  ) + " transition-all rounded-full " + escape(
    "bg-black dark:bg-white",
    true
  )}"${add_attribute(
    "style",
    "",
    0
  )}></div>`}`}</button>` : `<div class="relative flex video-container w-full max-h-full pt-2 pb-4 md:py-6 px-2 h-full"> <video id="camera-feed" autoplay class="rounded-2xl h-full min-w-full object-cover object-center" playsinline></video> <canvas id="camera-canvas" style="display:none;"></canvas> <div class="absolute top-4 md:top-8 left-4"><button type="button" class="p-1.5 text-white cursor-pointer backdrop-blur-xl bg-black/10 rounded-full" data-svelte-h="svelte-16ul42n"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-6"><path d="M5.28 4.22a.75.75 0 0 0-1.06 1.06L6.94 8l-2.72 2.72a.75.75 0 1 0 1.06 1.06L8 9.06l2.72 2.72a.75.75 0 1 0 1.06-1.06L9.06 8l2.72-2.72a.75.75 0 0 0-1.06-1.06L8 6.94 5.28 4.22Z"></path></svg></button></div></div>`}</div> <div class="flex justify-between items-center pb-2 w-full"><div>${camera ? `${validate_component(VideoInputMenu, "VideoInputMenu").$$render($$result, { devices: videoInputDevices }, {}, {
    default: () => {
      return `<button class="p-3 rounded-full bg-gray-50 dark:bg-gray-900" type="button" data-svelte-h="svelte-5e0pue"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5"><path fill-rule="evenodd" d="M15.312 11.424a5.5 5.5 0 0 1-9.201 2.466l-.312-.311h2.433a.75.75 0 0 0 0-1.5H3.989a.75.75 0 0 0-.75.75v4.242a.75.75 0 0 0 1.5 0v-2.43l.31.31a7 7 0 0 0 11.712-3.138.75.75 0 0 0-1.449-.39Zm1.23-3.723a.75.75 0 0 0 .219-.53V2.929a.75.75 0 0 0-1.5 0V5.36l-.31-.31A7 7 0 0 0 3.239 8.188a.75.75 0 1 0 1.448.389A5.5 5.5 0 0 1 13.89 6.11l.311.31h-2.432a.75.75 0 0 0 0 1.5h4.243a.75.75 0 0 0 .53-.219Z" clip-rule="evenodd"></path></svg></button>`;
    }
  })}` : `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Camera") }, {}, {
    default: () => {
      return `<button class="p-3 rounded-full bg-gray-50 dark:bg-gray-900" type="button" data-svelte-h="svelte-1n1gs9g"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5"><path stroke-linecap="round" stroke-linejoin="round" d="M6.827 6.175A2.31 2.31 0 0 1 5.186 7.23c-.38.054-.757.112-1.134.175C2.999 7.58 2.25 8.507 2.25 9.574V18a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 18V9.574c0-1.067-.75-1.994-1.802-2.169a47.865 47.865 0 0 0-1.134-.175 2.31 2.31 0 0 1-1.64-1.055l-.822-1.316a2.192 2.192 0 0 0-1.736-1.039 48.774 48.774 0 0 0-5.232 0 2.192 2.192 0 0 0-1.736 1.039l-.821 1.316Z"></path><path stroke-linecap="round" stroke-linejoin="round" d="M16.5 12.75a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM18.75 10.5h.008v.008h-.008V10.5Z"></path></svg></button>`;
    }
  })}`}</div> <div><button type="button"><div class="line-clamp-1 text-sm font-medium">${loading ? `${escape($i18n.t("Thinking..."))}` : `${assistantSpeaking ? `${escape($i18n.t("Tap to interrupt"))}` : `${escape($i18n.t("Listening..."))}`}`}</div></button></div> <div><button class="p-3 rounded-full bg-gray-50 dark:bg-gray-900" type="button" data-svelte-h="svelte-1k5eavb"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5"><path d="M6.28 5.22a.75.75 0 0 0-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 1 0 1.06 1.06L10 11.06l3.72 3.72a.75.75 0 1 0 1.06-1.06L11.06 10l3.72-3.72a.75.75 0 0 0-1.06-1.06L10 8.94 6.28 5.22Z"></path></svg></button></div></div></div>` : ``}`;
});
const ArrowsPointingOut = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15"></path></svg>`;
});
const Artifacts = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_chatId;
  let $i18n, $$unsubscribe_i18n;
  let $settings, $$unsubscribe_settings;
  $$unsubscribe_chatId = subscribe(chatId, (value) => value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  createEventDispatcher();
  let { overlay = false } = $$props;
  let { history } = $$props;
  let messages = [];
  let contents = [];
  let selectedContentIdx = 0;
  let iframeElement;
  const getContents = () => {
    contents = [];
    messages.forEach((message) => {
      if (message?.role !== "user" && message?.content) {
        const codeBlockContents = message.content.match(/```[\s\S]*?```/g);
        let codeBlocks = [];
        let htmlContent = "";
        let cssContent = "";
        let jsContent = "";
        if (codeBlockContents) {
          codeBlockContents.forEach((block) => {
            const lang = block.split("\n")[0].replace("```", "").trim().toLowerCase();
            const code = block.replace(/```[\s\S]*?\n/, "").replace(/```$/, "");
            codeBlocks.push({ lang, code });
          });
          codeBlocks.forEach((block) => {
            const { lang, code } = block;
            if (lang === "html") {
              htmlContent += code + "\n";
            } else if (lang === "css") {
              cssContent += code + "\n";
            } else if (lang === "javascript" || lang === "js") {
              jsContent += code + "\n";
            }
          });
        } else {
          const inlineHtml = message.content.match(/<html>[\s\S]*?<\/html>/gi);
          const inlineCss = message.content.match(/<style>[\s\S]*?<\/style>/gi);
          const inlineJs = message.content.match(/<script>[\s\S]*?<\/script>/gi);
          if (inlineHtml) {
            inlineHtml.forEach((block) => {
              const content = block.replace(/<\/?html>/gi, "");
              htmlContent += content + "\n";
            });
          }
          if (inlineCss) {
            inlineCss.forEach((block) => {
              const content = block.replace(/<\/?style>/gi, "");
              cssContent += content + "\n";
            });
          }
          if (inlineJs) {
            inlineJs.forEach((block) => {
              const content = block.replace(/<\/?script>/gi, "");
              jsContent += content + "\n";
            });
          }
        }
        if (htmlContent || cssContent || jsContent) {
          const renderedContent = `
                        <!DOCTYPE html>
                        <html lang="en">
                        <head>
                            <meta charset="UTF-8">
                            <meta name="viewport" content="width=device-width, initial-scale=1.0">
							<${""}style>
								body {
									background-color: white; /* Ensure the iframe has a white background */
								}

								${cssContent}
							</${""}style>
                        </head>
                        <body>
                            ${htmlContent}

							<${""}script>
                            	${jsContent}
							</${""}script>
                        </body>
                        </html>
                    `;
          contents = [...contents, { type: "iframe", content: renderedContent }];
        } else {
          for (const block of codeBlocks) {
            if (block.lang === "svg" || block.lang === "xml" && block.code.includes("<svg")) {
              contents = [...contents, { type: "svg", content: block.code }];
            }
          }
        }
      }
    });
    if (contents.length === 0) {
      showControls.set(false);
      showArtifacts.set(false);
    }
    selectedContentIdx = contents ? contents.length - 1 : 0;
  };
  if ($$props.overlay === void 0 && $$bindings.overlay && overlay !== void 0) $$bindings.overlay(overlay);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  {
    if (history) {
      messages = createMessagesList(history, history.currentId);
      getContents();
    } else {
      messages = [];
      getContents();
    }
  }
  $$unsubscribe_chatId();
  $$unsubscribe_i18n();
  $$unsubscribe_settings();
  return `<div class="w-full h-full relative flex flex-col bg-white dark:bg-gray-850" id="artifacts-container"><div class="w-full h-full flex flex-col flex-1 relative">${contents.length > 0 ? `<div class="pointer-events-auto z-20 flex justify-between items-center p-2.5 font-primar text-gray-900 dark:text-white"><div class="flex-1 flex items-center justify-between pr-1"><div class="flex items-center space-x-2"><div class="flex items-center gap-0.5 self-center min-w-fit" dir="ltr"><button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition disabled:cursor-not-allowed" ${contents.length <= 1 ? "disabled" : ""}><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5"></path></svg></button> <div class="text-xs self-center dark:text-gray-100 min-w-fit">${escape($i18n.t("Version {{selectedVersion}} of {{totalVersions}}", {
    selectedVersion: selectedContentIdx + 1,
    totalVersions: contents.length
  }))}</div> <button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition disabled:cursor-not-allowed" ${contents.length <= 1 ? "disabled" : ""}><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5"></path></svg></button></div></div> <div class="flex items-center gap-1.5"><button class="copy-code-button bg-none border-none text-xs bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-md px-1.5 py-0.5">${escape($i18n.t("Copy"))}</button> ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Download") }, {}, {
    default: () => {
      return `<button class="bg-none border-none text-xs bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-md p-0.5">${validate_component(Download, "Download").$$render($$result, { className: "size-3.5" }, {}, {})}</button>`;
    }
  })} ${contents[selectedContentIdx].type === "iframe" ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Open in full screen") }, {}, {
    default: () => {
      return `<button class="bg-none border-none text-xs bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-md p-0.5">${validate_component(ArrowsPointingOut, "ArrowsPointingOut").$$render($$result, { className: "size-3.5" }, {}, {})}</button>`;
    }
  })}` : ``}</div></div> <button class="self-center pointer-events-auto p-1 rounded-full bg-white dark:bg-gray-850">${validate_component(XMark, "XMark").$$render(
    $$result,
    {
      className: "size-3.5 text-gray-900 dark:text-white"
    },
    {},
    {}
  )}</button></div>` : ``} ${overlay ? `<div class="absolute top-0 left-0 right-0 bottom-0 z-10"></div>` : ``} <div class="flex-1 w-full h-full"><div class="h-full flex flex-col">${contents.length > 0 ? `<div class="max-w-full w-full h-full">${contents[selectedContentIdx].type === "iframe" ? `<iframe title="Content"${add_attribute("srcdoc", contents[selectedContentIdx].content, 0)} class="w-full border-0 h-full rounded-none" sandbox="${"allow-scripts allow-downloads" + escape(
    $settings?.iframeSandboxAllowForms ?? false ? " allow-forms" : "",
    true
  ) + escape(
    $settings?.iframeSandboxAllowSameOrigin ?? false ? " allow-same-origin" : "",
    true
  )}"${add_attribute("this", iframeElement, 0)}></iframe>` : `${contents[selectedContentIdx].type === "svg" ? `${validate_component(SVGPanZoom, "SvgPanZoom").$$render(
    $$result,
    {
      className: " w-full h-full max-h-full overflow-hidden",
      svg: contents[selectedContentIdx].content
    },
    {},
    {}
  )}` : ``}`}</div>` : `<div class="m-auto font-medium text-xs text-gray-900 dark:text-white">${escape($i18n.t("No HTML, CSS, or JavaScript content found."))}</div>`}</div></div></div></div>`;
});
const Embeds = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $embed, $$unsubscribe_embed;
  $$unsubscribe_embed = subscribe(embed, (value) => $embed = value);
  let { overlay = false } = $$props;
  if ($$props.overlay === void 0 && $$bindings.overlay && overlay !== void 0) $$bindings.overlay(overlay);
  $$unsubscribe_embed();
  return `${$embed ? `<div class="h-full w-full"><div class="pointer-events-auto z-20 flex justify-between items-center py-3 px-2 font-primar text-gray-900 dark:text-white"><div class="flex-1 flex items-center justify-between pl-2"><a class="flex items-center space-x-2 hover:underline"${add_attribute("href", $embed?.url, 0)} target="_blank" rel="noopener noreferrer">${escape($embed?.title ?? "Embedded Content")}</a></div> <button class="self-center pointer-events-auto p-1 rounded-full bg-white dark:bg-gray-850">${validate_component(XMark, "XMark").$$render(
    $$result,
    {
      className: "size-3.5 text-gray-900 dark:text-white"
    },
    {},
    {}
  )}</button></div> <div class="w-full h-full relative">${overlay ? `<div class="absolute top-0 left-0 right-0 bottom-0 z-10"></div>` : ``} ${validate_component(FullHeightIframe, "FullHeightIframe").$$render(
    $$result,
    {
      src: $embed?.url,
      iframeClassName: "w-full h-full"
    },
    {},
    {}
  )}</div></div>` : ``}`;
});
const ChatControls = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $showCallOverlay, $$unsubscribe_showCallOverlay;
  let $showControls, $$unsubscribe_showControls;
  let $showOverview, $$unsubscribe_showOverview;
  let $showArtifacts, $$unsubscribe_showArtifacts;
  let $showEmbeds, $$unsubscribe_showEmbeds;
  $$unsubscribe_showCallOverlay = subscribe(showCallOverlay, (value) => $showCallOverlay = value);
  $$unsubscribe_showControls = subscribe(showControls, (value) => $showControls = value);
  $$unsubscribe_showOverview = subscribe(showOverview, (value) => $showOverview = value);
  $$unsubscribe_showArtifacts = subscribe(showArtifacts, (value) => $showArtifacts = value);
  $$unsubscribe_showEmbeds = subscribe(showEmbeds, (value) => $showEmbeds = value);
  let { history } = $$props;
  let { models: models2 = [] } = $$props;
  let { chatId: chatId2 = null } = $$props;
  let { chatFiles = [] } = $$props;
  let { params = {} } = $$props;
  let { eventTarget } = $$props;
  let { submitPrompt } = $$props;
  let { stopResponse } = $$props;
  let { showMessage } = $$props;
  let { files } = $$props;
  let { modelId } = $$props;
  let { pane } = $$props;
  let mediaQuery;
  let largeScreen = false;
  let dragged = false;
  let minSize = 0;
  const openPane = () => {
    if (parseInt(localStorage?.chatControlsSize)) {
      const container = document.getElementById("chat-container");
      let size = Math.floor(parseInt(localStorage?.chatControlsSize) / container.clientWidth * 100);
      pane.resize(size);
    } else {
      pane.resize(minSize);
    }
  };
  const handleMediaQuery = async (e) => {
    if (e.matches) {
      largeScreen = true;
      if ($showCallOverlay) {
        showCallOverlay.set(false);
        await tick();
        showCallOverlay.set(true);
      }
    } else {
      largeScreen = false;
      if ($showCallOverlay) {
        showCallOverlay.set(false);
        await tick();
        showCallOverlay.set(true);
      }
      pane = null;
    }
  };
  const onMouseDown = (event) => {
    dragged = true;
  };
  const onMouseUp = (event) => {
    dragged = false;
  };
  onDestroy(() => {
    showControls.set(false);
    mediaQuery.removeEventListener("change", handleMediaQuery);
    document.removeEventListener("mousedown", onMouseDown);
    document.removeEventListener("mouseup", onMouseUp);
  });
  const closeHandler = () => {
    showControls.set(false);
    showOverview.set(false);
    showArtifacts.set(false);
    showEmbeds.set(false);
    if ($showCallOverlay) {
      showCallOverlay.set(false);
    }
  };
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.models === void 0 && $$bindings.models && models2 !== void 0) $$bindings.models(models2);
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  if ($$props.chatFiles === void 0 && $$bindings.chatFiles && chatFiles !== void 0) $$bindings.chatFiles(chatFiles);
  if ($$props.params === void 0 && $$bindings.params && params !== void 0) $$bindings.params(params);
  if ($$props.eventTarget === void 0 && $$bindings.eventTarget && eventTarget !== void 0) $$bindings.eventTarget(eventTarget);
  if ($$props.submitPrompt === void 0 && $$bindings.submitPrompt && submitPrompt !== void 0) $$bindings.submitPrompt(submitPrompt);
  if ($$props.stopResponse === void 0 && $$bindings.stopResponse && stopResponse !== void 0) $$bindings.stopResponse(stopResponse);
  if ($$props.showMessage === void 0 && $$bindings.showMessage && showMessage !== void 0) $$bindings.showMessage(showMessage);
  if ($$props.files === void 0 && $$bindings.files && files !== void 0) $$bindings.files(files);
  if ($$props.modelId === void 0 && $$bindings.modelId && modelId !== void 0) $$bindings.modelId(modelId);
  if ($$props.pane === void 0 && $$bindings.pane && pane !== void 0) $$bindings.pane(pane);
  if ($$props.openPane === void 0 && $$bindings.openPane && openPane !== void 0) $$bindings.openPane(openPane);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (!chatId2) {
        closeHandler();
      }
    }
    $$rendered = `${!largeScreen ? `${$showControls ? `${validate_component(Drawer, "Drawer").$$render(
      $$result,
      {
        show: $showControls,
        onClose: () => {
          showControls.set(false);
        }
      },
      {},
      {
        default: () => {
          return `<div class="${"" + escape(
            $showCallOverlay || $showOverview || $showArtifacts || $showEmbeds ? " h-screen  w-full" : "px-4 py-3",
            true
          ) + " h-full"}">${$showCallOverlay ? `<div class="h-full max-h-[100dvh] bg-white text-gray-700 dark:bg-black dark:text-gray-300 flex justify-center">${validate_component(CallOverlay, "CallOverlay").$$render(
            $$result,
            {
              submitPrompt,
              stopResponse,
              modelId,
              chatId: chatId2,
              eventTarget,
              files
            },
            {
              files: ($$value) => {
                files = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div>` : `${$showEmbeds ? `${validate_component(Embeds, "Embeds").$$render($$result, {}, {}, {})}` : `${$showArtifacts ? `${validate_component(Artifacts, "Artifacts").$$render($$result, { history }, {}, {})}` : `${$showOverview ? `${function(__value) {
            if (is_promise(__value)) {
              __value.then(null, noop);
              return ``;
            }
            return function({ default: Overview }) {
              return ` ${validate_component(Overview, "Overview").$$render(
                $$result,
                {
                  history,
                  onNodeClick: (e) => {
                    const node = e.node;
                    showMessage(node.data.message, true);
                  },
                  onClose: () => {
                    showControls.set(false);
                  }
                },
                {},
                {}
              )} `;
            }(__value);
          }(import("./Overview.js"))}` : `${validate_component(Controls, "Controls").$$render(
            $$result,
            { models: models2, chatFiles, params },
            {
              chatFiles: ($$value) => {
                chatFiles = $$value;
                $$settled = false;
              },
              params: ($$value) => {
                params = $$value;
                $$settled = false;
              }
            },
            {}
          )}`}`}`}`}</div>`;
        }
      }
    )}` : ``}` : ` ${$showControls ? `${validate_component(Pane_resizer, "PaneResizer").$$render(
      $$result,
      {
        class: "relative flex items-center justify-center group border-l border-gray-50 dark:border-gray-850 hover:border-gray-200 dark:hover:border-gray-800  transition z-20",
        id: "controls-resizer"
      },
      {},
      {
        default: () => {
          return `<div class="absolute -left-1.5 -right-1.5 -top-0 -bottom-0 z-20 cursor-col-resize bg-transparent"></div>`;
        }
      }
    )}` : ``} ${validate_component(Pane, "Pane").$$render(
      $$result,
      {
        defaultSize: 0,
        onResize: (size) => {
          if ($showControls && pane.isExpanded()) {
            if (size < minSize) {
              pane.resize(minSize);
            }
            if (size < minSize) {
              localStorage.chatControlsSize = 0;
            } else {
              const container = document.getElementById("chat-container");
              localStorage.chatControlsSize = Math.floor(size / 100 * container.clientWidth);
            }
          }
        },
        onCollapse: () => {
          showControls.set(false);
        },
        collapsible: true,
        class: " z-10 bg-white dark:bg-gray-850",
        pane
      },
      {
        pane: ($$value) => {
          pane = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `${$showControls ? `<div class="flex max-h-full min-h-full"><div class="${"w-full " + escape(
            ($showOverview || $showArtifacts || $showEmbeds) && !$showCallOverlay ? " " : "px-4 py-3 bg-white dark:shadow-lg dark:bg-gray-850 ",
            true
          ) + " z-40 pointer-events-auto overflow-y-auto scrollbar-hidden"}" id="controls-container">${$showCallOverlay ? `<div class="w-full h-full flex justify-center">${validate_component(CallOverlay, "CallOverlay").$$render(
            $$result,
            {
              submitPrompt,
              stopResponse,
              modelId,
              chatId: chatId2,
              eventTarget,
              files
            },
            {
              files: ($$value) => {
                files = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div>` : `${$showEmbeds ? `${validate_component(Embeds, "Embeds").$$render($$result, { overlay: dragged }, {}, {})}` : `${$showArtifacts ? `${validate_component(Artifacts, "Artifacts").$$render($$result, { history, overlay: dragged }, {}, {})}` : `${$showOverview ? `${function(__value) {
            if (is_promise(__value)) {
              __value.then(null, noop);
              return ``;
            }
            return function({ default: Overview }) {
              return ` ${validate_component(Overview, "Overview").$$render(
                $$result,
                {
                  history,
                  onNodeClick: (e) => {
                    const node = e.node;
                    if (node?.data?.message?.favorite) {
                      history.messages[node.data.message.id].favorite = true;
                    } else {
                      history.messages[node.data.message.id].favorite = null;
                    }
                    showMessage(node.data.message, true);
                  },
                  onClose: () => {
                    showControls.set(false);
                  }
                },
                {},
                {}
              )} `;
            }(__value);
          }(import("./Overview.js"))}` : `${validate_component(Controls, "Controls").$$render(
            $$result,
            { models: models2, chatFiles, params },
            {
              chatFiles: ($$value) => {
                chatFiles = $$value;
                $$settled = false;
              },
              params: ($$value) => {
                params = $$value;
                $$settled = false;
              }
            },
            {}
          )}`}`}`}`}</div></div>` : ``}`;
        }
      }
    )}`}`;
  } while (!$$settled);
  $$unsubscribe_showCallOverlay();
  $$unsubscribe_showControls();
  $$unsubscribe_showOverview();
  $$unsubscribe_showArtifacts();
  $$unsubscribe_showEmbeds();
  return $$rendered;
});
const ChatList = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  dayjs.extend(localizedFormat);
  let { chats: chats2 = [] } = $$props;
  let chatList = null;
  const init = async () => {
    if (chats2.length === 0) {
      chatList = [];
    } else {
      chatList = chats2.map((chat) => ({
        ...chat,
        time_range: getTimeRange(chat.updated_at)
      }));
      chatList.sort((a, b) => {
        {
          return a[orderBy] < b[orderBy] ? 1 : -1;
        }
      });
    }
  };
  let orderBy = "updated_at";
  if ($$props.chats === void 0 && $$bindings.chats && chats2 !== void 0) $$bindings.chats(chats2);
  {
    if (chats2) {
      init();
    }
  }
  $$unsubscribe_i18n();
  return `${chatList ? `${chatList.length > 0 ? `<div class="flex text-xs font-medium mb-1 items-center -mr-0.5"><button class="px-1.5 py-1 cursor-pointer select-none basis-3/5"><div class="flex gap-1.5 items-center">${escape($i18n.t("Title"))} ${`<span class="invisible">${validate_component(ChevronUp, "ChevronUp").$$render($$result, { className: "size-2" }, {}, {})}</span>`}</div></button> <button class="px-1.5 py-1 cursor-pointer select-none hidden sm:flex sm:basis-2/5 justify-end"><div class="flex gap-1.5 items-center">${escape($i18n.t("Updated at"))} ${`<span class="font-normal">${` ${validate_component(ChevronDown, "ChevronDown").$$render($$result, { className: "size-2" }, {}, {})}`}</span>`}</div></button></div>` : ``} <div class="text-left text-sm w-full mb-3">${chatList.length === 0 ? `<div class="text-xs text-gray-500 dark:text-gray-400 text-center px-5 min-h-20 w-full h-full flex justify-center items-center">${escape($i18n.t("No chats found"))}</div>` : ``} ${each(chatList, (chat, idx) => {
    return `${(idx === 0 || idx > 0 && chat.time_range !== chatList[idx - 1].time_range) && chat?.time_range ? `<div class="${"w-full text-xs text-gray-500 dark:text-gray-500 font-medium " + escape(idx === 0 ? "" : "pt-5", true) + " pb-2 px-2"}">${escape($i18n.t(chat.time_range))}  </div>` : ``} <a class="w-full flex justify-between items-center rounded-lg text-sm py-2 px-3 hover:bg-gray-50 dark:hover:bg-gray-850" draggable="false"${add_attribute("href", `/c/${chat.id}`, 0)}><div class="text-ellipsis line-clamp-1 w-full sm:basis-3/5">${escape(chat?.title)}</div> <div class="hidden sm:flex sm:basis-2/5 items-center justify-end"><div class="text-gray-500 dark:text-gray-400 text-xs">${escape(dayjs(chat?.updated_at * 1e3).calendar())} </div></div> </a>`;
  })} </div>` : ``}`;
});
let page = 1;
const FolderPlaceholder = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  let { folder = null } = $$props;
  let chats2 = null;
  const setChatList = async () => {
    chats2 = null;
    if (folder && folder.id) {
      const res = await getChatListByFolderId(localStorage.token, folder.id, page);
      if (res) {
        chats2 = res;
      } else {
        chats2 = [];
      }
    } else {
      chats2 = [];
    }
  };
  if ($$props.folder === void 0 && $$bindings.folder && folder !== void 0) $$bindings.folder(folder);
  {
    if (folder) {
      setChatList();
    }
  }
  return `<div> <div class="">${`${`${chats2 !== null ? `${validate_component(ChatList, "ChatList").$$render($$result, { chats: chats2 }, {}, {})}` : `<div class="py-10">${validate_component(Spinner, "Spinner").$$render($$result, {}, {}, {})}</div>`}`}`}</div></div>`;
});
const FolderTitle = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  const { saveAs } = fileSaver;
  let { folder = null } = $$props;
  let { onUpdate = (folderId) => {
  } } = $$props;
  let { onDelete = (folderId) => {
  } } = $$props;
  let showFolderModal = false;
  let showDeleteConfirm = false;
  const updateHandler = async ({ name, meta, data }) => {
    if (name === "") {
      toast.error($i18n.t("Folder name cannot be empty."));
      return;
    }
    const currentName = folder.name;
    name = name.trim();
    folder.name = name;
    const res = await updateFolderById(localStorage.token, folder.id, {
      name,
      ...meta ? { meta } : {},
      ...data ? { data } : {}
    }).catch((error) => {
      toast.error(`${error}`);
      folder.name = currentName;
      return null;
    });
    if (res) {
      folder.name = name;
      if (data) {
        folder.data = data;
      }
      toast.success($i18n.t("Folder updated successfully"));
      const _folder = await getFolderById(localStorage.token, folder.id).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      await selectedFolder.set(_folder);
      onUpdate(_folder);
    }
  };
  const updateIconHandler = async (iconName) => {
    const res = await updateFolderById(localStorage.token, folder.id, { meta: { icon: iconName } }).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    if (res) {
      folder.meta = { ...folder.meta, icon: iconName };
      toast.success($i18n.t("Folder updated successfully"));
      const _folder = await getFolderById(localStorage.token, folder.id).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      await selectedFolder.set(_folder);
      onUpdate(_folder);
    }
  };
  const exportHandler = async () => {
    const chats2 = await getChatsByFolderId(localStorage.token, folder.id).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    if (!chats2) {
      return;
    }
    const blob = new Blob([JSON.stringify(chats2)], { type: "application/json" });
    saveAs(blob, `folder-${folder.name}-export-${Date.now()}.json`);
  };
  if ($$props.folder === void 0 && $$bindings.folder && folder !== void 0) $$bindings.folder(folder);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${folder ? `${validate_component(FolderModal, "FolderModal").$$render(
      $$result,
      {
        edit: true,
        folderId: folder.id,
        onSubmit: updateHandler,
        show: showFolderModal
      },
      {
        show: ($$value) => {
          showFolderModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(ConfirmDialog, "DeleteConfirmDialog").$$render(
      $$result,
      {
        title: $i18n.t("Delete folder?"),
        show: showDeleteConfirm
      },
      {
        show: ($$value) => {
          showDeleteConfirm = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="text-sm text-gray-700 dark:text-gray-300 flex-1 line-clamp-3"><!-- HTML_TAG_START -->${DOMPurify.sanitize($i18n.t("This will delete <strong>{{NAME}}</strong> and <strong>all its contents</strong>.", { NAME: folder.name }))}<!-- HTML_TAG_END --></div>`;
        }
      }
    )} <div class="mb-3 px-6 @md:max-w-3xl justify-between w-full flex relative group items-center"><div class="text-center flex gap-3.5 items-center">${validate_component(EmojiPicker, "EmojiPicker").$$render(
      $$result,
      {
        onClose: () => {
        },
        onSubmit: (name) => {
          /* @__PURE__ */ console.log(name);
          updateIconHandler(name);
        }
      },
      {},
      {
        default: () => {
          return `<button class="rounded-full bg-gray-50 dark:bg-gray-800 size-11 flex justify-center items-center">${folder?.meta?.icon ? `${validate_component(Emoji, "Emoji").$$render(
            $$result,
            {
              className: "size-6",
              shortCode: folder.meta.icon
            },
            {},
            {}
          )}` : `${validate_component(Folder, "Folder").$$render($$result, { className: "size-4.5", strokeWidth: "2" }, {}, {})}`}</button>`;
        }
      }
    )} <div class="text-3xl">${escape(folder.name)}</div></div> <div class="flex items-center translate-x-2.5">${validate_component(FolderMenu, "FolderMenu").$$render(
      $$result,
      {
        align: "end",
        onEdit: () => {
          showFolderModal = true;
        },
        onDelete: () => {
          showDeleteConfirm = true;
        },
        onExport: () => {
          exportHandler();
        }
      },
      {},
      {
        default: () => {
          return `<button class="p-1.5 dark:hover:bg-gray-850 rounded-full touch-auto">${validate_component(EllipsisHorizontal, "EllipsisHorizontal").$$render($$result, { className: "size-4", strokeWidth: "2.5" }, {}, {})}</button>`;
        }
      }
    )}</div></div>` : ``}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const Placeholder = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $_models, $$unsubscribe__models;
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  let $i18n, $$unsubscribe_i18n;
  let $selectedFolder, $$unsubscribe_selectedFolder;
  let $currentChatPage, $$unsubscribe_currentChatPage;
  let $user, $$unsubscribe_user;
  let $config, $$unsubscribe_config;
  $$unsubscribe__models = subscribe(models, (value) => $_models = value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  $$unsubscribe_selectedFolder = subscribe(selectedFolder, (value) => $selectedFolder = value);
  $$unsubscribe_currentChatPage = subscribe(currentChatPage, (value) => $currentChatPage = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { createMessagePair } = $$props;
  let { stopResponse } = $$props;
  let { autoScroll = false } = $$props;
  let { atSelectedModel } = $$props;
  let { selectedModels } = $$props;
  let { history } = $$props;
  let { prompt = "" } = $$props;
  let { files = [] } = $$props;
  let { messageInput = null } = $$props;
  let { selectedToolIds = [] } = $$props;
  let { selectedFilterIds = [] } = $$props;
  let { showCommands = false } = $$props;
  let { imageGenerationEnabled = false } = $$props;
  let { codeInterpreterEnabled = false } = $$props;
  let { webSearchEnabled = false } = $$props;
  let { onSelect = (e) => {
  } } = $$props;
  let { onChange = (e) => {
  } } = $$props;
  let { toolServers: toolServers2 = [] } = $$props;
  let models$1 = [];
  let selectedModelIdx = 0;
  if ($$props.createMessagePair === void 0 && $$bindings.createMessagePair && createMessagePair !== void 0) $$bindings.createMessagePair(createMessagePair);
  if ($$props.stopResponse === void 0 && $$bindings.stopResponse && stopResponse !== void 0) $$bindings.stopResponse(stopResponse);
  if ($$props.autoScroll === void 0 && $$bindings.autoScroll && autoScroll !== void 0) $$bindings.autoScroll(autoScroll);
  if ($$props.atSelectedModel === void 0 && $$bindings.atSelectedModel && atSelectedModel !== void 0) $$bindings.atSelectedModel(atSelectedModel);
  if ($$props.selectedModels === void 0 && $$bindings.selectedModels && selectedModels !== void 0) $$bindings.selectedModels(selectedModels);
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.prompt === void 0 && $$bindings.prompt && prompt !== void 0) $$bindings.prompt(prompt);
  if ($$props.files === void 0 && $$bindings.files && files !== void 0) $$bindings.files(files);
  if ($$props.messageInput === void 0 && $$bindings.messageInput && messageInput !== void 0) $$bindings.messageInput(messageInput);
  if ($$props.selectedToolIds === void 0 && $$bindings.selectedToolIds && selectedToolIds !== void 0) $$bindings.selectedToolIds(selectedToolIds);
  if ($$props.selectedFilterIds === void 0 && $$bindings.selectedFilterIds && selectedFilterIds !== void 0) $$bindings.selectedFilterIds(selectedFilterIds);
  if ($$props.showCommands === void 0 && $$bindings.showCommands && showCommands !== void 0) $$bindings.showCommands(showCommands);
  if ($$props.imageGenerationEnabled === void 0 && $$bindings.imageGenerationEnabled && imageGenerationEnabled !== void 0) $$bindings.imageGenerationEnabled(imageGenerationEnabled);
  if ($$props.codeInterpreterEnabled === void 0 && $$bindings.codeInterpreterEnabled && codeInterpreterEnabled !== void 0) $$bindings.codeInterpreterEnabled(codeInterpreterEnabled);
  if ($$props.webSearchEnabled === void 0 && $$bindings.webSearchEnabled && webSearchEnabled !== void 0) $$bindings.webSearchEnabled(webSearchEnabled);
  if ($$props.onSelect === void 0 && $$bindings.onSelect && onSelect !== void 0) $$bindings.onSelect(onSelect);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  if ($$props.toolServers === void 0 && $$bindings.toolServers && toolServers2 !== void 0) $$bindings.toolServers(toolServers2);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    models$1 = selectedModels.map((id) => $_models.find((m) => m.id === id));
    {
      if (selectedModels.length > 0) {
        selectedModelIdx = models$1.length - 1;
      }
    }
    $$rendered = `<div class="m-auto w-full max-w-6xl px-2 @2xl:px-20 translate-y-6 py-24 text-center">${$temporaryChatEnabled ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("This chat won't appear in history and your messages will not be saved."),
        className: "w-full flex justify-center mb-0.5",
        placement: "top"
      },
      {},
      {
        default: () => {
          return `<div class="flex items-center gap-2 text-gray-500 text-base my-2 w-fit">${validate_component(EyeSlash, "EyeSlash").$$render($$result, { strokeWidth: "2.5", className: "size-4" }, {}, {})}${escape($i18n.t("Temporary Chat"))}</div>`;
        }
      }
    )}` : ``} <div class="w-full text-3xl text-gray-800 dark:text-gray-100 text-center flex items-center gap-4 font-primary"><div class="w-full flex flex-col justify-center items-center">${$selectedFolder ? `${validate_component(FolderTitle, "FolderTitle").$$render(
      $$result,
      {
        folder: $selectedFolder,
        onUpdate: async (folder) => {
          await chats.set(await getChatList(localStorage.token, $currentChatPage));
          currentChatPage.set(1);
        },
        onDelete: async () => {
          await chats.set(await getChatList(localStorage.token, $currentChatPage));
          currentChatPage.set(1);
          selectedFolder.set(null);
        }
      },
      {},
      {}
    )}` : `<div class="flex flex-row justify-center gap-3 @sm:gap-3.5 w-fit px-5 max-w-xl"><div class="flex shrink-0 justify-center"><div class="flex -space-x-4 mb-0.5">${each(models$1, (model, modelIdx) => {
      return `${validate_component(Tooltip, "Tooltip").$$render(
        $$result,
        {
          content: (models$1[modelIdx]?.info?.meta?.tags ?? []).map((tag) => tag.name.toUpperCase()).join(", "),
          placement: "top"
        },
        {},
        {
          default: () => {
            return `<button${add_attribute("aria-hidden", models$1.length <= 1, 0)}${add_attribute("aria-label", $i18n.t("Get information on {{name}} in the UI", { name: models$1[modelIdx]?.name }), 0)}><img crossorigin="anonymous"${add_attribute(
              "src",
              model?.info?.meta?.profile_image_url ?? ($i18n.language === "dg-DG" ? `${WEBUI_BASE_URL}/doge.png` : `${WEBUI_BASE_URL}/static/favicon.png`),
              0
            )} class="size-9 @sm:size-10 rounded-full border-[1px] border-gray-100 dark:border-none" aria-hidden="true" draggable="false"></button> `;
          }
        }
      )}`;
    })}</div></div> <div class="text-3xl @sm:text-3xl line-clamp-1 flex items-center">${models$1[selectedModelIdx]?.name ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: models$1[selectedModelIdx]?.name,
        placement: "top",
        className: " flex items-center "
      },
      {},
      {
        default: () => {
          return `<span class="line-clamp-1">${escape(models$1[selectedModelIdx]?.name)}</span>`;
        }
      }
    )}` : `${escape($i18n.t("Hello, {{name}}", { name: $user?.name }))}`}</div></div> <div class="flex mt-1 mb-2"><div>${models$1[selectedModelIdx]?.info?.meta?.description ?? null ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        className: " w-fit",
        content: marked.parse(sanitizeResponseContent(models$1[selectedModelIdx]?.info?.meta?.description ?? "").replaceAll("\n", "<br>")),
        placement: "top"
      },
      {},
      {
        default: () => {
          return `<div class="mt-0.5 px-2 text-sm font-normal text-gray-500 dark:text-gray-400 line-clamp-2 max-w-xl markdown"><!-- HTML_TAG_START -->${marked.parse(sanitizeResponseContent(models$1[selectedModelIdx]?.info?.meta?.description ?? "").replaceAll("\n", "<br>"))}<!-- HTML_TAG_END --></div>`;
        }
      }
    )} ${models$1[selectedModelIdx]?.info?.meta?.user ? `<div class="mt-0.5 text-sm font-normal text-gray-400 dark:text-gray-500">By
									${models$1[selectedModelIdx]?.info?.meta?.user.community ? `<a href="${"https://openwebui.com/m/" + escape(models$1[selectedModelIdx]?.info?.meta?.user.username, true)}">${escape(models$1[selectedModelIdx]?.info?.meta?.user.name ? models$1[selectedModelIdx]?.info?.meta?.user.name : `@${models$1[selectedModelIdx]?.info?.meta?.user.username}`)}</a>` : `${escape(models$1[selectedModelIdx]?.info?.meta?.user.name)}`}</div>` : ``}` : ``}</div></div>`} <div class="${"text-base font-normal @md:max-w-3xl w-full py-3 " + escape(atSelectedModel ? "mt-2" : "", true)}">${validate_component(MessageInput, "MessageInput").$$render(
      $$result,
      {
        history,
        selectedModels,
        toolServers: toolServers2,
        stopResponse,
        createMessagePair,
        placeholder: $i18n.t("How can I help you today?"),
        onChange,
        this: messageInput,
        files,
        prompt,
        autoScroll,
        selectedToolIds,
        selectedFilterIds,
        imageGenerationEnabled,
        codeInterpreterEnabled,
        webSearchEnabled,
        atSelectedModel,
        showCommands
      },
      {
        this: ($$value) => {
          messageInput = $$value;
          $$settled = false;
        },
        files: ($$value) => {
          files = $$value;
          $$settled = false;
        },
        prompt: ($$value) => {
          prompt = $$value;
          $$settled = false;
        },
        autoScroll: ($$value) => {
          autoScroll = $$value;
          $$settled = false;
        },
        selectedToolIds: ($$value) => {
          selectedToolIds = $$value;
          $$settled = false;
        },
        selectedFilterIds: ($$value) => {
          selectedFilterIds = $$value;
          $$settled = false;
        },
        imageGenerationEnabled: ($$value) => {
          imageGenerationEnabled = $$value;
          $$settled = false;
        },
        codeInterpreterEnabled: ($$value) => {
          codeInterpreterEnabled = $$value;
          $$settled = false;
        },
        webSearchEnabled: ($$value) => {
          webSearchEnabled = $$value;
          $$settled = false;
        },
        atSelectedModel: ($$value) => {
          atSelectedModel = $$value;
          $$settled = false;
        },
        showCommands: ($$value) => {
          showCommands = $$value;
          $$settled = false;
        }
      },
      {}
    )}</div></div></div> ${$selectedFolder ? `<div class="mx-auto px-4 md:max-w-3xl md:px-6 font-primary min-h-62">${validate_component(FolderPlaceholder, "FolderPlaceholder").$$render($$result, { folder: $selectedFolder }, {}, {})}</div>` : `<div class="mx-auto max-w-2xl font-primary mt-2"><div class="mx-5">${validate_component(Suggestions, "Suggestions").$$render(
      $$result,
      {
        suggestionPrompts: atSelectedModel?.info?.meta?.suggestion_prompts ?? models$1[selectedModelIdx]?.info?.meta?.suggestion_prompts ?? $config?.default_prompt_suggestions ?? [],
        inputValue: prompt,
        onSelect
      },
      {},
      {}
    )}</div></div>`}</div>`;
  } while (!$$settled);
  $$unsubscribe__models();
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe_i18n();
  $$unsubscribe_selectedFolder();
  $$unsubscribe_currentChatPage();
  $$unsubscribe_user();
  $$unsubscribe_config();
  return $$rendered;
});
const MAX_DRAFT_LENGTH = 5e3;
const Chat = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $currentChatPage, $$unsubscribe_currentChatPage;
  let $temporaryChatEnabled, $$unsubscribe_temporaryChatEnabled;
  let $chatId, $$unsubscribe_chatId;
  let $socket, $$unsubscribe_socket;
  let $selectedFolder, $$unsubscribe_selectedFolder;
  let $settings, $$unsubscribe_settings;
  let $models, $$unsubscribe_models;
  let $user, $$unsubscribe_user;
  let $toolServers, $$unsubscribe_toolServers;
  let $config, $$unsubscribe_config;
  let $showCallOverlay, $$unsubscribe_showCallOverlay;
  let $page, $$unsubscribe_page;
  let $$unsubscribe_mobile;
  let $tools, $$unsubscribe_tools;
  let $functions, $$unsubscribe_functions;
  let $chatTitle, $$unsubscribe_chatTitle;
  let $WEBUI_NAME, $$unsubscribe_WEBUI_NAME;
  let $showSidebar, $$unsubscribe_showSidebar;
  $$unsubscribe_currentChatPage = subscribe(currentChatPage, (value) => $currentChatPage = value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => $temporaryChatEnabled = value);
  $$unsubscribe_chatId = subscribe(chatId, (value) => $chatId = value);
  $$unsubscribe_socket = subscribe(socket, (value) => $socket = value);
  $$unsubscribe_selectedFolder = subscribe(selectedFolder, (value) => $selectedFolder = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_toolServers = subscribe(toolServers, (value) => $toolServers = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_showCallOverlay = subscribe(showCallOverlay, (value) => $showCallOverlay = value);
  $$unsubscribe_page = subscribe(page$1, (value) => $page = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => value);
  $$unsubscribe_tools = subscribe(tools, (value) => $tools = value);
  $$unsubscribe_functions = subscribe(functions, (value) => $functions = value);
  $$unsubscribe_chatTitle = subscribe(chatTitle, (value) => $chatTitle = value);
  $$unsubscribe_WEBUI_NAME = subscribe(WEBUI_NAME, (value) => $WEBUI_NAME = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { chatIdProp = "" } = $$props;
  let loading = true;
  const eventTarget = new EventTarget();
  let controlPane;
  let controlPaneComponent;
  let messageInput;
  let autoScroll = true;
  let messagesContainerElement;
  let navbarElement;
  let showEventConfirmation = false;
  let eventConfirmationTitle = "";
  let eventConfirmationMessage = "";
  let eventConfirmationInput = false;
  let eventConfirmationInputPlaceholder = "";
  let eventConfirmationInputValue = "";
  let chatIdUnsubscriber;
  let selectedModels = [""];
  let atSelectedModel;
  let selectedModelIds = [];
  let selectedToolIds = [];
  let selectedFilterIds = [];
  let imageGenerationEnabled = false;
  let webSearchEnabled = false;
  let codeInterpreterEnabled = false;
  let showCommands = false;
  let generating = false;
  let generationController = null;
  let chat = null;
  let history = { messages: {}, currentId: null };
  let taskIds = null;
  let prompt = "";
  let chatFiles = [];
  let files = [];
  let params = {};
  const navigateHandler = async () => {
    loading = true;
    prompt = "";
    messageInput?.setText("");
    files = [];
    selectedToolIds = [];
    selectedFilterIds = [];
    webSearchEnabled = false;
    imageGenerationEnabled = false;
    const storageChatInput = sessionStorage.getItem(`chat-input${chatIdProp ? `-${chatIdProp}` : ""}`);
    if (chatIdProp && await loadChat()) {
      await tick();
      loading = false;
      window.setTimeout(() => scrollToBottom(), 0);
      await tick();
      if (storageChatInput) {
        try {
          const input = JSON.parse(storageChatInput);
          if (!$temporaryChatEnabled) {
            messageInput?.setText(input.prompt);
            files = input.files;
            selectedToolIds = input.selectedToolIds;
            selectedFilterIds = input.selectedFilterIds;
            webSearchEnabled = input.webSearchEnabled;
            imageGenerationEnabled = input.imageGenerationEnabled;
            codeInterpreterEnabled = input.codeInterpreterEnabled;
          }
        } catch (e) {
        }
      }
      const chatInput = document.getElementById("chat-input");
      chatInput?.focus();
    } else {
      await goto();
    }
  };
  const onSelect = async (e) => {
    const { type, data } = e;
    if (type === "prompt") {
      messageInput?.setText(data, async () => {
        if (!($settings?.insertSuggestionPrompt ?? false)) {
          await tick();
          submitPrompt(prompt);
        }
      });
    }
  };
  const saveSessionSelectedModels = () => {
    const selectedModelsString = JSON.stringify(selectedModels);
    if (selectedModels.length === 0 || selectedModels.length === 1 && selectedModels[0] === "" || sessionStorage.selectedModels === selectedModelsString) {
      return;
    }
    sessionStorage.selectedModels = selectedModelsString;
    /* @__PURE__ */ console.log("saveSessionSelectedModels", selectedModels, sessionStorage.selectedModels);
  };
  let oldSelectedModelIds = [""];
  const onSelectedModelIdsChange = () => {
    if (oldSelectedModelIds.filter((id) => id).length > 0) {
      resetInput();
    }
    oldSelectedModelIds = selectedModelIds;
  };
  const resetInput = () => {
    selectedToolIds = [];
    selectedFilterIds = [];
    webSearchEnabled = false;
    imageGenerationEnabled = false;
    codeInterpreterEnabled = false;
    setDefaults();
  };
  const setDefaults = async () => {
    if (!$tools) {
      tools.set(await getTools(localStorage.token));
    }
    if (!$functions) {
      functions.set(await getFunctions(localStorage.token));
    }
    if (selectedModels.length !== 1 && !atSelectedModel) {
      return;
    }
    const model = atSelectedModel ?? $models.find((m) => m.id === selectedModels[0]);
    if (model) {
      if (model?.info?.meta?.toolIds) {
        selectedToolIds = [
          ...new Set([...model?.info?.meta?.toolIds ?? []].filter((id) => $tools.find((t) => t.id === id)))
        ];
      }
      if (model?.info?.meta?.defaultFilterIds) {
        selectedFilterIds = model.info.meta.defaultFilterIds.filter((id) => model?.filters?.find((f) => f.id === id));
      }
      if (model?.info?.meta?.defaultFeatureIds) {
        if (model.info?.meta?.capabilities?.["image_generation"]) {
          imageGenerationEnabled = model.info.meta.defaultFeatureIds.includes("image_generation");
        }
        if (model.info?.meta?.capabilities?.["web_search"]) {
          webSearchEnabled = model.info.meta.defaultFeatureIds.includes("web_search");
        }
        if (model.info?.meta?.capabilities?.["code_interpreter"]) {
          codeInterpreterEnabled = model.info.meta.defaultFeatureIds.includes("code_interpreter");
        }
      }
    }
  };
  const showMessage = async (message, ignoreSettings = false) => {
    await tick();
    const _chatId = JSON.parse(JSON.stringify($chatId));
    let _messageId = JSON.parse(JSON.stringify(message.id));
    let messageChildrenIds = [];
    if (_messageId === null) {
      messageChildrenIds = Object.keys(history.messages).filter((id) => history.messages[id].parentId === null);
    } else {
      messageChildrenIds = history.messages[_messageId].childrenIds;
    }
    while (messageChildrenIds.length !== 0) {
      _messageId = messageChildrenIds.at(-1);
      messageChildrenIds = history.messages[_messageId].childrenIds;
    }
    history.currentId = _messageId;
    await tick();
    await tick();
    await tick();
    if (($settings?.scrollOnBranchChange ?? true) || ignoreSettings) {
      const messageElement = document.getElementById(`message-${message.id}`);
      if (messageElement) {
        messageElement.scrollIntoView({ behavior: "smooth" });
      }
    }
    await tick();
    saveChatHandler(_chatId, history);
  };
  const chatEventHandler = async (event, cb) => {
    /* @__PURE__ */ console.log(event);
    if (event.chat_id === $chatId) {
      await tick();
      let message = history.messages[event.message_id];
      if (message) {
        const type = event?.data?.type ?? null;
        const data = event?.data?.data ?? null;
        if (type === "status") {
          if (message?.statusHistory) {
            message.statusHistory.push(data);
          } else {
            message.statusHistory = [data];
          }
        } else if (type === "chat:completion") {
          chatCompletionEventHandler(data, message, event.chat_id);
        } else if (type === "chat:tasks:cancel") {
          taskIds = null;
          const responseMessage = history.messages[history.currentId];
          for (const messageId of history.messages[responseMessage.parentId].childrenIds) {
            history.messages[messageId].done = true;
          }
        } else if (type === "chat:message:delta" || type === "message") {
          message.content += data.content;
        } else if (type === "chat:message" || type === "replace") {
          message.content = data.content;
        } else if (type === "chat:message:files" || type === "files") {
          message.files = data.files;
        } else if (type === "chat:message:embeds" || type === "embeds") {
          message.embeds = data.embeds;
        } else if (type === "chat:message:error") {
          message.error = data.error;
        } else if (type === "chat:message:follow_ups") {
          message.followUps = data.follow_ups;
          if (autoScroll) {
            scrollToBottom("smooth");
          }
        } else if (type === "chat:title") {
          chatTitle.set(data);
          currentChatPage.set(1);
          await chats.set(await getChatList(localStorage.token, $currentChatPage));
        } else if (type === "chat:tags") {
          chat = await getChatById(localStorage.token, $chatId);
          tags.set(await getAllTags(localStorage.token));
        } else if (type === "source" || type === "citation") {
          if (data?.type === "code_execution") {
            if (!message?.code_executions) {
              message.code_executions = [];
            }
            const existingCodeExecutionIndex = message.code_executions.findIndex((execution) => execution.id === data.id);
            if (existingCodeExecutionIndex !== -1) {
              message.code_executions[existingCodeExecutionIndex] = data;
            } else {
              message.code_executions.push(data);
            }
            message.code_executions = message.code_executions;
          } else {
            if (message?.sources) {
              message.sources.push(data);
            } else {
              message.sources = [data];
            }
          }
        } else if (type === "notification") {
          const toastType = data?.type ?? "info";
          const toastContent = data?.content ?? "";
          if (toastType === "success") {
            toast.success(toastContent);
          } else if (toastType === "error") {
            toast.error(toastContent);
          } else if (toastType === "warning") {
            toast.warning(toastContent);
          } else {
            toast.info(toastContent);
          }
        } else if (type === "confirmation") {
          eventConfirmationInput = false;
          showEventConfirmation = true;
          eventConfirmationTitle = data.title;
          eventConfirmationMessage = data.message;
        } else if (type === "execute") {
          try {
            const asyncFunction = new Function(`return (async () => { ${data.code} })()`);
            const result = await asyncFunction();
            if (cb) {
              cb(result);
            }
          } catch (error) {
            /* @__PURE__ */ console.error("Error executing code:", error);
          }
        } else if (type === "input") {
          eventConfirmationInput = true;
          showEventConfirmation = true;
          eventConfirmationTitle = data.title;
          eventConfirmationMessage = data.message;
          eventConfirmationInputPlaceholder = data.placeholder;
          eventConfirmationInputValue = data?.value ?? "";
        } else {
          /* @__PURE__ */ console.log("Unknown message type", data);
        }
        history.messages[event.message_id] = message;
      }
    }
  };
  const onMessageHandler = async (event) => {
    if (event.origin !== window.origin) {
      return;
    }
    if (event.data.type === "action:submit") {
      /* @__PURE__ */ console.debug(event.data.text);
      if (prompt !== "") {
        await tick();
        submitPrompt(prompt);
      }
    }
    if (event.data.type === "input:prompt") {
      /* @__PURE__ */ console.debug(event.data.text);
      const inputElement = document.getElementById("chat-input");
      if (inputElement) {
        messageInput?.setText(event.data.text);
        inputElement.focus();
      }
    }
    if (event.data.type === "input:prompt:submit") {
      /* @__PURE__ */ console.debug(event.data.text);
      if (event.data.text !== "") {
        await tick();
        submitPrompt(event.data.text);
      }
    }
  };
  const savedModelIds = async () => {
    if ($selectedFolder && selectedModels.filter((modelId) => modelId !== "").length > 0 && JSON.stringify($selectedFolder?.data?.model_ids) !== JSON.stringify(selectedModels)) {
      await updateFolderById(localStorage.token, $selectedFolder.id, { data: { model_ids: selectedModels } });
    }
  };
  let pageSubscribe = null;
  let showControlsSubscribe = null;
  let selectedFolderSubscribe = null;
  onDestroy(() => {
    try {
      pageSubscribe();
      showControlsSubscribe();
      selectedFolderSubscribe();
      chatIdUnsubscriber?.();
      window.removeEventListener("message", onMessageHandler);
      $socket?.off("events", chatEventHandler);
    } catch (e) {
      /* @__PURE__ */ console.error(e);
    }
  });
  const uploadWeb = async (url) => {
    /* @__PURE__ */ console.log(url);
    const fileItem = {
      type: "text",
      name: url,
      collection_name: "",
      status: "uploading",
      url,
      error: ""
    };
    try {
      files = [...files, fileItem];
      const res = await processWeb(localStorage.token, "", url);
      if (res) {
        fileItem.status = "uploaded";
        fileItem.collection_name = res.collection_name;
        fileItem.file = { ...res.file, ...fileItem.file };
        files = files;
      }
    } catch (e) {
      files = files.filter((f) => f.name !== url);
      toast.error(JSON.stringify(e));
    }
  };
  const uploadYoutubeTranscription = async (url) => {
    /* @__PURE__ */ console.log(url);
    const fileItem = {
      type: "text",
      name: url,
      collection_name: "",
      status: "uploading",
      context: "full",
      url,
      error: ""
    };
    try {
      files = [...files, fileItem];
      const res = await processYoutubeVideo(localStorage.token, url);
      if (res) {
        fileItem.status = "uploaded";
        fileItem.collection_name = res.collection_name;
        fileItem.file = { ...res.file, ...fileItem.file };
        files = files;
      }
    } catch (e) {
      files = files.filter((f) => f.name !== url);
      toast.error(`${e}`);
    }
  };
  const initNewChat = async () => {
    /* @__PURE__ */ console.log("initNewChat");
    if ($user?.role !== "admin" && $user?.permissions?.chat?.temporary_enforced) {
      await temporaryChatEnabled.set(true);
    }
    if ($settings?.temporaryChatByDefault ?? false) {
      if ($temporaryChatEnabled === false) {
        await temporaryChatEnabled.set(true);
      } else if ($temporaryChatEnabled === null) {
        await temporaryChatEnabled.set(false);
      }
    }
    const availableModels = $models.filter((m) => !(m?.info?.meta?.hidden ?? false)).map((m) => m.id);
    if ($page.url.searchParams.get("models") || $page.url.searchParams.get("model")) {
      const urlModels = ($page.url.searchParams.get("models") || $page.url.searchParams.get("model") || "")?.split(",");
      if (urlModels.length === 1) {
        const m = $models.find((m2) => m2.id === urlModels[0]);
        if (!m) {
          const modelSelectorButton = document.getElementById("model-selector-0-button");
          if (modelSelectorButton) {
            modelSelectorButton.click();
            await tick();
            const modelSelectorInput = document.getElementById("model-search-input");
            if (modelSelectorInput) {
              modelSelectorInput.focus();
              modelSelectorInput.value = urlModels[0];
              modelSelectorInput.dispatchEvent(new Event("input"));
            }
          }
        } else {
          selectedModels = urlModels;
        }
      } else {
        selectedModels = urlModels;
      }
      selectedModels = selectedModels.filter((modelId) => $models.map((m) => m.id).includes(modelId));
    } else {
      if ($selectedFolder?.data?.model_ids) {
        selectedModels = $selectedFolder?.data?.model_ids;
      } else {
        if (sessionStorage.selectedModels) {
          selectedModels = JSON.parse(sessionStorage.selectedModels);
          sessionStorage.removeItem("selectedModels");
        } else {
          if ($settings?.models) {
            selectedModels = $settings?.models;
          } else if ($config?.default_models) {
            /* @__PURE__ */ console.log($config?.default_models.split(",") ?? "");
            selectedModels = $config?.default_models.split(",");
          }
        }
      }
      selectedModels = selectedModels.filter((modelId) => availableModels.includes(modelId));
    }
    if (selectedModels.length === 0 || selectedModels.length === 1 && selectedModels[0] === "") {
      if (availableModels.length > 0) {
        selectedModels = [availableModels?.at(0) ?? ""];
      } else {
        selectedModels = [""];
      }
    }
    await showControls.set(false);
    await showCallOverlay.set(false);
    await showOverview.set(false);
    await showArtifacts.set(false);
    if ($page.url.pathname.includes("/c/")) {
      window.history.replaceState(history.state, "", `/`);
    }
    autoScroll = true;
    resetInput();
    await chatId.set("");
    await chatTitle.set("");
    history = { messages: {}, currentId: null };
    chatFiles = [];
    params = {};
    if ($page.url.searchParams.get("youtube")) {
      uploadYoutubeTranscription(`https://www.youtube.com/watch?v=${$page.url.searchParams.get("youtube")}`);
    }
    if ($page.url.searchParams.get("load-url")) {
      await uploadWeb($page.url.searchParams.get("load-url"));
    }
    if ($page.url.searchParams.get("web-search") === "true") {
      webSearchEnabled = true;
    }
    if ($page.url.searchParams.get("image-generation") === "true") {
      imageGenerationEnabled = true;
    }
    if ($page.url.searchParams.get("code-interpreter") === "true") {
      codeInterpreterEnabled = true;
    }
    if ($page.url.searchParams.get("tools")) {
      selectedToolIds = $page.url.searchParams.get("tools")?.split(",").map((id) => id.trim()).filter((id) => id);
    } else if ($page.url.searchParams.get("tool-ids")) {
      selectedToolIds = $page.url.searchParams.get("tool-ids")?.split(",").map((id) => id.trim()).filter((id) => id);
    }
    if ($page.url.searchParams.get("call") === "true") {
      showCallOverlay.set(true);
      showControls.set(true);
    }
    if ($page.url.searchParams.get("q")) {
      const q = $page.url.searchParams.get("q") ?? "";
      messageInput?.setText(q);
      if (q) {
        if (($page.url.searchParams.get("submit") ?? "true") === "true") {
          await tick();
          submitPrompt(q);
        }
      }
    }
    selectedModels = selectedModels.map((modelId) => $models.map((m) => m.id).includes(modelId) ? modelId : "");
    const userSettings = await getUserSettings(localStorage.token);
    if (userSettings) {
      settings.set(userSettings.ui);
    } else {
      settings.set(JSON.parse(localStorage.getItem("settings") ?? "{}"));
    }
    const chatInput = document.getElementById("chat-input");
    setTimeout(() => chatInput?.focus(), 0);
  };
  const loadChat = async () => {
    chatId.set(chatIdProp);
    if ($temporaryChatEnabled) {
      temporaryChatEnabled.set(false);
    }
    chat = await getChatById(localStorage.token, $chatId).catch(async (error) => {
      await goto();
      return null;
    });
    if (chat) {
      await getTagsById(localStorage.token, $chatId).catch(async (error) => {
        return [];
      });
      const chatContent = chat.chat;
      if (chatContent) {
        /* @__PURE__ */ console.log(chatContent);
        selectedModels = (chatContent?.models ?? void 0) !== void 0 ? chatContent.models : [chatContent.models ?? ""];
        if (!($user?.role === "admin" || ($user?.permissions?.chat?.multiple_models ?? true))) {
          selectedModels = selectedModels.length > 0 ? [selectedModels[0]] : [""];
        }
        oldSelectedModelIds = selectedModels;
        history = (chatContent?.history ?? void 0) !== void 0 ? chatContent.history : convertMessagesToHistory(chatContent.messages);
        chatTitle.set(chatContent.title);
        const userSettings = await getUserSettings(localStorage.token);
        if (userSettings) {
          await settings.set(userSettings.ui);
        } else {
          await settings.set(JSON.parse(localStorage.getItem("settings") ?? "{}"));
        }
        params = chatContent?.params ?? {};
        chatFiles = chatContent?.files ?? [];
        autoScroll = true;
        await tick();
        if (history.currentId) {
          for (const message of Object.values(history.messages)) {
            if (message.role === "assistant") {
              message.done = true;
            }
          }
        }
        const taskRes = await getTaskIdsByChatId(localStorage.token, $chatId).catch((error) => {
          return null;
        });
        if (taskRes) {
          taskIds = taskRes.task_ids;
        }
        await tick();
        return true;
      } else {
        return null;
      }
    }
  };
  const scrollToBottom = async (behavior = "auto") => {
    await tick();
  };
  const chatCompletedHandler = async (chatId2, modelId, responseMessageId, messages) => {
    const res = await chatCompleted(localStorage.token, {
      model: modelId,
      messages: messages.map((m) => ({
        id: m.id,
        role: m.role,
        content: m.content,
        info: m.info ? m.info : void 0,
        timestamp: m.timestamp,
        ...m.usage ? { usage: m.usage } : {},
        ...m.sources ? { sources: m.sources } : {}
      })),
      filter_ids: selectedFilterIds.length > 0 ? selectedFilterIds : void 0,
      model_item: $models.find((m) => m.id === modelId),
      chat_id: chatId2,
      session_id: $socket?.id,
      id: responseMessageId
    }).catch((error) => {
      toast.error(`${error}`);
      messages.at(-1).error = { content: error };
      return null;
    });
    if (res !== null && res.messages) {
      for (const message of res.messages) {
        if (message?.id) {
          history.messages[message.id] = {
            ...history.messages[message.id],
            ...history.messages[message.id].content !== message.content ? {
              originalContent: history.messages[message.id].content
            } : {},
            ...message
          };
        }
      }
    }
    await tick();
    if ($chatId == chatId2) {
      if (!$temporaryChatEnabled) {
        chat = await updateChatById(localStorage.token, chatId2, {
          models: selectedModels,
          messages,
          history,
          params,
          files: chatFiles
        });
        currentChatPage.set(1);
        await chats.set(await getChatList(localStorage.token, $currentChatPage));
      }
    }
    taskIds = null;
  };
  const chatActionHandler = async (chatId2, actionId, modelId, responseMessageId, event = null) => {
    const messages = createMessagesList(history, responseMessageId);
    const res = await chatAction(localStorage.token, actionId, {
      model: modelId,
      messages: messages.map((m) => ({
        id: m.id,
        role: m.role,
        content: m.content,
        info: m.info ? m.info : void 0,
        timestamp: m.timestamp,
        ...m.sources ? { sources: m.sources } : {}
      })),
      ...event ? { event } : {},
      model_item: $models.find((m) => m.id === modelId),
      chat_id: chatId2,
      session_id: $socket?.id,
      id: responseMessageId
    }).catch((error) => {
      toast.error(`${error}`);
      messages.at(-1).error = { content: error };
      return null;
    });
    if (res !== null && res.messages) {
      for (const message of res.messages) {
        history.messages[message.id] = {
          ...history.messages[message.id],
          ...history.messages[message.id].content !== message.content ? {
            originalContent: history.messages[message.id].content
          } : {},
          ...message
        };
      }
    }
    if ($chatId == chatId2) {
      if (!$temporaryChatEnabled) {
        chat = await updateChatById(localStorage.token, chatId2, {
          models: selectedModels,
          messages,
          history,
          params,
          files: chatFiles
        });
        currentChatPage.set(1);
        await chats.set(await getChatList(localStorage.token, $currentChatPage));
      }
    }
  };
  const getChatEventEmitter = async (modelId, chatId2 = "") => {
    return setInterval(
      () => {
        $socket?.emit("usage", {
          action: "chat",
          model: modelId,
          chat_id: chatId2
        });
      },
      1e3
    );
  };
  const createMessagePair = async (userPrompt) => {
    messageInput?.setText("");
    if (selectedModels.length === 0) {
      toast.error($i18n.t("Model not selected"));
    } else {
      const modelId = selectedModels[0];
      const model = $models.filter((m) => m.id === modelId).at(0);
      const messages = createMessagesList(history, history.currentId);
      const parentMessage = messages.length !== 0 ? messages.at(-1) : null;
      const userMessageId = v4();
      const responseMessageId = v4();
      const userMessage = {
        id: userMessageId,
        parentId: parentMessage ? parentMessage.id : null,
        childrenIds: [responseMessageId],
        role: "user",
        content: userPrompt ? userPrompt : `[PROMPT] ${userMessageId}`,
        timestamp: Math.floor(Date.now() / 1e3)
      };
      const responseMessage = {
        id: responseMessageId,
        parentId: userMessageId,
        childrenIds: [],
        role: "assistant",
        content: `[RESPONSE] ${responseMessageId}`,
        done: true,
        model: modelId,
        modelName: model.name ?? model.id,
        modelIdx: 0,
        timestamp: Math.floor(Date.now() / 1e3)
      };
      if (parentMessage) {
        parentMessage.childrenIds.push(userMessageId);
        history.messages[parentMessage.id] = parentMessage;
      }
      history.messages[userMessageId] = userMessage;
      history.messages[responseMessageId] = responseMessage;
      history.currentId = responseMessageId;
      await tick();
      if (autoScroll) {
        scrollToBottom();
      }
      if (messages.length === 0) {
        await initChatHandler(history);
      } else {
        await saveChatHandler($chatId, history);
      }
    }
  };
  const addMessages = async ({ modelId, parentId, messages }) => {
    const model = $models.filter((m) => m.id === modelId).at(0);
    let parentMessage = history.messages[parentId];
    let currentParentId = parentMessage ? parentMessage.id : null;
    for (const message of messages) {
      let messageId = v4();
      if (message.role === "user") {
        const userMessage = {
          id: messageId,
          parentId: currentParentId,
          childrenIds: [],
          timestamp: Math.floor(Date.now() / 1e3),
          ...message
        };
        if (parentMessage) {
          parentMessage.childrenIds.push(messageId);
          history.messages[parentMessage.id] = parentMessage;
        }
        history.messages[messageId] = userMessage;
        parentMessage = userMessage;
        currentParentId = messageId;
      } else {
        const responseMessage = {
          id: messageId,
          parentId: currentParentId,
          childrenIds: [],
          done: true,
          model: model.id,
          modelName: model.name ?? model.id,
          modelIdx: 0,
          timestamp: Math.floor(Date.now() / 1e3),
          ...message
        };
        if (parentMessage) {
          parentMessage.childrenIds.push(messageId);
          history.messages[parentMessage.id] = parentMessage;
        }
        history.messages[messageId] = responseMessage;
        parentMessage = responseMessage;
        currentParentId = messageId;
      }
    }
    history.currentId = currentParentId;
    await tick();
    if (autoScroll) {
      scrollToBottom();
    }
    if (messages.length === 0) {
      await initChatHandler(history);
    } else {
      await saveChatHandler($chatId, history);
    }
  };
  const chatCompletionEventHandler = async (data, message, chatId2) => {
    const { id, done, choices, content, sources, selected_model_id, error, usage } = data;
    if (error) {
      await handleOpenAIError(error, message);
    }
    if (sources && !message?.sources) {
      message.sources = sources;
    }
    if (choices) {
      if (choices[0]?.message?.content) {
        message.content += choices[0]?.message?.content;
      } else {
        let value = choices[0]?.delta?.content ?? "";
        if (message.content == "" && value == "\n") {
          /* @__PURE__ */ console.log("Empty response");
        } else {
          message.content += value;
          if (navigator.vibrate && ($settings?.hapticFeedback ?? false)) {
            navigator.vibrate(5);
          }
          const messageContentParts = getMessageContentParts(removeAllDetails(message.content), $config?.audio?.tts?.split_on ?? "punctuation");
          messageContentParts.pop();
          if (messageContentParts.length > 0 && messageContentParts[messageContentParts.length - 1] !== message.lastSentence) {
            message.lastSentence = messageContentParts[messageContentParts.length - 1];
            eventTarget.dispatchEvent(new CustomEvent(
              "chat",
              {
                detail: {
                  id: message.id,
                  content: messageContentParts[messageContentParts.length - 1]
                }
              }
            ));
          }
        }
      }
    }
    if (content) {
      message.content = content;
      if (navigator.vibrate && ($settings?.hapticFeedback ?? false)) {
        navigator.vibrate(5);
      }
      const messageContentParts = getMessageContentParts(removeAllDetails(message.content), $config?.audio?.tts?.split_on ?? "punctuation");
      messageContentParts.pop();
      if (messageContentParts.length > 0 && messageContentParts[messageContentParts.length - 1] !== message.lastSentence) {
        message.lastSentence = messageContentParts[messageContentParts.length - 1];
        eventTarget.dispatchEvent(new CustomEvent(
          "chat",
          {
            detail: {
              id: message.id,
              content: messageContentParts[messageContentParts.length - 1]
            }
          }
        ));
      }
    }
    if (selected_model_id) {
      message.selectedModelId = selected_model_id;
      message.arena = true;
    }
    if (usage) {
      message.usage = usage;
    }
    history.messages[message.id] = message;
    if (done) {
      message.done = true;
      if ($settings.responseAutoCopy) {
        copyToClipboard(message.content);
      }
      if ($settings.responseAutoPlayback && !$showCallOverlay) {
        await tick();
        document.getElementById(`speak-button-${message.id}`)?.click();
      }
      let lastMessageContentPart = getMessageContentParts(removeAllDetails(message.content), $config?.audio?.tts?.split_on ?? "punctuation")?.at(-1) ?? "";
      if (lastMessageContentPart) {
        eventTarget.dispatchEvent(new CustomEvent(
          "chat",
          {
            detail: {
              id: message.id,
              content: lastMessageContentPart
            }
          }
        ));
      }
      eventTarget.dispatchEvent(new CustomEvent(
        "chat:finish",
        {
          detail: { id: message.id, content: message.content }
        }
      ));
      history.messages[message.id] = message;
      await tick();
      if (autoScroll) {
        scrollToBottom();
      }
      await chatCompletedHandler(chatId2, message.model, message.id, createMessagesList(history, message.id));
    }
    /* @__PURE__ */ console.log(data);
    await tick();
    if (autoScroll) {
      scrollToBottom();
    }
  };
  const submitPrompt = async (userPrompt, { _raw = false } = {}) => {
    /* @__PURE__ */ console.log("submitPrompt", userPrompt, $chatId);
    const _selectedModels = selectedModels.map((modelId) => $models.map((m) => m.id).includes(modelId) ? modelId : "");
    if (JSON.stringify(selectedModels) !== JSON.stringify(_selectedModels)) {
      selectedModels = _selectedModels;
    }
    if (userPrompt === "" && files.length === 0) {
      toast.error($i18n.t("Please enter a prompt"));
      return;
    }
    if (selectedModels.includes("")) {
      toast.error($i18n.t("Model not selected"));
      return;
    }
    if (files.length > 0 && files.filter((file) => file.type !== "image" && file.status === "uploading").length > 0) {
      toast.error($i18n.t(`Oops! There are files still uploading. Please wait for the upload to complete.`));
      return;
    }
    if (($config?.file?.max_count ?? null) !== null && files.length + chatFiles.length > $config?.file?.max_count) {
      toast.error($i18n.t(`You can only chat with a maximum of {{maxCount}} file(s) at a time.`, { maxCount: $config?.file?.max_count }));
      return;
    }
    if (history?.currentId) {
      const lastMessage = history.messages[history.currentId];
      if (lastMessage.done != true) {
        return;
      }
      if (lastMessage.error && !lastMessage.content) {
        toast.error($i18n.t(`Oops! There was an error in the previous response.`));
        return;
      }
    }
    messageInput?.setText("");
    prompt = "";
    const messages = createMessagesList(history, history.currentId);
    const _files = JSON.parse(JSON.stringify(files));
    chatFiles.push(..._files.filter((item) => ["doc", "text", "file", "note", "chat", "folder", "collection"].includes(item.type)));
    chatFiles = chatFiles.filter(
      // Remove duplicates
      (item, index, array) => array.findIndex((i) => JSON.stringify(i) === JSON.stringify(item)) === index
    );
    files = [];
    messageInput?.setText("");
    let userMessageId = v4();
    let userMessage = {
      id: userMessageId,
      parentId: messages.length !== 0 ? messages.at(-1).id : null,
      childrenIds: [],
      role: "user",
      content: userPrompt,
      files: _files.length > 0 ? _files : void 0,
      timestamp: Math.floor(Date.now() / 1e3),
      // Unix epoch
      models: selectedModels
    };
    history.messages[userMessageId] = userMessage;
    history.currentId = userMessageId;
    if (messages.length !== 0) {
      history.messages[messages.at(-1).id].childrenIds.push(userMessageId);
    }
    const chatInput = document.getElementById("chat-input");
    chatInput?.focus();
    saveSessionSelectedModels();
    await sendMessage(history, userMessageId, { newChat: true });
  };
  const sendMessage = async (_history, parentId, { messages = null, modelId = null, modelIdx = null, newChat = false } = {}) => {
    if (autoScroll) {
      scrollToBottom();
    }
    let _chatId = JSON.parse(JSON.stringify($chatId));
    _history = JSON.parse(JSON.stringify(_history));
    const responseMessageIds = {};
    let selectedModelIds2 = modelId ? [modelId] : atSelectedModel !== void 0 ? [atSelectedModel.id] : selectedModels;
    for (const [_modelIdx, modelId2] of selectedModelIds2.entries()) {
      const model = $models.filter((m) => m.id === modelId2).at(0);
      if (model) {
        let responseMessageId = v4();
        let responseMessage = {
          parentId,
          id: responseMessageId,
          childrenIds: [],
          role: "assistant",
          content: "",
          model: model.id,
          modelName: model.name ?? model.id,
          modelIdx: modelIdx ? modelIdx : _modelIdx,
          timestamp: Math.floor(Date.now() / 1e3)
        };
        history.messages[responseMessageId] = responseMessage;
        history.currentId = responseMessageId;
        if (parentId !== null && history.messages[parentId]) {
          history.messages[parentId].childrenIds = [...history.messages[parentId].childrenIds, responseMessageId];
        }
        responseMessageIds[`${modelId2}-${modelIdx ? modelIdx : _modelIdx}`] = responseMessageId;
      }
    }
    history = history;
    if (newChat && _history.messages[_history.currentId].parentId === null) {
      _chatId = await initChatHandler(_history);
    }
    await tick();
    _history = JSON.parse(JSON.stringify(history));
    await saveChatHandler(_chatId, _history);
    await Promise.all(selectedModelIds2.map(async (modelId2, _modelIdx) => {
      /* @__PURE__ */ console.log("modelId", modelId2);
      const model = $models.filter((m) => m.id === modelId2).at(0);
      if (model) {
        const hasImages = createMessagesList(_history, parentId).some((message) => message.files?.some((file) => file.type === "image"));
        if (hasImages && !(model.info?.meta?.capabilities?.vision ?? true)) {
          toast.error($i18n.t("Model {{modelName}} is not vision capable", { modelName: model.name ?? model.id }));
        }
        let responseMessageId = responseMessageIds[`${modelId2}-${modelIdx ? modelIdx : _modelIdx}`];
        const chatEventEmitter = await getChatEventEmitter(model.id, _chatId);
        scrollToBottom();
        await sendMessageSocket(
          model,
          messages && messages.length > 0 ? messages : createMessagesList(_history, responseMessageId),
          _history,
          responseMessageId
        );
        if (chatEventEmitter) clearInterval(chatEventEmitter);
      } else {
        toast.error($i18n.t(`Model {{modelId}} not found`, { modelId: modelId2 }));
      }
    }));
    currentChatPage.set(1);
    chats.set(await getChatList(localStorage.token, $currentChatPage));
  };
  const getFeatures = () => {
    let features = {};
    if ($config?.features) features = {
      image_generation: $config?.features?.enable_image_generation && ($user?.role === "admin" || $user?.permissions?.features?.image_generation) ? imageGenerationEnabled : false,
      code_interpreter: $config?.features?.enable_code_interpreter && ($user?.role === "admin" || $user?.permissions?.features?.code_interpreter) ? codeInterpreterEnabled : false,
      web_search: $config?.features?.enable_web_search && ($user?.role === "admin" || $user?.permissions?.features?.web_search) ? webSearchEnabled : false
    };
    const currentModels = atSelectedModel?.id ? [atSelectedModel.id] : selectedModels;
    if (currentModels.filter((model) => $models.find((m) => m.id === model)?.info?.meta?.capabilities?.web_search ?? true).length === currentModels.length) {
      if ($config?.features?.enable_web_search && ($settings?.webSearch ?? false) === "always") {
        features = { ...features, web_search: true };
      }
    }
    if ($settings?.memory ?? false) {
      features = { ...features, memory: true };
    }
    return features;
  };
  const sendMessageSocket = async (model, _messages, _history, responseMessageId, _chatId) => {
    const responseMessage = _history.messages[responseMessageId];
    const userMessage = _history.messages[responseMessage.parentId];
    const chatMessageFiles = _messages.filter((message) => message.files).flatMap((message) => message.files);
    chatFiles = chatFiles.filter((item) => {
      const fileExists = chatMessageFiles.some((messageFile) => messageFile.id === item.id);
      return fileExists;
    });
    let files2 = JSON.parse(JSON.stringify(chatFiles));
    files2.push(...(userMessage?.files ?? []).filter((item) => ["doc", "text", "file", "note", "chat", "collection"].includes(item.type)));
    files2 = files2.filter((item, index, array) => array.findIndex((i) => JSON.stringify(i) === JSON.stringify(item)) === index);
    scrollToBottom();
    eventTarget.dispatchEvent(new CustomEvent("chat:start", { detail: { id: responseMessageId } }));
    await tick();
    let userLocation;
    if ($settings?.userLocation) {
      userLocation = await getAndUpdateUserLocation(localStorage.token).catch((err) => {
        /* @__PURE__ */ console.error(err);
        return void 0;
      });
    }
    const stream = model?.info?.params?.stream_response ?? $settings?.params?.stream_response ?? params?.stream_response ?? true;
    let messages = [
      params?.system || $settings.system ? {
        role: "system",
        content: `${params?.system ?? $settings?.system ?? ""}`
      } : void 0,
      ..._messages.map((message) => ({
        ...message,
        content: processDetails(message.content)
      }))
    ].filter((message) => message);
    messages = messages.map((message, idx, arr) => ({
      role: message.role,
      ...message.files?.filter((file) => file.type === "image").length > 0 && message.role === "user" ? {
        content: [
          {
            type: "text",
            text: message?.merged?.content ?? message.content
          },
          ...message.files.filter((file) => file.type === "image").map((file) => ({
            type: "image_url",
            image_url: { url: file.url }
          }))
        ]
      } : {
        content: message?.merged?.content ?? message.content
      }
    })).filter((message) => message?.role === "user" || message?.content?.trim());
    const toolIds = [];
    const toolServerIds = [];
    for (const toolId of selectedToolIds) {
      if (toolId.startsWith("direct_server:")) {
        let serverId = toolId.replace("direct_server:", "");
        if (!isNaN(parseInt(serverId))) {
          toolServerIds.push(parseInt(serverId));
        } else {
          toolServerIds.push(serverId);
        }
      } else {
        toolIds.push(toolId);
      }
    }
    const res = await generateOpenAIChatCompletion(
      localStorage.token,
      {
        stream,
        model: model.id,
        messages,
        params: {
          ...$settings?.params,
          ...params,
          stop: params?.stop ?? $settings?.params?.stop ?? void 0 ? (params?.stop.split(",").map((token2) => token2.trim()) ?? $settings.params.stop).map((str) => decodeURIComponent(JSON.parse('"' + str.replace(/\"/g, '\\"') + '"'))) : void 0
        },
        files: (files2?.length ?? 0) > 0 ? files2 : void 0,
        filter_ids: selectedFilterIds.length > 0 ? selectedFilterIds : void 0,
        tool_ids: toolIds.length > 0 ? toolIds : void 0,
        tool_servers: ($toolServers ?? []).filter((server, idx) => toolServerIds.includes(idx) || toolServerIds.includes(server?.id)),
        features: getFeatures(),
        variables: {
          ...getPromptVariables($user?.name, $settings?.userLocation ? userLocation : void 0)
        },
        model_item: $models.find((m) => m.id === model.id),
        session_id: $socket?.id,
        chat_id: $chatId,
        id: responseMessageId,
        background_tasks: {
          ...!$temporaryChatEnabled && (messages.length == 1 || messages.length == 2 && messages.at(0)?.role === "system" && messages.at(1)?.role === "user") && (selectedModels[0] === model.id || atSelectedModel !== void 0) ? {
            title_generation: $settings?.title?.auto ?? true,
            tags_generation: $settings?.autoTags ?? true
          } : {},
          follow_up_generation: $settings?.autoFollowUps ?? true
        },
        ...stream && (model.info?.meta?.capabilities?.usage ?? false) ? { stream_options: { include_usage: true } } : {}
      },
      `${WEBUI_BASE_URL}/api`
    ).catch(async (error) => {
      /* @__PURE__ */ console.log(error);
      let errorMessage = error;
      if (error?.error?.message) {
        errorMessage = error.error.message;
      } else if (error?.message) {
        errorMessage = error.message;
      }
      if (typeof errorMessage === "object") {
        errorMessage = $i18n.t(`Uh-oh! There was an issue with the response.`);
      }
      toast.error(`${errorMessage}`);
      responseMessage.error = { content: error };
      responseMessage.done = true;
      history.messages[responseMessageId] = responseMessage;
      history.currentId = responseMessageId;
      return null;
    });
    if (res) {
      if (res.error) {
        await handleOpenAIError(res.error, responseMessage);
      } else {
        if (taskIds) {
          taskIds.push(res.task_id);
        } else {
          taskIds = [res.task_id];
        }
      }
    }
    await tick();
    scrollToBottom();
  };
  const handleOpenAIError = async (error, responseMessage) => {
    let errorMessage = "";
    let innerError;
    if (error) {
      innerError = error;
    }
    /* @__PURE__ */ console.error(innerError);
    if ("detail" in innerError) {
      toast.error(innerError.detail);
      errorMessage = innerError.detail;
    } else if ("error" in innerError) {
      if ("message" in innerError.error) {
        toast.error(innerError.error.message);
        errorMessage = innerError.error.message;
      } else {
        toast.error(innerError.error);
        errorMessage = innerError.error;
      }
    } else if ("message" in innerError) {
      toast.error(innerError.message);
      errorMessage = innerError.message;
    }
    responseMessage.error = {
      content: $i18n.t(`Uh-oh! There was an issue with the response.`) + "\n" + errorMessage
    };
    responseMessage.done = true;
    if (responseMessage.statusHistory) {
      responseMessage.statusHistory = responseMessage.statusHistory.filter((status) => status.action !== "knowledge_search");
    }
    history.messages[responseMessage.id] = responseMessage;
  };
  const stopResponse = async () => {
    if (taskIds) {
      for (const taskId of taskIds) {
        await stopTask(localStorage.token, taskId).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
      }
      taskIds = null;
      const responseMessage = history.messages[history.currentId];
      for (const messageId of history.messages[responseMessage.parentId].childrenIds) {
        history.messages[messageId].done = true;
      }
      history.messages[history.currentId] = responseMessage;
      if (autoScroll) {
        scrollToBottom();
      }
    }
    if (generating) {
      generating = false;
      generationController?.abort();
      generationController = null;
    }
  };
  const submitMessage = async (parentId, prompt2) => {
    let userPrompt = prompt2;
    let userMessageId = v4();
    let userMessage = {
      id: userMessageId,
      parentId,
      childrenIds: [],
      role: "user",
      content: userPrompt,
      models: selectedModels,
      timestamp: Math.floor(Date.now() / 1e3)
    };
    if (parentId !== null) {
      history.messages[parentId].childrenIds = [...history.messages[parentId].childrenIds, userMessageId];
    }
    history.messages[userMessageId] = userMessage;
    history.currentId = userMessageId;
    await tick();
    if (autoScroll) {
      scrollToBottom();
    }
    await sendMessage(history, userMessageId);
  };
  const regenerateResponse = async (message, suggestionPrompt = null) => {
    /* @__PURE__ */ console.log("regenerateResponse");
    if (history.currentId) {
      let userMessage = history.messages[message.parentId];
      if (autoScroll) {
        scrollToBottom();
      }
      await sendMessage(history, userMessage.id, {
        ...suggestionPrompt ? {
          messages: [
            ...createMessagesList(history, message.id),
            { role: "user", content: suggestionPrompt }
          ]
        } : {},
        ...(userMessage?.models ?? [...selectedModels]).length > 1 ? {
          // If multiple models are selected, use the model from the message
          modelId: message.model,
          modelIdx: message.modelIdx
        } : {}
      });
    }
  };
  const continueResponse = async () => {
    /* @__PURE__ */ console.log("continueResponse");
    JSON.parse(JSON.stringify($chatId));
    if (history.currentId && history.messages[history.currentId].done == true) {
      const responseMessage = history.messages[history.currentId];
      responseMessage.done = false;
      await tick();
      const model = $models.filter((m) => m.id === (responseMessage?.selectedModelId ?? responseMessage.model)).at(0);
      if (model) {
        await sendMessageSocket(model, createMessagesList(history, responseMessage.id), history, responseMessage.id);
      }
    }
  };
  const mergeResponses = async (messageId, responses, _chatId) => {
    /* @__PURE__ */ console.log("mergeResponses", messageId, responses);
    const message = history.messages[messageId];
    const mergedResponse = { status: true, content: "" };
    message.merged = mergedResponse;
    history.messages[messageId] = message;
    try {
      generating = true;
      const [res, controller] = await generateMoACompletion(localStorage.token, message.model, history.messages[message.parentId].content, responses);
      if (res && res.ok && res.body && generating) {
        generationController = controller;
        const textStream = await createOpenAITextStream(res.body, $settings.splitLargeChunks);
        for await (const update of textStream) {
          const { value, done, sources, error, usage } = update;
          if (error || done) {
            generating = false;
            generationController = null;
            break;
          }
          if (mergedResponse.content == "" && value == "\n") {
            continue;
          } else {
            mergedResponse.content += value;
            history.messages[messageId] = message;
          }
          if (autoScroll) {
            scrollToBottom();
          }
        }
        await saveChatHandler(_chatId, history);
      } else {
        /* @__PURE__ */ console.error(res);
      }
    } catch (e) {
      /* @__PURE__ */ console.error(e);
    }
  };
  const initChatHandler = async (history2) => {
    let _chatId = $chatId;
    if (!$temporaryChatEnabled) {
      chat = await createNewChat(
        localStorage.token,
        {
          id: _chatId,
          title: $i18n.t("New Chat"),
          models: selectedModels,
          system: $settings.system ?? void 0,
          params,
          history: history2,
          messages: createMessagesList(history2, history2.currentId),
          tags: [],
          timestamp: Date.now()
        },
        $selectedFolder?.id
      );
      _chatId = chat.id;
      await chatId.set(_chatId);
      window.history.replaceState(history2.state, "", `/c/${_chatId}`);
      await tick();
      await chats.set(await getChatList(localStorage.token, $currentChatPage));
      currentChatPage.set(1);
      selectedFolder.set(null);
    } else {
      _chatId = `local:${$socket?.id}`;
      await chatId.set(_chatId);
    }
    await tick();
    return _chatId;
  };
  const saveChatHandler = async (_chatId, history2) => {
    if ($chatId == _chatId) {
      if (!$temporaryChatEnabled) {
        chat = await updateChatById(localStorage.token, _chatId, {
          models: selectedModels,
          history: history2,
          messages: createMessagesList(history2, history2.currentId),
          params,
          files: chatFiles
        });
        currentChatPage.set(1);
        await chats.set(await getChatList(localStorage.token, $currentChatPage));
      }
    }
  };
  let saveDraftTimeout = null;
  const saveDraft = async (draft, chatId2 = null) => {
    if (saveDraftTimeout) {
      clearTimeout(saveDraftTimeout);
    }
    if (draft.prompt !== null && draft.prompt.length < MAX_DRAFT_LENGTH) {
      saveDraftTimeout = setTimeout(
        async () => {
          await sessionStorage.setItem(`chat-input${chatId2 ? `-${chatId2}` : ""}`, JSON.stringify(draft));
        },
        500
      );
    } else {
      sessionStorage.removeItem(`chat-input${chatId2 ? `-${chatId2}` : ""}`);
    }
  };
  const moveChatHandler = async (chatId2, folderId) => {
    if (chatId2 && folderId) {
      const res = await updateChatFolderIdById(localStorage.token, chatId2, folderId).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      if (res) {
        currentChatPage.set(1);
        await chats.set(await getChatList(localStorage.token, $currentChatPage));
        await pinnedChats.set(await getPinnedChatList(localStorage.token));
        toast.success($i18n.t("Chat moved successfully"));
      }
    } else {
      toast.error($i18n.t("Failed to move chat"));
    }
  };
  if ($$props.chatIdProp === void 0 && $$bindings.chatIdProp && chatIdProp !== void 0) $$bindings.chatIdProp(chatIdProp);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    selectedModelIds = atSelectedModel !== void 0 ? [atSelectedModel.id] : selectedModels;
    {
      if (chatIdProp) {
        navigateHandler();
      }
    }
    {
      if (selectedModels && chatIdProp !== "") {
        saveSessionSelectedModels();
      }
    }
    {
      if (JSON.stringify(selectedModelIds) !== JSON.stringify(oldSelectedModelIds)) {
        onSelectedModelIdsChange();
      }
    }
    {
      if (selectedModels !== null) {
        savedModelIds();
      }
    }
    $$rendered = `${$$result.head += `<!-- HEAD_svelte-mbrmpu_START -->${$$result.title = `<title> ${escape($settings.showChatTitleInTab !== false && $chatTitle ? `${$chatTitle.length > 30 ? `${$chatTitle.slice(0, 30)}...` : $chatTitle} • ${$WEBUI_NAME}` : `${$WEBUI_NAME}`)} </title>`, ""}<!-- HEAD_svelte-mbrmpu_END -->`, ""} <audio id="audioElement" src="" style="display: none;"></audio> ${validate_component(ConfirmDialog, "EventConfirmDialog").$$render(
      $$result,
      {
        title: eventConfirmationTitle,
        message: eventConfirmationMessage,
        input: eventConfirmationInput,
        inputPlaceholder: eventConfirmationInputPlaceholder,
        inputValue: eventConfirmationInputValue,
        show: showEventConfirmation
      },
      {
        show: ($$value) => {
          showEventConfirmation = $$value;
          $$settled = false;
        }
      },
      {}
    )} <div class="${"h-screen max-h-[100dvh] transition-width duration-200 ease-in-out " + escape($showSidebar ? "  md:max-w-[calc(100%-260px)]" : " ", true) + " w-full max-w-full flex flex-col"}" id="chat-container">${!loading ? `<div class="w-full h-full flex flex-col">${$selectedFolder && $selectedFolder?.meta?.background_image_url ? `<div class="${"absolute " + escape(
      $showSidebar ? "md:max-w-[calc(100%-260px)] md:translate-x-[260px]" : "",
      true
    ) + " top-0 left-0 w-full h-full bg-cover bg-center bg-no-repeat"}" style="${"background-image: url(" + escape($selectedFolder?.meta?.background_image_url, true) + ")"}"></div> <div class="absolute top-0 left-0 w-full h-full bg-linear-to-t from-white to-white/85 dark:from-gray-900 dark:to-gray-900/90 z-0"></div>` : `${$settings?.backgroundImageUrl ?? $config?.license_metadata?.background_image_url ?? null ? `<div class="${"absolute " + escape(
      $showSidebar ? "md:max-w-[calc(100%-260px)] md:translate-x-[260px]" : "",
      true
    ) + " top-0 left-0 w-full h-full bg-cover bg-center bg-no-repeat"}" style="${"background-image: url(" + escape($settings?.backgroundImageUrl ?? $config?.license_metadata?.background_image_url, true) + ")"}"></div> <div class="absolute top-0 left-0 w-full h-full bg-linear-to-t from-white to-white/85 dark:from-gray-900 dark:to-gray-900/90 z-0"></div>` : ``}`} ${validate_component(Pane_group, "PaneGroup").$$render(
      $$result,
      {
        direction: "horizontal",
        class: "w-full h-full"
      },
      {},
      {
        default: () => {
          return `${validate_component(Pane, "Pane").$$render(
            $$result,
            {
              defaultSize: 50,
              minSize: 30,
              class: "h-full flex relative max-w-full flex-col"
            },
            {},
            {
              default: () => {
                return `${validate_component(Navbar, "Navbar").$$render(
                  $$result,
                  {
                    chat: {
                      id: $chatId,
                      chat: {
                        title: $chatTitle,
                        models: selectedModels,
                        system: $settings.system ?? void 0,
                        params,
                        history,
                        timestamp: Date.now()
                      }
                    },
                    history,
                    title: $chatTitle,
                    shareEnabled: !!history.currentId,
                    initNewChat,
                    archiveChatHandler: () => {
                    },
                    moveChatHandler,
                    onSaveTempChat: async () => {
                      try {
                        if (!history?.currentId || !Object.keys(history.messages).length) {
                          toast.error($i18n.t("No conversation to save"));
                          return;
                        }
                        const messages = createMessagesList(history, history.currentId);
                        const title = messages.find((m) => m.role === "user")?.content ?? $i18n.t("New Chat");
                        const savedChat = await createNewChat(
                          localStorage.token,
                          {
                            id: v4(),
                            title: title.length > 50 ? `${title.slice(0, 50)}...` : title,
                            models: selectedModels,
                            history,
                            messages,
                            timestamp: Date.now()
                          },
                          null
                        );
                        if (savedChat) {
                          temporaryChatEnabled.set(false);
                          chatId.set(savedChat.id);
                          chats.set(await getChatList(localStorage.token, $currentChatPage));
                          await goto(`/c/${savedChat.id}`);
                          toast.success($i18n.t("Conversation saved successfully"));
                        }
                      } catch (error) {
                        /* @__PURE__ */ console.error("Error saving conversation:", error);
                        toast.error($i18n.t("Failed to save conversation"));
                      }
                    },
                    this: navbarElement,
                    selectedModels
                  },
                  {
                    this: ($$value) => {
                      navbarElement = $$value;
                      $$settled = false;
                    },
                    selectedModels: ($$value) => {
                      selectedModels = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )} <div class="flex flex-col flex-auto z-10 w-full @container overflow-auto">${$settings?.landingPageMode === "chat" && !$selectedFolder || createMessagesList(history, history.currentId).length > 0 ? `<div class="pb-2.5 flex flex-col justify-between w-full flex-auto overflow-auto h-0 max-w-full z-10 scrollbar-hidden" id="messages-container"${add_attribute("this", messagesContainerElement, 0)}><div class="h-full w-full flex flex-col">${validate_component(Messages, "Messages").$$render(
                  $$result,
                  {
                    chatId: $chatId,
                    setInputText: (text) => {
                      messageInput?.setText(text);
                    },
                    selectedModels,
                    atSelectedModel,
                    sendMessage,
                    showMessage,
                    submitMessage,
                    continueResponse,
                    regenerateResponse,
                    mergeResponses,
                    chatActionHandler,
                    addMessages,
                    topPadding: true,
                    bottomPadding: files.length > 0,
                    onSelect,
                    history,
                    autoScroll,
                    prompt
                  },
                  {
                    history: ($$value) => {
                      history = $$value;
                      $$settled = false;
                    },
                    autoScroll: ($$value) => {
                      autoScroll = $$value;
                      $$settled = false;
                    },
                    prompt: ($$value) => {
                      prompt = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}</div></div> <div class="pb-2">${validate_component(MessageInput, "MessageInput").$$render(
                  $$result,
                  {
                    history,
                    taskIds,
                    selectedModels,
                    toolServers: $toolServers,
                    generating,
                    stopResponse,
                    createMessagePair,
                    onChange: (data) => {
                      if (!$temporaryChatEnabled) {
                        saveDraft(data, $chatId);
                      }
                    },
                    this: messageInput,
                    files,
                    prompt,
                    autoScroll,
                    selectedToolIds,
                    selectedFilterIds,
                    imageGenerationEnabled,
                    codeInterpreterEnabled,
                    webSearchEnabled,
                    atSelectedModel,
                    showCommands
                  },
                  {
                    this: ($$value) => {
                      messageInput = $$value;
                      $$settled = false;
                    },
                    files: ($$value) => {
                      files = $$value;
                      $$settled = false;
                    },
                    prompt: ($$value) => {
                      prompt = $$value;
                      $$settled = false;
                    },
                    autoScroll: ($$value) => {
                      autoScroll = $$value;
                      $$settled = false;
                    },
                    selectedToolIds: ($$value) => {
                      selectedToolIds = $$value;
                      $$settled = false;
                    },
                    selectedFilterIds: ($$value) => {
                      selectedFilterIds = $$value;
                      $$settled = false;
                    },
                    imageGenerationEnabled: ($$value) => {
                      imageGenerationEnabled = $$value;
                      $$settled = false;
                    },
                    codeInterpreterEnabled: ($$value) => {
                      codeInterpreterEnabled = $$value;
                      $$settled = false;
                    },
                    webSearchEnabled: ($$value) => {
                      webSearchEnabled = $$value;
                      $$settled = false;
                    },
                    atSelectedModel: ($$value) => {
                      atSelectedModel = $$value;
                      $$settled = false;
                    },
                    showCommands: ($$value) => {
                      showCommands = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )} <div class="absolute bottom-1 text-xs text-gray-500 text-center line-clamp-1 right-0 left-0" data-svelte-h="svelte-ko82kn"></div></div>` : `<div class="flex items-center h-full">${validate_component(Placeholder, "Placeholder").$$render(
                  $$result,
                  {
                    history,
                    selectedModels,
                    toolServers: $toolServers,
                    stopResponse,
                    createMessagePair,
                    onSelect,
                    onChange: (data) => {
                      if (!$temporaryChatEnabled) {
                        saveDraft(data);
                      }
                    },
                    messageInput,
                    files,
                    prompt,
                    autoScroll,
                    selectedToolIds,
                    selectedFilterIds,
                    imageGenerationEnabled,
                    codeInterpreterEnabled,
                    webSearchEnabled,
                    atSelectedModel,
                    showCommands
                  },
                  {
                    messageInput: ($$value) => {
                      messageInput = $$value;
                      $$settled = false;
                    },
                    files: ($$value) => {
                      files = $$value;
                      $$settled = false;
                    },
                    prompt: ($$value) => {
                      prompt = $$value;
                      $$settled = false;
                    },
                    autoScroll: ($$value) => {
                      autoScroll = $$value;
                      $$settled = false;
                    },
                    selectedToolIds: ($$value) => {
                      selectedToolIds = $$value;
                      $$settled = false;
                    },
                    selectedFilterIds: ($$value) => {
                      selectedFilterIds = $$value;
                      $$settled = false;
                    },
                    imageGenerationEnabled: ($$value) => {
                      imageGenerationEnabled = $$value;
                      $$settled = false;
                    },
                    codeInterpreterEnabled: ($$value) => {
                      codeInterpreterEnabled = $$value;
                      $$settled = false;
                    },
                    webSearchEnabled: ($$value) => {
                      webSearchEnabled = $$value;
                      $$settled = false;
                    },
                    atSelectedModel: ($$value) => {
                      atSelectedModel = $$value;
                      $$settled = false;
                    },
                    showCommands: ($$value) => {
                      showCommands = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}</div>`}</div>`;
              }
            }
          )} ${validate_component(ChatControls, "ChatControls").$$render(
            $$result,
            {
              chatId: $chatId,
              modelId: selectedModelIds?.at(0) ?? null,
              models: selectedModelIds.reduce(
                (a, e, i, arr) => {
                  const model = $models.find((m) => m.id === e);
                  if (model) {
                    return [...a, model];
                  }
                  return a;
                },
                []
              ),
              submitPrompt,
              stopResponse,
              showMessage,
              eventTarget,
              this: controlPaneComponent,
              history,
              chatFiles,
              params,
              files,
              pane: controlPane
            },
            {
              this: ($$value) => {
                controlPaneComponent = $$value;
                $$settled = false;
              },
              history: ($$value) => {
                history = $$value;
                $$settled = false;
              },
              chatFiles: ($$value) => {
                chatFiles = $$value;
                $$settled = false;
              },
              params: ($$value) => {
                params = $$value;
                $$settled = false;
              },
              files: ($$value) => {
                files = $$value;
                $$settled = false;
              },
              pane: ($$value) => {
                controlPane = $$value;
                $$settled = false;
              }
            },
            {}
          )}`;
        }
      }
    )}</div>` : `${loading ? `<div class="flex items-center justify-center h-full w-full"><div class="m-auto">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</div></div>` : ``}`}</div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_currentChatPage();
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe_chatId();
  $$unsubscribe_socket();
  $$unsubscribe_selectedFolder();
  $$unsubscribe_settings();
  $$unsubscribe_models();
  $$unsubscribe_user();
  $$unsubscribe_toolServers();
  $$unsubscribe_config();
  $$unsubscribe_showCallOverlay();
  $$unsubscribe_page();
  $$unsubscribe_mobile();
  $$unsubscribe_tools();
  $$unsubscribe_functions();
  $$unsubscribe_chatTitle();
  $$unsubscribe_WEBUI_NAME();
  $$unsubscribe_showSidebar();
  return $$rendered;
});
export {
  Chat as C
};
//# sourceMappingURL=Chat.js.map
