import { c as create_ssr_component, b as subscribe, l as getContext, g as escape, v as validate_component } from "../../../../chunks/ssr.js";
import { W as WEBUI_NAME, n as showSidebar, m as mobile } from "../../../../chunks/index.js";
import { p as page } from "../../../../chunks/stores.js";
import { T as Tooltip } from "../../../../chunks/Tooltip.js";
import { S as Sidebar } from "../../../../chunks/Sidebar.js";
const Layout = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $WEBUI_NAME, $$unsubscribe_WEBUI_NAME;
  let $showSidebar, $$unsubscribe_showSidebar;
  let $mobile, $$unsubscribe_mobile;
  let $page, $$unsubscribe_page;
  $$unsubscribe_WEBUI_NAME = subscribe(WEBUI_NAME, (value) => $WEBUI_NAME = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_page = subscribe(page, (value) => $page = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  $$unsubscribe_i18n();
  $$unsubscribe_WEBUI_NAME();
  $$unsubscribe_showSidebar();
  $$unsubscribe_mobile();
  $$unsubscribe_page();
  return `${$$result.head += `<!-- HEAD_svelte-1d6dk9z_START -->${$$result.title = `<title> ${escape($i18n.t("Playground"))} • ${escape($WEBUI_NAME)} </title>`, ""}<!-- HEAD_svelte-1d6dk9z_END -->`, ""} <div class="${"flex flex-col w-full h-screen max-h-[100dvh] transition-width duration-200 ease-in-out " + escape($showSidebar ? "md:max-w-[calc(100%-260px)]" : "", true) + " max-w-full"}"><nav class="px-2.5 pt-1.5 backdrop-blur-xl w-full drag-region"><div class="flex items-center">${$mobile ? `<div class="${escape($showSidebar ? "md:hidden" : "", true) + " flex flex-none items-center self-end"}">${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      content: $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar"),
      interactive: true
    },
    {},
    {
      default: () => {
        return `<button id="sidebar-toggle-button" class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition cursor-"><div class="self-center p-1.5">${validate_component(Sidebar, "Sidebar").$$render($$result, {}, {}, {})}</div></button>`;
      }
    }
  )}</div>` : ``} <div class="flex w-full"><div class="flex gap-1 scrollbar-none overflow-x-auto w-fit text-center text-sm font-medium rounded-full bg-transparent pt-1"><a class="${"min-w-fit p-1.5 " + escape(
    ["/playground", "/playground/"].includes($page.url.pathname) ? "" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white",
    true
  ) + " transition"}" href="/playground">${escape($i18n.t("Chat"))}</a>  <a class="${"min-w-fit p-1.5 " + escape(
    $page.url.pathname.includes("/playground/completions") ? "" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white",
    true
  ) + " transition"}" href="/playground/completions">${escape($i18n.t("Completions"))}</a></div></div></div></nav> <div class="flex-1 max-h-full overflow-y-auto">${slots.default ? slots.default({}) : ``}</div></div>`;
});
export {
  Layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
