import { c as create_ssr_component, a as add_attribute, b as subscribe, l as getContext, o as onDestroy, g as escape, v as validate_component, e as each, p as createEventDispatcher } from "../../../../../chunks/ssr.js";
import { p as page } from "../../../../../chunks/stores.js";
import { a as settings, c as config, q as models, h as WEBUI_BASE_URL, s as socket, W as WEBUI_NAME, m as mobile, n as showSidebar, u as user, D as WEBUI_API_BASE_URL } from "../../../../../chunks/index.js";
import { t as tick } from "../../../../../chunks/ssr2.js";
import { v4 } from "uuid";
import fileSaver from "file-saver";
import { marked } from "marked";
import { a as toast } from "../../../../../chunks/Toaster.svelte_svelte_type_style_lang.js";
import { g as goto } from "../../../../../chunks/client.js";
import dayjs from "dayjs";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import calendar from "dayjs/plugin/calendar.js";
import duration from "dayjs/plugin/duration.js";
import relativeTime from "dayjs/plugin/relativeTime.js";
import { D as Drawer, P as Pane, a as Pane_group } from "../../../../../chunks/Drawer.js";
import { o as blobToFile, x as splitStream, a as copyToClipboard, l as convertHeicToJpeg, n as compressImage } from "../../../../../chunks/index2.js";
import { u as uploadFile } from "../../../../../chunks/index12.js";
import { c as chatCompletion } from "../../../../../chunks/index10.js";
import { t as transcribeAudio, P as Pane_resizer } from "../../../../../chunks/pane-resizer.js";
import { X as XMark } from "../../../../../chunks/XMark.js";
import { I as Image, M as Markdown } from "../../../../../chunks/Collapsible.js";
import "panzoom";
import "dompurify";
import "dequal";
import "../../../../../chunks/create.js";
import { a as FileItem, S as Skeleton } from "../../../../../chunks/FileItem.js";
import { P as Pencil } from "../../../../../chunks/Pencil.js";
import { T as Textarea } from "../../../../../chunks/Textarea.js";
import { T as Tooltip } from "../../../../../chunks/Tooltip.js";
import { M as MessageInput } from "../../../../../chunks/MessageInput.js";
import { D as DocumentDuplicate, P as PencilSquare } from "../../../../../chunks/PencilSquare.js";
import { A as AccessControlModal } from "../../../../../chunks/AccessControlModal.js";
import { a as getNoteById, u as updateNoteById } from "../../../../../chunks/index13.js";
import { R as RichTextInput, M as MicSolid } from "../../../../../chunks/MicSolid.js";
import { S as Spinner } from "../../../../../chunks/Spinner.js";
import localizedFormat from "dayjs/plugin/localizedFormat.js";
import "../../../../../chunks/Drawer.svelte_svelte_type_style_lang.js";
import { C as ConfirmDialog } from "../../../../../chunks/ConfirmDialog.js";
/* empty css                                                        */
import { F as FilesOverlay } from "../../../../../chunks/FilesOverlay.js";
import { b as Menu, c as Menu_trigger, M as Menu_content, a as Menu_item } from "../../../../../chunks/menu-trigger.js";
import { f as fade } from "../../../../../chunks/index14.js";
import { M as Menu_sub, a as Menu_sub_trigger, b as Menu_sub_content, S as Share } from "../../../../../chunks/Share.js";
import { f as flyAndScale } from "../../../../../chunks/index4.js";
import { D as Download } from "../../../../../chunks/Download.js";
import { G as GarbageBin } from "../../../../../chunks/GarbageBin.js";
import { L as Link } from "../../../../../chunks/Link.js";
import { E as EllipsisHorizontal } from "../../../../../chunks/EllipsisHorizontal.js";
import { S as Sidebar } from "../../../../../chunks/Sidebar.js";
import { S as Sparkles } from "../../../../../chunks/Sparkles.js";
const ChatBubbleOval = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor" aria-hidden="true"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M12 20.25c4.97 0 9-3.694 9-8.25s-4.03-8.25-9-8.25S3 7.444 3 12c0 2.104.859 4.023 2.273 5.48.432.447.74 1.04.586 1.641a4.483 4.483 0 0 1-.923 1.785A5.969 5.969 0 0 0 6 21c1.282 0 2.47-.402 3.445-1.087.81.22 1.668.337 2.555.337Z"></path></svg>`;
});
const css = {
  code: ".visualizer.svelte-156uiqn{display:flex;height:100%}.visualizer-bar.svelte-156uiqn{width:2px;background-color:#4a5aba}",
  map: '{"version":3,"file":"VoiceRecording.svelte","sources":["VoiceRecording.svelte"],"sourcesContent":["<script lang=\\"ts\\">import { toast } from \\"svelte-sonner\\";\\nimport { tick, getContext, onMount, onDestroy } from \\"svelte\\";\\nimport { config, settings } from \\"$lib/stores\\";\\nimport { blobToFile, calculateSHA256, extractCurlyBraceWords } from \\"$lib/utils\\";\\nimport { transcribeAudio } from \\"$lib/apis/audio\\";\\nimport XMark from \\"$lib/components/icons/XMark.svelte\\";\\nimport dayjs from \\"dayjs\\";\\nimport LocalizedFormat from \\"dayjs/plugin/localizedFormat\\";\\ndayjs.extend(LocalizedFormat);\\nconst i18n = getContext(\\"i18n\\");\\nexport let recording = false;\\nexport let transcribe = true;\\nexport let displayMedia = false;\\nexport let echoCancellation = true;\\nexport let noiseSuppression = true;\\nexport let autoGainControl = true;\\nexport let className = \\" p-2.5 w-full max-w-full\\";\\nexport let onCancel = () => {\\n};\\nexport let onConfirm = (data) => {\\n};\\nlet loading = false;\\nlet confirmed = false;\\nlet durationSeconds = 0;\\nlet durationCounter = null;\\nlet transcription = \\"\\";\\nconst startDurationCounter = () => {\\n  durationCounter = setInterval(() => {\\n    durationSeconds++;\\n  }, 1e3);\\n};\\nconst stopDurationCounter = () => {\\n  clearInterval(durationCounter);\\n  durationSeconds = 0;\\n};\\n$: if (recording) {\\n  startRecording();\\n} else {\\n  stopRecording();\\n}\\nconst formatSeconds = (seconds) => {\\n  const minutes = Math.floor(seconds / 60);\\n  const remainingSeconds = seconds % 60;\\n  const formattedSeconds = remainingSeconds < 10 ? `0${remainingSeconds}` : remainingSeconds;\\n  return `${minutes}:${formattedSeconds}`;\\n};\\nlet stream;\\nlet speechRecognition;\\nlet mediaRecorder;\\nlet audioChunks = [];\\nconst MIN_DECIBELS = -45;\\nlet VISUALIZER_BUFFER_LENGTH = 300;\\nlet visualizerData = Array(VISUALIZER_BUFFER_LENGTH).fill(0);\\nconst calculateRMS = (data) => {\\n  let sumSquares = 0;\\n  for (let i = 0; i < data.length; i++) {\\n    const normalizedValue = (data[i] - 128) / 128;\\n    sumSquares += normalizedValue * normalizedValue;\\n  }\\n  return Math.sqrt(sumSquares / data.length);\\n};\\nconst normalizeRMS = (rms) => {\\n  rms = rms * 10;\\n  const exp = 1.5;\\n  const scaledRMS = Math.pow(rms, exp);\\n  return Math.min(1, Math.max(0.01, scaledRMS));\\n};\\nconst analyseAudio = (stream2) => {\\n  const audioContext = new AudioContext();\\n  const audioStreamSource = audioContext.createMediaStreamSource(stream2);\\n  const analyser = audioContext.createAnalyser();\\n  analyser.minDecibels = MIN_DECIBELS;\\n  audioStreamSource.connect(analyser);\\n  const bufferLength = analyser.frequencyBinCount;\\n  const domainData = new Uint8Array(bufferLength);\\n  const timeDomainData = new Uint8Array(analyser.fftSize);\\n  let lastSoundTime = Date.now();\\n  const detectSound = () => {\\n    const processFrame = () => {\\n      if (!recording || loading) return;\\n      if (recording && !loading) {\\n        analyser.getByteTimeDomainData(timeDomainData);\\n        analyser.getByteFrequencyData(domainData);\\n        const rmsLevel = calculateRMS(timeDomainData);\\n        visualizerData.push(normalizeRMS(rmsLevel));\\n        if (visualizerData.length >= VISUALIZER_BUFFER_LENGTH) {\\n          visualizerData.shift();\\n        }\\n        visualizerData = visualizerData;\\n      }\\n      window.requestAnimationFrame(processFrame);\\n    };\\n    window.requestAnimationFrame(processFrame);\\n  };\\n  detectSound();\\n};\\nconst onStopHandler = async (audioBlob, ext = \\"wav\\") => {\\n  await tick();\\n  const file = blobToFile(audioBlob, `Recording-${dayjs().format(\\"L LT\\")}.${ext}`);\\n  if (transcribe) {\\n    if ($config.audio.stt.engine === \\"web\\" || ($settings?.audio?.stt?.engine ?? \\"\\") === \\"web\\") {\\n      return;\\n    }\\n    const res = await transcribeAudio(\\n      localStorage.token,\\n      file,\\n      $settings?.audio?.stt?.language\\n    ).catch((error) => {\\n      toast.error(`${error}`);\\n      return null;\\n    });\\n    if (res) {\\n      console.log(res);\\n      onConfirm(res);\\n    }\\n  } else {\\n    onConfirm({\\n      file,\\n      blob: audioBlob\\n    });\\n  }\\n};\\nconst startRecording = async () => {\\n  loading = true;\\n  try {\\n    if (displayMedia) {\\n      const mediaStream = await navigator.mediaDevices.getDisplayMedia({\\n        audio: true\\n      });\\n      stream = new MediaStream();\\n      for (const track of mediaStream.getAudioTracks()) {\\n        stream.addTrack(track);\\n      }\\n      for (const track of mediaStream.getVideoTracks()) {\\n        track.stop();\\n      }\\n    } else {\\n      stream = await navigator.mediaDevices.getUserMedia({\\n        audio: {\\n          echoCancellation,\\n          noiseSuppression,\\n          autoGainControl\\n        }\\n      });\\n    }\\n  } catch (err) {\\n    console.error(\\"Error accessing media devices.\\", err);\\n    toast.error($i18n.t(\\"Error accessing media devices.\\"));\\n    loading = false;\\n    recording = false;\\n    return;\\n  }\\n  const mineTypes = [\\"audio/webm; codecs=opus\\", \\"audio/mp4\\"];\\n  mediaRecorder = new MediaRecorder(stream, {\\n    mimeType: mineTypes.find((type) => MediaRecorder.isTypeSupported(type))\\n  });\\n  mediaRecorder.onstart = () => {\\n    console.log(\\"Recording started\\");\\n    loading = false;\\n    startDurationCounter();\\n    audioChunks = [];\\n    analyseAudio(stream);\\n  };\\n  mediaRecorder.ondataavailable = (event) => audioChunks.push(event.data);\\n  mediaRecorder.onstop = async () => {\\n    console.log(\\"Recording stopped\\");\\n    if (confirmed) {\\n      let type = audioChunks[0]?.type || mediaRecorder.mimeType || \\"audio/webm\\";\\n      let ext = type.split(\\"/\\")[1].split(\\";\\")[0] || \\"webm\\";\\n      if (!type.startsWith(\\"audio/\\")) {\\n        ext = \\"webm\\";\\n      }\\n      const audioBlob = new Blob(audioChunks, { type });\\n      await onStopHandler(audioBlob, ext);\\n      confirmed = false;\\n      loading = false;\\n    }\\n    audioChunks = [];\\n    recording = false;\\n  };\\n  try {\\n    mediaRecorder.start();\\n  } catch (error) {\\n    console.error(\\"Error starting recording:\\", error);\\n    toast.error($i18n.t(\\"Error starting recording.\\"));\\n    loading = false;\\n    recording = false;\\n    return;\\n  }\\n  if (transcribe) {\\n    if ($config.audio.stt.engine === \\"web\\" || ($settings?.audio?.stt?.engine ?? \\"\\") === \\"web\\") {\\n      if (\\"SpeechRecognition\\" in window || \\"webkitSpeechRecognition\\" in window) {\\n        speechRecognition = new (window.SpeechRecognition || window.webkitSpeechRecognition)();\\n        speechRecognition.continuous = true;\\n        const inactivityTimeout = 2e3;\\n        let timeoutId;\\n        speechRecognition.start();\\n        speechRecognition.onresult = async (event) => {\\n          clearTimeout(timeoutId);\\n          console.log(event);\\n          const transcript = event.results[Object.keys(event.results).length - 1][0].transcript;\\n          transcription = `${transcription}${transcript}`;\\n          await tick();\\n          document.getElementById(\\"chat-input\\")?.focus();\\n          timeoutId = setTimeout(() => {\\n            console.log(\\"Speech recognition turned off due to inactivity.\\");\\n            speechRecognition.stop();\\n          }, inactivityTimeout);\\n        };\\n        speechRecognition.onend = function() {\\n          console.log(\\"recognition ended\\");\\n          confirmRecording();\\n          onConfirm({\\n            text: transcription\\n          });\\n          confirmed = false;\\n          loading = false;\\n        };\\n        speechRecognition.onerror = function(event) {\\n          console.log(event);\\n          toast.error($i18n.t(`Speech recognition error: {{error}}`, { error: event.error }));\\n          onCancel();\\n          stopRecording();\\n        };\\n      }\\n    }\\n  }\\n};\\nconst stopRecording = async () => {\\n  if (recording && mediaRecorder) {\\n    await mediaRecorder.stop();\\n  }\\n  if (speechRecognition) {\\n    speechRecognition.stop();\\n  }\\n  stopDurationCounter();\\n  audioChunks = [];\\n  if (stream) {\\n    const tracks = stream.getTracks();\\n    tracks.forEach((track) => track.stop());\\n  }\\n  stream = null;\\n};\\nconst confirmRecording = async () => {\\n  loading = true;\\n  confirmed = true;\\n  if (recording && mediaRecorder) {\\n    await mediaRecorder.stop();\\n  }\\n  clearInterval(durationCounter);\\n  if (stream) {\\n    const tracks = stream.getTracks();\\n    tracks.forEach((track) => track.stop());\\n  }\\n  stream = null;\\n};\\nlet resizeObserver;\\nlet containerWidth;\\nlet maxVisibleItems = 300;\\n$: maxVisibleItems = Math.floor(containerWidth / 5);\\nonMount(() => {\\n  resizeObserver = new ResizeObserver(() => {\\n    VISUALIZER_BUFFER_LENGTH = Math.floor(window.innerWidth / 4);\\n    if (visualizerData.length > VISUALIZER_BUFFER_LENGTH) {\\n      visualizerData = visualizerData.slice(visualizerData.length - VISUALIZER_BUFFER_LENGTH);\\n    } else {\\n      visualizerData = Array(VISUALIZER_BUFFER_LENGTH - visualizerData.length).fill(0).concat(visualizerData);\\n    }\\n  });\\n  resizeObserver.observe(document.body);\\n});\\nonDestroy(() => {\\n  resizeObserver.disconnect();\\n});\\n<\/script>\\n\\n<div\\n\\tbind:clientWidth={containerWidth}\\n\\tclass=\\"{loading\\n\\t\\t? \' bg-gray-100/50 dark:bg-gray-850/50\'\\n\\t\\t: \'bg-indigo-300/10 dark:bg-indigo-500/10 \'} rounded-full flex justify-between {className}\\"\\n>\\n\\t<div class=\\"flex items-center mr-1\\">\\n\\t\\t<button\\n\\t\\t\\ttype=\\"button\\"\\n\\t\\t\\tclass=\\"p-1.5\\n\\n            {loading\\n\\t\\t\\t\\t? \' bg-gray-200 dark:bg-gray-700/50\'\\n\\t\\t\\t\\t: \'bg-indigo-400/20 text-indigo-600 dark:text-indigo-300 \'} \\n\\n\\n             rounded-full\\"\\n\\t\\t\\ton:click={async () => {\\n\\t\\t\\t\\tstopRecording();\\n\\t\\t\\t\\tonCancel();\\n\\t\\t\\t}}\\n\\t\\t>\\n\\t\\t\\t<XMark className={\'size-4\'} />\\n\\t\\t</button>\\n\\t</div>\\n\\n\\t<div\\n\\t\\tclass=\\"flex flex-1 self-center items-center justify-between ml-2 mx-1 overflow-hidden h-6\\"\\n\\t\\tdir=\\"rtl\\"\\n\\t>\\n\\t\\t<div\\n\\t\\t\\tclass=\\"flex items-center gap-0.5 h-6 w-full max-w-full overflow-hidden overflow-x-hidden flex-wrap\\"\\n\\t\\t>\\n\\t\\t\\t{#each visualizerData.slice().reverse() as rms}\\n\\t\\t\\t\\t<div class=\\"flex items-center h-full\\">\\n\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\tclass=\\"w-[2px] shrink-0\\n                    \\n                    {loading\\n\\t\\t\\t\\t\\t\\t\\t? \' bg-gray-500 dark:bg-gray-400   \'\\n\\t\\t\\t\\t\\t\\t\\t: \'bg-indigo-500 dark:bg-indigo-400  \'} \\n                    \\n                    inline-block h-full\\"\\n\\t\\t\\t\\t\\t\\tstyle=\\"height: {Math.min(100, Math.max(14, rms * 100))}%;\\"\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t</div>\\n\\t\\t\\t{/each}\\n\\t\\t</div>\\n\\t</div>\\n\\n\\t<div class=\\"flex\\">\\n\\t\\t<div class=\\"  mx-1.5 pr-1 flex justify-center items-center\\">\\n\\t\\t\\t<div\\n\\t\\t\\t\\tclass=\\"text-sm\\n        \\n        \\n        {loading ? \' text-gray-500  dark:text-gray-400  \' : \' text-indigo-400 \'} \\n       font-medium flex-1 mx-auto text-center\\"\\n\\t\\t\\t>\\n\\t\\t\\t\\t{formatSeconds(durationSeconds)}\\n\\t\\t\\t</div>\\n\\t\\t</div>\\n\\n\\t\\t<div class=\\"flex items-center\\">\\n\\t\\t\\t{#if loading}\\n\\t\\t\\t\\t<div class=\\" text-gray-500 rounded-full cursor-not-allowed\\">\\n\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\twidth=\\"24\\"\\n\\t\\t\\t\\t\\t\\theight=\\"24\\"\\n\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\tfill=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\t><style>\\n\\t\\t\\t\\t\\t\\t\\t.spinner_OSmW {\\n\\t\\t\\t\\t\\t\\t\\t\\ttransform-origin: center;\\n\\t\\t\\t\\t\\t\\t\\t\\tanimation: spinner_T6mA 0.75s step-end infinite;\\n\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t@keyframes spinner_T6mA {\\n\\t\\t\\t\\t\\t\\t\\t\\t8.3% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(30deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t16.6% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(60deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t25% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(90deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t33.3% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(120deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t41.6% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(150deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t50% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(180deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t58.3% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(210deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t66.6% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(240deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t75% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(270deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t83.3% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(300deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t91.6% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(330deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t\\t100% {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ttransform: rotate(360deg);\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t</style><g class=\\"spinner_OSmW\\"\\n\\t\\t\\t\\t\\t\\t\\t><rect x=\\"11\\" y=\\"1\\" width=\\"2\\" height=\\"5\\" opacity=\\".14\\" /><rect\\n\\t\\t\\t\\t\\t\\t\\t\\tx=\\"11\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ty=\\"1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\twidth=\\"2\\"\\n\\t\\t\\t\\t\\t\\t\\t\\theight=\\"5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ttransform=\\"rotate(30 12 12)\\"\\n\\t\\t\\t\\t\\t\\t\\t\\topacity=\\".29\\"\\n\\t\\t\\t\\t\\t\\t\\t/><rect\\n\\t\\t\\t\\t\\t\\t\\t\\tx=\\"11\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ty=\\"1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\twidth=\\"2\\"\\n\\t\\t\\t\\t\\t\\t\\t\\theight=\\"5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ttransform=\\"rotate(60 12 12)\\"\\n\\t\\t\\t\\t\\t\\t\\t\\topacity=\\".43\\"\\n\\t\\t\\t\\t\\t\\t\\t/><rect\\n\\t\\t\\t\\t\\t\\t\\t\\tx=\\"11\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ty=\\"1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\twidth=\\"2\\"\\n\\t\\t\\t\\t\\t\\t\\t\\theight=\\"5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ttransform=\\"rotate(90 12 12)\\"\\n\\t\\t\\t\\t\\t\\t\\t\\topacity=\\".57\\"\\n\\t\\t\\t\\t\\t\\t\\t/><rect\\n\\t\\t\\t\\t\\t\\t\\t\\tx=\\"11\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ty=\\"1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\twidth=\\"2\\"\\n\\t\\t\\t\\t\\t\\t\\t\\theight=\\"5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ttransform=\\"rotate(120 12 12)\\"\\n\\t\\t\\t\\t\\t\\t\\t\\topacity=\\".71\\"\\n\\t\\t\\t\\t\\t\\t\\t/><rect\\n\\t\\t\\t\\t\\t\\t\\t\\tx=\\"11\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ty=\\"1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\twidth=\\"2\\"\\n\\t\\t\\t\\t\\t\\t\\t\\theight=\\"5\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ttransform=\\"rotate(150 12 12)\\"\\n\\t\\t\\t\\t\\t\\t\\t\\topacity=\\".86\\"\\n\\t\\t\\t\\t\\t\\t\\t/><rect x=\\"11\\" y=\\"1\\" width=\\"2\\" height=\\"5\\" transform=\\"rotate(180 12 12)\\" /></g\\n\\t\\t\\t\\t\\t\\t></svg\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t</div>\\n\\t\\t\\t{:else}\\n\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\ttype=\\"button\\"\\n\\t\\t\\t\\t\\tclass=\\"p-1.5 bg-indigo-500 text-white dark:bg-indigo-500 dark:text-blue-950 rounded-full\\"\\n\\t\\t\\t\\t\\ton:click={async () => {\\n\\t\\t\\t\\t\\t\\tawait confirmRecording();\\n\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t<svg\\n\\t\\t\\t\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\t\\t\\t\\tfill=\\"none\\"\\n\\t\\t\\t\\t\\t\\tviewBox=\\"0 0 24 24\\"\\n\\t\\t\\t\\t\\t\\tstroke-width=\\"2.5\\"\\n\\t\\t\\t\\t\\t\\tstroke=\\"currentColor\\"\\n\\t\\t\\t\\t\\t\\tclass=\\"size-4\\"\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t<path stroke-linecap=\\"round\\" stroke-linejoin=\\"round\\" d=\\"m4.5 12.75 6 6 9-13.5\\" />\\n\\t\\t\\t\\t\\t</svg>\\n\\t\\t\\t\\t</button>\\n\\t\\t\\t{/if}\\n\\t\\t</div>\\n\\t</div>\\n</div>\\n\\n<style>\\n\\t.visualizer {\\n\\t\\tdisplay: flex;\\n\\t\\theight: 100%;\\n\\t}\\n\\n\\t.visualizer-bar {\\n\\t\\twidth: 2px;\\n\\t\\tbackground-color: #4a5aba; /* or whatever color you need */\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AAwcC,0BAAY,CACX,OAAO,CAAE,IAAI,CACb,MAAM,CAAE,IACT,CAEA,8BAAgB,CACf,KAAK,CAAE,GAAG,CACV,gBAAgB,CAAE,OACnB"}'
};
const VoiceRecording = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $settings, $$unsubscribe_settings;
  let $config, $$unsubscribe_config;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  dayjs.extend(localizedFormat);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { recording = false } = $$props;
  let { transcribe = true } = $$props;
  let { displayMedia = false } = $$props;
  let { echoCancellation = true } = $$props;
  let { noiseSuppression = true } = $$props;
  let { autoGainControl = true } = $$props;
  let { className = " p-2.5 w-full max-w-full" } = $$props;
  let { onCancel = () => {
  } } = $$props;
  let { onConfirm = (data) => {
  } } = $$props;
  let loading = false;
  let confirmed = false;
  let durationSeconds = 0;
  let durationCounter = null;
  let transcription = "";
  const startDurationCounter = () => {
    durationCounter = setInterval(
      () => {
        durationSeconds++;
      },
      1e3
    );
  };
  const stopDurationCounter = () => {
    clearInterval(durationCounter);
    durationSeconds = 0;
  };
  const formatSeconds = (seconds) => {
    const minutes = Math.floor(seconds / 60);
    const remainingSeconds = seconds % 60;
    const formattedSeconds = remainingSeconds < 10 ? `0${remainingSeconds}` : remainingSeconds;
    return `${minutes}:${formattedSeconds}`;
  };
  let stream;
  let speechRecognition;
  let mediaRecorder;
  let audioChunks = [];
  const MIN_DECIBELS = -45;
  let VISUALIZER_BUFFER_LENGTH = 300;
  let visualizerData = Array(VISUALIZER_BUFFER_LENGTH).fill(0);
  const calculateRMS = (data) => {
    let sumSquares = 0;
    for (let i = 0; i < data.length; i++) {
      const normalizedValue = (data[i] - 128) / 128;
      sumSquares += normalizedValue * normalizedValue;
    }
    return Math.sqrt(sumSquares / data.length);
  };
  const normalizeRMS = (rms) => {
    rms = rms * 10;
    const exp = 1.5;
    const scaledRMS = Math.pow(rms, exp);
    return Math.min(1, Math.max(0.01, scaledRMS));
  };
  const analyseAudio = (stream2) => {
    const audioContext = new AudioContext();
    const audioStreamSource = audioContext.createMediaStreamSource(stream2);
    const analyser = audioContext.createAnalyser();
    analyser.minDecibels = MIN_DECIBELS;
    audioStreamSource.connect(analyser);
    const bufferLength = analyser.frequencyBinCount;
    const domainData = new Uint8Array(bufferLength);
    const timeDomainData = new Uint8Array(analyser.fftSize);
    const detectSound = () => {
      const processFrame = () => {
        if (!recording || loading) return;
        if (recording && !loading) {
          analyser.getByteTimeDomainData(timeDomainData);
          analyser.getByteFrequencyData(domainData);
          const rmsLevel = calculateRMS(timeDomainData);
          visualizerData.push(normalizeRMS(rmsLevel));
          if (visualizerData.length >= VISUALIZER_BUFFER_LENGTH) {
            visualizerData.shift();
          }
          visualizerData = visualizerData;
        }
        window.requestAnimationFrame(processFrame);
      };
      window.requestAnimationFrame(processFrame);
    };
    detectSound();
  };
  const onStopHandler = async (audioBlob, ext = "wav") => {
    await tick();
    const file = blobToFile(audioBlob, `Recording-${dayjs().format("L LT")}.${ext}`);
    if (transcribe) {
      if ($config.audio.stt.engine === "web" || ($settings?.audio?.stt?.engine ?? "") === "web") {
        return;
      }
      const res = await transcribeAudio(localStorage.token, file, $settings?.audio?.stt?.language).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      if (res) {
        /* @__PURE__ */ console.log(res);
        onConfirm(res);
      }
    } else {
      onConfirm({ file, blob: audioBlob });
    }
  };
  const startRecording = async () => {
    loading = true;
    try {
      if (displayMedia) {
        const mediaStream = await navigator.mediaDevices.getDisplayMedia({ audio: true });
        stream = new MediaStream();
        for (const track of mediaStream.getAudioTracks()) {
          stream.addTrack(track);
        }
        for (const track of mediaStream.getVideoTracks()) {
          track.stop();
        }
      } else {
        stream = await navigator.mediaDevices.getUserMedia({
          audio: {
            echoCancellation,
            noiseSuppression,
            autoGainControl
          }
        });
      }
    } catch (err) {
      /* @__PURE__ */ console.error("Error accessing media devices.", err);
      toast.error($i18n.t("Error accessing media devices."));
      loading = false;
      recording = false;
      return;
    }
    const mineTypes = ["audio/webm; codecs=opus", "audio/mp4"];
    mediaRecorder = new MediaRecorder(
      stream,
      {
        mimeType: mineTypes.find((type) => MediaRecorder.isTypeSupported(type))
      }
    );
    mediaRecorder.onstart = () => {
      /* @__PURE__ */ console.log("Recording started");
      loading = false;
      startDurationCounter();
      audioChunks = [];
      analyseAudio(stream);
    };
    mediaRecorder.ondataavailable = (event) => audioChunks.push(event.data);
    mediaRecorder.onstop = async () => {
      /* @__PURE__ */ console.log("Recording stopped");
      if (confirmed) {
        let type = audioChunks[0]?.type || mediaRecorder.mimeType || "audio/webm";
        let ext = type.split("/")[1].split(";")[0] || "webm";
        if (!type.startsWith("audio/")) {
          ext = "webm";
        }
        const audioBlob = new Blob(audioChunks, { type });
        await onStopHandler(audioBlob, ext);
        confirmed = false;
        loading = false;
      }
      audioChunks = [];
      recording = false;
    };
    try {
      mediaRecorder.start();
    } catch (error) {
      /* @__PURE__ */ console.error("Error starting recording:", error);
      toast.error($i18n.t("Error starting recording."));
      loading = false;
      recording = false;
      return;
    }
    if (transcribe) {
      if ($config.audio.stt.engine === "web" || ($settings?.audio?.stt?.engine ?? "") === "web") {
        if ("SpeechRecognition" in window || "webkitSpeechRecognition" in window) {
          speechRecognition = new (window.SpeechRecognition || window.webkitSpeechRecognition)();
          speechRecognition.continuous = true;
          const inactivityTimeout = 2e3;
          let timeoutId;
          speechRecognition.start();
          speechRecognition.onresult = async (event) => {
            clearTimeout(timeoutId);
            /* @__PURE__ */ console.log(event);
            const transcript = event.results[Object.keys(event.results).length - 1][0].transcript;
            transcription = `${transcription}${transcript}`;
            await tick();
            document.getElementById("chat-input")?.focus();
            timeoutId = setTimeout(
              () => {
                /* @__PURE__ */ console.log("Speech recognition turned off due to inactivity.");
                speechRecognition.stop();
              },
              inactivityTimeout
            );
          };
          speechRecognition.onend = function() {
            /* @__PURE__ */ console.log("recognition ended");
            confirmRecording();
            onConfirm({ text: transcription });
            confirmed = false;
            loading = false;
          };
          speechRecognition.onerror = function(event) {
            /* @__PURE__ */ console.log(event);
            toast.error($i18n.t(`Speech recognition error: {{error}}`, { error: event.error }));
            onCancel();
            stopRecording();
          };
        }
      }
    }
  };
  const stopRecording = async () => {
    if (recording && mediaRecorder) {
      await mediaRecorder.stop();
    }
    if (speechRecognition) {
      speechRecognition.stop();
    }
    stopDurationCounter();
    audioChunks = [];
    if (stream) {
      const tracks = stream.getTracks();
      tracks.forEach((track) => track.stop());
    }
    stream = null;
  };
  const confirmRecording = async () => {
    loading = true;
    confirmed = true;
    if (recording && mediaRecorder) {
      await mediaRecorder.stop();
    }
    clearInterval(durationCounter);
    if (stream) {
      const tracks = stream.getTracks();
      tracks.forEach((track) => track.stop());
    }
    stream = null;
  };
  let resizeObserver;
  onDestroy(() => {
    resizeObserver.disconnect();
  });
  if ($$props.recording === void 0 && $$bindings.recording && recording !== void 0) $$bindings.recording(recording);
  if ($$props.transcribe === void 0 && $$bindings.transcribe && transcribe !== void 0) $$bindings.transcribe(transcribe);
  if ($$props.displayMedia === void 0 && $$bindings.displayMedia && displayMedia !== void 0) $$bindings.displayMedia(displayMedia);
  if ($$props.echoCancellation === void 0 && $$bindings.echoCancellation && echoCancellation !== void 0) $$bindings.echoCancellation(echoCancellation);
  if ($$props.noiseSuppression === void 0 && $$bindings.noiseSuppression && noiseSuppression !== void 0) $$bindings.noiseSuppression(noiseSuppression);
  if ($$props.autoGainControl === void 0 && $$bindings.autoGainControl && autoGainControl !== void 0) $$bindings.autoGainControl(autoGainControl);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.onCancel === void 0 && $$bindings.onCancel && onCancel !== void 0) $$bindings.onCancel(onCancel);
  if ($$props.onConfirm === void 0 && $$bindings.onConfirm && onConfirm !== void 0) $$bindings.onConfirm(onConfirm);
  $$result.css.add(css);
  {
    if (recording) {
      startRecording();
    } else {
      stopRecording();
    }
  }
  $$unsubscribe_i18n();
  $$unsubscribe_settings();
  $$unsubscribe_config();
  return `<div class="${escape(
    loading ? " bg-gray-100/50 dark:bg-gray-850/50" : "bg-indigo-300/10 dark:bg-indigo-500/10 ",
    true
  ) + " rounded-full flex justify-between " + escape(className, true) + " svelte-156uiqn"}"><div class="flex items-center mr-1"><button type="button" class="${"p-1.5 " + escape(
    loading ? " bg-gray-200 dark:bg-gray-700/50" : "bg-indigo-400/20 text-indigo-600 dark:text-indigo-300 ",
    true
  ) + " rounded-full"}">${validate_component(XMark, "XMark").$$render($$result, { className: "size-4" }, {}, {})}</button></div> <div class="flex flex-1 self-center items-center justify-between ml-2 mx-1 overflow-hidden h-6" dir="rtl"><div class="flex items-center gap-0.5 h-6 w-full max-w-full overflow-hidden overflow-x-hidden flex-wrap">${each(visualizerData.slice().reverse(), (rms) => {
    return `<div class="flex items-center h-full"><div class="${"w-[2px] shrink-0 " + escape(
      loading ? " bg-gray-500 dark:bg-gray-400   " : "bg-indigo-500 dark:bg-indigo-400  ",
      true
    ) + " inline-block h-full"}" style="${"height: " + escape(Math.min(100, Math.max(14, rms * 100)), true) + "%;"}"></div> </div>`;
  })}</div></div> <div class="flex"><div class="mx-1.5 pr-1 flex justify-center items-center"><div class="${"text-sm " + escape(
    loading ? " text-gray-500  dark:text-gray-400  " : " text-indigo-400 ",
    true
  ) + " font-medium flex-1 mx-auto text-center"}">${escape(formatSeconds(durationSeconds))}</div></div> <div class="flex items-center">${loading ? `<div class="text-gray-500 rounded-full cursor-not-allowed" data-svelte-h="svelte-cqc0xj"><svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="currentColor"><style>.spinner_OSmW {
								transform-origin: center;
								animation: spinner_T6mA 0.75s step-end infinite;
							}
							@keyframes spinner_T6mA {
								8.3% {
									transform: rotate(30deg);
								}
								16.6% {
									transform: rotate(60deg);
								}
								25% {
									transform: rotate(90deg);
								}
								33.3% {
									transform: rotate(120deg);
								}
								41.6% {
									transform: rotate(150deg);
								}
								50% {
									transform: rotate(180deg);
								}
								58.3% {
									transform: rotate(210deg);
								}
								66.6% {
									transform: rotate(240deg);
								}
								75% {
									transform: rotate(270deg);
								}
								83.3% {
									transform: rotate(300deg);
								}
								91.6% {
									transform: rotate(330deg);
								}
								100% {
									transform: rotate(360deg);
								}
							}
						</style><g class="spinner_OSmW"><rect x="11" y="1" width="2" height="5" opacity=".14"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(30 12 12)" opacity=".29"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(60 12 12)" opacity=".43"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(90 12 12)" opacity=".57"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(120 12 12)" opacity=".71"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(150 12 12)" opacity=".86"></rect><rect x="11" y="1" width="2" height="5" transform="rotate(180 12 12)"></rect></g></svg></div>` : `<button type="button" class="p-1.5 bg-indigo-500 text-white dark:bg-indigo-500 dark:text-blue-950 rounded-full" data-svelte-h="svelte-dblpqo"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor" class="size-4"><path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5"></path></svg></button>`}</div></div> </div>`;
});
const CloudArrowUp = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M12 16.5V9.75m0 0 3 3m-3-3-3 3M6.75 19.5a4.5 4.5 0 0 1-1.41-8.775 5.25 5.25 0 0 1 10.233-2.33 3 3 0 0 1 3.758 3.848A3.752 3.752 0 0 1 18 19.5H6.75Z"></path></svg>`;
});
const NoteMenu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { className = "max-w-[180px]" } = $$props;
  let { onDownload = (type) => {
  } } = $$props;
  let { onDelete = () => {
  } } = $$props;
  let { onCopyLink = null } = $$props;
  let { onCopyToClipboard = null } = $$props;
  let { onChange = () => {
  } } = $$props;
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.onDownload === void 0 && $$bindings.onDownload && onDownload !== void 0) $$bindings.onDownload(onDownload);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  if ($$props.onCopyLink === void 0 && $$bindings.onCopyLink && onCopyLink !== void 0) $$bindings.onCopyLink(onCopyLink);
  if ($$props.onCopyToClipboard === void 0 && $$bindings.onCopyToClipboard && onCopyToClipboard !== void 0) $$bindings.onCopyToClipboard(onCopyToClipboard);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Menu, "DropdownMenu.Root").$$render(
      $$result,
      {
        onOpenChange: (state) => {
          onChange(state);
        },
        open: show
      },
      {
        open: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `${validate_component(Menu_trigger, "DropdownMenu.Trigger").$$render($$result, {}, {}, {
            default: () => {
              return `${slots.default ? slots.default({}) : ``}`;
            }
          })} ${slots.content ? slots.content({}) : ` ${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full " + className + " text-sm rounded-2xl px-1 py-1 border border-gray-100  dark:border-gray-800  z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg",
              sideOffset: 6,
              side: "bottom",
              align: "end",
              transition: (e) => fade(e, { duration: 100 })
            },
            {},
            {
              default: () => {
                return `${validate_component(Menu_sub, "DropdownMenu.Sub").$$render($$result, {}, {}, {
                  default: () => {
                    return `${validate_component(Menu_sub_trigger, "DropdownMenu.SubTrigger").$$render(
                      $$result,
                      {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                      },
                      {},
                      {
                        default: () => {
                          return `${validate_component(Download, "Download").$$render($$result, { strokeWidth: "2" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Download"))}</div>`;
                        }
                      }
                    )} ${validate_component(Menu_sub_content, "DropdownMenu.SubContent").$$render(
                      $$result,
                      {
                        class: "w-full rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg",
                        transition: flyAndScale,
                        sideOffset: 8,
                        align: "end"
                      },
                      {},
                      {
                        default: () => {
                          return `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                            },
                            {},
                            {
                              default: () => {
                                return `<div class="flex items-center line-clamp-1">${escape($i18n.t("Plain text (.txt)"))}</div>`;
                              }
                            }
                          )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                            },
                            {},
                            {
                              default: () => {
                                return `<div class="flex items-center line-clamp-1">${escape($i18n.t("Plain text (.md)"))}</div>`;
                              }
                            }
                          )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                            },
                            {},
                            {
                              default: () => {
                                return `<div class="flex items-center line-clamp-1">${escape($i18n.t("PDF document (.pdf)"))}</div>`;
                              }
                            }
                          )}`;
                        }
                      }
                    )}`;
                  }
                })} ${onCopyLink || onCopyToClipboard ? `${validate_component(Menu_sub, "DropdownMenu.Sub").$$render($$result, {}, {}, {
                  default: () => {
                    return `${validate_component(Menu_sub_trigger, "DropdownMenu.SubTrigger").$$render(
                      $$result,
                      {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                      },
                      {},
                      {
                        default: () => {
                          return `${validate_component(Share, "Share").$$render($$result, { strokeWidth: "2" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Share"))}</div>`;
                        }
                      }
                    )} ${validate_component(Menu_sub_content, "DropdownMenu.SubContent").$$render(
                      $$result,
                      {
                        class: "w-full rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg",
                        transition: flyAndScale,
                        sideOffset: 8,
                        align: "end"
                      },
                      {},
                      {
                        default: () => {
                          return `${onCopyLink ? `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                            },
                            {},
                            {
                              default: () => {
                                return `${validate_component(Link, "Link").$$render($$result, {}, {}, {})} <div class="flex items-center">${escape($i18n.t("Copy link"))}</div>`;
                              }
                            }
                          )}` : ``} ${onCopyToClipboard ? `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                            },
                            {},
                            {
                              default: () => {
                                return `${validate_component(DocumentDuplicate, "DocumentDuplicate").$$render($$result, { strokeWidth: "2" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Copy to clipboard"))}</div>`;
                              }
                            }
                          )}` : ``}`;
                        }
                      }
                    )}`;
                  }
                })}` : ``} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex  gap-2  items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(GarbageBin, "GarbageBin").$$render($$result, {}, {}, {})} <div class="flex items-center">${escape($i18n.t("Delete"))}</div>`;
                    }
                  }
                )}`;
              }
            }
          )} `}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const NotePanel = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { show = false } = $$props;
  let { pane = null } = $$props;
  let { containerId = "note-container" } = $$props;
  let mediaQuery;
  let largeScreen = false;
  let minSize = 0;
  const handleMediaQuery = async (e) => {
    if (e.matches) {
      largeScreen = true;
    } else {
      largeScreen = false;
      pane = null;
    }
  };
  onDestroy(() => {
    mediaQuery.removeEventListener("change", handleMediaQuery);
  });
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.pane === void 0 && $$bindings.pane && pane !== void 0) $$bindings.pane(pane);
  if ($$props.containerId === void 0 && $$bindings.containerId && containerId !== void 0) $$bindings.containerId(containerId);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${!largeScreen ? `${show ? `${validate_component(Drawer, "Drawer").$$render(
      $$result,
      {
        show,
        onClose: () => {
          show = false;
        }
      },
      {},
      {
        default: () => {
          return `<div class="px-3.5 py-2.5 h-screen max-h-dvh flex flex-col">${slots.default ? slots.default({}) : ``}</div>`;
        }
      }
    )}` : ``}` : `${show ? `${validate_component(Pane_resizer, "PaneResizer").$$render(
      $$result,
      {
        class: "relative flex items-center justify-center group border-l border-gray-50 dark:border-gray-850 hover:border-gray-200 dark:hover:border-gray-800  transition z-20",
        id: "controls-resizer"
      },
      {},
      {
        default: () => {
          return `<div class="absolute -left-1.5 -right-1.5 -top-0 -bottom-0 z-20 cursor-col-resize bg-transparent"></div>`;
        }
      }
    )} ${validate_component(Pane, "Pane").$$render(
      $$result,
      {
        defaultSize: Math.max(20, minSize),
        minSize,
        onCollapse: () => {
          show = false;
        },
        collapsible: true,
        class: " z-10 ",
        pane
      },
      {
        pane: ($$value) => {
          pane = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `${show ? `<div class="flex max-h-full min-h-full"><div class="w-full pt-2 bg-white dark:shadow-lg dark:bg-gray-850 z-40 pointer-events-auto overflow-y-auto scrollbar-hidden flex flex-col">${slots.default ? slots.default({}) : ``}</div></div>` : ``}`;
        }
      }
    )}` : ``}`}`;
  } while (!$$settled);
  return $$rendered;
});
const Controls = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $models, $$unsubscribe_models;
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { selectedModelId = "" } = $$props;
  let { files = [] } = $$props;
  let { onUpdate = (files2) => {
  } } = $$props;
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.selectedModelId === void 0 && $$bindings.selectedModelId && selectedModelId !== void 0) $$bindings.selectedModelId(selectedModelId);
  if ($$props.files === void 0 && $$bindings.files && files !== void 0) $$bindings.files(files);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  $$unsubscribe_i18n();
  $$unsubscribe_models();
  return `<div class="flex items-center mb-1.5 pt-1.5 px-2.5"><div class="mr-1 flex items-center"><button class="p-0.5 bg-transparent transition rounded-lg">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5", strokeWidth: "2.5" }, {}, {})}</button></div> <div class="font-medium text-base flex items-center gap-1"><div>${escape($i18n.t("Controls"))}</div></div></div> <div class="mt-1 px-2.5"><div class="pb-10">${files.length > 0 ? `<div class="text-xs font-medium pb-1">${escape($i18n.t("Files"))}</div> <div class="flex flex-col gap-1">${each(files.filter((file) => file.type !== "image"), (file, fileIdx) => {
    return `${validate_component(FileItem, "FileItem").$$render(
      $$result,
      {
        className: "w-full",
        item: file,
        small: true,
        edit: true,
        dismissible: true,
        url: file.url,
        name: file.name,
        type: file.type,
        size: file?.size,
        loading: file.status === "uploading"
      },
      {},
      {}
    )}`;
  })} <div class="flex items-center flex-wrap gap-2 mt-1.5">${each(files.filter((file) => file.type === "image"), (file, fileIdx) => {
    return `${validate_component(Image, "Image").$$render(
      $$result,
      {
        src: file.url,
        imageClassName: " size-14 rounded-xl object-cover",
        dismissible: true,
        onDismiss: () => {
          files = files.filter((item) => item.id !== file.id);
          files = files;
          onUpdate(files);
        }
      },
      {},
      {}
    )}`;
  })}</div></div> <hr class="my-2 border-gray-50 dark:border-gray-700/10">` : ``} <div class="text-xs font-medium mb-1">${escape($i18n.t("Model"))}</div> <div class="w-full"><select class="w-full bg-transparent text-sm outline-hidden"><option value="" class="bg-gray-50 dark:bg-gray-700" disabled>${escape($i18n.t("Select a model"))} </option>${each($models.filter((model) => !(model?.info?.meta?.hidden ?? false)), (model) => {
    return `<option${add_attribute("value", model.id, 0)} class="bg-gray-50 dark:bg-gray-700">${escape(model.name)}</option>`;
  })}</select></div></div></div>`;
});
const ArrowUpLeft = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="m19.5 19.5-15-15m0 0v11.25m0-11.25h11.25"></path></svg>`;
});
const Message = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { message } = $$props;
  let { idx } = $$props;
  let { onDelete } = $$props;
  let { onEdit } = $$props;
  let { onInsert } = $$props;
  if ($$props.message === void 0 && $$bindings.message && message !== void 0) $$bindings.message(message);
  if ($$props.idx === void 0 && $$bindings.idx && idx !== void 0) $$bindings.idx(idx);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  if ($$props.onEdit === void 0 && $$bindings.onEdit && onEdit !== void 0) $$bindings.onEdit(onEdit);
  if ($$props.onInsert === void 0 && $$bindings.onInsert && onInsert !== void 0) $$bindings.onInsert(onInsert);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `<div class="flex flex-col gap-1 group"><div class="flex items-center justify-between pt-1"><div class="py-1 text-sm font-semibold uppercase min-w-[6rem] text-left rounded-lg transition">${escape($i18n.t(message.role))}</div> <div class="flex items-center gap-2">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        placement: "top",
        content: $i18n.t("Insert")
      },
      {},
      {
        default: () => {
          return `<button class="text-transparent group-hover:text-gray-500 dark:hover:text-gray-300 transition">${validate_component(ArrowUpLeft, "ArrowUpLeft").$$render($$result, { className: "size-3.5", strokeWidth: "2" }, {}, {})}</button>`;
        }
      }
    )} ${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        placement: "top",
        content: $i18n.t("Edit")
      },
      {},
      {
        default: () => {
          return `<button class="text-transparent group-hover:text-gray-500 dark:hover:text-gray-300 transition">${validate_component(Pencil, "Pencil").$$render($$result, { className: "size-3.5", strokeWidth: "2" }, {}, {})}</button>`;
        }
      }
    )} ${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        placement: "top",
        content: $i18n.t("Delete")
      },
      {},
      {
        default: () => {
          return `<button class="text-transparent group-hover:text-gray-500 dark:hover:text-gray-300 transition" data-svelte-h="svelte-n6kawc"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="size-4"><path stroke-linecap="round" stroke-linejoin="round" d="M15 12H9m12 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path></svg></button>`;
        }
      }
    )}</div></div> <div class="flex-1">  ${!(message?.done ?? true) && message?.content === "" ? `<div class="">${validate_component(Skeleton, "Skeleton").$$render($$result, { size: "sm" }, {}, {})}</div>` : `${message?.edit === true ? `${validate_component(Textarea, "Textarea").$$render(
      $$result,
      {
        className: "w-full bg-transparent outline-hidden text-sm resize-none overflow-hidden",
        placeholder: $i18n.t(`Enter {{role}} message here`, {
          role: message.role === "user" ? $i18n.t("a user") : $i18n.t("an assistant")
        }),
        onBlur: () => {
          message.edit = false;
        },
        value: message.content
      },
      {
        value: ($$value) => {
          message.content = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : `<div class="markdown-prose-sm text-sm">${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id: `note-message-${idx}`,
        content: message.content
      },
      {},
      {}
    )}</div>`}`}</div></div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const Messages = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  let { messages = [] } = $$props;
  let { onInsert = (content) => {
  } } = $$props;
  if ($$props.messages === void 0 && $$bindings.messages && messages !== void 0) $$bindings.messages(messages);
  if ($$props.onInsert === void 0 && $$bindings.onInsert && onInsert !== void 0) $$bindings.onInsert(onInsert);
  return `<div class="space-y-3 pb-12">${each(messages, (message, idx) => {
    return `${validate_component(Message, "Message").$$render(
      $$result,
      {
        message,
        idx,
        onInsert: () => {
          onInsert(message?.content ?? "");
        },
        onEdit: () => {
          messages = messages.map((msg, messageIdx) => {
            if (messageIdx === idx) {
              return { ...msg, edit: true };
            }
            return msg;
          });
        },
        onDelete: () => {
          messages = messages.filter((message2, messageIdx) => messageIdx !== idx);
        }
      },
      {},
      {}
    )}`;
  })}</div>`;
});
const Chat = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $models, $$unsubscribe_models;
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  let { show = false } = $$props;
  let { selectedModelId = "" } = $$props;
  marked.use({
    breaks: true,
    gfm: true,
    renderer: {
      list(body, ordered, start) {
        const isTaskList = body.includes("data-checked=");
        if (isTaskList) {
          return `<ul data-type="taskList">${body}</ul>`;
        }
        const type = ordered ? "ol" : "ul";
        const startatt = ordered && start !== 1 ? ` start="${start}"` : "";
        return `<${type}${startatt}>${body}</${type}>`;
      },
      listitem(text, task, checked) {
        if (task) {
          const checkedAttr = checked ? "true" : "false";
          return `<li data-type="taskItem" data-checked="${checkedAttr}">${text}</li>`;
        }
        return `<li>${text}</li>`;
      }
    }
  });
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { editor = null } = $$props;
  let { editing = false } = $$props;
  let { streaming = false } = $$props;
  let { stopResponseFlag = false } = $$props;
  let { note = null } = $$props;
  let { selectedContent = null } = $$props;
  let { files = [] } = $$props;
  let { messages = [] } = $$props;
  let { onInsert = (content) => {
  } } = $$props;
  let { onStop = () => {
  } } = $$props;
  let { onEdited = () => {
  } } = $$props;
  let { insertNoteHandler = () => {
  } } = $$props;
  let { scrollToBottomHandler = () => {
  } } = $$props;
  let loading = false;
  let messagesContainerElement;
  let system = "";
  let editEnabled = false;
  let chatInputElement = null;
  const chatCompletionHandler = async () => {
    if (selectedModelId === "") {
      toast.error($i18n.t("Please select a model."));
      return;
    }
    const model = $models.find((model2) => model2.id === selectedModelId);
    if (!model) {
      selectedModelId = "";
      return;
    }
    let responseMessage;
    if (messages.at(-1)?.role === "assistant") {
      responseMessage = messages.at(-1);
    } else {
      responseMessage = {
        role: "assistant",
        content: "",
        done: false
      };
      messages.push(responseMessage);
      messages = messages;
    }
    await tick();
    stopResponseFlag = false;
    let enhancedContent = { json: null, html: "", md: "" };
    system = "";
    {
      system = `You are a helpful assistant. Please answer the user's questions based on the context provided.

`;
    }
    system += `<notes>${note?.data?.content?.md ?? ""}</notes>` + (files && files.length > 0 ? `
<context>${files.map((file) => `${file.name}: ${file?.file?.data?.content ?? "Could not extract content"}
`).join("")}</context>` : "") + (selectedContent ? `
<selection>${selectedContent?.text}</selection>` : "");
    const chatMessages = JSON.parse(JSON.stringify([{ role: "system", content: `${system}` }, ...messages]));
    const [res, controller] = await chatCompletion(
      localStorage.token,
      {
        model: model.id,
        stream: true,
        messages: chatMessages
      },
      // ...(files && files.length > 0 ? { files } : {}) // TODO: Decide whether to use native file handling or not
      `${WEBUI_BASE_URL}/api`
    );
    await tick();
    let messageContent = "";
    if (res && res.ok) {
      const reader = res.body.pipeThrough(new TextDecoderStream()).pipeThrough(splitStream("\n")).getReader();
      while (true) {
        const { value, done } = await reader.read();
        if (done || stopResponseFlag) {
          if (stopResponseFlag) {
            controller.abort("User: Stop Response");
          }
          break;
        }
        try {
          let lines = value.split("\n");
          for (const line of lines) {
            if (line !== "") {
              /* @__PURE__ */ console.log(line);
              if (line === "data: [DONE]") {
                if (editEnabled) ;
                responseMessage.done = true;
                messages = messages;
              } else {
                let data = JSON.parse(line.replace(/^data: /, ""));
                /* @__PURE__ */ console.log(data);
                let deltaContent = data.choices[0]?.delta?.content ?? "";
                if (responseMessage.content == "" && deltaContent == "\n") {
                  continue;
                } else {
                  if (editEnabled) ;
                  else {
                    messageContent += deltaContent;
                    responseMessage.content = messageContent;
                    messages = messages;
                  }
                  await tick();
                }
              }
            }
          }
        } catch (error) {
          /* @__PURE__ */ console.log(error);
        }
      }
    }
  };
  const submitHandler = async (e) => {
    const { content, data } = e;
    if (selectedModelId && content) {
      messages.push({ role: "user", content });
      messages = messages;
      await tick();
      loading = true;
      await chatCompletionHandler();
      messages = messages.map((message) => {
        message.done = true;
        return message;
      });
      loading = false;
      stopResponseFlag = false;
    }
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.selectedModelId === void 0 && $$bindings.selectedModelId && selectedModelId !== void 0) $$bindings.selectedModelId(selectedModelId);
  if ($$props.editor === void 0 && $$bindings.editor && editor !== void 0) $$bindings.editor(editor);
  if ($$props.editing === void 0 && $$bindings.editing && editing !== void 0) $$bindings.editing(editing);
  if ($$props.streaming === void 0 && $$bindings.streaming && streaming !== void 0) $$bindings.streaming(streaming);
  if ($$props.stopResponseFlag === void 0 && $$bindings.stopResponseFlag && stopResponseFlag !== void 0) $$bindings.stopResponseFlag(stopResponseFlag);
  if ($$props.note === void 0 && $$bindings.note && note !== void 0) $$bindings.note(note);
  if ($$props.selectedContent === void 0 && $$bindings.selectedContent && selectedContent !== void 0) $$bindings.selectedContent(selectedContent);
  if ($$props.files === void 0 && $$bindings.files && files !== void 0) $$bindings.files(files);
  if ($$props.messages === void 0 && $$bindings.messages && messages !== void 0) $$bindings.messages(messages);
  if ($$props.onInsert === void 0 && $$bindings.onInsert && onInsert !== void 0) $$bindings.onInsert(onInsert);
  if ($$props.onStop === void 0 && $$bindings.onStop && onStop !== void 0) $$bindings.onStop(onStop);
  if ($$props.onEdited === void 0 && $$bindings.onEdited && onEdited !== void 0) $$bindings.onEdited(onEdited);
  if ($$props.insertNoteHandler === void 0 && $$bindings.insertNoteHandler && insertNoteHandler !== void 0) $$bindings.insertNoteHandler(insertNoteHandler);
  if ($$props.scrollToBottomHandler === void 0 && $$bindings.scrollToBottomHandler && scrollToBottomHandler !== void 0) $$bindings.scrollToBottomHandler(scrollToBottomHandler);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `<div class="flex items-center mb-1.5 pt-1.5 px-2.5"><div class="flex items-center mr-1"><button class="p-0.5 bg-transparent transition rounded-lg">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5", strokeWidth: "2.5" }, {}, {})}</button></div> <div class="font-medium text-base flex items-center gap-1"><div>${escape($i18n.t("Chat"))}</div> <div>${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("This feature is experimental and may be modified or discontinued without notice."),
        position: "top",
        className: "inline-block"
      },
      {},
      {
        default: () => {
          return `<span class="text-gray-500 text-sm">(${escape($i18n.t("Experimental"))})</span>`;
        }
      }
    )}</div></div></div> <div class="flex flex-col items-center flex-1 @container px-2.5"><div class="flex flex-col justify-between w-full overflow-y-auto h-full"><div class="mx-auto w-full md:px-0 h-full relative"><div class="flex flex-col h-full"><div class="pb-2.5 flex flex-col justify-between w-full flex-auto overflow-auto h-0 scrollbar-hidden" id="messages-container"${add_attribute("this", messagesContainerElement, 0)}><div class="h-full w-full flex flex-col"><div class="flex-1 p-1">${validate_component(Messages, "Messages").$$render(
      $$result,
      { onInsert, messages },
      {
        messages: ($$value) => {
          messages = $$value;
          $$settled = false;
        }
      },
      {}
    )}</div></div></div> <div class="pb-[1rem]">${selectedContent ? `<div class="text-xs rounded-xl px-3.5 py-3 w-full markdown-prose-xs"><blockquote><div class="line-clamp-3">${escape(selectedContent?.text)}</div></blockquote></div>` : ``} ${validate_component(MessageInput, "MessageInput").$$render(
      $$result,
      {
        acceptFiles: false,
        inputLoading: loading,
        showFormattingToolbar: false,
        onSubmit: submitHandler,
        onStop,
        chatInputElement
      },
      {
        chatInputElement: ($$value) => {
          chatInputElement = $$value;
          $$settled = false;
        }
      },
      {
        menu: () => {
          return `<div slot="menu" class="flex items-center justify-between gap-2 w-full pr-1"><div>${validate_component(Tooltip, "Tooltip").$$render(
            $$result,
            {
              content: $i18n.t("Edit"),
              placement: "top"
            },
            {},
            {
              default: () => {
                return `<button ${streaming || loading ? "disabled" : ""} type="button" class="${"px-2 @xl:px-2.5 py-2 flex gap-1.5 items-center text-sm rounded-full transition-colors duration-300 focus:outline-hidden max-w-full overflow-hidden hover:bg-gray-50 dark:hover:bg-gray-800 " + escape(
                  "bg-transparent text-gray-600 dark:text-gray-300 ",
                  true
                ) + " disabled:opacity-50 disabled:pointer-events-none"}">${validate_component(PencilSquare, "PencilSquare").$$render($$result, { className: "size-4", strokeWidth: "1.75" }, {}, {})} <span class="block whitespace-nowrap overflow-hidden text-ellipsis leading-none pr-0.5">${escape($i18n.t("Edit"))}</span></button>`;
              }
            }
          )}</div> ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: selectedModelId }, {}, {
            default: () => {
              return `<select class="bg-transparent rounded-lg py-1 px-2 -mx-0.5 text-sm outline-hidden w-full text-right pr-5">${each($models.filter((model) => !(model?.info?.meta?.hidden ?? false)), (model) => {
                return `<option${add_attribute("value", model.id, 0)} class="bg-gray-50 dark:bg-gray-700">${escape(model.name)}</option>`;
              })}</select>`;
            }
          })}</div>`;
        }
      }
    )}</div></div></div></div></div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_models();
  return $$rendered;
});
const Calendar = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-3" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5"></path></svg>`;
});
const Users = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-3" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z"></path></svg>`;
});
const Mic = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M12 18.75a6 6 0 0 0 6-6v-1.5m-6 7.5a6 6 0 0 1-6-6v-1.5m6 7.5v3.75m-3.75 0h7.5M12 15.75a3 3 0 0 1-3-3V4.5a3 3 0 1 1 6 0v8.25a3 3 0 0 1-3 3Z"></path></svg>`;
});
const CursorArrowRays = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M15.042 21.672 13.684 16.6m0 0-2.51 2.225.569-9.47 5.227 7.917-3.286-.672ZM12 2.25V4.5m5.834.166-1.591 1.591M20.25 10.5H18M7.757 14.743l-1.59 1.59M6 10.5H3.75m4.007-4.243-1.59-1.59"></path></svg>`;
});
const RecordMenu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { className = "max-w-[170px]" } = $$props;
  let { onRecord = () => {
  } } = $$props;
  let { onCaptureAudio = () => {
  } } = $$props;
  let { onUpload = () => {
  } } = $$props;
  const dispatch = createEventDispatcher();
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.onRecord === void 0 && $$bindings.onRecord && onRecord !== void 0) $$bindings.onRecord(onRecord);
  if ($$props.onCaptureAudio === void 0 && $$bindings.onCaptureAudio && onCaptureAudio !== void 0) $$bindings.onCaptureAudio(onCaptureAudio);
  if ($$props.onUpload === void 0 && $$bindings.onUpload && onUpload !== void 0) $$bindings.onUpload(onUpload);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Menu, "DropdownMenu.Root").$$render(
      $$result,
      {
        onOpenChange: (state) => {
          dispatch("change", state);
        },
        open: show
      },
      {
        open: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `${validate_component(Menu_trigger, "DropdownMenu.Trigger").$$render($$result, {}, {}, {
            default: () => {
              return `${slots.default ? slots.default({}) : ``}`;
            }
          })} ${slots.content ? slots.content({}) : ` ${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full " + className + " text-sm rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg font-primary",
              sideOffset: 8,
              side: "bottom",
              align: "start",
              transition: (e) => fade(e, { duration: 100 })
            },
            {},
            {
              default: () => {
                return `<button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">${validate_component(Mic, "Mic").$$render($$result, { className: "size-4", strokeWidth: "2" }, {}, {})}</div> <div class="self-center truncate">${escape($i18n.t("Record"))}</div></button> <button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">${validate_component(CursorArrowRays, "CursorArrowRays").$$render($$result, { className: "size-4", strokeWidth: "2" }, {}, {})}</div> <div class="self-center truncate">${escape($i18n.t("Capture Audio"))}</div></button> <button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">${validate_component(CloudArrowUp, "CloudArrowUp").$$render($$result, { className: "size-4", strokeWidth: "2" }, {}, {})}</div> <div class="self-center truncate">${escape($i18n.t("Upload Audio"))}</div></button>`;
              }
            }
          )} `}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const SparklesSolid = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"${add_attribute("class", className, 0)}><path fill-rule="evenodd" d="M9 4.5a.75.75 0 0 1 .721.544l.813 2.846a3.75 3.75 0 0 0 2.576 2.576l2.846.813a.75.75 0 0 1 0 1.442l-2.846.813a3.75 3.75 0 0 0-2.576 2.576l-.813 2.846a.75.75 0 0 1-1.442 0l-.813-2.846a3.75 3.75 0 0 0-2.576-2.576l-2.846-.813a.75.75 0 0 1 0-1.442l2.846-.813A3.75 3.75 0 0 0 7.466 7.89l.813-2.846A.75.75 0 0 1 9 4.5ZM18 1.5a.75.75 0 0 1 .728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 0 1 0 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 0 1-1.456 0l-.258-1.036a2.625 2.625 0 0 0-1.91-1.91l-1.036-.258a.75.75 0 0 1 0-1.456l1.036-.258a2.625 2.625 0 0 0 1.91-1.91l.258-1.036A.75.75 0 0 1 18 1.5ZM16.5 15a.75.75 0 0 1 .712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 0 1 0 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 0 1-1.422 0l-.395-1.183a1.5 1.5 0 0 0-.948-.948l-1.183-.395a.75.75 0 0 1 0-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0 1 16.5 15Z" clip-rule="evenodd"></path></svg>`;
});
const ArrowUturnLeft = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3"></path></svg>`;
});
const ArrowUturnRight = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3"></path></svg>`;
});
const AIMenu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { className = "max-w-[170px]" } = $$props;
  let { onEdit = () => {
  } } = $$props;
  let { onChat = () => {
  } } = $$props;
  let { onChange = () => {
  } } = $$props;
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.onEdit === void 0 && $$bindings.onEdit && onEdit !== void 0) $$bindings.onEdit(onEdit);
  if ($$props.onChat === void 0 && $$bindings.onChat && onChat !== void 0) $$bindings.onChat(onChat);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Menu, "DropdownMenu.Root").$$render(
      $$result,
      { onOpenChange: onChange, open: show },
      {
        open: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `${validate_component(Menu_trigger, "DropdownMenu.Trigger").$$render($$result, {}, {}, {
            default: () => {
              return `${slots.default ? slots.default({}) : ``}`;
            }
          })} ${slots.content ? slots.content({}) : ` ${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full " + className + " text-sm rounded-xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg font-primary",
              sideOffset: 8,
              side: "bottom",
              align: "end",
              transition: (e) => fade(e, { duration: 100 })
            },
            {},
            {
              default: () => {
                return `<button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">${validate_component(Sparkles, "Sparkles").$$render($$result, { className: "size-4", strokeWidth: "2" }, {}, {})}</div> <div class="self-center truncate">${escape($i18n.t("Enhance"))}</div></button> <button class="flex rounded-md py-1.5 px-3 w-full hover:bg-gray-50 dark:hover:bg-gray-800 transition"><div class="self-center mr-2">${validate_component(ChatBubbleOval, "ChatBubbleOval").$$render($$result, { className: "size-4", strokeWidth: "2" }, {}, {})}</div> <div class="self-center truncate">${escape($i18n.t("Chat"))}</div></button>`;
              }
            }
          )} `}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const AdjustmentsHorizontalOutline = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 1 1-3 0m3 0a1.5 1.5 0 1 0-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-9.75 0h9.75"></path></svg>`;
});
function areContentsEqual(a, b) {
  return JSON.stringify(a) === JSON.stringify(b);
}
function insertNoteVersion(note2) {
  const current = {
    json: note2.data.content.json,
    html: note2.data.content.html,
    md: note2.data.content.md
  };
  const lastVersion = note2.data.versions?.at(-1);
  if (!lastVersion || !areContentsEqual(lastVersion, current)) {
    note2.data.versions = (note2.data.versions ?? []).concat(current);
    return true;
  }
  return false;
}
const NoteEditor = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $socket, $$unsubscribe_socket;
  let $models, $$unsubscribe_models;
  let $config, $$unsubscribe_config;
  let $settings, $$unsubscribe_settings;
  let $i18n, $$unsubscribe_i18n;
  let $WEBUI_NAME, $$unsubscribe_WEBUI_NAME;
  let $mobile, $$unsubscribe_mobile;
  let $showSidebar, $$unsubscribe_showSidebar;
  let $user, $$unsubscribe_user;
  $$unsubscribe_socket = subscribe(socket, (value) => $socket = value);
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_WEBUI_NAME = subscribe(WEBUI_NAME, (value) => $WEBUI_NAME = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const { saveAs } = fileSaver;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  dayjs.extend(calendar);
  dayjs.extend(duration);
  dayjs.extend(relativeTime);
  async function loadLocale(locales) {
    for (const locale of locales) {
      try {
        dayjs.locale(locale);
        break;
      } catch (error) {
        /* @__PURE__ */ console.error(`Could not load locale '${locale}':`, error);
      }
    }
  }
  let { id = null } = $$props;
  let editor = null;
  let note = null;
  let files = [];
  let messages = [];
  let wordCount = 0;
  let charCount = 0;
  let versionIdx = null;
  let selectedModelId = null;
  let recording = false;
  let displayMediaRecord = false;
  let showPanel = false;
  let selectedPanel = "chat";
  let selectedContent = null;
  let showDeleteConfirm = false;
  let showAccessControlModal = false;
  let titleGenerating = false;
  let dragged = false;
  let loading = false;
  let editing = false;
  let streaming = false;
  let stopResponseFlag = false;
  let inputElement = null;
  const init = async () => {
    loading = true;
    const res = await getNoteById(localStorage.token, id).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    messages = [];
    if (res) {
      note = res;
      files = res.data.files || [];
    } else {
      goto();
      return;
    }
    loading = false;
  };
  let debounceTimeout = null;
  const changeDebounceHandler = () => {
    if (debounceTimeout) {
      clearTimeout(debounceTimeout);
    }
    debounceTimeout = setTimeout(
      async () => {
        await updateNoteById(localStorage.token, id, {
          title: note?.title === "" ? $i18n.t("Untitled") : note.title,
          data: { files },
          access_control: note?.access_control
        }).catch((e) => {
          toast.error(`${e}`);
        });
      },
      200
    );
  };
  const onEdited = async () => {
    if (!editor) return;
    editor.commands.setContent(note.data.content.html);
  };
  async function enhanceNoteHandler() {
    if (selectedModelId === "") {
      toast.error($i18n.t("Please select a model."));
      return;
    }
    const model = $models.filter((model2) => model2.id === selectedModelId && !(model2?.info?.meta?.hidden ?? false)).find((model2) => model2.id === selectedModelId);
    if (!model) {
      selectedModelId = "";
      return;
    }
    editing = true;
    await enhanceCompletionHandler(model);
    editing = false;
    onEdited();
    versionIdx = null;
  }
  const stopResponseHandler = async () => {
    stopResponseFlag = true;
    /* @__PURE__ */ console.log("stopResponse", stopResponseFlag);
  };
  const uploadFileHandler = async (file) => {
    const tempItemId = v4();
    const fileItem = {
      type: "file",
      file: "",
      id: null,
      url: "",
      name: file.name,
      collection_name: "",
      status: "uploading",
      size: file.size,
      error: "",
      itemId: tempItemId
    };
    if (fileItem.size == 0) {
      toast.error($i18n.t("You cannot upload an empty file."));
      return null;
    }
    files = [...files, fileItem];
    selectedPanel = "settings";
    if (!showPanel) {
      showPanel = true;
    }
    try {
      let metadata = null;
      if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && $settings?.audio?.stt?.language) {
        metadata = {
          language: $settings?.audio?.stt?.language
        };
      }
      const uploadedFile = await uploadFile(localStorage.token, file, metadata);
      if (uploadedFile) {
        /* @__PURE__ */ console.log("File upload completed:", {
          id: uploadedFile.id,
          name: fileItem.name,
          collection: uploadedFile?.meta?.collection_name
        });
        if (uploadedFile.error) {
          console.warn("File upload warning:", uploadedFile.error);
          toast.warning(uploadedFile.error);
        }
        fileItem.status = "uploaded";
        fileItem.file = uploadedFile;
        fileItem.id = uploadedFile.id;
        fileItem.collection_name = uploadedFile?.meta?.collection_name || uploadedFile?.collection_name;
        fileItem.url = `${WEBUI_API_BASE_URL}/files/${uploadedFile.id}`;
        files = files;
      } else {
        files = files.filter((item) => item?.itemId !== tempItemId);
      }
    } catch (e) {
      toast.error(`${e}`);
      files = files.filter((item) => item?.itemId !== tempItemId);
    }
    if (files.length > 0) {
      note.data.files = files;
    } else {
      note.data.files = null;
    }
    editor.storage.files = files;
    changeDebounceHandler();
    return fileItem;
  };
  const compressImageHandler = async (imageUrl, settings2 = {}, config2 = {}) => {
    const settingsCompression = settings2?.imageCompression ?? false;
    const configWidth = config2?.file?.image_compression?.width ?? null;
    const configHeight = config2?.file?.image_compression?.height ?? null;
    if (!settingsCompression && !configWidth && !configHeight) {
      return imageUrl;
    }
    let width = null;
    let height = null;
    if (settingsCompression) {
      width = settings2?.imageCompressionSize?.width ?? null;
      height = settings2?.imageCompressionSize?.height ?? null;
    }
    if (configWidth && (width === null || width > configWidth)) {
      width = configWidth;
    }
    if (configHeight && (height === null || height > configHeight)) {
      height = configHeight;
    }
    if (width || height) {
      return await compressImage(imageUrl, width, height);
    }
    return imageUrl;
  };
  const inputFileHandler = async (file) => {
    /* @__PURE__ */ console.log("Processing file:", {
      name: file.name,
      type: file.type,
      size: file.size,
      extension: file.name.split(".").at(-1)
    });
    if (($config?.file?.max_size ?? null) !== null && file.size > ($config?.file?.max_size ?? 0) * 1024 * 1024) {
      /* @__PURE__ */ console.log("File exceeds max size limit:", {
        fileSize: file.size,
        maxSize: ($config?.file?.max_size ?? 0) * 1024 * 1024
      });
      toast.error($i18n.t(`File size should not exceed {{maxSize}} MB.`, { maxSize: $config?.file?.max_size }));
      return;
    }
    if (file["type"].startsWith("image/")) {
      const uploadImagePromise = new Promise(async (resolve, reject) => {
        let reader = new FileReader();
        reader.onload = async (event) => {
          try {
            let imageUrl = event.target.result;
            imageUrl = await compressImageHandler(imageUrl, $settings, $config);
            const fileId = v4();
            const fileItem = {
              id: fileId,
              type: "image",
              url: `${imageUrl}`
            };
            files = [...files, fileItem];
            note.data.files = files;
            editor.storage.files = files;
            changeDebounceHandler();
            resolve(fileItem);
          } catch (err) {
            reject(err);
          }
        };
        reader.readAsDataURL(file["type"] === "image/heic" ? await convertHeicToJpeg(file) : file);
      });
      return await uploadImagePromise;
    } else {
      return await uploadFileHandler(file);
    }
  };
  const downloadHandler = async (type) => {
    /* @__PURE__ */ console.log("downloadHandler", type);
    if (type === "txt") {
      const blob = new Blob([note.data.content.md], { type: "text/plain" });
      saveAs(blob, `${note.title}.txt`);
    } else if (type === "md") {
      const blob = new Blob([note.data.content.md], { type: "text/markdown" });
      saveAs(blob, `${note.title}.md`);
    } else if (type === "pdf") {
      await downloadPdf(note);
    }
  };
  const downloadPdf = async (note2) => {
    try {
      const [{ default: jsPDF }, { default: html2canvas }] = await Promise.all([import("jspdf"), import("html2canvas-pro")]);
      const virtualWidth = 1024;
      const virtualHeight = 1400;
      const html = note2.data?.content?.html ?? "";
      const isDarkMode = document.documentElement.classList.contains("dark");
      let node;
      if (html instanceof HTMLElement) {
        node = html;
      } else {
        const virtualWidth2 = 800;
        node = document.createElement("div");
        const titleNode = document.createElement("div");
        titleNode.textContent = note2.title;
        titleNode.style.fontSize = "24px";
        titleNode.style.fontWeight = "medium";
        titleNode.style.paddingBottom = "20px";
        titleNode.style.color = isDarkMode ? "white" : "black";
        node.appendChild(titleNode);
        const contentNode = document.createElement("div");
        contentNode.innerHTML = html;
        node.appendChild(contentNode);
        node.classList.add("text-black");
        node.classList.add("dark:text-white");
        node.style.width = `${virtualWidth2}px`;
        node.style.position = "absolute";
        node.style.left = "-9999px";
        node.style.height = "auto";
        node.style.padding = "40px 40px";
        /* @__PURE__ */ console.log(node);
        document.body.appendChild(node);
      }
      const canvas = await html2canvas(node, {
        useCORS: true,
        backgroundColor: isDarkMode ? "#000" : "#fff",
        scale: 2,
        // Keep at 1x to avoid unexpected enlargements
        width: virtualWidth,
        // Set fixed virtual screen width
        windowWidth: virtualWidth,
        // Ensure consistent rendering
        windowHeight: virtualHeight
      });
      if (!(html instanceof HTMLElement)) {
        document.body.removeChild(node);
      }
      const imgData = canvas.toDataURL("image/jpeg", 0.7);
      const pdf = new jsPDF("p", "mm", "a4");
      const imgWidth = 210;
      const pageWidthMM = 210;
      const pageHeight = 297;
      const pageHeightMM = 297;
      if (isDarkMode) {
        pdf.setFillColor(0, 0, 0);
        pdf.rect(0, 0, pageWidthMM, pageHeightMM, "F");
      }
      const imgHeight = canvas.height * imgWidth / canvas.width;
      let heightLeft = imgHeight;
      let position = 0;
      pdf.addImage(imgData, "JPEG", 0, position, imgWidth, imgHeight);
      heightLeft -= pageHeight;
      while (heightLeft > 0) {
        position -= pageHeight;
        pdf.addPage();
        if (isDarkMode) {
          pdf.setFillColor(0, 0, 0);
          pdf.rect(0, 0, pageWidthMM, pageHeightMM, "F");
        }
        pdf.addImage(imgData, "JPEG", 0, position, imgWidth, imgHeight);
        heightLeft -= pageHeight;
      }
      pdf.save(`${note2.title}.pdf`);
    } catch (error) {
      /* @__PURE__ */ console.error("Error generating PDF", error);
      toast.error(`${error}`);
    }
  };
  const scrollToBottom = () => {
    const element = document.getElementById("note-content-container");
    if (element) {
      element.scrollTop = element?.scrollHeight;
    }
  };
  const enhanceCompletionHandler = async (model) => {
    stopResponseFlag = false;
    let enhancedContent = { json: null, html: "", md: "" };
    const systemPrompt = `Enhance existing notes using additional context provided from audio transcription or uploaded file content in the content's primary language. Your task is to make the notes more useful and comprehensive by incorporating relevant information from the provided context.

Input will be provided within <notes> and <context> XML tags, providing a structure for the existing notes and context respectively.

# Output Format

Provide the enhanced notes in markdown format. Use markdown syntax for headings, lists, task lists ([ ]) where tasks or checklists are strongly implied, and emphasis to improve clarity and presentation. Ensure that all integrated content from the context is accurately reflected. Return only the markdown formatted note.
`;
    const [res, controller] = await chatCompletion(
      localStorage.token,
      {
        model: model.id,
        stream: true,
        messages: [
          { role: "system", content: systemPrompt },
          {
            role: "user",
            content: `<notes>${note.data.content.md}</notes>` + (files && files.length > 0 ? `
<context>${files.map((file) => `${file.name}: ${file?.file?.data?.content ?? "Could not extract content"}
`).join("")}</context>` : "")
          }
        ]
      },
      `${WEBUI_BASE_URL}/api`
    );
    await tick();
    streaming = true;
    if (res && res.ok) {
      const reader = res.body.pipeThrough(new TextDecoderStream()).pipeThrough(splitStream("\n")).getReader();
      while (true) {
        const { value, done } = await reader.read();
        if (done || stopResponseFlag) {
          if (stopResponseFlag) {
            controller.abort("User: Stop Response");
          }
          editing = false;
          streaming = false;
          break;
        }
        try {
          let lines = value.split("\n");
          for (const line of lines) {
            if (line !== "") {
              /* @__PURE__ */ console.log(line);
              if (line === "data: [DONE]") {
                /* @__PURE__ */ console.log(line);
              } else {
                let data = JSON.parse(line.replace(/^data: /, ""));
                /* @__PURE__ */ console.log(data);
                if (data.choices && data.choices.length > 0) {
                  const choice = data.choices[0];
                  if (choice.delta && choice.delta.content) {
                    enhancedContent.md += choice.delta.content;
                    enhancedContent.html = marked.parse(enhancedContent.md);
                    note.data.content.md = enhancedContent.md;
                    note.data.content.html = enhancedContent.html;
                    note.data.content.json = null;
                    scrollToBottom();
                  }
                }
              }
            }
          }
        } catch (error) {
          /* @__PURE__ */ console.log(error);
        }
      }
    }
    streaming = false;
  };
  const insertHandler = (content) => {
    insertNoteVersion(note);
    inputElement?.insertContent(content);
  };
  const noteEventHandler = async (_note) => {
    /* @__PURE__ */ console.log("noteEventHandler", _note);
    if (_note.id !== id) return;
    if (_note.access_control && _note.access_control !== note.access_control) {
      note.access_control = _note.access_control;
    }
    if (_note.data && _note.data.files) {
      files = _note.data.files;
      note.data.files = files;
    }
    if (_note.title && _note.title) {
      note.title = _note.title;
    }
    editor.storage.files = files;
    await tick();
    for (const file of files) {
      if (file.type === "image") {
        const e = new CustomEvent("data", { files });
        const img = document.getElementById(`image:${file.id}`);
        if (img) {
          img.dispatchEvent(e);
        }
      }
    }
  };
  onDestroy(() => {
    /* @__PURE__ */ console.log("destroy");
    $socket?.off("note-events", noteEventHandler);
    document.getElementById("note-editor");
  });
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      loadLocale($i18n.languages);
    }
    {
      if (id) {
        init();
      }
    }
    $$rendered = `${$$result.head += `<!-- HEAD_svelte-zkgjga_START -->${$$result.title = `<title> ${escape(note?.title ? `${note?.title.length > 30 ? `${note?.title.slice(0, 30)}...` : note?.title} • ${$WEBUI_NAME}` : `${$WEBUI_NAME}`)} </title>`, ""}<!-- HEAD_svelte-zkgjga_END -->`, ""} ${note ? `${validate_component(AccessControlModal, "AccessControlModal").$$render(
      $$result,
      {
        accessRoles: ["read", "write"],
        onChange: () => {
          changeDebounceHandler();
        },
        show: showAccessControlModal,
        accessControl: note.access_control
      },
      {
        show: ($$value) => {
          showAccessControlModal = $$value;
          $$settled = false;
        },
        accessControl: ($$value) => {
          note.access_control = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : ``} ${validate_component(FilesOverlay, "FilesOverlay").$$render($$result, { show: dragged }, {}, {})} ${validate_component(ConfirmDialog, "DeleteConfirmDialog").$$render(
      $$result,
      {
        title: $i18n.t("Delete note?"),
        show: showDeleteConfirm
      },
      {
        show: ($$value) => {
          showDeleteConfirm = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="text-sm text-gray-500">${escape($i18n.t("This will delete"))} <span class="font-semibold">${escape(note.title)}</span>.</div>`;
        }
      }
    )} ${validate_component(Pane_group, "PaneGroup").$$render(
      $$result,
      {
        direction: "horizontal",
        class: "w-full h-full"
      },
      {},
      {
        default: () => {
          return `${validate_component(Pane, "Pane").$$render(
            $$result,
            {
              defaultSize: 70,
              minSize: 30,
              class: "h-full flex flex-col w-full relative"
            },
            {},
            {
              default: () => {
                return `<div class="relative flex-1 w-full h-full flex justify-center pt-[11px]" id="note-editor">${loading ? `<div class="absolute top-0 bottom-0 left-0 right-0 flex"><div class="m-auto">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</div></div>` : `<div class="${"w-full flex flex-col " + escape(loading ? "opacity-20" : "", true)}"><div class="shrink-0 w-full flex justify-between items-center px-3.5 mb-1.5"><div class="w-full flex items-center">${$mobile ? `<div class="${escape($showSidebar ? "md:hidden pl-0.5" : "", true) + " flex flex-none items-center pr-1 -translate-x-1"}">${validate_component(Tooltip, "Tooltip").$$render(
                  $$result,
                  {
                    content: $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar")
                  },
                  {},
                  {
                    default: () => {
                      return `<button id="sidebar-toggle-button" class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition cursor-"><div class="self-center p-1.5">${validate_component(Sidebar, "Sidebar").$$render($$result, {}, {}, {})}</div></button>`;
                    }
                  }
                )}</div>` : ``} <input class="w-full text-2xl font-medium bg-transparent outline-hidden" type="text"${add_attribute(
                  "placeholder",
                  $i18n.t("Title"),
                  0
                )} ${note?.user_id !== $user?.id && $user?.role !== "admin" || titleGenerating ? "disabled" : ""} required${add_attribute("value", note.title, 0)}> ${``} <div class="flex items-center gap-0.5 translate-x-1">${editor ? `<div><div class="flex items-center gap-0.5 self-center min-w-fit" dir="ltr"><button class="self-center p-1 hover:enabled:bg-black/5 dark:hover:enabled:bg-white/5 dark:hover:enabled:text-white hover:enabled:text-black rounded-md transition disabled:cursor-not-allowed disabled:text-gray-500 disabled:hover:text-gray-500" ${!editor.can().undo() ? "disabled" : ""}>${validate_component(ArrowUturnLeft, "ArrowUturnLeft").$$render($$result, { className: "size-4" }, {}, {})}</button> <button class="self-center p-1 hover:enabled:bg-black/5 dark:hover:enabled:bg-white/5 dark:hover:enabled:text-white hover:enabled:text-black rounded-md transition disabled:cursor-not-allowed disabled:text-gray-500 disabled:hover:text-gray-500" ${!editor.can().redo() ? "disabled" : ""}>${validate_component(ArrowUturnRight, "ArrowUturnRight").$$render($$result, { className: "size-4" }, {}, {})}</button></div></div>` : ``} ${validate_component(Tooltip, "Tooltip").$$render(
                  $$result,
                  {
                    placement: "top",
                    content: $i18n.t("Chat"),
                    className: "cursor-pointer"
                  },
                  {},
                  {
                    default: () => {
                      return `<button class="p-1.5 bg-transparent hover:bg-white/5 transition rounded-lg">${validate_component(ChatBubbleOval, "ChatBubbleOval").$$render($$result, {}, {}, {})}</button>`;
                    }
                  }
                )} ${validate_component(Tooltip, "Tooltip").$$render(
                  $$result,
                  {
                    placement: "top",
                    content: $i18n.t("Controls"),
                    className: "cursor-pointer"
                  },
                  {},
                  {
                    default: () => {
                      return `<button class="p-1.5 bg-transparent hover:bg-white/5 transition rounded-lg">${validate_component(AdjustmentsHorizontalOutline, "AdjustmentsHorizontalOutline").$$render($$result, {}, {}, {})}</button>`;
                    }
                  }
                )} ${validate_component(NoteMenu, "NoteMenu").$$render(
                  $$result,
                  {
                    onDownload: (type) => {
                      downloadHandler(type);
                    },
                    onCopyLink: async () => {
                      const baseUrl = window.location.origin;
                      const res = await copyToClipboard(`${baseUrl}/notes/${note.id}`);
                      if (res) {
                        toast.success($i18n.t("Copied link to clipboard"));
                      } else {
                        toast.error($i18n.t("Failed to copy link"));
                      }
                    },
                    onCopyToClipboard: async () => {
                      const res = await copyToClipboard(note.data.content.md, note.data.content.html, true).catch((error) => {
                        toast.error(`${error}`);
                        return null;
                      });
                      if (res) {
                        toast.success($i18n.t("Copied to clipboard"));
                      }
                    },
                    onDelete: () => {
                      showDeleteConfirm = true;
                    }
                  },
                  {},
                  {
                    default: () => {
                      return `<div class="p-1 bg-transparent hover:bg-white/5 transition rounded-lg">${validate_component(EllipsisHorizontal, "EllipsisHorizontal").$$render($$result, { className: "size-5" }, {}, {})}</div>`;
                    }
                  }
                )}</div></div></div> <div class="px-2.5"><div class="flex w-full bg-transparent overflow-x-auto scrollbar-none"><div class="flex gap-1 items-center text-xs font-medium text-gray-500 dark:text-gray-500 w-fit"><button class="flex items-center gap-1 w-fit py-1 px-1.5 rounded-lg min-w-fit">${validate_component(Calendar, "Calendar").$$render($$result, { className: "size-3.5", strokeWidth: "2" }, {}, {})}  ${dayjs(note.created_at / 1e6).isSame(dayjs(), "day") ? `<span>${escape(dayjs(note.created_at / 1e6).format($i18n.t("[Today at] h:mm A")))}</span>` : `${dayjs(note.created_at / 1e6).isSame(dayjs().subtract(1, "day"), "day") ? `<span>${escape(dayjs(note.created_at / 1e6).format($i18n.t("[Yesterday at] h:mm A")))}</span>` : `${dayjs(note.created_at / 1e6).isSame(dayjs().subtract(1, "week"), "week") ? `<span>${escape(dayjs(note.created_at / 1e6).format($i18n.t("[Last] dddd [at] h:mm A")))}</span>` : `<span>${escape(dayjs(note.created_at / 1e6).format($i18n.t("DD/MM/YYYY")))}</span>`}`}`}</button> <button class="flex items-center gap-1 w-fit py-1 px-1.5 rounded-lg min-w-fit" ${note?.user_id !== $user?.id && $user?.role !== "admin" ? "disabled" : ""}>${validate_component(Users, "Users").$$render($$result, { className: "size-3.5", strokeWidth: "2" }, {}, {})} <span>${escape(note?.access_control ? $i18n.t("Private") : $i18n.t("Everyone"))}</span></button> ${editor ? `<div class="flex items-center gap-1 px-1 min-w-fit"><div>${escape($i18n.t("{{COUNT}} words", { COUNT: wordCount }))}</div> <div>${escape($i18n.t("{{COUNT}} characters", { COUNT: charCount }))}</div></div>` : ``}</div></div></div> <div class="flex-1 w-full h-full overflow-auto px-3.5 pb-20 relative pt-2.5" id="note-content-container">${editing ? `<div class="${"w-full h-full fixed top-0 left-0 " + escape(
                  streaming ? "" : " backdrop-blur-xs  bg-white/10 dark:bg-gray-900/10",
                  true
                ) + " flex items-center justify-center z-10 cursor-not-allowed"}"></div>` : ``} ${validate_component(RichTextInput, "RichTextInput").$$render(
                  $$result,
                  {
                    id: `note-${note.id}`,
                    className: "input-prose-sm px-0.5",
                    json: true,
                    html: note.data?.content?.html,
                    documentId: `note:${note.id}`,
                    collaboration: true,
                    socket: $socket,
                    user: $user,
                    dragHandle: true,
                    link: true,
                    image: true,
                    files,
                    placeholder: $i18n.t("Write something..."),
                    editable: versionIdx === null && !editing,
                    onSelectionUpdate: ({ editor: editor2 }) => {
                      const { from, to } = editor2.state.selection;
                      const selectedText = editor2.state.doc.textBetween(from, to, " ");
                      if (selectedText.length === 0) {
                        selectedContent = null;
                      } else {
                        selectedContent = { text: selectedText, from, to };
                      }
                    },
                    onChange: (content) => {
                      note.data.content.html = content.html;
                      note.data.content.md = content.md;
                      if (editor) {
                        wordCount = editor.storage.characterCount.words();
                        charCount = editor.storage.characterCount.characters();
                      }
                    },
                    fileHandler: true,
                    onFileDrop: (currentEditor, files2, pos) => {
                      files2.forEach(async (file) => {
                        const fileItem = await inputFileHandler(file).catch((error) => {
                          return null;
                        });
                        if (fileItem.type === "image") {
                          currentEditor.chain().insertContentAt(pos, {
                            type: "image",
                            attrs: { src: `data://${fileItem.id}` }
                          }).focus().run();
                        }
                      });
                    },
                    onFilePaste: () => {
                    },
                    this: inputElement,
                    editor,
                    value: note.data.content.json
                  },
                  {
                    this: ($$value) => {
                      inputElement = $$value;
                      $$settled = false;
                    },
                    editor: ($$value) => {
                      editor = $$value;
                      $$settled = false;
                    },
                    value: ($$value) => {
                      note.data.content.json = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}</div></div>`}</div> <div class="absolute z-20 bottom-0 right-0 p-3.5 max-w-full w-full flex"><div class="flex gap-1 w-full min-w-full justify-between">${recording ? `<div class="flex-1 w-full">${validate_component(VoiceRecording, "VoiceRecording").$$render(
                  $$result,
                  {
                    className: "p-1 w-full max-w-full",
                    transcribe: false,
                    displayMedia: displayMediaRecord,
                    echoCancellation: false,
                    noiseSuppression: false,
                    onCancel: () => {
                      recording = false;
                      displayMediaRecord = false;
                    },
                    onConfirm: (data) => {
                      if (data?.file) {
                        uploadFileHandler(data?.file);
                      }
                      recording = false;
                      displayMediaRecord = false;
                    },
                    recording
                  },
                  {
                    recording: ($$value) => {
                      recording = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}</div>` : `${validate_component(RecordMenu, "RecordMenu").$$render(
                  $$result,
                  {
                    onRecord: async () => {
                      displayMediaRecord = false;
                      try {
                        let stream = await navigator.mediaDevices.getUserMedia({ audio: true }).catch(function(err) {
                          toast.error($i18n.t(`Permission denied when accessing microphone: {{error}}`, { error: err }));
                          return null;
                        });
                        if (stream) {
                          recording = true;
                          const tracks = stream.getTracks();
                          tracks.forEach((track) => track.stop());
                        }
                        stream = null;
                      } catch {
                        toast.error($i18n.t("Permission denied when accessing microphone"));
                      }
                    },
                    onCaptureAudio: async () => {
                      displayMediaRecord = true;
                      recording = true;
                    },
                    onUpload: async () => {
                      const input = document.createElement("input");
                      input.type = "file";
                      input.accept = "audio/*";
                      input.multiple = false;
                      input.click();
                      input.onchange = async (e) => {
                        const files2 = e.target.files;
                        if (files2 && files2.length > 0) {
                          await uploadFileHandler(files2[0]);
                        }
                      };
                    }
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(Tooltip, "Tooltip").$$render(
                        $$result,
                        {
                          content: $i18n.t("Record"),
                          placement: "top"
                        },
                        {},
                        {
                          default: () => {
                            return `<div class="cursor-pointer p-2.5 flex rounded-full border border-gray-50 bg-white dark:border-none dark:bg-gray-850 hover:bg-gray-50 dark:hover:bg-gray-800 transition shadow-xl">${validate_component(MicSolid, "MicSolid").$$render($$result, { className: "size-4.5" }, {}, {})}</div>`;
                          }
                        }
                      )}`;
                    }
                  }
                )} <div class="cursor-pointer flex gap-0.5 rounded-full border border-gray-50 dark:border-gray-850 dark:bg-gray-850 transition shadow-xl">${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("AI"), placement: "top" }, {}, {
                  default: () => {
                    return `${editing ? `<button class="p-2 flex justify-center items-center hover:bg-gray-50 dark:hover:bg-gray-800 rounded-full transition shrink-0" type="button">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</button>` : `${validate_component(AIMenu, "AiMenu").$$render(
                      $$result,
                      {
                        onEdit: () => {
                          enhanceNoteHandler();
                        },
                        onChat: () => {
                          showPanel = true;
                          selectedPanel = "chat";
                        }
                      },
                      {},
                      {
                        default: () => {
                          return `<div class="cursor-pointer p-2.5 flex rounded-full border border-gray-50 bg-white dark:border-none dark:bg-gray-850 hover:bg-gray-50 dark:hover:bg-gray-800 transition shadow-xl">${validate_component(SparklesSolid, "SparklesSolid").$$render($$result, {}, {}, {})}</div>`;
                        }
                      }
                    )}`}`;
                  }
                })}</div>`}</div></div>`;
              }
            }
          )} ${validate_component(NotePanel, "NotePanel").$$render(
            $$result,
            { show: showPanel },
            {
              show: ($$value) => {
                showPanel = $$value;
                $$settled = false;
              }
            },
            {
              default: () => {
                return `${selectedPanel === "chat" ? `${validate_component(Chat, "Chat").$$render(
                  $$result,
                  {
                    editor,
                    inputElement,
                    selectedContent,
                    files,
                    onInsert: insertHandler,
                    onStop: stopResponseHandler,
                    onEdited,
                    insertNoteHandler: () => {
                      insertNoteVersion(note);
                    },
                    scrollToBottomHandler: scrollToBottom,
                    show: showPanel,
                    selectedModelId,
                    messages,
                    note,
                    editing,
                    streaming,
                    stopResponseFlag
                  },
                  {
                    show: ($$value) => {
                      showPanel = $$value;
                      $$settled = false;
                    },
                    selectedModelId: ($$value) => {
                      selectedModelId = $$value;
                      $$settled = false;
                    },
                    messages: ($$value) => {
                      messages = $$value;
                      $$settled = false;
                    },
                    note: ($$value) => {
                      note = $$value;
                      $$settled = false;
                    },
                    editing: ($$value) => {
                      editing = $$value;
                      $$settled = false;
                    },
                    streaming: ($$value) => {
                      streaming = $$value;
                      $$settled = false;
                    },
                    stopResponseFlag: ($$value) => {
                      stopResponseFlag = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}` : `${selectedPanel === "settings" ? `${validate_component(Controls, "Controls").$$render(
                  $$result,
                  {
                    onUpdate: () => {
                      changeDebounceHandler();
                    },
                    show: showPanel,
                    selectedModelId,
                    files
                  },
                  {
                    show: ($$value) => {
                      showPanel = $$value;
                      $$settled = false;
                    },
                    selectedModelId: ($$value) => {
                      selectedModelId = $$value;
                      $$settled = false;
                    },
                    files: ($$value) => {
                      files = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}` : ``}`}`;
              }
            }
          )}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_socket();
  $$unsubscribe_models();
  $$unsubscribe_config();
  $$unsubscribe_settings();
  $$unsubscribe_i18n();
  $$unsubscribe_WEBUI_NAME();
  $$unsubscribe_mobile();
  $$unsubscribe_showSidebar();
  $$unsubscribe_user();
  return $$rendered;
});
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $showSidebar, $$unsubscribe_showSidebar;
  let $page, $$unsubscribe_page;
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_page = subscribe(page, (value) => $page = value);
  $$unsubscribe_showSidebar();
  $$unsubscribe_page();
  return `<div id="note-container" class="${"w-full h-full " + escape($showSidebar ? "md:max-w-[calc(100%-260px)]" : "", true)}">${validate_component(NoteEditor, "NoteEditor").$$render($$result, { id: $page.params.id }, {}, {})}</div>`;
});
export {
  Page as default
};
//# sourceMappingURL=_page.svelte.js.map
