import { c as create_ssr_component, l as getContext, v as validate_component, a as add_attribute, b as subscribe, g as escape, q as null_to_empty, e as each, o as onDestroy } from "../../../../../chunks/ssr.js";
import { p as page } from "../../../../../chunks/stores.js";
import { t as tick } from "../../../../../chunks/ssr2.js";
import { a as toast } from "../../../../../chunks/Toaster.svelte_svelte_type_style_lang.js";
import { a as Pane_group, P as Pane, D as Drawer } from "../../../../../chunks/Drawer.js";
import { g as goto } from "../../../../../chunks/client.js";
import { u as user, a as settings, D as WEBUI_API_BASE_URL, h as WEBUI_BASE_URL, m as mobile, n as showSidebar, s as socket, d as chatId } from "../../../../../chunks/index.js";
import { d as deleteMessage, a as updateMessage, r as removeReaction, b as addReaction, e as getChannelThreadMessages, s as sendMessage, f as getChannelById, h as getChannelMessages } from "../../../../../chunks/index5.js";
import dayjs from "dayjs";
import relativeTime from "dayjs/plugin/relativeTime.js";
import isToday from "dayjs/plugin/isToday.js";
import isYesterday from "dayjs/plugin/isYesterday.js";
import localizedFormat from "dayjs/plugin/localizedFormat.js";
import { w as formatDate } from "../../../../../chunks/index2.js";
import { L as Link_preview, b as Link_preview_trigger, U as UserStatusLinkPreview, M as Markdown, I as Image } from "../../../../../chunks/Collapsible.js";
import { P as ProfileImage, N as Name, L as Loader } from "../../../../../chunks/ProfileImage.js";
import { C as ConfirmDialog } from "../../../../../chunks/ConfirmDialog.js";
import { G as GarbageBin } from "../../../../../chunks/GarbageBin.js";
import { P as Pencil } from "../../../../../chunks/Pencil.js";
import { T as Tooltip } from "../../../../../chunks/Tooltip.js";
import { C as ChatBubble, a as FileItem, S as Skeleton } from "../../../../../chunks/FileItem.js";
import "dequal";
import "../../../../../chunks/create.js";
import { E as EmojiPicker } from "../../../../../chunks/EmojiPicker.js";
import { C as ChevronRight } from "../../../../../chunks/ChevronRight.js";
import { E as Emoji } from "../../../../../chunks/Emoji.js";
import { S as Spinner } from "../../../../../chunks/Spinner.js";
import { M as MessageInput } from "../../../../../chunks/MessageInput.js";
import { U as UserMenu } from "../../../../../chunks/UserMenu.js";
import { S as Sidebar } from "../../../../../chunks/Sidebar.js";
import { X as XMark } from "../../../../../chunks/XMark.js";
import { i as i18n } from "../../../../../chunks/index3.js";
const ProfilePreview = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  let { user: user2 = null } = $$props;
  if ($$props.user === void 0 && $$bindings.user && user2 !== void 0) $$bindings.user(user2);
  return `${validate_component(Link_preview, "LinkPreview.Root").$$render($$result, { openDelay: 0, closeDelay: 0 }, {}, {
    default: () => {
      return `${validate_component(Link_preview_trigger, "LinkPreview.Trigger").$$render(
        $$result,
        {
          class: " cursor-pointer no-underline! font-normal! "
        },
        {},
        {
          default: () => {
            return `${slots.default ? slots.default({}) : ``}`;
          }
        }
      )} ${validate_component(UserStatusLinkPreview, "UserStatusLinkPreview").$$render(
        $$result,
        {
          id: user2?.id,
          side: "right",
          align: "center",
          sideOffset: 8
        },
        {},
        {}
      )}`;
    }
  })}`;
});
const FaceSmile = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M15.182 15.182a4.5 4.5 0 0 1-6.364 0M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0ZM9.75 9.75c0 .414-.168.75-.375.75S9 10.164 9 9.75 9.168 9 9.375 9s.375.336.375.75Zm-.375 0h.008v.015h-.008V9.75Zm5.625 0c0 .414-.168.75-.375.75s-.375-.336-.375-.75.168-.75.375-.75.375.336.375.75Zm-.375 0h.008v.015h-.008V9.75Z"></path></svg>`;
});
const ArrowUpLeftAlt = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M10.25 4.75L6.75 8.25L10.25 11.75" stroke-linecap="round" stroke-linejoin="round"></path><path d="M6.75 8.25L12.75 8.25C14.9591 8.25 16.75 10.0409 16.75 12.25V19.25" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const css = {
  code: ".highlight.svelte-870i4{animation:svelte-870i4-highlightAnimation 2s ease-in-out}@keyframes svelte-870i4-highlightAnimation{0%{background-color:rgba(0, 60, 255, 0.1)}100%{background-color:transparent}}",
  map: `{"version":3,"file":"Message.svelte","sources":["Message.svelte"],"sourcesContent":["<script lang=\\"ts\\">import dayjs from \\"dayjs\\";\\nimport relativeTime from \\"dayjs/plugin/relativeTime\\";\\nimport isToday from \\"dayjs/plugin/isToday\\";\\nimport isYesterday from \\"dayjs/plugin/isYesterday\\";\\nimport localizedFormat from \\"dayjs/plugin/localizedFormat\\";\\ndayjs.extend(relativeTime);\\ndayjs.extend(isToday);\\ndayjs.extend(isYesterday);\\ndayjs.extend(localizedFormat);\\nimport { getContext, onMount } from \\"svelte\\";\\nconst i18n = getContext(\\"i18n\\");\\nimport { formatDate } from \\"$lib/utils\\";\\nimport { settings, user, shortCodesToEmojis } from \\"$lib/stores\\";\\nimport { WEBUI_API_BASE_URL, WEBUI_BASE_URL } from \\"$lib/constants\\";\\nimport Markdown from \\"$lib/components/chat/Messages/Markdown.svelte\\";\\nimport ProfileImage from \\"$lib/components/chat/Messages/ProfileImage.svelte\\";\\nimport Name from \\"$lib/components/chat/Messages/Name.svelte\\";\\nimport ConfirmDialog from \\"$lib/components/common/ConfirmDialog.svelte\\";\\nimport GarbageBin from \\"$lib/components/icons/GarbageBin.svelte\\";\\nimport Pencil from \\"$lib/components/icons/Pencil.svelte\\";\\nimport Tooltip from \\"$lib/components/common/Tooltip.svelte\\";\\nimport Textarea from \\"$lib/components/common/Textarea.svelte\\";\\nimport Image from \\"$lib/components/common/Image.svelte\\";\\nimport FileItem from \\"$lib/components/common/FileItem.svelte\\";\\nimport ProfilePreview from \\"./Message/ProfilePreview.svelte\\";\\nimport ChatBubbleOvalEllipsis from \\"$lib/components/icons/ChatBubble.svelte\\";\\nimport FaceSmile from \\"$lib/components/icons/FaceSmile.svelte\\";\\nimport EmojiPicker from \\"$lib/components/common/EmojiPicker.svelte\\";\\nimport ChevronRight from \\"$lib/components/icons/ChevronRight.svelte\\";\\nimport Emoji from \\"$lib/components/common/Emoji.svelte\\";\\nimport Skeleton from \\"$lib/components/chat/Messages/Skeleton.svelte\\";\\nimport ArrowUpLeftAlt from \\"$lib/components/icons/ArrowUpLeftAlt.svelte\\";\\nexport let message;\\nexport let showUserProfile = true;\\nexport let thread = false;\\nexport let replyToMessage = false;\\nexport let disabled = false;\\nexport let onDelete = () => {\\n};\\nexport let onEdit = () => {\\n};\\nexport let onReply = () => {\\n};\\nexport let onThread = () => {\\n};\\nexport let onReaction = () => {\\n};\\nlet showButtons = false;\\nlet edit = false;\\nlet editedContent = null;\\nlet showDeleteConfirmDialog = false;\\n<\/script>\\n\\n<ConfirmDialog\\n\\tbind:show={showDeleteConfirmDialog}\\n\\ttitle={$i18n.t('Delete Message')}\\n\\tmessage={$i18n.t('Are you sure you want to delete this message?')}\\n\\tonConfirm={async () => {\\n\\t\\tawait onDelete();\\n\\t}}\\n/>\\n\\n{#if message}\\n\\t<div\\n\\t\\tid=\\"message-{message.id}\\"\\n\\t\\tclass=\\"flex flex-col justify-between px-5 {showUserProfile\\n\\t\\t\\t? 'pt-1.5 pb-0.5'\\n\\t\\t\\t: ''} w-full max-w-full mx-auto group hover:bg-gray-300/5 dark:hover:bg-gray-700/5 transition relative {replyToMessage\\n\\t\\t\\t? 'border-l-4 border-blue-500 bg-blue-100/10 dark:bg-blue-100/5 pl-4'\\n\\t\\t\\t: ''} {(message?.reply_to_message?.meta?.model_id ?? message?.reply_to_message?.user_id) ===\\n\\t\\t$user?.id\\n\\t\\t\\t? 'border-l-4 border-orange-500 bg-orange-100/10 dark:bg-orange-100/5 pl-4'\\n\\t\\t\\t: ''}\\"\\n\\t>\\n\\t\\t{#if !edit && !disabled}\\n\\t\\t\\t<div\\n\\t\\t\\t\\tclass=\\" absolute {showButtons ? '' : 'invisible group-hover:visible'} right-1 -top-2 z-10\\"\\n\\t\\t\\t>\\n\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\tclass=\\"flex gap-1 rounded-lg bg-white dark:bg-gray-850 shadow-md p-0.5 border border-gray-100 dark:border-gray-850\\"\\n\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t<EmojiPicker\\n\\t\\t\\t\\t\\t\\tonClose={() => (showButtons = false)}\\n\\t\\t\\t\\t\\t\\tonSubmit={(name) => {\\n\\t\\t\\t\\t\\t\\t\\tshowButtons = false;\\n\\t\\t\\t\\t\\t\\t\\tonReaction(name);\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Add Reaction')}>\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tshowButtons = true;\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<FaceSmile />\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t</EmojiPicker>\\n\\n\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Reply')}>\\n\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\tclass=\\"hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-0.5\\"\\n\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\tonReply(message);\\n\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t<ArrowUpLeftAlt className=\\"size-5\\" />\\n\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t</Tooltip>\\n\\n\\t\\t\\t\\t\\t{#if !thread}\\n\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Reply in Thread')}>\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tonThread(message.id);\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<ChatBubbleOvalEllipsis />\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t{#if message.user_id === $user?.id || $user?.role === 'admin'}\\n\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Edit')}>\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tedit = true;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\teditedContent = message.content;\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<Pencil />\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\n\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Delete')}>\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => (showDeleteConfirmDialog = true)}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<GarbageBin />\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t</div>\\n\\t\\t\\t</div>\\n\\t\\t{/if}\\n\\n\\t\\t{#if message?.reply_to_message?.user}\\n\\t\\t\\t<div class=\\"relative text-xs mb-1\\">\\n\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\tclass=\\"absolute h-3 w-7 left-[18px] top-2 rounded-tl-lg border-t-2 border-l-2 border-gray-300 dark:border-gray-500 z-0\\"\\n\\t\\t\\t\\t></div>\\n\\n\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\tclass=\\"ml-12 flex items-center space-x-2 relative z-0\\"\\n\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\tconst messageElement = document.getElementById(\\n\\t\\t\\t\\t\\t\\t\\t\`message-\${message.reply_to_message.id}\`\\n\\t\\t\\t\\t\\t\\t);\\n\\t\\t\\t\\t\\t\\tif (messageElement) {\\n\\t\\t\\t\\t\\t\\t\\tmessageElement.scrollIntoView({ behavior: 'smooth', block: 'center' });\\n\\t\\t\\t\\t\\t\\t\\tmessageElement.classList.add('highlight');\\n\\t\\t\\t\\t\\t\\t\\tsetTimeout(() => {\\n\\t\\t\\t\\t\\t\\t\\t\\tmessageElement.classList.remove('highlight');\\n\\t\\t\\t\\t\\t\\t\\t}, 2000);\\n\\t\\t\\t\\t\\t\\t\\treturn;\\n\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t{#if message?.reply_to_message?.meta?.model_id}\\n\\t\\t\\t\\t\\t\\t<img\\n\\t\\t\\t\\t\\t\\t\\tsrc={\`\${WEBUI_API_BASE_URL}/models/model/profile/image?id=\${message.reply_to_message.meta.model_id}\`}\\n\\t\\t\\t\\t\\t\\t\\talt={message.reply_to_message.meta.model_name ??\\n\\t\\t\\t\\t\\t\\t\\t\\tmessage.reply_to_message.meta.model_id}\\n\\t\\t\\t\\t\\t\\t\\tclass=\\"size-4 ml-0.5 rounded-full object-cover\\"\\n\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t<img\\n\\t\\t\\t\\t\\t\\t\\tsrc={message.reply_to_message.user?.profile_image_url ??\\n\\t\\t\\t\\t\\t\\t\\t\\t\`\${WEBUI_BASE_URL}/static/favicon.png\`}\\n\\t\\t\\t\\t\\t\\t\\talt={message.reply_to_message.user?.name ?? $i18n.t('Unknown User')}\\n\\t\\t\\t\\t\\t\\t\\tclass=\\"size-4 ml-0.5 rounded-full object-cover\\"\\n\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t<div class=\\"shrink-0\\">\\n\\t\\t\\t\\t\\t\\t{message?.reply_to_message.meta?.model_name ??\\n\\t\\t\\t\\t\\t\\t\\tmessage?.reply_to_message.user?.name ??\\n\\t\\t\\t\\t\\t\\t\\t$i18n.t('Unknown User')}\\n\\t\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t\\t<div class=\\"italic text-sm text-gray-500 dark:text-gray-400 line-clamp-1 w-full flex-1\\">\\n\\t\\t\\t\\t\\t\\t<Markdown id={\`\${message.id}-reply-to\`} content={message?.reply_to_message?.content} />\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t</button>\\n\\t\\t\\t</div>\\n\\t\\t{/if}\\n\\t\\t<div\\n\\t\\t\\tclass=\\" flex w-full message-{message.id}\\"\\n\\t\\t\\tid=\\"message-{message.id}\\"\\n\\t\\t\\tdir={$settings.chatDirection}\\n\\t\\t>\\n\\t\\t\\t<div class={\`shrink-0 mr-3 w-9\`}>\\n\\t\\t\\t\\t{#if showUserProfile}\\n\\t\\t\\t\\t\\t{#if message?.meta?.model_id}\\n\\t\\t\\t\\t\\t\\t<img\\n\\t\\t\\t\\t\\t\\t\\tsrc={\`\${WEBUI_API_BASE_URL}/models/model/profile/image?id=\${message.meta.model_id}\`}\\n\\t\\t\\t\\t\\t\\t\\talt={message.meta.model_name ?? message.meta.model_id}\\n\\t\\t\\t\\t\\t\\t\\tclass=\\"size-8 translate-y-1 ml-0.5 object-cover rounded-full\\"\\n\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t<ProfilePreview user={message.user}>\\n\\t\\t\\t\\t\\t\\t\\t<ProfileImage\\n\\t\\t\\t\\t\\t\\t\\t\\tsrc={message.user?.profile_image_url ?? \`\${WEBUI_BASE_URL}/static/favicon.png\`}\\n\\t\\t\\t\\t\\t\\t\\t\\tclassName={'size-8 ml-0.5'}\\n\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t</ProfilePreview>\\n\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t<!-- <div class=\\"w-7 h-7 rounded-full bg-transparent\\" /> -->\\n\\n\\t\\t\\t\\t\\t{#if message.created_at}\\n\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\tclass=\\"mt-1.5 flex shrink-0 items-center text-xs self-center invisible group-hover:visible text-gray-500 font-medium first-letter:capitalize\\"\\n\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t<Tooltip content={dayjs(message.created_at / 1000000).format('LLLL')}>\\n\\t\\t\\t\\t\\t\\t\\t\\t{dayjs(message.created_at / 1000000).format('HH:mm')}\\n\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t</div>\\n\\n\\t\\t\\t<div class=\\"flex-auto w-0 pl-1\\">\\n\\t\\t\\t\\t{#if showUserProfile}\\n\\t\\t\\t\\t\\t<Name>\\n\\t\\t\\t\\t\\t\\t<div class=\\" self-end text-base shrink-0 font-medium truncate\\">\\n\\t\\t\\t\\t\\t\\t\\t{#if message?.meta?.model_id}\\n\\t\\t\\t\\t\\t\\t\\t\\t{message?.meta?.model_name ?? message?.meta?.model_id}\\n\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t{message?.user?.name}\\n\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t\\t\\t{#if message.created_at}\\n\\t\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\" self-center text-xs invisible group-hover:visible text-gray-400 font-medium first-letter:capitalize ml-0.5 translate-y-[1px]\\"\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={dayjs(message.created_at / 1000000).format('LLLL')}>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<span class=\\"line-clamp-1\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t(formatDate(message.created_at / 1000000), {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tLOCALIZED_TIME: dayjs(message.created_at / 1000000).format('LT'),\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tLOCALIZED_DATE: dayjs(message.created_at / 1000000).format('L')\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t})}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</span>\\n\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t</Name>\\n\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t{#if (message?.data?.files ?? []).length > 0}\\n\\t\\t\\t\\t\\t<div class=\\"my-2.5 w-full flex overflow-x-auto gap-2 flex-wrap\\">\\n\\t\\t\\t\\t\\t\\t{#each message?.data?.files as file}\\n\\t\\t\\t\\t\\t\\t\\t<div>\\n\\t\\t\\t\\t\\t\\t\\t\\t{#if file.type === 'image'}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Image src={file.url} alt={file.name} imageClassName=\\" max-h-96 rounded-lg\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<FileItem\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\titem={file}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\turl={file.url}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tname={file.name}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype={file.type}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsize={file?.size}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsmall={true}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t{/each}\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t{#if edit}\\n\\t\\t\\t\\t\\t<div class=\\"py-2\\">\\n\\t\\t\\t\\t\\t\\t<Textarea\\n\\t\\t\\t\\t\\t\\t\\tclassName=\\" bg-transparent outline-hidden w-full resize-none\\"\\n\\t\\t\\t\\t\\t\\t\\tbind:value={editedContent}\\n\\t\\t\\t\\t\\t\\t\\tonKeydown={(e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\tif (e.key === 'Escape') {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tdocument.getElementById('close-edit-message-button')?.click();\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\tconst isCmdOrCtrlPressed = e.metaKey || e.ctrlKey;\\n\\t\\t\\t\\t\\t\\t\\t\\tconst isEnterPressed = e.key === 'Enter';\\n\\n\\t\\t\\t\\t\\t\\t\\t\\tif (isCmdOrCtrlPressed && isEnterPressed) {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tdocument.getElementById('confirm-edit-message-button')?.click();\\n\\t\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t\\t<div class=\\" mt-2 mb-1 flex justify-end text-sm font-medium\\">\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"flex space-x-1.5\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"close-edit-message-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"px-3.5 py-1.5 bg-white dark:bg-gray-900 hover:bg-gray-100 text-gray-800 dark:text-gray-100 transition rounded-3xl\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tedit = false;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\teditedContent = null;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Cancel')}\\n\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tid=\\"confirm-edit-message-button\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"px-3.5 py-1.5 bg-gray-900 dark:bg-white hover:bg-gray-850 text-gray-100 dark:text-gray-800 transition rounded-3xl\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={async () => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonEdit(editedContent);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tedit = false;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\teditedContent = null;\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Save')}\\n\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t<div class=\\" min-w-full markdown-prose\\">\\n\\t\\t\\t\\t\\t\\t{#if (message?.content ?? '').trim() === '' && message?.meta?.model_id}\\n\\t\\t\\t\\t\\t\\t\\t<Skeleton />\\n\\t\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t\\t<Markdown\\n\\t\\t\\t\\t\\t\\t\\t\\tid={message.id}\\n\\t\\t\\t\\t\\t\\t\\t\\tcontent={message.content}\\n\\t\\t\\t\\t\\t\\t\\t/>{#if message.created_at !== message.updated_at && (message?.meta?.model_id ?? null) === null}<span\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"text-gray-500 text-[10px]\\">({$i18n.t('edited')})</span\\n\\t\\t\\t\\t\\t\\t\\t\\t>{/if}\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t\\t{#if (message?.reactions ?? []).length > 0}\\n\\t\\t\\t\\t\\t\\t<div>\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"flex items-center flex-wrap gap-y-1.5 gap-1 mt-1 mb-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t{#each message.reactions as reaction}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={\`:\${reaction.name}:\`}>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"flex items-center gap-1.5 transition rounded-xl px-2 py-1 cursor-pointer {reaction.user_ids.includes(\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t$user?.id\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ' bg-blue-300/10 outline outline-blue-500/50 outline-1'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'bg-gray-300/10 dark:bg-gray-500/10 hover:outline hover:outline-gray-700/30 dark:hover:outline-gray-300/30 hover:outline-1'}\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonReaction(reaction.name);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Emoji shortCode={reaction.name} />\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{#if reaction.user_ids.length > 0}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\"text-xs font-medium text-gray-500 dark:text-gray-400\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{reaction.user_ids?.length}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t{/each}\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t<EmojiPicker\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tonSubmit={(name) => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tonReaction(name);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Tooltip content={$i18n.t('Add Reaction')}>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"flex items-center gap-1.5 bg-gray-500/10 hover:outline hover:outline-gray-700/30 dark:hover:outline-gray-300/30 hover:outline-1 transition rounded-xl px-1 py-1 cursor-pointer text-gray-500 dark:text-gray-400\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<FaceSmile />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</Tooltip>\\n\\t\\t\\t\\t\\t\\t\\t\\t</EmojiPicker>\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t\\t{#if !thread && message.reply_count > 0}\\n\\t\\t\\t\\t\\t\\t<div class=\\"flex items-center gap-1.5 -mt-0.5 mb-1.5\\">\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"flex items-center text-xs py-1 text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-300 transition\\"\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tonThread(message.id);\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<span class=\\"font-medium mr-1\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('{{COUNT}} Replies', { COUNT: message.reply_count })}</span\\n\\t\\t\\t\\t\\t\\t\\t\\t><span>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{' - '}{$i18n.t('Last reply')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t{dayjs.unix(message.latest_reply_at / 1000000000).fromNow()}</span\\n\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t<span class=\\"ml-1\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<ChevronRight className=\\"size-2.5\\" strokeWidth=\\"3\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</span>\\n\\t\\t\\t\\t\\t\\t\\t\\t<!-- {$i18n.t('View Replies')} -->\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t</div>\\n\\t\\t</div>\\n\\t</div>\\n{/if}\\n\\n<style>\\n\\t.highlight {\\n\\t\\tanimation: highlightAnimation 2s ease-in-out;\\n\\t}\\n\\n\\t@keyframes highlightAnimation {\\n\\t\\t0% {\\n\\t\\t\\tbackground-color: rgba(0, 60, 255, 0.1);\\n\\t\\t}\\n\\t\\t100% {\\n\\t\\t\\tbackground-color: transparent;\\n\\t\\t}\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AAgaC,uBAAW,CACV,SAAS,CAAE,+BAAkB,CAAC,EAAE,CAAC,WAClC,CAEA,WAAW,+BAAmB,CAC7B,EAAG,CACF,gBAAgB,CAAE,KAAK,CAAC,CAAC,CAAC,EAAE,CAAC,CAAC,GAAG,CAAC,CAAC,GAAG,CACvC,CACA,IAAK,CACJ,gBAAgB,CAAE,WACnB,CACD"}`
};
const Message = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  let $settings, $$unsubscribe_settings;
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  dayjs.extend(relativeTime);
  dayjs.extend(isToday);
  dayjs.extend(isYesterday);
  dayjs.extend(localizedFormat);
  const i18n2 = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n2, (value) => $i18n = value);
  let { message } = $$props;
  let { showUserProfile = true } = $$props;
  let { thread = false } = $$props;
  let { replyToMessage = false } = $$props;
  let { disabled = false } = $$props;
  let { onDelete = () => {
  } } = $$props;
  let { onEdit = () => {
  } } = $$props;
  let { onReply = () => {
  } } = $$props;
  let { onThread = () => {
  } } = $$props;
  let { onReaction = () => {
  } } = $$props;
  let showButtons = false;
  let showDeleteConfirmDialog = false;
  if ($$props.message === void 0 && $$bindings.message && message !== void 0) $$bindings.message(message);
  if ($$props.showUserProfile === void 0 && $$bindings.showUserProfile && showUserProfile !== void 0) $$bindings.showUserProfile(showUserProfile);
  if ($$props.thread === void 0 && $$bindings.thread && thread !== void 0) $$bindings.thread(thread);
  if ($$props.replyToMessage === void 0 && $$bindings.replyToMessage && replyToMessage !== void 0) $$bindings.replyToMessage(replyToMessage);
  if ($$props.disabled === void 0 && $$bindings.disabled && disabled !== void 0) $$bindings.disabled(disabled);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  if ($$props.onEdit === void 0 && $$bindings.onEdit && onEdit !== void 0) $$bindings.onEdit(onEdit);
  if ($$props.onReply === void 0 && $$bindings.onReply && onReply !== void 0) $$bindings.onReply(onReply);
  if ($$props.onThread === void 0 && $$bindings.onThread && onThread !== void 0) $$bindings.onThread(onThread);
  if ($$props.onReaction === void 0 && $$bindings.onReaction && onReaction !== void 0) $$bindings.onReaction(onReaction);
  $$result.css.add(css);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(ConfirmDialog, "ConfirmDialog").$$render(
      $$result,
      {
        title: $i18n.t("Delete Message"),
        message: $i18n.t("Are you sure you want to delete this message?"),
        onConfirm: async () => {
          await onDelete();
        },
        show: showDeleteConfirmDialog
      },
      {
        show: ($$value) => {
          showDeleteConfirmDialog = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${message ? `<div id="${"message-" + escape(message.id, true)}" class="${"flex flex-col justify-between px-5 " + escape(showUserProfile ? "pt-1.5 pb-0.5" : "", true) + " w-full max-w-full mx-auto group hover:bg-gray-300/5 dark:hover:bg-gray-700/5 transition relative " + escape(
      replyToMessage ? "border-l-4 border-blue-500 bg-blue-100/10 dark:bg-blue-100/5 pl-4" : "",
      true
    ) + " " + escape(
      (message?.reply_to_message?.meta?.model_id ?? message?.reply_to_message?.user_id) === $user?.id ? "border-l-4 border-orange-500 bg-orange-100/10 dark:bg-orange-100/5 pl-4" : "",
      true
    )}">${!disabled ? `<div class="${"absolute " + escape(showButtons ? "" : "invisible group-hover:visible", true) + " right-1 -top-2 z-10"}"><div class="flex gap-1 rounded-lg bg-white dark:bg-gray-850 shadow-md p-0.5 border border-gray-100 dark:border-gray-850">${validate_component(EmojiPicker, "EmojiPicker").$$render(
      $$result,
      {
        onClose: () => showButtons = false,
        onSubmit: (name) => {
          showButtons = false;
          onReaction(name);
        }
      },
      {},
      {
        default: () => {
          return `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Add Reaction") }, {}, {
            default: () => {
              return `<button class="hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1">${validate_component(FaceSmile, "FaceSmile").$$render($$result, {}, {}, {})}</button>`;
            }
          })}`;
        }
      }
    )} ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Reply") }, {}, {
      default: () => {
        return `<button class="hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-0.5">${validate_component(ArrowUpLeftAlt, "ArrowUpLeftAlt").$$render($$result, { className: "size-5" }, {}, {})}</button>`;
      }
    })} ${!thread ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Reply in Thread") }, {}, {
      default: () => {
        return `<button class="hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1">${validate_component(ChatBubble, "ChatBubbleOvalEllipsis").$$render($$result, {}, {}, {})}</button>`;
      }
    })}` : ``} ${message.user_id === $user?.id || $user?.role === "admin" ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Edit") }, {}, {
      default: () => {
        return `<button class="hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1">${validate_component(Pencil, "Pencil").$$render($$result, {}, {}, {})}</button>`;
      }
    })} ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Delete") }, {}, {
      default: () => {
        return `<button class="hover:bg-gray-100 dark:hover:bg-gray-800 transition rounded-lg p-1">${validate_component(GarbageBin, "GarbageBin").$$render($$result, {}, {}, {})}</button>`;
      }
    })}` : ``}</div></div>` : ``} ${message?.reply_to_message?.user ? `<div class="relative text-xs mb-1"><div class="absolute h-3 w-7 left-[18px] top-2 rounded-tl-lg border-t-2 border-l-2 border-gray-300 dark:border-gray-500 z-0"></div> <button class="ml-12 flex items-center space-x-2 relative z-0">${message?.reply_to_message?.meta?.model_id ? `<img${add_attribute("src", `${WEBUI_API_BASE_URL}/models/model/profile/image?id=${message.reply_to_message.meta.model_id}`, 0)}${add_attribute("alt", message.reply_to_message.meta.model_name ?? message.reply_to_message.meta.model_id, 0)} class="size-4 ml-0.5 rounded-full object-cover">` : `<img${add_attribute("src", message.reply_to_message.user?.profile_image_url ?? `${WEBUI_BASE_URL}/static/favicon.png`, 0)}${add_attribute("alt", message.reply_to_message.user?.name ?? $i18n.t("Unknown User"), 0)} class="size-4 ml-0.5 rounded-full object-cover">`} <div class="shrink-0">${escape(message?.reply_to_message.meta?.model_name ?? message?.reply_to_message.user?.name ?? $i18n.t("Unknown User"))}</div> <div class="italic text-sm text-gray-500 dark:text-gray-400 line-clamp-1 w-full flex-1">${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id: `${message.id}-reply-to`,
        content: message?.reply_to_message?.content
      },
      {},
      {}
    )}</div></button></div>` : ``} <div class="${"flex w-full message-" + escape(message.id, true) + " svelte-870i4"}" id="${"message-" + escape(message.id, true)}"${add_attribute("dir", $settings.chatDirection, 0)}><div class="${escape(null_to_empty(`shrink-0 mr-3 w-9`), true) + " svelte-870i4"}">${showUserProfile ? `${message?.meta?.model_id ? `<img${add_attribute("src", `${WEBUI_API_BASE_URL}/models/model/profile/image?id=${message.meta.model_id}`, 0)}${add_attribute("alt", message.meta.model_name ?? message.meta.model_id, 0)} class="size-8 translate-y-1 ml-0.5 object-cover rounded-full">` : `${validate_component(ProfilePreview, "ProfilePreview").$$render($$result, { user: message.user }, {}, {
      default: () => {
        return `${validate_component(ProfileImage, "ProfileImage").$$render(
          $$result,
          {
            src: message.user?.profile_image_url ?? `${WEBUI_BASE_URL}/static/favicon.png`,
            className: "size-8 ml-0.5"
          },
          {},
          {}
        )}`;
      }
    })}`}` : ` ${message.created_at ? `<div class="mt-1.5 flex shrink-0 items-center text-xs self-center invisible group-hover:visible text-gray-500 font-medium first-letter:capitalize">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: dayjs(message.created_at / 1e6).format("LLLL")
      },
      {},
      {
        default: () => {
          return `${escape(dayjs(message.created_at / 1e6).format("HH:mm"))}`;
        }
      }
    )}</div>` : ``}`}</div> <div class="flex-auto w-0 pl-1">${showUserProfile ? `${validate_component(Name, "Name").$$render($$result, {}, {}, {
      default: () => {
        return `<div class="self-end text-base shrink-0 font-medium truncate">${message?.meta?.model_id ? `${escape(message?.meta?.model_name ?? message?.meta?.model_id)}` : `${escape(message?.user?.name)}`}</div> ${message.created_at ? `<div class="self-center text-xs invisible group-hover:visible text-gray-400 font-medium first-letter:capitalize ml-0.5 translate-y-[1px]">${validate_component(Tooltip, "Tooltip").$$render(
          $$result,
          {
            content: dayjs(message.created_at / 1e6).format("LLLL")
          },
          {},
          {
            default: () => {
              return `<span class="line-clamp-1">${escape($i18n.t(formatDate(message.created_at / 1e6), {
                LOCALIZED_TIME: dayjs(message.created_at / 1e6).format("LT"),
                LOCALIZED_DATE: dayjs(message.created_at / 1e6).format("L")
              }))}</span>`;
            }
          }
        )}</div>` : ``}`;
      }
    })}` : ``} ${(message?.data?.files ?? []).length > 0 ? `<div class="my-2.5 w-full flex overflow-x-auto gap-2 flex-wrap">${each(message?.data?.files, (file) => {
      return `<div>${file.type === "image" ? `${validate_component(Image, "Image").$$render(
        $$result,
        {
          src: file.url,
          alt: file.name,
          imageClassName: " max-h-96 rounded-lg"
        },
        {},
        {}
      )}` : `${validate_component(FileItem, "FileItem").$$render(
        $$result,
        {
          item: file,
          url: file.url,
          name: file.name,
          type: file.type,
          size: file?.size,
          small: true
        },
        {},
        {}
      )}`} </div>`;
    })}</div>` : ``} ${`<div class="min-w-full markdown-prose">${(message?.content ?? "").trim() === "" && message?.meta?.model_id ? `${validate_component(Skeleton, "Skeleton").$$render($$result, {}, {}, {})}` : `${validate_component(Markdown, "Markdown").$$render($$result, { id: message.id, content: message.content }, {}, {})}${message.created_at !== message.updated_at && (message?.meta?.model_id ?? null) === null ? `<span class="text-gray-500 text-[10px]">(${escape($i18n.t("edited"))})</span>` : ``}`}</div> ${(message?.reactions ?? []).length > 0 ? `<div><div class="flex items-center flex-wrap gap-y-1.5 gap-1 mt-1 mb-2">${each(message.reactions, (reaction) => {
      return `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: `:${reaction.name}:` }, {}, {
        default: () => {
          return `<button class="${"flex items-center gap-1.5 transition rounded-xl px-2 py-1 cursor-pointer " + escape(
            reaction.user_ids.includes($user?.id) ? " bg-blue-300/10 outline outline-blue-500/50 outline-1" : "bg-gray-300/10 dark:bg-gray-500/10 hover:outline hover:outline-gray-700/30 dark:hover:outline-gray-300/30 hover:outline-1",
            true
          )}">${validate_component(Emoji, "Emoji").$$render($$result, { shortCode: reaction.name }, {}, {})} ${reaction.user_ids.length > 0 ? `<div class="text-xs font-medium text-gray-500 dark:text-gray-400">${escape(reaction.user_ids?.length)} </div>` : ``}</button> `;
        }
      })}`;
    })} ${validate_component(EmojiPicker, "EmojiPicker").$$render(
      $$result,
      {
        onSubmit: (name) => {
          onReaction(name);
        }
      },
      {},
      {
        default: () => {
          return `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Add Reaction") }, {}, {
            default: () => {
              return `<div class="flex items-center gap-1.5 bg-gray-500/10 hover:outline hover:outline-gray-700/30 dark:hover:outline-gray-300/30 hover:outline-1 transition rounded-xl px-1 py-1 cursor-pointer text-gray-500 dark:text-gray-400">${validate_component(FaceSmile, "FaceSmile").$$render($$result, {}, {}, {})}</div>`;
            }
          })}`;
        }
      }
    )}</div></div>` : ``} ${!thread && message.reply_count > 0 ? `<div class="flex items-center gap-1.5 -mt-0.5 mb-1.5"><button class="flex items-center text-xs py-1 text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-300 transition"><span class="font-medium mr-1">${escape($i18n.t("{{COUNT}} Replies", { COUNT: message.reply_count }))}</span><span>${escape(" - ")}${escape($i18n.t("Last reply"))} ${escape(dayjs.unix(message.latest_reply_at / 1e9).fromNow())}</span> <span class="ml-1">${validate_component(ChevronRight, "ChevronRight").$$render($$result, { className: "size-2.5", strokeWidth: "3" }, {}, {})}</span> </button></div>` : ``}`}</div></div></div>` : ``}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  $$unsubscribe_settings();
  return $$rendered;
});
const Messages = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  dayjs.extend(relativeTime);
  dayjs.extend(isToday);
  dayjs.extend(isYesterday);
  const i18n2 = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n2, (value) => $i18n = value);
  let { id = null } = $$props;
  let { channel = null } = $$props;
  let { messages = [] } = $$props;
  let { replyToMessage = null } = $$props;
  let { top = false } = $$props;
  let { thread = false } = $$props;
  let { onLoad = () => {
  } } = $$props;
  let { onReply = () => {
  } } = $$props;
  let { onThread = () => {
  } } = $$props;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.channel === void 0 && $$bindings.channel && channel !== void 0) $$bindings.channel(channel);
  if ($$props.messages === void 0 && $$bindings.messages && messages !== void 0) $$bindings.messages(messages);
  if ($$props.replyToMessage === void 0 && $$bindings.replyToMessage && replyToMessage !== void 0) $$bindings.replyToMessage(replyToMessage);
  if ($$props.top === void 0 && $$bindings.top && top !== void 0) $$bindings.top(top);
  if ($$props.thread === void 0 && $$bindings.thread && thread !== void 0) $$bindings.thread(thread);
  if ($$props.onLoad === void 0 && $$bindings.onLoad && onLoad !== void 0) $$bindings.onLoad(onLoad);
  if ($$props.onReply === void 0 && $$bindings.onReply && onReply !== void 0) $$bindings.onReply(onReply);
  if ($$props.onThread === void 0 && $$bindings.onThread && onThread !== void 0) $$bindings.onThread(onThread);
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  return `${messages ? (() => {
    let messageList = messages.slice().reverse();
    return ` <div>${!top ? `${validate_component(Loader, "Loader").$$render($$result, {}, {}, {
      default: () => {
        return `<div class="w-full flex justify-center py-1 text-xs animate-pulse items-center gap-2">${validate_component(Spinner, "Spinner").$$render($$result, { className: " size-4" }, {}, {})} <div class="">${escape($i18n.t("Loading..."))}</div></div>`;
      }
    })}` : `${!thread ? `<div class="px-5 max-w-full mx-auto">${channel ? `<div class="flex flex-col gap-1.5 pb-5 pt-10"><div class="text-2xl font-medium capitalize">${escape(channel.name)}</div> <div class="text-gray-500">${escape($i18n.t("This channel was created on {{createdAt}}. This is the very beginning of the {{channelName}} channel.", {
      createdAt: dayjs(channel.created_at / 1e6).format("MMMM D, YYYY"),
      channelName: channel.name
    }))}</div></div>` : `<div class="flex justify-center text-xs items-center gap-2 py-5"><div class="">${escape($i18n.t("Start of the channel"))}</div></div>`} ${messageList.length > 0 ? `<hr class="border-gray-50 dark:border-gray-700/20 py-2.5 w-full">` : ``}</div>` : ``}`} ${each(messageList, (message, messageIdx) => {
      return `${validate_component(Message, "Message").$$render(
        $$result,
        {
          message,
          thread,
          replyToMessage: replyToMessage?.id === message.id,
          disabled: !channel?.write_access,
          showUserProfile: messageIdx === 0 || messageList.at(messageIdx - 1)?.user_id !== message.user_id || messageList.at(messageIdx - 1)?.meta?.model_id !== message?.meta?.model_id || message?.reply_to_message,
          onDelete: () => {
            messages = messages.filter((m) => m.id !== message.id);
            deleteMessage(localStorage.token, message.channel_id, message.id).catch((error) => {
              toast.error(`${error}`);
              return null;
            });
          },
          onEdit: (content) => {
            messages = messages.map((m) => {
              if (m.id === message.id) {
                m.content = content;
              }
              return m;
            });
            updateMessage(localStorage.token, message.channel_id, message.id, { content }).catch((error) => {
              toast.error(`${error}`);
              return null;
            });
          },
          onReply: (message2) => {
            onReply(message2);
          },
          onThread: (id2) => {
            onThread(id2);
          },
          onReaction: (name) => {
            if ((message?.reactions ?? []).find((reaction) => reaction.name === name)?.user_ids?.includes($user?.id) ?? false) {
              messages = messages.map((m) => {
                if (m.id === message.id) {
                  const reaction = m.reactions.find((reaction2) => reaction2.name === name);
                  if (reaction) {
                    reaction.user_ids = reaction.user_ids.filter((id2) => id2 !== $user?.id);
                    reaction.count = reaction.user_ids.length;
                    if (reaction.count === 0) {
                      m.reactions = m.reactions.filter((r) => r.name !== name);
                    }
                  }
                }
                return m;
              });
              removeReaction(localStorage.token, message.channel_id, message.id, name).catch((error) => {
                toast.error(`${error}`);
                return null;
              });
            } else {
              messages = messages.map((m) => {
                if (m.id === message.id) {
                  if (m.reactions) {
                    const reaction = m.reactions.find((reaction2) => reaction2.name === name);
                    if (reaction) {
                      reaction.user_ids.push($user?.id);
                      reaction.count = reaction.user_ids.length;
                    } else {
                      m.reactions.push({ name, user_ids: [$user?.id], count: 1 });
                    }
                  }
                }
                return m;
              });
              addReaction(localStorage.token, message.channel_id, message.id, name).catch((error) => {
                toast.error(`${error}`);
                return null;
              });
            }
          }
        },
        {},
        {}
      )}`;
    })} <div class="pb-6"></div></div>`;
  })() : ``}`;
});
const Navbar = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $mobile, $$unsubscribe_mobile;
  let $showSidebar, $$unsubscribe_showSidebar;
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const i18n2 = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n2, (value) => $i18n = value);
  let { channel } = $$props;
  if ($$props.channel === void 0 && $$bindings.channel && channel !== void 0) $$bindings.channel(channel);
  $$unsubscribe_mobile();
  $$unsubscribe_showSidebar();
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  return `<nav class="sticky top-0 z-30 w-full px-1.5 py-1.5 -mb-8 flex items-center drag-region"><div class="bg-linear-to-b via-50% from-white via-white to-transparent dark:from-gray-900 dark:via-gray-900 dark:to-transparent pointer-events-none absolute inset-0 -bottom-7 z-[-1]"></div> <div class="flex max-w-full w-full mx-auto px-1 pt-0.5 bg-transparent"><div class="flex items-center w-full max-w-full">${$mobile ? `<div class="${escape($showSidebar ? "md:hidden" : "", true) + " mr-1.5 mt-0.5 self-start flex flex-none items-center text-gray-600 dark:text-gray-400"}">${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      content: $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar"),
      interactive: true
    },
    {},
    {
      default: () => {
        return `<button id="sidebar-toggle-button" class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition cursor-"><div class="self-center p-1.5">${validate_component(Sidebar, "Sidebar").$$render($$result, {}, {}, {})}</div></button>`;
      }
    }
  )}</div>` : ``} <div class="${"flex-1 overflow-hidden max-w-full py-0.5 " + escape($showSidebar ? "ml-1" : "", true)}">${channel ? `<div class="line-clamp-1 capitalize font-medium font-primary text-lg">${escape(channel.name)}</div>` : ``}</div> <div class="self-start flex flex-none items-center text-gray-600 dark:text-gray-400">${$user !== void 0 ? `${validate_component(UserMenu, "UserMenu").$$render(
    $$result,
    {
      className: "max-w-[240px]",
      role: $user?.role,
      help: true
    },
    {},
    {
      default: () => {
        return `<button class="select-none flex rounded-xl p-1.5 w-full hover:bg-gray-50 dark:hover:bg-gray-850 transition" aria-label="User Menu"><div class="self-center"><img${add_attribute("src", $user?.profile_image_url, 0)} class="size-6 object-cover rounded-full" alt="User profile" draggable="false"></div></button>`;
      }
    }
  )}` : ``}</div></div></div></nav>`;
});
const Thread = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $socket, $$unsubscribe_socket;
  let $user, $$unsubscribe_user;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_socket = subscribe(socket, (value) => $socket = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const i18n2 = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n2, (value) => $i18n = value);
  let { threadId = null } = $$props;
  let { channel = null } = $$props;
  let { onClose = () => {
  } } = $$props;
  let messages = null;
  let top = false;
  let messagesContainerElement = null;
  let chatInputElement = null;
  let replyToMessage = null;
  let typingUsers = [];
  let typingUsersTimeout = {};
  const scrollToBottom = () => {
    messagesContainerElement.scrollTop = messagesContainerElement.scrollHeight;
  };
  const initHandler = async () => {
    messages = null;
    top = false;
    typingUsers = [];
    typingUsersTimeout = {};
    if (channel) {
      messages = await getChannelThreadMessages(localStorage.token, channel.id, threadId);
      if (messages.length < 50) {
        top = true;
      }
      await tick();
      scrollToBottom();
    } else {
      goto();
    }
  };
  const channelEventHandler = async (event) => {
    /* @__PURE__ */ console.debug(event);
    if (event.channel_id === channel.id) {
      const type = event?.data?.type ?? null;
      const data = event?.data?.data ?? null;
      if (type === "message") {
        if ((data?.parent_id ?? null) === threadId) {
          if (messages) {
            messages = [data, ...messages];
            if (typingUsers.find((user2) => user2.id === event.user.id)) {
              typingUsers = typingUsers.filter((user2) => user2.id !== event.user.id);
            }
          }
        }
      } else if (type === "message:update") {
        if (messages) {
          const idx = messages.findIndex((message) => message.id === data.id);
          if (idx !== -1) {
            messages[idx] = data;
          }
        }
      } else if (type === "message:delete") {
        if (messages) {
          messages = messages.filter((message) => message.id !== data.id);
        }
      } else if (type.includes("message:reaction")) {
        if (messages) {
          const idx = messages.findIndex((message) => message.id === data.id);
          if (idx !== -1) {
            messages[idx] = data;
          }
        }
      } else if (type === "typing" && event.message_id === threadId) {
        if (event.user.id === $user?.id) {
          return;
        }
        typingUsers = data.typing ? [
          ...typingUsers,
          ...typingUsers.find((user2) => user2.id === event.user.id) ? [] : [{ id: event.user.id, name: event.user.name }]
        ] : typingUsers.filter((user2) => user2.id !== event.user.id);
        if (typingUsersTimeout[event.user.id]) {
          clearTimeout(typingUsersTimeout[event.user.id]);
        }
        typingUsersTimeout[event.user.id] = setTimeout(
          () => {
            typingUsers = typingUsers.filter((user2) => user2.id !== event.user.id);
          },
          5e3
        );
      }
    }
  };
  const submitHandler = async ({ content, data }) => {
    if (!content && (data?.files ?? []).length === 0) {
      return;
    }
    await sendMessage(localStorage.token, channel.id, {
      parent_id: threadId,
      reply_to_id: replyToMessage?.id ?? null,
      content,
      data
    }).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    replyToMessage = null;
  };
  const onChange = async () => {
    $socket?.emit("events:channel", {
      channel_id: channel.id,
      message_id: threadId,
      data: { type: "typing", data: { typing: true } }
    });
  };
  onDestroy(() => {
    $socket?.off("events:channel", channelEventHandler);
  });
  if ($$props.threadId === void 0 && $$bindings.threadId && threadId !== void 0) $$bindings.threadId(threadId);
  if ($$props.channel === void 0 && $$bindings.channel && channel !== void 0) $$bindings.channel(channel);
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (threadId) {
        initHandler();
      }
    }
    $$rendered = `${channel ? `<div class="flex flex-col w-full h-full bg-gray-50 dark:bg-gray-850"><div class="sticky top-0 flex items-center justify-between px-3.5 py-3"><div class="font-medium text-lg">${escape($i18n.t("Thread"))}</div> <div><button class="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300 p-2">${validate_component(XMark, "XMark").$$render($$result, {}, {}, {})}</button></div></div> <div class="max-h-full w-full overflow-y-auto"${add_attribute("this", messagesContainerElement, 0)}>${messages !== null ? `${validate_component(Messages, "Messages").$$render(
      $$result,
      {
        id: threadId,
        channel,
        top,
        messages,
        replyToMessage,
        thread: true,
        onReply: async (message) => {
          replyToMessage = message;
          await tick();
          chatInputElement?.focus();
        },
        onLoad: async () => {
          const newMessages = await getChannelThreadMessages(localStorage.token, channel.id, threadId, messages.length);
          messages = [...messages, ...newMessages];
          if (newMessages.length < 50) {
            top = true;
            return;
          }
        }
      },
      {},
      {}
    )}` : `<div class="w-full flex justify-center pt-5 pb-10">${validate_component(Spinner, "Spinner").$$render($$result, {}, {}, {})}</div>`} <div class="pb-[1rem] px-2.5 w-full">${validate_component(MessageInput, "MessageInput").$$render(
      $$result,
      {
        id: threadId,
        disabled: !channel?.write_access,
        placeholder: !channel?.write_access ? $i18n.t("You do not have permission to send messages in this thread.") : $i18n.t("Reply to thread..."),
        typingUsersClassName: "from-gray-50 dark:from-gray-850",
        typingUsers,
        userSuggestions: true,
        channelSuggestions: true,
        onChange,
        onSubmit: submitHandler,
        replyToMessage,
        chatInputElement
      },
      {
        replyToMessage: ($$value) => {
          replyToMessage = $$value;
          $$settled = false;
        },
        chatInputElement: ($$value) => {
          chatInputElement = $$value;
          $$settled = false;
        }
      },
      {}
    )}</div></div></div>` : ``}`;
  } while (!$$settled);
  $$unsubscribe_socket();
  $$unsubscribe_user();
  $$unsubscribe_i18n();
  return $$rendered;
});
const Channel = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $socket, $$unsubscribe_socket;
  let $$unsubscribe_chatId;
  let $user, $$unsubscribe_user;
  let $showSidebar, $$unsubscribe_showSidebar;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_socket = subscribe(socket, (value) => $socket = value);
  $$unsubscribe_chatId = subscribe(chatId, (value) => value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { id = "" } = $$props;
  let scrollEnd = true;
  let messagesContainerElement = null;
  let chatInputElement = null;
  let top = false;
  let channel = null;
  let messages = null;
  let replyToMessage = null;
  let threadId = null;
  let typingUsers = [];
  let typingUsersTimeout = {};
  const scrollToBottom = () => {
  };
  const initHandler = async () => {
    top = false;
    messages = null;
    channel = null;
    threadId = null;
    typingUsers = [];
    typingUsersTimeout = {};
    channel = await getChannelById(localStorage.token, id).catch((error) => {
      return null;
    });
    if (channel) {
      messages = await getChannelMessages(localStorage.token, id, 0);
      if (messages) {
        if (messages.length < 50) {
          top = true;
        }
      }
    } else {
      goto();
    }
  };
  const channelEventHandler = async (event) => {
    if (event.channel_id === id) {
      const type = event?.data?.type ?? null;
      const data = event?.data?.data ?? null;
      if (type === "message") {
        if ((data?.parent_id ?? null) === null) {
          messages = [data, ...messages];
          if (typingUsers.find((user2) => user2.id === event.user.id)) {
            typingUsers = typingUsers.filter((user2) => user2.id !== event.user.id);
          }
          await tick();
        }
      } else if (type === "message:update") {
        const idx = messages.findIndex((message) => message.id === data.id);
        if (idx !== -1) {
          messages[idx] = data;
        }
      } else if (type === "message:delete") {
        messages = messages.filter((message) => message.id !== data.id);
      } else if (type === "message:reply") {
        const idx = messages.findIndex((message) => message.id === data.id);
        if (idx !== -1) {
          messages[idx] = data;
        }
      } else if (type.includes("message:reaction")) {
        const idx = messages.findIndex((message) => message.id === data.id);
        if (idx !== -1) {
          messages[idx] = data;
        }
      } else if (type === "typing" && event.message_id === null) {
        if (event.user.id === $user?.id) {
          return;
        }
        typingUsers = data.typing ? [
          ...typingUsers,
          ...typingUsers.find((user2) => user2.id === event.user.id) ? [] : [{ id: event.user.id, name: event.user.name }]
        ] : typingUsers.filter((user2) => user2.id !== event.user.id);
        if (typingUsersTimeout[event.user.id]) {
          clearTimeout(typingUsersTimeout[event.user.id]);
        }
        typingUsersTimeout[event.user.id] = setTimeout(
          () => {
            typingUsers = typingUsers.filter((user2) => user2.id !== event.user.id);
          },
          5e3
        );
      }
    }
  };
  const submitHandler = async ({ content, data }) => {
    if (!content && (data?.files ?? []).length === 0) {
      return;
    }
    const res = await sendMessage(localStorage.token, id, {
      content,
      data,
      reply_to_id: replyToMessage?.id ?? null
    }).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    if (res) {
      messagesContainerElement.scrollTop = messagesContainerElement.scrollHeight;
    }
    replyToMessage = null;
  };
  const onChange = async () => {
    $socket?.emit("events:channel", {
      channel_id: id,
      message_id: null,
      data: { type: "typing", data: { typing: true } }
    });
  };
  onDestroy(() => {
    $socket?.off("events:channel", channelEventHandler);
  });
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (id) {
        initHandler();
      }
    }
    $$rendered = `${$$result.head += `<!-- HEAD_svelte-dfmiil_START -->${$$result.title = `<title>#${escape(channel?.name ?? "Channel")} • Open WebUI</title>`, ""}<!-- HEAD_svelte-dfmiil_END -->`, ""} <div class="${"h-screen max-h-[100dvh] transition-width duration-200 ease-in-out " + escape($showSidebar ? "md:max-w-[calc(100%-260px)]" : "", true) + " w-full max-w-full flex flex-col"}" id="channel-container">${validate_component(Pane_group, "PaneGroup").$$render(
      $$result,
      {
        direction: "horizontal",
        class: "w-full h-full"
      },
      {},
      {
        default: () => {
          return `${validate_component(Pane, "Pane").$$render(
            $$result,
            {
              defaultSize: 50,
              minSize: 50,
              class: "h-full flex flex-col w-full relative"
            },
            {},
            {
              default: () => {
                return `${validate_component(Navbar, "Navbar").$$render($$result, { channel }, {}, {})} <div class="flex-1 overflow-y-auto">${channel ? `<div class="pb-2.5 max-w-full z-10 scrollbar-hidden w-full h-full pt-6 flex-1 flex flex-col-reverse overflow-auto" id="messages-container"${add_attribute("this", messagesContainerElement, 0)}>${validate_component(Messages, "Messages").$$render(
                  $$result,
                  {
                    channel,
                    top,
                    messages,
                    replyToMessage,
                    onReply: async (message) => {
                      replyToMessage = message;
                      await tick();
                      chatInputElement?.focus();
                    },
                    onThread: (id2) => {
                      threadId = id2;
                    },
                    onLoad: async () => {
                      const newMessages = await getChannelMessages(localStorage.token, id, messages.length);
                      messages = [...messages, ...newMessages];
                      if (newMessages.length < 50) {
                        top = true;
                        return;
                      }
                    }
                  },
                  {},
                  {}
                )}</div>` : ``}</div> <div class="pb-[1rem] px-2.5">${validate_component(MessageInput, "MessageInput").$$render(
                  $$result,
                  {
                    id: "root",
                    typingUsers,
                    userSuggestions: true,
                    channelSuggestions: true,
                    disabled: !channel?.write_access,
                    placeholder: !channel?.write_access ? $i18n.t("You do not have permission to send messages in this channel.") : $i18n.t("Type here..."),
                    onChange,
                    onSubmit: submitHandler,
                    scrollToBottom,
                    scrollEnd,
                    chatInputElement,
                    replyToMessage
                  },
                  {
                    chatInputElement: ($$value) => {
                      chatInputElement = $$value;
                      $$settled = false;
                    },
                    replyToMessage: ($$value) => {
                      replyToMessage = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}</div>`;
              }
            }
          )} ${`${threadId !== null ? `${validate_component(Drawer, "Drawer").$$render(
            $$result,
            {
              show: threadId !== null,
              onClose: () => {
                threadId = null;
              }
            },
            {},
            {
              default: () => {
                return `<div class="${"" + escape(threadId !== null ? " h-screen  w-full" : "px-6 py-4", true) + " h-full"}">${validate_component(Thread, "Thread").$$render(
                  $$result,
                  {
                    threadId,
                    channel,
                    onClose: () => {
                      threadId = null;
                    }
                  },
                  {},
                  {}
                )}</div>`;
              }
            }
          )}` : ``}`}`;
        }
      }
    )}</div>`;
  } while (!$$settled);
  $$unsubscribe_socket();
  $$unsubscribe_chatId();
  $$unsubscribe_user();
  $$unsubscribe_showSidebar();
  $$unsubscribe_i18n();
  return $$rendered;
});
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $page, $$unsubscribe_page;
  $$unsubscribe_page = subscribe(page, (value) => $page = value);
  $$unsubscribe_page();
  return `${validate_component(Channel, "Channel").$$render($$result, { id: $page.params.id }, {}, {})}`;
});
export {
  Page as default
};
//# sourceMappingURL=_page.svelte.js.map
