import { o as onMount$1, s as svelte } from "./ssr2.js";
import "@sveltejs/kit/internal";
import { w as writable } from "./exports.js";
function get(key, parse = JSON.parse) {
  try {
    return parse(sessionStorage[key]);
  } catch {
  }
}
const SNAPSHOT_KEY = "sveltekit:snapshot";
const SCROLL_KEY = "sveltekit:scroll";
function notifiable_store(value) {
  const store = writable(value);
  let ready = true;
  function notify() {
    ready = true;
    store.update((val) => val);
  }
  function set(new_value) {
    ready = false;
    store.set(new_value);
  }
  function subscribe(run) {
    let old_value;
    return store.subscribe((new_value) => {
      if (old_value === void 0 || ready && new_value !== old_value) {
        run(old_value = new_value);
      }
    });
  }
  return { notify, set, subscribe };
}
function create_updated_store() {
  const { set, subscribe } = writable(false);
  {
    return {
      subscribe,
      // eslint-disable-next-line @typescript-eslint/require-await
      check: async () => false
    };
  }
}
let updated;
const is_legacy = onMount$1.toString().includes("$$") || /function \w+\(\) \{\}/.test(onMount$1.toString());
if (is_legacy) {
  ({
    data: {},
    form: null,
    error: null,
    params: {},
    route: { id: null },
    state: {},
    status: -1,
    url: new URL("https://example.com")
  });
  updated = { current: false };
} else {
  updated = new class Updated {
    current = $state.raw(false);
  }();
}
const { onMount, tick } = svelte;
get(SCROLL_KEY) ?? {};
get(SNAPSHOT_KEY) ?? {};
const stores = {
  url: /* @__PURE__ */ notifiable_store({}),
  page: /* @__PURE__ */ notifiable_store({}),
  navigating: /* @__PURE__ */ writable(
    /** @type {import('@sveltejs/kit').Navigation | null} */
    null
  ),
  updated: /* @__PURE__ */ create_updated_store()
};
const before_navigate_callbacks = /* @__PURE__ */ new Set();
function add_navigation_callback(callbacks, callback) {
  onMount(() => {
    callbacks.add(callback);
    return () => {
      callbacks.delete(callback);
    };
  });
}
function beforeNavigate(callback) {
  add_navigation_callback(before_navigate_callbacks, callback);
}
function goto(url, opts = {}) {
  {
    throw new Error("Cannot call goto(...) on the server");
  }
}
export {
  beforeNavigate as b,
  goto as g,
  stores as s,
  updated as u
};
//# sourceMappingURL=client.js.map
