import { c as create_ssr_component, o as onDestroy, a as add_attribute } from "./ssr.js";
import "dompurify";
const void_element_names = /^(?:area|base|br|col|command|embed|hr|img|input|keygen|link|meta|param|source|track|wbr)$/;
function is_void(name) {
  return void_element_names.test(name) || name.toLowerCase() === "!doctype";
}
const Tooltip = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { elementId = "" } = $$props;
  let { as = "div" } = $$props;
  let { className = "flex" } = $$props;
  let { placement = "top" } = $$props;
  let { content = `I'm a tooltip!` } = $$props;
  let { touch = true } = $$props;
  let { theme = "" } = $$props;
  let { offset = [0, 4] } = $$props;
  let { allowHTML = true } = $$props;
  let { tippyOptions = {} } = $$props;
  let { interactive = false } = $$props;
  let { onClick = () => {
  } } = $$props;
  let tooltipElement;
  onDestroy(() => {
  });
  if ($$props.elementId === void 0 && $$bindings.elementId && elementId !== void 0) $$bindings.elementId(elementId);
  if ($$props.as === void 0 && $$bindings.as && as !== void 0) $$bindings.as(as);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.placement === void 0 && $$bindings.placement && placement !== void 0) $$bindings.placement(placement);
  if ($$props.content === void 0 && $$bindings.content && content !== void 0) $$bindings.content(content);
  if ($$props.touch === void 0 && $$bindings.touch && touch !== void 0) $$bindings.touch(touch);
  if ($$props.theme === void 0 && $$bindings.theme && theme !== void 0) $$bindings.theme(theme);
  if ($$props.offset === void 0 && $$bindings.offset && offset !== void 0) $$bindings.offset(offset);
  if ($$props.allowHTML === void 0 && $$bindings.allowHTML && allowHTML !== void 0) $$bindings.allowHTML(allowHTML);
  if ($$props.tippyOptions === void 0 && $$bindings.tippyOptions && tippyOptions !== void 0) $$bindings.tippyOptions(tippyOptions);
  if ($$props.interactive === void 0 && $$bindings.interactive && interactive !== void 0) $$bindings.interactive(interactive);
  if ($$props.onClick === void 0 && $$bindings.onClick && onClick !== void 0) $$bindings.onClick(onClick);
  return ` ${((tag) => {
    return tag ? `<${as}${add_attribute("class", className, 0)}${add_attribute("this", tooltipElement, 0)}>${is_void(tag) ? "" : `${slots.default ? slots.default({}) : ``}`}${is_void(tag) ? "" : `</${tag}>`}` : "";
  })(as)} ${slots.tooltip ? slots.tooltip({}) : ``}`;
});
export {
  Tooltip as T,
  is_void as i
};
//# sourceMappingURL=Tooltip.js.map
