import { c as create_ssr_component, a as add_attribute, g as escape } from "./ssr.js";
const Textarea = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { value = "" } = $$props;
  let { placeholder = "" } = $$props;
  let { rows = 1 } = $$props;
  let { minSize = null } = $$props;
  let { maxSize = null } = $$props;
  let { required = false } = $$props;
  let { readonly = false } = $$props;
  let { className = "w-full rounded-lg px-3.5 py-2 text-sm bg-gray-50 dark:text-gray-300 dark:bg-gray-850 outline-hidden  h-full" } = $$props;
  let { onBlur = () => {
  } } = $$props;
  let textareaElement;
  if ($$props.value === void 0 && $$bindings.value && value !== void 0) $$bindings.value(value);
  if ($$props.placeholder === void 0 && $$bindings.placeholder && placeholder !== void 0) $$bindings.placeholder(placeholder);
  if ($$props.rows === void 0 && $$bindings.rows && rows !== void 0) $$bindings.rows(rows);
  if ($$props.minSize === void 0 && $$bindings.minSize && minSize !== void 0) $$bindings.minSize(minSize);
  if ($$props.maxSize === void 0 && $$bindings.maxSize && maxSize !== void 0) $$bindings.maxSize(maxSize);
  if ($$props.required === void 0 && $$bindings.required && required !== void 0) $$bindings.required(required);
  if ($$props.readonly === void 0 && $$bindings.readonly && readonly !== void 0) $$bindings.readonly(readonly);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.onBlur === void 0 && $$bindings.onBlur && onBlur !== void 0) $$bindings.onBlur(onBlur);
  return `<textarea${add_attribute("placeholder", placeholder, 0)}${add_attribute("class", className, 0)} style="field-sizing: content;"${add_attribute("rows", rows, 0)} ${required ? "required" : ""} ${readonly ? "readonly" : ""}${add_attribute("this", textareaElement, 0)}>${escape(value || "")}</textarea>`;
});
export {
  Textarea as T
};
//# sourceMappingURL=Textarea.js.map
