import { c as create_ssr_component, l as getContext, b as subscribe, a as add_attribute, g as escape, h as compute_rest_props, v as validate_component, t as get_store_value, d as add_styles, f as merge_ssr_styles, s as setContext, p as createEventDispatcher, o as onDestroy, m as missing_component, e as each, i as spread, j as escape_attribute_value, k as escape_object, u as hasContext, E as compute_slots, n as noop, q as null_to_empty } from "./ssr.js";
import { w as writable, r as readable, i as derived } from "./exports.js";
import { h as WEBUI_BASE_URL, g as theme, q as models, u as user } from "./index.js";
import { P as ProfileImage } from "./ProfileImage.js";
import { T as Tooltip } from "./Tooltip.js";
import cc from "classcat";
import { Position, ConnectionMode, areConnectionMapsEqual, handleConnectionChange, errorMessages, getBezierPath, getSmoothStepPath, getStraightPath, infiniteExtent, adoptUserNodes, updateConnectionLookup, getInternalNodesBounds, getViewportForBounds, SelectionMode, initialConnection, ConnectionLineType, devWarn, isEdgeVisible, getEdgePosition, getElevatedEdgeZIndex, getNodesInside, getElementsToRemove, pointToRendererPoint, createMarkerIds, addEdge, updateNodeInternals, getFitViewNodes, fitView, panBy, nodeHasDimensions, getMarkerId, MarkerType, isNumeric, isMacOs, getConnectionStatus, PanOnScrollMode, isNodeBase, isRectObject, nodeToRect, getOverlappingArea, rendererPointToPoint, getNodesBounds, evaluateAbsolutePosition } from "@xyflow/system";
import { X as XMark } from "./XMark.js";
const Handle = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let isTarget;
  let isConnectable;
  let handleId;
  let connectionInProcess;
  let connectingFrom;
  let connectingTo;
  let isPossibleEndHandle;
  let valid;
  let $connection, $$unsubscribe_connection;
  let $connectionMode, $$unsubscribe_connectionMode;
  let $connectionLookup, $$unsubscribe_connectionLookup;
  let $$unsubscribe_edges;
  let $$unsubscribe_viewport;
  let $$unsubscribe_onConnectEndAction;
  let $$unsubscribe_onConnectStartAction;
  let $$unsubscribe_onConnectAction;
  let $$unsubscribe_onedgecreate;
  let $$unsubscribe_isValidConnectionStore;
  let $flowId, $$unsubscribe_flowId;
  let $$unsubscribe_autoPanOnConnect;
  let $$unsubscribe_lib;
  let $$unsubscribe_nodeLookup;
  let $$unsubscribe_domNode;
  let $$unsubscribe_connectionRadius;
  let $connectable, $$unsubscribe_connectable;
  let { id = void 0 } = $$props;
  let { type = "source" } = $$props;
  let { position = Position.Top } = $$props;
  let { style = void 0 } = $$props;
  let { isValidConnection = void 0 } = $$props;
  let { onconnect = void 0 } = $$props;
  let { ondisconnect = void 0 } = $$props;
  let { isConnectable: isConnectableProp = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  const nodeId = getContext("svelteflow__node_id");
  const connectable = getContext("svelteflow__node_connectable");
  $$unsubscribe_connectable = subscribe(connectable, (value) => $connectable = value);
  const store = useStore();
  const { connectionMode, domNode, nodeLookup, connectionRadius, viewport, isValidConnection: isValidConnectionStore, lib, addEdge: addEdge2, onedgecreate, panBy: panBy2, cancelConnection, updateConnection, autoPanOnConnect, edges, connectionLookup, onconnect: onConnectAction, onconnectstart: onConnectStartAction, onconnectend: onConnectEndAction, flowId, connection } = store;
  $$unsubscribe_connectionMode = subscribe(connectionMode, (value) => $connectionMode = value);
  $$unsubscribe_domNode = subscribe(domNode, (value) => value);
  $$unsubscribe_nodeLookup = subscribe(nodeLookup, (value) => value);
  $$unsubscribe_connectionRadius = subscribe(connectionRadius, (value) => value);
  $$unsubscribe_viewport = subscribe(viewport, (value) => value);
  $$unsubscribe_isValidConnectionStore = subscribe(isValidConnectionStore, (value) => value);
  $$unsubscribe_lib = subscribe(lib, (value) => value);
  $$unsubscribe_onedgecreate = subscribe(onedgecreate, (value) => value);
  $$unsubscribe_autoPanOnConnect = subscribe(autoPanOnConnect, (value) => value);
  $$unsubscribe_edges = subscribe(edges, (value) => value);
  $$unsubscribe_connectionLookup = subscribe(connectionLookup, (value) => $connectionLookup = value);
  $$unsubscribe_onConnectAction = subscribe(onConnectAction, (value) => value);
  $$unsubscribe_onConnectStartAction = subscribe(onConnectStartAction, (value) => value);
  $$unsubscribe_onConnectEndAction = subscribe(onConnectEndAction, (value) => value);
  $$unsubscribe_flowId = subscribe(flowId, (value) => $flowId = value);
  $$unsubscribe_connection = subscribe(connection, (value) => $connection = value);
  let prevConnections = null;
  let connections;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.position === void 0 && $$bindings.position && position !== void 0) $$bindings.position(position);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.isValidConnection === void 0 && $$bindings.isValidConnection && isValidConnection !== void 0) $$bindings.isValidConnection(isValidConnection);
  if ($$props.onconnect === void 0 && $$bindings.onconnect && onconnect !== void 0) $$bindings.onconnect(onconnect);
  if ($$props.ondisconnect === void 0 && $$bindings.ondisconnect && ondisconnect !== void 0) $$bindings.ondisconnect(ondisconnect);
  if ($$props.isConnectable === void 0 && $$bindings.isConnectable && isConnectableProp !== void 0) $$bindings.isConnectable(isConnectableProp);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  isTarget = type === "target";
  isConnectable = isConnectableProp !== void 0 ? isConnectableProp : $connectable;
  handleId = id || null;
  {
    if (onconnect || ondisconnect) {
      connections = $connectionLookup.get(`${nodeId}-${type}-${id || null}`);
    }
  }
  {
    {
      if (prevConnections && !areConnectionMapsEqual(connections, prevConnections)) {
        const _connections = connections ?? /* @__PURE__ */ new Map();
        handleConnectionChange(prevConnections, _connections, ondisconnect);
        handleConnectionChange(_connections, prevConnections, onconnect);
      }
      prevConnections = connections ?? /* @__PURE__ */ new Map();
    }
  }
  connectionInProcess = !!$connection.fromHandle;
  connectingFrom = $connection.fromHandle?.nodeId === nodeId && $connection.fromHandle?.type === type && $connection.fromHandle?.id === handleId;
  connectingTo = $connection.toHandle?.nodeId === nodeId && $connection.toHandle?.type === type && $connection.toHandle?.id === handleId;
  isPossibleEndHandle = $connectionMode === ConnectionMode.Strict ? $connection.fromHandle?.type !== type : nodeId !== $connection.fromHandle?.nodeId || handleId !== $connection.fromHandle?.id;
  valid = connectingTo && $connection.isValid;
  $$unsubscribe_connection();
  $$unsubscribe_connectionMode();
  $$unsubscribe_connectionLookup();
  $$unsubscribe_edges();
  $$unsubscribe_viewport();
  $$unsubscribe_onConnectEndAction();
  $$unsubscribe_onConnectStartAction();
  $$unsubscribe_onConnectAction();
  $$unsubscribe_onedgecreate();
  $$unsubscribe_isValidConnectionStore();
  $$unsubscribe_flowId();
  $$unsubscribe_autoPanOnConnect();
  $$unsubscribe_lib();
  $$unsubscribe_nodeLookup();
  $$unsubscribe_domNode();
  $$unsubscribe_connectionRadius();
  $$unsubscribe_connectable();
  return ` <div${add_attribute("data-handleid", handleId, 0)}${add_attribute("data-nodeid", nodeId, 0)}${add_attribute("data-handlepos", position, 0)} data-id="${escape($flowId, true) + "-" + escape(nodeId, true) + "-" + escape(id || null, true) + "-" + escape(type, true)}" class="${[
    escape(
      cc([
        "svelte-flow__handle",
        `svelte-flow__handle-${position}`,
        "nodrag",
        "nopan",
        position,
        className
      ]),
      true
    ),
    (valid ? "valid" : "") + " " + (connectingTo ? "connectingto" : "") + " " + (connectingFrom ? "connectingfrom" : "") + " " + (!isTarget ? "source" : "") + " " + (isTarget ? "target" : "") + " " + (isConnectable ? "connectablestart" : "") + " " + (isConnectable ? "connectableend" : "") + " " + (isConnectable ? "connectable" : "") + " " + (isConnectable && (!connectionInProcess || isPossibleEndHandle) ? "connectionindicator" : "")
  ].join(" ").trim()}"${add_attribute("style", style, 0)} role="button" tabindex="-1">${slots.default ? slots.default({}) : ``}</div>`;
});
const DefaultNode = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  compute_rest_props($$props, ["data", "targetPosition", "sourcePosition"]);
  let { data = { label: "Node" } } = $$props;
  let { targetPosition = void 0 } = $$props;
  let { sourcePosition = void 0 } = $$props;
  if ($$props.data === void 0 && $$bindings.data && data !== void 0) $$bindings.data(data);
  if ($$props.targetPosition === void 0 && $$bindings.targetPosition && targetPosition !== void 0) $$bindings.targetPosition(targetPosition);
  if ($$props.sourcePosition === void 0 && $$bindings.sourcePosition && sourcePosition !== void 0) $$bindings.sourcePosition(sourcePosition);
  return `${validate_component(Handle, "Handle").$$render(
    $$result,
    {
      type: "target",
      position: targetPosition ?? Position.Top
    },
    {},
    {}
  )} ${escape(data?.label)} ${validate_component(Handle, "Handle").$$render(
    $$result,
    {
      type: "source",
      position: sourcePosition ?? Position.Bottom
    },
    {},
    {}
  )}`;
});
const InputNode = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  compute_rest_props($$props, ["data", "sourcePosition"]);
  let { data = { label: "Node" } } = $$props;
  let { sourcePosition = void 0 } = $$props;
  if ($$props.data === void 0 && $$bindings.data && data !== void 0) $$bindings.data(data);
  if ($$props.sourcePosition === void 0 && $$bindings.sourcePosition && sourcePosition !== void 0) $$bindings.sourcePosition(sourcePosition);
  return `${escape(data?.label)} ${validate_component(Handle, "Handle").$$render(
    $$result,
    {
      type: "source",
      position: sourcePosition ?? Position.Bottom
    },
    {},
    {}
  )}`;
});
const OutputNode = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  compute_rest_props($$props, ["data", "targetPosition"]);
  let { data = { label: "Node" } } = $$props;
  let { targetPosition = void 0 } = $$props;
  if ($$props.data === void 0 && $$bindings.data && data !== void 0) $$bindings.data(data);
  if ($$props.targetPosition === void 0 && $$bindings.targetPosition && targetPosition !== void 0) $$bindings.targetPosition(targetPosition);
  return `${escape(data?.label)} ${validate_component(Handle, "Handle").$$render(
    $$result,
    {
      type: "target",
      position: targetPosition ?? Position.Top
    },
    {},
    {}
  )}`;
});
const GroupNode = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  compute_rest_props($$props, []);
  return ``;
});
const EdgeLabelRenderer = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_domNode;
  const { domNode } = useStore();
  $$unsubscribe_domNode = subscribe(domNode, (value) => value);
  $$unsubscribe_domNode();
  return `<div>${slots.default ? slots.default({}) : ``}</div>`;
});
function useHandleEdgeSelect() {
  const { edgeLookup, selectionRect, selectionRectMode, multiselectionKeyPressed, addSelectedEdges, unselectNodesAndEdges, elementsSelectable } = useStore();
  return (id) => {
    const edge = get_store_value(edgeLookup).get(id);
    if (!edge) {
      console.warn("012", errorMessages["error012"](id));
      return;
    }
    const selectable = edge.selectable || get_store_value(elementsSelectable) && typeof edge.selectable === "undefined";
    if (selectable) {
      selectionRect.set(null);
      selectionRectMode.set(null);
      if (!edge.selected) {
        addSelectedEdges([id]);
      } else if (edge.selected && get_store_value(multiselectionKeyPressed)) {
        unselectNodesAndEdges({ nodes: [], edges: [edge] });
      }
    }
  };
}
const EdgeLabel = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { style = void 0 } = $$props;
  let { x = void 0 } = $$props;
  let { y = void 0 } = $$props;
  useHandleEdgeSelect();
  getContext("svelteflow__edge_id");
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.x === void 0 && $$bindings.x && x !== void 0) $$bindings.x(x);
  if ($$props.y === void 0 && $$bindings.y && y !== void 0) $$bindings.y(y);
  return `${validate_component(EdgeLabelRenderer, "EdgeLabelRenderer").$$render($$result, {}, {}, {
    default: () => {
      return `<div class="svelte-flow__edge-label"${add_styles(merge_ssr_styles(escape("pointer-events: all;" + style, true), {
        "transform": `translate(-50%, -50%) translate(${x}px,${y}px)`
      }))} role="button" tabindex="-1">${slots.default ? slots.default({}) : ``}</div>`;
    }
  })}`;
});
const BaseEdge = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { id = void 0 } = $$props;
  let { path } = $$props;
  let { label = void 0 } = $$props;
  let { labelX = void 0 } = $$props;
  let { labelY = void 0 } = $$props;
  let { labelStyle = void 0 } = $$props;
  let { markerStart = void 0 } = $$props;
  let { markerEnd = void 0 } = $$props;
  let { style = void 0 } = $$props;
  let { interactionWidth = 20 } = $$props;
  let { class: className = void 0 } = $$props;
  let interactionWidthValue = interactionWidth === void 0 ? 20 : interactionWidth;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.path === void 0 && $$bindings.path && path !== void 0) $$bindings.path(path);
  if ($$props.label === void 0 && $$bindings.label && label !== void 0) $$bindings.label(label);
  if ($$props.labelX === void 0 && $$bindings.labelX && labelX !== void 0) $$bindings.labelX(labelX);
  if ($$props.labelY === void 0 && $$bindings.labelY && labelY !== void 0) $$bindings.labelY(labelY);
  if ($$props.labelStyle === void 0 && $$bindings.labelStyle && labelStyle !== void 0) $$bindings.labelStyle(labelStyle);
  if ($$props.markerStart === void 0 && $$bindings.markerStart && markerStart !== void 0) $$bindings.markerStart(markerStart);
  if ($$props.markerEnd === void 0 && $$bindings.markerEnd && markerEnd !== void 0) $$bindings.markerEnd(markerEnd);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.interactionWidth === void 0 && $$bindings.interactionWidth && interactionWidth !== void 0) $$bindings.interactionWidth(interactionWidth);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  return `<path${add_attribute("id", id, 0)}${add_attribute("d", path, 0)}${add_attribute("class", cc(["svelte-flow__edge-path", className]), 0)}${add_attribute("marker-start", markerStart, 0)}${add_attribute("marker-end", markerEnd, 0)} fill="none"${add_attribute("style", style, 0)}></path> ${interactionWidthValue ? `<path${add_attribute("d", path, 0)}${add_attribute("stroke-opacity", 0, 0)}${add_attribute("stroke-width", interactionWidthValue, 0)} fill="none" class="svelte-flow__edge-interaction"></path>` : ``} ${label ? `${validate_component(EdgeLabel, "EdgeLabel").$$render($$result, { x: labelX, y: labelY, style: labelStyle }, {}, {
    default: () => {
      return `${escape(label)}`;
    }
  })}` : ``}`;
});
const BezierEdgeInternal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let path;
  let labelX;
  let labelY;
  compute_rest_props($$props, [
    "label",
    "labelStyle",
    "style",
    "markerStart",
    "markerEnd",
    "interactionWidth",
    "sourceX",
    "sourceY",
    "sourcePosition",
    "targetX",
    "targetY",
    "targetPosition"
  ]);
  let { label = void 0 } = $$props;
  let { labelStyle = void 0 } = $$props;
  let { style = void 0 } = $$props;
  let { markerStart = void 0 } = $$props;
  let { markerEnd = void 0 } = $$props;
  let { interactionWidth = void 0 } = $$props;
  let { sourceX } = $$props;
  let { sourceY } = $$props;
  let { sourcePosition } = $$props;
  let { targetX } = $$props;
  let { targetY } = $$props;
  let { targetPosition } = $$props;
  if ($$props.label === void 0 && $$bindings.label && label !== void 0) $$bindings.label(label);
  if ($$props.labelStyle === void 0 && $$bindings.labelStyle && labelStyle !== void 0) $$bindings.labelStyle(labelStyle);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.markerStart === void 0 && $$bindings.markerStart && markerStart !== void 0) $$bindings.markerStart(markerStart);
  if ($$props.markerEnd === void 0 && $$bindings.markerEnd && markerEnd !== void 0) $$bindings.markerEnd(markerEnd);
  if ($$props.interactionWidth === void 0 && $$bindings.interactionWidth && interactionWidth !== void 0) $$bindings.interactionWidth(interactionWidth);
  if ($$props.sourceX === void 0 && $$bindings.sourceX && sourceX !== void 0) $$bindings.sourceX(sourceX);
  if ($$props.sourceY === void 0 && $$bindings.sourceY && sourceY !== void 0) $$bindings.sourceY(sourceY);
  if ($$props.sourcePosition === void 0 && $$bindings.sourcePosition && sourcePosition !== void 0) $$bindings.sourcePosition(sourcePosition);
  if ($$props.targetX === void 0 && $$bindings.targetX && targetX !== void 0) $$bindings.targetX(targetX);
  if ($$props.targetY === void 0 && $$bindings.targetY && targetY !== void 0) $$bindings.targetY(targetY);
  if ($$props.targetPosition === void 0 && $$bindings.targetPosition && targetPosition !== void 0) $$bindings.targetPosition(targetPosition);
  [path, labelX, labelY] = getBezierPath({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition
  });
  return `${validate_component(BaseEdge, "BaseEdge").$$render(
    $$result,
    {
      path,
      labelX,
      labelY,
      label,
      labelStyle,
      markerStart,
      markerEnd,
      interactionWidth,
      style
    },
    {},
    {}
  )}`;
});
const SmoothStepEdgeInternal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let path;
  let labelX;
  let labelY;
  compute_rest_props($$props, [
    "label",
    "labelStyle",
    "style",
    "markerStart",
    "markerEnd",
    "interactionWidth",
    "sourceX",
    "sourceY",
    "sourcePosition",
    "targetX",
    "targetY",
    "targetPosition"
  ]);
  let { label = void 0 } = $$props;
  let { labelStyle = void 0 } = $$props;
  let { style = void 0 } = $$props;
  let { markerStart = void 0 } = $$props;
  let { markerEnd = void 0 } = $$props;
  let { interactionWidth = void 0 } = $$props;
  let { sourceX } = $$props;
  let { sourceY } = $$props;
  let { sourcePosition } = $$props;
  let { targetX } = $$props;
  let { targetY } = $$props;
  let { targetPosition } = $$props;
  if ($$props.label === void 0 && $$bindings.label && label !== void 0) $$bindings.label(label);
  if ($$props.labelStyle === void 0 && $$bindings.labelStyle && labelStyle !== void 0) $$bindings.labelStyle(labelStyle);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.markerStart === void 0 && $$bindings.markerStart && markerStart !== void 0) $$bindings.markerStart(markerStart);
  if ($$props.markerEnd === void 0 && $$bindings.markerEnd && markerEnd !== void 0) $$bindings.markerEnd(markerEnd);
  if ($$props.interactionWidth === void 0 && $$bindings.interactionWidth && interactionWidth !== void 0) $$bindings.interactionWidth(interactionWidth);
  if ($$props.sourceX === void 0 && $$bindings.sourceX && sourceX !== void 0) $$bindings.sourceX(sourceX);
  if ($$props.sourceY === void 0 && $$bindings.sourceY && sourceY !== void 0) $$bindings.sourceY(sourceY);
  if ($$props.sourcePosition === void 0 && $$bindings.sourcePosition && sourcePosition !== void 0) $$bindings.sourcePosition(sourcePosition);
  if ($$props.targetX === void 0 && $$bindings.targetX && targetX !== void 0) $$bindings.targetX(targetX);
  if ($$props.targetY === void 0 && $$bindings.targetY && targetY !== void 0) $$bindings.targetY(targetY);
  if ($$props.targetPosition === void 0 && $$bindings.targetPosition && targetPosition !== void 0) $$bindings.targetPosition(targetPosition);
  [path, labelX, labelY] = getSmoothStepPath({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition
  });
  return `${validate_component(BaseEdge, "BaseEdge").$$render(
    $$result,
    {
      path,
      labelX,
      labelY,
      label,
      labelStyle,
      markerStart,
      markerEnd,
      interactionWidth,
      style
    },
    {},
    {}
  )}`;
});
const StraightEdgeInternal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let path;
  let labelX;
  let labelY;
  compute_rest_props($$props, [
    "label",
    "labelStyle",
    "style",
    "markerStart",
    "markerEnd",
    "interactionWidth",
    "sourceX",
    "sourceY",
    "targetX",
    "targetY"
  ]);
  let { label = void 0 } = $$props;
  let { labelStyle = void 0 } = $$props;
  let { style = void 0 } = $$props;
  let { markerStart = void 0 } = $$props;
  let { markerEnd = void 0 } = $$props;
  let { interactionWidth = void 0 } = $$props;
  let { sourceX } = $$props;
  let { sourceY } = $$props;
  let { targetX } = $$props;
  let { targetY } = $$props;
  if ($$props.label === void 0 && $$bindings.label && label !== void 0) $$bindings.label(label);
  if ($$props.labelStyle === void 0 && $$bindings.labelStyle && labelStyle !== void 0) $$bindings.labelStyle(labelStyle);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.markerStart === void 0 && $$bindings.markerStart && markerStart !== void 0) $$bindings.markerStart(markerStart);
  if ($$props.markerEnd === void 0 && $$bindings.markerEnd && markerEnd !== void 0) $$bindings.markerEnd(markerEnd);
  if ($$props.interactionWidth === void 0 && $$bindings.interactionWidth && interactionWidth !== void 0) $$bindings.interactionWidth(interactionWidth);
  if ($$props.sourceX === void 0 && $$bindings.sourceX && sourceX !== void 0) $$bindings.sourceX(sourceX);
  if ($$props.sourceY === void 0 && $$bindings.sourceY && sourceY !== void 0) $$bindings.sourceY(sourceY);
  if ($$props.targetX === void 0 && $$bindings.targetX && targetX !== void 0) $$bindings.targetX(targetX);
  if ($$props.targetY === void 0 && $$bindings.targetY && targetY !== void 0) $$bindings.targetY(targetY);
  [path, labelX, labelY] = getStraightPath({ sourceX, sourceY, targetX, targetY });
  return `${validate_component(BaseEdge, "BaseEdge").$$render(
    $$result,
    {
      path,
      labelX,
      labelY,
      label,
      labelStyle,
      markerStart,
      markerEnd,
      interactionWidth,
      style
    },
    {},
    {}
  )}`;
});
const StepEdgeInternal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let path;
  let labelX;
  let labelY;
  compute_rest_props($$props, [
    "label",
    "labelStyle",
    "style",
    "markerStart",
    "markerEnd",
    "interactionWidth",
    "sourceX",
    "sourceY",
    "sourcePosition",
    "targetX",
    "targetY",
    "targetPosition"
  ]);
  let { label = void 0 } = $$props;
  let { labelStyle = void 0 } = $$props;
  let { style = void 0 } = $$props;
  let { markerStart = void 0 } = $$props;
  let { markerEnd = void 0 } = $$props;
  let { interactionWidth = void 0 } = $$props;
  let { sourceX } = $$props;
  let { sourceY } = $$props;
  let { sourcePosition } = $$props;
  let { targetX } = $$props;
  let { targetY } = $$props;
  let { targetPosition } = $$props;
  if ($$props.label === void 0 && $$bindings.label && label !== void 0) $$bindings.label(label);
  if ($$props.labelStyle === void 0 && $$bindings.labelStyle && labelStyle !== void 0) $$bindings.labelStyle(labelStyle);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.markerStart === void 0 && $$bindings.markerStart && markerStart !== void 0) $$bindings.markerStart(markerStart);
  if ($$props.markerEnd === void 0 && $$bindings.markerEnd && markerEnd !== void 0) $$bindings.markerEnd(markerEnd);
  if ($$props.interactionWidth === void 0 && $$bindings.interactionWidth && interactionWidth !== void 0) $$bindings.interactionWidth(interactionWidth);
  if ($$props.sourceX === void 0 && $$bindings.sourceX && sourceX !== void 0) $$bindings.sourceX(sourceX);
  if ($$props.sourceY === void 0 && $$bindings.sourceY && sourceY !== void 0) $$bindings.sourceY(sourceY);
  if ($$props.sourcePosition === void 0 && $$bindings.sourcePosition && sourcePosition !== void 0) $$bindings.sourcePosition(sourcePosition);
  if ($$props.targetX === void 0 && $$bindings.targetX && targetX !== void 0) $$bindings.targetX(targetX);
  if ($$props.targetY === void 0 && $$bindings.targetY && targetY !== void 0) $$bindings.targetY(targetY);
  if ($$props.targetPosition === void 0 && $$bindings.targetPosition && targetPosition !== void 0) $$bindings.targetPosition(targetPosition);
  [path, labelX, labelY] = getSmoothStepPath({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition,
    borderRadius: 0
  });
  return `${validate_component(BaseEdge, "BaseEdge").$$render(
    $$result,
    {
      path,
      labelX,
      labelY,
      label,
      labelStyle,
      markerStart,
      markerEnd,
      interactionWidth,
      style
    },
    {},
    {}
  )}`;
});
function syncNodeStores(nodesStore, userNodesStore) {
  const nodesStoreSetter = nodesStore.set;
  const userNodesStoreSetter = userNodesStore.set;
  const currentNodesStore = get_store_value(nodesStore);
  const currentUserNodesStore = get_store_value(userNodesStore);
  const initWithUserNodes = currentNodesStore.length === 0 && currentUserNodesStore.length > 0;
  let val = initWithUserNodes ? currentUserNodesStore : currentNodesStore;
  nodesStore.set(val);
  const _set = (nds) => {
    const updatedNodes = nodesStoreSetter(nds);
    val = updatedNodes;
    userNodesStoreSetter(val);
    return updatedNodes;
  };
  nodesStore.set = userNodesStore.set = _set;
  nodesStore.update = userNodesStore.update = (fn) => _set(fn(val));
}
function syncEdgeStores(edgesStore, userEdgesStore) {
  const nodesStoreSetter = edgesStore.set;
  const userEdgesStoreSetter = userEdgesStore.set;
  let val = get_store_value(userEdgesStore);
  edgesStore.set(val);
  const _set = (eds) => {
    nodesStoreSetter(eds);
    userEdgesStoreSetter(eds);
    val = eds;
  };
  edgesStore.set = userEdgesStore.set = _set;
  edgesStore.update = userEdgesStore.update = (fn) => _set(fn(val));
}
const syncViewportStores = (panZoomStore, viewportStore, userViewportStore) => {
  if (!userViewportStore) {
    return;
  }
  const panZoom = get_store_value(panZoomStore);
  const viewportStoreSetter = viewportStore.set;
  const userViewportStoreSetter = userViewportStore.set;
  let val = userViewportStore ? get_store_value(userViewportStore) : { x: 0, y: 0, zoom: 1 };
  viewportStore.set(val);
  viewportStore.set = (vp) => {
    viewportStoreSetter(vp);
    userViewportStoreSetter(vp);
    val = vp;
    return vp;
  };
  userViewportStore.set = (vp) => {
    panZoom?.syncViewport(vp);
    viewportStoreSetter(vp);
    userViewportStoreSetter(vp);
    val = vp;
    return vp;
  };
  viewportStore.update = (fn) => {
    viewportStore.set(fn(val));
  };
  userViewportStore.update = (fn) => {
    userViewportStore.set(fn(val));
  };
};
const createNodesStore = (nodes, nodeLookup, parentLookup, nodeOrigin = [0, 0], nodeExtent = infiniteExtent) => {
  const { subscribe: subscribe2, set, update } = writable([]);
  let value = nodes;
  let defaults = {};
  let elevateNodesOnSelect = true;
  const _set = (nds) => {
    adoptUserNodes(nds, nodeLookup, parentLookup, {
      elevateNodesOnSelect,
      nodeOrigin,
      nodeExtent,
      defaults,
      checkEquality: false
    });
    value = nds;
    set(value);
    return value;
  };
  const _update = (fn) => _set(fn(value));
  const setDefaultOptions = (options) => {
    defaults = options;
  };
  const setOptions = (options) => {
    elevateNodesOnSelect = options.elevateNodesOnSelect ?? elevateNodesOnSelect;
  };
  _set(value);
  return {
    subscribe: subscribe2,
    set: _set,
    update: _update,
    setDefaultOptions,
    setOptions
  };
};
const createEdgesStore = (edges, connectionLookup, edgeLookup, defaultOptions) => {
  const { subscribe: subscribe2, set, update } = writable([]);
  let value = edges;
  let defaults = {};
  const _set = (eds) => {
    const nextEdges = defaults ? eds.map((edge) => ({ ...defaults, ...edge })) : eds;
    updateConnectionLookup(connectionLookup, edgeLookup, nextEdges);
    value = nextEdges;
    set(value);
  };
  const _update = (fn) => _set(fn(value));
  const setDefaultOptions = (options) => {
    defaults = options;
  };
  _set(value);
  return {
    subscribe: subscribe2,
    set: _set,
    update: _update,
    setDefaultOptions
  };
};
const initialNodeTypes = {
  input: InputNode,
  output: OutputNode,
  default: DefaultNode,
  group: GroupNode
};
const initialEdgeTypes = {
  straight: StraightEdgeInternal,
  smoothstep: SmoothStepEdgeInternal,
  default: BezierEdgeInternal,
  step: StepEdgeInternal
};
const getInitialStore = ({ nodes = [], edges = [], width, height, fitView: fitView2, nodeOrigin, nodeExtent }) => {
  const nodeLookup = /* @__PURE__ */ new Map();
  const parentLookup = /* @__PURE__ */ new Map();
  const connectionLookup = /* @__PURE__ */ new Map();
  const edgeLookup = /* @__PURE__ */ new Map();
  const storeNodeOrigin = nodeOrigin ?? [0, 0];
  const storeNodeExtent = nodeExtent ?? infiniteExtent;
  adoptUserNodes(nodes, nodeLookup, parentLookup, {
    nodeExtent: storeNodeExtent,
    nodeOrigin: storeNodeOrigin,
    elevateNodesOnSelect: false,
    checkEquality: false
  });
  updateConnectionLookup(connectionLookup, edgeLookup, edges);
  let viewport = { x: 0, y: 0, zoom: 1 };
  if (fitView2 && width && height) {
    const bounds = getInternalNodesBounds(nodeLookup, {
      filter: (node) => !!((node.width || node.initialWidth) && (node.height || node.initialHeight))
    });
    viewport = getViewportForBounds(bounds, width, height, 0.5, 2, 0.1);
  }
  return {
    flowId: writable(null),
    nodes: createNodesStore(nodes, nodeLookup, parentLookup, storeNodeOrigin, storeNodeExtent),
    nodeLookup: readable(nodeLookup),
    parentLookup: readable(parentLookup),
    edgeLookup: readable(edgeLookup),
    visibleNodes: readable([]),
    edges: createEdgesStore(edges, connectionLookup, edgeLookup),
    visibleEdges: readable([]),
    connectionLookup: readable(connectionLookup),
    height: writable(500),
    width: writable(500),
    minZoom: writable(0.5),
    maxZoom: writable(2),
    nodeOrigin: writable(storeNodeOrigin),
    nodeDragThreshold: writable(1),
    nodeExtent: writable(storeNodeExtent),
    translateExtent: writable(infiniteExtent),
    autoPanOnNodeDrag: writable(true),
    autoPanOnConnect: writable(true),
    fitViewOnInit: writable(false),
    fitViewOnInitDone: writable(false),
    fitViewOptions: writable(void 0),
    panZoom: writable(null),
    snapGrid: writable(null),
    dragging: writable(false),
    selectionRect: writable(null),
    selectionKeyPressed: writable(false),
    multiselectionKeyPressed: writable(false),
    deleteKeyPressed: writable(false),
    panActivationKeyPressed: writable(false),
    zoomActivationKeyPressed: writable(false),
    selectionRectMode: writable(null),
    selectionMode: writable(SelectionMode.Partial),
    nodeTypes: writable(initialNodeTypes),
    edgeTypes: writable(initialEdgeTypes),
    viewport: writable(viewport),
    connectionMode: writable(ConnectionMode.Strict),
    domNode: writable(null),
    connection: readable(initialConnection),
    connectionLineType: writable(ConnectionLineType.Bezier),
    connectionRadius: writable(20),
    isValidConnection: writable(() => true),
    nodesDraggable: writable(true),
    nodesConnectable: writable(true),
    elementsSelectable: writable(true),
    selectNodesOnDrag: writable(true),
    markers: readable([]),
    defaultMarkerColor: writable("#b1b1b7"),
    lib: readable("svelte"),
    onlyRenderVisibleElements: writable(false),
    onerror: writable(devWarn),
    ondelete: writable(void 0),
    onedgecreate: writable(void 0),
    onconnect: writable(void 0),
    onconnectstart: writable(void 0),
    onconnectend: writable(void 0),
    onbeforedelete: writable(void 0),
    nodesInitialized: writable(false),
    edgesInitialized: writable(false),
    viewportInitialized: writable(false),
    initialized: readable(false)
  };
};
function getVisibleEdges(store) {
  const visibleEdges = derived([
    store.edges,
    store.nodes,
    store.nodeLookup,
    store.onlyRenderVisibleElements,
    store.viewport,
    store.width,
    store.height
  ], ([edges, , nodeLookup, onlyRenderVisibleElements, viewport, width, height]) => {
    const visibleEdges2 = onlyRenderVisibleElements && width && height ? edges.filter((edge) => {
      const sourceNode = nodeLookup.get(edge.source);
      const targetNode = nodeLookup.get(edge.target);
      return sourceNode && targetNode && isEdgeVisible({
        sourceNode,
        targetNode,
        width,
        height,
        transform: [viewport.x, viewport.y, viewport.zoom]
      });
    }) : edges;
    return visibleEdges2;
  });
  return derived([visibleEdges, store.nodes, store.nodeLookup, store.connectionMode, store.onerror], ([visibleEdges2, , nodeLookup, connectionMode, onerror]) => {
    const layoutedEdges = visibleEdges2.reduce((res, edge) => {
      const sourceNode = nodeLookup.get(edge.source);
      const targetNode = nodeLookup.get(edge.target);
      if (!sourceNode || !targetNode) {
        return res;
      }
      const edgePosition = getEdgePosition({
        id: edge.id,
        sourceNode,
        targetNode,
        sourceHandle: edge.sourceHandle || null,
        targetHandle: edge.targetHandle || null,
        connectionMode,
        onError: onerror
      });
      if (edgePosition) {
        res.push({
          ...edge,
          zIndex: getElevatedEdgeZIndex({
            selected: edge.selected,
            zIndex: edge.zIndex,
            sourceNode,
            targetNode,
            elevateOnSelect: false
          }),
          ...edgePosition
        });
      }
      return res;
    }, []);
    return layoutedEdges;
  });
}
function getVisibleNodes(store) {
  return derived([
    store.nodeLookup,
    store.onlyRenderVisibleElements,
    store.width,
    store.height,
    store.viewport,
    store.nodes
  ], ([nodeLookup, onlyRenderVisibleElements, width, height, viewport]) => {
    const transform = [viewport.x, viewport.y, viewport.zoom];
    return onlyRenderVisibleElements ? getNodesInside(nodeLookup, { x: 0, y: 0, width, height }, transform, true) : Array.from(nodeLookup.values());
  });
}
const key = Symbol();
function createStore({ nodes, edges, width, height, fitView: fitViewOnCreate, nodeOrigin, nodeExtent }) {
  const store = getInitialStore({
    nodes,
    edges,
    width,
    height,
    fitView: fitViewOnCreate,
    nodeOrigin,
    nodeExtent
  });
  function setNodeTypes(nodeTypes) {
    store.nodeTypes.set({
      ...initialNodeTypes,
      ...nodeTypes
    });
  }
  function setEdgeTypes(edgeTypes) {
    store.edgeTypes.set({
      ...initialEdgeTypes,
      ...edgeTypes
    });
  }
  function addEdge$1(edgeParams) {
    const edges2 = get_store_value(store.edges);
    store.edges.set(addEdge(edgeParams, edges2));
  }
  const updateNodePositions = (nodeDragItems, dragging = false) => {
    const nodeLookup = get_store_value(store.nodeLookup);
    for (const [id, dragItem] of nodeDragItems) {
      const node = nodeLookup.get(id)?.internals.userNode;
      if (!node) {
        continue;
      }
      node.position = dragItem.position;
      node.dragging = dragging;
    }
    store.nodes.update((nds) => nds);
  };
  function updateNodeInternals$1(updates) {
    const nodeLookup = get_store_value(store.nodeLookup);
    const { changes, updatedInternals } = updateNodeInternals(updates, nodeLookup, get_store_value(store.parentLookup), get_store_value(store.domNode), get_store_value(store.nodeOrigin));
    if (!updatedInternals) {
      return;
    }
    if (!get_store_value(store.fitViewOnInitDone) && get_store_value(store.fitViewOnInit)) {
      const fitViewOptions = get_store_value(store.fitViewOptions);
      const fitViewOnInitDone = fitViewSync({
        ...fitViewOptions,
        nodes: fitViewOptions?.nodes
      });
      store.fitViewOnInitDone.set(fitViewOnInitDone);
    }
    for (const change of changes) {
      const node = nodeLookup.get(change.id)?.internals.userNode;
      if (!node) {
        continue;
      }
      switch (change.type) {
        case "dimensions": {
          const measured = { ...node.measured, ...change.dimensions };
          if (change.setAttributes) {
            node.width = change.dimensions?.width ?? node.width;
            node.height = change.dimensions?.height ?? node.height;
          }
          node.measured = measured;
          break;
        }
        case "position":
          node.position = change.position ?? node.position;
          break;
      }
    }
    store.nodes.update((nds) => nds);
    if (!get_store_value(store.nodesInitialized)) {
      store.nodesInitialized.set(true);
    }
  }
  function fitView$1(options) {
    const panZoom = get_store_value(store.panZoom);
    if (!panZoom) {
      return Promise.resolve(false);
    }
    const fitViewNodes = getFitViewNodes(get_store_value(store.nodeLookup), options);
    return fitView({
      nodes: fitViewNodes,
      width: get_store_value(store.width),
      height: get_store_value(store.height),
      minZoom: get_store_value(store.minZoom),
      maxZoom: get_store_value(store.maxZoom),
      panZoom
    }, options);
  }
  function fitViewSync(options) {
    const panZoom = get_store_value(store.panZoom);
    if (!panZoom) {
      return false;
    }
    const fitViewNodes = getFitViewNodes(get_store_value(store.nodeLookup), options);
    fitView({
      nodes: fitViewNodes,
      width: get_store_value(store.width),
      height: get_store_value(store.height),
      minZoom: get_store_value(store.minZoom),
      maxZoom: get_store_value(store.maxZoom),
      panZoom
    }, options);
    return fitViewNodes.size > 0;
  }
  function zoomBy(factor, options) {
    const panZoom = get_store_value(store.panZoom);
    if (!panZoom) {
      return Promise.resolve(false);
    }
    return panZoom.scaleBy(factor, options);
  }
  function zoomIn(options) {
    return zoomBy(1.2, options);
  }
  function zoomOut(options) {
    return zoomBy(1 / 1.2, options);
  }
  function setMinZoom(minZoom) {
    const panZoom = get_store_value(store.panZoom);
    if (panZoom) {
      panZoom.setScaleExtent([minZoom, get_store_value(store.maxZoom)]);
      store.minZoom.set(minZoom);
    }
  }
  function setMaxZoom(maxZoom) {
    const panZoom = get_store_value(store.panZoom);
    if (panZoom) {
      panZoom.setScaleExtent([get_store_value(store.minZoom), maxZoom]);
      store.maxZoom.set(maxZoom);
    }
  }
  function setTranslateExtent(extent) {
    const panZoom = get_store_value(store.panZoom);
    if (panZoom) {
      panZoom.setTranslateExtent(extent);
      store.translateExtent.set(extent);
    }
  }
  function resetSelectedElements(elements) {
    let elementsChanged = false;
    elements.forEach((element) => {
      if (element.selected) {
        element.selected = false;
        elementsChanged = true;
      }
    });
    return elementsChanged;
  }
  function setPaneClickDistance(distance) {
    get_store_value(store.panZoom)?.setClickDistance(distance);
  }
  function unselectNodesAndEdges(params) {
    const resetNodes = resetSelectedElements(params?.nodes || get_store_value(store.nodes));
    if (resetNodes)
      store.nodes.set(get_store_value(store.nodes));
    const resetEdges = resetSelectedElements(params?.edges || get_store_value(store.edges));
    if (resetEdges)
      store.edges.set(get_store_value(store.edges));
  }
  store.deleteKeyPressed.subscribe(async (deleteKeyPressed) => {
    if (deleteKeyPressed) {
      const nodes2 = get_store_value(store.nodes);
      const edges2 = get_store_value(store.edges);
      const selectedNodes = nodes2.filter((node) => node.selected);
      const selectedEdges = edges2.filter((edge) => edge.selected);
      const { nodes: matchingNodes, edges: matchingEdges } = await getElementsToRemove({
        nodesToRemove: selectedNodes,
        edgesToRemove: selectedEdges,
        nodes: nodes2,
        edges: edges2,
        onBeforeDelete: get_store_value(store.onbeforedelete)
      });
      if (matchingNodes.length || matchingEdges.length) {
        store.nodes.update((nds) => nds.filter((node) => !matchingNodes.some((mN) => mN.id === node.id)));
        store.edges.update((eds) => eds.filter((edge) => !matchingEdges.some((mE) => mE.id === edge.id)));
        get_store_value(store.ondelete)?.({
          nodes: matchingNodes,
          edges: matchingEdges
        });
      }
    }
  });
  function addSelectedNodes(ids) {
    const isMultiSelection = get_store_value(store.multiselectionKeyPressed);
    store.nodes.update((ns) => ns.map((node) => {
      const nodeWillBeSelected = ids.includes(node.id);
      const selected = isMultiSelection ? node.selected || nodeWillBeSelected : nodeWillBeSelected;
      node.selected = selected;
      return node;
    }));
    if (!isMultiSelection) {
      store.edges.update((es) => es.map((edge) => {
        edge.selected = false;
        return edge;
      }));
    }
  }
  function addSelectedEdges(ids) {
    const isMultiSelection = get_store_value(store.multiselectionKeyPressed);
    store.edges.update((edges2) => edges2.map((edge) => {
      const edgeWillBeSelected = ids.includes(edge.id);
      const selected = isMultiSelection ? edge.selected || edgeWillBeSelected : edgeWillBeSelected;
      edge.selected = selected;
      return edge;
    }));
    if (!isMultiSelection) {
      store.nodes.update((ns) => ns.map((node) => {
        node.selected = false;
        return node;
      }));
    }
  }
  function handleNodeSelection(id) {
    const node = get_store_value(store.nodes)?.find((n) => n.id === id);
    if (!node) {
      console.warn("012", errorMessages["error012"](id));
      return;
    }
    store.selectionRect.set(null);
    store.selectionRectMode.set(null);
    if (!node.selected) {
      addSelectedNodes([id]);
    } else if (node.selected && get_store_value(store.multiselectionKeyPressed)) {
      unselectNodesAndEdges({ nodes: [node], edges: [] });
    }
  }
  function panBy$1(delta) {
    const viewport = get_store_value(store.viewport);
    return panBy({
      delta,
      panZoom: get_store_value(store.panZoom),
      transform: [viewport.x, viewport.y, viewport.zoom],
      translateExtent: get_store_value(store.translateExtent),
      width: get_store_value(store.width),
      height: get_store_value(store.height)
    });
  }
  const _connection = writable(initialConnection);
  const updateConnection = (newConnection) => {
    _connection.set({ ...newConnection });
  };
  function cancelConnection() {
    _connection.set(initialConnection);
  }
  function reset() {
    store.fitViewOnInitDone.set(false);
    store.selectionRect.set(null);
    store.selectionRectMode.set(null);
    store.snapGrid.set(null);
    store.isValidConnection.set(() => true);
    unselectNodesAndEdges();
    cancelConnection();
  }
  return {
    // state
    ...store,
    // derived state
    visibleEdges: getVisibleEdges(store),
    visibleNodes: getVisibleNodes(store),
    connection: derived([_connection, store.viewport], ([connection, viewport]) => {
      return connection.inProgress ? {
        ...connection,
        to: pointToRendererPoint(connection.to, [viewport.x, viewport.y, viewport.zoom])
      } : { ...connection };
    }),
    markers: derived([store.edges, store.defaultMarkerColor, store.flowId], ([edges2, defaultColor, id]) => createMarkerIds(edges2, { defaultColor, id })),
    initialized: (() => {
      let initialized = false;
      const initialNodesLength = get_store_value(store.nodes).length;
      const initialEdgesLength = get_store_value(store.edges).length;
      return derived([store.nodesInitialized, store.edgesInitialized, store.viewportInitialized], ([nodesInitialized, edgesInitialized, viewportInitialized]) => {
        if (initialized)
          return initialized;
        if (initialNodesLength === 0) {
          initialized = viewportInitialized;
        } else if (initialEdgesLength === 0) {
          initialized = viewportInitialized && nodesInitialized;
        } else {
          initialized = viewportInitialized && nodesInitialized && edgesInitialized;
        }
        return initialized;
      });
    })(),
    // actions
    syncNodeStores: (nodes2) => syncNodeStores(store.nodes, nodes2),
    syncEdgeStores: (edges2) => syncEdgeStores(store.edges, edges2),
    syncViewport: (viewport) => syncViewportStores(store.panZoom, store.viewport, viewport),
    setNodeTypes,
    setEdgeTypes,
    addEdge: addEdge$1,
    updateNodePositions,
    updateNodeInternals: updateNodeInternals$1,
    zoomIn,
    zoomOut,
    fitView: (options) => fitView$1(options),
    setMinZoom,
    setMaxZoom,
    setTranslateExtent,
    setPaneClickDistance,
    unselectNodesAndEdges,
    addSelectedNodes,
    addSelectedEdges,
    handleNodeSelection,
    panBy: panBy$1,
    updateConnection,
    cancelConnection,
    reset
  };
}
function useStore() {
  const store = getContext(key);
  if (!store) {
    throw new Error("In order to use useStore you need to wrap your component in a <SvelteFlowProvider />");
  }
  return store.getStore();
}
function createStoreContext({ nodes, edges, width, height, fitView: fitView2, nodeOrigin, nodeExtent }) {
  const store = createStore({ nodes, edges, width, height, fitView: fitView2, nodeOrigin, nodeExtent });
  setContext(key, {
    getStore: () => store
  });
  return store;
}
const css$7 = {
  code: ".svelte-flow__zoom.svelte-4xkw84{width:100%;height:100%;position:absolute;top:0;left:0;z-index:4}",
  map: `{"version":3,"file":"Zoom.svelte","sources":["Zoom.svelte"],"sourcesContent":["<script>import { onMount } from 'svelte';\\nimport { PanOnScrollMode } from '@xyflow/system';\\nimport { useStore } from '../../store';\\nimport zoom from '../../actions/zoom';\\nexport let initialViewport = undefined;\\nexport let onMoveStart = undefined;\\nexport let onMove = undefined;\\nexport let onMoveEnd = undefined;\\nexport let panOnScrollMode;\\nexport let preventScrolling;\\nexport let zoomOnScroll;\\nexport let zoomOnDoubleClick;\\nexport let zoomOnPinch;\\nexport let panOnDrag;\\nexport let panOnScroll;\\nexport let paneClickDistance;\\nconst { viewport, panZoom, selectionRect, minZoom, maxZoom, dragging, translateExtent, lib, panActivationKeyPressed, zoomActivationKeyPressed, viewportInitialized } = useStore();\\n$: viewPort = initialViewport || { x: 0, y: 0, zoom: 1 };\\n$: _panOnDrag = $panActivationKeyPressed || panOnDrag;\\n$: _panOnScroll = $panActivationKeyPressed || panOnScroll;\\nconst onTransformChange = (transform) => viewport.set({ x: transform[0], y: transform[1], zoom: transform[2] });\\nonMount(() => {\\n    $viewportInitialized = true;\\n});\\n<\/script>\\n\\n<div\\n  class=\\"svelte-flow__zoom\\"\\n  use:zoom={{\\n    viewport,\\n    minZoom: $minZoom,\\n    maxZoom: $maxZoom,\\n    initialViewport: viewPort,\\n    dragging,\\n    panZoom,\\n    onPanZoomStart: onMoveStart,\\n    onPanZoom: onMove,\\n    onPanZoomEnd: onMoveEnd,\\n    zoomOnScroll,\\n    zoomOnDoubleClick,\\n    zoomOnPinch,\\n    panOnScroll: _panOnScroll,\\n    panOnDrag: _panOnDrag,\\n    panOnScrollSpeed: 0.5,\\n    panOnScrollMode: panOnScrollMode || PanOnScrollMode.Free,\\n    zoomActivationKeyPressed: $zoomActivationKeyPressed,\\n    preventScrolling: typeof preventScrolling === 'boolean' ? preventScrolling : true,\\n    noPanClassName: 'nopan',\\n    noWheelClassName: 'nowheel',\\n    userSelectionActive: !!$selectionRect,\\n    translateExtent: $translateExtent,\\n    lib: $lib,\\n    paneClickDistance,\\n    onTransformChange\\n  }}\\n>\\n  <slot />\\n</div>\\n\\n<style>\\n  .svelte-flow__zoom {\\n    width: 100%;\\n    height: 100%;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    z-index: 4;\\n  }\\n</style>\\n"],"names":[],"mappings":"AA4DE,gCAAmB,CACjB,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IAAI,CACZ,QAAQ,CAAE,QAAQ,CAClB,GAAG,CAAE,CAAC,CACN,IAAI,CAAE,CAAC,CACP,OAAO,CAAE,CACX"}`
};
const Zoom = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_viewportInitialized;
  let $$unsubscribe_panActivationKeyPressed;
  let $$unsubscribe_minZoom;
  let $$unsubscribe_maxZoom;
  let $$unsubscribe_zoomActivationKeyPressed;
  let $$unsubscribe_selectionRect;
  let $$unsubscribe_translateExtent;
  let $$unsubscribe_lib;
  let { initialViewport = void 0 } = $$props;
  let { onMoveStart = void 0 } = $$props;
  let { onMove = void 0 } = $$props;
  let { onMoveEnd = void 0 } = $$props;
  let { panOnScrollMode } = $$props;
  let { preventScrolling } = $$props;
  let { zoomOnScroll } = $$props;
  let { zoomOnDoubleClick } = $$props;
  let { zoomOnPinch } = $$props;
  let { panOnDrag } = $$props;
  let { panOnScroll } = $$props;
  let { paneClickDistance } = $$props;
  const { viewport, panZoom, selectionRect, minZoom, maxZoom, dragging, translateExtent, lib, panActivationKeyPressed, zoomActivationKeyPressed, viewportInitialized } = useStore();
  $$unsubscribe_selectionRect = subscribe(selectionRect, (value) => value);
  $$unsubscribe_minZoom = subscribe(minZoom, (value) => value);
  $$unsubscribe_maxZoom = subscribe(maxZoom, (value) => value);
  $$unsubscribe_translateExtent = subscribe(translateExtent, (value) => value);
  $$unsubscribe_lib = subscribe(lib, (value) => value);
  $$unsubscribe_panActivationKeyPressed = subscribe(panActivationKeyPressed, (value) => value);
  $$unsubscribe_zoomActivationKeyPressed = subscribe(zoomActivationKeyPressed, (value) => value);
  $$unsubscribe_viewportInitialized = subscribe(viewportInitialized, (value) => value);
  if ($$props.initialViewport === void 0 && $$bindings.initialViewport && initialViewport !== void 0) $$bindings.initialViewport(initialViewport);
  if ($$props.onMoveStart === void 0 && $$bindings.onMoveStart && onMoveStart !== void 0) $$bindings.onMoveStart(onMoveStart);
  if ($$props.onMove === void 0 && $$bindings.onMove && onMove !== void 0) $$bindings.onMove(onMove);
  if ($$props.onMoveEnd === void 0 && $$bindings.onMoveEnd && onMoveEnd !== void 0) $$bindings.onMoveEnd(onMoveEnd);
  if ($$props.panOnScrollMode === void 0 && $$bindings.panOnScrollMode && panOnScrollMode !== void 0) $$bindings.panOnScrollMode(panOnScrollMode);
  if ($$props.preventScrolling === void 0 && $$bindings.preventScrolling && preventScrolling !== void 0) $$bindings.preventScrolling(preventScrolling);
  if ($$props.zoomOnScroll === void 0 && $$bindings.zoomOnScroll && zoomOnScroll !== void 0) $$bindings.zoomOnScroll(zoomOnScroll);
  if ($$props.zoomOnDoubleClick === void 0 && $$bindings.zoomOnDoubleClick && zoomOnDoubleClick !== void 0) $$bindings.zoomOnDoubleClick(zoomOnDoubleClick);
  if ($$props.zoomOnPinch === void 0 && $$bindings.zoomOnPinch && zoomOnPinch !== void 0) $$bindings.zoomOnPinch(zoomOnPinch);
  if ($$props.panOnDrag === void 0 && $$bindings.panOnDrag && panOnDrag !== void 0) $$bindings.panOnDrag(panOnDrag);
  if ($$props.panOnScroll === void 0 && $$bindings.panOnScroll && panOnScroll !== void 0) $$bindings.panOnScroll(panOnScroll);
  if ($$props.paneClickDistance === void 0 && $$bindings.paneClickDistance && paneClickDistance !== void 0) $$bindings.paneClickDistance(paneClickDistance);
  $$result.css.add(css$7);
  $$unsubscribe_viewportInitialized();
  $$unsubscribe_panActivationKeyPressed();
  $$unsubscribe_minZoom();
  $$unsubscribe_maxZoom();
  $$unsubscribe_zoomActivationKeyPressed();
  $$unsubscribe_selectionRect();
  $$unsubscribe_translateExtent();
  $$unsubscribe_lib();
  return `<div class="svelte-flow__zoom svelte-4xkw84">${slots.default ? slots.default({}) : ``} </div>`;
});
const css$6 = {
  code: ".svelte-flow__pane.svelte-1esy7hx{position:absolute;top:0;left:0;width:100%;height:100%}",
  map: `{"version":3,"file":"Pane.svelte","sources":["Pane.svelte"],"sourcesContent":["<script context=\\"module\\">export function wrapHandler(handler, container) {\\n    return (event) => {\\n        if (event.target !== container) {\\n            return;\\n        }\\n        handler?.(event);\\n    };\\n}\\nexport function toggleSelected(ids) {\\n    return (item) => {\\n        const isSelected = ids.includes(item.id);\\n        if (item.selected !== isSelected) {\\n            item.selected = isSelected;\\n        }\\n        return item;\\n    };\\n}\\n<\/script>\\n\\n<script>import { createEventDispatcher } from 'svelte';\\nimport { SelectionMode, getEventPosition, getNodesInside, getConnectedEdges } from '@xyflow/system';\\nimport { useStore } from '../../store';\\nexport let panOnDrag = undefined;\\nexport let selectionOnDrag = undefined;\\nconst dispatch = createEventDispatcher();\\nconst { nodes, nodeLookup, edges, viewport, dragging, elementsSelectable, selectionRect, selectionRectMode, selectionKeyPressed, selectionMode, panActivationKeyPressed, unselectNodesAndEdges } = useStore();\\nlet container;\\nlet containerBounds = null;\\nlet selectedNodes = [];\\n$: _panOnDrag = $panActivationKeyPressed || panOnDrag;\\n$: isSelecting =\\n    $selectionKeyPressed || $selectionRect || (selectionOnDrag && _panOnDrag !== true);\\n$: hasActiveSelection = $elementsSelectable && (isSelecting || $selectionRectMode === 'user');\\n// Used to prevent click events when the user lets go of the selectionKey during a selection\\nlet selectionInProgress = false;\\nfunction onClick(event) {\\n    // We prevent click events when the user let go of the selectionKey during a selection\\n    if (selectionInProgress) {\\n        selectionInProgress = false;\\n        return;\\n    }\\n    dispatch('paneclick', { event });\\n    unselectNodesAndEdges();\\n    selectionRectMode.set(null);\\n}\\nfunction onPointerDown(event) {\\n    containerBounds = container.getBoundingClientRect();\\n    if (!elementsSelectable ||\\n        !isSelecting ||\\n        event.button !== 0 ||\\n        event.target !== container ||\\n        !containerBounds) {\\n        return;\\n    }\\n    event.target?.setPointerCapture?.(event.pointerId);\\n    const { x, y } = getEventPosition(event, containerBounds);\\n    unselectNodesAndEdges();\\n    selectionRect.set({\\n        width: 0,\\n        height: 0,\\n        startX: x,\\n        startY: y,\\n        x,\\n        y\\n    });\\n    // onSelectionStart?.(event);\\n}\\nfunction onPointerMove(event) {\\n    if (!isSelecting || !containerBounds || !$selectionRect) {\\n        return;\\n    }\\n    selectionInProgress = true;\\n    const mousePos = getEventPosition(event, containerBounds);\\n    const startX = $selectionRect.startX ?? 0;\\n    const startY = $selectionRect.startY ?? 0;\\n    const nextUserSelectRect = {\\n        ...$selectionRect,\\n        x: mousePos.x < startX ? mousePos.x : startX,\\n        y: mousePos.y < startY ? mousePos.y : startY,\\n        width: Math.abs(mousePos.x - startX),\\n        height: Math.abs(mousePos.y - startY)\\n    };\\n    const prevSelectedNodeIds = selectedNodes.map((n) => n.id);\\n    const prevSelectedEdgeIds = getConnectedEdges(selectedNodes, $edges).map((e) => e.id);\\n    selectedNodes = getNodesInside($nodeLookup, nextUserSelectRect, [$viewport.x, $viewport.y, $viewport.zoom], $selectionMode === SelectionMode.Partial, true);\\n    const selectedEdgeIds = getConnectedEdges(selectedNodes, $edges).map((e) => e.id);\\n    const selectedNodeIds = selectedNodes.map((n) => n.id);\\n    // this prevents unnecessary updates while updating the selection rectangle\\n    if (prevSelectedNodeIds.length !== selectedNodeIds.length ||\\n        selectedNodeIds.some((id) => !prevSelectedNodeIds.includes(id))) {\\n        nodes.update((nodes) => nodes.map(toggleSelected(selectedNodeIds)));\\n    }\\n    if (prevSelectedEdgeIds.length !== selectedEdgeIds.length ||\\n        selectedEdgeIds.some((id) => !prevSelectedEdgeIds.includes(id))) {\\n        edges.update((edges) => edges.map(toggleSelected(selectedEdgeIds)));\\n    }\\n    selectionRectMode.set('user');\\n    selectionRect.set(nextUserSelectRect);\\n}\\nfunction onPointerUp(event) {\\n    if (event.button !== 0) {\\n        return;\\n    }\\n    event.target?.releasePointerCapture?.(event.pointerId);\\n    // We only want to trigger click functions when in selection mode if\\n    // the user did not move the mouse.\\n    if (!isSelecting && $selectionRectMode === 'user' && event.target === container) {\\n        onClick?.(event);\\n    }\\n    selectionRect.set(null);\\n    if (selectedNodes.length > 0) {\\n        $selectionRectMode = 'nodes';\\n    }\\n    // If the user kept holding the selectionKey during the selection,\\n    // we need to reset the selectionInProgress, so the next click event is not prevented\\n    if ($selectionKeyPressed) {\\n        selectionInProgress = false;\\n    }\\n    // onSelectionEnd?.(event);\\n}\\nconst onContextMenu = (event) => {\\n    if (Array.isArray(_panOnDrag) && _panOnDrag?.includes(2)) {\\n        event.preventDefault();\\n        return;\\n    }\\n    dispatch('panecontextmenu', { event });\\n};\\n<\/script>\\n\\n<!-- svelte-ignore a11y-no-static-element-interactions -->\\n<!-- svelte-ignore a11y-click-events-have-key-events -->\\n<div\\n  bind:this={container}\\n  class=\\"svelte-flow__pane\\"\\n  class:draggable={panOnDrag === true || (Array.isArray(panOnDrag) && panOnDrag.includes(0))}\\n  class:dragging={$dragging}\\n  class:selection={isSelecting}\\n  on:click={hasActiveSelection ? undefined : wrapHandler(onClick, container)}\\n  on:pointerdown={hasActiveSelection ? onPointerDown : undefined}\\n  on:pointermove={hasActiveSelection ? onPointerMove : undefined}\\n  on:pointerup={hasActiveSelection ? onPointerUp : undefined}\\n  on:contextmenu={wrapHandler(onContextMenu, container)}\\n>\\n  <slot />\\n</div>\\n\\n<style>\\n  .svelte-flow__pane {\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    width: 100%;\\n    height: 100%;\\n  }\\n</style>\\n"],"names":[],"mappings":"AAmJE,iCAAmB,CACjB,QAAQ,CAAE,QAAQ,CAClB,GAAG,CAAE,CAAC,CACN,IAAI,CAAE,CAAC,CACP,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IACV"}`
};
const Pane = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let _panOnDrag;
  let isSelecting;
  let $selectionKeyPressed, $$unsubscribe_selectionKeyPressed;
  let $$unsubscribe_selectionRectMode;
  let $$unsubscribe_edges;
  let $$unsubscribe_selectionMode;
  let $$unsubscribe_viewport;
  let $$unsubscribe_nodeLookup;
  let $selectionRect, $$unsubscribe_selectionRect;
  let $$unsubscribe_elementsSelectable;
  let $panActivationKeyPressed, $$unsubscribe_panActivationKeyPressed;
  let $dragging, $$unsubscribe_dragging;
  let { panOnDrag = void 0 } = $$props;
  let { selectionOnDrag = void 0 } = $$props;
  createEventDispatcher();
  const { nodes, nodeLookup, edges, viewport, dragging, elementsSelectable, selectionRect, selectionRectMode, selectionKeyPressed, selectionMode, panActivationKeyPressed, unselectNodesAndEdges } = useStore();
  $$unsubscribe_nodeLookup = subscribe(nodeLookup, (value) => value);
  $$unsubscribe_edges = subscribe(edges, (value) => value);
  $$unsubscribe_viewport = subscribe(viewport, (value) => value);
  $$unsubscribe_dragging = subscribe(dragging, (value) => $dragging = value);
  $$unsubscribe_elementsSelectable = subscribe(elementsSelectable, (value) => value);
  $$unsubscribe_selectionRect = subscribe(selectionRect, (value) => $selectionRect = value);
  $$unsubscribe_selectionRectMode = subscribe(selectionRectMode, (value) => value);
  $$unsubscribe_selectionKeyPressed = subscribe(selectionKeyPressed, (value) => $selectionKeyPressed = value);
  $$unsubscribe_selectionMode = subscribe(selectionMode, (value) => value);
  $$unsubscribe_panActivationKeyPressed = subscribe(panActivationKeyPressed, (value) => $panActivationKeyPressed = value);
  let container;
  if ($$props.panOnDrag === void 0 && $$bindings.panOnDrag && panOnDrag !== void 0) $$bindings.panOnDrag(panOnDrag);
  if ($$props.selectionOnDrag === void 0 && $$bindings.selectionOnDrag && selectionOnDrag !== void 0) $$bindings.selectionOnDrag(selectionOnDrag);
  $$result.css.add(css$6);
  _panOnDrag = $panActivationKeyPressed || panOnDrag;
  isSelecting = $selectionKeyPressed || $selectionRect || selectionOnDrag && _panOnDrag !== true;
  $$unsubscribe_selectionKeyPressed();
  $$unsubscribe_selectionRectMode();
  $$unsubscribe_edges();
  $$unsubscribe_selectionMode();
  $$unsubscribe_viewport();
  $$unsubscribe_nodeLookup();
  $$unsubscribe_selectionRect();
  $$unsubscribe_elementsSelectable();
  $$unsubscribe_panActivationKeyPressed();
  $$unsubscribe_dragging();
  return `  <div class="${[
    "svelte-flow__pane svelte-1esy7hx",
    (panOnDrag === true || Array.isArray(panOnDrag) && panOnDrag.includes(0) ? "draggable" : "") + " " + ($dragging ? "dragging" : "") + " " + (isSelecting ? "selection" : "")
  ].join(" ").trim()}"${add_attribute("this", container, 0)}>${slots.default ? slots.default({}) : ``} </div>`;
});
const css$5 = {
  code: ".svelte-flow__viewport.svelte-1floaup{width:100%;height:100%;position:absolute;top:0;left:0}",
  map: `{"version":3,"file":"Viewport.svelte","sources":["Viewport.svelte"],"sourcesContent":["<script>import { useStore } from '../../store';\\nconst { viewport } = useStore();\\n<\/script>\\n\\n<div\\n  class=\\"svelte-flow__viewport xyflow__viewport\\"\\n  style=\\"transform: translate({$viewport.x}px, {$viewport.y}px) scale({$viewport.zoom})\\"\\n>\\n  <slot />\\n</div>\\n\\n<style>\\n  .svelte-flow__viewport {\\n    width: 100%;\\n    height: 100%;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n  }\\n</style>\\n"],"names":[],"mappings":"AAYE,qCAAuB,CACrB,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IAAI,CACZ,QAAQ,CAAE,QAAQ,CAClB,GAAG,CAAE,CAAC,CACN,IAAI,CAAE,CACR"}`
};
const Viewport = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $viewport, $$unsubscribe_viewport;
  const { viewport } = useStore();
  $$unsubscribe_viewport = subscribe(viewport, (value) => $viewport = value);
  $$result.css.add(css$5);
  $$unsubscribe_viewport();
  return `<div class="svelte-flow__viewport xyflow__viewport svelte-1floaup" style="${"transform: translate(" + escape($viewport.x, true) + "px, " + escape($viewport.y, true) + "px) scale(" + escape($viewport.zoom, true) + ")"}">${slots.default ? slots.default({}) : ``} </div>`;
});
function getNodeInlineStyleDimensions({ width, height, initialWidth, initialHeight, measuredWidth, measuredHeight }) {
  if (measuredWidth === void 0 && measuredHeight === void 0) {
    const styleWidth = width ?? initialWidth;
    const styleHeight = height ?? initialHeight;
    return {
      width: styleWidth ? `width:${styleWidth}px;` : "",
      height: styleHeight ? `height:${styleHeight}px;` : ""
    };
  }
  return {
    width: width ? `width:${width}px;` : "",
    height: height ? `height:${height}px;` : ""
  };
}
const NodeWrapper = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let nodeType;
  let nodeTypeValid;
  let nodeComponent;
  let inlineStyleDimensions;
  let $nodeTypes, $$unsubscribe_nodeTypes;
  let $connectableStore, $$unsubscribe_connectableStore;
  let { node } = $$props;
  let { id } = $$props;
  let { data = {} } = $$props;
  let { selected = false } = $$props;
  let { draggable = void 0 } = $$props;
  let { selectable = void 0 } = $$props;
  let { connectable = true } = $$props;
  let { deletable = true } = $$props;
  let { hidden = false } = $$props;
  let { dragging = false } = $$props;
  let { resizeObserver = null } = $$props;
  let { style = void 0 } = $$props;
  let { type = "default" } = $$props;
  let { isParent = false } = $$props;
  let { positionX } = $$props;
  let { positionY } = $$props;
  let { sourcePosition = void 0 } = $$props;
  let { targetPosition = void 0 } = $$props;
  let { zIndex } = $$props;
  let { measuredWidth = void 0 } = $$props;
  let { measuredHeight = void 0 } = $$props;
  let { initialWidth = void 0 } = $$props;
  let { initialHeight = void 0 } = $$props;
  let { width = void 0 } = $$props;
  let { height = void 0 } = $$props;
  let { dragHandle = void 0 } = $$props;
  let { initialized = false } = $$props;
  let { parentId = void 0 } = $$props;
  let { nodeClickDistance = void 0 } = $$props;
  let { class: className = "" } = $$props;
  const store = useStore();
  const { nodeTypes, nodeDragThreshold, selectNodesOnDrag, handleNodeSelection, updateNodeInternals: updateNodeInternals2 } = store;
  $$unsubscribe_nodeTypes = subscribe(nodeTypes, (value) => $nodeTypes = value);
  let nodeRef;
  let prevNodeRef = null;
  createEventDispatcher();
  const connectableStore = writable(connectable);
  $$unsubscribe_connectableStore = subscribe(connectableStore, (value) => $connectableStore = value);
  let prevType = void 0;
  let prevSourcePosition = void 0;
  let prevTargetPosition = void 0;
  setContext("svelteflow__node_id", id);
  setContext("svelteflow__node_connectable", connectableStore);
  onDestroy(() => {
    if (prevNodeRef) {
      resizeObserver?.unobserve(prevNodeRef);
    }
  });
  if ($$props.node === void 0 && $$bindings.node && node !== void 0) $$bindings.node(node);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.data === void 0 && $$bindings.data && data !== void 0) $$bindings.data(data);
  if ($$props.selected === void 0 && $$bindings.selected && selected !== void 0) $$bindings.selected(selected);
  if ($$props.draggable === void 0 && $$bindings.draggable && draggable !== void 0) $$bindings.draggable(draggable);
  if ($$props.selectable === void 0 && $$bindings.selectable && selectable !== void 0) $$bindings.selectable(selectable);
  if ($$props.connectable === void 0 && $$bindings.connectable && connectable !== void 0) $$bindings.connectable(connectable);
  if ($$props.deletable === void 0 && $$bindings.deletable && deletable !== void 0) $$bindings.deletable(deletable);
  if ($$props.hidden === void 0 && $$bindings.hidden && hidden !== void 0) $$bindings.hidden(hidden);
  if ($$props.dragging === void 0 && $$bindings.dragging && dragging !== void 0) $$bindings.dragging(dragging);
  if ($$props.resizeObserver === void 0 && $$bindings.resizeObserver && resizeObserver !== void 0) $$bindings.resizeObserver(resizeObserver);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.isParent === void 0 && $$bindings.isParent && isParent !== void 0) $$bindings.isParent(isParent);
  if ($$props.positionX === void 0 && $$bindings.positionX && positionX !== void 0) $$bindings.positionX(positionX);
  if ($$props.positionY === void 0 && $$bindings.positionY && positionY !== void 0) $$bindings.positionY(positionY);
  if ($$props.sourcePosition === void 0 && $$bindings.sourcePosition && sourcePosition !== void 0) $$bindings.sourcePosition(sourcePosition);
  if ($$props.targetPosition === void 0 && $$bindings.targetPosition && targetPosition !== void 0) $$bindings.targetPosition(targetPosition);
  if ($$props.zIndex === void 0 && $$bindings.zIndex && zIndex !== void 0) $$bindings.zIndex(zIndex);
  if ($$props.measuredWidth === void 0 && $$bindings.measuredWidth && measuredWidth !== void 0) $$bindings.measuredWidth(measuredWidth);
  if ($$props.measuredHeight === void 0 && $$bindings.measuredHeight && measuredHeight !== void 0) $$bindings.measuredHeight(measuredHeight);
  if ($$props.initialWidth === void 0 && $$bindings.initialWidth && initialWidth !== void 0) $$bindings.initialWidth(initialWidth);
  if ($$props.initialHeight === void 0 && $$bindings.initialHeight && initialHeight !== void 0) $$bindings.initialHeight(initialHeight);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0) $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0) $$bindings.height(height);
  if ($$props.dragHandle === void 0 && $$bindings.dragHandle && dragHandle !== void 0) $$bindings.dragHandle(dragHandle);
  if ($$props.initialized === void 0 && $$bindings.initialized && initialized !== void 0) $$bindings.initialized(initialized);
  if ($$props.parentId === void 0 && $$bindings.parentId && parentId !== void 0) $$bindings.parentId(parentId);
  if ($$props.nodeClickDistance === void 0 && $$bindings.nodeClickDistance && nodeClickDistance !== void 0) $$bindings.nodeClickDistance(nodeClickDistance);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  nodeType = type || "default";
  nodeTypeValid = !!$nodeTypes[nodeType];
  nodeComponent = $nodeTypes[nodeType] || DefaultNode;
  {
    {
      if (!nodeTypeValid) {
        console.warn("003", errorMessages["error003"](type));
      }
    }
  }
  inlineStyleDimensions = getNodeInlineStyleDimensions({
    width,
    height,
    initialWidth,
    initialHeight,
    measuredWidth,
    measuredHeight
  });
  {
    {
      connectableStore.set(!!connectable);
    }
  }
  {
    {
      const doUpdate = prevType && nodeType !== prevType || prevSourcePosition && sourcePosition !== prevSourcePosition || prevTargetPosition && targetPosition !== prevTargetPosition;
      if (doUpdate) {
        requestAnimationFrame(() => updateNodeInternals2(/* @__PURE__ */ new Map([[id, { id, nodeElement: nodeRef, force: true }]])));
      }
      prevType = nodeType;
      prevSourcePosition = sourcePosition;
      prevTargetPosition = targetPosition;
    }
  }
  {
    {
      if (resizeObserver && (nodeRef !== prevNodeRef || !initialized)) {
        prevNodeRef && resizeObserver.unobserve(prevNodeRef);
        prevNodeRef = nodeRef;
      }
    }
  }
  $$unsubscribe_nodeTypes();
  $$unsubscribe_connectableStore();
  return `    ${!hidden ? `<div${add_attribute("data-id", id, 0)} class="${[
    escape(cc(["svelte-flow__node", `svelte-flow__node-${nodeType}`, className]), true),
    (dragging ? "dragging" : "") + " " + (selected ? "selected" : "") + " " + (draggable ? "draggable" : "") + " " + (connectable ? "connectable" : "") + " " + (selectable ? "selectable" : "") + " " + (draggable ? "nopan" : "") + " " + (isParent ? "parent" : "")
  ].join(" ").trim()}"${add_styles(merge_ssr_styles(escape(style ?? "", true) + ";" + escape(inlineStyleDimensions.width, true) + escape(inlineStyleDimensions.height, true), {
    "z-index": zIndex,
    "transform": `translate(${positionX}px, ${positionY}px)`,
    "visibility": initialized ? "visible" : "hidden"
  }))}${add_attribute("this", nodeRef, 0)}>${validate_component(nodeComponent || missing_component, "svelte:component").$$render(
    $$result,
    {
      data,
      id,
      selected,
      selectable,
      deletable,
      sourcePosition,
      targetPosition,
      zIndex,
      dragging,
      draggable,
      dragHandle,
      parentId,
      type: nodeType,
      isConnectable: $connectableStore,
      positionAbsoluteX: positionX,
      positionAbsoluteY: positionY,
      width,
      height
    },
    {},
    {}
  )}</div>` : ``}`;
});
const css$4 = {
  code: ".svelte-flow__nodes.svelte-tf4uy4{width:100%;height:100%;position:absolute;left:0;top:0}",
  map: `{"version":3,"file":"NodeRenderer.svelte","sources":["NodeRenderer.svelte"],"sourcesContent":["<script>import { onDestroy } from 'svelte';\\nimport { nodeHasDimensions } from '@xyflow/system';\\nimport { NodeWrapper } from '../../components/NodeWrapper';\\nimport { useStore } from '../../store';\\nexport let nodeClickDistance = 0;\\nconst { visibleNodes, nodesDraggable, nodesConnectable, elementsSelectable, updateNodeInternals, parentLookup } = useStore();\\nconst resizeObserver = typeof ResizeObserver === 'undefined'\\n    ? null\\n    : new ResizeObserver((entries) => {\\n        const updates = new Map();\\n        entries.forEach((entry) => {\\n            const id = entry.target.getAttribute('data-id');\\n            updates.set(id, {\\n                id,\\n                nodeElement: entry.target,\\n                force: true\\n            });\\n        });\\n        updateNodeInternals(updates);\\n    });\\nonDestroy(() => {\\n    resizeObserver?.disconnect();\\n});\\n<\/script>\\n\\n<div class=\\"svelte-flow__nodes\\">\\n  {#each $visibleNodes as node (node.id)}\\n    <NodeWrapper\\n      {node}\\n      id={node.id}\\n      data={node.data}\\n      selected={!!node.selected}\\n      hidden={!!node.hidden}\\n      draggable={!!(node.draggable || ($nodesDraggable && typeof node.draggable === 'undefined'))}\\n      selectable={!!(\\n        node.selectable ||\\n        ($elementsSelectable && typeof node.selectable === 'undefined')\\n      )}\\n      connectable={!!(\\n        node.connectable ||\\n        ($nodesConnectable && typeof node.connectable === 'undefined')\\n      )}\\n      deletable={node.deletable ?? true}\\n      positionX={node.internals.positionAbsolute.x}\\n      positionY={node.internals.positionAbsolute.y}\\n      isParent={$parentLookup.has(node.id)}\\n      style={node.style}\\n      class={node.class}\\n      type={node.type ?? 'default'}\\n      sourcePosition={node.sourcePosition}\\n      targetPosition={node.targetPosition}\\n      dragging={node.dragging}\\n      zIndex={node.internals.z ?? 0}\\n      dragHandle={node.dragHandle}\\n      initialized={nodeHasDimensions(node)}\\n      width={node.width}\\n      height={node.height}\\n      initialWidth={node.initialWidth}\\n      initialHeight={node.initialHeight}\\n      measuredWidth={node.measured.width}\\n      measuredHeight={node.measured.height}\\n      parentId={node.parentId}\\n      {resizeObserver}\\n      {nodeClickDistance}\\n      on:nodeclick\\n      on:nodemouseenter\\n      on:nodemousemove\\n      on:nodemouseleave\\n      on:nodedrag\\n      on:nodedragstart\\n      on:nodedragstop\\n      on:nodecontextmenu\\n    />\\n  {/each}\\n</div>\\n\\n<style>\\n  .svelte-flow__nodes {\\n    width: 100%;\\n    height: 100%;\\n    position: absolute;\\n    left: 0;\\n    top: 0;\\n  }\\n</style>\\n"],"names":[],"mappings":"AA6EE,iCAAoB,CAClB,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IAAI,CACZ,QAAQ,CAAE,QAAQ,CAClB,IAAI,CAAE,CAAC,CACP,GAAG,CAAE,CACP"}`
};
const NodeRenderer = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $visibleNodes, $$unsubscribe_visibleNodes;
  let $nodesDraggable, $$unsubscribe_nodesDraggable;
  let $elementsSelectable, $$unsubscribe_elementsSelectable;
  let $nodesConnectable, $$unsubscribe_nodesConnectable;
  let $parentLookup, $$unsubscribe_parentLookup;
  let { nodeClickDistance = 0 } = $$props;
  const { visibleNodes, nodesDraggable, nodesConnectable, elementsSelectable, updateNodeInternals: updateNodeInternals2, parentLookup } = useStore();
  $$unsubscribe_visibleNodes = subscribe(visibleNodes, (value) => $visibleNodes = value);
  $$unsubscribe_nodesDraggable = subscribe(nodesDraggable, (value) => $nodesDraggable = value);
  $$unsubscribe_nodesConnectable = subscribe(nodesConnectable, (value) => $nodesConnectable = value);
  $$unsubscribe_elementsSelectable = subscribe(elementsSelectable, (value) => $elementsSelectable = value);
  $$unsubscribe_parentLookup = subscribe(parentLookup, (value) => $parentLookup = value);
  const resizeObserver = typeof ResizeObserver === "undefined" ? null : new ResizeObserver((entries) => {
    const updates = /* @__PURE__ */ new Map();
    entries.forEach((entry) => {
      const id = entry.target.getAttribute("data-id");
      updates.set(id, {
        id,
        nodeElement: entry.target,
        force: true
      });
    });
    updateNodeInternals2(updates);
  });
  onDestroy(() => {
    resizeObserver?.disconnect();
  });
  if ($$props.nodeClickDistance === void 0 && $$bindings.nodeClickDistance && nodeClickDistance !== void 0) $$bindings.nodeClickDistance(nodeClickDistance);
  $$result.css.add(css$4);
  $$unsubscribe_visibleNodes();
  $$unsubscribe_nodesDraggable();
  $$unsubscribe_elementsSelectable();
  $$unsubscribe_nodesConnectable();
  $$unsubscribe_parentLookup();
  return `<div class="svelte-flow__nodes svelte-tf4uy4">${each($visibleNodes, (node) => {
    return `${validate_component(NodeWrapper, "NodeWrapper").$$render(
      $$result,
      {
        node,
        id: node.id,
        data: node.data,
        selected: !!node.selected,
        hidden: !!node.hidden,
        draggable: !!(node.draggable || $nodesDraggable && typeof node.draggable === "undefined"),
        selectable: !!(node.selectable || $elementsSelectable && typeof node.selectable === "undefined"),
        connectable: !!(node.connectable || $nodesConnectable && typeof node.connectable === "undefined"),
        deletable: node.deletable ?? true,
        positionX: node.internals.positionAbsolute.x,
        positionY: node.internals.positionAbsolute.y,
        isParent: $parentLookup.has(node.id),
        style: node.style,
        class: node.class,
        type: node.type ?? "default",
        sourcePosition: node.sourcePosition,
        targetPosition: node.targetPosition,
        dragging: node.dragging,
        zIndex: node.internals.z ?? 0,
        dragHandle: node.dragHandle,
        initialized: nodeHasDimensions(node),
        width: node.width,
        height: node.height,
        initialWidth: node.initialWidth,
        initialHeight: node.initialHeight,
        measuredWidth: node.measured.width,
        measuredHeight: node.measured.height,
        parentId: node.parentId,
        resizeObserver,
        nodeClickDistance
      },
      {},
      {}
    )}`;
  })} </div>`;
});
const EdgeWrapper = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let edgeType;
  let edgeComponent;
  let markerStartUrl;
  let markerEndUrl;
  let isSelectable;
  let $$unsubscribe_edgeLookup;
  let $elementsSelectable, $$unsubscribe_elementsSelectable;
  let $flowId, $$unsubscribe_flowId;
  let $edgeTypes, $$unsubscribe_edgeTypes;
  let { id } = $$props;
  let { type = "default" } = $$props;
  let { source = "" } = $$props;
  let { target = "" } = $$props;
  let { data = {} } = $$props;
  let { style = void 0 } = $$props;
  let { zIndex = void 0 } = $$props;
  let { animated = false } = $$props;
  let { selected = false } = $$props;
  let { selectable = void 0 } = $$props;
  let { deletable = void 0 } = $$props;
  let { hidden = false } = $$props;
  let { label = void 0 } = $$props;
  let { labelStyle = void 0 } = $$props;
  let { markerStart = void 0 } = $$props;
  let { markerEnd = void 0 } = $$props;
  let { sourceHandle = void 0 } = $$props;
  let { targetHandle = void 0 } = $$props;
  let { sourceX } = $$props;
  let { sourceY } = $$props;
  let { targetX } = $$props;
  let { targetY } = $$props;
  let { sourcePosition } = $$props;
  let { targetPosition } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { interactionWidth = void 0 } = $$props;
  let { class: className = "" } = $$props;
  setContext("svelteflow__edge_id", id);
  const { edgeLookup, edgeTypes, flowId, elementsSelectable } = useStore();
  $$unsubscribe_edgeLookup = subscribe(edgeLookup, (value) => value);
  $$unsubscribe_edgeTypes = subscribe(edgeTypes, (value) => $edgeTypes = value);
  $$unsubscribe_flowId = subscribe(flowId, (value) => $flowId = value);
  $$unsubscribe_elementsSelectable = subscribe(elementsSelectable, (value) => $elementsSelectable = value);
  createEventDispatcher();
  useHandleEdgeSelect();
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.source === void 0 && $$bindings.source && source !== void 0) $$bindings.source(source);
  if ($$props.target === void 0 && $$bindings.target && target !== void 0) $$bindings.target(target);
  if ($$props.data === void 0 && $$bindings.data && data !== void 0) $$bindings.data(data);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.zIndex === void 0 && $$bindings.zIndex && zIndex !== void 0) $$bindings.zIndex(zIndex);
  if ($$props.animated === void 0 && $$bindings.animated && animated !== void 0) $$bindings.animated(animated);
  if ($$props.selected === void 0 && $$bindings.selected && selected !== void 0) $$bindings.selected(selected);
  if ($$props.selectable === void 0 && $$bindings.selectable && selectable !== void 0) $$bindings.selectable(selectable);
  if ($$props.deletable === void 0 && $$bindings.deletable && deletable !== void 0) $$bindings.deletable(deletable);
  if ($$props.hidden === void 0 && $$bindings.hidden && hidden !== void 0) $$bindings.hidden(hidden);
  if ($$props.label === void 0 && $$bindings.label && label !== void 0) $$bindings.label(label);
  if ($$props.labelStyle === void 0 && $$bindings.labelStyle && labelStyle !== void 0) $$bindings.labelStyle(labelStyle);
  if ($$props.markerStart === void 0 && $$bindings.markerStart && markerStart !== void 0) $$bindings.markerStart(markerStart);
  if ($$props.markerEnd === void 0 && $$bindings.markerEnd && markerEnd !== void 0) $$bindings.markerEnd(markerEnd);
  if ($$props.sourceHandle === void 0 && $$bindings.sourceHandle && sourceHandle !== void 0) $$bindings.sourceHandle(sourceHandle);
  if ($$props.targetHandle === void 0 && $$bindings.targetHandle && targetHandle !== void 0) $$bindings.targetHandle(targetHandle);
  if ($$props.sourceX === void 0 && $$bindings.sourceX && sourceX !== void 0) $$bindings.sourceX(sourceX);
  if ($$props.sourceY === void 0 && $$bindings.sourceY && sourceY !== void 0) $$bindings.sourceY(sourceY);
  if ($$props.targetX === void 0 && $$bindings.targetX && targetX !== void 0) $$bindings.targetX(targetX);
  if ($$props.targetY === void 0 && $$bindings.targetY && targetY !== void 0) $$bindings.targetY(targetY);
  if ($$props.sourcePosition === void 0 && $$bindings.sourcePosition && sourcePosition !== void 0) $$bindings.sourcePosition(sourcePosition);
  if ($$props.targetPosition === void 0 && $$bindings.targetPosition && targetPosition !== void 0) $$bindings.targetPosition(targetPosition);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0) $$bindings.ariaLabel(ariaLabel);
  if ($$props.interactionWidth === void 0 && $$bindings.interactionWidth && interactionWidth !== void 0) $$bindings.interactionWidth(interactionWidth);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  edgeType = type || "default";
  edgeComponent = $edgeTypes[edgeType] || BezierEdgeInternal;
  markerStartUrl = markerStart ? `url('#${getMarkerId(markerStart, $flowId)}')` : void 0;
  markerEndUrl = markerEnd ? `url('#${getMarkerId(markerEnd, $flowId)}')` : void 0;
  isSelectable = selectable ?? $elementsSelectable;
  $$unsubscribe_edgeLookup();
  $$unsubscribe_elementsSelectable();
  $$unsubscribe_flowId();
  $$unsubscribe_edgeTypes();
  return `    ${!hidden ? `<svg${add_styles({ "z-index": zIndex })}><g class="${[
    escape(cc(["svelte-flow__edge", className]), true),
    (animated ? "animated" : "") + " " + (selected ? "selected" : "") + " " + (isSelectable ? "selectable" : "")
  ].join(" ").trim()}"${add_attribute("data-id", id, 0)}${add_attribute(
    "aria-label",
    ariaLabel === null ? void 0 : ariaLabel ? ariaLabel : `Edge from ${source} to ${target}`,
    0
  )} role="img">${validate_component(edgeComponent || missing_component, "svelte:component").$$render(
    $$result,
    {
      id,
      source,
      target,
      sourceX,
      sourceY,
      targetX,
      targetY,
      sourcePosition,
      targetPosition,
      animated,
      selected,
      label,
      labelStyle,
      data,
      style,
      interactionWidth,
      selectable: isSelectable,
      deletable: deletable ?? true,
      type: edgeType,
      sourceHandleId: sourceHandle,
      targetHandleId: targetHandle,
      markerStart: markerStartUrl,
      markerEnd: markerEndUrl
    },
    {},
    {}
  )}</g></svg>` : ``}`;
});
const CallOnMount = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { onMount: _onMount = void 0 } = $$props;
  let { onDestroy: _onDestroy = void 0 } = $$props;
  if ($$props.onMount === void 0 && $$bindings.onMount && _onMount !== void 0) $$bindings.onMount(_onMount);
  if ($$props.onDestroy === void 0 && $$bindings.onDestroy && _onDestroy !== void 0) $$bindings.onDestroy(_onDestroy);
  return ``;
});
const MarkerDefinition = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $markers, $$unsubscribe_markers;
  const { markers } = useStore();
  $$unsubscribe_markers = subscribe(markers, (value) => $markers = value);
  $$unsubscribe_markers();
  return `<defs>${each($markers, (marker) => {
    return `${validate_component(Marker, "Marker").$$render($$result, Object.assign({}, marker), {}, {})}`;
  })}</defs>`;
});
const Marker = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { id } = $$props;
  let { type } = $$props;
  let { width = 12.5 } = $$props;
  let { height = 12.5 } = $$props;
  let { markerUnits = "strokeWidth" } = $$props;
  let { orient = "auto-start-reverse" } = $$props;
  let { color = void 0 } = $$props;
  let { strokeWidth = void 0 } = $$props;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0) $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0) $$bindings.height(height);
  if ($$props.markerUnits === void 0 && $$bindings.markerUnits && markerUnits !== void 0) $$bindings.markerUnits(markerUnits);
  if ($$props.orient === void 0 && $$bindings.orient && orient !== void 0) $$bindings.orient(orient);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0) $$bindings.color(color);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<marker class="svelte-flow__arrowhead"${add_attribute("id", id, 0)}${add_attribute("markerWidth", `${width}`, 0)}${add_attribute("markerHeight", `${height}`, 0)} viewBox="-10 -10 20 20"${add_attribute("markerUnits", markerUnits, 0)}${add_attribute("orient", orient, 0)} refX="0" refY="0">${type === MarkerType.Arrow ? `<polyline${add_attribute("stroke", color, 0)} stroke-linecap="round" stroke-linejoin="round"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" points="-5,-4 0,0 -5,4"></polyline>` : `${type === MarkerType.ArrowClosed ? `<polyline${add_attribute("stroke", color, 0)} stroke-linecap="round" stroke-linejoin="round"${add_attribute("stroke-width", strokeWidth, 0)}${add_attribute("fill", color, 0)} points="-5,-4 0,0 -5,4 -5,-4"></polyline>` : ``}`}</marker>`;
});
const EdgeRenderer = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $visibleEdges, $$unsubscribe_visibleEdges;
  let $elementsSelectable, $$unsubscribe_elementsSelectable;
  let $$unsubscribe_edgesInitialized;
  let { defaultEdgeOptions } = $$props;
  const { visibleEdges, edgesInitialized, edges: { setDefaultOptions }, elementsSelectable } = useStore();
  $$unsubscribe_visibleEdges = subscribe(visibleEdges, (value) => $visibleEdges = value);
  $$unsubscribe_edgesInitialized = subscribe(edgesInitialized, (value) => value);
  $$unsubscribe_elementsSelectable = subscribe(elementsSelectable, (value) => $elementsSelectable = value);
  if ($$props.defaultEdgeOptions === void 0 && $$bindings.defaultEdgeOptions && defaultEdgeOptions !== void 0) $$bindings.defaultEdgeOptions(defaultEdgeOptions);
  $$unsubscribe_visibleEdges();
  $$unsubscribe_elementsSelectable();
  $$unsubscribe_edgesInitialized();
  return `<div class="svelte-flow__edges"><svg class="svelte-flow__marker">${validate_component(MarkerDefinition, "MarkerDefinition").$$render($$result, {}, {}, {})}</svg> ${each($visibleEdges, (edge) => {
    return `${validate_component(EdgeWrapper, "EdgeWrapper").$$render(
      $$result,
      {
        id: edge.id,
        source: edge.source,
        target: edge.target,
        data: edge.data,
        style: edge.style,
        animated: edge.animated,
        selected: edge.selected,
        selectable: edge.selectable ?? $elementsSelectable,
        deletable: edge.deletable,
        hidden: edge.hidden,
        label: edge.label,
        labelStyle: edge.labelStyle,
        markerStart: edge.markerStart,
        markerEnd: edge.markerEnd,
        sourceHandle: edge.sourceHandle,
        targetHandle: edge.targetHandle,
        sourceX: edge.sourceX,
        sourceY: edge.sourceY,
        targetX: edge.targetX,
        targetY: edge.targetY,
        sourcePosition: edge.sourcePosition,
        targetPosition: edge.targetPosition,
        ariaLabel: edge.ariaLabel,
        interactionWidth: edge.interactionWidth,
        class: edge.class,
        type: edge.type || "default",
        zIndex: edge.zIndex
      },
      {},
      {}
    )}`;
  })} ${$visibleEdges.length > 0 ? `${validate_component(CallOnMount, "CallOnMount").$$render(
    $$result,
    {
      onMount: () => {
      },
      onDestroy: () => {
      }
    },
    {},
    {}
  )}` : ``}</div>`;
});
const css$3 = {
  code: ".svelte-flow__selection.svelte-1iugwpu{position:absolute;top:0;left:0}",
  map: '{"version":3,"file":"Selection.svelte","sources":["Selection.svelte"],"sourcesContent":["<script>export let x = 0;\\nexport let y = 0;\\nexport let width = 0;\\nexport let height = 0;\\nexport let isVisible = true;\\n<\/script>\\n\\n{#if isVisible}\\n  <div\\n    class=\\"svelte-flow__selection\\"\\n    style:width={typeof width === \'string\' ? width : `${width}px`}\\n    style:height={typeof height === \'string\' ? height : `${height}px`}\\n    style:transform={`translate(${x}px, ${y}px)`}\\n  />\\n{/if}\\n\\n<style>\\n  .svelte-flow__selection {\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n  }\\n</style>\\n"],"names":[],"mappings":"AAiBE,sCAAwB,CACtB,QAAQ,CAAE,QAAQ,CAClB,GAAG,CAAE,CAAC,CACN,IAAI,CAAE,CACR"}'
};
const Selection = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { x = 0 } = $$props;
  let { y = 0 } = $$props;
  let { width = 0 } = $$props;
  let { height = 0 } = $$props;
  let { isVisible = true } = $$props;
  if ($$props.x === void 0 && $$bindings.x && x !== void 0) $$bindings.x(x);
  if ($$props.y === void 0 && $$bindings.y && y !== void 0) $$bindings.y(y);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0) $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0) $$bindings.height(height);
  if ($$props.isVisible === void 0 && $$bindings.isVisible && isVisible !== void 0) $$bindings.isVisible(isVisible);
  $$result.css.add(css$3);
  return `${isVisible ? `<div class="svelte-flow__selection svelte-1iugwpu"${add_styles({
    "width": typeof width === "string" ? width : `${width}px`,
    "height": typeof height === "string" ? height : `${height}px`,
    "transform": `translate(${x}px, ${y}px)`
  })}></div>` : ``}`;
});
const UserSelection = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $selectionRect, $$unsubscribe_selectionRect;
  let $selectionRectMode, $$unsubscribe_selectionRectMode;
  const { selectionRect, selectionRectMode } = useStore();
  $$unsubscribe_selectionRect = subscribe(selectionRect, (value) => $selectionRect = value);
  $$unsubscribe_selectionRectMode = subscribe(selectionRectMode, (value) => $selectionRectMode = value);
  $$unsubscribe_selectionRect();
  $$unsubscribe_selectionRectMode();
  return `${validate_component(Selection, "Selection").$$render(
    $$result,
    {
      isVisible: !!($selectionRect && $selectionRectMode === "user"),
      width: $selectionRect?.width,
      height: $selectionRect?.height,
      x: $selectionRect?.x,
      y: $selectionRect?.y
    },
    {},
    {}
  )}`;
});
const css$2 = {
  code: ".selection-wrapper.svelte-5pxri{position:absolute;top:0;left:0;z-index:7;pointer-events:all}",
  map: `{"version":3,"file":"NodeSelection.svelte","sources":["NodeSelection.svelte"],"sourcesContent":["<script>import { createEventDispatcher } from 'svelte';\\nimport { getInternalNodesBounds, isNumeric } from '@xyflow/system';\\nimport { useStore } from '../../store';\\nimport { Selection } from '../Selection';\\nimport drag from '../../actions/drag';\\nconst store = useStore();\\nconst { selectionRectMode, nodes, nodeLookup } = store;\\nconst dispatch = createEventDispatcher();\\nlet bounds = null;\\n$: if ($selectionRectMode === 'nodes') {\\n    bounds = getInternalNodesBounds($nodeLookup, { filter: (node) => !!node.selected });\\n    $nodes;\\n}\\nfunction onContextMenu(event) {\\n    const selectedNodes = $nodes.filter((n) => n.selected);\\n    dispatch('selectioncontextmenu', { nodes: selectedNodes, event });\\n}\\nfunction onClick(event) {\\n    const selectedNodes = $nodes.filter((n) => n.selected);\\n    dispatch('selectionclick', { nodes: selectedNodes, event });\\n}\\n<\/script>\\n\\n{#if $selectionRectMode === 'nodes' && bounds && isNumeric(bounds.x) && isNumeric(bounds.y)}\\n  <div\\n    class=\\"selection-wrapper nopan\\"\\n    style=\\"width: {bounds.width}px; height: {bounds.height}px; transform: translate({bounds.x}px, {bounds.y}px)\\"\\n    use:drag={{\\n      disabled: false,\\n      store,\\n      onDrag: (event, _, __, nodes) => {\\n        dispatch('nodedrag', { event, targetNode: null, nodes });\\n      },\\n      onDragStart: (event, _, __, nodes) => {\\n        dispatch('nodedragstart', { event, targetNode: null, nodes });\\n      },\\n      onDragStop: (event, _, __, nodes) => {\\n        dispatch('nodedragstop', { event, targetNode: null, nodes });\\n      }\\n    }}\\n    on:contextmenu={onContextMenu}\\n    on:click={onClick}\\n    role=\\"button\\"\\n    tabindex=\\"-1\\"\\n    on:keyup={() => {}}\\n  >\\n    <Selection width=\\"100%\\" height=\\"100%\\" x={0} y={0} />\\n  </div>\\n{/if}\\n\\n<style>\\n  .selection-wrapper {\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    z-index: 7;\\n    pointer-events: all;\\n  }\\n</style>\\n"],"names":[],"mappings":"AAmDE,+BAAmB,CACjB,QAAQ,CAAE,QAAQ,CAClB,GAAG,CAAE,CAAC,CACN,IAAI,CAAE,CAAC,CACP,OAAO,CAAE,CAAC,CACV,cAAc,CAAE,GAClB"}`
};
const NodeSelection = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_nodes;
  let $nodeLookup, $$unsubscribe_nodeLookup;
  let $selectionRectMode, $$unsubscribe_selectionRectMode;
  const store = useStore();
  const { selectionRectMode, nodes, nodeLookup } = store;
  $$unsubscribe_selectionRectMode = subscribe(selectionRectMode, (value) => $selectionRectMode = value);
  $$unsubscribe_nodes = subscribe(nodes, (value) => value);
  $$unsubscribe_nodeLookup = subscribe(nodeLookup, (value) => $nodeLookup = value);
  createEventDispatcher();
  let bounds = null;
  $$result.css.add(css$2);
  {
    if ($selectionRectMode === "nodes") {
      bounds = getInternalNodesBounds($nodeLookup, { filter: (node) => !!node.selected });
    }
  }
  $$unsubscribe_nodes();
  $$unsubscribe_nodeLookup();
  $$unsubscribe_selectionRectMode();
  return `${$selectionRectMode === "nodes" && bounds && isNumeric(bounds.x) && isNumeric(bounds.y) ? `<div class="selection-wrapper nopan svelte-5pxri" style="${"width: " + escape(bounds.width, true) + "px; height: " + escape(bounds.height, true) + "px; transform: translate(" + escape(bounds.x, true) + "px, " + escape(bounds.y, true) + "px)"}" role="button" tabindex="-1">${validate_component(Selection, "Selection").$$render(
    $$result,
    {
      width: "100%",
      height: "100%",
      x: 0,
      y: 0
    },
    {},
    {}
  )}</div>` : ``}`;
});
const KeyHandler = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { selectionKey = "Shift" } = $$props;
  let { multiSelectionKey = isMacOs() ? "Meta" : "Control" } = $$props;
  let { deleteKey = "Backspace" } = $$props;
  let { panActivationKey = " " } = $$props;
  let { zoomActivationKey = isMacOs() ? "Meta" : "Control" } = $$props;
  useStore();
  if ($$props.selectionKey === void 0 && $$bindings.selectionKey && selectionKey !== void 0) $$bindings.selectionKey(selectionKey);
  if ($$props.multiSelectionKey === void 0 && $$bindings.multiSelectionKey && multiSelectionKey !== void 0) $$bindings.multiSelectionKey(multiSelectionKey);
  if ($$props.deleteKey === void 0 && $$bindings.deleteKey && deleteKey !== void 0) $$bindings.deleteKey(deleteKey);
  if ($$props.panActivationKey === void 0 && $$bindings.panActivationKey && panActivationKey !== void 0) $$bindings.panActivationKey(panActivationKey);
  if ($$props.zoomActivationKey === void 0 && $$bindings.zoomActivationKey && zoomActivationKey !== void 0) $$bindings.zoomActivationKey(zoomActivationKey);
  return ``;
});
const ConnectionLine = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $connectionLineType, $$unsubscribe_connectionLineType;
  let $connection, $$unsubscribe_connection;
  let $width, $$unsubscribe_width;
  let $height, $$unsubscribe_height;
  let { containerStyle = "" } = $$props;
  let { style = "" } = $$props;
  let { isCustomComponent = false } = $$props;
  const { width, height, connection, connectionLineType } = useStore();
  $$unsubscribe_width = subscribe(width, (value) => $width = value);
  $$unsubscribe_height = subscribe(height, (value) => $height = value);
  $$unsubscribe_connection = subscribe(connection, (value) => $connection = value);
  $$unsubscribe_connectionLineType = subscribe(connectionLineType, (value) => $connectionLineType = value);
  let path = null;
  if ($$props.containerStyle === void 0 && $$bindings.containerStyle && containerStyle !== void 0) $$bindings.containerStyle(containerStyle);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.isCustomComponent === void 0 && $$bindings.isCustomComponent && isCustomComponent !== void 0) $$bindings.isCustomComponent(isCustomComponent);
  {
    if ($connection.inProgress && !isCustomComponent) {
      const { from, to, fromPosition, toPosition } = $connection;
      const pathParams = {
        sourceX: from.x,
        sourceY: from.y,
        sourcePosition: fromPosition,
        targetX: to.x,
        targetY: to.y,
        targetPosition: toPosition
      };
      switch ($connectionLineType) {
        case ConnectionLineType.Bezier:
          [path] = getBezierPath(pathParams);
          break;
        case ConnectionLineType.Step:
          [path] = getSmoothStepPath({ ...pathParams, borderRadius: 0 });
          break;
        case ConnectionLineType.SmoothStep:
          [path] = getSmoothStepPath(pathParams);
          break;
        default:
          [path] = getStraightPath(pathParams);
      }
    }
  }
  $$unsubscribe_connectionLineType();
  $$unsubscribe_connection();
  $$unsubscribe_width();
  $$unsubscribe_height();
  return `${$connection.inProgress ? `<svg${add_attribute("width", $width, 0)}${add_attribute("height", $height, 0)} class="svelte-flow__connectionline"${add_attribute("style", containerStyle, 0)}><g${add_attribute("class", cc(["svelte-flow__connection", getConnectionStatus($connection.isValid)]), 0)}>${slots.connectionLine ? slots.connectionLine({}) : ``}${!isCustomComponent ? `<path${add_attribute("d", path, 0)}${add_attribute("style", style, 0)} fill="none" class="svelte-flow__connection-path"></path>` : ``}</g></svg>` : ``}`;
});
const Panel = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let positionClasses;
  let $$restProps = compute_rest_props($$props, ["position", "style", "class"]);
  let $selectionRectMode, $$unsubscribe_selectionRectMode;
  let { position = "top-right" } = $$props;
  let { style = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  const { selectionRectMode } = useStore();
  $$unsubscribe_selectionRectMode = subscribe(selectionRectMode, (value) => $selectionRectMode = value);
  if ($$props.position === void 0 && $$bindings.position && position !== void 0) $$bindings.position(position);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  positionClasses = `${position}`.split("-");
  $$unsubscribe_selectionRectMode();
  return `<div${spread(
    [
      {
        class: escape_attribute_value(cc(["svelte-flow__panel", className, ...positionClasses]))
      },
      { style: escape_attribute_value(style) },
      escape_object($$restProps)
    ],
    {
      styles: {
        "pointer-events": $selectionRectMode ? "none" : ""
      }
    }
  )}>${slots.default ? slots.default({}) : ``}</div>`;
});
const Attribution = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { proOptions = void 0 } = $$props;
  let { position = "bottom-right" } = $$props;
  if ($$props.proOptions === void 0 && $$bindings.proOptions && proOptions !== void 0) $$bindings.proOptions(proOptions);
  if ($$props.position === void 0 && $$bindings.position && position !== void 0) $$bindings.position(position);
  return `${!proOptions?.hideAttribution ? `${validate_component(Panel, "Panel").$$render(
    $$result,
    {
      position,
      class: "svelte-flow__attribution",
      "data-message": "Feel free to remove the attribution or check out how you could support us: https://svelteflow.dev/support-us"
    },
    {},
    {
      default: () => {
        return `<a href="https://svelteflow.dev" target="_blank" rel="noopener noreferrer" aria-label="Svelte Flow attribution" data-svelte-h="svelte-2vm8e4">Svelte Flow</a>`;
      }
    }
  )}` : ``}`;
});
function updateStore(store, { nodeTypes, edgeTypes, minZoom, maxZoom, translateExtent, paneClickDistance }) {
  if (nodeTypes !== void 0) {
    store.setNodeTypes(nodeTypes);
  }
  if (edgeTypes !== void 0) {
    store.setEdgeTypes(edgeTypes);
  }
  if (minZoom !== void 0) {
    store.setMinZoom(minZoom);
  }
  if (maxZoom !== void 0) {
    store.setMaxZoom(maxZoom);
  }
  if (translateExtent !== void 0) {
    store.setTranslateExtent(translateExtent);
  }
  if (paneClickDistance !== void 0) {
    store.setPaneClickDistance(paneClickDistance);
  }
}
const getKeys = (obj) => Object.keys(obj);
function updateStoreByKeys(store, keys) {
  getKeys(keys).forEach((prop) => {
    const update = keys[prop];
    if (update !== void 0) {
      store[prop].set(update);
    }
  });
}
function getMediaQuery() {
  if (typeof window === "undefined" || !window.matchMedia) {
    return null;
  }
  return window.matchMedia("(prefers-color-scheme: dark)");
}
function useColorModeClass(colorMode = "light") {
  const colorModeClass = readable("light", (set) => {
    if (colorMode !== "system") {
      set(colorMode);
      return;
    }
    const mediaQuery = getMediaQuery();
    const updateColorModeClass = () => set(mediaQuery?.matches ? "dark" : "light");
    set(mediaQuery?.matches ? "dark" : "light");
    mediaQuery?.addEventListener("change", updateColorModeClass);
    return () => {
      mediaQuery?.removeEventListener("change", updateColorModeClass);
    };
  });
  return colorModeClass;
}
const css$1 = {
  code: ".svelte-flow.svelte-12wlba6{width:100%;height:100%;overflow:hidden;position:relative;z-index:0;background-color:var(--background-color, var(--background-color-default))}:root{--background-color-default:#fff;--background-pattern-color-default:#ddd;--minimap-mask-color-default:rgb(240, 240, 240, 0.6);--minimap-mask-stroke-color-default:none;--minimap-mask-stroke-width-default:1;--controls-button-background-color-default:#fefefe;--controls-button-background-color-hover-default:#f4f4f4;--controls-button-color-default:inherit;--controls-button-color-hover-default:inherit;--controls-button-border-color-default:#eee}",
  map: `{"version":3,"file":"SvelteFlow.svelte","sources":["SvelteFlow.svelte"],"sourcesContent":["<script>import { onMount, hasContext } from 'svelte';\\nimport { get } from 'svelte/store';\\nimport cc from 'classcat';\\nimport { ConnectionMode, PanOnScrollMode } from '@xyflow/system';\\nimport { Zoom } from '../Zoom';\\nimport { Pane } from '../Pane';\\nimport { Viewport as ViewportComponent } from '../Viewport';\\nimport { NodeRenderer } from '../NodeRenderer';\\nimport { EdgeRenderer } from '../EdgeRenderer';\\nimport { UserSelection } from '../../components/UserSelection';\\nimport { NodeSelection } from '../../components/NodeSelection';\\nimport { KeyHandler } from '../../components/KeyHandler';\\nimport { ConnectionLine } from '../../components/ConnectionLine';\\nimport { Attribution } from '../../components/Attribution';\\nimport { key, useStore, createStoreContext } from '../../store';\\nimport { updateStore, updateStoreByKeys } from './utils';\\nimport { useColorModeClass } from '../../hooks/useColorModeClass';\\nexport let id = '1';\\nexport let nodes;\\nexport let edges;\\nexport let fitView = undefined;\\nexport let fitViewOptions = undefined;\\nexport let minZoom = undefined;\\nexport let maxZoom = undefined;\\nexport let initialViewport = undefined;\\nexport let viewport = undefined;\\nexport let nodeTypes = undefined;\\nexport let edgeTypes = undefined;\\nexport let selectionKey = undefined;\\nexport let selectionMode = undefined;\\nexport let panActivationKey = undefined;\\nexport let multiSelectionKey = undefined;\\nexport let zoomActivationKey = undefined;\\nexport let nodesDraggable = undefined;\\nexport let nodesConnectable = undefined;\\nexport let nodeDragThreshold = undefined;\\nexport let elementsSelectable = undefined;\\nexport let snapGrid = undefined;\\nexport let deleteKey = undefined;\\nexport let connectionRadius = undefined;\\nexport let connectionLineType = undefined;\\nexport let connectionMode = ConnectionMode.Strict;\\nexport let connectionLineStyle = '';\\nexport let connectionLineContainerStyle = '';\\nexport let onMoveStart = undefined;\\nexport let onMove = undefined;\\nexport let onMoveEnd = undefined;\\nexport let isValidConnection = undefined;\\nexport let translateExtent = undefined;\\nexport let nodeExtent = undefined;\\nexport let onlyRenderVisibleElements = undefined;\\nexport let panOnScrollMode = PanOnScrollMode.Free;\\nexport let preventScrolling = true;\\nexport let zoomOnScroll = true;\\nexport let zoomOnDoubleClick = true;\\nexport let zoomOnPinch = true;\\nexport let panOnScroll = false;\\nexport let panOnDrag = true;\\nexport let selectionOnDrag = undefined;\\nexport let autoPanOnConnect = true;\\nexport let autoPanOnNodeDrag = true;\\nexport let onerror = undefined;\\nexport let ondelete = undefined;\\nexport let onedgecreate = undefined;\\nexport let attributionPosition = undefined;\\nexport let proOptions = undefined;\\nexport let defaultEdgeOptions = undefined;\\nexport let width = undefined;\\nexport let height = undefined;\\nexport let colorMode = 'light';\\nexport let onconnect = undefined;\\nexport let onconnectstart = undefined;\\nexport let onconnectend = undefined;\\nexport let onbeforedelete = undefined;\\nexport let oninit = undefined;\\nexport let nodeOrigin = undefined;\\nexport let paneClickDistance = 0;\\nexport let nodeClickDistance = 0;\\nexport let defaultMarkerColor = '#b1b1b7';\\nexport let style = undefined;\\nlet className = undefined;\\nexport { className as class };\\nlet domNode;\\nlet clientWidth;\\nlet clientHeight;\\nconst initViewport = $viewport || initialViewport;\\nconst store = hasContext(key)\\n    ? useStore()\\n    : createStoreContext({\\n        nodes: get(nodes),\\n        edges: get(edges),\\n        width,\\n        height,\\n        fitView,\\n        nodeOrigin,\\n        nodeExtent\\n    });\\nonMount(() => {\\n    store.width.set(clientWidth);\\n    store.height.set(clientHeight);\\n    store.domNode.set(domNode);\\n    store.syncNodeStores(nodes);\\n    store.syncEdgeStores(edges);\\n    store.syncViewport(viewport);\\n    if (fitView !== undefined) {\\n        store.fitViewOnInit.set(fitView);\\n    }\\n    if (fitViewOptions) {\\n        store.fitViewOptions.set(fitViewOptions);\\n    }\\n    updateStore(store, {\\n        nodeTypes,\\n        edgeTypes,\\n        minZoom,\\n        maxZoom,\\n        translateExtent,\\n        paneClickDistance\\n    });\\n    return () => {\\n        store.reset();\\n    };\\n});\\n// Update width & height on resize\\n$: {\\n    if (clientWidth !== undefined && clientHeight !== undefined) {\\n        store.width.set(clientWidth);\\n        store.height.set(clientHeight);\\n    }\\n}\\n// Call oninit once when flow is intialized\\nconst { initialized } = store;\\nlet onInitCalled = false;\\n$: {\\n    if (!onInitCalled && $initialized) {\\n        oninit?.();\\n        onInitCalled = true;\\n    }\\n}\\n// this updates the store for simple changes\\n// where the prop names equals the store name\\n$: {\\n    const updatableProps = {\\n        flowId: id,\\n        connectionLineType,\\n        connectionRadius,\\n        selectionMode,\\n        snapGrid,\\n        defaultMarkerColor,\\n        nodesDraggable,\\n        nodesConnectable,\\n        elementsSelectable,\\n        onlyRenderVisibleElements,\\n        isValidConnection,\\n        autoPanOnConnect,\\n        autoPanOnNodeDrag,\\n        onerror,\\n        ondelete,\\n        onedgecreate,\\n        connectionMode,\\n        nodeDragThreshold,\\n        onconnect,\\n        onconnectstart,\\n        onconnectend,\\n        onbeforedelete,\\n        nodeOrigin\\n    };\\n    updateStoreByKeys(store, updatableProps);\\n}\\n$: updateStore(store, {\\n    nodeTypes,\\n    edgeTypes,\\n    minZoom,\\n    maxZoom,\\n    translateExtent,\\n    paneClickDistance\\n});\\n$: colorModeClass = useColorModeClass(colorMode);\\n<\/script>\\n\\n<div\\n  bind:this={domNode}\\n  bind:clientWidth\\n  bind:clientHeight\\n  {style}\\n  class={cc(['svelte-flow', className, $colorModeClass])}\\n  data-testid=\\"svelte-flow__wrapper\\"\\n  on:dragover\\n  on:drop\\n  {...$$restProps}\\n  role=\\"application\\"\\n>\\n  <KeyHandler\\n    {selectionKey}\\n    {deleteKey}\\n    {panActivationKey}\\n    {multiSelectionKey}\\n    {zoomActivationKey}\\n  />\\n  <Zoom\\n    initialViewport={initViewport}\\n    {onMoveStart}\\n    {onMove}\\n    {onMoveEnd}\\n    panOnScrollMode={panOnScrollMode === undefined ? PanOnScrollMode.Free : panOnScrollMode}\\n    preventScrolling={preventScrolling === undefined ? true : preventScrolling}\\n    zoomOnScroll={zoomOnScroll === undefined ? true : zoomOnScroll}\\n    zoomOnDoubleClick={zoomOnDoubleClick === undefined ? true : zoomOnDoubleClick}\\n    zoomOnPinch={zoomOnPinch === undefined ? true : zoomOnPinch}\\n    panOnScroll={panOnScroll === undefined ? false : panOnScroll}\\n    panOnDrag={panOnDrag === undefined ? true : panOnDrag}\\n    paneClickDistance={paneClickDistance === undefined ? 0 : paneClickDistance}\\n  >\\n    <Pane\\n      on:paneclick\\n      on:panecontextmenu\\n      panOnDrag={panOnDrag === undefined ? true : panOnDrag}\\n      {selectionOnDrag}\\n    >\\n      <ViewportComponent>\\n        <EdgeRenderer\\n          on:edgeclick\\n          on:edgecontextmenu\\n          on:edgemouseenter\\n          on:edgemouseleave\\n          {defaultEdgeOptions}\\n        />\\n        <ConnectionLine\\n          containerStyle={connectionLineContainerStyle}\\n          style={connectionLineStyle}\\n          isCustomComponent={$$slots.connectionLine}\\n        >\\n          <slot name=\\"connectionLine\\" slot=\\"connectionLine\\" />\\n        </ConnectionLine>\\n        <div class=\\"svelte-flow__edgelabel-renderer\\" />\\n        <div class=\\"svelte-flow__viewport-portal\\" />\\n        <NodeRenderer\\n          {nodeClickDistance}\\n          on:nodeclick\\n          on:nodemouseenter\\n          on:nodemousemove\\n          on:nodemouseleave\\n          on:nodedragstart\\n          on:nodedrag\\n          on:nodedragstop\\n          on:nodecontextmenu\\n        />\\n        <NodeSelection\\n          on:selectionclick\\n          on:selectioncontextmenu\\n          on:nodedragstart\\n          on:nodedrag\\n          on:nodedragstop\\n        />\\n      </ViewportComponent>\\n      <UserSelection />\\n    </Pane>\\n  </Zoom>\\n  <Attribution {proOptions} position={attributionPosition} />\\n  <slot />\\n</div>\\n\\n<style>\\n  .svelte-flow {\\n    width: 100%;\\n    height: 100%;\\n    overflow: hidden;\\n    position: relative;\\n    z-index: 0;\\n\\n    background-color: var(--background-color, var(--background-color-default));\\n  }\\n\\n  :root {\\n    --background-color-default: #fff;\\n    --background-pattern-color-default: #ddd;\\n\\n    --minimap-mask-color-default: rgb(240, 240, 240, 0.6);\\n    --minimap-mask-stroke-color-default: none;\\n    --minimap-mask-stroke-width-default: 1;\\n\\n    --controls-button-background-color-default: #fefefe;\\n    --controls-button-background-color-hover-default: #f4f4f4;\\n    --controls-button-color-default: inherit;\\n    --controls-button-color-hover-default: inherit;\\n    --controls-button-border-color-default: #eee;\\n  }\\n</style>\\n"],"names":[],"mappings":"AAsQE,2BAAa,CACX,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IAAI,CACZ,QAAQ,CAAE,MAAM,CAChB,QAAQ,CAAE,QAAQ,CAClB,OAAO,CAAE,CAAC,CAEV,gBAAgB,CAAE,IAAI,kBAAkB,CAAC,gCAAgC,CAC3E,CAEA,KAAM,CACJ,0BAA0B,CAAE,IAAI,CAChC,kCAAkC,CAAE,IAAI,CAExC,4BAA4B,CAAE,uBAAuB,CACrD,mCAAmC,CAAE,IAAI,CACzC,mCAAmC,CAAE,CAAC,CAEtC,0CAA0C,CAAE,OAAO,CACnD,gDAAgD,CAAE,OAAO,CACzD,+BAA+B,CAAE,OAAO,CACxC,qCAAqC,CAAE,OAAO,CAC9C,sCAAsC,CAAE,IAC1C"}`
};
const SvelteFlow = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let colorModeClass;
  let $$restProps = compute_rest_props($$props, [
    "id",
    "nodes",
    "edges",
    "fitView",
    "fitViewOptions",
    "minZoom",
    "maxZoom",
    "initialViewport",
    "viewport",
    "nodeTypes",
    "edgeTypes",
    "selectionKey",
    "selectionMode",
    "panActivationKey",
    "multiSelectionKey",
    "zoomActivationKey",
    "nodesDraggable",
    "nodesConnectable",
    "nodeDragThreshold",
    "elementsSelectable",
    "snapGrid",
    "deleteKey",
    "connectionRadius",
    "connectionLineType",
    "connectionMode",
    "connectionLineStyle",
    "connectionLineContainerStyle",
    "onMoveStart",
    "onMove",
    "onMoveEnd",
    "isValidConnection",
    "translateExtent",
    "nodeExtent",
    "onlyRenderVisibleElements",
    "panOnScrollMode",
    "preventScrolling",
    "zoomOnScroll",
    "zoomOnDoubleClick",
    "zoomOnPinch",
    "panOnScroll",
    "panOnDrag",
    "selectionOnDrag",
    "autoPanOnConnect",
    "autoPanOnNodeDrag",
    "onerror",
    "ondelete",
    "onedgecreate",
    "attributionPosition",
    "proOptions",
    "defaultEdgeOptions",
    "width",
    "height",
    "colorMode",
    "onconnect",
    "onconnectstart",
    "onconnectend",
    "onbeforedelete",
    "oninit",
    "nodeOrigin",
    "paneClickDistance",
    "nodeClickDistance",
    "defaultMarkerColor",
    "style",
    "class"
  ]);
  let $$slots = compute_slots(slots);
  let $initialized, $$unsubscribe_initialized;
  let $viewport, $$unsubscribe_viewport;
  let $colorModeClass, $$unsubscribe_colorModeClass = noop, $$subscribe_colorModeClass = () => ($$unsubscribe_colorModeClass(), $$unsubscribe_colorModeClass = subscribe(colorModeClass, ($$value) => $colorModeClass = $$value), colorModeClass);
  let { id = "1" } = $$props;
  let { nodes } = $$props;
  let { edges } = $$props;
  let { fitView: fitView2 = void 0 } = $$props;
  let { fitViewOptions = void 0 } = $$props;
  let { minZoom = void 0 } = $$props;
  let { maxZoom = void 0 } = $$props;
  let { initialViewport = void 0 } = $$props;
  let { viewport = void 0 } = $$props;
  $$unsubscribe_viewport = subscribe(viewport, (value) => $viewport = value);
  let { nodeTypes = void 0 } = $$props;
  let { edgeTypes = void 0 } = $$props;
  let { selectionKey = void 0 } = $$props;
  let { selectionMode = void 0 } = $$props;
  let { panActivationKey = void 0 } = $$props;
  let { multiSelectionKey = void 0 } = $$props;
  let { zoomActivationKey = void 0 } = $$props;
  let { nodesDraggable = void 0 } = $$props;
  let { nodesConnectable = void 0 } = $$props;
  let { nodeDragThreshold = void 0 } = $$props;
  let { elementsSelectable = void 0 } = $$props;
  let { snapGrid = void 0 } = $$props;
  let { deleteKey = void 0 } = $$props;
  let { connectionRadius = void 0 } = $$props;
  let { connectionLineType = void 0 } = $$props;
  let { connectionMode = ConnectionMode.Strict } = $$props;
  let { connectionLineStyle = "" } = $$props;
  let { connectionLineContainerStyle = "" } = $$props;
  let { onMoveStart = void 0 } = $$props;
  let { onMove = void 0 } = $$props;
  let { onMoveEnd = void 0 } = $$props;
  let { isValidConnection = void 0 } = $$props;
  let { translateExtent = void 0 } = $$props;
  let { nodeExtent = void 0 } = $$props;
  let { onlyRenderVisibleElements = void 0 } = $$props;
  let { panOnScrollMode = PanOnScrollMode.Free } = $$props;
  let { preventScrolling = true } = $$props;
  let { zoomOnScroll = true } = $$props;
  let { zoomOnDoubleClick = true } = $$props;
  let { zoomOnPinch = true } = $$props;
  let { panOnScroll = false } = $$props;
  let { panOnDrag = true } = $$props;
  let { selectionOnDrag = void 0 } = $$props;
  let { autoPanOnConnect = true } = $$props;
  let { autoPanOnNodeDrag = true } = $$props;
  let { onerror = void 0 } = $$props;
  let { ondelete = void 0 } = $$props;
  let { onedgecreate = void 0 } = $$props;
  let { attributionPosition = void 0 } = $$props;
  let { proOptions = void 0 } = $$props;
  let { defaultEdgeOptions = void 0 } = $$props;
  let { width = void 0 } = $$props;
  let { height = void 0 } = $$props;
  let { colorMode = "light" } = $$props;
  let { onconnect = void 0 } = $$props;
  let { onconnectstart = void 0 } = $$props;
  let { onconnectend = void 0 } = $$props;
  let { onbeforedelete = void 0 } = $$props;
  let { oninit = void 0 } = $$props;
  let { nodeOrigin = void 0 } = $$props;
  let { paneClickDistance = 0 } = $$props;
  let { nodeClickDistance = 0 } = $$props;
  let { defaultMarkerColor = "#b1b1b7" } = $$props;
  let { style = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  let domNode;
  const initViewport = $viewport || initialViewport;
  const store = hasContext(key) ? useStore() : createStoreContext({
    nodes: get_store_value(nodes),
    edges: get_store_value(edges),
    width,
    height,
    fitView: fitView2,
    nodeOrigin,
    nodeExtent
  });
  const { initialized } = store;
  $$unsubscribe_initialized = subscribe(initialized, (value) => $initialized = value);
  let onInitCalled = false;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.nodes === void 0 && $$bindings.nodes && nodes !== void 0) $$bindings.nodes(nodes);
  if ($$props.edges === void 0 && $$bindings.edges && edges !== void 0) $$bindings.edges(edges);
  if ($$props.fitView === void 0 && $$bindings.fitView && fitView2 !== void 0) $$bindings.fitView(fitView2);
  if ($$props.fitViewOptions === void 0 && $$bindings.fitViewOptions && fitViewOptions !== void 0) $$bindings.fitViewOptions(fitViewOptions);
  if ($$props.minZoom === void 0 && $$bindings.minZoom && minZoom !== void 0) $$bindings.minZoom(minZoom);
  if ($$props.maxZoom === void 0 && $$bindings.maxZoom && maxZoom !== void 0) $$bindings.maxZoom(maxZoom);
  if ($$props.initialViewport === void 0 && $$bindings.initialViewport && initialViewport !== void 0) $$bindings.initialViewport(initialViewport);
  if ($$props.viewport === void 0 && $$bindings.viewport && viewport !== void 0) $$bindings.viewport(viewport);
  if ($$props.nodeTypes === void 0 && $$bindings.nodeTypes && nodeTypes !== void 0) $$bindings.nodeTypes(nodeTypes);
  if ($$props.edgeTypes === void 0 && $$bindings.edgeTypes && edgeTypes !== void 0) $$bindings.edgeTypes(edgeTypes);
  if ($$props.selectionKey === void 0 && $$bindings.selectionKey && selectionKey !== void 0) $$bindings.selectionKey(selectionKey);
  if ($$props.selectionMode === void 0 && $$bindings.selectionMode && selectionMode !== void 0) $$bindings.selectionMode(selectionMode);
  if ($$props.panActivationKey === void 0 && $$bindings.panActivationKey && panActivationKey !== void 0) $$bindings.panActivationKey(panActivationKey);
  if ($$props.multiSelectionKey === void 0 && $$bindings.multiSelectionKey && multiSelectionKey !== void 0) $$bindings.multiSelectionKey(multiSelectionKey);
  if ($$props.zoomActivationKey === void 0 && $$bindings.zoomActivationKey && zoomActivationKey !== void 0) $$bindings.zoomActivationKey(zoomActivationKey);
  if ($$props.nodesDraggable === void 0 && $$bindings.nodesDraggable && nodesDraggable !== void 0) $$bindings.nodesDraggable(nodesDraggable);
  if ($$props.nodesConnectable === void 0 && $$bindings.nodesConnectable && nodesConnectable !== void 0) $$bindings.nodesConnectable(nodesConnectable);
  if ($$props.nodeDragThreshold === void 0 && $$bindings.nodeDragThreshold && nodeDragThreshold !== void 0) $$bindings.nodeDragThreshold(nodeDragThreshold);
  if ($$props.elementsSelectable === void 0 && $$bindings.elementsSelectable && elementsSelectable !== void 0) $$bindings.elementsSelectable(elementsSelectable);
  if ($$props.snapGrid === void 0 && $$bindings.snapGrid && snapGrid !== void 0) $$bindings.snapGrid(snapGrid);
  if ($$props.deleteKey === void 0 && $$bindings.deleteKey && deleteKey !== void 0) $$bindings.deleteKey(deleteKey);
  if ($$props.connectionRadius === void 0 && $$bindings.connectionRadius && connectionRadius !== void 0) $$bindings.connectionRadius(connectionRadius);
  if ($$props.connectionLineType === void 0 && $$bindings.connectionLineType && connectionLineType !== void 0) $$bindings.connectionLineType(connectionLineType);
  if ($$props.connectionMode === void 0 && $$bindings.connectionMode && connectionMode !== void 0) $$bindings.connectionMode(connectionMode);
  if ($$props.connectionLineStyle === void 0 && $$bindings.connectionLineStyle && connectionLineStyle !== void 0) $$bindings.connectionLineStyle(connectionLineStyle);
  if ($$props.connectionLineContainerStyle === void 0 && $$bindings.connectionLineContainerStyle && connectionLineContainerStyle !== void 0) $$bindings.connectionLineContainerStyle(connectionLineContainerStyle);
  if ($$props.onMoveStart === void 0 && $$bindings.onMoveStart && onMoveStart !== void 0) $$bindings.onMoveStart(onMoveStart);
  if ($$props.onMove === void 0 && $$bindings.onMove && onMove !== void 0) $$bindings.onMove(onMove);
  if ($$props.onMoveEnd === void 0 && $$bindings.onMoveEnd && onMoveEnd !== void 0) $$bindings.onMoveEnd(onMoveEnd);
  if ($$props.isValidConnection === void 0 && $$bindings.isValidConnection && isValidConnection !== void 0) $$bindings.isValidConnection(isValidConnection);
  if ($$props.translateExtent === void 0 && $$bindings.translateExtent && translateExtent !== void 0) $$bindings.translateExtent(translateExtent);
  if ($$props.nodeExtent === void 0 && $$bindings.nodeExtent && nodeExtent !== void 0) $$bindings.nodeExtent(nodeExtent);
  if ($$props.onlyRenderVisibleElements === void 0 && $$bindings.onlyRenderVisibleElements && onlyRenderVisibleElements !== void 0) $$bindings.onlyRenderVisibleElements(onlyRenderVisibleElements);
  if ($$props.panOnScrollMode === void 0 && $$bindings.panOnScrollMode && panOnScrollMode !== void 0) $$bindings.panOnScrollMode(panOnScrollMode);
  if ($$props.preventScrolling === void 0 && $$bindings.preventScrolling && preventScrolling !== void 0) $$bindings.preventScrolling(preventScrolling);
  if ($$props.zoomOnScroll === void 0 && $$bindings.zoomOnScroll && zoomOnScroll !== void 0) $$bindings.zoomOnScroll(zoomOnScroll);
  if ($$props.zoomOnDoubleClick === void 0 && $$bindings.zoomOnDoubleClick && zoomOnDoubleClick !== void 0) $$bindings.zoomOnDoubleClick(zoomOnDoubleClick);
  if ($$props.zoomOnPinch === void 0 && $$bindings.zoomOnPinch && zoomOnPinch !== void 0) $$bindings.zoomOnPinch(zoomOnPinch);
  if ($$props.panOnScroll === void 0 && $$bindings.panOnScroll && panOnScroll !== void 0) $$bindings.panOnScroll(panOnScroll);
  if ($$props.panOnDrag === void 0 && $$bindings.panOnDrag && panOnDrag !== void 0) $$bindings.panOnDrag(panOnDrag);
  if ($$props.selectionOnDrag === void 0 && $$bindings.selectionOnDrag && selectionOnDrag !== void 0) $$bindings.selectionOnDrag(selectionOnDrag);
  if ($$props.autoPanOnConnect === void 0 && $$bindings.autoPanOnConnect && autoPanOnConnect !== void 0) $$bindings.autoPanOnConnect(autoPanOnConnect);
  if ($$props.autoPanOnNodeDrag === void 0 && $$bindings.autoPanOnNodeDrag && autoPanOnNodeDrag !== void 0) $$bindings.autoPanOnNodeDrag(autoPanOnNodeDrag);
  if ($$props.onerror === void 0 && $$bindings.onerror && onerror !== void 0) $$bindings.onerror(onerror);
  if ($$props.ondelete === void 0 && $$bindings.ondelete && ondelete !== void 0) $$bindings.ondelete(ondelete);
  if ($$props.onedgecreate === void 0 && $$bindings.onedgecreate && onedgecreate !== void 0) $$bindings.onedgecreate(onedgecreate);
  if ($$props.attributionPosition === void 0 && $$bindings.attributionPosition && attributionPosition !== void 0) $$bindings.attributionPosition(attributionPosition);
  if ($$props.proOptions === void 0 && $$bindings.proOptions && proOptions !== void 0) $$bindings.proOptions(proOptions);
  if ($$props.defaultEdgeOptions === void 0 && $$bindings.defaultEdgeOptions && defaultEdgeOptions !== void 0) $$bindings.defaultEdgeOptions(defaultEdgeOptions);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0) $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0) $$bindings.height(height);
  if ($$props.colorMode === void 0 && $$bindings.colorMode && colorMode !== void 0) $$bindings.colorMode(colorMode);
  if ($$props.onconnect === void 0 && $$bindings.onconnect && onconnect !== void 0) $$bindings.onconnect(onconnect);
  if ($$props.onconnectstart === void 0 && $$bindings.onconnectstart && onconnectstart !== void 0) $$bindings.onconnectstart(onconnectstart);
  if ($$props.onconnectend === void 0 && $$bindings.onconnectend && onconnectend !== void 0) $$bindings.onconnectend(onconnectend);
  if ($$props.onbeforedelete === void 0 && $$bindings.onbeforedelete && onbeforedelete !== void 0) $$bindings.onbeforedelete(onbeforedelete);
  if ($$props.oninit === void 0 && $$bindings.oninit && oninit !== void 0) $$bindings.oninit(oninit);
  if ($$props.nodeOrigin === void 0 && $$bindings.nodeOrigin && nodeOrigin !== void 0) $$bindings.nodeOrigin(nodeOrigin);
  if ($$props.paneClickDistance === void 0 && $$bindings.paneClickDistance && paneClickDistance !== void 0) $$bindings.paneClickDistance(paneClickDistance);
  if ($$props.nodeClickDistance === void 0 && $$bindings.nodeClickDistance && nodeClickDistance !== void 0) $$bindings.nodeClickDistance(nodeClickDistance);
  if ($$props.defaultMarkerColor === void 0 && $$bindings.defaultMarkerColor && defaultMarkerColor !== void 0) $$bindings.defaultMarkerColor(defaultMarkerColor);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  $$result.css.add(css$1);
  {
    {
      if (!onInitCalled && $initialized) {
        oninit?.();
        onInitCalled = true;
      }
    }
  }
  {
    {
      const updatableProps = {
        flowId: id,
        connectionLineType,
        connectionRadius,
        selectionMode,
        snapGrid,
        defaultMarkerColor,
        nodesDraggable,
        nodesConnectable,
        elementsSelectable,
        onlyRenderVisibleElements,
        isValidConnection,
        autoPanOnConnect,
        autoPanOnNodeDrag,
        onerror,
        ondelete,
        onedgecreate,
        connectionMode,
        nodeDragThreshold,
        onconnect,
        onconnectstart,
        onconnectend,
        onbeforedelete,
        nodeOrigin
      };
      updateStoreByKeys(store, updatableProps);
    }
  }
  {
    updateStore(store, {
      nodeTypes,
      edgeTypes,
      minZoom,
      maxZoom,
      translateExtent,
      paneClickDistance
    });
  }
  $$subscribe_colorModeClass(colorModeClass = useColorModeClass(colorMode));
  $$unsubscribe_initialized();
  $$unsubscribe_viewport();
  $$unsubscribe_colorModeClass();
  return `<div${spread(
    [
      { style: escape_attribute_value(style) },
      {
        class: escape_attribute_value(cc(["svelte-flow", className, $colorModeClass]))
      },
      { "data-testid": "svelte-flow__wrapper" },
      escape_object($$restProps),
      { role: "application" }
    ],
    { classes: "svelte-12wlba6" }
  )}${add_attribute("this", domNode, 0)}>${validate_component(KeyHandler, "KeyHandler").$$render(
    $$result,
    {
      selectionKey,
      deleteKey,
      panActivationKey,
      multiSelectionKey,
      zoomActivationKey
    },
    {},
    {}
  )} ${validate_component(Zoom, "Zoom").$$render(
    $$result,
    {
      initialViewport: initViewport,
      onMoveStart,
      onMove,
      onMoveEnd,
      panOnScrollMode: panOnScrollMode === void 0 ? PanOnScrollMode.Free : panOnScrollMode,
      preventScrolling: preventScrolling === void 0 ? true : preventScrolling,
      zoomOnScroll: zoomOnScroll === void 0 ? true : zoomOnScroll,
      zoomOnDoubleClick: zoomOnDoubleClick === void 0 ? true : zoomOnDoubleClick,
      zoomOnPinch: zoomOnPinch === void 0 ? true : zoomOnPinch,
      panOnScroll: panOnScroll === void 0 ? false : panOnScroll,
      panOnDrag: panOnDrag === void 0 ? true : panOnDrag,
      paneClickDistance: paneClickDistance === void 0 ? 0 : paneClickDistance
    },
    {},
    {
      default: () => {
        return `${validate_component(Pane, "Pane").$$render(
          $$result,
          {
            panOnDrag: panOnDrag === void 0 ? true : panOnDrag,
            selectionOnDrag
          },
          {},
          {
            default: () => {
              return `${validate_component(Viewport, "ViewportComponent").$$render($$result, {}, {}, {
                default: () => {
                  return `${validate_component(EdgeRenderer, "EdgeRenderer").$$render($$result, { defaultEdgeOptions }, {}, {})} ${validate_component(ConnectionLine, "ConnectionLine").$$render(
                    $$result,
                    {
                      containerStyle: connectionLineContainerStyle,
                      style: connectionLineStyle,
                      isCustomComponent: $$slots.connectionLine
                    },
                    {},
                    {
                      connectionLine: () => {
                        return `${slots.connectionLine ? slots.connectionLine({ slot: "connectionLine" }) : ``}`;
                      }
                    }
                  )} <div class="svelte-flow__edgelabel-renderer"></div> <div class="svelte-flow__viewport-portal"></div> ${validate_component(NodeRenderer, "NodeRenderer").$$render($$result, { nodeClickDistance }, {}, {})} ${validate_component(NodeSelection, "NodeSelection").$$render($$result, {}, {}, {})}`;
                }
              })} ${validate_component(UserSelection, "UserSelection").$$render($$result, {}, {}, {})}`;
            }
          }
        )}`;
      }
    }
  )} ${validate_component(Attribution, "Attribution").$$render(
    $$result,
    {
      proOptions,
      position: attributionPosition
    },
    {},
    {}
  )} ${slots.default ? slots.default({}) : ``} </div>`;
});
const SvelteFlowProvider = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { initialNodes = void 0 } = $$props;
  let { initialEdges = void 0 } = $$props;
  let { initialWidth = void 0 } = $$props;
  let { initialHeight = void 0 } = $$props;
  let { fitView: fitView2 = void 0 } = $$props;
  let { nodeOrigin = void 0 } = $$props;
  const store = createStore({
    nodes: initialNodes,
    edges: initialEdges,
    width: initialWidth,
    height: initialHeight,
    nodeOrigin,
    fitView: fitView2
  });
  setContext(key, { getStore: () => store });
  onDestroy(() => {
    store.reset();
  });
  if ($$props.initialNodes === void 0 && $$bindings.initialNodes && initialNodes !== void 0) $$bindings.initialNodes(initialNodes);
  if ($$props.initialEdges === void 0 && $$bindings.initialEdges && initialEdges !== void 0) $$bindings.initialEdges(initialEdges);
  if ($$props.initialWidth === void 0 && $$bindings.initialWidth && initialWidth !== void 0) $$bindings.initialWidth(initialWidth);
  if ($$props.initialHeight === void 0 && $$bindings.initialHeight && initialHeight !== void 0) $$bindings.initialHeight(initialHeight);
  if ($$props.fitView === void 0 && $$bindings.fitView && fitView2 !== void 0) $$bindings.fitView(fitView2);
  if ($$props.nodeOrigin === void 0 && $$bindings.nodeOrigin && nodeOrigin !== void 0) $$bindings.nodeOrigin(nodeOrigin);
  return `${slots.default ? slots.default({}) : ``}`;
});
const ControlButton = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$restProps = compute_rest_props($$props, ["class"]);
  let { class: className = void 0 } = $$props;
  let bgColor = void 0;
  let bgColorHover = void 0;
  let color = void 0;
  let colorHover = void 0;
  let borderColor = void 0;
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  return `<button${spread(
    [
      { type: "button" },
      {
        class: escape_attribute_value(cc(["svelte-flow__controls-button", className]))
      },
      escape_object($$restProps)
    ],
    {
      styles: {
        "--xy-controls-button-background-color-props": bgColor,
        "--xy-controls-button-background-color-hover-props": bgColorHover,
        "--xy-controls-button-color-props": color,
        "--xy-controls-button-color-hover-props": colorHover,
        "--xy-controls-button-border-color-props": borderColor
      }
    }
  )}>${slots.default ? slots.default({ class: "button-svg" }) : ``}</button>`;
});
const Plus = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M32 18.133H18.133V32h-4.266V18.133H0v-4.266h13.867V0h4.266v13.867H32z"></path></svg>`;
});
const Minus = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 5"><path d="M0 0h32v4.2H0z"></path></svg>`;
});
const Fit = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 30"><path d="M3.692 4.63c0-.53.4-.938.939-.938h5.215V0H4.708C2.13 0 0 2.054 0 4.63v5.216h3.692V4.631zM27.354 0h-5.2v3.692h5.17c.53 0 .984.4.984.939v5.215H32V4.631A4.624 4.624 0 0027.354 0zm.954 24.83c0 .532-.4.94-.939.94h-5.215v3.768h5.215c2.577 0 4.631-2.13 4.631-4.707v-5.139h-3.692v5.139zm-23.677.94c-.531 0-.939-.4-.939-.94v-5.138H0v5.139c0 2.577 2.13 4.707 4.708 4.707h5.138V25.77H4.631z"></path></svg>`;
});
const Lock = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 32"><path d="M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0 8 0 4.571 3.429 4.571 7.619v3.048H3.048A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047zm4.724-13.866H7.467V7.619c0-2.59 2.133-4.724 4.723-4.724 2.591 0 4.724 2.133 4.724 4.724v3.048z"></path></svg>`;
});
const Unlock = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 32"><path d="M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0c-4.114 1.828-1.37 2.133.305 2.438 1.676.305 4.42 2.59 4.42 5.181v3.048H3.047A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047z"></path></svg>`;
});
const Controls = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let isInteractive;
  let minZoomReached;
  let maxZoomReached;
  let orientationClass;
  let $maxZoom, $$unsubscribe_maxZoom;
  let $viewport, $$unsubscribe_viewport;
  let $minZoom, $$unsubscribe_minZoom;
  let $elementsSelectable, $$unsubscribe_elementsSelectable;
  let $nodesConnectable, $$unsubscribe_nodesConnectable;
  let $nodesDraggable, $$unsubscribe_nodesDraggable;
  let { position = "bottom-left" } = $$props;
  let { showZoom = true } = $$props;
  let { showFitView = true } = $$props;
  let { showLock = true } = $$props;
  let { buttonBgColor = void 0 } = $$props;
  let { buttonBgColorHover = void 0 } = $$props;
  let { buttonColor = void 0 } = $$props;
  let { buttonColorHover = void 0 } = $$props;
  let { buttonBorderColor = void 0 } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { style = void 0 } = $$props;
  let { orientation = "vertical" } = $$props;
  let { fitViewOptions = void 0 } = $$props;
  let { class: className = "" } = $$props;
  const { zoomIn, zoomOut, fitView: fitView2, viewport, minZoom, maxZoom, nodesDraggable, nodesConnectable, elementsSelectable } = useStore();
  $$unsubscribe_viewport = subscribe(viewport, (value) => $viewport = value);
  $$unsubscribe_minZoom = subscribe(minZoom, (value) => $minZoom = value);
  $$unsubscribe_maxZoom = subscribe(maxZoom, (value) => $maxZoom = value);
  $$unsubscribe_nodesDraggable = subscribe(nodesDraggable, (value) => $nodesDraggable = value);
  $$unsubscribe_nodesConnectable = subscribe(nodesConnectable, (value) => $nodesConnectable = value);
  $$unsubscribe_elementsSelectable = subscribe(elementsSelectable, (value) => $elementsSelectable = value);
  const buttonProps = {
    bgColor: buttonBgColor,
    bgColorHover: buttonBgColorHover,
    color: buttonColor,
    colorHover: buttonColorHover,
    borderColor: buttonBorderColor
  };
  if ($$props.position === void 0 && $$bindings.position && position !== void 0) $$bindings.position(position);
  if ($$props.showZoom === void 0 && $$bindings.showZoom && showZoom !== void 0) $$bindings.showZoom(showZoom);
  if ($$props.showFitView === void 0 && $$bindings.showFitView && showFitView !== void 0) $$bindings.showFitView(showFitView);
  if ($$props.showLock === void 0 && $$bindings.showLock && showLock !== void 0) $$bindings.showLock(showLock);
  if ($$props.buttonBgColor === void 0 && $$bindings.buttonBgColor && buttonBgColor !== void 0) $$bindings.buttonBgColor(buttonBgColor);
  if ($$props.buttonBgColorHover === void 0 && $$bindings.buttonBgColorHover && buttonBgColorHover !== void 0) $$bindings.buttonBgColorHover(buttonBgColorHover);
  if ($$props.buttonColor === void 0 && $$bindings.buttonColor && buttonColor !== void 0) $$bindings.buttonColor(buttonColor);
  if ($$props.buttonColorHover === void 0 && $$bindings.buttonColorHover && buttonColorHover !== void 0) $$bindings.buttonColorHover(buttonColorHover);
  if ($$props.buttonBorderColor === void 0 && $$bindings.buttonBorderColor && buttonBorderColor !== void 0) $$bindings.buttonBorderColor(buttonBorderColor);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0) $$bindings.ariaLabel(ariaLabel);
  if ($$props.style === void 0 && $$bindings.style && style !== void 0) $$bindings.style(style);
  if ($$props.orientation === void 0 && $$bindings.orientation && orientation !== void 0) $$bindings.orientation(orientation);
  if ($$props.fitViewOptions === void 0 && $$bindings.fitViewOptions && fitViewOptions !== void 0) $$bindings.fitViewOptions(fitViewOptions);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  isInteractive = $nodesDraggable || $nodesConnectable || $elementsSelectable;
  minZoomReached = $viewport.zoom <= $minZoom;
  maxZoomReached = $viewport.zoom >= $maxZoom;
  orientationClass = orientation === "horizontal" ? "horizontal" : "vertical";
  $$unsubscribe_maxZoom();
  $$unsubscribe_viewport();
  $$unsubscribe_minZoom();
  $$unsubscribe_elementsSelectable();
  $$unsubscribe_nodesConnectable();
  $$unsubscribe_nodesDraggable();
  return `${validate_component(Panel, "Panel").$$render(
    $$result,
    {
      class: cc(["svelte-flow__controls", orientationClass, className]),
      position,
      "data-testid": "svelte-flow__controls",
      "aria-label": ariaLabel ?? "Svelte Flow controls",
      style
    },
    {},
    {
      default: () => {
        return `${slots.before ? slots.before({}) : ``} ${showZoom ? `${validate_component(ControlButton, "ControlButton").$$render($$result, Object.assign({}, { class: "svelte-flow__controls-zoomin" }, { title: "zoom in" }, { "aria-label": "zoom in" }, { disabled: maxZoomReached }, buttonProps), {}, {
          default: () => {
            return `${validate_component(Plus, "PlusIcon").$$render($$result, {}, {}, {})}`;
          }
        })} ${validate_component(ControlButton, "ControlButton").$$render($$result, Object.assign({}, { class: "svelte-flow__controls-zoomout" }, { title: "zoom out" }, { "aria-label": "zoom out" }, { disabled: minZoomReached }, buttonProps), {}, {
          default: () => {
            return `${validate_component(Minus, "MinusIcon").$$render($$result, {}, {}, {})}`;
          }
        })}` : ``} ${showFitView ? `${validate_component(ControlButton, "ControlButton").$$render($$result, Object.assign({}, { class: "svelte-flow__controls-fitview" }, { title: "fit view" }, { "aria-label": "fit view" }, buttonProps), {}, {
          default: () => {
            return `${validate_component(Fit, "FitViewIcon").$$render($$result, {}, {}, {})}`;
          }
        })}` : ``} ${showLock ? `${validate_component(ControlButton, "ControlButton").$$render(
          $$result,
          Object.assign(
            {},
            {
              class: "svelte-flow__controls-interactive"
            },
            { title: "toggle interactivity" },
            { "aria-label": "toggle interactivity" },
            buttonProps
          ),
          {},
          {
            default: () => {
              return `${isInteractive ? `${validate_component(Unlock, "UnlockIcon").$$render($$result, {}, {}, {})}` : `${validate_component(Lock, "LockIcon").$$render($$result, {}, {}, {})}`}`;
            }
          }
        )}` : ``} ${slots.default ? slots.default({}) : ``} ${slots.after ? slots.after({}) : ``}`;
      }
    }
  )}`;
});
var BackgroundVariant;
(function(BackgroundVariant2) {
  BackgroundVariant2["Lines"] = "lines";
  BackgroundVariant2["Dots"] = "dots";
  BackgroundVariant2["Cross"] = "cross";
})(BackgroundVariant || (BackgroundVariant = {}));
const DotPattern = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { radius = 5 } = $$props;
  let { class: className = "" } = $$props;
  if ($$props.radius === void 0 && $$bindings.radius && radius !== void 0) $$bindings.radius(radius);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  return `<circle${add_attribute("cx", radius, 0)}${add_attribute("cy", radius, 0)}${add_attribute("r", radius, 0)}${add_attribute("class", cc(["svelte-flow__background-pattern", "dots", className]), 0)}></circle>`;
});
const LinePattern = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { lineWidth = 1 } = $$props;
  let { dimensions } = $$props;
  let { variant = void 0 } = $$props;
  let { class: className = "" } = $$props;
  if ($$props.lineWidth === void 0 && $$bindings.lineWidth && lineWidth !== void 0) $$bindings.lineWidth(lineWidth);
  if ($$props.dimensions === void 0 && $$bindings.dimensions && dimensions !== void 0) $$bindings.dimensions(dimensions);
  if ($$props.variant === void 0 && $$bindings.variant && variant !== void 0) $$bindings.variant(variant);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  return `<path${add_attribute("stroke-width", lineWidth, 0)}${add_attribute("d", `M${dimensions[0] / 2} 0 V${dimensions[1]} M0 ${dimensions[1] / 2} H${dimensions[0]}`, 0)}${add_attribute("class", cc(["svelte-flow__background-pattern", variant, className]), 0)}></path>`;
});
const css = {
  code: ".svelte-flow__background.svelte-1r7pe8d{position:absolute;width:100%;height:100%;top:0;left:0}",
  map: `{"version":3,"file":"Background.svelte","sources":["Background.svelte"],"sourcesContent":["<script labg=\\"ts\\" context=\\"module\\">\\n  const defaultSize = {\\n    [BackgroundVariant.Dots]: 1,\\n    [BackgroundVariant.Lines]: 1,\\n    [BackgroundVariant.Cross]: 6\\n  };\\n<\/script>\\n\\n<script>import cc from 'classcat';\\nimport DotPattern from './DotPattern.svelte';\\nimport LinePattern from './LinePattern.svelte';\\nimport { useStore } from '../../store';\\nimport { BackgroundVariant } from './types';\\nexport let id = undefined;\\nexport let variant = BackgroundVariant.Dots;\\nexport let gap = 20;\\nexport let size = 1;\\nexport let lineWidth = 1;\\nexport let bgColor = undefined;\\nexport let patternColor = undefined;\\nexport let patternClass = undefined;\\nlet className = '';\\nexport { className as class };\\nconst { viewport, flowId } = useStore();\\nconst patternSize = size || defaultSize[variant];\\nconst isDots = variant === BackgroundVariant.Dots;\\nconst isCross = variant === BackgroundVariant.Cross;\\nconst gapXY = Array.isArray(gap) ? gap : [gap, gap];\\n$: patternId = \`background-pattern-\${$flowId}-\${id ? id : ''}\`;\\n$: scaledGap = [gapXY[0] * $viewport.zoom || 1, gapXY[1] * $viewport.zoom || 1];\\n$: scaledSize = patternSize * $viewport.zoom;\\n$: patternDimensions = (isCross ? [scaledSize, scaledSize] : scaledGap);\\n$: patternOffset = isDots\\n    ? [scaledSize / 2, scaledSize / 2]\\n    : [patternDimensions[0] / 2, patternDimensions[1] / 2];\\n<\/script>\\n\\n<svg\\n  class={cc(['svelte-flow__background', className])}\\n  data-testid=\\"svelte-flow__background\\"\\n  style:--xy-background-color-props={bgColor}\\n  style:--xy-background-pattern-color-props={patternColor}\\n>\\n  <pattern\\n    id={patternId}\\n    x={$viewport.x % scaledGap[0]}\\n    y={$viewport.y % scaledGap[1]}\\n    width={scaledGap[0]}\\n    height={scaledGap[1]}\\n    patternUnits=\\"userSpaceOnUse\\"\\n    patternTransform={\`translate(-\${patternOffset[0]},-\${patternOffset[1]})\`}\\n  >\\n    {#if isDots}\\n      <DotPattern radius={scaledSize / 2} class={patternClass} />\\n    {:else}\\n      <LinePattern dimensions={patternDimensions} {variant} {lineWidth} class={patternClass} />\\n    {/if}\\n  </pattern>\\n  <rect x=\\"0\\" y=\\"0\\" width=\\"100%\\" height=\\"100%\\" fill={\`url(#\${patternId})\`} />\\n</svg>\\n\\n<style>\\n  .svelte-flow__background {\\n    position: absolute;\\n    width: 100%;\\n    height: 100%;\\n    top: 0;\\n    left: 0;\\n  }\\n</style>\\n"],"names":[],"mappings":"AA8DE,uCAAyB,CACvB,QAAQ,CAAE,QAAQ,CAClB,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IAAI,CACZ,GAAG,CAAE,CAAC,CACN,IAAI,CAAE,CACR"}`
};
const defaultSize = {
  [BackgroundVariant.Dots]: 1,
  [BackgroundVariant.Lines]: 1,
  [BackgroundVariant.Cross]: 6
};
const Background = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let patternId;
  let scaledGap;
  let scaledSize;
  let patternDimensions;
  let patternOffset;
  let $viewport, $$unsubscribe_viewport;
  let $flowId, $$unsubscribe_flowId;
  let { id = void 0 } = $$props;
  let { variant = BackgroundVariant.Dots } = $$props;
  let { gap = 20 } = $$props;
  let { size = 1 } = $$props;
  let { lineWidth = 1 } = $$props;
  let { bgColor = void 0 } = $$props;
  let { patternColor = void 0 } = $$props;
  let { patternClass = void 0 } = $$props;
  let { class: className = "" } = $$props;
  const { viewport, flowId } = useStore();
  $$unsubscribe_viewport = subscribe(viewport, (value) => $viewport = value);
  $$unsubscribe_flowId = subscribe(flowId, (value) => $flowId = value);
  const patternSize = size || defaultSize[variant];
  const isDots = variant === BackgroundVariant.Dots;
  const isCross = variant === BackgroundVariant.Cross;
  const gapXY = Array.isArray(gap) ? gap : [gap, gap];
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.variant === void 0 && $$bindings.variant && variant !== void 0) $$bindings.variant(variant);
  if ($$props.gap === void 0 && $$bindings.gap && gap !== void 0) $$bindings.gap(gap);
  if ($$props.size === void 0 && $$bindings.size && size !== void 0) $$bindings.size(size);
  if ($$props.lineWidth === void 0 && $$bindings.lineWidth && lineWidth !== void 0) $$bindings.lineWidth(lineWidth);
  if ($$props.bgColor === void 0 && $$bindings.bgColor && bgColor !== void 0) $$bindings.bgColor(bgColor);
  if ($$props.patternColor === void 0 && $$bindings.patternColor && patternColor !== void 0) $$bindings.patternColor(patternColor);
  if ($$props.patternClass === void 0 && $$bindings.patternClass && patternClass !== void 0) $$bindings.patternClass(patternClass);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0) $$bindings.class(className);
  $$result.css.add(css);
  patternId = `background-pattern-${$flowId}-${id ? id : ""}`;
  scaledGap = [gapXY[0] * $viewport.zoom || 1, gapXY[1] * $viewport.zoom || 1];
  scaledSize = patternSize * $viewport.zoom;
  patternDimensions = isCross ? [scaledSize, scaledSize] : scaledGap;
  patternOffset = isDots ? [scaledSize / 2, scaledSize / 2] : [patternDimensions[0] / 2, patternDimensions[1] / 2];
  $$unsubscribe_viewport();
  $$unsubscribe_flowId();
  return `<svg class="${escape(null_to_empty(cc(["svelte-flow__background", className])), true) + " svelte-1r7pe8d"}" data-testid="svelte-flow__background"${add_styles({
    "--xy-background-color-props": bgColor,
    "--xy-background-pattern-color-props": patternColor
  })}><pattern${add_attribute("id", patternId, 0)}${add_attribute("x", $viewport.x % scaledGap[0], 0)}${add_attribute("y", $viewport.y % scaledGap[1], 0)}${add_attribute("width", scaledGap[0], 0)}${add_attribute("height", scaledGap[1], 0)} patternUnits="userSpaceOnUse"${add_attribute("patternTransform", `translate(-${patternOffset[0]},-${patternOffset[1]})`, 0)}>${isDots ? `${validate_component(DotPattern, "DotPattern").$$render(
    $$result,
    {
      radius: scaledSize / 2,
      class: patternClass
    },
    {},
    {}
  )}` : `${validate_component(LinePattern, "LinePattern").$$render(
    $$result,
    {
      dimensions: patternDimensions,
      variant,
      lineWidth,
      class: patternClass
    },
    {},
    {}
  )}`}</pattern><rect x="0" y="0" width="100%" height="100%"${add_attribute("fill", `url(#${patternId})`, 0)}></rect></svg>`;
});
const isNode = (element) => isNodeBase(element);
function useSvelteFlow() {
  const { zoomIn, zoomOut, fitView: fitView2, onbeforedelete, snapGrid, viewport, width, height, minZoom, maxZoom, panZoom, nodes, edges, domNode, nodeLookup, nodeOrigin, edgeLookup, connectionLookup } = useStore();
  const getNodeRect = (node) => {
    const $nodeLookup = get_store_value(nodeLookup);
    const nodeToUse = isNode(node) ? node : $nodeLookup.get(node.id);
    const position = nodeToUse.parentId ? evaluateAbsolutePosition(nodeToUse.position, nodeToUse.measured, nodeToUse.parentId, $nodeLookup, get_store_value(nodeOrigin)) : nodeToUse.position;
    const nodeWithPosition = {
      id: nodeToUse.id,
      position,
      width: nodeToUse.measured?.width ?? nodeToUse.width,
      height: nodeToUse.measured?.height ?? nodeToUse.height,
      data: nodeToUse.data
    };
    return nodeToRect(nodeWithPosition);
  };
  const updateNode = (id, nodeUpdate, options = { replace: false }) => {
    const node = get_store_value(nodeLookup).get(id)?.internals.userNode;
    if (!node) {
      return;
    }
    const nextNode = typeof nodeUpdate === "function" ? nodeUpdate(node) : nodeUpdate;
    if (options.replace) {
      nodes.update((nds) => nds.map((node2) => {
        if (node2.id === id) {
          return isNode(nextNode) ? nextNode : { ...node2, ...nextNode };
        }
        return node2;
      }));
    } else {
      Object.assign(node, nextNode);
      nodes.update((nds) => nds);
    }
  };
  const getInternalNode = (id) => get_store_value(nodeLookup).get(id);
  return {
    zoomIn,
    zoomOut,
    getInternalNode,
    getNode: (id) => getInternalNode(id)?.internals.userNode,
    getNodes: (ids) => ids === void 0 ? get_store_value(nodes) : getElements(get_store_value(nodeLookup), ids),
    getEdge: (id) => get_store_value(edgeLookup).get(id),
    getEdges: (ids) => ids === void 0 ? get_store_value(edges) : getElements(get_store_value(edgeLookup), ids),
    setZoom: (zoomLevel, options) => {
      const currentPanZoom = get_store_value(panZoom);
      return currentPanZoom ? currentPanZoom.scaleTo(zoomLevel, { duration: options?.duration }) : Promise.resolve(false);
    },
    getZoom: () => get_store_value(viewport).zoom,
    setViewport: async (nextViewport, options) => {
      const currentViewport = get_store_value(viewport);
      const currentPanZoom = get_store_value(panZoom);
      if (!currentPanZoom) {
        return Promise.resolve(false);
      }
      await currentPanZoom.setViewport({
        x: nextViewport.x ?? currentViewport.x,
        y: nextViewport.y ?? currentViewport.y,
        zoom: nextViewport.zoom ?? currentViewport.zoom
      }, { duration: options?.duration });
      return Promise.resolve(true);
    },
    getViewport: () => get_store_value(viewport),
    setCenter: async (x, y, options) => {
      const nextZoom = typeof options?.zoom !== "undefined" ? options.zoom : get_store_value(maxZoom);
      const currentPanZoom = get_store_value(panZoom);
      if (!currentPanZoom) {
        return Promise.resolve(false);
      }
      await currentPanZoom.setViewport({
        x: get_store_value(width) / 2 - x * nextZoom,
        y: get_store_value(height) / 2 - y * nextZoom,
        zoom: nextZoom
      }, { duration: options?.duration });
      return Promise.resolve(true);
    },
    fitView: fitView2,
    fitBounds: async (bounds, options) => {
      const currentPanZoom = get_store_value(panZoom);
      if (!currentPanZoom) {
        return Promise.resolve(false);
      }
      const viewport2 = getViewportForBounds(bounds, get_store_value(width), get_store_value(height), get_store_value(minZoom), get_store_value(maxZoom), options?.padding ?? 0.1);
      await currentPanZoom.setViewport(viewport2, { duration: options?.duration });
      return Promise.resolve(true);
    },
    getIntersectingNodes: (nodeOrRect, partially = true, nodesToIntersect) => {
      const isRect = isRectObject(nodeOrRect);
      const nodeRect = isRect ? nodeOrRect : getNodeRect(nodeOrRect);
      if (!nodeRect) {
        return [];
      }
      return (nodesToIntersect || get_store_value(nodes)).filter((n) => {
        const internalNode = get_store_value(nodeLookup).get(n.id);
        if (!internalNode || !isRect && n.id === nodeOrRect.id) {
          return false;
        }
        const currNodeRect = nodeToRect(internalNode);
        const overlappingArea = getOverlappingArea(currNodeRect, nodeRect);
        const partiallyVisible = partially && overlappingArea > 0;
        return partiallyVisible || overlappingArea >= nodeRect.width * nodeRect.height;
      });
    },
    isNodeIntersecting: (nodeOrRect, area, partially = true) => {
      const isRect = isRectObject(nodeOrRect);
      const nodeRect = isRect ? nodeOrRect : getNodeRect(nodeOrRect);
      if (!nodeRect) {
        return false;
      }
      const overlappingArea = getOverlappingArea(nodeRect, area);
      const partiallyVisible = partially && overlappingArea > 0;
      return partiallyVisible || overlappingArea >= nodeRect.width * nodeRect.height;
    },
    deleteElements: async ({ nodes: nodesToRemove = [], edges: edgesToRemove = [] }) => {
      const { nodes: matchingNodes, edges: matchingEdges } = await getElementsToRemove({
        nodesToRemove,
        edgesToRemove,
        nodes: get_store_value(nodes),
        edges: get_store_value(edges),
        onBeforeDelete: get_store_value(onbeforedelete)
      });
      if (matchingNodes) {
        nodes.update((nds) => nds.filter((node) => !matchingNodes.some(({ id }) => id === node.id)));
      }
      if (matchingEdges) {
        edges.update((eds) => eds.filter((edge) => !matchingEdges.some(({ id }) => id === edge.id)));
      }
      return {
        deletedNodes: matchingNodes,
        deletedEdges: matchingEdges
      };
    },
    screenToFlowPosition: (position, options = { snapToGrid: true }) => {
      const _domNode = get_store_value(domNode);
      if (!_domNode) {
        return position;
      }
      const _snapGrid = options.snapToGrid ? get_store_value(snapGrid) : false;
      const { x, y, zoom } = get_store_value(viewport);
      const { x: domX, y: domY } = _domNode.getBoundingClientRect();
      const correctedPosition = {
        x: position.x - domX,
        y: position.y - domY
      };
      return pointToRendererPoint(correctedPosition, [x, y, zoom], _snapGrid !== null, _snapGrid || [1, 1]);
    },
    /**
     *
     * @param position
     * @returns
     */
    flowToScreenPosition: (position) => {
      const _domNode = get_store_value(domNode);
      if (!_domNode) {
        return position;
      }
      const { x, y, zoom } = get_store_value(viewport);
      const { x: domX, y: domY } = _domNode.getBoundingClientRect();
      const rendererPosition = rendererPointToPoint(position, [x, y, zoom]);
      return {
        x: rendererPosition.x + domX,
        y: rendererPosition.y + domY
      };
    },
    toObject: () => {
      return {
        nodes: get_store_value(nodes).map((node) => ({
          ...node,
          // we want to make sure that changes to the nodes object that gets returned by toObject
          // do not affect the nodes object
          position: { ...node.position },
          data: { ...node.data }
        })),
        edges: get_store_value(edges).map((edge) => ({ ...edge })),
        viewport: { ...get_store_value(viewport) }
      };
    },
    updateNode,
    updateNodeData: (id, dataUpdate, options) => {
      const node = get_store_value(nodeLookup).get(id)?.internals.userNode;
      if (!node) {
        return;
      }
      const nextData = typeof dataUpdate === "function" ? dataUpdate(node) : dataUpdate;
      node.data = options?.replace ? nextData : { ...node.data, ...nextData };
      nodes.update((nds) => nds);
    },
    getNodesBounds: (nodes2) => {
      const _nodeLookup = get_store_value(nodeLookup);
      const _nodeOrigin = get_store_value(nodeOrigin);
      return getNodesBounds(nodes2, { nodeLookup: _nodeLookup, nodeOrigin: _nodeOrigin });
    },
    getHandleConnections: ({ type, id, nodeId }) => Array.from(get_store_value(connectionLookup).get(`${nodeId}-${type}-${id ?? null}`)?.values() ?? []),
    viewport
  };
}
function getElements(lookup, ids) {
  const result = [];
  for (const id of ids) {
    const item = lookup.get(id);
    if (item) {
      const element = "internals" in item ? item.internals?.userNode : item;
      result.push(element);
    }
  }
  return result;
}
function useNodesInitialized() {
  const { nodesInitialized } = useStore();
  return {
    subscribe: nodesInitialized.subscribe
  };
}
const ArrowLeft = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 19.5 3 12m0 0 7.5-7.5M3 12h18"></path></svg>`;
});
const Heart = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12Z"></path></svg>`;
});
const Node = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { data } = $$props;
  if ($$props.data === void 0 && $$bindings.data && data !== void 0) $$bindings.data(data);
  return `<div class="px-4 py-3 shadow-md rounded-xl dark:bg-black bg-white border dark:border-gray-900 w-60 h-20 group">${validate_component(Tooltip, "Tooltip").$$render(
    $$result,
    {
      content: data?.message?.error ? data.message.error.content : data.message.content,
      class: "w-full",
      allowHTML: false
    },
    {},
    {
      default: () => {
        return `${data.message.role === "user" ? `<div class="flex w-full">${validate_component(ProfileImage, "ProfileImage").$$render(
          $$result,
          {
            src: data.user?.profile_image_url ?? `${WEBUI_BASE_URL}/user.png`,
            className: "size-5 -translate-y-[1px]"
          },
          {},
          {}
        )} <div class="ml-2"><div class="flex justify-between items-center"><div class="text-xs text-black dark:text-white font-medium line-clamp-1">${escape(data?.user?.name ?? "User")}</div></div> ${data?.message?.error ? `<div class="text-red-500 line-clamp-2 text-xs mt-0.5">${escape(data.message.error.content)}</div>` : `<div class="text-gray-500 line-clamp-2 text-xs mt-0.5">${escape(data.message.content)}</div>`}</div></div>` : `<div class="flex w-full">${validate_component(ProfileImage, "ProfileImage").$$render(
          $$result,
          {
            src: data?.model?.info?.meta?.profile_image_url ?? "",
            className: "size-5 -translate-y-[1px]"
          },
          {},
          {}
        )} <div class="ml-2"><div class="flex justify-between items-center"><div class="text-xs text-black dark:text-white font-medium line-clamp-1">${escape(data?.model?.name ?? data?.message?.model ?? "Assistant")}</div> <button${add_attribute(
          "class",
          data?.message?.favorite ? "" : "invisible group-hover:visible",
          0
        )}>${validate_component(Heart, "Heart").$$render(
          $$result,
          {
            className: "size-3 " + (data?.message?.favorite ? "fill-red-500 stroke-red-500" : "hover:fill-red-500 hover:stroke-red-500") + " ",
            strokeWidth: "2.5"
          },
          {},
          {}
        )}</button></div> ${data?.message?.error ? `<div class="text-red-500 line-clamp-2 text-xs mt-0.5">${escape(data.message.error.content)}</div>` : `<div class="text-gray-500 line-clamp-2 text-xs mt-0.5">${escape(data.message.content)}</div>`}</div></div>`}`;
      }
    }
  )} ${validate_component(Handle, "Handle").$$render(
    $$result,
    {
      type: "target",
      position: Position.Top,
      class: "w-2 rounded-full dark:bg-gray-900"
    },
    {},
    {}
  )} ${validate_component(Handle, "Handle").$$render(
    $$result,
    {
      type: "source",
      position: Position.Bottom,
      class: "w-2 rounded-full dark:bg-gray-900"
    },
    {},
    {}
  )}</div>`;
});
const AlignVertical = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M22 3L2 3" stroke-linecap="round" stroke-linejoin="round"></path><path d="M22 21L2 21" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 15V9C8 7.89543 8.89543 7 10 7H14C15.1046 7 16 7.89543 16 9V15C16 16.1046 15.1046 17 14 17H10C8.89543 17 8 16.1046 8 15Z"></path></svg>`;
});
const AlignHorizontal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M3 22L3 2" stroke-linecap="round" stroke-linejoin="round"></path><path d="M21 22V2" stroke-linecap="round" stroke-linejoin="round"></path><path d="M15 16H9C7.89543 16 7 15.1046 7 14V10C7 8.89543 7.89543 8 9 8H15C16.1046 8 17 8.89543 17 10V14C17 15.1046 16.1046 16 15 16Z"></path></svg>`;
});
const Flow = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $theme, $$unsubscribe_theme;
  $$unsubscribe_theme = subscribe(theme, (value) => $theme = value);
  createEventDispatcher();
  let { nodes } = $$props;
  let { nodeTypes } = $$props;
  let { edges } = $$props;
  let { setLayoutDirection } = $$props;
  if ($$props.nodes === void 0 && $$bindings.nodes && nodes !== void 0) $$bindings.nodes(nodes);
  if ($$props.nodeTypes === void 0 && $$bindings.nodeTypes && nodeTypes !== void 0) $$bindings.nodeTypes(nodeTypes);
  if ($$props.edges === void 0 && $$bindings.edges && edges !== void 0) $$bindings.edges(edges);
  if ($$props.setLayoutDirection === void 0 && $$bindings.setLayoutDirection && setLayoutDirection !== void 0) $$bindings.setLayoutDirection(setLayoutDirection);
  $$unsubscribe_theme();
  return `${validate_component(SvelteFlow, "SvelteFlow").$$render(
    $$result,
    {
      nodes,
      nodeTypes,
      edges,
      fitView: true,
      minZoom: 1e-3,
      colorMode: $theme.includes("dark") ? "dark" : $theme === "system" ? window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light" : "light",
      nodesConnectable: false,
      nodesDraggable: false,
      oninit: () => {
        /* @__PURE__ */ console.log("Flow initialized");
      }
    },
    {},
    {
      default: () => {
        return `${validate_component(Controls, "Controls").$$render($$result, { showLock: false }, {}, {
          default: () => {
            return `${validate_component(ControlButton, "ControlButton").$$render($$result, { title: "Vertical Layout" }, {}, {
              default: () => {
                return `${validate_component(AlignVertical, "AlignVertical").$$render($$result, { className: "size-4" }, {}, {})}`;
              }
            })} ${validate_component(ControlButton, "ControlButton").$$render($$result, { title: "Horizontal Layout" }, {}, {
              default: () => {
                return `${validate_component(AlignHorizontal, "AlignHorizontal").$$render($$result, { className: "size-4" }, {}, {})}`;
              }
            })}`;
          }
        })} ${validate_component(Background, "Background").$$render($$result, { variant: BackgroundVariant.Dots }, {}, {})}`;
      }
    }
  )}`;
});
const View = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $models, $$unsubscribe_models;
  let $user, $$unsubscribe_user;
  let $i18n, $$unsubscribe_i18n;
  let $nodes, $$unsubscribe_nodes;
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  useStore();
  const { fitView: fitView2, getViewport } = useSvelteFlow();
  useNodesInitialized();
  let { history } = $$props;
  let { onClose } = $$props;
  let { onNodeClick } = $$props;
  let selectedMessageId = null;
  const nodes = writable([]);
  $$unsubscribe_nodes = subscribe(nodes, (value) => $nodes = value);
  const edges = writable([]);
  let layoutDirection = "vertical";
  const nodeTypes = { custom: Node };
  const focusNode = async () => {
    if (selectedMessageId === null) {
      await fitView2({ nodes: [{ id: history.currentId }] });
    } else {
      await fitView2({ nodes: [{ id: selectedMessageId }] });
    }
    selectedMessageId = null;
  };
  const drawFlow = async (direction) => {
    const nodeList = [];
    const edgeList = [];
    const levelOffset = direction === "vertical" ? 150 : 300;
    const siblingOffset = direction === "vertical" ? 250 : 150;
    let positionMap = /* @__PURE__ */ new Map();
    let layerWidths = {};
    Object.keys(history.messages).forEach((id) => {
      const message = history.messages[id];
      const level = message.parentId ? (positionMap.get(message.parentId)?.level ?? -1) + 1 : 0;
      if (!layerWidths[level]) layerWidths[level] = 0;
      positionMap.set(id, {
        id: message.id,
        level,
        position: layerWidths[level]++
      });
    });
    Object.keys(history.messages).forEach((id) => {
      const pos = positionMap.get(id);
      const x = direction === "vertical" ? pos.position * siblingOffset : pos.level * levelOffset;
      const y = direction === "vertical" ? pos.level * levelOffset : pos.position * siblingOffset;
      nodeList.push({
        id: pos.id,
        type: "custom",
        data: {
          user: $user,
          message: history.messages[id],
          model: $models.find((model) => model.id === history.messages[id].model)
        },
        position: { x, y }
      });
      const parentId = history.messages[id].parentId;
      if (parentId) {
        edgeList.push({
          id: parentId + "-" + pos.id,
          source: parentId,
          target: pos.id,
          selectable: false,
          class: " dark:fill-gray-300 fill-gray-300",
          type: "smoothstep",
          animated: history.currentId === id || recurseCheckChild(id, history.currentId)
        });
      }
    });
    await edges.set([...edgeList]);
    await nodes.set([...nodeList]);
  };
  const recurseCheckChild = (nodeId, currentId) => {
    const node = history.messages[nodeId];
    return node.childrenIds && node.childrenIds.some((id) => id === currentId || recurseCheckChild(id, currentId));
  };
  const setLayoutDirection = (direction) => {
    layoutDirection = direction;
    drawFlow(layoutDirection);
  };
  onDestroy(() => {
    /* @__PURE__ */ console.log("Overview destroyed");
    nodes.set([]);
    edges.set([]);
  });
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  if ($$props.onNodeClick === void 0 && $$bindings.onNodeClick && onNodeClick !== void 0) $$bindings.onNodeClick(onNodeClick);
  {
    if (history) {
      drawFlow(layoutDirection);
    }
  }
  {
    if (history && history.currentId) {
      focusNode();
    }
  }
  $$unsubscribe_models();
  $$unsubscribe_user();
  $$unsubscribe_i18n();
  $$unsubscribe_nodes();
  return `<div class="w-full h-full relative"><div class="absolute z-50 w-full flex justify-between dark:text-gray-100 px-4 py-3"><div class="flex items-center gap-2.5"><button class="self-center p-0.5">${validate_component(ArrowLeft, "ArrowLeft").$$render($$result, { className: "size-3.5" }, {}, {})}</button> <div class="text-lg font-medium self-center font-primary">${escape($i18n.t("Chat Overview"))}</div></div> <button class="self-center p-0.5">${validate_component(XMark, "XMark").$$render($$result, { className: "size-3.5" }, {}, {})}</button></div> ${$nodes.length > 0 ? `${validate_component(Flow, "Flow").$$render(
    $$result,
    {
      nodes,
      nodeTypes,
      edges,
      setLayoutDirection
    },
    {},
    {}
  )}` : ``}</div>`;
});
const Overview = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  createEventDispatcher();
  let { history } = $$props;
  let { onClose } = $$props;
  let { onNodeClick } = $$props;
  if ($$props.history === void 0 && $$bindings.history && history !== void 0) $$bindings.history(history);
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  if ($$props.onNodeClick === void 0 && $$bindings.onNodeClick && onNodeClick !== void 0) $$bindings.onNodeClick(onNodeClick);
  return `${validate_component(SvelteFlowProvider, "SvelteFlowProvider").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(View, "View").$$render($$result, { history, onClose, onNodeClick }, {}, {})}`;
    }
  })}`;
});
export {
  Overview as default
};
//# sourceMappingURL=Overview.js.map
