import { c as create_ssr_component, b as subscribe, l as getContext, o as onDestroy } from "./ssr.js";
import { t as tick } from "./ssr2.js";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { v4 } from "uuid";
import { a as settings, c as config, m as mobile, D as WEBUI_API_BASE_URL } from "./index.js";
import { e as extractInputVariables, b as getUserPosition, d as getAge, f as getFormattedDate, h as getFormattedTime, i as getCurrentDateTime, j as getUserTimezone, k as getWeekday, l as convertHeicToJpeg, n as compressImage } from "./index2.js";
import { g as getSessionUser } from "./Drawer.js";
import { u as uploadFile } from "./index12.js";
import "dompurify";
import "dayjs";
import "dayjs/plugin/relativeTime.js";
import "dequal";
import "./create.js";
import "marked";
import "turndown";
import "@joplin/turndown-plugin-gfm";
import "./Drawer.svelte_svelte_type_style_lang.js";
import "@tiptap/starter-kit";
import "@tiptap/extension-table";
import "@tiptap/extension-list";
import "@tiptap/extensions";
import "@tiptap/extension-file-handler";
import "@tiptap/extension-typography";
import "@tiptap/extension-highlight";
import "@tiptap/extension-code-block-lowlight";
import "@tiptap/extension-mention";
import "dayjs/plugin/localizedFormat.js";
/* empty css                                    */
import "panzoom";
import "file-saver";
import "./FileItem.js";
const MessageInput = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  let $i18n, $$unsubscribe_i18n;
  let $config, $$unsubscribe_config;
  let $$unsubscribe_mobile;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { placeholder = $i18n.t("Type here...") } = $$props;
  let { id = null } = $$props;
  let { chatInputElement } = $$props;
  let { typingUsers = [] } = $$props;
  let { inputLoading = false } = $$props;
  let { onSubmit = (e) => {
  } } = $$props;
  let { onChange = (e) => {
  } } = $$props;
  let { onStop = (e) => {
  } } = $$props;
  let { scrollEnd = true } = $$props;
  let { scrollToBottom = () => {
  } } = $$props;
  let { disabled = false } = $$props;
  let { acceptFiles = true } = $$props;
  let { showFormattingToolbar = true } = $$props;
  let { userSuggestions = false } = $$props;
  let { channelSuggestions = false } = $$props;
  let { replyToMessage = null } = $$props;
  let { typingUsersClassName = "from-white dark:from-gray-900" } = $$props;
  let files = [];
  let inputVariables = {};
  const inputVariableHandler = async (text) => {
    inputVariables = extractInputVariables(text);
    if (Object.keys(inputVariables).length === 0) {
      return text;
    }
    return await new Promise((resolve) => {
    });
  };
  const textVariableHandler = async (text) => {
    if (text.includes("{{CLIPBOARD}}")) {
      const clipboardText = await navigator.clipboard.readText().catch((err) => {
        toast.error($i18n.t("Failed to read clipboard contents"));
        return "{{CLIPBOARD}}";
      });
      const clipboardItems = await navigator.clipboard.read();
      let imageUrl = null;
      for (const item of clipboardItems) {
        for (const type of item.types) {
          if (type.startsWith("image/")) {
            const blob = await item.getType(type);
            imageUrl = URL.createObjectURL(blob);
          }
        }
      }
      if (imageUrl) {
        files = [...files, { type: "image", url: imageUrl }];
      }
      text = text.replaceAll("{{CLIPBOARD}}", clipboardText);
    }
    if (text.includes("{{USER_LOCATION}}")) {
      let location;
      try {
        location = await getUserPosition();
      } catch (error) {
        toast.error($i18n.t("Location access not allowed"));
        location = "LOCATION_UNKNOWN";
      }
      text = text.replaceAll("{{USER_LOCATION}}", String(location));
    }
    const sessionUser = await getSessionUser(localStorage.token);
    if (text.includes("{{USER_NAME}}")) {
      const name = sessionUser?.name || "User";
      text = text.replaceAll("{{USER_NAME}}", name);
    }
    if (text.includes("{{USER_BIO}}")) {
      const bio = sessionUser?.bio || "";
      if (bio) {
        text = text.replaceAll("{{USER_BIO}}", bio);
      }
    }
    if (text.includes("{{USER_GENDER}}")) {
      const gender = sessionUser?.gender || "";
      if (gender) {
        text = text.replaceAll("{{USER_GENDER}}", gender);
      }
    }
    if (text.includes("{{USER_BIRTH_DATE}}")) {
      const birthDate = sessionUser?.date_of_birth || "";
      if (birthDate) {
        text = text.replaceAll("{{USER_BIRTH_DATE}}", birthDate);
      }
    }
    if (text.includes("{{USER_AGE}}")) {
      const birthDate = sessionUser?.date_of_birth || "";
      if (birthDate) {
        const age = getAge(birthDate);
        text = text.replaceAll("{{USER_AGE}}", age);
      }
    }
    if (text.includes("{{USER_LANGUAGE}}")) {
      const language = localStorage.getItem("locale") || "en-US";
      text = text.replaceAll("{{USER_LANGUAGE}}", language);
    }
    if (text.includes("{{CURRENT_DATE}}")) {
      const date = getFormattedDate();
      text = text.replaceAll("{{CURRENT_DATE}}", date);
    }
    if (text.includes("{{CURRENT_TIME}}")) {
      const time = getFormattedTime();
      text = text.replaceAll("{{CURRENT_TIME}}", time);
    }
    if (text.includes("{{CURRENT_DATETIME}}")) {
      const dateTime = getCurrentDateTime();
      text = text.replaceAll("{{CURRENT_DATETIME}}", dateTime);
    }
    if (text.includes("{{CURRENT_TIMEZONE}}")) {
      const timezone = getUserTimezone();
      text = text.replaceAll("{{CURRENT_TIMEZONE}}", timezone);
    }
    if (text.includes("{{CURRENT_WEEKDAY}}")) {
      const weekday = getWeekday();
      text = text.replaceAll("{{CURRENT_WEEKDAY}}", weekday);
    }
    return text;
  };
  const setText = async (text, cb) => {
    const chatInput = document.getElementById("chat-input");
    if (chatInput) {
      if (text !== "") {
        text = await textVariableHandler(text || "");
      }
      chatInputElement?.setText(text);
      chatInputElement?.focus();
      if (text !== "") {
        text = await inputVariableHandler(text);
      }
      await tick();
      if (cb) await cb(text);
    }
  };
  let command = "";
  let { showCommands = false } = $$props;
  const inputFilesHandler = async (inputFiles2) => {
    inputFiles2.forEach(async (file) => {
      console.info("Processing file:", {
        name: file.name,
        type: file.type,
        size: file.size,
        extension: file.name.split(".").at(-1)
      });
      if (($config?.file?.max_size ?? null) !== null && file.size > ($config?.file?.max_size ?? 0) * 1024 * 1024) {
        /* @__PURE__ */ console.error("File exceeds max size limit:", {
          fileSize: file.size,
          maxSize: ($config?.file?.max_size ?? 0) * 1024 * 1024
        });
        toast.error($i18n.t(`File size should not exceed {{maxSize}} MB.`, { maxSize: $config?.file?.max_size }));
        return;
      }
      if (file["type"].startsWith("image/")) {
        const compressImageHandler = async (imageUrl, settings2 = {}, config2 = {}) => {
          const settingsCompression = settings2?.imageCompression ?? false;
          const configWidth = config2?.file?.image_compression?.width ?? null;
          const configHeight = config2?.file?.image_compression?.height ?? null;
          if (!settingsCompression && !configWidth && !configHeight) {
            return imageUrl;
          }
          let width = null;
          let height = null;
          if (settingsCompression) {
            width = settings2?.imageCompressionSize?.width ?? null;
            height = settings2?.imageCompressionSize?.height ?? null;
          }
          if (configWidth && (width === null || width > configWidth)) {
            width = configWidth;
          }
          if (configHeight && (height === null || height > configHeight)) {
            height = configHeight;
          }
          if (width || height) {
            return await compressImage(imageUrl, width, height);
          }
          return imageUrl;
        };
        let reader = new FileReader();
        reader.onload = async (event) => {
          let imageUrl = event.target.result;
          if ($settings?.imageCompression && $settings?.imageCompressionInChannels) {
            imageUrl = await compressImageHandler(imageUrl, $settings, $config);
          }
          files = [...files, { type: "image", url: `${imageUrl}` }];
        };
        reader.readAsDataURL(file["type"] === "image/heic" ? await convertHeicToJpeg(file) : file);
      } else {
        uploadFileHandler(file);
      }
    });
  };
  const uploadFileHandler = async (file) => {
    const tempItemId = v4();
    const fileItem = {
      type: "file",
      file: "",
      id: null,
      url: "",
      name: file.name,
      collection_name: "",
      status: "uploading",
      size: file.size,
      error: "",
      itemId: tempItemId
    };
    if (fileItem.size == 0) {
      toast.error($i18n.t("You cannot upload an empty file."));
      return null;
    }
    files = [...files, fileItem];
    try {
      let metadata = null;
      if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && $settings?.audio?.stt?.language) {
        metadata = {
          language: $settings?.audio?.stt?.language
        };
      }
      const uploadedFile = await uploadFile(localStorage.token, file, metadata);
      if (uploadedFile) {
        console.info("File upload completed:", {
          id: uploadedFile.id,
          name: fileItem.name,
          collection: uploadedFile?.meta?.collection_name
        });
        if (uploadedFile.error) {
          /* @__PURE__ */ console.error("File upload warning:", uploadedFile.error);
          toast.warning(uploadedFile.error);
        }
        fileItem.status = "uploaded";
        fileItem.file = uploadedFile;
        fileItem.id = uploadedFile.id;
        fileItem.collection_name = uploadedFile?.meta?.collection_name || uploadedFile?.collection_name;
        fileItem.url = `${WEBUI_API_BASE_URL}/files/${uploadedFile.id}`;
        files = files;
      } else {
        files = files.filter((item) => item?.itemId !== tempItemId);
      }
    } catch (e) {
      toast.error(`${e}`);
      files = files.filter((item) => item?.itemId !== tempItemId);
    }
  };
  const handleKeyDown = (event) => {
    if (event.key === "Escape") ;
  };
  const onDragOver = (e) => {
    e.preventDefault();
    if (e.dataTransfer?.types?.includes("Files")) ;
  };
  const onDragLeave = () => {
  };
  const onDrop = async (e) => {
    e.preventDefault();
    if (e.dataTransfer?.files && acceptFiles) {
      const inputFiles2 = Array.from(e.dataTransfer?.files);
      if (inputFiles2 && inputFiles2.length > 0) {
        /* @__PURE__ */ console.log(inputFiles2);
        inputFilesHandler(inputFiles2);
      }
    }
  };
  onDestroy(() => {
    window.removeEventListener("keydown", handleKeyDown);
    const dropzoneElement = document.getElementById("channel-container");
    if (dropzoneElement) {
      dropzoneElement?.removeEventListener("dragover", onDragOver);
      dropzoneElement?.removeEventListener("drop", onDrop);
      dropzoneElement?.removeEventListener("dragleave", onDragLeave);
    }
  });
  if ($$props.placeholder === void 0 && $$bindings.placeholder && placeholder !== void 0) $$bindings.placeholder(placeholder);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.chatInputElement === void 0 && $$bindings.chatInputElement && chatInputElement !== void 0) $$bindings.chatInputElement(chatInputElement);
  if ($$props.typingUsers === void 0 && $$bindings.typingUsers && typingUsers !== void 0) $$bindings.typingUsers(typingUsers);
  if ($$props.inputLoading === void 0 && $$bindings.inputLoading && inputLoading !== void 0) $$bindings.inputLoading(inputLoading);
  if ($$props.onSubmit === void 0 && $$bindings.onSubmit && onSubmit !== void 0) $$bindings.onSubmit(onSubmit);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  if ($$props.onStop === void 0 && $$bindings.onStop && onStop !== void 0) $$bindings.onStop(onStop);
  if ($$props.scrollEnd === void 0 && $$bindings.scrollEnd && scrollEnd !== void 0) $$bindings.scrollEnd(scrollEnd);
  if ($$props.scrollToBottom === void 0 && $$bindings.scrollToBottom && scrollToBottom !== void 0) $$bindings.scrollToBottom(scrollToBottom);
  if ($$props.disabled === void 0 && $$bindings.disabled && disabled !== void 0) $$bindings.disabled(disabled);
  if ($$props.acceptFiles === void 0 && $$bindings.acceptFiles && acceptFiles !== void 0) $$bindings.acceptFiles(acceptFiles);
  if ($$props.showFormattingToolbar === void 0 && $$bindings.showFormattingToolbar && showFormattingToolbar !== void 0) $$bindings.showFormattingToolbar(showFormattingToolbar);
  if ($$props.userSuggestions === void 0 && $$bindings.userSuggestions && userSuggestions !== void 0) $$bindings.userSuggestions(userSuggestions);
  if ($$props.channelSuggestions === void 0 && $$bindings.channelSuggestions && channelSuggestions !== void 0) $$bindings.channelSuggestions(channelSuggestions);
  if ($$props.replyToMessage === void 0 && $$bindings.replyToMessage && replyToMessage !== void 0) $$bindings.replyToMessage(replyToMessage);
  if ($$props.typingUsersClassName === void 0 && $$bindings.typingUsersClassName && typingUsersClassName !== void 0) $$bindings.typingUsersClassName(typingUsersClassName);
  if ($$props.setText === void 0 && $$bindings.setText && setText !== void 0) $$bindings.setText(setText);
  if ($$props.showCommands === void 0 && $$bindings.showCommands && showCommands !== void 0) $$bindings.showCommands(showCommands);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    showCommands = ["/"].includes(command?.charAt(0));
    $$rendered = `${``}`;
  } while (!$$settled);
  $$unsubscribe_settings();
  $$unsubscribe_i18n();
  $$unsubscribe_config();
  $$unsubscribe_mobile();
  return $$rendered;
});
export {
  MessageInput as M
};
//# sourceMappingURL=MessageInput.js.map
