import { c as create_ssr_component, l as getContext, b as subscribe, g as escape, a as add_attribute, v as validate_component } from "./ssr.js";
import { n as showSidebar } from "./index.js";
const AddFilesPlaceholder = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let { title = "" } = $$props;
  let { content = "" } = $$props;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0) $$bindings.title(title);
  if ($$props.content === void 0 && $$bindings.content && content !== void 0) $$bindings.content(content);
  $$unsubscribe_i18n();
  return `<div class="px-3"><div class="text-center dark:text-white text-2xl font-medium z-50">${title ? `${escape(title)}` : `${escape($i18n.t("Add Files"))}`}</div> ${slots.default ? slots.default({}) : `<div class="px-2 mt-2 text-center text-gray-700 dark:text-gray-200 w-full">${content ? `${escape(content)}` : `${escape($i18n.t("Drop any files here to upload"))}`}</div> `}</div>`;
});
const FilesOverlay = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $showSidebar, $$unsubscribe_showSidebar;
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  let { show = false } = $$props;
  let overlayElement = null;
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  {
    if (show && overlayElement) {
      document.body.appendChild(overlayElement);
      document.body.style.overflow = "hidden";
    }
  }
  $$unsubscribe_showSidebar();
  return `${show ? `<div class="${"fixed " + escape(
    $showSidebar ? "left-0 md:left-[260px] md:w-[calc(100%-260px)]" : "left-0",
    true
  ) + " fixed top-0 right-0 bottom-0 w-full h-full flex z-9999 touch-none pointer-events-none"}" id="dropzone" role="region" aria-label="Drag and Drop Container"${add_attribute("this", overlayElement, 0)}><div class="absolute w-full h-full backdrop-blur-sm bg-gray-100/50 dark:bg-gray-900/80 flex justify-center"><div class="m-auto flex flex-col justify-center"><div class="max-w-md">${validate_component(AddFilesPlaceholder, "AddFilesPlaceholder").$$render($$result, {}, {}, {})}</div></div></div></div>` : ``}`;
});
export {
  FilesOverlay as F
};
//# sourceMappingURL=FilesOverlay.js.map
