import { s as setContext, l as getContext, c as create_ssr_component, b as subscribe, h as compute_rest_props, i as spread, k as escape_object, a as add_attribute, o as onDestroy, v as validate_component, p as createEventDispatcher, g as escape, e as each, m as missing_component } from "./ssr.js";
import { decode } from "html-entities";
import { v4 } from "uuid";
import dayjs from "dayjs";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import duration from "dayjs/plugin/duration.js";
import relativeTime from "dayjs/plugin/relativeTime.js";
import { D as Download, C as ChevronUp } from "./Download.js";
import { C as ChevronDown } from "./ChevronDown.js";
import { S as Spinner } from "./Spinner.js";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { a as settings, h as WEBUI_BASE_URL, u as user, c as config, q as models, w as channels } from "./index.js";
import { y as renderMermaidDiagram, z as renderVegaVisualization, A as unescapeHtml, B as markedKatexExtension, C as markedExtension, D as replaceTokens, E as processResponseContent } from "./index2.js";
import "file-saver";
import "panzoom";
import DOMPurify from "dompurify";
import { marked } from "marked";
import { T as Tooltip, i as is_void } from "./Tooltip.js";
import hljs from "highlight.js";
import { basicSetup, EditorView } from "codemirror";
import { keymap, placeholder } from "@codemirror/view";
import { Compartment } from "@codemirror/state";
import { acceptCompletion } from "@codemirror/autocomplete";
import { indentWithTab } from "@codemirror/commands";
import { LanguageDescription, indentUnit } from "@codemirror/language";
import { languages } from "@codemirror/language-data";
import { X as XMark } from "./XMark.js";
import "dequal";
import { w as withGet, o as omit, m as makeElement, e as executeCallbacks, a as addMeltEventListener, q as isElement, r as isFocusVisible, t as isTouch, s as styleToString, p as portalAttr, f as effect, i as isHTMLElement, b as isBrowser, g as safeOnMount, c as createElHelpers, n as noop } from "./create.js";
import { w as writable, i as derived } from "./exports.js";
import { o as overridable, t as toWritableStores, b as generateIds, e as derivedVisible, u as usePopper, f as getPortalDestination, s as sleep, c as createBitAttrs, r as removeUndefined, g as getOptionUpdater, a as createDispatcher } from "./updater.js";
import { t as tick } from "./ssr2.js";
import "./client.js";
import { A as ArrowRightCircle } from "./ArrowRightCircle.js";
function getTabbableNodes(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
    acceptNode: (node) => {
      return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
    }
  });
  while (walker.nextNode()) {
    nodes.push(walker.currentNode);
  }
  return nodes;
}
const { name } = createElHelpers("hover-card");
const defaults = {
  defaultOpen: false,
  openDelay: 1e3,
  closeDelay: 100,
  positioning: {
    placement: "bottom"
  },
  arrowSize: 8,
  closeOnOutsideClick: true,
  forceVisible: false,
  portal: void 0,
  closeOnEscape: true,
  onOutsideClick: void 0
};
const linkPreviewIdParts = ["trigger", "content"];
function createLinkPreview(props = {}) {
  const withDefaults = { ...defaults, ...props };
  const openWritable = withDefaults.open ?? writable(withDefaults.defaultOpen);
  const open = overridable(openWritable, withDefaults?.onOpenChange);
  const hasSelection = withGet.writable(false);
  const isPointerDownOnContent = withGet.writable(false);
  const containSelection = writable(false);
  const activeTrigger = writable(null);
  const options = toWritableStores(omit(withDefaults, "ids"));
  const { openDelay, closeDelay, positioning, arrowSize, closeOnOutsideClick, forceVisible, portal, closeOnEscape, onOutsideClick } = options;
  const ids = toWritableStores({ ...generateIds(linkPreviewIdParts), ...withDefaults.ids });
  let timeout = null;
  let originalBodyUserSelect;
  const handleOpen = withGet.derived(openDelay, ($openDelay) => {
    return () => {
      if (timeout) {
        window.clearTimeout(timeout);
        timeout = null;
      }
      timeout = window.setTimeout(() => {
        open.set(true);
      }, $openDelay);
    };
  });
  const handleClose = withGet.derived([closeDelay, isPointerDownOnContent, hasSelection], ([$closeDelay, $isPointerDownOnContent, $hasSelection]) => {
    return () => {
      if (timeout) {
        window.clearTimeout(timeout);
        timeout = null;
      }
      if (!$isPointerDownOnContent && !$hasSelection) {
        timeout = window.setTimeout(() => {
          open.set(false);
        }, $closeDelay);
      }
    };
  });
  const trigger = makeElement(name("trigger"), {
    stores: [open, ids.trigger, ids.content],
    returned: ([$open, $triggerId, $contentId]) => {
      return {
        role: "button",
        "aria-haspopup": "dialog",
        "aria-expanded": $open,
        "data-state": $open ? "open" : "closed",
        "aria-controls": $contentId,
        id: $triggerId
      };
    },
    action: (node) => {
      const unsub = executeCallbacks(addMeltEventListener(node, "pointerenter", (e) => {
        if (isTouch(e))
          return;
        handleOpen.get()();
      }), addMeltEventListener(node, "pointerleave", (e) => {
        if (isTouch(e))
          return;
        handleClose.get()();
      }), addMeltEventListener(node, "focus", (e) => {
        if (!isElement(e.currentTarget) || !isFocusVisible(e.currentTarget))
          return;
        handleOpen.get()();
      }), addMeltEventListener(node, "blur", () => handleClose.get()()));
      return {
        destroy: unsub
      };
    }
  });
  const isVisible = derivedVisible({ open, forceVisible, activeTrigger });
  const content = makeElement(name("content"), {
    stores: [isVisible, portal, ids.content],
    returned: ([$isVisible, $portal, $contentId]) => {
      return {
        hidden: $isVisible ? void 0 : true,
        tabindex: -1,
        style: styleToString({
          "pointer-events": $isVisible ? void 0 : "none",
          opacity: $isVisible ? 1 : 0,
          userSelect: "text",
          WebkitUserSelect: "text"
        }),
        id: $contentId,
        "data-state": $isVisible ? "open" : "closed",
        "data-portal": portalAttr($portal)
      };
    },
    action: (node) => {
      let unsub = noop;
      const unsubTimers = () => {
        if (timeout) {
          window.clearTimeout(timeout);
        }
      };
      let unsubPopper = noop;
      const unsubDerived = effect([isVisible, activeTrigger, positioning, closeOnOutsideClick, portal, closeOnEscape], ([$isVisible, $activeTrigger, $positioning, $closeOnOutsideClick, $portal, $closeOnEscape]) => {
        unsubPopper();
        if (!$isVisible || !$activeTrigger)
          return;
        tick().then(() => {
          unsubPopper();
          unsubPopper = usePopper(node, {
            anchorElement: $activeTrigger,
            open,
            options: {
              floating: $positioning,
              modal: {
                closeOnInteractOutside: $closeOnOutsideClick,
                onClose: () => {
                  open.set(false);
                  $activeTrigger.focus();
                },
                shouldCloseOnInteractOutside: (e) => {
                  onOutsideClick.get()?.(e);
                  if (e.defaultPrevented)
                    return false;
                  if (isHTMLElement($activeTrigger) && $activeTrigger.contains(e.target))
                    return false;
                  return true;
                },
                open: $isVisible
              },
              portal: getPortalDestination(node, $portal),
              focusTrap: null,
              escapeKeydown: $closeOnEscape ? void 0 : null
            }
          }).destroy;
        });
      });
      unsub = executeCallbacks(addMeltEventListener(node, "pointerdown", (e) => {
        const currentTarget = e.currentTarget;
        const target = e.target;
        if (!isHTMLElement(currentTarget) || !isHTMLElement(target))
          return;
        if (currentTarget.contains(target)) {
          containSelection.set(true);
        }
        hasSelection.set(false);
        isPointerDownOnContent.set(true);
      }), addMeltEventListener(node, "pointerenter", (e) => {
        if (isTouch(e))
          return;
        handleOpen.get()();
      }), addMeltEventListener(node, "pointerleave", (e) => {
        if (isTouch(e))
          return;
        handleClose.get()();
      }), addMeltEventListener(node, "focusout", (e) => {
        e.preventDefault();
      }));
      return {
        destroy() {
          unsub();
          unsubPopper();
          unsubTimers();
          unsubDerived();
        }
      };
    }
  });
  const arrow = makeElement(name("arrow"), {
    stores: arrowSize,
    returned: ($arrowSize) => ({
      "data-arrow": true,
      style: styleToString({
        position: "absolute",
        width: `var(--arrow-size, ${$arrowSize}px)`,
        height: `var(--arrow-size, ${$arrowSize}px)`
      })
    })
  });
  effect([containSelection], ([$containSelection]) => {
    if (!isBrowser || !$containSelection)
      return;
    const body = document.body;
    const contentElement = document.getElementById(ids.content.get());
    if (!contentElement)
      return;
    originalBodyUserSelect = body.style.userSelect || body.style.webkitUserSelect;
    const originalContentUserSelect = contentElement.style.userSelect || contentElement.style.webkitUserSelect;
    body.style.userSelect = "none";
    body.style.webkitUserSelect = "none";
    contentElement.style.userSelect = "text";
    contentElement.style.webkitUserSelect = "text";
    return () => {
      body.style.userSelect = originalBodyUserSelect;
      body.style.webkitUserSelect = originalBodyUserSelect;
      contentElement.style.userSelect = originalContentUserSelect;
      contentElement.style.webkitUserSelect = originalContentUserSelect;
    };
  });
  safeOnMount(() => {
    const triggerEl = document.getElementById(ids.trigger.get());
    if (!triggerEl)
      return;
    activeTrigger.set(triggerEl);
  });
  effect([open], ([$open]) => {
    if (!isBrowser || !$open) {
      hasSelection.set(false);
      return;
    }
    const handlePointerUp = () => {
      containSelection.set(false);
      isPointerDownOnContent.set(false);
      sleep(1).then(() => {
        const isSelection = document.getSelection()?.toString() !== "";
        if (isSelection) {
          hasSelection.set(true);
        }
      });
    };
    document.addEventListener("pointerup", handlePointerUp);
    const contentElement = document.getElementById(ids.content.get());
    if (!contentElement)
      return;
    const tabbables = getTabbableNodes(contentElement);
    tabbables.forEach((tabbable) => tabbable.setAttribute("tabindex", "-1"));
    return () => {
      document.removeEventListener("pointerup", handlePointerUp);
      hasSelection.set(false);
      isPointerDownOnContent.set(false);
    };
  });
  return {
    ids,
    elements: {
      trigger,
      content,
      arrow
    },
    states: {
      open
    },
    options
  };
}
function getLinkPreviewData() {
  const NAME = "link-preview";
  const PARTS = ["arrow", "content", "trigger"];
  return {
    NAME,
    PARTS
  };
}
function setCtx(props) {
  const { NAME, PARTS } = getLinkPreviewData();
  const getAttrs = createBitAttrs(NAME, PARTS);
  const linkPreview = {
    ...createLinkPreview({
      ...removeUndefined(props),
      forceVisible: true
    }),
    getAttrs
  };
  setContext(NAME, linkPreview);
  return {
    ...linkPreview,
    updateOption: getOptionUpdater(linkPreview.options)
  };
}
function getCtx() {
  const { NAME } = getLinkPreviewData();
  return getContext(NAME);
}
const Link_preview = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $idValues, $$unsubscribe_idValues;
  let { open = void 0 } = $$props;
  let { onOpenChange = void 0 } = $$props;
  let { openDelay = 700 } = $$props;
  let { closeDelay = 300 } = $$props;
  let { closeOnOutsideClick = void 0 } = $$props;
  let { closeOnEscape = void 0 } = $$props;
  let { portal = void 0 } = $$props;
  let { onOutsideClick = void 0 } = $$props;
  const { states: { open: localOpen }, updateOption, ids } = setCtx({
    defaultOpen: open,
    openDelay,
    closeDelay,
    closeOnOutsideClick,
    closeOnEscape,
    portal,
    onOutsideClick,
    onOpenChange: ({ next }) => {
      if (open !== next) {
        onOpenChange?.(next);
        open = next;
      }
      return next;
    }
  });
  const idValues = derived([ids.content, ids.trigger], ([$contentId, $triggerId]) => ({ content: $contentId, trigger: $triggerId }));
  $$unsubscribe_idValues = subscribe(idValues, (value) => $idValues = value);
  if ($$props.open === void 0 && $$bindings.open && open !== void 0) $$bindings.open(open);
  if ($$props.onOpenChange === void 0 && $$bindings.onOpenChange && onOpenChange !== void 0) $$bindings.onOpenChange(onOpenChange);
  if ($$props.openDelay === void 0 && $$bindings.openDelay && openDelay !== void 0) $$bindings.openDelay(openDelay);
  if ($$props.closeDelay === void 0 && $$bindings.closeDelay && closeDelay !== void 0) $$bindings.closeDelay(closeDelay);
  if ($$props.closeOnOutsideClick === void 0 && $$bindings.closeOnOutsideClick && closeOnOutsideClick !== void 0) $$bindings.closeOnOutsideClick(closeOnOutsideClick);
  if ($$props.closeOnEscape === void 0 && $$bindings.closeOnEscape && closeOnEscape !== void 0) $$bindings.closeOnEscape(closeOnEscape);
  if ($$props.portal === void 0 && $$bindings.portal && portal !== void 0) $$bindings.portal(portal);
  if ($$props.onOutsideClick === void 0 && $$bindings.onOutsideClick && onOutsideClick !== void 0) $$bindings.onOutsideClick(onOutsideClick);
  open !== void 0 && localOpen.set(open);
  {
    updateOption("openDelay", openDelay);
  }
  {
    updateOption("closeDelay", closeDelay);
  }
  {
    updateOption("closeOnOutsideClick", closeOnOutsideClick);
  }
  {
    updateOption("closeOnEscape", closeOnEscape);
  }
  {
    updateOption("portal", portal);
  }
  {
    updateOption("onOutsideClick", onOutsideClick);
  }
  $$unsubscribe_idValues();
  return `${slots.default ? slots.default({ ids: $idValues }) : ``}`;
});
const Link_preview_trigger = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let builder;
  let $$restProps = compute_rest_props($$props, ["asChild", "id", "el"]);
  let $trigger, $$unsubscribe_trigger;
  let { asChild = false } = $$props;
  let { id = void 0 } = $$props;
  let { el = void 0 } = $$props;
  const { elements: { trigger }, ids, getAttrs } = getCtx();
  $$unsubscribe_trigger = subscribe(trigger, (value) => $trigger = value);
  createDispatcher();
  const attrs = getAttrs("trigger");
  if ($$props.asChild === void 0 && $$bindings.asChild && asChild !== void 0) $$bindings.asChild(asChild);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.el === void 0 && $$bindings.el && el !== void 0) $$bindings.el(el);
  {
    if (id) {
      ids.trigger.set(id);
    }
  }
  builder = $trigger;
  {
    Object.assign(builder, attrs);
  }
  $$unsubscribe_trigger();
  return `${asChild ? `${slots.default ? slots.default({ builder }) : ``}` : ` <a${spread([escape_object(builder), escape_object($$restProps), escape_object(attrs)], {})}${add_attribute("this", el, 0)}>${slots.default ? slots.default({ builder }) : ``}</a>`}`;
});
const ImagePreview = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_i18n;
  let { show = false } = $$props;
  let { src = "" } = $$props;
  let { alt = "" } = $$props;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => value);
  let previewElement = null;
  let sceneElement;
  const handleKeyDown = (event) => {
    if (event.key === "Escape") {
      /* @__PURE__ */ console.log("Escape");
      show = false;
    }
  };
  onDestroy(() => {
    show = false;
  });
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.src === void 0 && $$bindings.src && src !== void 0) $$bindings.src(src);
  if ($$props.alt === void 0 && $$bindings.alt && alt !== void 0) $$bindings.alt(alt);
  {
    if (show && previewElement) {
      document.body.appendChild(previewElement);
      window.addEventListener("keydown", handleKeyDown);
      document.body.style.overflow = "hidden";
    }
  }
  $$unsubscribe_i18n();
  return `${show ? `  <div class="modal fixed top-0 right-0 left-0 bottom-0 bg-black text-white w-full min-h-screen h-screen flex justify-center z-9999 overflow-hidden overscroll-contain"${add_attribute("this", previewElement, 0)}><div class="absolute left-0 w-full flex justify-between select-none z-20"><div><button class="p-5">${validate_component(XMark, "XMark").$$render($$result, { className: "size-6" }, {}, {})}</button></div> <div><button class="p-5 z-999" data-svelte-h="svelte-1etdbvs"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="w-6 h-6"><path d="M10.75 2.75a.75.75 0 0 0-1.5 0v8.614L6.295 8.235a.75.75 0 1 0-1.09 1.03l4.25 4.5a.75.75 0 0 0 1.09 0l4.25-4.5a.75.75 0 0 0-1.09-1.03l-2.955 3.129V2.75Z"></path><path d="M3.5 12.75a.75.75 0 0 0-1.5 0v2.5A2.75 2.75 0 0 0 4.75 18h10.5A2.75 2.75 0 0 0 18 15.25v-2.5a.75.75 0 0 0-1.5 0v2.5c0 .69-.56 1.25-1.25 1.25H4.75c-.69 0-1.25-.56-1.25-1.25v-2.5Z"></path></svg></button></div></div> <div class="flex h-full max-h-full justify-center items-center z-0"><img${add_attribute("src", src, 0)}${add_attribute("alt", alt, 0)} class="mx-auto h-full object-scale-down select-none" draggable="false"${add_attribute("this", sceneElement, 0)}></div></div>` : ``}`;
});
const Image = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  let { src = "" } = $$props;
  let { alt = "" } = $$props;
  let { className = ` w-full ${$settings?.highContrastMode ?? false ? "" : "outline-hidden focus:outline-hidden"}` } = $$props;
  let { imageClassName = "rounded-lg" } = $$props;
  let { dismissible = false } = $$props;
  let { onDismiss = () => {
  } } = $$props;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let _src = "";
  let showImagePreview = false;
  if ($$props.src === void 0 && $$bindings.src && src !== void 0) $$bindings.src(src);
  if ($$props.alt === void 0 && $$bindings.alt && alt !== void 0) $$bindings.alt(alt);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.imageClassName === void 0 && $$bindings.imageClassName && imageClassName !== void 0) $$bindings.imageClassName(imageClassName);
  if ($$props.dismissible === void 0 && $$bindings.dismissible && dismissible !== void 0) $$bindings.dismissible(dismissible);
  if ($$props.onDismiss === void 0 && $$bindings.onDismiss && onDismiss !== void 0) $$bindings.onDismiss(onDismiss);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    _src = src.startsWith("/") ? `${WEBUI_BASE_URL}${src}` : src;
    $$rendered = `${validate_component(ImagePreview, "ImagePreview").$$render(
      $$result,
      { src: _src, alt, show: showImagePreview },
      {
        show: ($$value) => {
          showImagePreview = $$value;
          $$settled = false;
        }
      },
      {}
    )} <div class="relative group w-fit flex items-center"><button${add_attribute("class", className, 0)}${add_attribute("aria-label", $i18n.t("Show image preview"), 0)} type="button"><img${add_attribute("src", _src, 0)}${add_attribute("alt", alt, 0)}${add_attribute("class", imageClassName, 0)} draggable="false" data-cy="image"></button> ${dismissible ? `<div class="absolute -top-1 -right-1"><button${add_attribute("aria-label", $i18n.t("Remove image"), 0)} class="bg-white text-black border border-white rounded-full group-hover:visible invisible transition" type="button">${validate_component(XMark, "XMark").$$render($$result, { className: "size-4" }, {}, {})}</button></div>` : ``}</div>`;
  } while (!$$settled);
  $$unsubscribe_settings();
  $$unsubscribe_i18n();
  return $$rendered;
});
function findChanges(oldStr, newStr) {
  let start = 0;
  while (start < oldStr.length && start < newStr.length && oldStr[start] === newStr[start]) {
    start++;
  }
  if (oldStr === newStr) return [];
  let endOld = oldStr.length, endNew = newStr.length;
  while (endOld > start && endNew > start && oldStr[endOld - 1] === newStr[endNew - 1]) {
    endOld--;
    endNew--;
  }
  return [
    {
      from: start,
      to: endOld,
      insert: newStr.slice(start, endNew)
    }
  ];
}
const CodeEditor = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $$unsubscribe_user;
  $$unsubscribe_user = subscribe(user, (value2) => value2);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value2) => $i18n = value2);
  let { boilerplate = "" } = $$props;
  let { value = "" } = $$props;
  let { onSave = () => {
  } } = $$props;
  let { onChange = () => {
  } } = $$props;
  let _value = "";
  const updateValue = () => {
    if (_value !== value) {
      findChanges(_value, value);
      _value = value;
    }
  };
  let { id = "" } = $$props;
  let { lang = "" } = $$props;
  let codeEditor;
  const focus = () => {
    codeEditor.focus();
  };
  let editorTheme = new Compartment();
  let editorLanguage = new Compartment();
  languages.push(LanguageDescription.of({
    name: "HCL",
    extensions: ["hcl", "tf"],
    load() {
      return import("codemirror-lang-hcl").then((m) => m.hcl());
    }
  }));
  languages.push(LanguageDescription.of({
    name: "Elixir",
    extensions: ["ex", "exs"],
    load() {
      return import("codemirror-lang-elixir").then((m) => m.elixir());
    }
  }));
  const getLang = async () => {
    const language = languages.find((l) => l.alias.includes(lang));
    return await language?.load();
  };
  const formatPythonCodeHandler = async () => {
    return false;
  };
  [
    basicSetup,
    keymap.of([{ key: "Tab", run: acceptCompletion }, indentWithTab]),
    indentUnit.of("    "),
    placeholder($i18n.t("Enter your code here...")),
    EditorView.updateListener.of((e) => {
      if (e.docChanged) {
        _value = e.state.doc.toString();
        onChange(_value);
      }
    }),
    editorTheme.of([]),
    editorLanguage.of([])
  ];
  const setLanguage = async () => {
    const language = await getLang();
    if (language && codeEditor) {
      codeEditor.dispatch({
        effects: editorLanguage.reconfigure(language)
      });
    }
  };
  onDestroy(() => {
  });
  if ($$props.boilerplate === void 0 && $$bindings.boilerplate && boilerplate !== void 0) $$bindings.boilerplate(boilerplate);
  if ($$props.value === void 0 && $$bindings.value && value !== void 0) $$bindings.value(value);
  if ($$props.onSave === void 0 && $$bindings.onSave && onSave !== void 0) $$bindings.onSave(onSave);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.lang === void 0 && $$bindings.lang && lang !== void 0) $$bindings.lang(lang);
  if ($$props.focus === void 0 && $$bindings.focus && focus !== void 0) $$bindings.focus(focus);
  if ($$props.formatPythonCodeHandler === void 0 && $$bindings.formatPythonCodeHandler && formatPythonCodeHandler !== void 0) $$bindings.formatPythonCodeHandler(formatPythonCodeHandler);
  {
    if (value) {
      updateValue();
    }
  }
  {
    if (lang) {
      setLanguage();
    }
  }
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  return `<div id="${"code-textarea-" + escape(id, true)}" class="h-full w-full text-sm"></div>`;
});
const Clipboard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "2" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M15.666 3.888A2.25 2.25 0 0 0 13.5 2.25h-3c-1.03 0-1.9.693-2.166 1.638m7.332 0c.055.194.084.4.084.612v0a.75.75 0 0 1-.75.75H9a.75.75 0 0 1-.75-.75v0c0-.212.03-.418.084-.612m7.332 0c.646.049 1.288.11 1.927.184 1.1.128 1.907 1.077 1.907 2.185V19.5a2.25 2.25 0 0 1-2.25 2.25H6.75A2.25 2.25 0 0 1 4.5 19.5V6.257c0-1.108.806-2.057 1.907-2.185a48.208 48.208 0 0 1 1.927-.184"></path></svg>`;
});
const Reset = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "2" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99"></path></svg>`;
});
const SVGPanZoom = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { className = "" } = $$props;
  let { svg = "" } = $$props;
  let { content = "" } = $$props;
  let sceneParentElement;
  let sceneElement;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.svg === void 0 && $$bindings.svg && svg !== void 0) $$bindings.svg(svg);
  if ($$props.content === void 0 && $$bindings.content && content !== void 0) $$bindings.content(content);
  $$unsubscribe_i18n();
  return `<div class="${"relative " + escape(className, true)}"${add_attribute("this", sceneParentElement, 0)}><div class="flex h-full max-h-full justify-center items-center"${add_attribute("this", sceneElement, 0)}><!-- HTML_TAG_START -->${DOMPurify.sanitize(svg, {
    USE_PROFILES: { svg: true, svgFilters: true },
    // allow <svg>, <defs>, <filter>, etc.
    WHOLE_DOCUMENT: false,
    ADD_TAGS: ["style", "foreignObject"],
    // include foreignObject if using HTML labels
    ADD_ATTR: [
      "class",
      "style",
      "id",
      "data-*",
      "viewBox",
      "preserveAspectRatio",
      // markers / arrows
      "markerWidth",
      "markerHeight",
      "markerUnits",
      "refX",
      "refY",
      "orient",
      // hrefs (for gradients, markers, etc.)
      "href",
      "xlink:href",
      // text positioning
      "dominant-baseline",
      "text-anchor",
      // pattern / clip / mask units
      "clipPathUnits",
      "filterUnits",
      "patternUnits",
      "patternContentUnits",
      "maskUnits",
      // a11y niceties
      "role",
      "aria-label",
      "aria-labelledby",
      "aria-hidden",
      "tabindex"
    ],
    SANITIZE_DOM: true
  })}<!-- HTML_TAG_END --></div> ${content ? `<div class="absolute top-2.5 right-2.5"><div class="flex gap-1">${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Download as SVG") }, {}, {
    default: () => {
      return `<button class="p-1.5 rounded-lg border border-gray-100 dark:border-none dark:bg-gray-850 hover:bg-gray-50 dark:hover:bg-gray-800 transition">${validate_component(Download, "Download").$$render($$result, { className: " size-4" }, {}, {})}</button>`;
    }
  })} ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Reset view") }, {}, {
    default: () => {
      return `<button class="p-1.5 rounded-lg border border-gray-100 dark:border-none dark:bg-gray-850 hover:bg-gray-50 dark:hover:bg-gray-800 transition">${validate_component(Reset, "Reset").$$render($$result, { className: " size-4" }, {}, {})}</button>`;
    }
  })} ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Copy to clipboard") }, {}, {
    default: () => {
      return `<button class="p-1.5 rounded-lg border border-gray-100 dark:border-none dark:bg-gray-850 hover:bg-gray-50 dark:hover:bg-gray-800 transition">${validate_component(Clipboard, "Clipboard").$$render($$result, { className: " size-4", strokeWidth: "1.5" }, {}, {})}</button>`;
    }
  })}</div></div>` : ``}</div>`;
});
const ChevronUpDown = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M8.25 15 12 18.75 15.75 15m-7.5-6L12 5.25 15.75 9"></path></svg>`;
});
const CodeBlock = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $config, $$unsubscribe_config;
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { id = "" } = $$props;
  let { edit = true } = $$props;
  let { onSave = (e) => {
  } } = $$props;
  let { onUpdate = (e) => {
  } } = $$props;
  let { onPreview = (e) => {
  } } = $$props;
  let { save = false } = $$props;
  let { run = true } = $$props;
  let { preview = false } = $$props;
  let { collapsed = false } = $$props;
  let { token } = $$props;
  let { lang = "" } = $$props;
  let { code = "" } = $$props;
  let { attributes = {} } = $$props;
  let { className = "mb-2" } = $$props;
  let { editorClassName = "" } = $$props;
  let { stickyButtonsClassName = "top-0" } = $$props;
  let _code = "";
  const updateCode = () => {
    _code = code;
  };
  let _token = null;
  let mermaidHtml = null;
  let vegaHtml = null;
  let stdout = null;
  let stderr = null;
  let result = null;
  let files = null;
  let saved = false;
  const saveCode = () => {
    saved = true;
    code = _code;
    onSave(code);
    setTimeout(
      () => {
        saved = false;
      },
      1e3
    );
  };
  const checkPythonCode = (str) => {
    const pythonSyntax = [
      "def ",
      "else:",
      "elif ",
      "try:",
      "except:",
      "finally:",
      "yield ",
      "lambda ",
      "assert ",
      "nonlocal ",
      "del ",
      "True",
      "False",
      "None",
      " and ",
      " or ",
      " not ",
      " in ",
      " is ",
      " with "
    ];
    for (let syntax of pythonSyntax) {
      if (str.includes(syntax)) {
        return true;
      }
    }
    return false;
  };
  const render = async () => {
    onUpdate(token);
    if (lang === "mermaid" && (token?.raw ?? "").slice(-4).includes("```")) {
      try {
        mermaidHtml = await renderMermaidDiagram(code);
      } catch (error) {
        /* @__PURE__ */ console.error("Failed to render mermaid diagram:", error);
        const errorMsg = error instanceof Error ? error.message : String(error);
        toast.error($i18n.t("Failed to render diagram") + `: ${errorMsg}`);
        mermaidHtml = null;
      }
    } else if ((lang === "vega" || lang === "vega-lite") && (token?.raw ?? "").slice(-4).includes("```")) {
      try {
        vegaHtml = await renderVegaVisualization(code);
      } catch (error) {
        /* @__PURE__ */ console.error("Failed to render Vega visualization:", error);
        const errorMsg = error instanceof Error ? error.message : String(error);
        toast.error($i18n.t("Failed to render diagram") + `: ${errorMsg}`);
        vegaHtml = null;
      }
    }
  };
  const onAttributesUpdate = () => {
    if (attributes?.output) {
      const unescapeHtml2 = (html) => {
        const textArea = document.createElement("textarea");
        textArea.innerHTML = html;
        return textArea.value;
      };
      try {
        const unescapedOutput = unescapeHtml2(attributes.output);
        const output = JSON.parse(unescapedOutput);
        stdout = output.stdout;
        stderr = output.stderr;
        result = output.result;
      } catch (error) {
        /* @__PURE__ */ console.error("Error:", error);
      }
    }
  };
  onDestroy(() => {
  });
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.edit === void 0 && $$bindings.edit && edit !== void 0) $$bindings.edit(edit);
  if ($$props.onSave === void 0 && $$bindings.onSave && onSave !== void 0) $$bindings.onSave(onSave);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  if ($$props.onPreview === void 0 && $$bindings.onPreview && onPreview !== void 0) $$bindings.onPreview(onPreview);
  if ($$props.save === void 0 && $$bindings.save && save !== void 0) $$bindings.save(save);
  if ($$props.run === void 0 && $$bindings.run && run !== void 0) $$bindings.run(run);
  if ($$props.preview === void 0 && $$bindings.preview && preview !== void 0) $$bindings.preview(preview);
  if ($$props.collapsed === void 0 && $$bindings.collapsed && collapsed !== void 0) $$bindings.collapsed(collapsed);
  if ($$props.token === void 0 && $$bindings.token && token !== void 0) $$bindings.token(token);
  if ($$props.lang === void 0 && $$bindings.lang && lang !== void 0) $$bindings.lang(lang);
  if ($$props.code === void 0 && $$bindings.code && code !== void 0) $$bindings.code(code);
  if ($$props.attributes === void 0 && $$bindings.attributes && attributes !== void 0) $$bindings.attributes(attributes);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.editorClassName === void 0 && $$bindings.editorClassName && editorClassName !== void 0) $$bindings.editorClassName(editorClassName);
  if ($$props.stickyButtonsClassName === void 0 && $$bindings.stickyButtonsClassName && stickyButtonsClassName !== void 0) $$bindings.stickyButtonsClassName(stickyButtonsClassName);
  {
    if (code) {
      updateCode();
    }
  }
  {
    if (token) {
      if (JSON.stringify(token) !== JSON.stringify(_token)) {
        _token = token;
      }
    }
  }
  {
    if (_token) {
      render();
    }
  }
  {
    if (attributes) {
      onAttributesUpdate();
    }
  }
  $$unsubscribe_i18n();
  $$unsubscribe_config();
  return `<div><div class="${"relative " + escape(className, true) + " flex flex-col rounded-3xl border border-gray-100 dark:border-gray-850 my-0.5"}" dir="ltr">${lang === "mermaid" ? `${mermaidHtml ? `${validate_component(SVGPanZoom, "SvgPanZoom").$$render(
    $$result,
    {
      className: " rounded-3xl max-h-fit overflow-hidden",
      svg: mermaidHtml,
      content: _token.text
    },
    {},
    {}
  )}` : `<pre class="mermaid">${escape(code)}</pre>`}` : `${lang === "vega" || lang === "vega-lite" ? `${vegaHtml ? `${validate_component(SVGPanZoom, "SvgPanZoom").$$render(
    $$result,
    {
      className: "rounded-3xl max-h-fit overflow-hidden",
      svg: vegaHtml,
      content: _token.text
    },
    {},
    {}
  )}` : `<pre class="vega">${escape(code)}</pre>`}` : `<div class="absolute left-0 right-0 py-2.5 pr-3 text-text-300 pl-4.5 text-xs font-medium dark:text-white">${escape(lang)}</div> <div class="${"sticky " + escape(stickyButtonsClassName, true) + " left-0 right-0 py-2 pr-3 flex items-center justify-end w-full z-10 text-xs text-black dark:text-white"}"><div class="flex items-center gap-0.5"><button class="flex gap-1 items-center bg-none border-none transition rounded-md px-1.5 py-0.5 bg-white dark:bg-black"><div class="-translate-y-[0.5px]">${validate_component(ChevronUpDown, "ChevronUpDown").$$render($$result, { className: "size-3" }, {}, {})}</div> <div>${escape(collapsed ? $i18n.t("Expand") : $i18n.t("Collapse"))}</div></button> ${($config?.features?.enable_code_execution ?? true) && (lang.toLowerCase() === "python" || lang.toLowerCase() === "py" || lang === "" && checkPythonCode(code)) ? `${`${run ? `<button class="flex gap-1 items-center run-code-button bg-none border-none transition rounded-md px-1.5 py-0.5 bg-white dark:bg-black"><div>${escape($i18n.t("Run"))}</div></button>` : ``}`}` : ``} ${save ? `<button class="save-code-button bg-none border-none transition rounded-md px-1.5 py-0.5 bg-white dark:bg-black">${escape(saved ? $i18n.t("Saved") : $i18n.t("Save"))}</button>` : ``} <button class="copy-code-button bg-none border-none transition rounded-md px-1.5 py-0.5 bg-white dark:bg-black">${escape($i18n.t("Copy"))}</button> ${preview && ["html", "svg"].includes(lang) ? `<button class="flex gap-1 items-center run-code-button bg-none border-none transition rounded-md px-1.5 py-0.5 bg-white dark:bg-black"><div>${escape($i18n.t("Preview"))}</div></button>` : ``}</div></div> <div class="${"language-" + escape(lang, true) + " rounded-t-3xl -mt-9 " + escape(
    editorClassName ? editorClassName : stdout || stderr || result ? "" : "rounded-b-3xl",
    true
  ) + " overflow-hidden"}"><div class="pt-8 bg-white dark:bg-black"></div> ${!collapsed ? `${edit ? `${validate_component(CodeEditor, "CodeEditor").$$render(
    $$result,
    {
      value: code,
      id,
      lang,
      onSave: () => {
        saveCode();
      },
      onChange: (value) => {
        _code = value;
      }
    },
    {},
    {}
  )}` : `<pre class="hljs p-4 px-5 overflow-x-auto" style="${"border-top-left-radius: 0px; border-top-right-radius: 0px; " + escape((stdout || stderr || result) && "border-bottom-left-radius: 0px; border-bottom-right-radius: 0px;", true)}"><code class="${"language-" + escape(lang, true) + " rounded-t-none whitespace-pre text-sm"}"><!-- HTML_TAG_START -->${hljs.highlightAuto(code, hljs.getLanguage(lang)?.aliases).value || code}<!-- HTML_TAG_END --></code></pre>`}` : `<div class="bg-white dark:bg-black dark:text-white rounded-b-3xl! pt-0.5 pb-3 px-4 flex flex-col gap-2 text-xs"><span class="text-gray-500 italic">${escape($i18n.t("{{COUNT}} hidden lines", { COUNT: code.split("\n").length }))}</span></div>`}</div> ${!collapsed ? `<div id="${"plt-canvas-" + escape(id, true)}" class="bg-gray-50 dark:bg-black dark:text-white max-w-full overflow-x-auto scrollbar-hidden"></div> ${stdout || stderr || result || files ? `<div class="bg-gray-50 dark:bg-black dark:text-white rounded-b-3xl! py-4 px-4 flex flex-col gap-2">${`${stdout || stderr ? `<div class=""><div class="text-gray-500 text-xs mb-1">${escape($i18n.t("STDOUT/STDERR"))}</div> <div class="${"text-sm " + escape(stdout?.split("\n")?.length > 100 ? `max-h-96` : "", true) + " overflow-y-auto"}">${escape(stdout || stderr)}</div></div>` : ``} ${result || files ? `<div class=""><div class="text-gray-500 text-xs mb-1">${escape($i18n.t("RESULT"))}</div> ${result ? `<div class="text-sm">${escape(`${JSON.stringify(result)}`)}</div>` : ``} ${``}</div>` : ``}`}</div>` : ``}` : ``}`}`}</div></div>`;
});
function escapeHtml(s) {
  return s.replace(
    /[&<>"']/g,
    (c) => ({ "&": "&amp;", "<": "&lt;", ">": "&gt;", '"': "&quot;", "'": "&#39;" })[c]
  );
}
function mentionStart(src) {
  return src.indexOf("<");
}
function mentionTokenizer(src, options = {}) {
  const trigger = options.triggerChar ?? "@";
  const re = new RegExp(`^<\\${trigger}([\\w.\\-:/]+)(?:\\|([^>]*))?>`);
  const m = re.exec(src);
  if (!m) return;
  const [, id, label] = m;
  return {
    type: "mention",
    raw: m[0],
    triggerChar: trigger,
    id,
    label: label && label.length > 0 ? label : id
  };
}
function mentionRenderer(token, options = {}) {
  const trigger = options.triggerChar ?? "@";
  const cls = options.className ?? "mention";
  const extra = options.extraAttrs ?? {};
  const attrs = Object.entries({
    class: cls,
    "data-type": "mention",
    "data-id": token.id,
    "data-mention-suggestion-char": trigger,
    ...extra
  }).map(([k, v]) => `${k}="${escapeHtml(String(v))}"`).join(" ");
  return `<span ${attrs}>${escapeHtml(trigger + token.label)}</span>`;
}
function mentionExtension(opts = {}) {
  return {
    name: "mention",
    level: "inline",
    start: mentionStart,
    tokenizer(src) {
      return mentionTokenizer.call(this, src, opts);
    },
    renderer(token) {
      return mentionRenderer(token, opts);
    }
  };
}
const KatexRenderer = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { content } = $$props;
  let { displayMode = false } = $$props;
  if ($$props.content === void 0 && $$bindings.content && content !== void 0) $$bindings.content(content);
  if ($$props.displayMode === void 0 && $$bindings.displayMode && displayMode !== void 0) $$bindings.displayMode(displayMode);
  return `${``}`;
});
function extractAttributes(input) {
  const regex = /(\w+)="([^"]*)"/g;
  let match;
  let attrs = {};
  while ((match = regex.exec(input)) !== null) {
    attrs[match[1]] = match[2];
  }
  return attrs;
}
function getDomain(url) {
  const domain = url.replace("http://", "").replace("https://", "").split(/[/?#]/)[0];
  if (domain.startsWith("www.")) {
    return domain.slice(4);
  }
  return domain;
}
function formattedTitle(title) {
  if (title.startsWith("http")) {
    return getDomain(title);
  }
  return title;
}
const Source = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { id } = $$props;
  let { token } = $$props;
  let { onClick = () => {
  } } = $$props;
  let attributes = {};
  const getDisplayTitle = (title) => {
    if (!title) return "N/A";
    if (title.length > 30) {
      return title.slice(0, 15) + "..." + title.slice(-10);
    }
    return title;
  };
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.token === void 0 && $$bindings.token && token !== void 0) $$bindings.token(token);
  if ($$props.onClick === void 0 && $$bindings.onClick && onClick !== void 0) $$bindings.onClick(onClick);
  attributes = extractAttributes(token.text);
  return `${attributes.title !== "N/A" ? `<button class="text-xs font-medium w-fit translate-y-[2px] px-2 py-0.5 dark:bg-white/5 dark:text-white/60 dark:hover:text-white bg-gray-50 text-black/60 hover:text-black transition rounded-lg"><span class="line-clamp-1">${escape(getDisplayTitle(decodeURIComponent(attributes.title) ? formattedTitle(decodeURIComponent(attributes.title)) : ""))}</span></button>` : ``}`;
});
const HTMLToken = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  let { id } = $$props;
  let { token } = $$props;
  let { onSourceClick = () => {
  } } = $$props;
  let html = null;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.token === void 0 && $$bindings.token && token !== void 0) $$bindings.token(token);
  if ($$props.onSourceClick === void 0 && $$bindings.onSourceClick && onSourceClick !== void 0) $$bindings.onSourceClick(onSourceClick);
  {
    if (token.type === "html" && token?.text) {
      html = DOMPurify.sanitize(token.text);
    } else {
      html = null;
    }
  }
  $$unsubscribe_settings();
  return `${token.type === "html" ? `${html && html.includes("<video") ? (() => {
    let video = html.match(/<video[^>]*>([\s\S]*?)<\/video>/), videoSrc = video && video[1];
    return `  ${videoSrc ? ` <video class="w-full my-2"${add_attribute("src", videoSrc.replaceAll("&amp;", "&"), 0)} title="Video player" frameborder="0" referrerpolicy="strict-origin-when-cross-origin" controls allowfullscreen></video>` : `${escape(token.text)}`}`;
  })() : `${html && html.includes("<audio") ? (() => {
    let audio = html.match(/<audio[^>]*>([\s\S]*?)<\/audio>/), audioSrc = audio && audio[1];
    return `  ${audioSrc ? ` <audio class="w-full my-2"${add_attribute("src", audioSrc.replaceAll("&amp;", "&"), 0)} title="Audio player" controls></audio>` : `${escape(token.text)}`}`;
  })() : `${token.text && token.text.match(/<iframe\s+[^>]*src="https:\/\/www\.youtube\.com\/embed\/([a-zA-Z0-9_-]{11})(?:\?[^"]*)?"[^>]*><\/iframe>/) ? (() => {
    let match = token.text.match(/<iframe\s+[^>]*src="https:\/\/www\.youtube\.com\/embed\/([a-zA-Z0-9_-]{11})(?:\?[^"]*)?"[^>]*><\/iframe>/), ytId = match && match[1];
    return `  ${ytId ? `<iframe class="w-full aspect-video my-2"${add_attribute("src", `https://www.youtube.com/embed/${ytId}`, 0)} title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>` : ``}`;
  })() : `${token.text && token.text.includes("<iframe") ? (() => {
    let match = token.text.match(/<iframe\s+[^>]*src="([^"]+)"[^>]*><\/iframe>/), iframeSrc = match && match[1];
    return `  ${iframeSrc ? `<iframe class="w-full my-2"${add_attribute("src", iframeSrc, 0)} title="Embedded content" frameborder="0" sandbox onload="this.style.height=(this.contentWindow.document.body.scrollHeight+20)+'px';"></iframe>` : `${escape(token.text)}`}`;
  })() : `${token.text && token.text.includes("<status") ? (() => {
    let match = token.text.match(/<status title="([^"]+)" done="(true|false)" ?\/?>/), statusTitle = match && match[1], statusDone = match && match[2] === "true";
    return `   ${statusTitle ? `<div class="flex flex-col justify-center -space-y-0.5"><div class="${escape(statusDone === false ? "shimmer" : "", true) + " text-gray-500 dark:text-gray-500 line-clamp-1 text-wrap"}">${escape(statusTitle)}</div></div>` : `${escape(token.text)}`}`;
  })() : `${token.text.includes(`<file type="html"`) ? (() => {
    let match = token.text.match(/<file type="html" id="([^"]+)"/), fileId = match && match[1];
    return `  ${fileId ? `<iframe class="w-full my-2"${add_attribute("src", `${WEBUI_BASE_URL}/api/v1/files/${fileId}/content/html`, 0)} title="Content" frameborder="0" sandbox="${"allow-scripts allow-downloads" + escape(
      $settings?.iframeSandboxAllowForms ?? false ? " allow-forms" : "",
      true
    ) + escape(
      $settings?.iframeSandboxAllowSameOrigin ?? false ? " allow-same-origin" : "",
      true
    )}" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen width="100%" onload="this.style.height=(this.contentWindow.document.body.scrollHeight+20)+'px';"></iframe>` : ``}`;
  })() : `${token.text.includes(`<source_id`) ? `${validate_component(Source, "Source").$$render($$result, { id, token, onClick: onSourceClick }, {}, {})}` : (() => {
    let br = token.text.match(/<br\s*\/?>/);
    return ` ${br ? `<br>` : `${escape(token.text)}`}`;
  })()}`}`}`}`}`}`}` : ``}`;
});
const TextToken = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { token } = $$props;
  let { done = true } = $$props;
  let texts = [];
  if ($$props.token === void 0 && $$bindings.token && token !== void 0) $$bindings.token(token);
  if ($$props.done === void 0 && $$bindings.done && done !== void 0) $$bindings.done(done);
  texts = (token?.raw ?? "").split(" ");
  return `${done ? `${escape(token?.raw)}` : `${each(texts, (text) => {
    return `<span class="">${escape(text)} </span>`;
  })}`}`;
});
const CodespanToken = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => value);
  let { token } = $$props;
  let { done = true } = $$props;
  if ($$props.token === void 0 && $$bindings.token && token !== void 0) $$bindings.token(token);
  if ($$props.done === void 0 && $$bindings.done && done !== void 0) $$bindings.done(done);
  $$unsubscribe_i18n();
  return `  ${done ? `<code class="codespan cursor-pointer">${escape(unescapeHtml(token.text))}</code>` : `<code class="codespan cursor-pointer">${escape(unescapeHtml(token.text))}</code>`}`;
});
const UserStatusLinkPreview = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  let { id = null } = $$props;
  let { side = "top" } = $$props;
  let { align = "start" } = $$props;
  let { sideOffset = 6 } = $$props;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.side === void 0 && $$bindings.side && side !== void 0) $$bindings.side(side);
  if ($$props.align === void 0 && $$bindings.align && align !== void 0) $$bindings.align(align);
  if ($$props.sideOffset === void 0 && $$bindings.sideOffset && sideOffset !== void 0) $$bindings.sideOffset(sideOffset);
  return `${``}`;
});
const MentionToken = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $models, $$unsubscribe_models;
  let $channels, $$unsubscribe_channels;
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_channels = subscribe(channels, (value) => $channels = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { token } = $$props;
  let triggerChar = "";
  let label = "";
  let idType = null;
  let id = "";
  const init = () => {
    const _id = token?.id;
    const parts = _id?.split(":");
    if (parts) {
      idType = parts[0];
      id = parts.slice(1).join(":");
    } else {
      idType = null;
      id = _id;
    }
    label = token?.label ?? id;
    triggerChar = token?.triggerChar ?? "@";
    if (triggerChar === "#") {
      if (idType === "C") {
        const channel = $channels.find((c) => c.id === id);
        if (channel) {
          label = channel.name;
        } else {
          label = $i18n.t("Unknown");
        }
      }
    } else if (triggerChar === "@") {
      if (idType === "U") ;
      else if (idType === "M") {
        const model = $models.find((m) => m.id === id);
        if (model) {
          label = model.name;
        } else {
          label = $i18n.t("Unknown");
        }
      }
    }
  };
  if ($$props.token === void 0 && $$bindings.token && token !== void 0) $$bindings.token(token);
  {
    if (token) {
      init();
    }
  }
  $$unsubscribe_i18n();
  $$unsubscribe_models();
  $$unsubscribe_channels();
  return `${validate_component(Link_preview, "LinkPreview.Root").$$render($$result, { openDelay: 0, closeDelay: 0 }, {}, {
    default: () => {
      return `${validate_component(Link_preview_trigger, "LinkPreview.Trigger").$$render(
        $$result,
        {
          class: " cursor-pointer no-underline! font-normal! "
        },
        {},
        {
          default: () => {
            return `  <span class="mention">${escape(triggerChar)}${escape(label)}</span>`;
          }
        }
      )} ${triggerChar === "@" && idType === "U" ? `${validate_component(UserStatusLinkPreview, "UserStatusLinkPreview").$$render($$result, { id }, {}, {})}` : ``}`;
    }
  })}`;
});
const MarkdownInlineTokens = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  let { id } = $$props;
  let { done = true } = $$props;
  let { tokens } = $$props;
  let { onSourceClick = () => {
  } } = $$props;
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.done === void 0 && $$bindings.done && done !== void 0) $$bindings.done(done);
  if ($$props.tokens === void 0 && $$bindings.tokens && tokens !== void 0) $$bindings.tokens(tokens);
  if ($$props.onSourceClick === void 0 && $$bindings.onSourceClick && onSourceClick !== void 0) $$bindings.onSourceClick(onSourceClick);
  return `${each(tokens, (token) => {
    return `${token.type === "escape" ? `${escape(unescapeHtml(token.text))}` : `${token.type === "html" ? `${validate_component(HTMLToken, "HtmlToken").$$render($$result, { id, token, onSourceClick }, {}, {})}` : `${token.type === "link" ? `${token.tokens ? `<a${add_attribute("href", token.href, 0)} target="_blank" rel="nofollow"${add_attribute("title", token.title, 0)}>${validate_component(MarkdownInlineTokens, "svelte:self").$$render(
      $$result,
      {
        id: `${id}-a`,
        tokens: token.tokens,
        onSourceClick,
        done
      },
      {},
      {}
    )} </a>` : `<a${add_attribute("href", token.href, 0)} target="_blank" rel="nofollow"${add_attribute("title", token.title, 0)}>${escape(token.text)}</a>`}` : `${token.type === "image" ? `${validate_component(Image, "Image").$$render($$result, { src: token.href, alt: token.text }, {}, {})}` : `${token.type === "strong" ? `<strong>${validate_component(MarkdownInlineTokens, "svelte:self").$$render(
      $$result,
      {
        id: `${id}-strong`,
        tokens: token.tokens,
        onSourceClick
      },
      {},
      {}
    )}</strong>` : `${token.type === "em" ? `<em>${validate_component(MarkdownInlineTokens, "svelte:self").$$render(
      $$result,
      {
        id: `${id}-em`,
        tokens: token.tokens,
        onSourceClick
      },
      {},
      {}
    )}</em>` : `${token.type === "codespan" ? `${validate_component(CodespanToken, "CodespanToken").$$render($$result, { token, done }, {}, {})}` : `${token.type === "br" ? `<br>` : `${token.type === "del" ? `<del>${validate_component(MarkdownInlineTokens, "svelte:self").$$render(
      $$result,
      {
        id: `${id}-del`,
        tokens: token.tokens,
        onSourceClick
      },
      {},
      {}
    )}</del>` : `${token.type === "inlineKatex" ? `${token.text ? `${validate_component(KatexRenderer, "KatexRenderer").$$render($$result, { content: token.text, displayMode: false }, {}, {})}` : ``}` : `${token.type === "iframe" ? `<iframe src="${escape(WEBUI_BASE_URL, true) + "/api/v1/files/" + escape(token.fileId, true) + "/content"}"${add_attribute("title", token.fileId, 0)} width="100%" frameborder="0" onload="this.style.height=(this.contentWindow.document.body.scrollHeight+20)+'px';"></iframe>` : `${token.type === "mention" ? `${validate_component(MentionToken, "MentionToken").$$render($$result, { token }, {}, {})}` : `${token.type === "text" ? `${validate_component(TextToken, "TextToken").$$render($$result, { token, done }, {}, {})}` : ``}`}`}`}`}`}`}`}`}`}`}`}`}`;
  })}`;
});
const Info = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="m11.25 11.25.041-.02a.75.75 0 0 1 1.063.852l-.708 2.836a.75.75 0 0 0 1.063.853l.041-.021M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9-3.75h.008v.008H12V8.25Z"></path></svg>`;
});
const Star = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 0 1 1.04 0l2.125 5.111a.563.563 0 0 0 .475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 0 0-.182.557l1.285 5.385a.562.562 0 0 1-.84.61l-4.725-2.885a.562.562 0 0 0-.586 0L6.982 20.54a.562.562 0 0 1-.84-.61l1.285-5.386a.562.562 0 0 0-.182-.557l-4.204-3.602a.562.562 0 0 1 .321-.988l5.518-.442a.563.563 0 0 0 .475-.345L11.48 3.5Z"></path></svg>`;
});
const LightBulb = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M12 18v-5.25m0 0a6.01 6.01 0 0 0 1.5-.189m-1.5.189a6.01 6.01 0 0 1-1.5-.189m3.75 7.478a12.06 12.06 0 0 1-4.5 0m3.75 2.383a14.406 14.406 0 0 1-3 0M14.25 18v-.192c0-.983.658-1.823 1.508-2.316a7.5 7.5 0 1 0-7.517 0c.85.493 1.509 1.333 1.509 2.316V18"></path></svg>`;
});
const Bolt = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-3" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" aria-hidden="true"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="m3.75 13.5 10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75Z"></path></svg>`;
});
const alertStyles = {
  NOTE: {
    border: "border-sky-500",
    text: "text-sky-500",
    icon: Info
  },
  TIP: {
    border: "border-emerald-500",
    text: "text-emerald-500",
    icon: LightBulb
  },
  IMPORTANT: {
    border: "border-purple-500",
    text: "text-purple-500",
    icon: Star
  },
  WARNING: {
    border: "border-yellow-500",
    text: "text-yellow-500",
    icon: ArrowRightCircle
  },
  CAUTION: {
    border: "border-rose-500",
    text: "text-rose-500",
    icon: Bolt
  }
};
function alertComponent(token) {
  const regExpStr = `^(?:\\[!(NOTE|TIP|IMPORTANT|WARNING|CAUTION)\\])\\s*?
*`;
  const regExp = new RegExp(regExpStr);
  const matches = token.text?.match(regExp);
  if (matches && matches.length) {
    const alertType = matches[1];
    const newText = token.text.replace(regExp, "");
    const newTokens = marked.lexer(newText);
    return {
      type: alertType,
      text: newText,
      tokens: newTokens
    };
  }
  return false;
}
const AlertRenderer = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { token } = $$props;
  let { alert } = $$props;
  let { id = "" } = $$props;
  let { tokenIdx = 0 } = $$props;
  let { onTaskClick = void 0 } = $$props;
  let { onSourceClick = void 0 } = $$props;
  if ($$props.token === void 0 && $$bindings.token && token !== void 0) $$bindings.token(token);
  if ($$props.alert === void 0 && $$bindings.alert && alert !== void 0) $$bindings.alert(alert);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.tokenIdx === void 0 && $$bindings.tokenIdx && tokenIdx !== void 0) $$bindings.tokenIdx(tokenIdx);
  if ($$props.onTaskClick === void 0 && $$bindings.onTaskClick && onTaskClick !== void 0) $$bindings.onTaskClick(onTaskClick);
  if ($$props.onSourceClick === void 0 && $$bindings.onSourceClick && onSourceClick !== void 0) $$bindings.onSourceClick(onSourceClick);
  return ` <div${add_attribute("class", `border-l-4 pl-2.5 ${alertStyles[alert.type].border} my-0.5`, 0)}><div class="${escape(alertStyles[alert.type].text, true) + " items-center flex gap-1 py-1.5"}">${validate_component(alertStyles[alert.type].icon || missing_component, "svelte:component").$$render($$result, { className: "inline-block size-4" }, {}, {})} <span class="font-medium">${escape(alert.type)}</span></div> <div class="pb-2">${validate_component(MarkdownTokens, "MarkdownTokens").$$render(
    $$result,
    {
      id: `${id}-${tokenIdx}`,
      tokens: alert.tokens,
      onTaskClick,
      onSourceClick
    },
    {},
    {}
  )}</div></div>`;
});
const MarkdownTokens = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { id } = $$props;
  let { tokens } = $$props;
  let { top = true } = $$props;
  let { attributes = {} } = $$props;
  let { done = true } = $$props;
  let { save = false } = $$props;
  let { preview = false } = $$props;
  let { editCodeBlock = true } = $$props;
  let { topPadding = false } = $$props;
  let { onSave = () => {
  } } = $$props;
  let { onUpdate = () => {
  } } = $$props;
  let { onPreview = () => {
  } } = $$props;
  let { onTaskClick = () => {
  } } = $$props;
  let { onSourceClick = () => {
  } } = $$props;
  const headerComponent = (depth) => {
    return "h" + depth;
  };
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.tokens === void 0 && $$bindings.tokens && tokens !== void 0) $$bindings.tokens(tokens);
  if ($$props.top === void 0 && $$bindings.top && top !== void 0) $$bindings.top(top);
  if ($$props.attributes === void 0 && $$bindings.attributes && attributes !== void 0) $$bindings.attributes(attributes);
  if ($$props.done === void 0 && $$bindings.done && done !== void 0) $$bindings.done(done);
  if ($$props.save === void 0 && $$bindings.save && save !== void 0) $$bindings.save(save);
  if ($$props.preview === void 0 && $$bindings.preview && preview !== void 0) $$bindings.preview(preview);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  if ($$props.onSave === void 0 && $$bindings.onSave && onSave !== void 0) $$bindings.onSave(onSave);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  if ($$props.onPreview === void 0 && $$bindings.onPreview && onPreview !== void 0) $$bindings.onPreview(onPreview);
  if ($$props.onTaskClick === void 0 && $$bindings.onTaskClick && onTaskClick !== void 0) $$bindings.onTaskClick(onTaskClick);
  if ($$props.onSourceClick === void 0 && $$bindings.onSourceClick && onSourceClick !== void 0) $$bindings.onSourceClick(onSourceClick);
  $$unsubscribe_settings();
  $$unsubscribe_i18n();
  return ` ${each(tokens, (token, tokenIdx) => {
    return `${token.type === "hr" ? `<hr class="border-gray-100 dark:border-gray-850">` : `${token.type === "heading" ? `${((tag) => {
      return tag ? `<${headerComponent(token.depth)} dir="auto">${is_void(tag) ? "" : `${validate_component(MarkdownInlineTokens, "MarkdownInlineTokens").$$render(
        $$result,
        {
          id: `${id}-${tokenIdx}-h`,
          tokens: token.tokens,
          done,
          onSourceClick
        },
        {},
        {}
      )} `}${is_void(tag) ? "" : `</${tag}>`}` : "";
    })(headerComponent(token.depth))}` : `${token.type === "code" ? `${token.raw.includes("```") ? `${validate_component(CodeBlock, "CodeBlock").$$render(
      $$result,
      {
        id: `${id}-${tokenIdx}`,
        collapsed: $settings?.collapseCodeBlocks ?? false,
        token,
        lang: token?.lang ?? "",
        code: token?.text ?? "",
        attributes,
        save,
        preview,
        edit: editCodeBlock,
        stickyButtonsClassName: topPadding ? "top-7" : "top-0",
        onSave: (value) => {
          onSave({
            raw: token.raw,
            oldContent: token.text,
            newContent: value
          });
        },
        onUpdate,
        onPreview
      },
      {},
      {}
    )}` : `${escape(token.text)}`}` : `${token.type === "table" ? `<div class="relative w-full group mb-2"><div class="scrollbar-hidden relative overflow-x-auto max-w-full"><table class="w-full text-sm text-left text-gray-500 dark:text-gray-400 max-w-full rounded-xl"><thead class="text-xs text-gray-700 uppercase bg-white dark:bg-gray-900 dark:text-gray-400 border-none"><tr class="">${each(token.header, (header, headerIdx) => {
      return `<th scope="col" class="px-2.5! py-2! cursor-pointer border-b border-gray-100! dark:border-gray-800!"${add_attribute(
        "style",
        token.align[headerIdx] ? "" : `text-align: ${token.align[headerIdx]}`,
        0
      )}><div class="gap-1.5 text-left"><div class="shrink-0 break-normal">${validate_component(MarkdownInlineTokens, "MarkdownInlineTokens").$$render(
        $$result,
        {
          id: `${id}-${tokenIdx}-header-${headerIdx}`,
          tokens: header.tokens,
          done,
          onSourceClick
        },
        {},
        {}
      )} </div></div> </th>`;
    })} </tr></thead> <tbody>${each(token.rows, (row, rowIdx) => {
      return `<tr class="bg-white dark:bg-gray-900 text-xs">${each(row ?? [], (cell, cellIdx) => {
        return `<td class="${"px-3! py-2! text-gray-900 dark:text-white w-max " + escape(
          token.rows.length - 1 === rowIdx ? "" : "border-b border-gray-50! dark:border-gray-850!",
          true
        )}"${add_attribute(
          "style",
          token.align[cellIdx] ? `text-align: ${token.align[cellIdx]}` : "",
          0
        )}><div class="break-normal">${validate_component(MarkdownInlineTokens, "MarkdownInlineTokens").$$render(
          $$result,
          {
            id: `${id}-${tokenIdx}-row-${rowIdx}-${cellIdx}`,
            tokens: cell.tokens,
            done,
            onSourceClick
          },
          {},
          {}
        )}</div> </td>`;
      })} </tr>`;
    })}</tbody> </table></div> <div class="absolute top-1 right-1.5 z-20 invisible group-hover:visible">${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Export to CSV") }, {}, {
      default: () => {
        return `<button class="p-1 rounded-lg bg-transparent transition">${validate_component(Download, "Download").$$render(
          $$result,
          {
            className: " size-3.5",
            strokeWidth: "1.5"
          },
          {},
          {}
        )}</button> `;
      }
    })}</div> </div>` : `${token.type === "blockquote" ? (() => {
      let alert = alertComponent(token);
      return ` ${alert ? `${validate_component(AlertRenderer, "AlertRenderer").$$render($$result, { token, alert }, {}, {})}` : `<blockquote dir="auto">${validate_component(MarkdownTokens, "svelte:self").$$render(
        $$result,
        {
          id: `${id}-${tokenIdx}`,
          tokens: token.tokens,
          done,
          editCodeBlock,
          onTaskClick,
          onSourceClick
        },
        {},
        {}
      )} </blockquote>`}`;
    })() : `${token.type === "list" ? `${token.ordered ? `<ol${add_attribute("start", token.start || 1, 0)} dir="auto">${each(token.items, (item, itemIdx) => {
      return `<li class="text-start">${item?.task ? `<input class="translate-y-[1px] -translate-x-1" type="checkbox" ${item.checked ? "checked" : ""}>` : ``} ${validate_component(MarkdownTokens, "svelte:self").$$render(
        $$result,
        {
          id: `${id}-${tokenIdx}-${itemIdx}`,
          tokens: item.tokens,
          top: token.loose,
          done,
          editCodeBlock,
          onTaskClick,
          onSourceClick
        },
        {},
        {}
      )} </li>`;
    })} </ol>` : `<ul dir="auto" class="">${each(token.items, (item, itemIdx) => {
      return `<li class="${"text-start " + escape(item?.task ? "flex -translate-x-6.5 gap-3 " : "", true)}">${item?.task ? `<input class="" type="checkbox" ${item.checked ? "checked" : ""}> <div>${validate_component(MarkdownTokens, "svelte:self").$$render(
        $$result,
        {
          id: `${id}-${tokenIdx}-${itemIdx}`,
          tokens: item.tokens,
          top: token.loose,
          done,
          editCodeBlock,
          onTaskClick,
          onSourceClick
        },
        {},
        {}
      )} </div>` : `${validate_component(MarkdownTokens, "svelte:self").$$render(
        $$result,
        {
          id: `${id}-${tokenIdx}-${itemIdx}`,
          tokens: item.tokens,
          top: token.loose,
          done,
          editCodeBlock,
          onTaskClick,
          onSourceClick
        },
        {},
        {}
      )}`} </li>`;
    })} </ul>`}` : `${token.type === "details" ? `${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        title: token.summary,
        open: $settings?.expandDetails ?? false,
        attributes: token?.attributes,
        className: "w-full space-y-1",
        dir: "auto"
      },
      {},
      {
        content: () => {
          return `<div class="mb-1.5" slot="content">${validate_component(MarkdownTokens, "svelte:self").$$render(
            $$result,
            {
              id: `${id}-${tokenIdx}-d`,
              tokens: marked.lexer(token.text),
              attributes: token?.attributes,
              done,
              editCodeBlock,
              onTaskClick,
              onSourceClick
            },
            {},
            {}
          )} </div>`;
        }
      }
    )}` : `${token.type === "html" ? `${validate_component(HTMLToken, "HtmlToken").$$render($$result, { id, token, onSourceClick }, {}, {})}` : `${token.type === "iframe" ? `<iframe src="${escape(WEBUI_BASE_URL, true) + "/api/v1/files/" + escape(token.fileId, true) + "/content"}"${add_attribute("title", token.fileId, 0)} width="100%" frameborder="0" onload="this.style.height=(this.contentWindow.document.body.scrollHeight+20)+'px';"></iframe>` : `${token.type === "paragraph" ? `<p dir="auto">${validate_component(MarkdownInlineTokens, "MarkdownInlineTokens").$$render(
      $$result,
      {
        id: `${id}-${tokenIdx}-p`,
        tokens: token.tokens ?? [],
        done,
        onSourceClick
      },
      {},
      {}
    )} </p>` : `${token.type === "text" ? `${top ? `<p>${token.tokens ? `${validate_component(MarkdownInlineTokens, "MarkdownInlineTokens").$$render(
      $$result,
      {
        id: `${id}-${tokenIdx}-t`,
        tokens: token.tokens,
        done,
        onSourceClick
      },
      {},
      {}
    )}` : `${escape(unescapeHtml(token.text))}`} </p>` : `${token.tokens ? `${validate_component(MarkdownInlineTokens, "MarkdownInlineTokens").$$render(
      $$result,
      {
        id: `${id}-${tokenIdx}-p`,
        tokens: token.tokens ?? [],
        done,
        onSourceClick
      },
      {},
      {}
    )}` : `${escape(unescapeHtml(token.text))}`}`}` : `${token.type === "inlineKatex" ? `${token.text ? `${validate_component(KatexRenderer, "KatexRenderer").$$render(
      $$result,
      {
        content: token.text,
        displayMode: token?.displayMode ?? false
      },
      {},
      {}
    )}` : ``}` : `${token.type === "blockKatex" ? `${token.text ? `${validate_component(KatexRenderer, "KatexRenderer").$$render(
      $$result,
      {
        content: token.text,
        displayMode: token?.displayMode ?? false
      },
      {},
      {}
    )}` : ``}` : `${token.type === "space" ? `<div class="my-2"></div>` : `${escape(/* @__PURE__ */ console.log("Unknown token", token))}`}`}`}`}`}`}`}`}`}`}`}`}`}`}`;
  })}`;
});
const Markdown = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $user, $$unsubscribe_user;
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  let { id = "" } = $$props;
  let { content } = $$props;
  let { done = true } = $$props;
  let { model = null } = $$props;
  let { save = false } = $$props;
  let { preview = false } = $$props;
  let { editCodeBlock = true } = $$props;
  let { topPadding = false } = $$props;
  let { sourceIds = [] } = $$props;
  let { onSave = () => {
  } } = $$props;
  let { onUpdate = () => {
  } } = $$props;
  let { onPreview = () => {
  } } = $$props;
  let { onSourceClick = () => {
  } } = $$props;
  let { onTaskClick = () => {
  } } = $$props;
  let tokens = [];
  const options = { throwOnError: false, breaks: true };
  marked.use(markedKatexExtension(options));
  marked.use(markedExtension(options));
  marked.use({
    extensions: [
      mentionExtension({ triggerChar: "@" }),
      mentionExtension({ triggerChar: "#" })
    ]
  });
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.content === void 0 && $$bindings.content && content !== void 0) $$bindings.content(content);
  if ($$props.done === void 0 && $$bindings.done && done !== void 0) $$bindings.done(done);
  if ($$props.model === void 0 && $$bindings.model && model !== void 0) $$bindings.model(model);
  if ($$props.save === void 0 && $$bindings.save && save !== void 0) $$bindings.save(save);
  if ($$props.preview === void 0 && $$bindings.preview && preview !== void 0) $$bindings.preview(preview);
  if ($$props.editCodeBlock === void 0 && $$bindings.editCodeBlock && editCodeBlock !== void 0) $$bindings.editCodeBlock(editCodeBlock);
  if ($$props.topPadding === void 0 && $$bindings.topPadding && topPadding !== void 0) $$bindings.topPadding(topPadding);
  if ($$props.sourceIds === void 0 && $$bindings.sourceIds && sourceIds !== void 0) $$bindings.sourceIds(sourceIds);
  if ($$props.onSave === void 0 && $$bindings.onSave && onSave !== void 0) $$bindings.onSave(onSave);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  if ($$props.onPreview === void 0 && $$bindings.onPreview && onPreview !== void 0) $$bindings.onPreview(onPreview);
  if ($$props.onSourceClick === void 0 && $$bindings.onSourceClick && onSourceClick !== void 0) $$bindings.onSourceClick(onSourceClick);
  if ($$props.onTaskClick === void 0 && $$bindings.onTaskClick && onTaskClick !== void 0) $$bindings.onTaskClick(onTaskClick);
  {
    (async () => {
      if (content) {
        tokens = marked.lexer(replaceTokens(processResponseContent(content), sourceIds, model?.name, $user?.name));
      }
    })();
  }
  $$unsubscribe_user();
  return `${validate_component(MarkdownTokens, "MarkdownTokens").$$render(
    $$result,
    {
      tokens,
      id,
      done,
      save,
      preview,
      editCodeBlock,
      topPadding,
      onTaskClick,
      onSourceClick,
      onSave,
      onUpdate,
      onPreview
    },
    {},
    {}
  )}`;
});
const FullHeightIframe = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let sandbox;
  let isUrl;
  let { src = null } = $$props;
  let { title = "Embedded Content" } = $$props;
  let { initialHeight = null } = $$props;
  let { iframeClassName = "w-full rounded-2xl" } = $$props;
  let { args = null } = $$props;
  let { allowScripts = true } = $$props;
  let { allowForms = false } = $$props;
  let { allowSameOrigin = false } = $$props;
  let { allowPopups = false } = $$props;
  let { allowDownloads = true } = $$props;
  let { referrerPolicy = "strict-origin-when-cross-origin" } = $$props;
  let { allowFullscreen = true } = $$props;
  let iframe = null;
  let iframeSrc = null;
  let iframeDoc = null;
  const setIframeSrc = async () => {
    await tick();
    if (isUrl) {
      iframeSrc = src;
      iframeDoc = null;
    } else {
      iframeDoc = await processHtmlForDeps(src);
      iframeSrc = null;
    }
  };
  const alpineDirectives = [
    "x-data",
    "x-init",
    "x-show",
    "x-bind",
    "x-on",
    "x-text",
    "x-html",
    "x-model",
    "x-modelable",
    "x-ref",
    "x-for",
    "x-if",
    "x-effect",
    "x-transition",
    "x-cloak",
    "x-ignore",
    "x-teleport",
    "x-id"
  ];
  async function processHtmlForDeps(html) {
    if (!allowSameOrigin) return html;
    const scriptTags = [];
    const hasAlpineDirectives = alpineDirectives.some((dir) => html.includes(dir));
    if (hasAlpineDirectives) {
      try {
        const { default: alpineCode } = await import("./cdn.min.js");
        const alpineBlob = new Blob([alpineCode], { type: "text/javascript" });
        const alpineUrl = URL.createObjectURL(alpineBlob);
        const alpineTag = `<script src="${alpineUrl}" defer><\/script>`;
        scriptTags.push(alpineTag);
      } catch (error) {
        /* @__PURE__ */ console.error("Error processing Alpine for iframe:", error);
      }
    }
    const chartJsDirectives = ["new Chart(", "Chart."];
    const hasChartJsDirectives = chartJsDirectives.some((dir) => html.includes(dir));
    if (hasChartJsDirectives) {
      try {
        const { default: Chart } = await import("chart.js/auto");
        window.Chart = Chart;
        const chartTag = `<script>
window.Chart = parent.Chart; // Chart previously assigned on parent
<\/script>`;
        scriptTags.push(chartTag);
      } catch (error) {
        /* @__PURE__ */ console.error("Error processing Chart.js for iframe:", error);
      }
    }
    if (scriptTags.length === 0) return html;
    const tags = scriptTags.join("\n");
    if (html.includes("</head>")) {
      return html.replace("</head>", `${tags}
</head>`);
    }
    if (html.includes("</body>")) {
      return html.replace("</body>", `${tags}
</body>`);
    }
    return `${tags}
${html}`;
  }
  function onMessage(e) {
    return;
  }
  onDestroy(() => {
    window.removeEventListener("message", onMessage);
  });
  if ($$props.src === void 0 && $$bindings.src && src !== void 0) $$bindings.src(src);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0) $$bindings.title(title);
  if ($$props.initialHeight === void 0 && $$bindings.initialHeight && initialHeight !== void 0) $$bindings.initialHeight(initialHeight);
  if ($$props.iframeClassName === void 0 && $$bindings.iframeClassName && iframeClassName !== void 0) $$bindings.iframeClassName(iframeClassName);
  if ($$props.args === void 0 && $$bindings.args && args !== void 0) $$bindings.args(args);
  if ($$props.allowScripts === void 0 && $$bindings.allowScripts && allowScripts !== void 0) $$bindings.allowScripts(allowScripts);
  if ($$props.allowForms === void 0 && $$bindings.allowForms && allowForms !== void 0) $$bindings.allowForms(allowForms);
  if ($$props.allowSameOrigin === void 0 && $$bindings.allowSameOrigin && allowSameOrigin !== void 0) $$bindings.allowSameOrigin(allowSameOrigin);
  if ($$props.allowPopups === void 0 && $$bindings.allowPopups && allowPopups !== void 0) $$bindings.allowPopups(allowPopups);
  if ($$props.allowDownloads === void 0 && $$bindings.allowDownloads && allowDownloads !== void 0) $$bindings.allowDownloads(allowDownloads);
  if ($$props.referrerPolicy === void 0 && $$bindings.referrerPolicy && referrerPolicy !== void 0) $$bindings.referrerPolicy(referrerPolicy);
  if ($$props.allowFullscreen === void 0 && $$bindings.allowFullscreen && allowFullscreen !== void 0) $$bindings.allowFullscreen(allowFullscreen);
  sandbox = [
    allowScripts && "allow-scripts",
    allowForms && "allow-forms",
    allowSameOrigin && "allow-same-origin",
    allowPopups && "allow-popups",
    allowDownloads && "allow-downloads"
  ].filter(Boolean).join(" ") || void 0;
  isUrl = typeof src === "string" && /^(https?:)?\/\//i.test(src);
  {
    if (src) {
      setIframeSrc();
    }
  }
  return `${iframeDoc ? `<iframe${add_attribute("srcdoc", iframeDoc, 0)}${add_attribute("title", title, 0)}${add_attribute("class", iframeClassName, 0)}${add_attribute("style", `${initialHeight ? `height:${initialHeight}px;` : ""}`, 0)} width="100%" frameborder="0"${add_attribute("sandbox", sandbox, 0)} ${allowFullscreen ? "allowfullscreen" : ""}${add_attribute("this", iframe, 0)}></iframe>` : `${iframeSrc ? `<iframe${add_attribute("src", iframeSrc, 0)}${add_attribute("title", title, 0)}${add_attribute("class", iframeClassName, 0)}${add_attribute("style", `${initialHeight ? `height:${initialHeight}px;` : ""}`, 0)} width="100%" frameborder="0"${add_attribute("sandbox", sandbox, 0)}${add_attribute("referrerpolicy", referrerPolicy, 0)} ${allowFullscreen ? "allowfullscreen" : ""}${add_attribute("this", iframe, 0)}></iframe>` : ``}`}`;
});
function parseJSONString(str) {
  try {
    return parseJSONString(JSON.parse(str));
  } catch (e) {
    return str;
  }
}
function formatJSONString(str) {
  try {
    const parsed = parseJSONString(str);
    if (typeof parsed === "object") {
      return JSON.stringify(parsed, null, 2);
    } else {
      return `${JSON.stringify(String(parsed))}`;
    }
  } catch (e) {
    return str;
  }
}
const Collapsible = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  dayjs.extend(duration);
  dayjs.extend(relativeTime);
  async function loadLocale(locales) {
    if (!locales || !Array.isArray(locales)) {
      return;
    }
    for (const locale of locales) {
      try {
        dayjs.locale(locale);
        break;
      } catch (error) {
        /* @__PURE__ */ console.error(`Could not load locale '${locale}':`, error);
      }
    }
  }
  let { open = false } = $$props;
  let { className = "" } = $$props;
  let { buttonClassName = "w-fit text-gray-500 hover:text-gray-700 dark:hover:text-gray-300 transition" } = $$props;
  let { id = "" } = $$props;
  let { title = null } = $$props;
  let { attributes = null } = $$props;
  let { chevron = false } = $$props;
  let { grow = false } = $$props;
  let { disabled = false } = $$props;
  let { hide = false } = $$props;
  let { onChange = () => {
  } } = $$props;
  const collapsibleId = v4();
  if ($$props.open === void 0 && $$bindings.open && open !== void 0) $$bindings.open(open);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.buttonClassName === void 0 && $$bindings.buttonClassName && buttonClassName !== void 0) $$bindings.buttonClassName(buttonClassName);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0) $$bindings.title(title);
  if ($$props.attributes === void 0 && $$bindings.attributes && attributes !== void 0) $$bindings.attributes(attributes);
  if ($$props.chevron === void 0 && $$bindings.chevron && chevron !== void 0) $$bindings.chevron(chevron);
  if ($$props.grow === void 0 && $$bindings.grow && grow !== void 0) $$bindings.grow(grow);
  if ($$props.disabled === void 0 && $$bindings.disabled && disabled !== void 0) $$bindings.disabled(disabled);
  if ($$props.hide === void 0 && $$bindings.hide && hide !== void 0) $$bindings.hide(hide);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  {
    loadLocale($i18n.languages);
  }
  {
    onChange(open);
  }
  $$unsubscribe_i18n();
  return `<div${add_attribute("id", id, 0)}${add_attribute("class", className, 0)}>${attributes?.type === "tool_calls" ? (() => {
    let args = decode(attributes?.arguments), result = decode(attributes?.result ?? ""), files = parseJSONString(decode(attributes?.files ?? "")), embeds = parseJSONString(decode(attributes?.embeds ?? ""));
    return `    ${embeds && Array.isArray(embeds) && embeds.length > 0 ? `<div class="py-1 w-full cursor-pointer"><div class="w-full text-xs text-gray-500"><div class="">${escape(attributes.name)}</div></div> ${each(embeds, (embed, idx) => {
      return `<div class="my-2"${add_attribute("id", `${collapsibleId}-tool-calls-${attributes?.id}-embed-${idx}`, 0)}>${validate_component(FullHeightIframe, "FullHeightIframe").$$render(
        $$result,
        {
          src: embed,
          args,
          allowScripts: true,
          allowForms: true,
          allowSameOrigin: true,
          allowPopups: true
        },
        {},
        {}
      )} </div>`;
    })}</div>` : `<div class="${escape(buttonClassName, true) + " cursor-pointer"}"><div class="${"w-full font-medium flex items-center justify-between gap-2 " + escape(
      attributes?.done && attributes?.done !== "true" ? "shimmer" : "",
      true
    )}">${attributes?.done && attributes?.done !== "true" ? `<div>${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-4" }, {}, {})}</div>` : ``} <div class="">${attributes?.done === "true" ? `${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id: `${collapsibleId}-tool-calls-${attributes?.id}`,
        content: $i18n.t("View Result from **{{NAME}}**", { NAME: attributes.name })
      },
      {},
      {}
    )}` : `${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id: `${collapsibleId}-tool-calls-${attributes?.id}-executing`,
        content: $i18n.t("Executing **{{NAME}}**...", { NAME: attributes.name })
      },
      {},
      {}
    )}`}</div> <div class="flex self-center translate-y-[1px]">${open ? `${validate_component(ChevronUp, "ChevronUp").$$render(
      $$result,
      {
        strokeWidth: "3.5",
        className: "size-3.5"
      },
      {},
      {}
    )}` : `${validate_component(ChevronDown, "ChevronDown").$$render(
      $$result,
      {
        strokeWidth: "3.5",
        className: "size-3.5"
      },
      {},
      {}
    )}`}</div></div></div> ${!grow ? `${open && !hide ? `<div>${attributes?.type === "tool_calls" ? `${attributes?.done === "true" ? `${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id: `${collapsibleId}-tool-calls-${attributes?.id}-result`,
        content: `> \`\`\`json
> ${formatJSONString(args)}
> ${formatJSONString(result)}
> \`\`\``
      },
      {},
      {}
    )}` : `${validate_component(Markdown, "Markdown").$$render(
      $$result,
      {
        id: `${collapsibleId}-tool-calls-${attributes?.id}-result`,
        content: `> \`\`\`json
> ${formatJSONString(args)}
> \`\`\``
      },
      {},
      {}
    )}`}` : `${slots.content ? slots.content({}) : ``}`}</div>` : ``}` : ``}`} ${attributes?.done === "true" ? `${typeof files === "object" ? `${each(files ?? [], (file, idx) => {
      return `${typeof file === "string" ? `${file.startsWith("data:image/") ? `${validate_component(Image, "Image").$$render(
        $$result,
        {
          id: `${collapsibleId}-tool-calls-${attributes?.id}-result-${idx}`,
          src: file,
          alt: "Image"
        },
        {},
        {}
      )}` : ``}` : `${typeof file === "object" ? `${file.type === "image" && file.url ? `${validate_component(Image, "Image").$$render(
        $$result,
        {
          id: `${collapsibleId}-tool-calls-${attributes?.id}-result-${idx}`,
          src: file.url,
          alt: "Image"
        },
        {},
        {}
      )}` : ``}` : ``}`}`;
    })}` : ``}` : ``}`;
  })() : `${title !== null ? `  <div class="${escape(buttonClassName, true) + " cursor-pointer"}"><div class="${"w-full font-medium flex items-center justify-between gap-2 " + escape(
    attributes?.done && attributes?.done !== "true" ? "shimmer" : "",
    true
  )}">${attributes?.done && attributes?.done !== "true" ? `<div>${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-4" }, {}, {})}</div>` : ``} <div class="">${attributes?.type === "reasoning" ? `${attributes?.done === "true" && attributes?.duration ? `${attributes.duration < 1 ? `${escape($i18n.t("Thought for less than a second"))}` : `${attributes.duration < 60 ? `${escape($i18n.t("Thought for {{DURATION}} seconds", { DURATION: attributes.duration }))}` : `${escape($i18n.t("Thought for {{DURATION}}", {
    DURATION: dayjs.duration(attributes.duration, "seconds").humanize()
  }))}`}`}` : `${escape($i18n.t("Thinking..."))}`}` : `${attributes?.type === "code_interpreter" ? `${attributes?.done === "true" ? `${escape($i18n.t("Analyzed"))}` : `${escape($i18n.t("Analyzing..."))}`}` : `${escape(title)}`}`}</div> <div class="flex self-center translate-y-[1px]">${open ? `${validate_component(ChevronUp, "ChevronUp").$$render(
    $$result,
    {
      strokeWidth: "3.5",
      className: "size-3.5"
    },
    {},
    {}
  )}` : `${validate_component(ChevronDown, "ChevronDown").$$render(
    $$result,
    {
      strokeWidth: "3.5",
      className: "size-3.5"
    },
    {},
    {}
  )}`}</div></div></div>` : `  <div class="${escape(buttonClassName, true) + " cursor-pointer"}"><div><div class="flex items-start justify-between">${slots.default ? slots.default({}) : ``} ${chevron ? `<div class="flex self-start translate-y-1">${open ? `${validate_component(ChevronUp, "ChevronUp").$$render(
    $$result,
    {
      strokeWidth: "3.5",
      className: "size-3.5"
    },
    {},
    {}
  )}` : `${validate_component(ChevronDown, "ChevronDown").$$render(
    $$result,
    {
      strokeWidth: "3.5",
      className: "size-3.5"
    },
    {},
    {}
  )}`}</div>` : ``}</div> ${grow ? `${open && !hide ? `<div>${slots.content ? slots.content({}) : ``}</div>` : ``}` : ``}</div></div>`} ${!grow ? `${open && !hide ? `<div>${slots.content ? slots.content({}) : ``}</div>` : ``}` : ``}`}</div>`;
});
export {
  Bolt as B,
  Collapsible as C,
  FullHeightIframe as F,
  Image as I,
  Link_preview as L,
  Markdown as M,
  SVGPanZoom as S,
  UserStatusLinkPreview as U,
  Clipboard as a,
  Link_preview_trigger as b,
  Info as c,
  CodeBlock as d,
  LightBulb as e
};
//# sourceMappingURL=Collapsible.js.map
