import { c as create_ssr_component, l as getContext, b as subscribe, v as validate_component, g as escape, a as add_attribute, e as each, p as createEventDispatcher, o as onDestroy, m as missing_component, q as null_to_empty } from "../../../chunks/ssr.js";
import { a as toast } from "../../../chunks/Toaster.svelte_svelte_type_style_lang.js";
import "idb";
import fileSaver from "file-saver";
import { g as goto } from "../../../chunks/client.js";
import { p as page } from "../../../chunks/stores.js";
import { c as createMessagesList } from "../../../chunks/index2.js";
import "yaml";
import { a as settings, u as user, j as folders, b as currentChatPage, d as chatId, k as selectedFolder, m as mobile, l as chats, p as pinnedChats, n as showSidebar, o as tags, c as config, h as WEBUI_BASE_URL, q as models, r as showArchivedChats, s as socket, f as isApp, v as showSearch, W as WEBUI_NAME, w as channels, x as scrollPaginationEnabled, y as WEBUI_VERSION, t as temporaryChatEnabled, z as showShortcuts, A as showSettings, B as showChangelog } from "../../../chunks/index.js";
import { t as tick } from "../../../chunks/ssr2.js";
import { v4 } from "uuid";
import { g as getArchivedChatList, a as archiveChatById, b as getChatPinnedStatusById, c as cloneChatById, d as getChatList, e as getPinnedChatList, u as updateChatFolderIdById, f as getChatListByFolderId, h as getChatsByFolderId, M as Messages, i as getChatListBySearchText, j as getChatById, k as getAllTags, l as importChat } from "../../../chunks/Messages.js";
import { F as Folder$1, S as ShareChatModal, a as FolderModal, b as FolderMenu, u as updateFolderById, g as getFolderById, c as createNewFolder, d as getFolders } from "../../../chunks/FolderModal.js";
import dayjs from "dayjs";
import localizedFormat from "dayjs/plugin/localizedFormat.js";
import { M as Modal } from "../../../chunks/Modal.js";
import { T as Tooltip } from "../../../chunks/Tooltip.js";
import { C as ConfirmDialog } from "../../../chunks/ConfirmDialog.js";
import { S as Spinner } from "../../../chunks/Spinner.js";
import { L as Loader } from "../../../chunks/ProfileImage.js";
import { X as XMark } from "../../../chunks/XMark.js";
import { C as ChevronUp } from "../../../chunks/ChevronUp.js";
import { C as ChevronDown } from "../../../chunks/ChevronDown.js";
import { A as ArchiveBox, U as UserMenu } from "../../../chunks/UserMenu.js";
import "dequal";
import "../../../chunks/create.js";
import { M as Menu_sub, a as Menu_sub_trigger, b as Menu_sub_content } from "../../../chunks/menu-sub-trigger.js";
import { M as Menu_content, a as Menu_item } from "../../../chunks/menu-trigger.js";
import { f as flyAndScale } from "../../../chunks/index4.js";
import { D as Dropdown } from "../../../chunks/Dropdown.js";
import { G as GarbageBin } from "../../../chunks/GarbageBin.js";
import { P as Pencil } from "../../../chunks/Pencil.js";
import { S as Share } from "../../../chunks/Share.js";
import { D as DocumentDuplicate } from "../../../chunks/DocumentDuplicate.js";
import { D as Download } from "../../../chunks/Download.js";
import "../../../chunks/FileItem.js";
import "panzoom";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import "dayjs/plugin/duration.js";
import "dayjs/plugin/relativeTime.js";
import { C as Collapsible } from "../../../chunks/Collapsible.js";
import DOMPurify from "dompurify";
import { marked } from "marked";
/* empty css                                                          */
/* empty css                                                  */
import "i18next";
import { S as Sparkles } from "../../../chunks/Sparkles.js";
import { C as ChevronRight } from "../../../chunks/ChevronRight.js";
import { P as Plus } from "../../../chunks/Plus.js";
import { E as EllipsisHorizontal } from "../../../chunks/EllipsisHorizontal.js";
import { E as Emoji } from "../../../chunks/Emoji.js";
import { u as updateChannelById, c as createNewChannel, g as getChannels } from "../../../chunks/index5.js";
import { A as AccessControl } from "../../../chunks/AccessControl.js";
import { C as Cog6 } from "../../../chunks/Cog6.js";
import { P as PencilSquare } from "../../../chunks/PencilSquare.js";
import { S as Search } from "../../../chunks/Search.js";
import calendar from "dayjs/plugin/calendar.js";
import { S as Sidebar } from "../../../chunks/Sidebar.js";
import "sortablejs";
import { u as updateUserSettings } from "../../../chunks/index6.js";
import { g as getModels, a as getChangelog } from "../../../chunks/index7.js";
import "../../../chunks/index3.js";
import { T as Textarea } from "../../../chunks/Textarea.js";
import "@sveltejs/kit";
import { L as Link } from "../../../chunks/Link.js";
const ChatsModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  dayjs.extend(localizedFormat);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { title = "Chats" } = $$props;
  let { emptyPlaceholder = "" } = $$props;
  let { shareUrl = false } = $$props;
  let { query = "" } = $$props;
  let { orderBy = "updated_at" } = $$props;
  let { direction = "desc" } = $$props;
  let { chatList = null } = $$props;
  let { allChatsLoaded = false } = $$props;
  let { chatListLoading = false } = $$props;
  let showDeleteConfirmDialog = false;
  let { onUpdate = () => {
  } } = $$props;
  let { loadHandler = null } = $$props;
  let { unarchiveHandler = null } = $$props;
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0) $$bindings.title(title);
  if ($$props.emptyPlaceholder === void 0 && $$bindings.emptyPlaceholder && emptyPlaceholder !== void 0) $$bindings.emptyPlaceholder(emptyPlaceholder);
  if ($$props.shareUrl === void 0 && $$bindings.shareUrl && shareUrl !== void 0) $$bindings.shareUrl(shareUrl);
  if ($$props.query === void 0 && $$bindings.query && query !== void 0) $$bindings.query(query);
  if ($$props.orderBy === void 0 && $$bindings.orderBy && orderBy !== void 0) $$bindings.orderBy(orderBy);
  if ($$props.direction === void 0 && $$bindings.direction && direction !== void 0) $$bindings.direction(direction);
  if ($$props.chatList === void 0 && $$bindings.chatList && chatList !== void 0) $$bindings.chatList(chatList);
  if ($$props.allChatsLoaded === void 0 && $$bindings.allChatsLoaded && allChatsLoaded !== void 0) $$bindings.allChatsLoaded(allChatsLoaded);
  if ($$props.chatListLoading === void 0 && $$bindings.chatListLoading && chatListLoading !== void 0) $$bindings.chatListLoading(chatListLoading);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  if ($$props.loadHandler === void 0 && $$bindings.loadHandler && loadHandler !== void 0) $$bindings.loadHandler(loadHandler);
  if ($$props.unarchiveHandler === void 0 && $$bindings.unarchiveHandler && unarchiveHandler !== void 0) $$bindings.unarchiveHandler(unarchiveHandler);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(ConfirmDialog, "ConfirmDialog").$$render(
      $$result,
      { show: showDeleteConfirmDialog },
      {
        show: ($$value) => {
          showDeleteConfirmDialog = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "lg", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-1"><div class="text-lg font-medium self-center">${escape(title)}</div> <button class="self-center" data-svelte-h="svelte-i7w487"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="w-5 h-5"><path fill-rule="evenodd" d="M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" clip-rule="evenodd"></path></svg></button></div> <div class="flex flex-col w-full px-5 pb-4 dark:text-gray-200"><div class="flex w-full space-x-2 mb-0.5"><div class="flex flex-1"><div class="self-center ml-1 mr-3" data-svelte-h="svelte-kinl2y"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="w-4 h-4"><path fill-rule="evenodd" d="M9 3.5a5.5 5.5 0 100 11 5.5 5.5 0 000-11zM2 9a7 7 0 1112.452 4.391l3.328 3.329a.75.75 0 11-1.06 1.06l-3.329-3.328A7 7 0 012 9z" clip-rule="evenodd"></path></svg></div> <input class="w-full text-sm pr-4 py-1 rounded-r-xl outline-hidden bg-transparent"${add_attribute("placeholder", $i18n.t("Search Chats"), 0)}${add_attribute("value", query, 0)}> ${query ? `<div class="self-center pl-1.5 pr-1 translate-y-[0.5px] rounded-l-xl bg-transparent"><button class="p-0.5 rounded-full hover:bg-gray-100 dark:hover:bg-gray-900 transition">${validate_component(XMark, "XMark").$$render($$result, { className: "size-3", strokeWidth: "2" }, {}, {})}</button></div>` : ``}</div></div> <div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6">${chatList ? `<div class="w-full">${chatList.length > 0 ? `<div class="flex text-xs font-medium mb-1.5"><button class="px-1.5 py-1 cursor-pointer select-none basis-3/5"><div class="flex gap-1.5 items-center">${escape($i18n.t("Title"))} ${orderBy === "title" ? `<span class="font-normal">${direction === "asc" ? ` ${validate_component(ChevronUp, "ChevronUp").$$render($$result, { className: "size-2" }, {}, {})}` : ` ${validate_component(ChevronDown, "ChevronDown").$$render($$result, { className: "size-2" }, {}, {})}`}</span>` : `<span class="invisible">${validate_component(ChevronUp, "ChevronUp").$$render($$result, { className: "size-2" }, {}, {})}</span>`}</div></button> <button class="px-1.5 py-1 cursor-pointer select-none hidden sm:flex sm:basis-2/5 justify-end"><div class="flex gap-1.5 items-center">${escape($i18n.t("Updated at"))} ${orderBy === "updated_at" ? `<span class="font-normal">${direction === "asc" ? ` ${validate_component(ChevronUp, "ChevronUp").$$render($$result, { className: "size-2" }, {}, {})}` : ` ${validate_component(ChevronDown, "ChevronDown").$$render($$result, { className: "size-2" }, {}, {})}`}</span>` : `<span class="invisible">${validate_component(ChevronUp, "ChevronUp").$$render($$result, { className: "size-2" }, {}, {})}</span>`}</div></button></div>` : ``} <div class="text-left text-sm w-full mb-3 max-h-[22rem] overflow-y-scroll">${chatList.length === 0 ? `<div class="text-xs text-gray-500 dark:text-gray-400 text-center px-5 min-h-20 w-full h-full flex justify-center items-center">${escape($i18n.t("No results found"))}</div>` : ``} ${each(chatList, (chat, idx) => {
            return `${(idx === 0 || idx > 0 && chat.time_range !== chatList[idx - 1].time_range) && chat?.time_range ? `<div class="${"w-full text-xs text-gray-500 dark:text-gray-500 font-medium " + escape(idx === 0 ? "" : "pt-5", true) + " pb-2 px-2"}">${escape($i18n.t(chat.time_range))}  </div>` : ``} <div class="w-full flex justify-between items-center rounded-lg text-sm py-2 px-3 hover:bg-gray-50 dark:hover:bg-gray-850" draggable="false"><a class="basis-3/5"${add_attribute("href", shareUrl ? `/s/${chat.id}` : `/c/${chat.id}`, 0)}><div class="text-ellipsis line-clamp-1 w-full">${escape(chat?.title)} </div></a> <div class="basis-2/5 flex items-center justify-end"><div class="hidden sm:flex text-gray-500 dark:text-gray-400 text-xs">${escape(dayjs(chat?.updated_at * 1e3).calendar())}</div> <div class="flex justify-end pl-2.5 text-gray-600 dark:text-gray-300">${unarchiveHandler ? `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Unarchive Chat") }, {}, {
              default: () => {
                return `<button class="self-center w-fit px-1 text-sm rounded-xl" data-svelte-h="svelte-akwxe0"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4"><path stroke-linecap="round" stroke-linejoin="round" d="M9 8.25H7.5a2.25 2.25 0 0 0-2.25 2.25v9a2.25 2.25 0 0 0 2.25 2.25h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25H15m0-3-3-3m0 0-3 3m3-3V15"></path></svg></button> `;
              }
            })}` : ``} ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Delete Chat") }, {}, {
              default: () => {
                return `<button class="self-center w-fit px-1 text-sm rounded-xl" data-svelte-h="svelte-uod23x"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path></svg></button> `;
              }
            })} </div></div> </div>`;
          })} ${!allChatsLoaded && loadHandler ? `${validate_component(Loader, "Loader").$$render($$result, {}, {}, {
            default: () => {
              return `<div class="w-full flex justify-center py-1 text-xs animate-pulse items-center gap-2">${validate_component(Spinner, "Spinner").$$render($$result, { className: " size-4" }, {}, {})} <div class="">${escape($i18n.t("Loading..."))}</div></div>`;
            }
          })}` : ``}</div> ${query === "" ? `${slots.footer ? slots.footer({}) : ``}` : ``}</div>` : `<div class="w-full h-full flex justify-center items-center min-h-20">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</div>`} </div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const ArchivedChatsModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { onUpdate = () => {
  } } = $$props;
  let chatList = null;
  let page2 = 1;
  let query = "";
  let orderBy = "updated_at";
  let direction = "desc";
  let allChatsLoaded = false;
  let chatListLoading = false;
  let searchDebounceTimeout;
  let showUnarchiveAllConfirmDialog = false;
  let filter = {};
  const searchHandler = async () => {
    if (!show) {
      return;
    }
    if (searchDebounceTimeout) {
      clearTimeout(searchDebounceTimeout);
    }
    page2 = 1;
    chatList = null;
    if (query === "") {
      chatList = await getArchivedChatList(localStorage.token, page2, filter);
    } else {
      searchDebounceTimeout = setTimeout(
        async () => {
          chatList = await getArchivedChatList(localStorage.token, page2, filter);
        },
        500
      );
    }
    if ((chatList ?? []).length === 0) {
      allChatsLoaded = true;
    } else {
      allChatsLoaded = false;
    }
  };
  const loadMoreChats = async () => {
    chatListLoading = true;
    page2 += 1;
    let newChatList = [];
    if (query) {
      newChatList = await getArchivedChatList(localStorage.token, page2, filter);
    } else {
      newChatList = await getArchivedChatList(localStorage.token, page2, filter);
    }
    allChatsLoaded = newChatList.length === 0;
    if (newChatList.length > 0) {
      chatList = [...chatList, ...newChatList];
    }
    chatListLoading = false;
  };
  const unarchiveHandler = async (chatId2) => {
    await archiveChatById(localStorage.token, chatId2).catch((error) => {
      toast.error(`${error}`);
    });
    onUpdate();
    init();
  };
  const init = async () => {
    chatList = await getArchivedChatList(localStorage.token);
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    filter = {
      ...query ? { query } : {},
      ...orderBy ? { order_by: orderBy } : {},
      ...direction ? { direction } : {}
    };
    {
      if (filter !== null) {
        searchHandler();
      }
    }
    {
      if (show) {
        init();
      }
    }
    $$rendered = `${validate_component(ConfirmDialog, "UnarchiveAllConfirmDialog").$$render(
      $$result,
      {
        message: $i18n.t("Are you sure you want to unarchive all archived chats?"),
        confirmLabel: $i18n.t("Unarchive All"),
        show: showUnarchiveAllConfirmDialog
      },
      {
        show: ($$value) => {
          showUnarchiveAllConfirmDialog = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(ChatsModal, "ChatsModal").$$render(
      $$result,
      {
        title: $i18n.t("Archived Chats"),
        emptyPlaceholder: $i18n.t("You have no archived conversations."),
        chatList,
        allChatsLoaded,
        chatListLoading,
        onUpdate: () => {
          init();
        },
        loadHandler: loadMoreChats,
        unarchiveHandler,
        show,
        query,
        orderBy,
        direction
      },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        },
        query: ($$value) => {
          query = $$value;
          $$settled = false;
        },
        orderBy: ($$value) => {
          orderBy = $$value;
          $$settled = false;
        },
        direction: ($$value) => {
          direction = $$value;
          $$settled = false;
        }
      },
      {
        footer: () => {
          return `<div slot="footer"><div class="flex flex-wrap text-sm font-medium gap-1.5 mt-2 m-1 justify-end w-full"><button class="px-3.5 py-1.5 font-medium hover:bg-black/5 dark:hover:bg-white/5 outline outline-1 outline-gray-100 dark:outline-gray-800 rounded-3xl" ${""}>${`${escape($i18n.t("Unarchive All Archived Chats"))}`}</button> <button class="px-3.5 py-1.5 font-medium hover:bg-black/5 dark:hover:bg-white/5 outline outline-1 outline-gray-100 dark:outline-gray-800 rounded-3xl" ${""}>${escape($i18n.t("Export All Archived Chats"))}</button></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const Bookmark = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M17.593 3.322c1.1.128 1.907 1.077 1.907 2.185V21L12 17.25 4.5 21V5.507c0-1.108.806-2.057 1.907-2.185a48.507 48.507 0 0 1 11.186 0Z"></path></svg>`;
});
const BookmarkSlash = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="m3 3 1.664 1.664M21 21l-1.5-1.5m-5.485-1.242L12 17.25 4.5 21V8.742m.164-4.078a2.15 2.15 0 0 1 1.743-1.342 48.507 48.507 0 0 1 11.186 0c1.1.128 1.907 1.077 1.907 2.185V19.5M4.664 4.664 19.5 19.5"></path></svg>`;
});
const ChatMenu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_settings;
  let $user, $$unsubscribe_user;
  let $i18n, $$unsubscribe_i18n;
  let $folders, $$unsubscribe_folders;
  $$unsubscribe_settings = subscribe(settings, (value) => value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_folders = subscribe(folders, (value) => $folders = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { shareHandler } = $$props;
  let { moveChatHandler } = $$props;
  let { cloneChatHandler } = $$props;
  let { archiveChatHandler } = $$props;
  let { renameHandler } = $$props;
  let { deleteHandler } = $$props;
  let { onClose } = $$props;
  let { chatId: chatId2 = "" } = $$props;
  let show = false;
  let pinned = false;
  const checkPinned = async () => {
    pinned = await getChatPinnedStatusById(localStorage.token, chatId2);
  };
  if ($$props.shareHandler === void 0 && $$bindings.shareHandler && shareHandler !== void 0) $$bindings.shareHandler(shareHandler);
  if ($$props.moveChatHandler === void 0 && $$bindings.moveChatHandler && moveChatHandler !== void 0) $$bindings.moveChatHandler(moveChatHandler);
  if ($$props.cloneChatHandler === void 0 && $$bindings.cloneChatHandler && cloneChatHandler !== void 0) $$bindings.cloneChatHandler(cloneChatHandler);
  if ($$props.archiveChatHandler === void 0 && $$bindings.archiveChatHandler && archiveChatHandler !== void 0) $$bindings.archiveChatHandler(archiveChatHandler);
  if ($$props.renameHandler === void 0 && $$bindings.renameHandler && renameHandler !== void 0) $$bindings.renameHandler(renameHandler);
  if ($$props.deleteHandler === void 0 && $$bindings.deleteHandler && deleteHandler !== void 0) $$bindings.deleteHandler(deleteHandler);
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId2 !== void 0) $$bindings.chatId(chatId2);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        checkPinned();
      }
    }
    $$rendered = `${``} ${validate_component(Dropdown, "Dropdown").$$render(
      $$result,
      { show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div slot="content">${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full max-w-[200px] rounded-2xl px-1 py-1  border border-gray-100  dark:border-gray-800 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg transition",
              sideOffset: -2,
              side: "bottom",
              align: "start",
              transition: flyAndScale
            },
            {},
            {
              default: () => {
                return `${$user?.role === "admin" || ($user.permissions?.chat?.share ?? true) ? `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800  rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(Share, "Share").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Share"))}</div>`;
                    }
                  }
                )}` : ``} ${validate_component(Menu_sub, "DropdownMenu.Sub").$$render($$result, {}, {}, {
                  default: () => {
                    return `${validate_component(Menu_sub_trigger, "DropdownMenu.SubTrigger").$$render(
                      $$result,
                      {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                      },
                      {},
                      {
                        default: () => {
                          return `${validate_component(Download, "Download").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Download"))}</div>`;
                        }
                      }
                    )} ${validate_component(Menu_sub_content, "DropdownMenu.SubContent").$$render(
                      $$result,
                      {
                        class: "w-full rounded-2xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg border border-gray-100  dark:border-gray-800",
                        transition: flyAndScale,
                        sideOffset: 8
                      },
                      {},
                      {
                        default: () => {
                          return `${$user?.role === "admin" || ($user.permissions?.chat?.export ?? true) ? `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                            },
                            {},
                            {
                              default: () => {
                                return `<div class="flex items-center line-clamp-1">${escape($i18n.t("Export chat (.json)"))}</div>`;
                              }
                            }
                          )}` : ``} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                            },
                            {},
                            {
                              default: () => {
                                return `<div class="flex items-center line-clamp-1">${escape($i18n.t("Plain text (.txt)"))}</div>`;
                              }
                            }
                          )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                            $$result,
                            {
                              class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full"
                            },
                            {},
                            {
                              default: () => {
                                return `<div class="flex items-center line-clamp-1">${escape($i18n.t("PDF document (.pdf)"))}</div>`;
                              }
                            }
                          )}`;
                        }
                      }
                    )}`;
                  }
                })} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(Pencil, "Pencil").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Rename"))}</div>`;
                    }
                  }
                )} <hr class="border-gray-50 dark:border-gray-800 my-1"> ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${pinned ? `${validate_component(BookmarkSlash, "BookmarkSlash").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Unpin"))}</div>` : `${validate_component(Bookmark, "Bookmark").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Pin"))}</div>`}`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(DocumentDuplicate, "DocumentDuplicate").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Clone"))}</div>`;
                    }
                  }
                )} ${chatId2 ? `${validate_component(Menu_sub, "DropdownMenu.Sub").$$render($$result, {}, {}, {
                  default: () => {
                    return `${validate_component(Menu_sub_trigger, "DropdownMenu.SubTrigger").$$render(
                      $$result,
                      {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full"
                      },
                      {},
                      {
                        default: () => {
                          return `${validate_component(Folder$1, "Folder").$$render($$result, {}, {}, {})} <div class="flex items-center">${escape($i18n.t("Move"))}</div>`;
                        }
                      }
                    )} ${validate_component(Menu_sub_content, "DropdownMenu.SubContent").$$render(
                      $$result,
                      {
                        class: "w-full rounded-2xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white border border-gray-100  dark:border-gray-800 shadow-lg max-h-52 overflow-y-auto scrollbar-hidden",
                        transition: flyAndScale,
                        sideOffset: 8
                      },
                      {},
                      {
                        default: () => {
                          return `${each($folders.sort((a, b) => b.updated_at - a.updated_at), (folder) => {
                            return `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                              $$result,
                              {
                                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                              },
                              {},
                              {
                                default: () => {
                                  return `${validate_component(Folder$1, "Folder").$$render($$result, {}, {}, {})} <div class="flex items-center">${escape(folder?.name ?? "Folder")}</div> `;
                                }
                              }
                            )}`;
                          })}`;
                        }
                      }
                    )}`;
                  }
                })}` : ``} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(ArchiveBox, "ArchiveBox").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Archive"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex  gap-2  items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(GarbageBin, "GarbageBin").$$render($$result, { strokeWidth: "1.5" }, {}, {})} <div class="flex items-center">${escape($i18n.t("Delete"))}</div>`;
                    }
                  }
                )}`;
              }
            }
          )}</div>`;
        },
        default: () => {
          return `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("More") }, {}, {
            default: () => {
              return `${slots.default ? slots.default({}) : ``}`;
            }
          })}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_settings();
  $$unsubscribe_user();
  $$unsubscribe_i18n();
  $$unsubscribe_folders();
  return $$rendered;
});
const ChatItem = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $currentChatPage, $$unsubscribe_currentChatPage;
  let $chatId, $$unsubscribe_chatId;
  let $$unsubscribe_selectedFolder;
  let $$unsubscribe_mobile;
  $$unsubscribe_currentChatPage = subscribe(currentChatPage, (value) => $currentChatPage = value);
  $$unsubscribe_chatId = subscribe(chatId, (value) => $chatId = value);
  $$unsubscribe_selectedFolder = subscribe(selectedFolder, (value) => value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  const dispatch = createEventDispatcher();
  let { className = "" } = $$props;
  let { id } = $$props;
  let { title } = $$props;
  let { selected = false } = $$props;
  let { shiftKey = false } = $$props;
  let { onDragEnd = () => {
  } } = $$props;
  let mouseOver = false;
  let draggable = false;
  let showShareChatModal = false;
  let confirmEdit = false;
  let chatTitle$1 = title;
  const cloneChatHandler = async (id2) => {
    const res = await cloneChatById(localStorage.token, id2, $i18n.t("Clone of {{TITLE}}", { TITLE: title })).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    if (res) {
      goto(`/c/${res.id}`);
      currentChatPage.set(1);
      await chats.set(await getChatList(localStorage.token, $currentChatPage));
      await pinnedChats.set(await getPinnedChatList(localStorage.token));
    }
  };
  const archiveChatHandler = async (id2) => {
    await archiveChatById(localStorage.token, id2);
    dispatch("change");
  };
  const moveChatHandler = async (chatId2, folderId) => {
    if (chatId2 && folderId) {
      const res = await updateChatFolderIdById(localStorage.token, chatId2, folderId).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      if (res) {
        currentChatPage.set(1);
        await chats.set(await getChatList(localStorage.token, $currentChatPage));
        await pinnedChats.set(await getPinnedChatList(localStorage.token));
        dispatch("change");
        toast.success($i18n.t("Chat moved successfully"));
      }
    } else {
      toast.error($i18n.t("Failed to move chat"));
    }
  };
  let itemElement;
  const dragImage = new Image();
  dragImage.src = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";
  onDestroy(() => {
  });
  let showDeleteConfirm = false;
  const renameHandler = async () => {
    chatTitle$1 = title;
    confirmEdit = true;
    await tick();
    setTimeout(
      () => {
        const input = document.getElementById(`chat-title-input-${id}`);
        if (input) {
          input.focus();
          input.select();
        }
      },
      0
    );
  };
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0) $$bindings.title(title);
  if ($$props.selected === void 0 && $$bindings.selected && selected !== void 0) $$bindings.selected(selected);
  if ($$props.shiftKey === void 0 && $$bindings.shiftKey && shiftKey !== void 0) $$bindings.shiftKey(shiftKey);
  if ($$props.onDragEnd === void 0 && $$bindings.onDragEnd && onDragEnd !== void 0) $$bindings.onDragEnd(onDragEnd);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(ShareChatModal, "ShareChatModal").$$render(
      $$result,
      { chatId: id, show: showShareChatModal },
      {
        show: ($$value) => {
          showShareChatModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(ConfirmDialog, "DeleteConfirmDialog").$$render(
      $$result,
      {
        title: $i18n.t("Delete chat?"),
        show: showDeleteConfirm
      },
      {
        show: ($$value) => {
          showDeleteConfirm = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="text-sm text-gray-500 flex-1 line-clamp-3">${escape($i18n.t("This will delete"))} <span class="font-semibold">${escape(title)}</span>.</div>`;
        }
      }
    )} ${``} <div id="sidebar-chat-group" class="${"w-full " + escape(className, true) + " relative group"}"${add_attribute("draggable", draggable, 0)}${add_attribute("this", itemElement, 0)}>${confirmEdit ? `<div id="sidebar-chat-item" class="${"w-full flex justify-between rounded-xl px-[11px] py-[6px] " + escape(
      id === $chatId || confirmEdit ? "bg-gray-100 dark:bg-gray-900 selected" : selected ? "bg-gray-100 dark:bg-gray-950 selected" : "group-hover:bg-gray-100 dark:group-hover:bg-gray-950",
      true
    ) + " whitespace-nowrap text-ellipsis relative " + escape("", true)}"><input id="${"chat-title-input-" + escape(id, true)}" class="bg-transparent w-full outline-hidden mr-10"${add_attribute("placeholder", "", 0)} ${""}${add_attribute("value", chatTitle$1, 0)}></div>` : `<a id="sidebar-chat-item" class="${"w-full flex justify-between rounded-xl px-[11px] py-[6px] " + escape(
      id === $chatId || confirmEdit ? "bg-gray-100 dark:bg-gray-900 selected" : selected ? "bg-gray-100 dark:bg-gray-950 selected" : " group-hover:bg-gray-100 dark:group-hover:bg-gray-950",
      true
    ) + " whitespace-nowrap text-ellipsis"}" href="${"/c/" + escape(id, true)}" draggable="false"><div class="flex self-center flex-1 w-full"><div dir="auto" class="text-left self-center overflow-hidden w-full h-[20px] truncate">${escape(title)}</div></div></a>`}  <div id="sidebar-chat-item-menu" class="${"" + escape(
      id === $chatId || confirmEdit ? "from-gray-100 dark:from-gray-900 selected" : selected ? "from-gray-100 dark:from-gray-950 selected" : "invisible group-hover:visible from-gray-100 dark:from-gray-950",
      true
    ) + " absolute " + escape(className === "pr-2" ? "right-[8px]" : "right-1", true) + " top-[4px] py-1 pr-0.5 mr-1.5 pl-5 bg-linear-to-l from-80% to-transparent"}">${confirmEdit ? `<div class="flex self-center items-center space-x-1.5 z-10 translate-y-[0.5px] -translate-x-[0.5px]">${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Generate") }, {}, {
      default: () => {
        return `<button class="self-center dark:hover:text-white transition disabled:cursor-not-allowed" id="generate-title-button" ${""}>${validate_component(Sparkles, "Sparkles").$$render($$result, { strokeWidth: "2" }, {}, {})}</button>`;
      }
    })}</div>` : `${shiftKey && mouseOver ? `<div class="flex items-center self-center space-x-1.5">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Archive"),
        className: "flex items-center"
      },
      {},
      {
        default: () => {
          return `<button class="self-center dark:hover:text-white transition" type="button">${validate_component(ArchiveBox, "ArchiveBox").$$render(
            $$result,
            {
              className: "size-4  translate-y-[0.5px]",
              strokeWidth: "2"
            },
            {},
            {}
          )}</button>`;
        }
      }
    )} ${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("Delete") }, {}, {
      default: () => {
        return `<button class="self-center dark:hover:text-white transition" type="button">${validate_component(GarbageBin, "GarbageBin").$$render($$result, { strokeWidth: "2" }, {}, {})}</button>`;
      }
    })}</div>` : `<div class="flex self-center z-10 items-end">${validate_component(ChatMenu, "ChatMenu").$$render(
      $$result,
      {
        chatId: id,
        cloneChatHandler: () => {
          cloneChatHandler(id);
        },
        shareHandler: () => {
          showShareChatModal = true;
        },
        moveChatHandler,
        archiveChatHandler: () => {
          archiveChatHandler(id);
        },
        renameHandler,
        deleteHandler: () => {
          showDeleteConfirm = true;
        },
        onClose: () => {
          dispatch("unselect");
        }
      },
      {},
      {
        default: () => {
          return `<button aria-label="Chat Menu" class="self-center dark:hover:text-white transition m-0" data-svelte-h="svelte-1d8pkdr"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="w-4 h-4"><path d="M2 8a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM6.5 8a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM12.5 6.5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z"></path></svg></button>`;
        }
      }
    )} ${id === $chatId ? ` <button id="delete-chat-button" class="hidden" data-svelte-h="svelte-1gozylk"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="w-4 h-4"><path d="M2 8a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM6.5 8a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM12.5 6.5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z"></path></svg></button>` : ``}</div>`}`}</div></div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_currentChatPage();
  $$unsubscribe_chatId();
  $$unsubscribe_selectedFolder();
  $$unsubscribe_mobile();
  return $$rendered;
});
const Folder = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  getContext("i18n");
  const dispatch = createEventDispatcher();
  let { open = true } = $$props;
  let { id = "" } = $$props;
  let { name = "" } = $$props;
  let { collapsible = true } = $$props;
  let { className = "" } = $$props;
  let { buttonClassName = "text-gray-600 dark:text-gray-400" } = $$props;
  let { chevron = true } = $$props;
  let { onAddLabel = "" } = $$props;
  let { onAdd = null } = $$props;
  let { dragAndDrop = true } = $$props;
  let folderElement;
  let draggedOver = false;
  const onDragOver = (e) => {
    e.preventDefault();
    e.stopPropagation();
    draggedOver = true;
  };
  const onDrop = (e) => {
    e.preventDefault();
    e.stopPropagation();
    if (folderElement.contains(e.target)) {
      /* @__PURE__ */ console.log("Dropped on the Button");
      if (e.dataTransfer.items && e.dataTransfer.items.length > 0) {
        for (const item of Array.from(e.dataTransfer.items)) {
          if (item.kind === "file") {
            const file = item.getAsFile();
            if (file && file.type === "application/json") {
              /* @__PURE__ */ console.log("Dropped file is a JSON file!");
              const reader = new FileReader();
              reader.onload = async function(event) {
                try {
                  const fileContent = JSON.parse(event.target.result);
                  /* @__PURE__ */ console.log("Parsed JSON Content: ", fileContent);
                  open = true;
                  dispatch("import", fileContent);
                } catch (error) {
                  /* @__PURE__ */ console.error("Error parsing JSON file:", error);
                }
              };
              reader.readAsText(file);
            } else {
              /* @__PURE__ */ console.error("Only JSON file types are supported.");
            }
          } else {
            open = true;
            try {
              const dataTransfer = e.dataTransfer.getData("text/plain");
              if (dataTransfer) {
                const data = JSON.parse(dataTransfer);
                /* @__PURE__ */ console.log(data);
                dispatch("drop", data);
              } else {
                /* @__PURE__ */ console.log("Dropped text data is empty or not text/plain.");
              }
            } catch (error) {
              /* @__PURE__ */ console.log("Dropped data is not valid JSON text or is empty. Ignoring drop event for this type of data.");
            } finally {
              draggedOver = false;
            }
          }
        }
      }
      draggedOver = false;
    }
  };
  const onDragLeave = (e) => {
    e.preventDefault();
    e.stopPropagation();
    draggedOver = false;
  };
  onDestroy(() => {
    if (!dragAndDrop) {
      return;
    }
    folderElement.removeEventListener("dragover", onDragOver);
    folderElement.removeEventListener("drop", onDrop);
    folderElement.removeEventListener("dragleave", onDragLeave);
  });
  if ($$props.open === void 0 && $$bindings.open && open !== void 0) $$bindings.open(open);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.name === void 0 && $$bindings.name && name !== void 0) $$bindings.name(name);
  if ($$props.collapsible === void 0 && $$bindings.collapsible && collapsible !== void 0) $$bindings.collapsible(collapsible);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.buttonClassName === void 0 && $$bindings.buttonClassName && buttonClassName !== void 0) $$bindings.buttonClassName(buttonClassName);
  if ($$props.chevron === void 0 && $$bindings.chevron && chevron !== void 0) $$bindings.chevron(chevron);
  if ($$props.onAddLabel === void 0 && $$bindings.onAddLabel && onAddLabel !== void 0) $$bindings.onAddLabel(onAddLabel);
  if ($$props.onAdd === void 0 && $$bindings.onAdd && onAdd !== void 0) $$bindings.onAdd(onAdd);
  if ($$props.dragAndDrop === void 0 && $$bindings.dragAndDrop && dragAndDrop !== void 0) $$bindings.dragAndDrop(dragAndDrop);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `<div class="${"relative " + escape(className, true)}"${add_attribute("this", folderElement, 0)}>${draggedOver ? `<div class="absolute top-0 left-0 w-full h-full rounded-xs bg-gray-100/50 dark:bg-gray-700/20 bg-opacity-50 dark:bg-opacity-10 z-50 pointer-events-none touch-none"></div>` : ``} ${collapsible ? `${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        className: "w-full ",
        buttonClassName: "w-full",
        onChange: (state) => {
          dispatch("change", state);
        },
        open
      },
      {
        open: ($$value) => {
          open = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div slot="content" class="w-full">${slots.default ? slots.default({}) : ``}</div>`;
        },
        default: () => {
          return ` <div id="sidebar-folder-button" class="${"w-full group rounded-xl relative flex items-center justify-between hover:bg-gray-100 dark:hover:bg-gray-900 transition " + escape(buttonClassName, true)}"><button class="w-full py-1.5 pl-2 flex items-center gap-1.5 text-xs font-medium">${chevron ? `<div class="p-[1px]">${open ? `${validate_component(ChevronDown, "ChevronDown").$$render($$result, { className: " size-3", strokeWidth: "2" }, {}, {})}` : `${validate_component(ChevronRight, "ChevronRight").$$render($$result, { className: " size-3", strokeWidth: "2" }, {}, {})}`}</div>` : ``} <div class="${"translate-y-[0.5px] " + escape(chevron ? "" : "pl-0.5", true)}">${escape(name)}</div></button> ${onAdd ? `<button class="absolute z-10 right-2 invisible group-hover:visible self-center flex items-center dark:text-gray-300">${validate_component(Tooltip, "Tooltip").$$render($$result, { content: onAddLabel }, {}, {
            default: () => {
              return `<button class="p-0.5 dark:hover:bg-gray-850 rounded-lg touch-auto">${validate_component(Plus, "Plus").$$render($$result, { className: " size-3", strokeWidth: "2.5" }, {}, {})}</button>`;
            }
          })}</button>` : ``}</div>`;
        }
      }
    )}` : `${slots.default ? slots.default({}) : ``}`}</div>`;
  } while (!$$settled);
  return $$rendered;
});
const RecursiveFolder = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $selectedFolder, $$unsubscribe_selectedFolder;
  let $i18n, $$unsubscribe_i18n;
  let $$unsubscribe_mobile;
  let $$unsubscribe_showSidebar;
  $$unsubscribe_selectedFolder = subscribe(selectedFolder, (value) => $selectedFolder = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  const dispatch = createEventDispatcher();
  const { saveAs } = fileSaver;
  let { folderRegistry = {} } = $$props;
  let { open = false } = $$props;
  let { folders: folders2 } = $$props;
  let { folderId } = $$props;
  let { shiftKey = false } = $$props;
  let { className = "" } = $$props;
  let { parentDragged = false } = $$props;
  let { onDelete = (e) => {
  } } = $$props;
  let { onItemMove = (e) => {
  } } = $$props;
  let folderElement;
  let showFolderModal = false;
  let dragged = false;
  const dragImage = new Image();
  dragImage.src = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";
  onDestroy(() => {
  });
  let showDeleteConfirm = false;
  const updateHandler = async ({ name, meta, data }) => {
    if (name === "") {
      toast.error($i18n.t("Folder name cannot be empty."));
      return;
    }
    const currentName = folders2[folderId].name;
    name = name.trim();
    folders2[folderId].name = name;
    const res = await updateFolderById(localStorage.token, folderId, {
      name,
      ...meta ? { meta } : {},
      ...data ? { data } : {}
    }).catch((error) => {
      toast.error(`${error}`);
      folders2[folderId].name = currentName;
      return null;
    });
    if (res) {
      folders2[folderId].name = name;
      if (data) {
        folders2[folderId].data = data;
      }
      toast.success($i18n.t("Folder updated successfully"));
      if ($selectedFolder?.id === folderId) {
        const folder = await getFolderById(localStorage.token, folderId).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
        if (folder) {
          selectedFolder.set(folder);
        }
      }
      dispatch("update");
    }
  };
  let chats2 = null;
  const setFolderItems = async () => {
    await tick();
    if (open) {
      chats2 = await getChatListByFolderId(localStorage.token, folderId).catch((error) => {
        toast.error(`${error}`);
        return [];
      });
      if ($selectedFolder?.id === folderId) {
        const folder = await getFolderById(localStorage.token, folderId).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
        if (folder) {
          selectedFolder.set(folder);
        }
      }
    } else {
      chats2 = null;
    }
  };
  const exportHandler = async () => {
    const chats3 = await getChatsByFolderId(localStorage.token, folderId).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    if (!chats3) {
      return;
    }
    const blob = new Blob([JSON.stringify(chats3)], { type: "application/json" });
    saveAs(blob, `folder-${folders2[folderId].name}-export-${Date.now()}.json`);
  };
  if ($$props.folderRegistry === void 0 && $$bindings.folderRegistry && folderRegistry !== void 0) $$bindings.folderRegistry(folderRegistry);
  if ($$props.open === void 0 && $$bindings.open && open !== void 0) $$bindings.open(open);
  if ($$props.folders === void 0 && $$bindings.folders && folders2 !== void 0) $$bindings.folders(folders2);
  if ($$props.folderId === void 0 && $$bindings.folderId && folderId !== void 0) $$bindings.folderId(folderId);
  if ($$props.shiftKey === void 0 && $$bindings.shiftKey && shiftKey !== void 0) $$bindings.shiftKey(shiftKey);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.parentDragged === void 0 && $$bindings.parentDragged && parentDragged !== void 0) $$bindings.parentDragged(parentDragged);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  if ($$props.onItemMove === void 0 && $$bindings.onItemMove && onItemMove !== void 0) $$bindings.onItemMove(onItemMove);
  if ($$props.setFolderItems === void 0 && $$bindings.setFolderItems && setFolderItems !== void 0) $$bindings.setFolderItems(setFolderItems);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      setFolderItems();
    }
    $$rendered = `${validate_component(ConfirmDialog, "DeleteConfirmDialog").$$render(
      $$result,
      {
        title: $i18n.t("Delete folder?"),
        show: showDeleteConfirm
      },
      {
        show: ($$value) => {
          showDeleteConfirm = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="text-sm text-gray-700 dark:text-gray-300 flex-1 line-clamp-3"><!-- HTML_TAG_START -->${DOMPurify.sanitize($i18n.t("This will delete <strong>{{NAME}}</strong> and <strong>all its contents</strong>.", { NAME: folders2[folderId].name }))}<!-- HTML_TAG_END --></div>`;
        }
      }
    )} ${validate_component(FolderModal, "FolderModal").$$render(
      $$result,
      {
        edit: true,
        folderId,
        onSubmit: updateHandler,
        show: showFolderModal
      },
      {
        show: ($$value) => {
          showFolderModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${``} <div class="${"relative " + escape(className, true)}" draggable="true"${add_attribute("this", folderElement, 0)}>${``} ${validate_component(Collapsible, "Collapsible").$$render(
      $$result,
      {
        className: "w-full",
        buttonClassName: "w-full",
        onChange: (state) => {
          dispatch("open", state);
        },
        open
      },
      {
        open: ($$value) => {
          open = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div slot="content" class="w-full">${(folders2[folderId]?.childrenIds ?? []).length > 0 || (chats2 ?? []).length > 0 ? `<div class="ml-3 pl-1 mt-[1px] flex flex-col overflow-y-auto scrollbar-hidden border-s border-gray-100 dark:border-gray-900">${folders2[folderId]?.childrenIds ? (() => {
            let children = folders2[folderId]?.childrenIds.map((id) => folders2[id]).sort((a, b) => a.name.localeCompare(b.name, void 0, { numeric: true, sensitivity: "base" }));
            return ` ${each(children, (childFolder) => {
              return `${validate_component(RecursiveFolder, "svelte:self").$$render(
                $$result,
                {
                  folders: folders2,
                  folderId: childFolder.id,
                  shiftKey,
                  parentDragged: dragged,
                  onItemMove,
                  onDelete,
                  folderRegistry
                },
                {
                  folderRegistry: ($$value) => {
                    folderRegistry = $$value;
                    $$settled = false;
                  }
                },
                {}
              )}`;
            })}`;
          })() : ``} ${each(chats2 ?? [], (chat) => {
            return `${validate_component(ChatItem, "ChatItem").$$render($$result, { id: chat.id, title: chat.title, shiftKey }, {}, {})}`;
          })}</div>` : ``} ${chats2 === null ? `<div class="flex justify-center items-center p-2">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-4 text-gray-500" }, {}, {})}</div>` : ``}</div>`;
        },
        default: () => {
          return ` <div class="w-full group"><button id="${"folder-" + escape(folderId, true) + "-button"}" class="${"relative w-full py-1 px-1.5 rounded-xl flex items-center gap-1.5 hover:bg-gray-100 dark:hover:bg-gray-900 transition " + escape(
            $selectedFolder?.id === folderId ? "bg-gray-100 dark:bg-gray-900 selected" : "",
            true
          )}"><button class="text-gray-500 dark:text-gray-500 transition-all p-1 hover:bg-gray-200 dark:hover:bg-gray-850 rounded-lg">${folders2[folderId]?.meta?.icon ? `<div class="flex group-hover:hidden transition-all">${validate_component(Emoji, "Emoji").$$render(
            $$result,
            {
              className: "size-3.5",
              shortCode: folders2[folderId].meta.icon
            },
            {},
            {}
          )}</div> <div class="hidden group-hover:flex transition-all p-[1px]">${open ? `${validate_component(ChevronDown, "ChevronDown").$$render($$result, { className: " size-3", strokeWidth: "2.5" }, {}, {})}` : `${validate_component(ChevronRight, "ChevronRight").$$render($$result, { className: " size-3", strokeWidth: "2.5" }, {}, {})}`}</div>` : `<div class="p-[1px]">${open ? `${validate_component(ChevronDown, "ChevronDown").$$render($$result, { className: " size-3", strokeWidth: "2.5" }, {}, {})}` : `${validate_component(ChevronRight, "ChevronRight").$$render($$result, { className: " size-3", strokeWidth: "2.5" }, {}, {})}`}</div>`}</button> <div class="translate-y-[0.5px] flex-1 justify-start text-start line-clamp-1">${`${escape(folders2[folderId].name)}`}</div> <button class="absolute z-10 right-2 invisible group-hover:visible self-center flex items-center dark:text-gray-300">${validate_component(FolderMenu, "FolderMenu").$$render(
            $$result,
            {
              onEdit: () => {
                showFolderModal = true;
              },
              onDelete: () => {
                showDeleteConfirm = true;
              },
              onExport: () => {
                exportHandler();
              }
            },
            {},
            {
              default: () => {
                return `<div class="p-1 dark:hover:bg-gray-850 rounded-lg touch-auto">${validate_component(EllipsisHorizontal, "EllipsisHorizontal").$$render($$result, { className: "size-4", strokeWidth: "2.5" }, {}, {})}</div>`;
              }
            }
          )}</button></button></div>`;
        }
      }
    )}</div>`;
  } while (!$$settled);
  $$unsubscribe_selectedFolder();
  $$unsubscribe_i18n();
  $$unsubscribe_mobile();
  $$unsubscribe_showSidebar();
  return $$rendered;
});
const Folders = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  createEventDispatcher();
  let { folderRegistry = {} } = $$props;
  let { folders: folders2 = {} } = $$props;
  let { shiftKey = false } = $$props;
  let { onDelete = (folderId) => {
  } } = $$props;
  let folderList = [];
  const onItemMove = (e) => {
    if (e.originFolderId) {
      folderRegistry[e.originFolderId]?.setFolderItems();
    }
  };
  if ($$props.folderRegistry === void 0 && $$bindings.folderRegistry && folderRegistry !== void 0) $$bindings.folderRegistry(folderRegistry);
  if ($$props.folders === void 0 && $$bindings.folders && folders2 !== void 0) $$bindings.folders(folders2);
  if ($$props.shiftKey === void 0 && $$bindings.shiftKey && shiftKey !== void 0) $$bindings.shiftKey(shiftKey);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    folderList = Object.keys(folders2).filter((key) => folders2[key].parent_id === null).sort((a, b) => folders2[a].name.localeCompare(folders2[b].name, void 0, { numeric: true, sensitivity: "base" }));
    $$rendered = `${each(folderList, (folderId) => {
      return `${validate_component(RecursiveFolder, "RecursiveFolder").$$render(
        $$result,
        {
          className: "",
          folders: folders2,
          folderId,
          shiftKey,
          onDelete,
          onItemMove,
          folderRegistry
        },
        {
          folderRegistry: ($$value) => {
            folderRegistry = $$value;
            $$settled = false;
          }
        },
        {}
      )}`;
    })}`;
  } while (!$$settled);
  return $$rendered;
});
const ChannelModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_page;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_page = subscribe(page, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { onSubmit = () => {
  } } = $$props;
  let { onUpdate = () => {
  } } = $$props;
  let { channel = null } = $$props;
  let { edit = false } = $$props;
  let name = "";
  let accessControl = {};
  let loading = false;
  const init = () => {
    name = channel.name;
    accessControl = channel.access_control;
  };
  let showDeleteConfirmDialog = false;
  const resetHandler = () => {
    name = "";
    accessControl = {};
    loading = false;
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.onSubmit === void 0 && $$bindings.onSubmit && onSubmit !== void 0) $$bindings.onSubmit(onSubmit);
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  if ($$props.channel === void 0 && $$bindings.channel && channel !== void 0) $$bindings.channel(channel);
  if ($$props.edit === void 0 && $$bindings.edit && edit !== void 0) $$bindings.edit(edit);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (name) {
        name = name.replace(/\s/g, "-").toLocaleLowerCase();
      }
    }
    {
      if (show) {
        if (channel) {
          init();
        }
      } else {
        resetHandler();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "sm", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-1"><div class="text-lg font-medium self-center">${edit ? `${escape($i18n.t("Edit Channel"))}` : `${escape($i18n.t("Create Channel"))}`}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-4 md:space-x-4 dark:text-gray-200"><div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6"><form class="flex flex-col w-full"><div class="flex flex-col w-full mt-2"><div class="mb-1 text-xs text-gray-500">${escape($i18n.t("Channel Name"))}</div> <div class="flex-1"><input class="w-full text-sm bg-transparent placeholder:text-gray-300 dark:placeholder:text-gray-700 outline-hidden" type="text"${add_attribute("placeholder", $i18n.t("new-channel"), 0)} autocomplete="off"${add_attribute("value", name, 0)}></div></div> <hr class="border-gray-100 dark:border-gray-700/10 my-2.5 w-full"> <div class="my-2 -mx-2"><div class="px-4 py-3 bg-gray-50 dark:bg-gray-950 rounded-3xl">${validate_component(AccessControl, "AccessControl").$$render(
            $$result,
            {
              accessRoles: ["read", "write"],
              accessControl
            },
            {
              accessControl: ($$value) => {
                accessControl = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div></div> <div class="flex justify-end pt-3 text-sm font-medium gap-1.5">${edit ? `<button class="px-3.5 py-1.5 text-sm font-medium dark:bg-black dark:hover:bg-black/90 dark:text-white bg-white text-black hover:bg-gray-100 transition rounded-full flex flex-row space-x-1 items-center" type="button">${escape($i18n.t("Delete"))}</button>` : ``} <button class="${"px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-950 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full flex flex-row space-x-1 items-center " + escape(loading ? " cursor-not-allowed" : "", true)}" type="submit" ${loading ? "disabled" : ""}>${edit ? `${escape($i18n.t("Update"))}` : `${escape($i18n.t("Create"))}`} ${loading ? `<div class="ml-2 self-center">${validate_component(Spinner, "Spinner").$$render($$result, {}, {}, {})}</div>` : ``}</button></div></form></div></div></div>`;
        }
      }
    )} ${validate_component(ConfirmDialog, "DeleteConfirmDialog").$$render(
      $$result,
      {
        message: $i18n.t("Are you sure you want to delete this channel?"),
        confirmLabel: $i18n.t("Delete"),
        show: showDeleteConfirmDialog
      },
      {
        show: ($$value) => {
          showDeleteConfirmDialog = $$value;
          $$settled = false;
        }
      },
      {}
    )}`;
  } while (!$$settled);
  $$unsubscribe_page();
  $$unsubscribe_i18n();
  return $$rendered;
});
const Lock = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M16 12H17.4C17.7314 12 18 12.2686 18 12.6V19.4C18 19.7314 17.7314 20 17.4 20H6.6C6.26863 20 6 19.7314 6 19.4V12.6C6 12.2686 6.26863 12 6.6 12H8M16 12V8C16 6.66667 15.2 4 12 4C8.8 4 8 6.66667 8 8V12M16 12H8" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const Hashtag = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M10 3L6 21" stroke-linecap="round"></path><path d="M20.5 16H2.5" stroke-linecap="round"></path><path d="M22 7H4" stroke-linecap="round"></path><path d="M18 3L14 21" stroke-linecap="round"></path></svg>`;
});
const ChannelItem = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $page, $$unsubscribe_page;
  let $$unsubscribe_mobile;
  let $user, $$unsubscribe_user;
  $$unsubscribe_page = subscribe(page, (value) => $page = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { onUpdate = () => {
  } } = $$props;
  let { className = "" } = $$props;
  let { channel } = $$props;
  let showEditChannelModal = false;
  let itemElement;
  if ($$props.onUpdate === void 0 && $$bindings.onUpdate && onUpdate !== void 0) $$bindings.onUpdate(onUpdate);
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.channel === void 0 && $$bindings.channel && channel !== void 0) $$bindings.channel(channel);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(ChannelModal, "ChannelModal").$$render(
      $$result,
      {
        channel,
        edit: true,
        onUpdate,
        onSubmit: async ({ name, access_control }) => {
          const res = await updateChannelById(localStorage.token, channel.id, { name, access_control }).catch((error) => {
            toast.error(error.message);
          });
          if (res) {
            toast.success($i18n.t("Channel updated successfully"));
          }
          onUpdate();
        },
        show: showEditChannelModal
      },
      {
        show: ($$value) => {
          showEditChannelModal = $$value;
          $$settled = false;
        }
      },
      {}
    )} <div id="sidebar-channel-item" class="${"w-full " + escape(className, true) + " rounded-xl flex relative group hover:bg-gray-100 dark:hover:bg-gray-900 " + escape(
      $page.url.pathname === `/channels/${channel.id}` ? "bg-gray-100 dark:bg-gray-900 selected" : "",
      true
    ) + " px-2.5 py-1"}"${add_attribute("this", itemElement, 0)}><a class="w-full flex justify-between" href="${"/channels/" + escape(channel.id, true)}" draggable="false"><div class="flex items-center gap-1 shrink-0"><div class="size-4 justify-center flex items-center">${channel?.access_control === null ? `${validate_component(Hashtag, "Hashtag").$$render($$result, { className: "size-3", strokeWidth: "2.5" }, {}, {})}` : `${validate_component(Lock, "Lock").$$render(
      $$result,
      {
        className: "size-[15px]",
        strokeWidth: "2"
      },
      {},
      {}
    )}`}</div> <div class="text-left self-center overflow-hidden w-full line-clamp-1 flex-1">${escape(channel.name)}</div></div></a> ${$user?.role === "admin" ? `<button class="absolute z-10 right-2 invisible group-hover:visible self-center flex items-center dark:text-gray-300"><button class="p-0.5 dark:hover:bg-gray-850 rounded-lg touch-auto">${validate_component(Cog6, "Cog6").$$render($$result, { className: "size-3.5" }, {}, {})}</button></button>` : ``}</div>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_page();
  $$unsubscribe_mobile();
  $$unsubscribe_user();
  return $$rendered;
});
const SearchInput = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $folders, $$unsubscribe_folders;
  let $i18n, $$unsubscribe_i18n;
  let $tags, $$unsubscribe_tags;
  $$unsubscribe_folders = subscribe(folders, (value2) => $folders = value2);
  $$unsubscribe_tags = subscribe(tags, (value2) => $tags = value2);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value2) => $i18n = value2);
  let { placeholder = "" } = $$props;
  let { value = "" } = $$props;
  let { showClearButton = false } = $$props;
  let { onFocus = () => {
  } } = $$props;
  let { onKeydown = (e) => {
  } } = $$props;
  let lastWord = "";
  let options = [
    {
      name: "tag:",
      description: $i18n.t("search for tags")
    },
    {
      name: "folder:",
      description: $i18n.t("search for folders")
    },
    {
      name: "pinned:",
      description: $i18n.t("search for pinned chats")
    },
    {
      name: "shared:",
      description: $i18n.t("search for shared chats")
    },
    {
      name: "archived:",
      description: $i18n.t("search for archived chats")
    }
  ];
  const initItems = async () => {
    /* @__PURE__ */ console.log("initItems", lastWord);
    await tick();
    if (lastWord.startsWith("tag:")) {
      [...$tags, { id: "none", name: $i18n.t("Untagged") }].filter((tag) => {
        const tagName = lastWord.slice(4);
        if (tagName) {
          const tagId = tagName.replace(" ", "_").toLowerCase();
          if (tag.id !== tagId) {
            return tag.id.startsWith(tagId);
          } else {
            return false;
          }
        } else {
          return true;
        }
      }).map((tag) => {
        return { id: tag.id, name: tag.name, type: "tag" };
      });
    } else if (lastWord.startsWith("folder:")) {
      [...$folders].filter((folder) => {
        const folderName = lastWord.slice(7);
        if (folderName) {
          const id = folder.name.replace(" ", "_").toLowerCase();
          const folderId = folderName.replace(" ", "_").toLowerCase();
          if (id !== folderId) {
            return id.startsWith(folderId);
          } else {
            return false;
          }
        } else {
          return true;
        }
      }).map((folder) => {
        return {
          id: folder.name.replace(" ", "_").toLowerCase(),
          name: folder.name,
          type: "folder"
        };
      });
    } else if (lastWord.startsWith("pinned:")) {
      [
        { id: "true", name: "true", type: "pinned" },
        {
          id: "false",
          name: "false",
          type: "pinned"
        }
      ].filter((item) => {
        const pinnedValue = lastWord.slice(7);
        if (pinnedValue) {
          return item.id.startsWith(pinnedValue) && item.id !== pinnedValue;
        } else {
          return true;
        }
      });
    } else if (lastWord.startsWith("shared:")) {
      [
        { id: "true", name: "true", type: "shared" },
        {
          id: "false",
          name: "false",
          type: "shared"
        }
      ].filter((item) => {
        const sharedValue = lastWord.slice(7);
        if (sharedValue) {
          return item.id.startsWith(sharedValue) && item.id !== sharedValue;
        } else {
          return true;
        }
      });
    } else if (lastWord.startsWith("archived:")) {
      [
        {
          id: "true",
          name: "true",
          type: "archived"
        },
        {
          id: "false",
          name: "false",
          type: "archived"
        }
      ].filter((item) => {
        const archivedValue = lastWord.slice(9);
        if (archivedValue) {
          return item.id.startsWith(archivedValue) && item.id !== archivedValue;
        } else {
          return true;
        }
      });
    } else ;
  };
  if ($$props.placeholder === void 0 && $$bindings.placeholder && placeholder !== void 0) $$bindings.placeholder(placeholder);
  if ($$props.value === void 0 && $$bindings.value && value !== void 0) $$bindings.value(value);
  if ($$props.showClearButton === void 0 && $$bindings.showClearButton && showClearButton !== void 0) $$bindings.showClearButton(showClearButton);
  if ($$props.onFocus === void 0 && $$bindings.onFocus && onFocus !== void 0) $$bindings.onFocus(onFocus);
  if ($$props.onKeydown === void 0 && $$bindings.onKeydown && onKeydown !== void 0) $$bindings.onKeydown(onKeydown);
  lastWord = value ? value.split(" ").at(-1) : value;
  options.filter((option) => {
    return option.name.startsWith(lastWord);
  });
  {
    if (lastWord && lastWord !== null) {
      initItems();
    }
  }
  $$unsubscribe_folders();
  $$unsubscribe_i18n();
  $$unsubscribe_tags();
  return `<div class="px-1 mb-1 flex justify-center space-x-2 relative z-10" id="search-container"><div class="flex w-full rounded-xl" id="chat-search"><div class="self-center py-2 rounded-l-xl bg-transparent dark:text-gray-300">${validate_component(Search, "Search").$$render($$result, {}, {}, {})}</div> <input id="search-input" class="w-full rounded-r-xl py-1.5 pl-2.5 text-sm bg-transparent dark:text-gray-300 outline-hidden"${add_attribute("placeholder", placeholder ? placeholder : $i18n.t("Search"), 0)} autocomplete="off"${add_attribute("value", value, 0)}> ${showClearButton && value ? `<div class="self-center pl-1.5 translate-y-[0.5px] rounded-l-xl bg-transparent"><button class="p-0.5 rounded-full hover:bg-gray-100 dark:hover:bg-gray-900 transition">${validate_component(XMark, "XMark").$$render($$result, { className: "size-3", strokeWidth: "2" }, {}, {})}</button></div>` : ``}</div> ${``}</div>`;
});
const SearchModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $user, $$unsubscribe_user;
  let $$unsubscribe_config;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_config = subscribe(config, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  dayjs.extend(calendar);
  let { show = false } = $$props;
  let { onClose = () => {
  } } = $$props;
  let actions = [
    {
      label: "Start a new conversation",
      onClick: async () => {
        await goto();
        show = false;
        onClose();
      },
      icon: PencilSquare
    }
  ];
  let query = "";
  let page2 = 1;
  let chatList = null;
  let allChatsLoaded = false;
  let searchDebounceTimeout;
  let selectedIdx = null;
  let selectedChat = null;
  let selectedModels = [""];
  let history = null;
  let messages = null;
  const loadChatPreview = async (selectedIdx2) => {
    if (!chatList || chatList.length === 0 || selectedIdx2 === null || chatList[selectedIdx2] === void 0) {
      selectedChat = null;
      messages = null;
      history = null;
      selectedModels = [""];
      return;
    }
    const selectedChatIdx = selectedIdx2 - actions.length;
    if (selectedChatIdx < 0) {
      selectedChat = null;
      return;
    }
    const chatId2 = chatList[selectedChatIdx].id;
    const chat = await getChatById(localStorage.token, chatId2).catch(async (error) => {
      return null;
    });
    if (chat) {
      if (chat?.chat?.history) {
        selectedModels = (chat?.chat?.models ?? void 0) !== void 0 ? chat?.chat?.models : [chat?.chat?.models ?? ""];
        history = chat?.chat?.history;
        messages = createMessagesList(chat?.chat?.history, chat?.chat?.history?.currentId);
        await tick();
        const messagesContainerElement = document.getElementById("chat-preview");
        if (messagesContainerElement) {
          messagesContainerElement.scrollTop = messagesContainerElement.scrollHeight;
        }
      } else {
        messages = [];
      }
    } else {
      toast.error($i18n.t("Failed to load chat preview"));
      selectedChat = null;
      messages = null;
      history = null;
      selectedModels = [""];
      return;
    }
  };
  const searchHandler = async () => {
    if (!show) {
      return;
    }
    if (searchDebounceTimeout) {
      clearTimeout(searchDebounceTimeout);
    }
    page2 = 1;
    chatList = null;
    if (query === "") {
      chatList = await getChatList(localStorage.token, page2);
    } else {
      searchDebounceTimeout = setTimeout(
        async () => {
          chatList = await getChatListBySearchText(localStorage.token, query, page2);
          if ((chatList ?? []).length === 0) {
            allChatsLoaded = true;
          } else {
            allChatsLoaded = false;
          }
        },
        500
      );
    }
    selectedChat = null;
    messages = null;
    history = null;
    selectedModels = [""];
    if ((chatList ?? []).length === 0) {
      allChatsLoaded = true;
    } else {
      allChatsLoaded = false;
    }
  };
  const onKeyDown = (e) => {
    const searchOptions = document.getElementById("search-options-container");
    if (searchOptions || !show) {
      return;
    }
    if (e.code === "Escape") {
      show = false;
      onClose();
    } else if (e.code === "Enter") {
      const item2 = document.querySelector(`[data-arrow-selected="true"]`);
      if (item2) {
        item2?.click();
        show = false;
      }
      return;
    } else if (e.code === "ArrowDown") {
      const searchInput = document.getElementById("search-input");
      if (searchInput) {
        if (document.activeElement === searchInput) {
          searchInput.blur();
          selectedIdx = 0;
          return;
        }
      }
      selectedIdx = Math.min(selectedIdx + 1, (chatList ?? []).length - 1 + actions.length);
    } else if (e.code === "ArrowUp") {
      if (selectedIdx === 0) {
        const searchInput = document.getElementById("search-input");
        if (searchInput) {
          if (document.activeElement !== searchInput) {
            searchInput.focus();
            selectedIdx = 0;
            return;
          }
        }
      }
      selectedIdx = Math.max(selectedIdx - 1, 0);
    }
    const item = document.querySelector(`[data-arrow-selected="true"]`);
    item?.scrollIntoView({
      block: "center",
      inline: "nearest",
      behavior: "instant"
    });
  };
  onDestroy(() => {
    if (searchDebounceTimeout) {
      clearTimeout(searchDebounceTimeout);
    }
    document.removeEventListener("keydown", onKeyDown);
  });
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.onClose === void 0 && $$bindings.onClose && onClose !== void 0) $$bindings.onClose(onClose);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (chatList) {
        loadChatPreview(selectedIdx);
      }
    }
    {
      if (show) {
        searchHandler();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "xl", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="py-3 dark:text-gray-300 text-gray-700"><div class="px-4 pb-1.5">${validate_component(SearchInput, "SearchInput").$$render(
            $$result,
            {
              placeholder: $i18n.t("Search"),
              showClearButton: true,
              onFocus: () => {
                selectedIdx = null;
                messages = null;
              },
              onKeydown: (e) => {
                /* @__PURE__ */ console.log("e", e);
                if (e.code === "Enter" && (chatList ?? []).length > 0) {
                  const item2 = document.querySelector(`[data-arrow-selected="true"]`);
                  if (item2) {
                    item2?.click();
                  }
                  show = false;
                  return;
                } else if (e.code === "ArrowDown") {
                  selectedIdx = Math.min(selectedIdx + 1, (chatList ?? []).length - 1 + actions.length);
                } else if (e.code === "ArrowUp") {
                  selectedIdx = Math.max(selectedIdx - 1, 0);
                } else {
                  selectedIdx = 0;
                }
                const item = document.querySelector(`[data-arrow-selected="true"]`);
                item?.scrollIntoView({
                  block: "center",
                  inline: "nearest",
                  behavior: "instant"
                });
              },
              value: query
            },
            {
              value: ($$value) => {
                query = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div>  <div class="flex px-4 pb-1"><div class="flex flex-col overflow-y-auto h-96 md:h-[40rem] max-h-full scrollbar-hidden w-full flex-1 pr-2"><div class="w-full text-xs text-gray-500 dark:text-gray-500 font-medium pb-2 px-2">${escape($i18n.t("Actions"))}</div> ${each(actions, (action, idx) => {
            return `<button class="${"w-full flex items-center rounded-xl text-sm py-2 px-3 hover:bg-gray-50 dark:hover:bg-gray-850 " + escape(selectedIdx === idx ? "bg-gray-50 dark:bg-gray-850" : "", true)}"${add_attribute("data-arrow-selected", selectedIdx === idx ? "true" : void 0, 0)} dragabble="false"><div class="pr-2">${validate_component(action.icon || missing_component, "svelte:component").$$render($$result, {}, {}, {})}</div> <div class="flex-1 text-left"><div class="text-ellipsis line-clamp-1 w-full">${escape($i18n.t(action.label))} </div></div> </button>`;
          })} ${chatList ? `<hr class="border-gray-50 dark:border-gray-850 my-3"> ${chatList.length === 0 ? `<div class="text-xs text-gray-500 dark:text-gray-400 text-center px-5 py-4">${escape($i18n.t("No results found"))}</div>` : ``} ${each(chatList, (chat, idx) => {
            return `${idx === 0 || idx > 0 && chat.time_range !== chatList[idx - 1].time_range ? `<div class="${"w-full text-xs text-gray-500 dark:text-gray-500 font-medium " + escape(idx === 0 ? "" : "pt-5", true) + " pb-2 px-2"}">${escape($i18n.t(chat.time_range))}  </div>` : ``} <a class="${"w-full flex justify-between items-center rounded-xl text-sm py-2 px-3 hover:bg-gray-50 dark:hover:bg-gray-850 " + escape(
              selectedIdx === idx + actions.length ? "bg-gray-50 dark:bg-gray-850" : "",
              true
            )}" href="${"/c/" + escape(chat.id, true)}" draggable="false"${add_attribute(
              "data-arrow-selected",
              selectedIdx === idx + actions.length ? "true" : void 0,
              0
            )}><div class="flex-1"><div class="text-ellipsis line-clamp-1 w-full">${escape(chat?.title)} </div></div> <div class="pl-3 shrink-0 text-gray-500 dark:text-gray-400 text-xs">${escape(dayjs(chat?.updated_at * 1e3).calendar())}</div> </a>`;
          })} ${!allChatsLoaded ? `${validate_component(Loader, "Loader").$$render($$result, {}, {}, {
            default: () => {
              return `<div class="w-full flex justify-center py-4 text-xs animate-pulse items-center gap-2">${validate_component(Spinner, "Spinner").$$render($$result, { className: " size-4" }, {}, {})} <div class="">${escape($i18n.t("Loading..."))}</div></div>`;
            }
          })}` : ``}` : `<div class="w-full h-full flex justify-center items-center">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</div>`}</div> <div id="chat-preview" class="hidden md:flex md:flex-1 w-full overflow-y-auto h-96 md:h-[40rem] scrollbar-hidden">${messages === null ? `<div class="w-full h-full flex justify-center items-center text-gray-500 dark:text-gray-400 text-sm">${escape($i18n.t("Select a conversation to preview"))}</div>` : `<div class="w-full h-full flex flex-col">${validate_component(Messages, "Messages").$$render(
            $$result,
            {
              className: "h-full flex pt-4 pb-8 w-full",
              chatId: `chat-preview-${selectedChat?.id ?? ""}`,
              user: $user,
              readOnly: true,
              selectedModels,
              autoScroll: true,
              sendMessage: () => {
              },
              continueResponse: () => {
              },
              regenerateResponse: () => {
              },
              history,
              messages
            },
            {
              history: ($$value) => {
                history = $$value;
                $$settled = false;
              },
              messages: ($$value) => {
                messages = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div>`}</div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_user();
  $$unsubscribe_config();
  $$unsubscribe_i18n();
  return $$rendered;
});
const PinnedModelItem = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => value);
  let { model = null } = $$props;
  let { shiftKey = false } = $$props;
  let { onClick = () => {
  } } = $$props;
  let { onUnpin = () => {
  } } = $$props;
  if ($$props.model === void 0 && $$bindings.model && model !== void 0) $$bindings.model(model);
  if ($$props.shiftKey === void 0 && $$bindings.shiftKey && shiftKey !== void 0) $$bindings.shiftKey(shiftKey);
  if ($$props.onClick === void 0 && $$bindings.onClick && onClick !== void 0) $$bindings.onClick(onClick);
  if ($$props.onUnpin === void 0 && $$bindings.onUnpin && onUnpin !== void 0) $$bindings.onUnpin(onUnpin);
  $$unsubscribe_i18n();
  return `${model ? ` <div class="px-[7px] flex justify-center text-gray-800 dark:text-gray-200 cursor-grab relative group"${add_attribute("data-id", model?.id, 0)}><a class="grow flex items-center space-x-2.5 rounded-lg px-2 py-[7px] group-hover:bg-gray-100 dark:group-hover:bg-gray-900 transition" href="${"/?model=" + escape(model?.id, true)}" draggable="false"><div class="self-center shrink-0"><img crossorigin="anonymous"${add_attribute("src", model?.info?.meta?.profile_image_url ?? `${WEBUI_BASE_URL}/static/favicon.png`, 0)} class="size-5 rounded-full -translate-x-[0.5px]" alt="logo"></div> <div class="flex self-center translate-y-[0.5px]"><div class="self-center text-sm font-primary line-clamp-1">${escape(model?.name ?? model.id)}</div></div></a> ${``}</div>` : ``}`;
});
const PinnedModelList = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  let $mobile, $$unsubscribe_mobile;
  let $models, $$unsubscribe_models;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  let { selectedChatId = null } = $$props;
  let { shiftKey = false } = $$props;
  if ($$props.selectedChatId === void 0 && $$bindings.selectedChatId && selectedChatId !== void 0) $$bindings.selectedChatId(selectedChatId);
  if ($$props.shiftKey === void 0 && $$bindings.shiftKey && shiftKey !== void 0) $$bindings.shiftKey(shiftKey);
  $$unsubscribe_settings();
  $$unsubscribe_mobile();
  $$unsubscribe_models();
  return `<div class="mt-0.5 pb-1.5" id="pinned-models-list">${each($settings.pinnedModels, (modelId) => {
    let model = $models.find((model2) => model2.id === modelId);
    return ` ${model ? `${validate_component(PinnedModelItem, "PinnedModelItem").$$render(
      $$result,
      {
        model,
        shiftKey,
        onClick: () => {
          selectedChatId = null;
          chatId.set("");
          if ($mobile) {
            showSidebar.set(false);
          }
        },
        onUnpin: () => {
          const pinnedModels = $settings.pinnedModels.filter((id) => id !== modelId);
          settings.set({ ...$settings, pinnedModels });
          updateUserSettings(localStorage.token, { ui: $settings });
        }
      },
      {},
      {}
    )}` : ``}`;
  })}</div>`;
});
const Note = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" viewBox="0 0 24 24"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" d="M10 3v4a1 1 0 0 1-1 1H5m4 8h6m-6-4h6m4-8v16a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V7.914a1 1 0 0 1 .293-.707l3.914-3.914A1 1 0 0 1 9.914 3H18a1 1 0 0 1 1 1Z"></path></svg>`;
});
const Sidebar_1 = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $mobile, $$unsubscribe_mobile;
  let $user, $$unsubscribe_user;
  let $showSidebar, $$unsubscribe_showSidebar;
  let $i18n, $$unsubscribe_i18n;
  let $chats, $$unsubscribe_chats;
  let $currentChatPage, $$unsubscribe_currentChatPage;
  let $showArchivedChats, $$unsubscribe_showArchivedChats;
  let $socket, $$unsubscribe_socket;
  let $isApp, $$unsubscribe_isApp;
  let $showSearch, $$unsubscribe_showSearch;
  let $config, $$unsubscribe_config;
  let $WEBUI_NAME, $$unsubscribe_WEBUI_NAME;
  let $models, $$unsubscribe_models;
  let $settings, $$unsubscribe_settings;
  let $channels, $$unsubscribe_channels;
  let $pinnedChats, $$unsubscribe_pinnedChats;
  let $scrollPaginationEnabled, $$unsubscribe_scrollPaginationEnabled;
  $$unsubscribe_mobile = subscribe(mobile, (value) => $mobile = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  $$unsubscribe_chats = subscribe(chats, (value) => $chats = value);
  $$unsubscribe_currentChatPage = subscribe(currentChatPage, (value) => $currentChatPage = value);
  $$unsubscribe_showArchivedChats = subscribe(showArchivedChats, (value) => $showArchivedChats = value);
  $$unsubscribe_socket = subscribe(socket, (value) => $socket = value);
  $$unsubscribe_isApp = subscribe(isApp, (value) => $isApp = value);
  $$unsubscribe_showSearch = subscribe(showSearch, (value) => $showSearch = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_WEBUI_NAME = subscribe(WEBUI_NAME, (value) => $WEBUI_NAME = value);
  $$unsubscribe_models = subscribe(models, (value) => $models = value);
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_channels = subscribe(channels, (value) => $channels = value);
  $$unsubscribe_pinnedChats = subscribe(pinnedChats, (value) => $pinnedChats = value);
  $$unsubscribe_scrollPaginationEnabled = subscribe(scrollPaginationEnabled, (value) => $scrollPaginationEnabled = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let navElement;
  let shiftKey = false;
  let selectedChatId = null;
  let showPinnedChat = true;
  let showCreateChannel = false;
  let allChatsLoaded = false;
  let showCreateFolderModal = false;
  let folders$1 = {};
  let folderRegistry = {};
  const initFolders = async () => {
    const folderList = await getFolders(localStorage.token).catch((error) => {
      toast.error(`${error}`);
      return [];
    });
    folders.set(folderList);
    folders$1 = {};
    for (const folder of folderList) {
      folders$1[folder.id] = { ...folders$1[folder.id] || {}, ...folder };
    }
    for (const folder of folderList) {
      if (folder.parent_id) {
        if (!folders$1[folder.parent_id]) {
          folders$1[folder.parent_id] = {};
        }
        folders$1[folder.parent_id].childrenIds = folders$1[folder.parent_id].childrenIds ? [...folders$1[folder.parent_id].childrenIds, folder.id] : [folder.id];
        folders$1[folder.parent_id].childrenIds.sort((a, b) => {
          return folders$1[b].updated_at - folders$1[a].updated_at;
        });
      }
    }
    await tick();
    for (const folderId in folders$1) {
      if (folders$1[folderId] && folders$1[folderId].is_expanded) {
        folderRegistry[folderId]?.setFolderItems();
      }
    }
  };
  const createFolder = async ({ name, data }) => {
    if (name === "") {
      toast.error($i18n.t("Folder name cannot be empty."));
      return;
    }
    const rootFolders = Object.values(folders$1).filter((folder) => folder.parent_id === null);
    if (rootFolders.find((folder) => folder.name.toLowerCase() === name.toLowerCase())) {
      let i = 1;
      while (rootFolders.find((folder) => folder.name.toLowerCase() === `${name} ${i}`.toLowerCase())) {
        i++;
      }
      name = `${name} ${i}`;
    }
    const tempId = v4();
    folders$1 = {
      ...folders$1,
      tempId: {
        id: tempId,
        name,
        created_at: Date.now(),
        updated_at: Date.now()
      }
    };
    const res = await createNewFolder(localStorage.token, { name, data }).catch((error) => {
      toast.error(`${error}`);
      return null;
    });
    if (res) {
      await initFolders();
    }
  };
  const initChannels = async () => {
    await channels.set(await getChannels(localStorage.token));
  };
  const initChatList = async () => {
    tags.set(await getAllTags(localStorage.token));
    pinnedChats.set(await getPinnedChatList(localStorage.token));
    initFolders();
    currentChatPage.set(1);
    allChatsLoaded = false;
    await chats.set(await getChatList(localStorage.token, $currentChatPage));
    scrollPaginationEnabled.set(true);
  };
  const importChatHandler = async (items, pinned = false, folderId = null) => {
    /* @__PURE__ */ console.log("importChatHandler", items, pinned, folderId);
    for (const item of items) {
      /* @__PURE__ */ console.log(item);
      if (item.chat) {
        await importChat(localStorage.token, item.chat, item?.meta ?? {}, pinned, folderId, item?.created_at ?? null, item?.updated_at ?? null);
      }
    }
    initChatList();
  };
  const inputFilesHandler = async (files) => {
    /* @__PURE__ */ console.log(files);
    for (const file of files) {
      const reader = new FileReader();
      reader.onload = async (e) => {
        const content = e.target.result;
        try {
          const chatItems = JSON.parse(content);
          importChatHandler(chatItems);
        } catch {
          toast.error($i18n.t(`Invalid file format.`));
        }
      };
      reader.readAsText(file);
    }
  };
  const onDragOver = (e) => {
    e.preventDefault();
    if (e.dataTransfer?.types?.includes("Files")) ;
  };
  const onDragLeave = () => {
  };
  const onDrop = async (e) => {
    e.preventDefault();
    /* @__PURE__ */ console.log(e);
    if (e.dataTransfer?.files) {
      const inputFiles = Array.from(e.dataTransfer?.files);
      if (inputFiles && inputFiles.length > 0) {
        /* @__PURE__ */ console.log(inputFiles);
        inputFilesHandler(inputFiles);
      }
    }
  };
  let touchstart;
  let touchend;
  function checkDirection() {
    const screenWidth = window.innerWidth;
    const swipeDistance = Math.abs(touchend.screenX - touchstart.screenX);
    if (touchstart.clientX < 40 && swipeDistance >= screenWidth / 8) {
      if (touchend.screenX < touchstart.screenX) {
        showSidebar.set(false);
      }
      if (touchend.screenX > touchstart.screenX) {
        showSidebar.set(true);
      }
    }
  }
  const onTouchStart = (e) => {
    touchstart = e.changedTouches[0];
    /* @__PURE__ */ console.log(touchstart.clientX);
  };
  const onTouchEnd = (e) => {
    touchend = e.changedTouches[0];
    checkDirection();
  };
  const onKeyDown = (e) => {
    if (e.key === "Shift") {
      shiftKey = true;
    }
  };
  const onKeyUp = (e) => {
    if (e.key === "Shift") {
      shiftKey = false;
    }
  };
  const onFocus = () => {
  };
  const onBlur = () => {
    shiftKey = false;
    selectedChatId = null;
  };
  onDestroy(() => {
    window.removeEventListener("keydown", onKeyDown);
    window.removeEventListener("keyup", onKeyUp);
    window.removeEventListener("touchstart", onTouchStart);
    window.removeEventListener("touchend", onTouchEnd);
    window.removeEventListener("focus", onFocus);
    window.removeEventListener("blur", onBlur);
    const dropZone = document.getElementById("sidebar");
    dropZone?.removeEventListener("dragover", onDragOver);
    dropZone?.removeEventListener("drop", onDrop);
    dropZone?.removeEventListener("dragleave", onDragLeave);
  });
  const isWindows = /Windows/i.test(navigator.userAgent);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(ArchivedChatsModal, "ArchivedChatsModal").$$render(
      $$result,
      {
        onUpdate: async () => {
          await initChatList();
        },
        show: $showArchivedChats
      },
      {
        show: ($$value) => {
          $showArchivedChats = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(ChannelModal, "ChannelModal").$$render(
      $$result,
      {
        onSubmit: async ({ name, access_control }) => {
          const res = await createNewChannel(localStorage.token, { name, access_control }).catch((error) => {
            toast.error(`${error}`);
            return null;
          });
          if (res) {
            $socket.emit("join-channels", { auth: { token: $user?.token } });
            await initChannels();
            showCreateChannel = false;
          }
        },
        show: showCreateChannel
      },
      {
        show: ($$value) => {
          showCreateChannel = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(FolderModal, "FolderModal").$$render(
      $$result,
      {
        onSubmit: async (folder) => {
          await createFolder(folder);
          showCreateFolderModal = false;
        },
        show: showCreateFolderModal
      },
      {
        show: ($$value) => {
          showCreateFolderModal = $$value;
          $$settled = false;
        }
      },
      {}
    )}  ${$showSidebar ? `<div class="${"" + escape($isApp ? " ml-[4.5rem] md:ml-0" : "", true) + " fixed md:hidden z-40 top-0 right-0 left-0 bottom-0 bg-black/60 w-full min-h-screen h-screen flex justify-center overflow-hidden overscroll-contain"}"></div>` : ``} ${validate_component(SearchModal, "SearchModal").$$render(
      $$result,
      {
        onClose: () => {
          if ($mobile) {
            showSidebar.set(false);
          }
        },
        show: $showSearch
      },
      {
        show: ($$value) => {
          $showSearch = $$value;
          $$settled = false;
        }
      },
      {}
    )} <button id="sidebar-new-chat-button" class="hidden"></button> ${!$mobile && !$showSidebar ? `<div class="py-2 px-1.5 flex flex-col justify-between text-black dark:text-white hover:bg-gray-50/50 dark:hover:bg-gray-950/50 h-full border-e border-gray-50 dark:border-gray-850 z-10 transition-all" id="sidebar"><button class="${"flex flex-col flex-1 " + escape(isWindows ? "cursor-pointer" : "cursor-[e-resize]", true)}"><div class="pb-1.5">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar"),
        placement: "right"
      },
      {},
      {
        default: () => {
          return `<button class="${"flex rounded-xl hover:bg-gray-100 dark:hover:bg-gray-850 transition group " + escape(isWindows ? "cursor-pointer" : "cursor-[e-resize]", true)}"${add_attribute(
            "aria-label",
            $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar"),
            0
          )}><div class="self-center flex items-center justify-center size-9"><img crossorigin="anonymous" src="${escape(WEBUI_BASE_URL, true) + "/static/favicon.png"}" class="sidebar-new-chat-icon size-6 rounded-full group-hover:hidden" alt=""> ${validate_component(Sidebar, "Sidebar").$$render(
            $$result,
            {
              className: "size-5 hidden group-hover:flex"
            },
            {},
            {}
          )}</div></button>`;
        }
      }
    )}</div> <div><div class="">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("New Chat"),
        placement: "right"
      },
      {},
      {
        default: () => {
          return `<a class="cursor-pointer flex rounded-xl hover:bg-gray-100 dark:hover:bg-gray-850 transition group" href="/" draggable="false"${add_attribute("aria-label", $i18n.t("New Chat"), 0)}><div class="self-center flex items-center justify-center size-9">${validate_component(PencilSquare, "PencilSquare").$$render($$result, { className: "size-4.5" }, {}, {})}</div></a>`;
        }
      }
    )}</div> <div class="">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Search"),
        placement: "right"
      },
      {},
      {
        default: () => {
          return `<button class="cursor-pointer flex rounded-xl hover:bg-gray-100 dark:hover:bg-gray-850 transition group" draggable="false"${add_attribute("aria-label", $i18n.t("Search"), 0)}><div class="self-center flex items-center justify-center size-9">${validate_component(Search, "Search").$$render($$result, { className: "size-4.5" }, {}, {})}</div></button>`;
        }
      }
    )}</div> ${($config?.features?.enable_notes ?? false) && ($user?.role === "admin" || ($user?.permissions?.features?.notes ?? true)) ? `<div class="">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Notes"),
        placement: "right"
      },
      {},
      {
        default: () => {
          return `<a class="cursor-pointer flex rounded-xl hover:bg-gray-100 dark:hover:bg-gray-850 transition group" href="/notes" draggable="false"${add_attribute("aria-label", $i18n.t("Notes"), 0)}><div class="self-center flex items-center justify-center size-9">${validate_component(Note, "Note").$$render($$result, { className: "size-4.5" }, {}, {})}</div></a>`;
        }
      }
    )}</div>` : ``} ${$user?.role === "admin" || $user?.permissions?.workspace?.models || $user?.permissions?.workspace?.knowledge || $user?.permissions?.workspace?.prompts || $user?.permissions?.workspace?.tools ? `<div class="">${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $i18n.t("Workspace"),
        placement: "right"
      },
      {},
      {
        default: () => {
          return `<a class="cursor-pointer flex rounded-xl hover:bg-gray-100 dark:hover:bg-gray-850 transition group" href="/workspace"${add_attribute("aria-label", $i18n.t("Workspace"), 0)} draggable="false"><div class="self-center flex items-center justify-center size-9" data-svelte-h="svelte-1fat3kp"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4.5"><path stroke-linecap="round" stroke-linejoin="round" d="M13.5 16.875h3.375m0 0h3.375m-3.375 0V13.5m0 3.375v3.375M6 10.5h2.25a2.25 2.25 0 0 0 2.25-2.25V6a2.25 2.25 0 0 0-2.25-2.25H6A2.25 2.25 0 0 0 3.75 6v2.25A2.25 2.25 0 0 0 6 10.5Zm0 9.75h2.25A2.25 2.25 0 0 0 10.5 18v-2.25a2.25 2.25 0 0 0-2.25-2.25H6a2.25 2.25 0 0 0-2.25 2.25V18A2.25 2.25 0 0 0 6 20.25Zm9.75-9.75H18a2.25 2.25 0 0 0 2.25-2.25V6A2.25 2.25 0 0 0 18 3.75h-2.25A2.25 2.25 0 0 0 13.5 6v2.25a2.25 2.25 0 0 0 2.25 2.25Z"></path></svg></div></a>`;
        }
      }
    )}</div>` : ``}</div></button> <div><div><div class="py-0.5">${$user !== void 0 && $user !== null ? `${validate_component(UserMenu, "UserMenu").$$render($$result, { role: $user?.role }, {}, {
      default: () => {
        return `<div class="cursor-pointer flex rounded-xl hover:bg-gray-100 dark:hover:bg-gray-850 transition group"><div class="self-center flex items-center justify-center size-9"><img${add_attribute("src", $user?.profile_image_url, 0)} class="size-6 object-cover rounded-full"${add_attribute("alt", $i18n.t("Open User Profile Menu"), 0)}${add_attribute("aria-label", $i18n.t("Open User Profile Menu"), 0)}></div></div>`;
      }
    })}` : ``}</div></div></div></div>` : ``} ${$showSidebar ? `<div id="sidebar" class="${"h-screen max-h-[100dvh] min-h-screen select-none " + escape(
      $showSidebar ? "bg-gray-50 dark:bg-gray-950 z-50" : " bg-transparent z-0 ",
      true
    ) + " " + escape(
      $isApp ? `ml-[4.5rem] md:ml-0 ` : " transition-all duration-300 ",
      true
    ) + " shrink-0 text-gray-900 dark:text-gray-200 text-sm fixed top-0 left-0 overflow-x-hidden"}"${add_attribute("data-state", $showSidebar, 0)}${add_attribute("this", navElement, 0)}><div class="${"my-auto flex flex-col justify-between h-screen max-h-[100dvh] w-[260px] overflow-x-hidden scrollbar-hidden z-50 " + escape($showSidebar ? "" : "invisible", true)}"><div class="sidebar px-2 pt-2 pb-1.5 flex justify-between space-x-1 text-gray-600 dark:text-gray-400 sticky top-0 z-10 -mb-3"><a class="flex items-center rounded-xl size-8.5 h-full justify-center hover:bg-gray-100/50 dark:hover:bg-gray-850/50 transition no-drag-region" href="/" draggable="false" data-svelte-h="svelte-1c9e0tz"><img crossorigin="anonymous" src="${escape(WEBUI_BASE_URL, true) + "/static/favicon.png"}" class="sidebar-new-chat-icon size-6 rounded-full" alt=""></a> <a href="/" class="flex flex-1 px-1.5"><div class="self-center font-medium text-gray-850 dark:text-white font-primary">${escape($WEBUI_NAME)}</div></a> ${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar"),
        placement: "bottom"
      },
      {},
      {
        default: () => {
          return `<button class="${"flex rounded-xl size-8.5 justify-center items-center hover:bg-gray-100/50 dark:hover:bg-gray-850/50 transition " + escape(isWindows ? "cursor-pointer" : "cursor-[w-resize]", true)}"${add_attribute(
            "aria-label",
            $showSidebar ? $i18n.t("Close Sidebar") : $i18n.t("Open Sidebar"),
            0
          )}><div class="self-center p-1.5">${validate_component(Sidebar, "Sidebar").$$render($$result, {}, {}, {})}</div></button>`;
        }
      }
    )} <div class="${escape("invisible", true) + " sidebar-bg-gradient-to-b bg-linear-to-b from-gray-50 dark:from-gray-950 to-transparent from-50% pointer-events-none absolute inset-0 -z-10 -mb-6"}"></div></div> <div class="relative flex flex-col flex-1 overflow-y-auto scrollbar-hidden pt-3 pb-3"><div class="pb-1.5"><div class="px-[7px] flex justify-center text-gray-800 dark:text-gray-200"><a id="sidebar-new-chat-button" class="grow flex items-center space-x-3 rounded-2xl px-2.5 py-2 hover:bg-gray-100 dark:hover:bg-gray-900 transition outline-none" href="/" draggable="false"${add_attribute("aria-label", $i18n.t("New Chat"), 0)}><div class="self-center">${validate_component(PencilSquare, "PencilSquare").$$render($$result, { className: " size-4.5", strokeWidth: "2" }, {}, {})}</div> <div class="flex self-center translate-y-[0.5px]"><div class="self-center text-sm font-primary">${escape($i18n.t("New Chat"))}</div></div></a></div> <div class="px-[7px] flex justify-center text-gray-800 dark:text-gray-200"><button id="sidebar-search-button" class="grow flex items-center space-x-3 rounded-2xl px-2.5 py-2 hover:bg-gray-100 dark:hover:bg-gray-900 transition outline-none" draggable="false"${add_attribute("aria-label", $i18n.t("Search"), 0)}><div class="self-center">${validate_component(Search, "Search").$$render($$result, { strokeWidth: "2", className: "size-4.5" }, {}, {})}</div> <div class="flex self-center translate-y-[0.5px]"><div class="self-center text-sm font-primary">${escape($i18n.t("Search"))}</div></div></button></div> ${($config?.features?.enable_notes ?? false) && ($user?.role === "admin" || ($user?.permissions?.features?.notes ?? true)) ? `<div class="px-[7px] flex justify-center text-gray-800 dark:text-gray-200"><a id="sidebar-notes-button" class="grow flex items-center space-x-3 rounded-2xl px-2.5 py-2 hover:bg-gray-100 dark:hover:bg-gray-900 transition" href="/notes" draggable="false"${add_attribute("aria-label", $i18n.t("Notes"), 0)}><div class="self-center">${validate_component(Note, "Note").$$render($$result, { className: "size-4.5", strokeWidth: "2" }, {}, {})}</div> <div class="flex self-center translate-y-[0.5px]"><div class="self-center text-sm font-primary">${escape($i18n.t("Notes"))}</div></div></a></div>` : ``} ${$user?.role === "admin" || $user?.permissions?.workspace?.models || $user?.permissions?.workspace?.knowledge || $user?.permissions?.workspace?.prompts || $user?.permissions?.workspace?.tools ? `<div class="px-[7px] flex justify-center text-gray-800 dark:text-gray-200"><a id="sidebar-workspace-button" class="grow flex items-center space-x-3 rounded-2xl px-2.5 py-2 hover:bg-gray-100 dark:hover:bg-gray-900 transition" href="/workspace" draggable="false"${add_attribute("aria-label", $i18n.t("Workspace"), 0)}><div class="self-center" data-svelte-h="svelte-rr3yvl"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="size-4.5"><path stroke-linecap="round" stroke-linejoin="round" d="M13.5 16.875h3.375m0 0h3.375m-3.375 0V13.5m0 3.375v3.375M6 10.5h2.25a2.25 2.25 0 0 0 2.25-2.25V6a2.25 2.25 0 0 0-2.25-2.25H6A2.25 2.25 0 0 0 3.75 6v2.25A2.25 2.25 0 0 0 6 10.5Zm0 9.75h2.25A2.25 2.25 0 0 0 10.5 18v-2.25a2.25 2.25 0 0 0-2.25-2.25H6a2.25 2.25 0 0 0-2.25 2.25V18A2.25 2.25 0 0 0 6 20.25Zm9.75-9.75H18a2.25 2.25 0 0 0 2.25-2.25V6A2.25 2.25 0 0 0 18 3.75h-2.25A2.25 2.25 0 0 0 13.5 6v2.25a2.25 2.25 0 0 0 2.25 2.25Z"></path></svg></div> <div class="flex self-center translate-y-[0.5px]"><div class="self-center text-sm font-primary">${escape($i18n.t("Workspace"))}</div></div></a></div>` : ``}</div> ${($models ?? []).length > 0 && ($settings?.pinnedModels ?? []).length > 0 ? `${validate_component(PinnedModelList, "PinnedModelList").$$render(
      $$result,
      { shiftKey, selectedChatId },
      {
        selectedChatId: ($$value) => {
          selectedChatId = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : ``} ${$config?.features?.enable_channels && ($user?.role === "admin" || $channels.length > 0) ? `${validate_component(Folder, "Folder").$$render(
      $$result,
      {
        className: "px-2 mt-0.5",
        name: $i18n.t("Channels"),
        chevron: false,
        dragAndDrop: false,
        onAdd: async () => {
          if ($user?.role === "admin") {
            await tick();
            setTimeout(
              () => {
                showCreateChannel = true;
              },
              0
            );
          }
        },
        onAddLabel: $i18n.t("Create Channel")
      },
      {},
      {
        default: () => {
          return `${each($channels, (channel) => {
            return `${validate_component(ChannelItem, "ChannelItem").$$render(
              $$result,
              {
                channel,
                onUpdate: async () => {
                  await initChannels();
                }
              },
              {},
              {}
            )}`;
          })}`;
        }
      }
    )}` : ``} ${folders$1 ? `${validate_component(Folder, "Folder").$$render(
      $$result,
      {
        className: "px-2 mt-0.5",
        name: $i18n.t("Folders"),
        chevron: false,
        onAdd: () => {
          showCreateFolderModal = true;
        },
        onAddLabel: $i18n.t("New Folder")
      },
      {},
      {
        default: () => {
          return `${validate_component(Folders, "Folders").$$render(
            $$result,
            {
              folders: folders$1,
              shiftKey,
              onDelete: (folderId) => {
                selectedFolder.set(null);
                initChatList();
              },
              folderRegistry
            },
            {
              folderRegistry: ($$value) => {
                folderRegistry = $$value;
                $$settled = false;
              }
            },
            {}
          )}`;
        }
      }
    )}` : ``} ${validate_component(Folder, "Folder").$$render(
      $$result,
      {
        className: "px-2 mt-0.5",
        name: $i18n.t("Chats"),
        chevron: false
      },
      {},
      {
        default: () => {
          return `${$pinnedChats.length > 0 ? `<div class="mb-1"><div class="flex flex-col space-y-1 rounded-xl">${validate_component(Folder, "Folder").$$render(
            $$result,
            {
              buttonClassName: " text-gray-500",
              name: $i18n.t("Pinned"),
              open: showPinnedChat
            },
            {
              open: ($$value) => {
                showPinnedChat = $$value;
                $$settled = false;
              }
            },
            {
              default: () => {
                return `<div class="ml-3 pl-1 mt-[1px] flex flex-col overflow-y-auto scrollbar-hidden border-s border-gray-100 dark:border-gray-900 text-gray-900 dark:text-gray-200">${each($pinnedChats, (chat, idx) => {
                  return `${validate_component(ChatItem, "ChatItem").$$render(
                    $$result,
                    {
                      className: "",
                      id: chat.id,
                      title: chat.title,
                      shiftKey,
                      selected: selectedChatId === chat.id
                    },
                    {},
                    {}
                  )}`;
                })}</div>`;
              }
            }
          )}</div></div>` : ``} <div class="flex-1 flex flex-col overflow-y-auto scrollbar-hidden"><div class="pt-1.5">${$chats ? `${each($chats, (chat, idx) => {
            return `${idx === 0 || idx > 0 && chat.time_range !== $chats[idx - 1].time_range ? `<div class="${"w-full pl-2.5 text-xs text-gray-500 dark:text-gray-500 font-medium " + escape(idx === 0 ? "" : "pt-5", true) + " pb-1.5"}">${escape($i18n.t(chat.time_range))}  </div>` : ``} ${validate_component(ChatItem, "ChatItem").$$render(
              $$result,
              {
                className: "",
                id: chat.id,
                title: chat.title,
                shiftKey,
                selected: selectedChatId === chat.id
              },
              {},
              {}
            )}`;
          })} ${$scrollPaginationEnabled && !allChatsLoaded ? `${validate_component(Loader, "Loader").$$render($$result, {}, {}, {
            default: () => {
              return `<div class="w-full flex justify-center py-1 text-xs animate-pulse items-center gap-2">${validate_component(Spinner, "Spinner").$$render($$result, { className: " size-4" }, {}, {})} <div class="">${escape($i18n.t("Loading..."))}</div></div>`;
            }
          })}` : ``}` : `<div class="w-full flex justify-center py-1 text-xs animate-pulse items-center gap-2">${validate_component(Spinner, "Spinner").$$render($$result, { className: " size-4" }, {}, {})} <div class="">${escape($i18n.t("Loading..."))}</div></div>`}</div></div>`;
        }
      }
    )}</div> <div class="px-1.5 pt-1.5 pb-2 sticky bottom-0 z-10 -mt-3 sidebar"><div class="sidebar-bg-gradient-to-t bg-linear-to-t from-gray-50 dark:from-gray-950 to-transparent from-50% pointer-events-none absolute inset-0 -z-10 -mt-6"></div> <div class="flex flex-col font-primary">${$user !== void 0 && $user !== null ? `${validate_component(UserMenu, "UserMenu").$$render($$result, { role: $user?.role }, {}, {
      default: () => {
        return `<div class="flex items-center rounded-2xl py-2 px-1.5 w-full hover:bg-gray-100/50 dark:hover:bg-gray-900/50 transition"><div class="self-center mr-3"><img${add_attribute("src", $user?.profile_image_url, 0)} class="size-6 object-cover rounded-full"${add_attribute("alt", $i18n.t("Open User Profile Menu"), 0)}${add_attribute("aria-label", $i18n.t("Open User Profile Menu"), 0)}></div> <div class="self-center font-medium">${escape($user?.name)}</div></div>`;
      }
    })}` : ``}</div></div></div></div>` : ``}`;
  } while (!$$settled);
  $$unsubscribe_mobile();
  $$unsubscribe_user();
  $$unsubscribe_showSidebar();
  $$unsubscribe_i18n();
  $$unsubscribe_chats();
  $$unsubscribe_currentChatPage();
  $$unsubscribe_showArchivedChats();
  $$unsubscribe_socket();
  $$unsubscribe_isApp();
  $$unsubscribe_showSearch();
  $$unsubscribe_config();
  $$unsubscribe_WEBUI_NAME();
  $$unsubscribe_models();
  $$unsubscribe_settings();
  $$unsubscribe_channels();
  $$unsubscribe_pinnedChats();
  $$unsubscribe_scrollPaginationEnabled();
  return $$rendered;
});
const General = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  let $i18n, $$unsubscribe_i18n;
  let $config, $$unsubscribe_config;
  let $user, $$unsubscribe_user;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { saveSettings } = $$props;
  let { getModels: getModels2 } = $$props;
  let languages = [];
  $i18n.language;
  let system = "";
  if ($$props.saveSettings === void 0 && $$bindings.saveSettings && saveSettings !== void 0) $$bindings.saveSettings(saveSettings);
  if ($$props.getModels === void 0 && $$bindings.getModels && getModels2 !== void 0) $$bindings.getModels(getModels2);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `<div class="flex flex-col h-full justify-between text-sm" id="tab-general"><div class="overflow-y-scroll max-h-[28rem] md:max-h-full"><div class=""><div class="mb-1 text-sm font-medium">${escape($i18n.t("WebUI Settings"))}</div> <div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Theme"))}</div> <div class="flex items-center relative"><select class="${"dark:bg-gray-900 w-fit pr-8 rounded-sm py-2 px-2 text-xs bg-transparent text-right " + escape($settings.highContrastMode ? "" : "outline-hidden", true)}"${add_attribute("placeholder", $i18n.t("Select a theme"), 0)}><option value="system">⚙️ ${escape($i18n.t("System"))}</option><option value="dark">🌑 ${escape($i18n.t("Dark"))}</option><option value="oled-dark">🌃 ${escape($i18n.t("OLED Dark"))}</option><option value="light">☀️ ${escape($i18n.t("Light"))}</option><option value="her" data-svelte-h="svelte-188ouwx">🌷 Her</option></select></div></div> <div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Language"))}</div> <div class="flex items-center relative"><select class="${"dark:bg-gray-900 w-fit pr-8 rounded-sm py-2 px-2 text-xs bg-transparent text-right " + escape($settings.highContrastMode ? "" : "outline-hidden", true)}"${add_attribute("placeholder", $i18n.t("Select a language"), 0)}>${each(languages, (language) => {
      return `<option${add_attribute("value", language["code"], 0)}>${escape(language["title"])}</option>`;
    })}</select></div></div> ${$i18n.language === "en-US" && !($config?.license_metadata ?? false) ? `<div class="${"mb-2 text-xs " + escape(
      $settings?.highContrastMode ?? false ? "text-gray-800 dark:text-gray-100" : "text-gray-400 dark:text-gray-500",
      true
    )}">Couldn&#39;t find your language?
					<a class="${"font-medium underline " + escape(
      $settings?.highContrastMode ?? false ? "text-gray-700 dark:text-gray-200" : "text-gray-300",
      true
    )}" href="https://github.com/open-webui/open-webui/blob/main/docs/CONTRIBUTING.md#-translations-and-internationalization" target="_blank">Help us translate Open WebUI!</a></div>` : ``} <div><div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape($i18n.t("Notifications"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${`<span class="ml-2 self-center">${escape($i18n.t("Off"))}</span>`}</button></div></div></div> ${$user?.role === "admin" || ($user?.permissions.chat?.system_prompt ?? true) ? `<hr class="border-gray-100/50 dark:border-gray-850 my-3"> <div><div class="my-2.5 text-sm font-medium">${escape($i18n.t("System Prompt"))}</div> ${validate_component(Textarea, "Textarea").$$render(
      $$result,
      {
        className: "w-full text-sm outline-hidden resize-vertical" + ($settings.highContrastMode ? " p-2.5 border-2 border-gray-300 dark:border-gray-700 rounded-lg bg-transparent text-gray-900 dark:text-gray-100 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 overflow-y-hidden" : "  dark:text-gray-300 "),
        rows: "4",
        placeholder: $i18n.t("Enter system prompt here"),
        value: system
      },
      {
        value: ($$value) => {
          system = $$value;
          $$settled = false;
        }
      },
      {}
    )}</div>` : ``} ${$user?.role === "admin" || ($user?.permissions.chat?.controls ?? true) ? `<div class="mt-2 space-y-3 pr-1.5"><div class="flex justify-between items-center text-sm"><div class="font-medium">${escape($i18n.t("Advanced Parameters"))}</div> <button class="${"text-xs font-medium " + escape(
      $settings?.highContrastMode ?? false ? "text-gray-800 dark:text-gray-100" : "text-gray-400 dark:text-gray-500",
      true
    )}" type="button">${escape($i18n.t("Show"))}</button></div> ${``}</div>` : ``}</div> <div class="flex justify-end pt-3 text-sm font-medium"><button class="px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full">${escape($i18n.t("Save"))}</button></div></div>`;
  } while (!$$settled);
  $$unsubscribe_settings();
  $$unsubscribe_i18n();
  $$unsubscribe_config();
  $$unsubscribe_user();
  return $$rendered;
});
const DatabaseSettings = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M4 6V12C4 12 4 15 11 15C18 15 18 12 18 12V6" stroke-linecap="round" stroke-linejoin="round"></path><path d="M11 3C18 3 18 6 18 6C18 6 18 9 11 9C4 9 4 6 4 6C4 6 4 3 11 3Z" stroke-linecap="round" stroke-linejoin="round"></path><path d="M11 21C4 21 4 18 4 18V12" stroke-linecap="round" stroke-linejoin="round"></path><path d="M19 21C20.1046 21 21 20.1046 21 19C21 17.8954 20.1046 17 19 17C18.6357 17 18.2942 17.0974 18 17.2676C17.4022 17.6134 17 18.2597 17 19C17 19.7403 17.4022 20.3866 18 20.7324C18.2942 20.9026 18.6357 21 19 21Z" stroke-linecap="round" stroke-linejoin="round"></path><path d="M19 22C20.6569 22 22 20.6569 22 19C22 17.3431 20.6569 16 19 16C17.3431 16 16 17.3431 16 19C16 20.6569 17.3431 22 19 22Z" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="0.3 2"></path></svg>`;
});
const SettingsAlt = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15Z" stroke-linecap="round" stroke-linejoin="round"></path><path d="M19.6224 10.3954L18.5247 7.7448L20 6L18 4L16.2647 5.48295L13.5578 4.36974L12.9353 2H10.981L10.3491 4.40113L7.70441 5.51596L6 4L4 6L5.45337 7.78885L4.3725 10.4463L2 11V13L4.40111 13.6555L5.51575 16.2997L4 18L6 20L7.79116 18.5403L10.397 19.6123L11 22H13L13.6045 19.6132L16.2551 18.5155C16.6969 18.8313 18 20 18 20L20 18L18.5159 16.2494L19.6139 13.598L21.9999 12.9772L22 11L19.6224 10.3954Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const UserCircle = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2Z" stroke-linecap="round" stroke-linejoin="round"></path><path d="M4.271 18.3457C4.271 18.3457 6.50002 15.5 12 15.5C17.5 15.5 19.7291 18.3457 19.7291 18.3457" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 12C13.6569 12 15 10.6569 15 9C15 7.34315 13.6569 6 12 6C10.3431 6 9 7.34315 9 9C9 10.6569 10.3431 12 12 12Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const SoundHigh = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M1 13.8571V10.1429C1 9.03829 1.89543 8.14286 3 8.14286H5.9C6.09569 8.14286 6.28708 8.08544 6.45046 7.97772L12.4495 4.02228C13.1144 3.5839 14 4.06075 14 4.85714V19.1429C14 19.9392 13.1144 20.4161 12.4495 19.9777L6.45046 16.0223C6.28708 15.9146 6.09569 15.8571 5.9 15.8571H3C1.89543 15.8571 1 14.9617 1 13.8571Z"></path><path d="M17.5 7.5C17.5 7.5 19 9 19 11.5C19 14 17.5 15.5 17.5 15.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M20.5 4.5C20.5 4.5 23 7 23 11.5C23 16 20.5 18.5 20.5 18.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const InfoCircle = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M12 11.5V16.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 7.51L12.01 7.49889" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const WrenchAlt = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M10.0503 10.6066L2.97923 17.6777C2.19818 18.4587 2.19818 19.725 2.97923 20.5061V20.5061C3.76027 21.2871 5.0266 21.2871 5.80765 20.5061L12.8787 13.435" stroke-linecap="round" stroke-linejoin="round"></path><path d="M10.0502 10.6066C9.20638 8.45358 9.37134 5.6286 11.1109 3.88909C12.8504 2.14957 16.0606 1.76777 17.8284 2.82843L14.7877 5.8691L14.5051 8.98014L17.6161 8.69753L20.6568 5.65685C21.7175 7.42462 21.3357 10.6349 19.5961 12.3744C17.8566 14.1139 15.0316 14.2789 12.8786 13.435" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const Face = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2Z" stroke-linecap="round" stroke-linejoin="round"></path><path d="M16 8L16 10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 8L8 10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M9 16C9 16 10 17 12 17C14 17 15 16 15 16" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 8L12 13L11 13" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const AppNotification = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M19 8C20.6569 8 22 6.65685 22 5C22 3.34315 20.6569 2 19 2C17.3431 2 16 3.34315 16 5C16 6.65685 17.3431 8 19 8Z" stroke-linecap="round" stroke-linejoin="round"></path><path d="M21 12V15C21 18.3137 18.3137 21 15 21H9C5.68629 21 3 18.3137 3 15V9C3 5.68629 5.68629 3 9 3H12" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const UserBadgeCheck = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M2 20V19C2 15.134 5.13401 12 9 12V12" stroke-linecap="round" stroke-linejoin="round"></path><path d="M15.8038 12.3135C16.4456 11.6088 17.5544 11.6088 18.1962 12.3135V12.3135C18.5206 12.6697 18.9868 12.8628 19.468 12.8403V12.8403C20.4201 12.7958 21.2042 13.5799 21.1597 14.532V14.532C21.1372 15.0132 21.3303 15.4794 21.6865 15.8038V15.8038C22.3912 16.4456 22.3912 17.5544 21.6865 18.1962V18.1962C21.3303 18.5206 21.1372 18.9868 21.1597 19.468V19.468C21.2042 20.4201 20.4201 21.2042 19.468 21.1597V21.1597C18.9868 21.1372 18.5206 21.3303 18.1962 21.6865V21.6865C17.5544 22.3912 16.4456 22.3912 15.8038 21.6865V21.6865C15.4794 21.3303 15.0132 21.1372 14.532 21.1597V21.1597C13.5799 21.2042 12.7958 20.4201 12.8403 19.468V19.468C12.8628 18.9868 12.6697 18.5206 12.3135 18.1962V18.1962C11.6088 17.5544 11.6088 16.4456 12.3135 15.8038V15.8038C12.6697 15.4794 12.8628 15.0132 12.8403 14.532V14.532C12.7958 13.5799 13.5799 12.7958 14.532 12.8403V12.8403C15.0132 12.8628 15.4794 12.6697 15.8038 12.3135V12.3135Z"></path><path d="M15.3636 17L16.4546 18.0909L18.6364 15.9091" stroke-linecap="round" stroke-linejoin="round"></path><path d="M9 12C11.2091 12 13 10.2091 13 8C13 5.79086 11.2091 4 9 4C6.79086 4 5 5.79086 5 8C5 10.2091 6.79086 12 9 12Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const css$2 = {
  code: "input.svelte-187gxci::-webkit-outer-spin-button,input.svelte-187gxci::-webkit-inner-spin-button{-webkit-appearance:none;margin:0}.tabs.svelte-187gxci::-webkit-scrollbar{display:none}.tabs.svelte-187gxci{-ms-overflow-style:none;scrollbar-width:none}",
  map: `{"version":3,"file":"SettingsModal.svelte","sources":["SettingsModal.svelte"],"sourcesContent":["<script lang=\\"ts\\">import { getContext, onMount, tick } from \\"svelte\\";\\nimport { toast } from \\"svelte-sonner\\";\\nimport { config, models, settings, user } from \\"$lib/stores\\";\\nimport { updateUserSettings } from \\"$lib/apis/users\\";\\nimport { getModels as _getModels } from \\"$lib/apis\\";\\nimport { goto } from \\"$app/navigation\\";\\nimport Modal from \\"../common/Modal.svelte\\";\\nimport Account from \\"./Settings/Account.svelte\\";\\nimport About from \\"./Settings/About.svelte\\";\\nimport General from \\"./Settings/General.svelte\\";\\nimport Interface from \\"./Settings/Interface.svelte\\";\\nimport Audio from \\"./Settings/Audio.svelte\\";\\nimport DataControls from \\"./Settings/DataControls.svelte\\";\\nimport Personalization from \\"./Settings/Personalization.svelte\\";\\nimport Search from \\"../icons/Search.svelte\\";\\nimport XMark from \\"../icons/XMark.svelte\\";\\nimport Connections from \\"./Settings/Connections.svelte\\";\\nimport Tools from \\"./Settings/Tools.svelte\\";\\nimport DatabaseSettings from \\"../icons/DatabaseSettings.svelte\\";\\nimport SettingsAlt from \\"../icons/SettingsAlt.svelte\\";\\nimport Link from \\"../icons/Link.svelte\\";\\nimport UserCircle from \\"../icons/UserCircle.svelte\\";\\nimport SoundHigh from \\"../icons/SoundHigh.svelte\\";\\nimport InfoCircle from \\"../icons/InfoCircle.svelte\\";\\nimport WrenchAlt from \\"../icons/WrenchAlt.svelte\\";\\nimport Face from \\"../icons/Face.svelte\\";\\nimport AppNotification from \\"../icons/AppNotification.svelte\\";\\nimport UserBadgeCheck from \\"../icons/UserBadgeCheck.svelte\\";\\nconst i18n = getContext(\\"i18n\\");\\nexport let show = false;\\n$: if (show) {\\n  addScrollListener();\\n} else {\\n  removeScrollListener();\\n}\\nconst allSettings = [\\n  {\\n    id: \\"general\\",\\n    title: \\"General\\",\\n    keywords: [\\n      \\"advancedparams\\",\\n      \\"advancedparameters\\",\\n      \\"advanced params\\",\\n      \\"advanced parameters\\",\\n      \\"configuration\\",\\n      \\"defaultparameters\\",\\n      \\"default parameters\\",\\n      \\"defaultsettings\\",\\n      \\"default settings\\",\\n      \\"general\\",\\n      \\"keepalive\\",\\n      \\"keep alive\\",\\n      \\"languages\\",\\n      \\"notifications\\",\\n      \\"requestmode\\",\\n      \\"request mode\\",\\n      \\"systemparameters\\",\\n      \\"system parameters\\",\\n      \\"systemprompt\\",\\n      \\"system prompt\\",\\n      \\"systemsettings\\",\\n      \\"system settings\\",\\n      \\"theme\\",\\n      \\"translate\\",\\n      \\"webuisettings\\",\\n      \\"webui settings\\"\\n    ]\\n  },\\n  {\\n    id: \\"interface\\",\\n    title: \\"Interface\\",\\n    keywords: [\\n      \\"allow user location\\",\\n      \\"allow voice interruption in call\\",\\n      \\"allowuserlocation\\",\\n      \\"allowvoiceinterruptionincall\\",\\n      \\"always collapse codeblocks\\",\\n      \\"always collapse code blocks\\",\\n      \\"always expand details\\",\\n      \\"always on web search\\",\\n      \\"always play notification sound\\",\\n      \\"alwayscollapsecodeblocks\\",\\n      \\"alwaysexpanddetails\\",\\n      \\"alwaysonwebsearch\\",\\n      \\"alwaysplaynotificationsound\\",\\n      \\"android\\",\\n      \\"auto chat tags\\",\\n      \\"auto copy response to clipboard\\",\\n      \\"auto title\\",\\n      \\"autochattags\\",\\n      \\"autocopyresponsetoclipboard\\",\\n      \\"autotitle\\",\\n      \\"beta\\",\\n      \\"call\\",\\n      \\"chat background image\\",\\n      \\"chat bubble ui\\",\\n      \\"chat direction\\",\\n      \\"chat tags autogen\\",\\n      \\"chat tags autogeneration\\",\\n      \\"chat ui\\",\\n      \\"chatbackgroundimage\\",\\n      \\"chatbubbleui\\",\\n      \\"chatdirection\\",\\n      \\"chat tags autogeneration\\",\\n      \\"chattagsautogeneration\\",\\n      \\"chatui\\",\\n      \\"copy formatted text\\",\\n      \\"copyformattedtext\\",\\n      \\"default model\\",\\n      \\"defaultmodel\\",\\n      \\"design\\",\\n      \\"detect artifacts automatically\\",\\n      \\"detectartifactsautomatically\\",\\n      \\"display emoji in call\\",\\n      \\"display username\\",\\n      \\"displayemojiincall\\",\\n      \\"displayusername\\",\\n      \\"enter key behavior\\",\\n      \\"enterkeybehavior\\",\\n      \\"expand mode\\",\\n      \\"expandmode\\",\\n      \\"file\\",\\n      \\"followup autogeneration\\",\\n      \\"followupautogeneration\\",\\n      \\"fullscreen\\",\\n      \\"fullwidthmode\\",\\n      \\"full width mode\\",\\n      \\"haptic feedback\\",\\n      \\"hapticfeedback\\",\\n      \\"high contrast mode\\",\\n      \\"highcontrastmode\\",\\n      \\"iframe sandbox allow forms\\",\\n      \\"iframe sandbox allow same origin\\",\\n      \\"iframesandboxallowforms\\",\\n      \\"iframesandboxallowsameorigin\\",\\n      \\"imagecompression\\",\\n      \\"image compression\\",\\n      \\"imagemaxcompressionsize\\",\\n      \\"image max compression size\\",\\n      \\"interface customization\\",\\n      \\"interface options\\",\\n      \\"interfacecustomization\\",\\n      \\"interfaceoptions\\",\\n      \\"landing page mode\\",\\n      \\"landingpagemode\\",\\n      \\"layout\\",\\n      \\"left to right\\",\\n      \\"left-to-right\\",\\n      \\"lefttoright\\",\\n      \\"ltr\\",\\n      \\"paste large text as file\\",\\n      \\"pastelargetextasfile\\",\\n      \\"reset background\\",\\n      \\"resetbackground\\",\\n      \\"response auto copy\\",\\n      \\"responseautocopy\\",\\n      \\"rich text input for chat\\",\\n      \\"richtextinputforchat\\",\\n      \\"right to left\\",\\n      \\"right-to-left\\",\\n      \\"righttoleft\\",\\n      \\"rtl\\",\\n      \\"scroll behavior\\",\\n      \\"scroll on branch change\\",\\n      \\"scrollbehavior\\",\\n      \\"scrollonbranchchange\\",\\n      \\"select model\\",\\n      \\"selectmodel\\",\\n      \\"settings\\",\\n      \\"show username\\",\\n      \\"showusername\\",\\n      \\"stream large chunks\\",\\n      \\"streamlargechunks\\",\\n      \\"stylized pdf export\\",\\n      \\"stylizedpdfexport\\",\\n      \\"title autogeneration\\",\\n      \\"titleautogeneration\\",\\n      \\"toast notifications for new updates\\",\\n      \\"toastnotificationsfornewupdates\\",\\n      \\"upload background\\",\\n      \\"uploadbackground\\",\\n      \\"user interface\\",\\n      \\"user location access\\",\\n      \\"userinterface\\",\\n      \\"userlocationaccess\\",\\n      \\"vibration\\",\\n      \\"voice control\\",\\n      \\"voicecontrol\\",\\n      \\"widescreen mode\\",\\n      \\"widescreenmode\\",\\n      \\"whatsnew\\",\\n      \\"whats new\\",\\n      \\"websearchinchat\\",\\n      \\"web search in chat\\"\\n    ]\\n  },\\n  {\\n    id: \\"connections\\",\\n    title: \\"Connections\\",\\n    keywords: [\\n      \\"addconnection\\",\\n      \\"add connection\\",\\n      \\"manageconnections\\",\\n      \\"manage connections\\",\\n      \\"manage direct connections\\",\\n      \\"managedirectconnections\\",\\n      \\"settings\\"\\n    ]\\n  },\\n  {\\n    id: \\"tools\\",\\n    title: \\"External Tools\\",\\n    keywords: [\\n      \\"addconnection\\",\\n      \\"add connection\\",\\n      \\"managetools\\",\\n      \\"manage tools\\",\\n      \\"manage tool servers\\",\\n      \\"managetoolservers\\",\\n      \\"settings\\"\\n    ]\\n  },\\n  {\\n    id: \\"personalization\\",\\n    title: \\"Personalization\\",\\n    keywords: [\\n      \\"account preferences\\",\\n      \\"account settings\\",\\n      \\"accountpreferences\\",\\n      \\"accountsettings\\",\\n      \\"custom settings\\",\\n      \\"customsettings\\",\\n      \\"experimental\\",\\n      \\"memories\\",\\n      \\"memory\\",\\n      \\"personalization\\",\\n      \\"personalize\\",\\n      \\"personal settings\\",\\n      \\"personalsettings\\",\\n      \\"profile\\",\\n      \\"user preferences\\",\\n      \\"userpreferences\\"\\n    ]\\n  },\\n  {\\n    id: \\"audio\\",\\n    title: \\"Audio\\",\\n    keywords: [\\n      \\"audio config\\",\\n      \\"audio control\\",\\n      \\"audio features\\",\\n      \\"audio input\\",\\n      \\"audio output\\",\\n      \\"audio playback\\",\\n      \\"audio voice\\",\\n      \\"audioconfig\\",\\n      \\"audiocontrol\\",\\n      \\"audiofeatures\\",\\n      \\"audioinput\\",\\n      \\"audiooutput\\",\\n      \\"audioplayback\\",\\n      \\"audiovoice\\",\\n      \\"auto playback response\\",\\n      \\"autoplaybackresponse\\",\\n      \\"auto transcribe\\",\\n      \\"autotranscribe\\",\\n      \\"instant auto send after voice transcription\\",\\n      \\"instantautosendaftervoicetranscription\\",\\n      \\"language\\",\\n      \\"non local voices\\",\\n      \\"nonlocalvoices\\",\\n      \\"save settings\\",\\n      \\"savesettings\\",\\n      \\"set voice\\",\\n      \\"setvoice\\",\\n      \\"sound settings\\",\\n      \\"soundsettings\\",\\n      \\"speech config\\",\\n      \\"speech mode\\",\\n      \\"speech playback speed\\",\\n      \\"speech rate\\",\\n      \\"speech recognition\\",\\n      \\"speech settings\\",\\n      \\"speech speed\\",\\n      \\"speech synthesis\\",\\n      \\"speech to text engine\\",\\n      \\"speechconfig\\",\\n      \\"speechmode\\",\\n      \\"speechplaybackspeed\\",\\n      \\"speechrate\\",\\n      \\"speechrecognition\\",\\n      \\"speechsettings\\",\\n      \\"speechspeed\\",\\n      \\"speechsynthesis\\",\\n      \\"speechtotextengine\\",\\n      \\"speedch playback rate\\",\\n      \\"speedchplaybackrate\\",\\n      \\"stt settings\\",\\n      \\"sttsettings\\",\\n      \\"text to speech engine\\",\\n      \\"text to speech\\",\\n      \\"textospeechengine\\",\\n      \\"texttospeech\\",\\n      \\"texttospeechvoice\\",\\n      \\"text to speech voice\\",\\n      \\"voice control\\",\\n      \\"voice modes\\",\\n      \\"voice options\\",\\n      \\"voice playback\\",\\n      \\"voice recognition\\",\\n      \\"voice speed\\",\\n      \\"voicecontrol\\",\\n      \\"voicemodes\\",\\n      \\"voiceoptions\\",\\n      \\"voiceplayback\\",\\n      \\"voicerecognition\\",\\n      \\"voicespeed\\",\\n      \\"volume\\"\\n    ]\\n  },\\n  {\\n    id: \\"data_controls\\",\\n    title: \\"Data Controls\\",\\n    keywords: [\\n      \\"archive all chats\\",\\n      \\"archive chats\\",\\n      \\"archiveallchats\\",\\n      \\"archivechats\\",\\n      \\"archived chats\\",\\n      \\"archivedchats\\",\\n      \\"chat activity\\",\\n      \\"chat history\\",\\n      \\"chat settings\\",\\n      \\"chatactivity\\",\\n      \\"chathistory\\",\\n      \\"chatsettings\\",\\n      \\"conversation activity\\",\\n      \\"conversation history\\",\\n      \\"conversationactivity\\",\\n      \\"conversationhistory\\",\\n      \\"conversations\\",\\n      \\"convos\\",\\n      \\"delete all chats\\",\\n      \\"delete chats\\",\\n      \\"deleteallchats\\",\\n      \\"deletechats\\",\\n      \\"export chats\\",\\n      \\"exportchats\\",\\n      \\"import chats\\",\\n      \\"importchats\\",\\n      \\"message activity\\",\\n      \\"message archive\\",\\n      \\"message history\\",\\n      \\"messagearchive\\",\\n      \\"messagehistory\\"\\n    ]\\n  },\\n  {\\n    id: \\"account\\",\\n    title: \\"Account\\",\\n    keywords: [\\n      \\"account preferences\\",\\n      \\"account settings\\",\\n      \\"accountpreferences\\",\\n      \\"accountsettings\\",\\n      \\"api keys\\",\\n      \\"apikeys\\",\\n      \\"change password\\",\\n      \\"changepassword\\",\\n      \\"jwt token\\",\\n      \\"jwttoken\\",\\n      \\"login\\",\\n      \\"new password\\",\\n      \\"newpassword\\",\\n      \\"notification webhook url\\",\\n      \\"notificationwebhookurl\\",\\n      \\"personal settings\\",\\n      \\"personalsettings\\",\\n      \\"privacy settings\\",\\n      \\"privacysettings\\",\\n      \\"profileavatar\\",\\n      \\"profile avatar\\",\\n      \\"profile details\\",\\n      \\"profile image\\",\\n      \\"profile picture\\",\\n      \\"profiledetails\\",\\n      \\"profileimage\\",\\n      \\"profilepicture\\",\\n      \\"security settings\\",\\n      \\"securitysettings\\",\\n      \\"update account\\",\\n      \\"update password\\",\\n      \\"updateaccount\\",\\n      \\"updatepassword\\",\\n      \\"user account\\",\\n      \\"user data\\",\\n      \\"user preferences\\",\\n      \\"user profile\\",\\n      \\"useraccount\\",\\n      \\"userdata\\",\\n      \\"username\\",\\n      \\"userpreferences\\",\\n      \\"userprofile\\",\\n      \\"webhook url\\",\\n      \\"webhookurl\\"\\n    ]\\n  },\\n  {\\n    id: \\"about\\",\\n    title: \\"About\\",\\n    keywords: [\\n      \\"about app\\",\\n      \\"about me\\",\\n      \\"about open webui\\",\\n      \\"about page\\",\\n      \\"about us\\",\\n      \\"aboutapp\\",\\n      \\"aboutme\\",\\n      \\"aboutopenwebui\\",\\n      \\"aboutpage\\",\\n      \\"aboutus\\",\\n      \\"check for updates\\",\\n      \\"checkforupdates\\",\\n      \\"contact\\",\\n      \\"copyright\\",\\n      \\"details\\",\\n      \\"discord\\",\\n      \\"documentation\\",\\n      \\"github\\",\\n      \\"help\\",\\n      \\"information\\",\\n      \\"license\\",\\n      \\"redistributions\\",\\n      \\"release\\",\\n      \\"see whats new\\",\\n      \\"seewhatsnew\\",\\n      \\"settings\\",\\n      \\"software info\\",\\n      \\"softwareinfo\\",\\n      \\"support\\",\\n      \\"terms and conditions\\",\\n      \\"terms of use\\",\\n      \\"termsandconditions\\",\\n      \\"termsofuse\\",\\n      \\"timothy jae ryang baek\\",\\n      \\"timothy j baek\\",\\n      \\"timothyjaeryangbaek\\",\\n      \\"timothyjbaek\\",\\n      \\"twitter\\",\\n      \\"update info\\",\\n      \\"updateinfo\\",\\n      \\"version info\\",\\n      \\"versioninfo\\"\\n    ]\\n  }\\n];\\nlet availableSettings = [];\\nlet filteredSettings = [];\\nlet search = \\"\\";\\nlet searchDebounceTimeout;\\nconst getAvailableSettings = () => {\\n  return allSettings.filter((tab) => {\\n    if (tab.id === \\"connections\\") {\\n      return $config?.features?.enable_direct_connections;\\n    }\\n    if (tab.id === \\"tools\\") {\\n      return $user?.role === \\"admin\\" || $user?.role === \\"user\\" && $user?.permissions?.features?.direct_tool_servers;\\n    }\\n    return true;\\n  });\\n};\\nconst setFilteredSettings = () => {\\n  filteredSettings = availableSettings.filter((tab) => {\\n    return search === \\"\\" || tab.title.toLowerCase().includes(search.toLowerCase().trim()) || tab.keywords.some((keyword) => keyword.includes(search.toLowerCase().trim()));\\n  }).map((tab) => tab.id);\\n  if (filteredSettings.length > 0 && !filteredSettings.includes(selectedTab)) {\\n    selectedTab = filteredSettings[0];\\n  }\\n};\\nconst searchDebounceHandler = () => {\\n  if (searchDebounceTimeout) {\\n    clearTimeout(searchDebounceTimeout);\\n  }\\n  searchDebounceTimeout = setTimeout(() => {\\n    setFilteredSettings();\\n  }, 100);\\n};\\nconst saveSettings = async (updated) => {\\n  console.log(updated);\\n  await settings.set({ ...$settings, ...updated });\\n  await models.set(await getModels());\\n  await updateUserSettings(localStorage.token, { ui: $settings });\\n};\\nconst getModels = async () => {\\n  return await _getModels(\\n    localStorage.token,\\n    $config?.features?.enable_direct_connections && ($settings?.directConnections ?? null)\\n  );\\n};\\nlet selectedTab = \\"general\\";\\nconst scrollHandler = (event) => {\\n  const settingsTabsContainer = document.getElementById(\\"settings-tabs-container\\");\\n  if (settingsTabsContainer) {\\n    event.preventDefault();\\n    settingsTabsContainer.scrollLeft += event.deltaY;\\n  }\\n};\\nconst addScrollListener = async () => {\\n  await tick();\\n  const settingsTabsContainer = document.getElementById(\\"settings-tabs-container\\");\\n  if (settingsTabsContainer) {\\n    settingsTabsContainer.addEventListener(\\"wheel\\", scrollHandler);\\n  }\\n};\\nconst removeScrollListener = async () => {\\n  await tick();\\n  const settingsTabsContainer = document.getElementById(\\"settings-tabs-container\\");\\n  if (settingsTabsContainer) {\\n    settingsTabsContainer.removeEventListener(\\"wheel\\", scrollHandler);\\n  }\\n};\\nonMount(() => {\\n  availableSettings = getAvailableSettings();\\n  setFilteredSettings();\\n  config.subscribe((configData) => {\\n    availableSettings = getAvailableSettings();\\n    setFilteredSettings();\\n  });\\n});\\n<\/script>\\n\\n<Modal size=\\"xl\\" bind:show>\\n\\t<div class=\\"text-gray-700 dark:text-gray-100 mx-1\\">\\n\\t\\t<div class=\\" flex justify-between dark:text-gray-300 px-4 md:px-4.5 pt-4.5 pb-0.5 md:pb-2.5\\">\\n\\t\\t\\t<div class=\\" text-lg font-medium self-center\\">{$i18n.t('Settings')}</div>\\n\\t\\t\\t<button\\n\\t\\t\\t\\taria-label={$i18n.t('Close settings modal')}\\n\\t\\t\\t\\tclass=\\"self-center\\"\\n\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\tshow = false;\\n\\t\\t\\t\\t}}\\n\\t\\t\\t>\\n\\t\\t\\t\\t<XMark className=\\"w-5 h-5\\"></XMark>\\n\\t\\t\\t</button>\\n\\t\\t</div>\\n\\n\\t\\t<div class=\\"flex flex-col md:flex-row w-full pt-1 pb-4\\">\\n\\t\\t\\t<div\\n\\t\\t\\t\\trole=\\"tablist\\"\\n\\t\\t\\t\\tid=\\"settings-tabs-container\\"\\n\\t\\t\\t\\tclass=\\"tabs flex flex-row overflow-x-auto gap-2.5 mx-3 md:pr-4 md:gap-1 md:flex-col flex-1 md:flex-none md:w-50 md:min-h-[36rem] md:max-h-[36rem] dark:text-gray-200 text-sm text-left mb-1 md:mb-0 -translate-y-1\\"\\n\\t\\t\\t>\\n\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\tclass=\\"hidden md:flex w-full rounded-full px-2.5 gap-2 bg-gray-100/80 dark:bg-gray-850/80 backdrop-blur-2xl my-1 mb-1.5\\"\\n\\t\\t\\t\\t\\tid=\\"settings-search\\"\\n\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t<div class=\\"self-center rounded-l-xl bg-transparent\\">\\n\\t\\t\\t\\t\\t\\t<Search\\n\\t\\t\\t\\t\\t\\t\\tclassName=\\"size-3.5\\"\\n\\t\\t\\t\\t\\t\\t\\tstrokeWidth={($settings?.highContrastMode ?? false) ? '3' : '1.5'}\\n\\t\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t<label class=\\"sr-only\\" for=\\"search-input-settings-modal\\">{$i18n.t('Search')}</label>\\n\\t\\t\\t\\t\\t<input\\n\\t\\t\\t\\t\\t\\tclass={\`w-full py-1 text-sm bg-transparent dark:text-gray-300 outline-hidden\\n\\t\\t\\t\\t\\t\\t\\t\\t\${($settings?.highContrastMode ?? false) ? 'placeholder-gray-800' : ''}\`}\\n\\t\\t\\t\\t\\t\\tbind:value={search}\\n\\t\\t\\t\\t\\t\\tid=\\"search-input-settings-modal\\"\\n\\t\\t\\t\\t\\t\\ton:input={searchDebounceHandler}\\n\\t\\t\\t\\t\\t\\tplaceholder={$i18n.t('Search')}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t{#if filteredSettings.length > 0}\\n\\t\\t\\t\\t\\t{#each filteredSettings as tabId (tabId)}\\n\\t\\t\\t\\t\\t\\t{#if tabId === 'general'}\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-general\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'general'}\\n\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'general'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'general';\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<SettingsAlt strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('General')}</div>\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'interface'}\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-interface\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'interface'}\\n\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'interface'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'interface';\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<AppNotification strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('Interface')}</div>\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'connections'}\\n\\t\\t\\t\\t\\t\\t\\t{#if $user?.role === 'admin' || ($user?.role === 'user' && $config?.features?.enable_direct_connections)}\\n\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-connections\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'connections'}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'connections'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'connections';\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<Link strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('Connections')}</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'tools'}\\n\\t\\t\\t\\t\\t\\t\\t{#if $user?.role === 'admin' || ($user?.role === 'user' && $user?.permissions?.features?.direct_tool_servers)}\\n\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-tools\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'tools'}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'tools'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'tools';\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<WrenchAlt strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('External Tools')}</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'personalization'}\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-personalization\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'personalization'}\\n\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'personalization'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'personalization';\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<Face strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('Personalization')}</div>\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'audio'}\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-audio\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'audio'}\\n\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'audio'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'audio';\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<SoundHigh strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('Audio')}</div>\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'data_controls'}\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-data-controls\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'data_controls'}\\n\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'data_controls'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'data_controls';\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<DatabaseSettings strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('Data Controls')}</div>\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'account'}\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-account\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'account'}\\n\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'account'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'account';\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<UserCircle strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('Account')}</div>\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t{:else if tabId === 'about'}\\n\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\trole=\\"tab\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-controls=\\"tab-about\\"\\n\\t\\t\\t\\t\\t\\t\\t\\taria-selected={selectedTab === 'about'}\\n\\t\\t\\t\\t\\t\\t\\t\\tclass={\`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition\\n\\t\\t\\t\\t\\t\\t\\t\\t\${\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab === 'about'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'dark:bg-gray-800 bg-gray-200'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ''\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: ($settings?.highContrastMode ?? false)\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'\\n\\t\\t\\t\\t\\t\\t\\t\\t}\`}\\n\\t\\t\\t\\t\\t\\t\\t\\ton:click={() => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\tselectedTab = 'about';\\n\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<InfoCircle strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('About')}</div>\\n\\t\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t\\t{/each}\\n\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t<div class=\\"text-center text-gray-500 mt-4\\">\\n\\t\\t\\t\\t\\t\\t{$i18n.t('No results found')}\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t{#if $user?.role === 'admin'}\\n\\t\\t\\t\\t\\t<a\\n\\t\\t\\t\\t\\t\\thref=\\"/admin/settings\\"\\n\\t\\t\\t\\t\\t\\tclass=\\"px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none md:mt-auto flex text-left transition {$settings?.highContrastMode\\n\\t\\t\\t\\t\\t\\t\\t? 'hover:bg-gray-200 dark:hover:bg-gray-800'\\n\\t\\t\\t\\t\\t\\t\\t: 'text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white'}\\"\\n\\t\\t\\t\\t\\t\\ton:click={async (e) => {\\n\\t\\t\\t\\t\\t\\t\\te.preventDefault();\\n\\t\\t\\t\\t\\t\\t\\tawait goto('/admin/settings');\\n\\t\\t\\t\\t\\t\\t\\tshow = false;\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t<div class=\\" self-center mr-2\\">\\n\\t\\t\\t\\t\\t\\t\\t<UserBadgeCheck strokeWidth=\\"2\\" />\\n\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t<div class=\\" self-center\\">{$i18n.t('Admin Settings')}</div>\\n\\t\\t\\t\\t\\t</a>\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t</div>\\n\\t\\t\\t<div class=\\"flex-1 px-3.5 md:pl-0 md:pr-4.5 md:min-h-[36rem] max-h-[36rem]\\">\\n\\t\\t\\t\\t{#if selectedTab === 'general'}\\n\\t\\t\\t\\t\\t<General\\n\\t\\t\\t\\t\\t\\t{getModels}\\n\\t\\t\\t\\t\\t\\t{saveSettings}\\n\\t\\t\\t\\t\\t\\ton:save={() => {\\n\\t\\t\\t\\t\\t\\t\\ttoast.success($i18n.t('Settings saved successfully!'));\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t{:else if selectedTab === 'interface'}\\n\\t\\t\\t\\t\\t<Interface\\n\\t\\t\\t\\t\\t\\t{saveSettings}\\n\\t\\t\\t\\t\\t\\ton:save={() => {\\n\\t\\t\\t\\t\\t\\t\\ttoast.success($i18n.t('Settings saved successfully!'));\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t{:else if selectedTab === 'connections'}\\n\\t\\t\\t\\t\\t<Connections\\n\\t\\t\\t\\t\\t\\tsaveSettings={async (updated) => {\\n\\t\\t\\t\\t\\t\\t\\tawait saveSettings(updated);\\n\\t\\t\\t\\t\\t\\t\\ttoast.success($i18n.t('Settings saved successfully!'));\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t{:else if selectedTab === 'tools'}\\n\\t\\t\\t\\t\\t<Tools\\n\\t\\t\\t\\t\\t\\tsaveSettings={async (updated) => {\\n\\t\\t\\t\\t\\t\\t\\tawait saveSettings(updated);\\n\\t\\t\\t\\t\\t\\t\\ttoast.success($i18n.t('Settings saved successfully!'));\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t{:else if selectedTab === 'personalization'}\\n\\t\\t\\t\\t\\t<Personalization\\n\\t\\t\\t\\t\\t\\t{saveSettings}\\n\\t\\t\\t\\t\\t\\ton:save={() => {\\n\\t\\t\\t\\t\\t\\t\\ttoast.success($i18n.t('Settings saved successfully!'));\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t{:else if selectedTab === 'audio'}\\n\\t\\t\\t\\t\\t<Audio\\n\\t\\t\\t\\t\\t\\t{saveSettings}\\n\\t\\t\\t\\t\\t\\ton:save={() => {\\n\\t\\t\\t\\t\\t\\t\\ttoast.success($i18n.t('Settings saved successfully!'));\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t{:else if selectedTab === 'data_controls'}\\n\\t\\t\\t\\t\\t<DataControls {saveSettings} />\\n\\t\\t\\t\\t{:else if selectedTab === 'account'}\\n\\t\\t\\t\\t\\t<Account\\n\\t\\t\\t\\t\\t\\t{saveSettings}\\n\\t\\t\\t\\t\\t\\tsaveHandler={() => {\\n\\t\\t\\t\\t\\t\\t\\ttoast.success($i18n.t('Settings saved successfully!'));\\n\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t/>\\n\\t\\t\\t\\t{:else if selectedTab === 'about'}\\n\\t\\t\\t\\t\\t<About />\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t</div>\\n\\t\\t</div>\\n\\t</div>\\n</Modal>\\n\\n<style>\\n\\tinput::-webkit-outer-spin-button,\\n\\tinput::-webkit-inner-spin-button {\\n\\t\\t/* display: none; <- Crashes Chrome on hover */\\n\\t\\t-webkit-appearance: none;\\n\\t\\tmargin: 0; /* <-- Apparently some margin are still there even though it's hidden */\\n\\t}\\n\\n\\t.tabs::-webkit-scrollbar {\\n\\t\\tdisplay: none; /* for Chrome, Safari and Opera */\\n\\t}\\n\\n\\t.tabs {\\n\\t\\t-ms-overflow-style: none; /* IE and Edge */\\n\\t\\tscrollbar-width: none; /* Firefox */\\n\\t}\\n\\n\\tinput[type='number'] {\\n\\t\\tappearance: textfield;\\n\\t\\t-moz-appearance: textfield; /* Firefox */\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AAk3BC,oBAAK,2BAA2B,CAChC,oBAAK,2BAA4B,CAEhC,kBAAkB,CAAE,IAAI,CACxB,MAAM,CAAE,CACT,CAEA,oBAAK,mBAAoB,CACxB,OAAO,CAAE,IACV,CAEA,oBAAM,CACL,kBAAkB,CAAE,IAAI,CACxB,eAAe,CAAE,IAClB"}`
};
const SettingsModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $settings, $$unsubscribe_settings;
  let $config, $$unsubscribe_config;
  let $user, $$unsubscribe_user;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let filteredSettings = [];
  let search = "";
  const saveSettings = async (updated) => {
    /* @__PURE__ */ console.log(updated);
    await settings.set({ ...$settings, ...updated });
    await models.set(await getModels$1());
    await updateUserSettings(localStorage.token, { ui: $settings });
  };
  const getModels$1 = async () => {
    return await getModels(localStorage.token, $config?.features?.enable_direct_connections && ($settings?.directConnections ?? null));
  };
  let selectedTab = "general";
  const scrollHandler = (event) => {
    const settingsTabsContainer = document.getElementById("settings-tabs-container");
    if (settingsTabsContainer) {
      event.preventDefault();
      settingsTabsContainer.scrollLeft += event.deltaY;
    }
  };
  const addScrollListener = async () => {
    await tick();
    const settingsTabsContainer = document.getElementById("settings-tabs-container");
    if (settingsTabsContainer) {
      settingsTabsContainer.addEventListener("wheel", scrollHandler);
    }
  };
  const removeScrollListener = async () => {
    await tick();
    const settingsTabsContainer = document.getElementById("settings-tabs-container");
    if (settingsTabsContainer) {
      settingsTabsContainer.removeEventListener("wheel", scrollHandler);
    }
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  $$result.css.add(css$2);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        addScrollListener();
      } else {
        removeScrollListener();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "xl", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="text-gray-700 dark:text-gray-100 mx-1"><div class="flex justify-between dark:text-gray-300 px-4 md:px-4.5 pt-4.5 pb-0.5 md:pb-2.5"><div class="text-lg font-medium self-center">${escape($i18n.t("Settings"))}</div> <button${add_attribute("aria-label", $i18n.t("Close settings modal"), 0)} class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "w-5 h-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full pt-1 pb-4"><div role="tablist" id="settings-tabs-container" class="tabs flex flex-row overflow-x-auto gap-2.5 mx-3 md:pr-4 md:gap-1 md:flex-col flex-1 md:flex-none md:w-50 md:min-h-[36rem] md:max-h-[36rem] dark:text-gray-200 text-sm text-left mb-1 md:mb-0 -translate-y-1 svelte-187gxci"><div class="hidden md:flex w-full rounded-full px-2.5 gap-2 bg-gray-100/80 dark:bg-gray-850/80 backdrop-blur-2xl my-1 mb-1.5" id="settings-search"><div class="self-center rounded-l-xl bg-transparent">${validate_component(Search, "Search").$$render(
            $$result,
            {
              className: "size-3.5",
              strokeWidth: $settings?.highContrastMode ?? false ? "3" : "1.5"
            },
            {},
            {}
          )}</div> <label class="sr-only" for="search-input-settings-modal">${escape($i18n.t("Search"))}</label> <input class="${escape(
            null_to_empty(`w-full py-1 text-sm bg-transparent dark:text-gray-300 outline-hidden
								${$settings?.highContrastMode ?? false ? "placeholder-gray-800" : ""}`),
            true
          ) + " svelte-187gxci"}" id="search-input-settings-modal"${add_attribute("placeholder", $i18n.t("Search"), 0)}${add_attribute("value", search, 0)}></div> ${filteredSettings.length > 0 ? `${each(filteredSettings, (tabId) => {
            return `${tabId === "general" ? `<button role="tab" aria-controls="tab-general"${add_attribute("aria-selected", selectedTab === "general", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "dark:bg-gray-800 bg-gray-200" : ""}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(SettingsAlt, "SettingsAlt").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("General"))}</div> </button>` : `${tabId === "interface" ? `<button role="tab" aria-controls="tab-interface"${add_attribute("aria-selected", selectedTab === "interface", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(AppNotification, "AppNotification").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("Interface"))}</div> </button>` : `${tabId === "connections" ? `${$user?.role === "admin" || $user?.role === "user" && $config?.features?.enable_direct_connections ? `<button role="tab" aria-controls="tab-connections"${add_attribute("aria-selected", selectedTab === "connections", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(Link, "Link").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("Connections"))}</div> </button>` : ``}` : `${tabId === "tools" ? `${$user?.role === "admin" || $user?.role === "user" && $user?.permissions?.features?.direct_tool_servers ? `<button role="tab" aria-controls="tab-tools"${add_attribute("aria-selected", selectedTab === "tools", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(WrenchAlt, "WrenchAlt").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("External Tools"))}</div> </button>` : ``}` : `${tabId === "personalization" ? `<button role="tab" aria-controls="tab-personalization"${add_attribute("aria-selected", selectedTab === "personalization", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(Face, "Face").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("Personalization"))}</div> </button>` : `${tabId === "audio" ? `<button role="tab" aria-controls="tab-audio"${add_attribute("aria-selected", selectedTab === "audio", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(SoundHigh, "SoundHigh").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("Audio"))}</div> </button>` : `${tabId === "data_controls" ? `<button role="tab" aria-controls="tab-data-controls"${add_attribute("aria-selected", selectedTab === "data_controls", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(DatabaseSettings, "DatabaseSettings").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("Data Controls"))}</div> </button>` : `${tabId === "account" ? `<button role="tab" aria-controls="tab-account"${add_attribute("aria-selected", selectedTab === "account", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(UserCircle, "UserCircle").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("Account"))}</div> </button>` : `${tabId === "about" ? `<button role="tab" aria-controls="tab-about"${add_attribute("aria-selected", selectedTab === "about", 0)} class="${escape(
              null_to_empty(`px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none flex text-left transition
								${$settings?.highContrastMode ?? false ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white"}`),
              true
            ) + " svelte-187gxci"}"><div class="self-center mr-2">${validate_component(InfoCircle, "InfoCircle").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("About"))}</div> </button>` : ``}`}`}`}`}`}`}`}`}`;
          })}` : `<div class="text-center text-gray-500 mt-4">${escape($i18n.t("No results found"))}</div>`} ${$user?.role === "admin" ? `<a href="/admin/settings" class="${"px-0.5 md:px-2.5 py-1 min-w-fit rounded-xl flex-1 md:flex-none md:mt-auto flex text-left transition " + escape(
            $settings?.highContrastMode ? "hover:bg-gray-200 dark:hover:bg-gray-800" : "text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white",
            true
          )}"><div class="self-center mr-2">${validate_component(UserBadgeCheck, "UserBadgeCheck").$$render($$result, { strokeWidth: "2" }, {}, {})}</div> <div class="self-center">${escape($i18n.t("Admin Settings"))}</div></a>` : ``}</div> <div class="flex-1 px-3.5 md:pl-0 md:pr-4.5 md:min-h-[36rem] max-h-[36rem]">${`${validate_component(General, "General").$$render($$result, { getModels: getModels$1, saveSettings }, {}, {})}`}</div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_settings();
  $$unsubscribe_config();
  $$unsubscribe_user();
  $$unsubscribe_i18n();
  return $$rendered;
});
const css$1 = {
  code: ".confetti-holder.svelte-io58ff.svelte-io58ff{position:relative}@keyframes svelte-io58ff-rotate{0%{transform:skew(var(--skew)) rotate3d(var(--full-rotation))}100%{transform:skew(var(--skew)) rotate3d(var(--rotation-xyz), calc(var(--rotation-deg) + 360deg))}}@keyframes svelte-io58ff-translate{0%{opacity:1}8%{transform:translateY(calc(var(--translate-y) * 0.95)) translateX(calc(var(--translate-x) * (var(--x-spread) * 0.9)));opacity:1}12%{transform:translateY(var(--translate-y)) translateX(calc(var(--translate-x) * (var(--x-spread) * 0.95)));opacity:1}16%{transform:translateY(var(--translate-y)) translateX(calc(var(--translate-x) * var(--x-spread)));opacity:1}100%{transform:translateY(calc(var(--translate-y) + var(--fall-distance))) translateX(var(--translate-x));opacity:0}}@keyframes svelte-io58ff-no-gravity-translate{0%{opacity:1}100%{transform:translateY(var(--translate-y)) translateX(var(--translate-x));opacity:0}}.confetti.svelte-io58ff.svelte-io58ff{--translate-y:calc(-200px * var(--translate-y-multiplier));--translate-x:calc(200px * var(--translate-x-multiplier));position:absolute;height:calc(var(--size) * var(--scale));width:calc(var(--size) * var(--scale));animation:svelte-io58ff-translate var(--transition-duration) var(--transition-delay) var(--transition-iteration-count) linear;opacity:0;pointer-events:none}.confetti.svelte-io58ff.svelte-io58ff::before{--full-rotation:var(--rotation-xyz), var(--rotation-deg);content:'';display:block;width:100%;height:100%;background:var(--color);background-size:contain;transform:skew(var(--skew)) rotate3d(var(--full-rotation));animation:svelte-io58ff-rotate var(--transition-duration) var(--transition-delay) var(--transition-iteration-count) linear}.rounded.svelte-io58ff .confetti.svelte-io58ff::before{border-radius:50%}.cone.svelte-io58ff .confetti.svelte-io58ff{--translate-x:calc(200px * var(--translate-y-multiplier) * var(--translate-x-multiplier))}.no-gravity.svelte-io58ff .confetti.svelte-io58ff{animation-name:svelte-io58ff-no-gravity-translate;animation-timing-function:ease-out}@media(prefers-reduced-motion){.confetti.svelte-io58ff.svelte-io58ff,.confetti.svelte-io58ff.svelte-io58ff::before{animation:none}}",
  map: '{"version":3,"file":"Confetti.svelte","sources":["Confetti.svelte"],"sourcesContent":["<script>\\r\\n  import { onMount } from \\"svelte\\"\\r\\n\\r\\n  export let size = 10\\r\\n  export let x = [-0.5, 0.5]\\r\\n  export let y = [0.25, 1]\\r\\n  export let duration = 2000\\r\\n  export let infinite = false\\r\\n  export let delay = [0, 50]\\r\\n  export let colorRange = [0, 360]\\r\\n  export let colorArray = []\\r\\n  export let amount = 50\\r\\n  export let iterationCount = 1\\r\\n  export let fallDistance = \\"100px\\"\\r\\n  export let rounded = false\\r\\n  export let cone = false\\r\\n  export let noGravity = false\\r\\n  export let xSpread = 0.15\\r\\n  export let destroyOnComplete = true\\r\\n\\r\\n  let complete = false\\r\\n\\r\\n  onMount(() => {\\r\\n    if (!destroyOnComplete || infinite || iterationCount == \\"infinite\\") return\\r\\n\\r\\n    setTimeout(() => complete = true, (duration + delay[1]) * iterationCount)\\r\\n  })\\r\\n\\r\\n  function randomBetween(min, max) {\\r\\n    return Math.random() * (max - min) + min\\r\\n  }\\r\\n\\r\\n  function getColor() {\\r\\n    if (colorArray.length) return colorArray[Math.round(Math.random() * (colorArray.length - 1))]\\r\\n    else return `hsl(${Math.round(randomBetween(colorRange[0], colorRange[1]))}, 75%, 50%)`\\r\\n  }\\r\\n<\/script>\\r\\n\\r\\n{#if !complete}\\r\\n  <div class=\\"confetti-holder\\" class:rounded class:cone class:no-gravity={noGravity}>\\r\\n    {#each { length: amount } as _}\\r\\n      <div\\r\\n        class=\\"confetti\\"\\r\\n        style=\\"\\r\\n        --fall-distance: {fallDistance};\\r\\n        --size: {size}px;\\r\\n        --color: {getColor()};\\r\\n        --skew: {randomBetween(-45, 45)}deg,{randomBetween(-45, 45)}deg;\\r\\n        --rotation-xyz: {randomBetween(-10, 10)}, {randomBetween(-10, 10)}, {randomBetween(-10, 10)};\\r\\n        --rotation-deg: {randomBetween(0, 360)}deg;\\r\\n        --translate-y-multiplier: {randomBetween(y[0], y[1])};\\r\\n        --translate-x-multiplier: {randomBetween(x[0], x[1])};\\r\\n        --scale: {0.1 * randomBetween(2, 10)};\\r\\n        --transition-duration: {infinite ? `calc(${duration}ms * var(--scale))` : `${duration}ms`};\\r\\n        --transition-delay: {randomBetween(delay[0], delay[1])}ms;\\r\\n        --transition-iteration-count: {infinite ? \'infinite\' : iterationCount};\\r\\n        --x-spread: {(1 - xSpread)}\\" />\\r\\n    {/each}\\r\\n  </div>\\r\\n{/if}\\r\\n\\r\\n<style>\\r\\n  .confetti-holder {\\r\\n    position: relative;\\r\\n  }\\r\\n\\r\\n  @keyframes rotate {\\r\\n    0% {\\r\\n      transform: skew(var(--skew)) rotate3d(var(--full-rotation));\\r\\n    }\\r\\n\\r\\n    100% {\\r\\n      transform: skew(var(--skew)) rotate3d(var(--rotation-xyz), calc(var(--rotation-deg) + 360deg));\\r\\n    }\\r\\n  }\\r\\n\\r\\n  @keyframes translate {\\r\\n    0% {\\r\\n      opacity: 1;\\r\\n    }\\r\\n\\r\\n    8% {\\r\\n      transform: translateY(calc(var(--translate-y) * 0.95)) translateX(calc(var(--translate-x) * (var(--x-spread) * 0.9)));\\r\\n      opacity: 1;\\r\\n    }\\r\\n\\r\\n    12% {\\r\\n      transform: translateY(var(--translate-y)) translateX(calc(var(--translate-x) * (var(--x-spread) * 0.95)));\\r\\n      opacity: 1;\\r\\n    }\\r\\n\\r\\n    16% {\\r\\n      transform: translateY(var(--translate-y)) translateX(calc(var(--translate-x) * var(--x-spread)));\\r\\n      opacity: 1;\\r\\n    }\\r\\n\\r\\n    100% {\\r\\n      transform: translateY(calc(var(--translate-y) + var(--fall-distance))) translateX(var(--translate-x));\\r\\n      opacity: 0;\\r\\n    }\\r\\n  }\\r\\n\\r\\n  @keyframes no-gravity-translate {\\r\\n    0% {\\r\\n      opacity: 1;\\r\\n    }\\r\\n\\r\\n    100% {\\r\\n      transform: translateY(var(--translate-y)) translateX(var(--translate-x));\\r\\n      opacity: 0;\\r\\n    }\\r\\n  }\\r\\n\\r\\n  .confetti {\\r\\n    --translate-y: calc(-200px * var(--translate-y-multiplier));\\r\\n    --translate-x: calc(200px * var(--translate-x-multiplier));\\r\\n    position: absolute;\\r\\n    height: calc(var(--size) * var(--scale));\\r\\n    width: calc(var(--size) * var(--scale));\\r\\n    animation: translate var(--transition-duration) var(--transition-delay) var(--transition-iteration-count) linear;\\r\\n    opacity: 0;\\r\\n    pointer-events: none;\\r\\n  }\\r\\n\\r\\n  .confetti::before {\\r\\n    --full-rotation: var(--rotation-xyz), var(--rotation-deg);\\r\\n    content: \'\';\\r\\n    display: block;\\r\\n    width: 100%;\\r\\n    height: 100%;\\r\\n    background: var(--color);\\r\\n    background-size: contain;\\r\\n    transform: skew(var(--skew)) rotate3d(var(--full-rotation));\\r\\n    animation: rotate var(--transition-duration) var(--transition-delay) var(--transition-iteration-count) linear;\\r\\n  }\\r\\n\\r\\n  .rounded .confetti::before {\\r\\n    border-radius: 50%;\\r\\n  }\\r\\n\\r\\n  .cone .confetti {\\r\\n    --translate-x: calc(200px * var(--translate-y-multiplier) * var(--translate-x-multiplier));\\r\\n  }\\r\\n\\r\\n  .no-gravity .confetti {\\r\\n    animation-name: no-gravity-translate;\\r\\n    animation-timing-function: ease-out;\\r\\n  }\\r\\n\\r\\n  @media (prefers-reduced-motion) {\\r\\n    .confetti,\\r\\n    .confetti::before {\\r\\n      animation: none;\\r\\n    }\\r\\n  }\\r\\n</style>\\r\\n"],"names":[],"mappings":"AA8DE,4CAAiB,CACf,QAAQ,CAAE,QACZ,CAEA,WAAW,oBAAO,CAChB,EAAG,CACD,SAAS,CAAE,KAAK,IAAI,MAAM,CAAC,CAAC,CAAC,SAAS,IAAI,eAAe,CAAC,CAC5D,CAEA,IAAK,CACH,SAAS,CAAE,KAAK,IAAI,MAAM,CAAC,CAAC,CAAC,SAAS,IAAI,cAAc,CAAC,CAAC,CAAC,KAAK,IAAI,cAAc,CAAC,CAAC,CAAC,CAAC,MAAM,CAAC,CAC/F,CACF,CAEA,WAAW,uBAAU,CACnB,EAAG,CACD,OAAO,CAAE,CACX,CAEA,EAAG,CACD,SAAS,CAAE,WAAW,KAAK,IAAI,aAAa,CAAC,CAAC,CAAC,CAAC,IAAI,CAAC,CAAC,CAAC,WAAW,KAAK,IAAI,aAAa,CAAC,CAAC,CAAC,CAAC,CAAC,IAAI,UAAU,CAAC,CAAC,CAAC,CAAC,GAAG,CAAC,CAAC,CAAC,CACrH,OAAO,CAAE,CACX,CAEA,GAAI,CACF,SAAS,CAAE,WAAW,IAAI,aAAa,CAAC,CAAC,CAAC,WAAW,KAAK,IAAI,aAAa,CAAC,CAAC,CAAC,CAAC,CAAC,IAAI,UAAU,CAAC,CAAC,CAAC,CAAC,IAAI,CAAC,CAAC,CAAC,CACzG,OAAO,CAAE,CACX,CAEA,GAAI,CACF,SAAS,CAAE,WAAW,IAAI,aAAa,CAAC,CAAC,CAAC,WAAW,KAAK,IAAI,aAAa,CAAC,CAAC,CAAC,CAAC,IAAI,UAAU,CAAC,CAAC,CAAC,CAChG,OAAO,CAAE,CACX,CAEA,IAAK,CACH,SAAS,CAAE,WAAW,KAAK,IAAI,aAAa,CAAC,CAAC,CAAC,CAAC,IAAI,eAAe,CAAC,CAAC,CAAC,CAAC,WAAW,IAAI,aAAa,CAAC,CAAC,CACrG,OAAO,CAAE,CACX,CACF,CAEA,WAAW,kCAAqB,CAC9B,EAAG,CACD,OAAO,CAAE,CACX,CAEA,IAAK,CACH,SAAS,CAAE,WAAW,IAAI,aAAa,CAAC,CAAC,CAAC,WAAW,IAAI,aAAa,CAAC,CAAC,CACxE,OAAO,CAAE,CACX,CACF,CAEA,qCAAU,CACR,aAAa,CAAE,4CAA4C,CAC3D,aAAa,CAAE,2CAA2C,CAC1D,QAAQ,CAAE,QAAQ,CAClB,MAAM,CAAE,KAAK,IAAI,MAAM,CAAC,CAAC,CAAC,CAAC,IAAI,OAAO,CAAC,CAAC,CACxC,KAAK,CAAE,KAAK,IAAI,MAAM,CAAC,CAAC,CAAC,CAAC,IAAI,OAAO,CAAC,CAAC,CACvC,SAAS,CAAE,uBAAS,CAAC,IAAI,qBAAqB,CAAC,CAAC,IAAI,kBAAkB,CAAC,CAAC,IAAI,4BAA4B,CAAC,CAAC,MAAM,CAChH,OAAO,CAAE,CAAC,CACV,cAAc,CAAE,IAClB,CAEA,qCAAS,QAAS,CAChB,eAAe,CAAE,wCAAwC,CACzD,OAAO,CAAE,EAAE,CACX,OAAO,CAAE,KAAK,CACd,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IAAI,CACZ,UAAU,CAAE,IAAI,OAAO,CAAC,CACxB,eAAe,CAAE,OAAO,CACxB,SAAS,CAAE,KAAK,IAAI,MAAM,CAAC,CAAC,CAAC,SAAS,IAAI,eAAe,CAAC,CAAC,CAC3D,SAAS,CAAE,oBAAM,CAAC,IAAI,qBAAqB,CAAC,CAAC,IAAI,kBAAkB,CAAC,CAAC,IAAI,4BAA4B,CAAC,CAAC,MACzG,CAEA,sBAAQ,CAAC,uBAAS,QAAS,CACzB,aAAa,CAAE,GACjB,CAEA,mBAAK,CAAC,uBAAU,CACd,aAAa,CAAE,2EACjB,CAEA,yBAAW,CAAC,uBAAU,CACpB,cAAc,CAAE,kCAAoB,CACpC,yBAAyB,CAAE,QAC7B,CAEA,MAAO,wBAAyB,CAC9B,qCAAS,CACT,qCAAS,QAAS,CAChB,SAAS,CAAE,IACb,CACF"}'
};
function randomBetween(min, max) {
  return Math.random() * (max - min) + min;
}
const Confetti = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = 10 } = $$props;
  let { x = [-0.5, 0.5] } = $$props;
  let { y = [0.25, 1] } = $$props;
  let { duration = 2e3 } = $$props;
  let { infinite = false } = $$props;
  let { delay = [0, 50] } = $$props;
  let { colorRange = [0, 360] } = $$props;
  let { colorArray = [] } = $$props;
  let { amount = 50 } = $$props;
  let { iterationCount = 1 } = $$props;
  let { fallDistance = "100px" } = $$props;
  let { rounded = false } = $$props;
  let { cone = false } = $$props;
  let { noGravity = false } = $$props;
  let { xSpread = 0.15 } = $$props;
  let { destroyOnComplete = true } = $$props;
  function getColor() {
    if (colorArray.length) return colorArray[Math.round(Math.random() * (colorArray.length - 1))];
    else return `hsl(${Math.round(randomBetween(colorRange[0], colorRange[1]))}, 75%, 50%)`;
  }
  if ($$props.size === void 0 && $$bindings.size && size !== void 0) $$bindings.size(size);
  if ($$props.x === void 0 && $$bindings.x && x !== void 0) $$bindings.x(x);
  if ($$props.y === void 0 && $$bindings.y && y !== void 0) $$bindings.y(y);
  if ($$props.duration === void 0 && $$bindings.duration && duration !== void 0) $$bindings.duration(duration);
  if ($$props.infinite === void 0 && $$bindings.infinite && infinite !== void 0) $$bindings.infinite(infinite);
  if ($$props.delay === void 0 && $$bindings.delay && delay !== void 0) $$bindings.delay(delay);
  if ($$props.colorRange === void 0 && $$bindings.colorRange && colorRange !== void 0) $$bindings.colorRange(colorRange);
  if ($$props.colorArray === void 0 && $$bindings.colorArray && colorArray !== void 0) $$bindings.colorArray(colorArray);
  if ($$props.amount === void 0 && $$bindings.amount && amount !== void 0) $$bindings.amount(amount);
  if ($$props.iterationCount === void 0 && $$bindings.iterationCount && iterationCount !== void 0) $$bindings.iterationCount(iterationCount);
  if ($$props.fallDistance === void 0 && $$bindings.fallDistance && fallDistance !== void 0) $$bindings.fallDistance(fallDistance);
  if ($$props.rounded === void 0 && $$bindings.rounded && rounded !== void 0) $$bindings.rounded(rounded);
  if ($$props.cone === void 0 && $$bindings.cone && cone !== void 0) $$bindings.cone(cone);
  if ($$props.noGravity === void 0 && $$bindings.noGravity && noGravity !== void 0) $$bindings.noGravity(noGravity);
  if ($$props.xSpread === void 0 && $$bindings.xSpread && xSpread !== void 0) $$bindings.xSpread(xSpread);
  if ($$props.destroyOnComplete === void 0 && $$bindings.destroyOnComplete && destroyOnComplete !== void 0) $$bindings.destroyOnComplete(destroyOnComplete);
  $$result.css.add(css$1);
  return `${`<div class="${[
    "confetti-holder svelte-io58ff",
    (rounded ? "rounded" : "") + " " + (cone ? "cone" : "") + " " + (noGravity ? "no-gravity" : "")
  ].join(" ").trim()}">${each({ length: amount }, (_) => {
    return `<div class="confetti svelte-io58ff" style="${"--fall-distance: " + escape(fallDistance, true) + "; --size: " + escape(size, true) + "px; --color: " + escape(getColor(), true) + "; --skew: " + escape(randomBetween(-45, 45), true) + "deg," + escape(randomBetween(-45, 45), true) + "deg; --rotation-xyz: " + escape(randomBetween(-10, 10), true) + ", " + escape(randomBetween(-10, 10), true) + ", " + escape(randomBetween(-10, 10), true) + "; --rotation-deg: " + escape(randomBetween(0, 360), true) + "deg; --translate-y-multiplier: " + escape(randomBetween(y[0], y[1]), true) + "; --translate-x-multiplier: " + escape(randomBetween(x[0], x[1]), true) + "; --scale: " + escape(0.1 * randomBetween(2, 10), true) + "; --transition-duration: " + escape(
      infinite ? `calc(${duration}ms * var(--scale))` : `${duration}ms`,
      true
    ) + "; --transition-delay: " + escape(randomBetween(delay[0], delay[1]), true) + "ms; --transition-iteration-count: " + escape(infinite ? "infinite" : iterationCount, true) + "; --x-spread: " + escape(1 - xSpread, true)}"></div>`;
  })}</div>`}`;
});
const ChangelogModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $WEBUI_NAME, $$unsubscribe_WEBUI_NAME;
  let $$unsubscribe_config;
  let $$unsubscribe_settings;
  $$unsubscribe_WEBUI_NAME = subscribe(WEBUI_NAME, (value) => $WEBUI_NAME = value);
  $$unsubscribe_config = subscribe(config, (value) => value);
  $$unsubscribe_settings = subscribe(settings, (value) => value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let changelog = null;
  const init = async () => {
    changelog = await getChangelog();
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        init();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "xl", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="px-6 pt-5 dark:text-white text-black"><div class="flex justify-between items-start"><div class="text-xl font-medium">${escape($i18n.t("What's New in"))} ${escape($WEBUI_NAME)} ${validate_component(Confetti, "Confetti").$$render($$result, { x: [-1, -0.25], y: [0, 0.5] }, {}, {})}</div> <button class="self-center"${add_attribute("aria-label", $i18n.t("Close"), 0)}>${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {
            default: () => {
              return `<p class="sr-only">${escape($i18n.t("Close"))}</p>`;
            }
          })}</button></div> <div class="flex items-center mt-1"><div class="text-sm dark:text-gray-200">${escape($i18n.t("Release Notes"))}</div> <div class="flex self-center w-[1px] h-6 mx-2.5 bg-gray-50/50 dark:bg-gray-850/50"></div> <div class="text-sm dark:text-gray-200">v${escape(WEBUI_VERSION)}</div></div></div> <div class="w-full p-4 px-5 text-gray-700 dark:text-gray-100"><div class="overflow-y-scroll max-h-[30rem] scrollbar-hidden"><div class="mb-3">${changelog ? `${each(Object.keys(changelog), (version) => {
            return `<div class="mb-3 pr-2"><div class="font-semibold text-xl mb-1 dark:text-white">v${escape(version)} - ${escape(changelog[version].date)}</div> <hr class="border-gray-50/50 dark:border-gray-850/50 my-2"> ${each(Object.keys(changelog[version]).filter((section) => section !== "date"), (section) => {
              return `<div class="w-full"><div class="${"font-semibold uppercase text-xs " + escape(
                section === "added" ? "bg-blue-500/20 text-blue-700 dark:text-blue-200" : section === "fixed" ? "bg-green-500/20 text-green-700 dark:text-green-200" : section === "changed" ? "bg-yellow-500/20 text-yellow-700 dark:text-yellow-200" : section === "removed" ? "bg-red-500/20 text-red-700 dark:text-red-200" : "",
                true
              ) + " w-fit rounded-xl px-2 my-2.5"}">${escape(section)}</div> <div class="my-2.5 px-1.5 markdown-prose-sm !list-none !w-full !max-w-none">${each(changelog[version][section], (entry) => {
                return `<div class="my-2"><!-- HTML_TAG_START -->${DOMPurify.sanitize(entry?.raw)}<!-- HTML_TAG_END --> </div>`;
              })}</div> </div>`;
            })} </div>`;
          })}` : ``}</div></div> <div class="flex justify-end pt-3 text-sm font-medium"><button class="px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full"><span class="relative">${escape($i18n.t("Okay, Let's Go!"))}</span></button></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_WEBUI_NAME();
  $$unsubscribe_config();
  $$unsubscribe_settings();
  return $$rendered;
});
const AccountPending = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $config, $$unsubscribe_config;
  let $i18n, $$unsubscribe_i18n;
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  $$unsubscribe_config();
  $$unsubscribe_i18n();
  return `<div class="fixed w-full h-full flex z-999"><div class="absolute w-full h-full backdrop-blur-lg bg-white/10 dark:bg-gray-900/50 flex justify-center"><div class="m-auto pb-10 flex flex-col justify-center"><div class="max-w-md"><div class="text-center dark:text-white text-2xl font-medium z-50" style="white-space: pre-wrap;">${($config?.ui?.pending_user_overlay_title ?? "").trim() !== "" ? `${escape($config.ui.pending_user_overlay_title)}` : `${escape($i18n.t("Account Activation Pending"))}<br> ${escape($i18n.t("Contact Admin for WebUI Access"))}`}</div> <div class="mt-4 text-center text-sm dark:text-gray-200 w-full" style="white-space: pre-wrap;">${($config?.ui?.pending_user_overlay_content ?? "").trim() !== "" ? `<!-- HTML_TAG_START -->${marked.parse(DOMPurify.sanitize(($config?.ui?.pending_user_overlay_content ?? "").replace(/\n/g, "<br>")))}<!-- HTML_TAG_END -->` : `${escape($i18n.t("Your account status is currently pending activation."))}${escape("\n")}${escape($i18n.t("To access the WebUI, please reach out to the administrator. Admins can manage user statuses from the Admin Panel."))}`}</div> ${``} <div class="mt-6 mx-auto relative group w-fit"><button class="relative z-20 flex px-5 py-2 rounded-full bg-white border border-gray-100 dark:border-none hover:bg-gray-100 text-gray-700 transition font-medium text-sm">${escape($i18n.t("Check Again"))}</button> <button class="text-xs text-center w-full mt-2 text-gray-400 underline">${escape($i18n.t("Sign Out"))}</button></div></div></div></div></div>`;
});
const css = {
  code: "@keyframes svelte-19023qi-l{to{clip-path:inset(0 -1ch 0 0)}}",
  map: `{"version":3,"file":"+layout.svelte","sources":["+layout.svelte"],"sourcesContent":["<script lang=\\"ts\\">import { toast } from \\"svelte-sonner\\";\\nimport { onMount, tick, getContext } from \\"svelte\\";\\nimport { openDB, deleteDB } from \\"idb\\";\\nimport fileSaver from \\"file-saver\\";\\nconst { saveAs } = fileSaver;\\nimport { goto } from \\"$app/navigation\\";\\nimport { page } from \\"$app/stores\\";\\nimport { fade } from \\"svelte/transition\\";\\nimport { getKnowledgeBases } from \\"$lib/apis/knowledge\\";\\nimport { getFunctions } from \\"$lib/apis/functions\\";\\nimport { getModels, getToolServersData, getVersionUpdates } from \\"$lib/apis\\";\\nimport { getAllTags } from \\"$lib/apis/chats\\";\\nimport { getPrompts } from \\"$lib/apis/prompts\\";\\nimport { getTools } from \\"$lib/apis/tools\\";\\nimport { getBanners } from \\"$lib/apis/configs\\";\\nimport { getUserSettings } from \\"$lib/apis/users\\";\\nimport { WEBUI_VERSION } from \\"$lib/constants\\";\\nimport { compareVersion } from \\"$lib/utils\\";\\nimport {\\n  config,\\n  user,\\n  settings,\\n  models,\\n  prompts,\\n  knowledge,\\n  tools,\\n  functions,\\n  tags,\\n  banners,\\n  showSettings,\\n  showShortcuts,\\n  showChangelog,\\n  temporaryChatEnabled,\\n  toolServers,\\n  showSearch,\\n  showSidebar\\n} from \\"$lib/stores\\";\\nimport Sidebar from \\"$lib/components/layout/Sidebar.svelte\\";\\nimport SettingsModal from \\"$lib/components/chat/SettingsModal.svelte\\";\\nimport ChangelogModal from \\"$lib/components/ChangelogModal.svelte\\";\\nimport AccountPending from \\"$lib/components/layout/Overlay/AccountPending.svelte\\";\\nimport UpdateInfoToast from \\"$lib/components/layout/UpdateInfoToast.svelte\\";\\nimport Spinner from \\"$lib/components/common/Spinner.svelte\\";\\nconst i18n = getContext(\\"i18n\\");\\nlet loaded = false;\\nlet DB = null;\\nlet localDBChats = [];\\nlet version;\\nonMount(async () => {\\n  if ($user === void 0 || $user === null) {\\n    await goto(\\"/auth\\");\\n  } else if ([\\"user\\", \\"admin\\"].includes($user?.role)) {\\n    try {\\n      DB = await openDB(\\"Chats\\", 1);\\n      if (DB) {\\n        const chats = await DB.getAllFromIndex(\\"chats\\", \\"timestamp\\");\\n        localDBChats = chats.map((item, idx) => chats[chats.length - 1 - idx]);\\n        if (localDBChats.length === 0) {\\n          await deleteDB(\\"Chats\\");\\n        }\\n      }\\n      console.log(DB);\\n    } catch (error) {\\n    }\\n    const chatInputKeys = Object.keys(localStorage).filter((key) => key.startsWith(\\"chat-input\\"));\\n    if (chatInputKeys.length > 0) {\\n      chatInputKeys.forEach((key) => {\\n        localStorage.removeItem(key);\\n      });\\n    }\\n    const userSettings = await getUserSettings(localStorage.token).catch((error) => {\\n      console.error(error);\\n      return null;\\n    });\\n    if (userSettings) {\\n      settings.set(userSettings.ui);\\n    } else {\\n      let localStorageSettings = {};\\n      try {\\n        localStorageSettings = JSON.parse(localStorage.getItem(\\"settings\\") ?? \\"{}\\");\\n      } catch (e) {\\n        console.error(\\"Failed to parse settings from localStorage\\", e);\\n      }\\n      settings.set(localStorageSettings);\\n    }\\n    models.set(\\n      await getModels(\\n        localStorage.token,\\n        $config?.features?.enable_direct_connections && ($settings?.directConnections ?? null)\\n      )\\n    );\\n    banners.set(await getBanners(localStorage.token));\\n    tools.set(await getTools(localStorage.token));\\n    let toolServersData = await getToolServersData($settings?.toolServers ?? []);\\n    toolServersData = toolServersData.filter((data) => {\\n      if (data.error) {\\n        toast.error(\\n          $i18n.t(\`Failed to connect to {{URL}} OpenAPI tool server\`, {\\n            URL: data?.url\\n          })\\n        );\\n        return false;\\n      }\\n      return true;\\n    });\\n    toolServers.set(toolServersData);\\n    document.addEventListener(\\"keydown\\", async function(event) {\\n      const isCtrlPressed = event.ctrlKey || event.metaKey;\\n      const isShiftPressed = event.shiftKey;\\n      if (isCtrlPressed && event.key.toLowerCase() === \\"k\\") {\\n        event.preventDefault();\\n        console.log(\\"search\\");\\n        showSearch.set(!$showSearch);\\n      }\\n      if (isCtrlPressed && isShiftPressed && event.key.toLowerCase() === \\"o\\") {\\n        event.preventDefault();\\n        console.log(\\"newChat\\");\\n        document.getElementById(\\"sidebar-new-chat-button\\")?.click();\\n      }\\n      if (isShiftPressed && event.key === \\"Escape\\") {\\n        event.preventDefault();\\n        console.log(\\"focusInput\\");\\n        document.getElementById(\\"chat-input\\")?.focus();\\n      }\\n      if (isCtrlPressed && isShiftPressed && event.key === \\";\\") {\\n        event.preventDefault();\\n        console.log(\\"copyLastCodeBlock\\");\\n        const button = [...document.getElementsByClassName(\\"copy-code-button\\")]?.at(-1);\\n        button?.click();\\n      }\\n      if (isCtrlPressed && isShiftPressed && event.key.toLowerCase() === \\"c\\") {\\n        event.preventDefault();\\n        console.log(\\"copyLastResponse\\");\\n        const button = [...document.getElementsByClassName(\\"copy-response-button\\")]?.at(-1);\\n        console.log(button);\\n        button?.click();\\n      }\\n      if (isCtrlPressed && isShiftPressed && event.key.toLowerCase() === \\"s\\") {\\n        event.preventDefault();\\n        console.log(\\"toggleSidebar\\");\\n        document.getElementById(\\"sidebar-toggle-button\\")?.click();\\n      }\\n      if (isCtrlPressed && isShiftPressed && (event.key === \\"Backspace\\" || event.key === \\"Delete\\")) {\\n        event.preventDefault();\\n        console.log(\\"deleteChat\\");\\n        document.getElementById(\\"delete-chat-button\\")?.click();\\n      }\\n      if (isCtrlPressed && event.key === \\".\\") {\\n        event.preventDefault();\\n        console.log(\\"openSettings\\");\\n        showSettings.set(!$showSettings);\\n      }\\n      if (isCtrlPressed && event.key === \\"/\\") {\\n        event.preventDefault();\\n        showShortcuts.set(!$showShortcuts);\\n      }\\n      if (isCtrlPressed && isShiftPressed && (event.key.toLowerCase() === \`'\` || event.key.toLowerCase() === \`\\"\`)) {\\n        event.preventDefault();\\n        console.log(\\"temporaryChat\\");\\n        if ($user?.role !== \\"admin\\" && $user?.permissions?.chat?.temporary_enforced) {\\n          temporaryChatEnabled.set(true);\\n        } else {\\n          temporaryChatEnabled.set(!$temporaryChatEnabled);\\n        }\\n        await goto(\\"/\\");\\n        const newChatButton = document.getElementById(\\"new-chat-button\\");\\n        setTimeout(() => {\\n          newChatButton?.click();\\n        }, 0);\\n      }\\n    });\\n    if ($user?.role === \\"admin\\" && ($settings?.showChangelog ?? true)) {\\n      showChangelog.set($settings?.version !== $config.version);\\n    }\\n    if ($user?.role === \\"admin\\" || ($user?.permissions?.chat?.temporary ?? true)) {\\n      if ($page.url.searchParams.get(\\"temporary-chat\\") === \\"true\\") {\\n        temporaryChatEnabled.set(true);\\n      }\\n      if ($user?.role !== \\"admin\\" && $user?.permissions?.chat?.temporary_enforced) {\\n        temporaryChatEnabled.set(true);\\n      }\\n    }\\n    if ($user?.role === \\"admin\\" && $config?.features?.enable_version_update_check) {\\n      if (localStorage.dismissedUpdateToast) {\\n        const dismissedUpdateToast = new Date(Number(localStorage.dismissedUpdateToast));\\n        const now = /* @__PURE__ */ new Date();\\n        if (now - dismissedUpdateToast > 24 * 60 * 60 * 1e3) {\\n          checkForVersionUpdates();\\n        }\\n      } else {\\n        checkForVersionUpdates();\\n      }\\n    }\\n    await tick();\\n  }\\n  loaded = true;\\n});\\nconst checkForVersionUpdates = async () => {\\n  version = await getVersionUpdates(localStorage.token).catch((error) => {\\n    return {\\n      current: WEBUI_VERSION,\\n      latest: WEBUI_VERSION\\n    };\\n  });\\n};\\n<\/script>\\n\\n<SettingsModal bind:show={$showSettings} />\\n<ChangelogModal bind:show={$showChangelog} />\\n\\n{#if version && compareVersion(version.latest, version.current) && ($settings?.showUpdateToast ?? true)}\\n\\t<div class=\\" absolute bottom-8 right-8 z-50\\" in:fade={{ duration: 100 }}>\\n\\t\\t<UpdateInfoToast\\n\\t\\t\\t{version}\\n\\t\\t\\ton:close={() => {\\n\\t\\t\\t\\tlocalStorage.setItem('dismissedUpdateToast', Date.now().toString());\\n\\t\\t\\t\\tversion = null;\\n\\t\\t\\t}}\\n\\t\\t/>\\n\\t</div>\\n{/if}\\n\\n{#if $user}\\n\\t<div class=\\"app relative\\">\\n\\t\\t<div\\n\\t\\t\\tclass=\\" text-gray-700 dark:text-gray-100 bg-white dark:bg-gray-900 h-screen max-h-[100dvh] overflow-auto flex flex-row justify-end\\"\\n\\t\\t>\\n\\t\\t\\t{#if !['user', 'admin'].includes($user?.role)}\\n\\t\\t\\t\\t<AccountPending />\\n\\t\\t\\t{:else}\\n\\t\\t\\t\\t{#if localDBChats.length > 0}\\n\\t\\t\\t\\t\\t<div class=\\"fixed w-full h-full flex z-50\\">\\n\\t\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\t\\tclass=\\"absolute w-full h-full backdrop-blur-md bg-white/20 dark:bg-gray-900/50 flex justify-center\\"\\n\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\"m-auto pb-44 flex flex-col justify-center\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\"max-w-md\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\"text-center dark:text-white text-2xl font-medium z-50\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Important Update')}<br />\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Action Required for Chat Log Storage')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" mt-4 text-center text-sm dark:text-gray-200 w-full\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t(\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\"Saving chat logs directly to your browser's storage is no longer supported. Please take a moment to download and delete your chat logs by clicking the button below. Don't worry, you can easily re-import your chat logs to the backend through\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<span class=\\"font-semibold dark:text-white\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>{$i18n.t('Settings')} > {$i18n.t('Chats')} > {$i18n.t('Import Chats')}</span\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>. {$i18n.t(\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t'This ensures that your valuable conversations are securely saved to your backend database. Thank you!'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t)}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t<div class=\\" mt-6 mx-auto relative group w-fit\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"relative z-20 flex px-5 py-2 rounded-full bg-white border border-gray-100 dark:border-none hover:bg-gray-100 transition font-medium text-sm\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={async () => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tlet blob = new Blob([JSON.stringify(localDBChats)], {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ttype: 'application/json'\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t});\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tsaveAs(blob, \`chat-export-\${Date.now()}.json\`);\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tconst tx = DB.transaction('chats', 'readwrite');\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tawait Promise.all([tx.store.clear(), tx.done]);\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tawait deleteDB('Chats');\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tlocalDBChats = [];\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t{$i18n.t('Download & Delete')}\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t</button>\\n\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tclass=\\"text-xs text-center w-full mt-2 text-gray-400 underline\\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\ton:click={async () => {\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tlocalDBChats = [];\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t}}>{$i18n.t('Close')}</button\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t{/if}\\n\\n\\t\\t\\t\\t<Sidebar />\\n\\n\\t\\t\\t\\t{#if loaded}\\n\\t\\t\\t\\t\\t<slot />\\n\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t<div\\n\\t\\t\\t\\t\\t\\tclass=\\"w-full flex-1 h-full flex items-center justify-center {$showSidebar\\n\\t\\t\\t\\t\\t\\t\\t? '  md:max-w-[calc(100%-260px)]'\\n\\t\\t\\t\\t\\t\\t\\t: ' '}\\"\\n\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t\\t<Spinner className=\\"size-5\\" />\\n\\t\\t\\t\\t\\t</div>\\n\\t\\t\\t\\t{/if}\\n\\t\\t\\t{/if}\\n\\t\\t</div>\\n\\t</div>\\n{/if}\\n\\n<style>\\n\\t.loading {\\n\\t\\tdisplay: inline-block;\\n\\t\\tclip-path: inset(0 1ch 0 0);\\n\\t\\tanimation: l 1s steps(3) infinite;\\n\\t\\tletter-spacing: -0.5px;\\n\\t}\\n\\n\\t@keyframes l {\\n\\t\\tto {\\n\\t\\t\\tclip-path: inset(0 -1ch 0 0);\\n\\t\\t}\\n\\t}\\n\\n\\tpre[class*='language-'] {\\n\\t\\tposition: relative;\\n\\t\\toverflow: auto;\\n\\n\\t\\t/* make space  */\\n\\t\\tmargin: 5px 0;\\n\\t\\tpadding: 1.75rem 0 1.75rem 1rem;\\n\\t\\tborder-radius: 10px;\\n\\t}\\n\\n\\tpre[class*='language-'] button {\\n\\t\\tposition: absolute;\\n\\t\\ttop: 5px;\\n\\t\\tright: 5px;\\n\\n\\t\\tfont-size: 0.9rem;\\n\\t\\tpadding: 0.15rem;\\n\\t\\tbackground-color: #828282;\\n\\n\\t\\tborder: ridge 1px #7b7b7c;\\n\\t\\tborder-radius: 5px;\\n\\t\\ttext-shadow: #c4c4c4 0 0 2px;\\n\\t}\\n\\n\\tpre[class*='language-'] button:hover {\\n\\t\\tcursor: pointer;\\n\\t\\tbackground-color: #bcbabb;\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AAuTC,WAAW,gBAAE,CACZ,EAAG,CACF,SAAS,CAAE,MAAM,CAAC,CAAC,IAAI,CAAC,CAAC,CAAC,CAAC,CAC5B,CACD"}`
};
const Layout = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_config;
  let $user, $$unsubscribe_user;
  let $$unsubscribe_page;
  let $$unsubscribe_settings;
  let $$unsubscribe_temporaryChatEnabled;
  let $$unsubscribe_showShortcuts;
  let $showSettings, $$unsubscribe_showSettings;
  let $$unsubscribe_showSearch;
  let $i18n, $$unsubscribe_i18n;
  let $showChangelog, $$unsubscribe_showChangelog;
  let $showSidebar, $$unsubscribe_showSidebar;
  $$unsubscribe_config = subscribe(config, (value) => value);
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  $$unsubscribe_page = subscribe(page, (value) => value);
  $$unsubscribe_settings = subscribe(settings, (value) => value);
  $$unsubscribe_temporaryChatEnabled = subscribe(temporaryChatEnabled, (value) => value);
  $$unsubscribe_showShortcuts = subscribe(showShortcuts, (value) => value);
  $$unsubscribe_showSettings = subscribe(showSettings, (value) => $showSettings = value);
  $$unsubscribe_showSearch = subscribe(showSearch, (value) => value);
  $$unsubscribe_showChangelog = subscribe(showChangelog, (value) => $showChangelog = value);
  $$unsubscribe_showSidebar = subscribe(showSidebar, (value) => $showSidebar = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let localDBChats = [];
  $$result.css.add(css);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(SettingsModal, "SettingsModal").$$render(
      $$result,
      { show: $showSettings },
      {
        show: ($$value) => {
          $showSettings = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${validate_component(ChangelogModal, "ChangelogModal").$$render(
      $$result,
      { show: $showChangelog },
      {
        show: ($$value) => {
          $showChangelog = $$value;
          $$settled = false;
        }
      },
      {}
    )} ${``} ${$user ? `<div class="app relative"><div class="text-gray-700 dark:text-gray-100 bg-white dark:bg-gray-900 h-screen max-h-[100dvh] overflow-auto flex flex-row justify-end">${!["user", "admin"].includes($user?.role) ? `${validate_component(AccountPending, "AccountPending").$$render($$result, {}, {}, {})}` : `${localDBChats.length > 0 ? `<div class="fixed w-full h-full flex z-50"><div class="absolute w-full h-full backdrop-blur-md bg-white/20 dark:bg-gray-900/50 flex justify-center"><div class="m-auto pb-44 flex flex-col justify-center"><div class="max-w-md"><div class="text-center dark:text-white text-2xl font-medium z-50">${escape($i18n.t("Important Update"))}<br> ${escape($i18n.t("Action Required for Chat Log Storage"))}</div> <div class="mt-4 text-center text-sm dark:text-gray-200 w-full">${escape($i18n.t("Saving chat logs directly to your browser's storage is no longer supported. Please take a moment to download and delete your chat logs by clicking the button below. Don't worry, you can easily re-import your chat logs to the backend through"))} <span class="font-semibold dark:text-white">${escape($i18n.t("Settings"))} &gt; ${escape($i18n.t("Chats"))} &gt; ${escape($i18n.t("Import Chats"))}</span>. ${escape($i18n.t("This ensures that your valuable conversations are securely saved to your backend database. Thank you!"))}</div> <div class="mt-6 mx-auto relative group w-fit"><button class="relative z-20 flex px-5 py-2 rounded-full bg-white border border-gray-100 dark:border-none hover:bg-gray-100 transition font-medium text-sm">${escape($i18n.t("Download & Delete"))}</button> <button class="text-xs text-center w-full mt-2 text-gray-400 underline">${escape($i18n.t("Close"))}</button></div></div></div></div></div>` : ``} ${validate_component(Sidebar_1, "Sidebar").$$render($$result, {}, {}, {})} ${`<div class="${"w-full flex-1 h-full flex items-center justify-center " + escape($showSidebar ? "  md:max-w-[calc(100%-260px)]" : " ", true)}">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</div>`}`}</div></div>` : ``}`;
  } while (!$$settled);
  $$unsubscribe_config();
  $$unsubscribe_user();
  $$unsubscribe_page();
  $$unsubscribe_settings();
  $$unsubscribe_temporaryChatEnabled();
  $$unsubscribe_showShortcuts();
  $$unsubscribe_showSettings();
  $$unsubscribe_showSearch();
  $$unsubscribe_i18n();
  $$unsubscribe_showChangelog();
  $$unsubscribe_showSidebar();
  return $$rendered;
});
export {
  Layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
