import { c as create_ssr_component, o as onDestroy, a as add_attribute, p as createEventDispatcher, l as getContext, b as subscribe, e as each, g as escape, v as validate_component } from "./ssr.js";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { M as Modal } from "./Modal.js";
import { D as WEBUI_API_BASE_URL } from "./index.js";
import { g as getUserValvesById$1, a as getUserValvesSpecById$1, c as getToolValvesById, d as getToolValvesSpecById } from "./index10.js";
import { S as Spinner } from "./Spinner.js";
import "dequal";
import "./create.js";
import "dompurify";
import { S as Switch_1 } from "./Switch.js";
import "postcss/lib/list";
import { X as XMark } from "./XMark.js";
const getFunctions = async (token = "") => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const loadFunctionByUrl = async (token = "", url) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/load/url`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    },
    body: JSON.stringify({
      url
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getFunctionById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/id/${id}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const toggleGlobalById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/id/${id}/toggle/global`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getFunctionValvesById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/id/${id}/valves`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getFunctionValvesSpecById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/id/${id}/valves/spec`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getUserValvesById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/id/${id}/valves/user`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getUserValvesSpecById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/functions/id/${id}/valves/user/spec`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const MapSelector = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let mapElement;
  let { setViewLocation = [51.505, -0.09] } = $$props;
  let { points = [] } = $$props;
  let { onClick = (e) => {
  } } = $$props;
  onDestroy(async () => {
  });
  if ($$props.setViewLocation === void 0 && $$bindings.setViewLocation && setViewLocation !== void 0) $$bindings.setViewLocation(setViewLocation);
  if ($$props.points === void 0 && $$bindings.points && points !== void 0) $$bindings.points(points);
  if ($$props.onClick === void 0 && $$bindings.onClick && onClick !== void 0) $$bindings.onClick(onClick);
  return `<div class="z-10 w-full"><div class="h-96 z-10"${add_attribute("this", mapElement, 0)}></div></div>`;
});
const Valves = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const dispatch = createEventDispatcher();
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { valvesSpec = null } = $$props;
  let { valves = {} } = $$props;
  if ($$props.valvesSpec === void 0 && $$bindings.valvesSpec && valvesSpec !== void 0) $$bindings.valvesSpec(valvesSpec);
  if ($$props.valves === void 0 && $$bindings.valves && valves !== void 0) $$bindings.valves(valves);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${valvesSpec && Object.keys(valvesSpec?.properties ?? {}).length ? `${each(Object.keys(valvesSpec.properties), (property, idx) => {
      return `<div class="py-0.5 w-full justify-between"><div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape(valvesSpec.properties[property].title)} ${(valvesSpec?.required ?? []).includes(property) ? `<span class="text-gray-500" data-svelte-h="svelte-1pjo6rv">*required</span>` : ``}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">${(valves[property] ?? null) === null ? `<span class="ml-2 self-center">${(valvesSpec?.required ?? []).includes(property) ? `${escape($i18n.t("None"))}` : `${escape($i18n.t("Default"))}`} </span>` : `<span class="ml-2 self-center">${escape($i18n.t("Custom"))} </span>`} </button></div> ${(valves[property] ?? null) !== null ? ` <div class="flex mt-0.5 mb-0.5 space-x-2"><div class="flex-1">${valvesSpec.properties[property]?.enum ?? null ? `<select class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850">${each(valvesSpec.properties[property].enum, (option) => {
        return `<option${add_attribute("value", option, 0)} ${option === valves[property] ? "selected" : ""}>${escape(option)} </option>`;
      })}</select>` : `${(valvesSpec.properties[property]?.type ?? null) === "boolean" ? `<div class="flex justify-between items-center"><div class="text-xs text-gray-500">${escape(valves[property] ? $i18n.t("Enabled") : $i18n.t("Disabled"))}</div> <div class="pr-2">${validate_component(Switch_1, "Switch").$$render(
        $$result,
        { state: valves[property] },
        {
          state: ($$value) => {
            valves[property] = $$value;
            $$settled = false;
          }
        },
        {}
      )}</div> </div>` : `${(valvesSpec.properties[property]?.type ?? null) !== "string" ? `<input class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850" type="text"${add_attribute("placeholder", valvesSpec.properties[property].title, 0)} autocomplete="off" required${add_attribute("value", valves[property], 0)}>` : `${valvesSpec.properties[property]?.input ?? null ? `${valvesSpec.properties[property]?.input?.type === "color" ? `<div class="flex items-center space-x-2"><div class="relative size-6"><input type="color" class="size-6 rounded cursor-pointer border border-gray-200 dark:border-gray-700"${add_attribute("value", valves[property] ?? "#000000", 0)}></div> <input type="text" class="flex-1 rounded-lg py-2 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"${add_attribute("placeholder", $i18n.t("Enter hex color (e.g. #FF0000)"), 0)} autocomplete="off" disabled${add_attribute("value", valves[property], 0)}> </div>` : `${valvesSpec.properties[property]?.input?.type === "map" ? ` <div class="flex flex-col items-center gap-1">${validate_component(MapSelector, "MapSelector").$$render(
        $$result,
        {
          setViewLocation: (valves[property] ?? "").includes(",") ?? false ? valves[property].split(",") : null,
          onClick: (value) => {
            valves[property] = value;
            dispatch("change");
          }
        },
        {},
        {}
      )} ${valves[property] ? `<input type="text" class="w-full rounded-lg py-1 text-left text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"${add_attribute("placeholder", $i18n.t("Enter coordinates (e.g. 51.505, -0.09)"), 0)} autocomplete="off"${add_attribute("value", valves[property], 0)}>` : ``} </div>` : ``}`}` : `<textarea class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100 dark:border-gray-850"${add_attribute("placeholder", valvesSpec.properties[property].title, 0)} autocomplete="off" required>${escape(valves[property] || "")}</textarea>`}`}`}`}</div> </div>` : ``} ${(valvesSpec.properties[property]?.description ?? null) !== null ? `<div class="text-xs text-gray-500">${escape(valvesSpec.properties[property].description)} </div>` : ``} </div>`;
    })}` : `<div class="text-xs">${escape($i18n.t("No valves"))}</div>`}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const ValvesModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  createEventDispatcher();
  let { show = false } = $$props;
  let { type = "tool" } = $$props;
  let { id = null } = $$props;
  let { userValves = false } = $$props;
  let loading = false;
  let valvesSpec = null;
  let valves = {};
  const initHandler = async () => {
    loading = true;
    valves = {};
    valvesSpec = null;
    try {
      if (userValves) {
        if (type === "tool") {
          valves = await getUserValvesById$1(localStorage.token, id);
          valvesSpec = await getUserValvesSpecById$1(localStorage.token, id);
        } else if (type === "function") {
          valves = await getUserValvesById(localStorage.token, id);
          valvesSpec = await getUserValvesSpecById(localStorage.token, id);
        }
      } else {
        if (type === "tool") {
          valves = await getToolValvesById(localStorage.token, id);
          valvesSpec = await getToolValvesSpecById(localStorage.token, id);
        } else if (type === "function") {
          valves = await getFunctionValvesById(localStorage.token, id);
          valvesSpec = await getFunctionValvesSpecById(localStorage.token, id);
        }
      }
      if (!valves) {
        valves = {};
      }
      if (valvesSpec) {
        for (const property in valvesSpec.properties) {
          if (valvesSpec.properties[property]?.type === "array") {
            if (valves[property] != null) {
              valves[property] = (Array.isArray(valves[property]) ? valves[property] : []).join(",");
            } else {
              valves[property] = null;
            }
          }
        }
      }
      loading = false;
    } catch (e) {
      toast.error(`Error fetching valves`);
      show = false;
    }
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0) $$bindings.id(id);
  if ($$props.userValves === void 0 && $$bindings.userValves && userValves !== void 0) $$bindings.userValves(userValves);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        initHandler();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "sm", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-2"><div class="text-lg font-medium self-center">${escape($i18n.t("Valves"))}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-4 md:space-x-4 dark:text-gray-200"><div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6"><form class="flex flex-col w-full"><div class="px-1">${!loading ? `${validate_component(Valves, "Valves").$$render(
            $$result,
            { valvesSpec, valves },
            {
              valves: ($$value) => {
                valves = $$value;
                $$settled = false;
              }
            },
            {}
          )}` : `${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}`}</div> <div class="flex justify-end pt-3 text-sm font-medium"><button class="${"px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full " + escape("", true)}" type="submit" ${""}>${escape($i18n.t("Save"))} ${``}</button></div></form></div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const Heart = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12Z"></path></svg>`;
});
export {
  Heart as H,
  MapSelector as M,
  ValvesModal as V,
  getFunctions as a,
  Valves as b,
  getFunctionById as g,
  loadFunctionByUrl as l,
  toggleGlobalById as t
};
//# sourceMappingURL=Heart.js.map
