import { c as create_ssr_component, a as add_attribute, b as subscribe, l as getContext, v as validate_component, g as escape, p as createEventDispatcher, e as each } from "./ssr.js";
import { D as WEBUI_API_BASE_URL, q as models, c as config, N as knowledge, a as settings, u as user } from "./index.js";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { j as getChatById } from "./Messages.js";
import "./index2.js";
import { M as Modal } from "./Modal.js";
import { L as Link } from "./Link.js";
import { X as XMark } from "./XMark.js";
import "dequal";
import "./create.js";
import { M as Menu_content, a as Menu_item } from "./menu-trigger.js";
import { f as flyAndScale } from "./index4.js";
import { D as Dropdown } from "./Dropdown.js";
import { G as GarbageBin } from "./GarbageBin.js";
import { P as Pencil } from "./Pencil.js";
import { T as Tooltip } from "./Tooltip.js";
import { D as Download } from "./Download.js";
import { t as tick } from "./ssr2.js";
import "./client.js";
import { T as Textarea } from "./Textarea.js";
import "dayjs";
import { F as FileItem } from "./FileItem.js";
const createNewFolder = async (token, folderForm) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/folders/`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    },
    body: JSON.stringify(folderForm)
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getFolders = async (token = "") => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/folders/`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const getFolderById = async (token, id) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/folders/${id}`, {
    method: "GET",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    }
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const updateFolderById = async (token, id, folderForm) => {
  let error = null;
  const res = await fetch(`${WEBUI_API_BASE_URL}/folders/${id}/update`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      authorization: `Bearer ${token}`
    },
    body: JSON.stringify(folderForm)
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).then((json) => {
    return json;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const Folder = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 12.75V12A2.25 2.25 0 0 1 4.5 9.75h15A2.25 2.25 0 0 1 21.75 12v.75m-8.69-6.44-2.12-2.12a1.5 1.5 0 0 0-1.061-.44H4.5A2.25 2.25 0 0 0 2.25 6v12a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 18V9a2.25 2.25 0 0 0-2.25-2.25h-5.379a1.5 1.5 0 0 1-1.06-.44Z"></path></svg>`;
});
const ShareChatModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_models;
  let $i18n, $$unsubscribe_i18n;
  let $config, $$unsubscribe_config;
  $$unsubscribe_models = subscribe(models, (value) => value);
  $$unsubscribe_config = subscribe(config, (value) => $config = value);
  let { chatId } = $$props;
  let chat = null;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  const isDifferentChat = (_chat) => {
    if (!chat) {
      return true;
    }
    if (!_chat) {
      return false;
    }
    return chat.id !== _chat.id || chat.share_id !== _chat.share_id;
  };
  if ($$props.chatId === void 0 && $$bindings.chatId && chatId !== void 0) $$bindings.chatId(chatId);
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        (async () => {
          if (chatId) {
            const _chat = await getChatById(localStorage.token, chatId);
            if (isDifferentChat(_chat)) {
              chat = _chat;
            }
          } else {
            chat = null;
            /* @__PURE__ */ console.log(chat);
          }
        })();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "md", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-0.5"><div class="text-lg font-medium self-center">${escape($i18n.t("Share Chat"))}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> ${chat ? `<div class="px-5 pt-4 pb-5 w-full flex flex-col justify-center"><div class="text-sm dark:text-gray-300 mb-1">${chat.share_id ? `<a href="${"/s/" + escape(chat.share_id, true)}" target="_blank">${escape($i18n.t("You have shared this chat"))} <span class="underline">${escape($i18n.t("before"))}</span>.</a> ${escape($i18n.t("Click here to"))} <button class="underline">${escape($i18n.t("delete this link"))}</button> ${escape($i18n.t("and create a new shared link."))}` : `${escape($i18n.t("Messages you send after creating your link won't be shared. Users with the URL will be able to view the shared chat."))}`}</div> <div class="flex justify-end"><div class="flex flex-col items-end space-x-1 mt-3"><div class="flex gap-1">${$config?.features.enable_community_sharing ? `<button class="self-center flex items-center gap-1 px-3.5 py-2 text-sm font-medium bg-gray-100 hover:bg-gray-200 text-gray-800 dark:bg-gray-850 dark:text-white dark:hover:bg-gray-800 transition rounded-full" type="button">${escape($i18n.t("Share to Open WebUI Community"))}</button>` : ``} <button class="self-center flex items-center gap-1 px-3.5 py-2 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full" type="button" id="copy-and-share-chat-button">${validate_component(Link, "Link").$$render($$result, {}, {}, {})} ${chat.share_id ? `${escape($i18n.t("Update and Copy Link"))}` : `${escape($i18n.t("Copy Link"))}`}</button></div></div></div></div>` : ``}</div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_models();
  $$unsubscribe_i18n();
  $$unsubscribe_config();
  return $$rendered;
});
const FolderMenu = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  createEventDispatcher();
  let { align = "start" } = $$props;
  let { onEdit = () => {
  } } = $$props;
  let { onExport = () => {
  } } = $$props;
  let { onDelete = () => {
  } } = $$props;
  let show = false;
  if ($$props.align === void 0 && $$bindings.align && align !== void 0) $$bindings.align(align);
  if ($$props.onEdit === void 0 && $$bindings.onEdit && onEdit !== void 0) $$bindings.onEdit(onEdit);
  if ($$props.onExport === void 0 && $$bindings.onExport && onExport !== void 0) $$bindings.onExport(onExport);
  if ($$props.onDelete === void 0 && $$bindings.onDelete && onDelete !== void 0) $$bindings.onDelete(onDelete);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Dropdown, "Dropdown").$$render(
      $$result,
      { show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        content: () => {
          return `<div slot="content">${validate_component(Menu_content, "DropdownMenu.Content").$$render(
            $$result,
            {
              class: "w-full max-w-[170px] rounded-2xl px-1 py-1 border border-gray-100  dark:border-gray-800   z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg",
              sideOffset: -2,
              side: "bottom",
              align,
              transition: flyAndScale
            },
            {},
            {
              default: () => {
                return `${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(Pencil, "Pencil").$$render($$result, {}, {}, {})} <div class="flex items-center">${escape($i18n.t("Edit"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(Download, "Download").$$render($$result, {}, {}, {})} <div class="flex items-center">${escape($i18n.t("Export"))}</div>`;
                    }
                  }
                )} ${validate_component(Menu_item, "DropdownMenu.Item").$$render(
                  $$result,
                  {
                    class: "flex  gap-2  items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl"
                  },
                  {},
                  {
                    default: () => {
                      return `${validate_component(GarbageBin, "GarbageBin").$$render($$result, {}, {}, {})} <div class="flex items-center">${escape($i18n.t("Delete"))}</div>`;
                    }
                  }
                )}`;
              }
            }
          )}</div>`;
        },
        default: () => {
          return `${validate_component(Tooltip, "Tooltip").$$render($$result, { content: $i18n.t("More") }, {}, {
            default: () => {
              return `<button>${slots.default ? slots.default({}) : ``}</button>`;
            }
          })}`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const Knowledge = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $$unsubscribe_knowledge;
  let $i18n, $$unsubscribe_i18n;
  let $$unsubscribe_config;
  let $$unsubscribe_settings;
  let $$unsubscribe_user;
  $$unsubscribe_knowledge = subscribe(knowledge, (value) => value);
  $$unsubscribe_config = subscribe(config, (value) => value);
  $$unsubscribe_settings = subscribe(settings, (value) => value);
  $$unsubscribe_user = subscribe(user, (value) => value);
  let { selectedItems = [] } = $$props;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  if ($$props.selectedItems === void 0 && $$bindings.selectedItems && selectedItems !== void 0) $$bindings.selectedItems(selectedItems);
  $$unsubscribe_knowledge();
  $$unsubscribe_i18n();
  $$unsubscribe_config();
  $$unsubscribe_settings();
  $$unsubscribe_user();
  return `<input type="file" hidden multiple> <div>${slots.label ? slots.label({}) : ` <div class="mb-2"><div class="flex w-full justify-between mb-1"><div class="self-center text-sm font-semibold">${escape($i18n.t("Knowledge"))}</div></div> <div class="text-xs dark:text-gray-500">${escape($i18n.t('To attach knowledge base here, add them to the "Knowledge" workspace first.'))}</div></div> `} <div class="flex flex-col">${selectedItems?.length > 0 ? `<div class="flex flex-wrap items-center gap-2 mb-2.5">${each(selectedItems, (file, fileIdx) => {
    return `${validate_component(FileItem, "FileItem").$$render(
      $$result,
      {
        file,
        item: file,
        name: file.name,
        modal: true,
        edit: true,
        loading: file.status === "uploading",
        type: file?.legacy ? `Legacy${file.type ? ` ${file.type}` : ""}` : file?.type ?? "collection",
        dismissible: true
      },
      {},
      {}
    )}`;
  })}</div>` : ``} ${``} </div></div>`;
});
const FolderModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $user, $$unsubscribe_user;
  $$unsubscribe_user = subscribe(user, (value) => $user = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { onSubmit = (e) => {
  } } = $$props;
  let { folderId = null } = $$props;
  let { edit = false } = $$props;
  let folder = null;
  let name = "";
  let meta = { background_image_url: null };
  let data = { system_prompt: "", files: [] };
  const init = async () => {
    if (folderId) {
      folder = await getFolderById(localStorage.token, folderId).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      name = folder.name;
      meta = folder.meta || { background_image_url: null };
      data = folder.data || { system_prompt: "", files: [] };
    }
    focusInput();
  };
  const focusInput = async () => {
    await tick();
    const input = document.getElementById("folder-name");
    if (input) {
      input.focus();
      input.select();
    }
  };
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.onSubmit === void 0 && $$bindings.onSubmit && onSubmit !== void 0) $$bindings.onSubmit(onSubmit);
  if ($$props.folderId === void 0 && $$bindings.folderId && folderId !== void 0) $$bindings.folderId(folderId);
  if ($$props.edit === void 0 && $$bindings.edit && edit !== void 0) $$bindings.edit(edit);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    {
      if (show) {
        init();
      }
    }
    {
      if (!show && !edit) {
        name = "";
        meta = { background_image_url: null };
        data = { system_prompt: "", files: [] };
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "md", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-1"><div class="text-lg font-medium self-center">${edit ? `${escape($i18n.t("Edit Folder"))}` : `${escape($i18n.t("Create Folder"))}`}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-4 md:space-x-4 dark:text-gray-200"><div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6"><form class="flex flex-col w-full"><div class="flex flex-col w-full mt-1"><div class="mb-1 text-xs text-gray-500">${escape($i18n.t("Folder Name"))}</div> <div class="flex-1"><input id="folder-name" class="w-full text-sm bg-transparent placeholder:text-gray-300 dark:placeholder:text-gray-700 outline-hidden" type="text"${add_attribute("placeholder", $i18n.t("Enter folder name"), 0)} autocomplete="off"${add_attribute("value", name, 0)}></div></div> <input id="folder-background-image-input" type="file" hidden accept="image/*"> <div class="flex justify-between w-full mt-1 items-center"><div class="text-xs text-gray-500">${escape($i18n.t("Folder Background Image"))}</div> <div class=""><button aria-labelledby="chat-background-label background-image-url-state" class="p-1 px-3 text-xs flex rounded-sm transition" type="button"><span class="ml-2 self-center" id="background-image-url-state">${escape((meta?.background_image_url ?? null) === null ? $i18n.t("Upload") : $i18n.t("Reset"))}</span></button></div></div> <hr class="border-gray-50 dark:border-gray-850 my-2.5 w-full"> ${$user?.role === "admin" || ($user?.permissions.chat?.system_prompt ?? true) ? `<div class="my-1"><div class="mb-2 text-xs text-gray-500">${escape($i18n.t("System Prompt"))}</div> <div>${validate_component(Textarea, "Textarea").$$render(
            $$result,
            {
              className: " text-sm w-full bg-transparent outline-hidden ",
              placeholder: $i18n.t("Write your model system prompt content here\ne.g.) You are Mario from Super Mario Bros, acting as an assistant."),
              maxSize: 200,
              value: data.system_prompt
            },
            {
              value: ($$value) => {
                data.system_prompt = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div></div>` : ``} <div class="my-2">${validate_component(Knowledge, "Knowledge").$$render(
            $$result,
            { selectedItems: data.files },
            {
              selectedItems: ($$value) => {
                data.files = $$value;
                $$settled = false;
              }
            },
            {
              label: () => {
                return `<div slot="label"><div class="flex w-full justify-between"><div class="mb-2 text-xs text-gray-500">${escape($i18n.t("Knowledge"))}</div></div></div>`;
              }
            }
          )}</div> <div class="flex justify-end pt-3 text-sm font-medium gap-1.5"><button class="${"px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-950 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full flex flex-row space-x-1 items-center " + escape("", true)}" type="submit" ${""}>${escape($i18n.t("Save"))} ${``}</button></div></form></div></div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_user();
  return $$rendered;
});
export {
  Folder as F,
  ShareChatModal as S,
  FolderModal as a,
  FolderMenu as b,
  createNewFolder as c,
  getFolders as d,
  getFolderById as g,
  updateFolderById as u
};
//# sourceMappingURL=FolderModal.js.map
