import { c as create_ssr_component, g as escape, a as add_attribute, l as getContext, b as subscribe, v as validate_component, e as each, p as createEventDispatcher } from "./ssr.js";
import { E as formatFileSize, F as getLineCount } from "./index2.js";
import { t as tick } from "./ssr2.js";
import { D as WEBUI_API_BASE_URL, a as settings } from "./index.js";
import { g as getKnowledgeById, a as getFileById } from "./index11.js";
import { M as Modal } from "./Modal.js";
import { X as XMark } from "./XMark.js";
import { S as Switch_1 } from "./Switch.js";
import { T as Tooltip } from "./Tooltip.js";
import dayjs from "dayjs";
import { S as Spinner } from "./Spinner.js";
const css = {
  code: "@keyframes svelte-w91618-size{0%,100%{transform:scale(1)}50%{transform:scale(1.25)}}.animate-size.svelte-w91618{animation:svelte-w91618-size 1.5s ease-in-out infinite}",
  map: `{"version":3,"file":"Skeleton.svelte","sources":["Skeleton.svelte"],"sourcesContent":["<script lang=\\"ts\\">export let size = \\"md\\";\\n<\/script>\\n\\n<span\\n\\tclass=\\"relative flex {size === 'md'\\n\\t\\t? 'size-3 my-2'\\n\\t\\t: size === 'xs'\\n\\t\\t\\t? 'size-1.5 my-1'\\n\\t\\t\\t: 'size-2 my-1'} mx-1\\"\\n>\\n\\t<span\\n\\t\\tclass=\\"absolute inline-flex h-full w-full animate-pulse rounded-full bg-gray-700 dark:bg-gray-200 opacity-75\\"\\n\\t></span>\\n\\t<span\\n\\t\\tclass=\\"relative inline-flex {size === 'md'\\n\\t\\t\\t? 'size-3'\\n\\t\\t\\t: size === 'xs'\\n\\t\\t\\t\\t? 'size-1.5'\\n\\t\\t\\t\\t: 'size-2'} rounded-full bg-black dark:bg-white animate-size\\"\\n\\t></span>\\n</span>\\n\\n<style>\\n\\t@keyframes size {\\n\\t\\t0%,\\n\\t\\t100% {\\n\\t\\t\\ttransform: scale(1);\\n\\t\\t}\\n\\t\\t50% {\\n\\t\\t\\ttransform: scale(1.25);\\n\\t\\t}\\n\\t}\\n\\n\\t.animate-size {\\n\\t\\tanimation: size 1.5s ease-in-out infinite;\\n\\t}\\n</style>\\n"],"names":[],"mappings":"AAuBC,WAAW,kBAAK,CACf,EAAE,CACF,IAAK,CACJ,SAAS,CAAE,MAAM,CAAC,CACnB,CACA,GAAI,CACH,SAAS,CAAE,MAAM,IAAI,CACtB,CACD,CAEA,2BAAc,CACb,SAAS,CAAE,kBAAI,CAAC,IAAI,CAAC,WAAW,CAAC,QAClC"}`
};
const Skeleton = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "md" } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0) $$bindings.size(size);
  $$result.css.add(css);
  return `<span class="${"relative flex " + escape(
    size === "md" ? "size-3 my-2" : size === "xs" ? "size-1.5 my-1" : "size-2 my-1",
    true
  ) + " mx-1"}"><span class="absolute inline-flex h-full w-full animate-pulse rounded-full bg-gray-700 dark:bg-gray-200 opacity-75"></span> <span class="${"relative inline-flex " + escape(
    size === "md" ? "size-3" : size === "xs" ? "size-1.5" : "size-2",
    true
  ) + " rounded-full bg-black dark:bg-white animate-size svelte-w91618"}"></span> </span>`;
});
const ChatBubble = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path stroke-linecap="round" stroke-linejoin="round" d="M8.625 12a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375M21 12c0 4.556-4.03 8.25-9 8.25a9.764 9.764 0 0 1-2.555-.337A5.972 5.972 0 0 1 5.41 20.97a5.969 5.969 0 0 1-.474-.065 4.48 4.48 0 0 0 .978-2.025c.09-.457-.133-.901-.467-1.226C3.93 16.178 3 14.189 3 12c0-4.556 4.03-8.25 9-8.25s9 3.694 9 8.25Z"></path></svg>`;
});
const FileItemModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let isPDF;
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { item } = $$props;
  let { show = false } = $$props;
  let { edit = false } = $$props;
  let enableFullContent = false;
  let isAudio = false;
  let loading = false;
  const loadContent = async () => {
    if (item?.type === "collection") {
      loading = true;
      const knowledge = await getKnowledgeById(localStorage.token, item.id).catch((e) => {
        /* @__PURE__ */ console.error("Error fetching knowledge base:", e);
        return null;
      });
      if (knowledge) {
        item.files = knowledge.files || [];
      }
      loading = false;
    } else if (item?.type === "file") {
      loading = true;
      const file = await getFileById(localStorage.token, item.id).catch((e) => {
        /* @__PURE__ */ console.error("Error fetching file:", e);
        return null;
      });
      if (file) {
        item.file = file || {};
      }
      loading = false;
    }
    await tick();
  };
  if ($$props.item === void 0 && $$bindings.item && item !== void 0) $$bindings.item(item);
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.edit === void 0 && $$bindings.edit && edit !== void 0) $$bindings.edit(edit);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    isPDF = item?.meta?.content_type === "application/pdf" || item?.name && item?.name.toLowerCase().endsWith(".pdf");
    isAudio = (item?.meta?.content_type ?? "").startsWith("audio/") || item?.name && item?.name.toLowerCase().endsWith(".mp3") || item?.name && item?.name.toLowerCase().endsWith(".wav") || item?.name && item?.name.toLowerCase().endsWith(".ogg") || item?.name && item?.name.toLowerCase().endsWith(".m4a") || item?.name && item?.name.toLowerCase().endsWith(".webm");
    {
      if (show) {
        loadContent();
      }
    }
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "lg", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div class="font-primary px-4.5 py-3.5 w-full flex flex-col justify-center dark:text-gray-400"><div class="pb-2"><div class="flex items-start justify-between"><div><div class="font-medium text-lg dark:text-gray-100"><a href="#" class="hover:underline line-clamp-1">${escape(item?.name ?? "File")}</a></div></div> <div><button>${validate_component(XMark, "XMark").$$render($$result, {}, {}, {})}</button></div></div> <div><div class="flex flex-col items-center md:flex-row gap-1 justify-between w-full"><div class="flex flex-wrap text-xs gap-1 text-gray-500">${item?.type === "collection" ? `${item?.type ? `<div class="capitalize shrink-0">${escape(item.type)}</div>
								•` : ``} ${item?.description ? `<div class="line-clamp-1">${escape(item.description)}</div>
								•` : ``} ${item?.created_at ? `<div class="capitalize shrink-0">${escape(dayjs(item.created_at * 1e3).format("LL"))}</div>` : ``}` : ``} ${item.size ? `<div class="capitalize shrink-0">${escape(formatFileSize(item.size))}</div>
							•` : ``} ${item?.file?.data?.content ? `<div class="capitalize shrink-0">${escape($i18n.t("{{COUNT}} extracted lines", {
            COUNT: getLineCount(item?.file?.data?.content ?? "")
          }))}</div> <div class="flex items-center gap-1 shrink-0">• ${escape($i18n.t("Formatting may be inconsistent from source."))}</div>` : ``} ${item?.knowledge ? `<div class="capitalize shrink-0">${escape($i18n.t("Knowledge Base"))}</div>` : ``}</div> ${edit ? `<div>${validate_component(Tooltip, "Tooltip").$$render(
            $$result,
            {
              content: enableFullContent ? $i18n.t("Inject the entire content as context for comprehensive processing, this is recommended for complex queries.") : $i18n.t("Default to segmented retrieval for focused and relevant content extraction, this is recommended for most cases.")
            },
            {},
            {
              default: () => {
                return `<div class="flex items-center gap-1.5 text-xs">${enableFullContent ? `${escape($i18n.t("Using Entire Document"))}` : `${escape($i18n.t("Using Focused Retrieval"))}`} ${validate_component(Switch_1, "Switch").$$render(
                  $$result,
                  { state: enableFullContent },
                  {
                    state: ($$value) => {
                      enableFullContent = $$value;
                      $$settled = false;
                    }
                  },
                  {}
                )}</div>`;
              }
            }
          )}</div>` : ``}</div></div></div> <div class="max-h-[75vh] overflow-auto">${!loading ? `${item?.type === "collection" ? `<div>${each(item?.files, (file) => {
            return `<div class="flex items-center gap-2 mb-2"><div class="flex-shrink-0 text-xs">${escape(file?.meta?.name)}</div> </div>`;
          })}</div>` : `${isPDF ? `<div class="flex mb-2.5 scrollbar-none overflow-x-auto w-full border-b border-gray-100 dark:border-gray-800 text-center text-sm font-medium bg-transparent dark:text-gray-200"><button class="${"min-w-fit py-1.5 px-4 border-b " + escape(
            " ",
            true
          ) + " transition"}" type="button">${escape($i18n.t("Content"))}</button> <button class="${"min-w-fit py-1.5 px-4 border-b " + escape(
            " border-transparent text-gray-300 dark:text-gray-600 hover:text-gray-700 dark:hover:text-white",
            true
          ) + " transition"}" type="button">${escape($i18n.t("Preview"))}</button></div> ${`<div class="max-h-96 overflow-scroll scrollbar-hidden text-xs whitespace-pre-wrap">${escape((item?.file?.data?.content ?? "").trim() || "No content")}</div>`}` : `${isAudio ? `<audio${add_attribute("src", `${WEBUI_API_BASE_URL}/files/${item.id}/content`, 0)} class="w-full border-0 rounded-lg mb-2" controls playsinline></audio>` : ``} ${item?.file?.data ? `<div class="max-h-96 overflow-scroll scrollbar-hidden text-xs whitespace-pre-wrap">${escape((item?.file?.data?.content ?? "").trim() || "No content")}</div>` : ``}`}`}` : `<div class="flex items-center justify-center py-6">${validate_component(Spinner, "Spinner").$$render($$result, { className: "size-5" }, {}, {})}</div>`}</div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
const DocumentPage = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M4 21.4V2.6C4 2.26863 4.26863 2 4.6 2H16.2515C16.4106 2 16.5632 2.06321 16.6757 2.17574L19.8243 5.32426C19.9368 5.43679 20 5.5894 20 5.74853V21.4C20 21.7314 19.7314 22 19.4 22H4.6C4.26863 22 4 21.7314 4 21.4Z" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 10L16 10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 18L16 18" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 14L12 14" stroke-linecap="round" stroke-linejoin="round"></path><path d="M16 2V5.4C16 5.73137 16.2686 6 16.6 6H20" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const Database = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "size-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${add_attribute("stroke-width", strokeWidth, 0)} stroke="currentColor"${add_attribute("class", className, 0)}><path d="M5 12V18C5 18 5 21 12 21C19 21 19 18 19 18V12"></path><path d="M5 6V12C5 12 5 15 12 15C19 15 19 12 19 12V6"></path><path d="M12 3C19 3 19 6 19 6C19 6 19 9 12 9C5 9 5 6 5 6C5 6 5 3 12 3Z"></path></svg>`;
});
const PageEdit = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { className = "w-4 h-4" } = $$props;
  let { strokeWidth = "1.5" } = $$props;
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.strokeWidth === void 0 && $$bindings.strokeWidth && strokeWidth !== void 0) $$bindings.strokeWidth(strokeWidth);
  return `<svg${add_attribute("class", className, 0)} aria-hidden="true" xmlns="http://www.w3.org/2000/svg"${add_attribute("stroke-width", strokeWidth, 0)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M20 12V5.74853C20 5.5894 19.9368 5.43679 19.8243 5.32426L16.6757 2.17574C16.5632 2.06321 16.4106 2 16.2515 2H4.6C4.26863 2 4 2.26863 4 2.6V21.4C4 21.7314 4.26863 22 4.6 22H11" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 10H16M8 6H12M8 14H11" stroke-linecap="round" stroke-linejoin="round"></path><path d="M17.9541 16.9394L18.9541 15.9394C19.392 15.5015 20.102 15.5015 20.5399 15.9394V15.9394C20.9778 16.3773 20.9778 17.0873 20.5399 17.5252L19.5399 18.5252M17.9541 16.9394L14.963 19.9305C14.8131 20.0804 14.7147 20.2741 14.6821 20.4835L14.4394 22.0399L15.9957 21.7973C16.2052 21.7646 16.3988 21.6662 16.5487 21.5163L19.5399 18.5252M17.9541 16.9394L19.5399 18.5252" stroke-linecap="round" stroke-linejoin="round"></path><path d="M16 2V5.4C16 5.73137 16.2686 6 16.6 6H20" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;
});
const FileItem = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  let $settings, $$unsubscribe_settings;
  $$unsubscribe_settings = subscribe(settings, (value) => $settings = value);
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  createEventDispatcher();
  let { className = "w-60" } = $$props;
  let { colorClassName = "bg-white dark:bg-gray-850 border border-gray-50 dark:border-gray-800" } = $$props;
  let { url = null } = $$props;
  let { dismissible = false } = $$props;
  let { modal = false } = $$props;
  let { loading = false } = $$props;
  let { item = null } = $$props;
  let { edit = false } = $$props;
  let { small = false } = $$props;
  let { name } = $$props;
  let { type } = $$props;
  let { size } = $$props;
  let showModal = false;
  const decodeString = (str) => {
    try {
      return decodeURIComponent(str);
    } catch (e) {
      return str;
    }
  };
  if ($$props.className === void 0 && $$bindings.className && className !== void 0) $$bindings.className(className);
  if ($$props.colorClassName === void 0 && $$bindings.colorClassName && colorClassName !== void 0) $$bindings.colorClassName(colorClassName);
  if ($$props.url === void 0 && $$bindings.url && url !== void 0) $$bindings.url(url);
  if ($$props.dismissible === void 0 && $$bindings.dismissible && dismissible !== void 0) $$bindings.dismissible(dismissible);
  if ($$props.modal === void 0 && $$bindings.modal && modal !== void 0) $$bindings.modal(modal);
  if ($$props.loading === void 0 && $$bindings.loading && loading !== void 0) $$bindings.loading(loading);
  if ($$props.item === void 0 && $$bindings.item && item !== void 0) $$bindings.item(item);
  if ($$props.edit === void 0 && $$bindings.edit && edit !== void 0) $$bindings.edit(edit);
  if ($$props.small === void 0 && $$bindings.small && small !== void 0) $$bindings.small(small);
  if ($$props.name === void 0 && $$bindings.name && name !== void 0) $$bindings.name(name);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0) $$bindings.type(type);
  if ($$props.size === void 0 && $$bindings.size && size !== void 0) $$bindings.size(size);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${item ? `${validate_component(FileItemModal, "FileItemModal").$$render(
      $$result,
      { edit, show: showModal, item },
      {
        show: ($$value) => {
          showModal = $$value;
          $$settled = false;
        },
        item: ($$value) => {
          item = $$value;
          $$settled = false;
        }
      },
      {}
    )}` : ``} <button class="${"relative group p-1.5 " + escape(className, true) + " flex items-center gap-1 " + escape(colorClassName, true) + " " + escape(small ? "rounded-xl p-2" : "rounded-2xl", true) + " text-left"}" type="button">${!small ? `<div class="size-10 shrink-0 flex justify-center items-center bg-black/20 dark:bg-white/10 text-white rounded-xl">${!loading ? `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="size-4.5"><path fill-rule="evenodd" d="M5.625 1.5c-1.036 0-1.875.84-1.875 1.875v17.25c0 1.035.84 1.875 1.875 1.875h12.75c1.035 0 1.875-.84 1.875-1.875V12.75A3.75 3.75 0 0 0 16.5 9h-1.875a1.875 1.875 0 0 1-1.875-1.875V5.25A3.75 3.75 0 0 0 9 1.5H5.625ZM7.5 15a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5A.75.75 0 0 1 7.5 15Zm.75 2.25a.75.75 0 0 0 0 1.5H12a.75.75 0 0 0 0-1.5H8.25Z" clip-rule="evenodd"></path><path d="M12.971 1.816A5.23 5.23 0 0 1 14.25 5.25v1.875c0 .207.168.375.375.375H16.5a5.23 5.23 0 0 1 3.434 1.279 9.768 9.768 0 0 0-6.963-6.963Z"></path></svg>` : `${validate_component(Spinner, "Spinner").$$render($$result, {}, {}, {})}`}</div>` : `<div class="pl-1.5">${!loading ? `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: type === "collection" ? $i18n.t("Collection") : type === "note" ? $i18n.t("Note") : type === "chat" ? $i18n.t("Chat") : type === "file" ? $i18n.t("File") : $i18n.t("Document"),
        placement: "top"
      },
      {},
      {
        default: () => {
          return `${type === "collection" ? `${validate_component(Database, "Database").$$render($$result, {}, {}, {})}` : `${type === "note" ? `${validate_component(PageEdit, "PageEdit").$$render($$result, {}, {}, {})}` : `${type === "chat" ? `${validate_component(ChatBubble, "ChatBubble").$$render($$result, {}, {}, {})}` : `${validate_component(DocumentPage, "DocumentPage").$$render($$result, {}, {}, {})}`}`}`}`;
        }
      }
    )}` : `${validate_component(Spinner, "Spinner").$$render($$result, {}, {}, {})}`}</div>`} ${!small ? `<div class="flex flex-col justify-center -space-y-0.5 px-2.5 w-full"><div class="dark:text-gray-100 text-sm font-medium line-clamp-1 mb-1">${escape(decodeString(name))}</div> <div class="${"flex justify-between text-xs line-clamp-1 " + escape(
      $settings?.highContrastMode ?? false ? "text-gray-800 dark:text-gray-100" : "text-gray-500",
      true
    )}">${type === "file" ? `${escape($i18n.t("File"))}` : `${type === "note" ? `${escape($i18n.t("Note"))}` : `${type === "doc" ? `${escape($i18n.t("Document"))}` : `${type === "collection" ? `${escape($i18n.t("Collection"))}` : `<span class="capitalize line-clamp-1">${escape(type)}</span>`}`}`}`} ${size ? `<span class="capitalize">${escape(formatFileSize(size))}</span>` : ``}</div></div>` : `${validate_component(Tooltip, "Tooltip").$$render(
      $$result,
      {
        content: decodeString(name),
        className: "flex flex-col w-full",
        placement: "top-start"
      },
      {},
      {
        default: () => {
          return `<div class="flex flex-col justify-center -space-y-0.5 px-1 w-full"><div class="dark:text-gray-100 text-sm flex justify-between items-center"><div class="font-medium line-clamp-1 flex-1 pr-1">${escape(decodeString(name))}</div> ${size ? `<div class="text-gray-500 text-xs capitalize shrink-0">${escape(formatFileSize(size))}</div>` : `<div class="text-gray-500 text-xs capitalize shrink-0">${escape(type)}</div>`}</div></div>`;
        }
      }
    )}`} ${dismissible ? `<div class="absolute -top-1 -right-1"><button${add_attribute("aria-label", $i18n.t("Remove File"), 0)} class="${"bg-white text-black border border-gray-50 rounded-full " + escape(
      $settings?.highContrastMode ?? false ? "" : "outline-hidden focus:outline-hidden group-hover:visible invisible transition",
      true
    )}" type="button">${validate_component(XMark, "XMark").$$render($$result, { className: "size-4" }, {}, {})}</button> </div>` : ``}</button>`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  $$unsubscribe_settings();
  return $$rendered;
});
export {
  ChatBubble as C,
  FileItem as F,
  Skeleton as S
};
//# sourceMappingURL=FileItem.js.map
