import { c as create_ssr_component, l as getContext, b as subscribe, v as validate_component, g as escape } from "./ssr.js";
import { M as Modal } from "./Modal.js";
import { A as AccessControl } from "./AccessControl.js";
import { X as XMark } from "./XMark.js";
const AccessControlModal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $i18n, $$unsubscribe_i18n;
  const i18n = getContext("i18n");
  $$unsubscribe_i18n = subscribe(i18n, (value) => $i18n = value);
  let { show = false } = $$props;
  let { accessControl = {} } = $$props;
  let { accessRoles = ["read"] } = $$props;
  let { allowPublic = true } = $$props;
  let { onChange = () => {
  } } = $$props;
  if ($$props.show === void 0 && $$bindings.show && show !== void 0) $$bindings.show(show);
  if ($$props.accessControl === void 0 && $$bindings.accessControl && accessControl !== void 0) $$bindings.accessControl(accessControl);
  if ($$props.accessRoles === void 0 && $$bindings.accessRoles && accessRoles !== void 0) $$bindings.accessRoles(accessRoles);
  if ($$props.allowPublic === void 0 && $$bindings.allowPublic && allowPublic !== void 0) $$bindings.allowPublic(allowPublic);
  if ($$props.onChange === void 0 && $$bindings.onChange && onChange !== void 0) $$bindings.onChange(onChange);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${validate_component(Modal, "Modal").$$render(
      $$result,
      { size: "sm", show },
      {
        show: ($$value) => {
          show = $$value;
          $$settled = false;
        }
      },
      {
        default: () => {
          return `<div><div class="flex justify-between dark:text-gray-100 px-5 pt-3 pb-1"><div class="text-lg font-medium self-center font-primary">${escape($i18n.t("Access Control"))}</div> <button class="self-center">${validate_component(XMark, "XMark").$$render($$result, { className: "size-5" }, {}, {})}</button></div> <div class="w-full px-5 pb-4 dark:text-white">${validate_component(AccessControl, "AccessControl").$$render(
            $$result,
            {
              onChange,
              accessRoles,
              allowPublic,
              accessControl
            },
            {
              accessControl: ($$value) => {
                accessControl = $$value;
                $$settled = false;
              }
            },
            {}
          )}</div></div>`;
        }
      }
    )}`;
  } while (!$$settled);
  $$unsubscribe_i18n();
  return $$rendered;
});
export {
  AccessControlModal as A
};
//# sourceMappingURL=AccessControlModal.js.map
