/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompoundCharacterTokenizer {
    private final Pattern regexExpression;

    public CompoundCharacterTokenizer(Set<String> compoundWords) {
        this.regexExpression = Pattern.compile(this.getRegexFromTokens(compoundWords));
    }

    @Deprecated
    public CompoundCharacterTokenizer(String singleRegex) {
        this.regexExpression = Pattern.compile(singleRegex);
    }

    public CompoundCharacterTokenizer(Pattern pattern) {
        this.regexExpression = pattern;
    }

    public List<String> tokenize(String text) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher regexMatcher = this.regexExpression.matcher(text);
        int lastIndexOfPrevMatch = 0;
        while (regexMatcher.find()) {
            int beginIndexOfNextMatch = regexMatcher.start();
            String prevToken = text.substring(lastIndexOfPrevMatch, beginIndexOfNextMatch);
            if (prevToken.length() > 0) {
                tokens.add(prevToken);
            }
            String currentMatch = regexMatcher.group();
            tokens.add(currentMatch);
            lastIndexOfPrevMatch = regexMatcher.end();
        }
        String tail = text.substring(lastIndexOfPrevMatch);
        if (tail.length() > 0) {
            tokens.add(tail);
        }
        return tokens;
    }

    private String getRegexFromTokens(Set<String> compoundWords) {
        StringJoiner sj = new StringJoiner(")|(", "(", ")");
        compoundWords.forEach(sj::add);
        return sj.toString();
    }
}

