/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.ImmutablePseudoClassSetsCache;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.StyleClassSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.css.Match;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;

public final class SimpleSelector
extends Selector {
    private final String name;
    private final Set<StyleClass> styleClassSet;
    private final Set<StyleClass> unwrappedStyleClassSet;
    private final String id;
    private final Set<PseudoClass> pseudoClassState;
    private final boolean matchOnName;
    private final boolean matchOnId;
    private final boolean matchOnStyleClass;
    private final NodeOrientation nodeOrientation;

    public String getName() {
        return this.name;
    }

    public List<String> getStyleClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<StyleClass> iterator = this.styleClassSet.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getStyleClassName());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Set<StyleClass> getStyleClassSet() {
        return this.styleClassSet;
    }

    public String getId() {
        return this.id;
    }

    Set<PseudoClass> getPseudoClassStates() {
        return this.pseudoClassState;
    }

    public NodeOrientation getNodeOrientation() {
        return this.nodeOrientation;
    }

    SimpleSelector(String string, List<String> list, List<String> list2, String string2) {
        Object object;
        this.name = string == null ? "*" : string;
        this.matchOnName = string != null && !"".equals(string) && !"*".equals(string);
        this.unwrappedStyleClassSet = new StyleClassSet();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object == null || object.isEmpty()) continue;
                this.unwrappedStyleClassSet.add(StyleClassSet.getStyleClass(object));
            }
        }
        this.styleClassSet = Collections.unmodifiableSet(this.unwrappedStyleClassSet);
        this.matchOnStyleClass = this.styleClassSet.size() > 0;
        PseudoClassState pseudoClassState = new PseudoClassState();
        object = NodeOrientation.INHERIT;
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                String string3 = list2.get(i);
                if (string3 == null || string3.isEmpty()) continue;
                if ("dir(".regionMatches(true, 0, string3, 0, 4)) {
                    boolean bl = "dir(rtl)".equalsIgnoreCase(string3);
                    object = bl ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.LEFT_TO_RIGHT;
                    continue;
                }
                pseudoClassState.add(PseudoClassState.getPseudoClass(string3));
            }
        }
        this.pseudoClassState = ImmutablePseudoClassSetsCache.of(pseudoClassState);
        this.nodeOrientation = object;
        this.id = string2 == null ? "" : string2;
        this.matchOnId = string2 != null && !"".equals(string2);
    }

    @Override
    public Match createMatch() {
        int n = this.matchOnId ? 1 : 0;
        int n2 = this.styleClassSet.size();
        return new Match(this, this.pseudoClassState, n, n2);
    }

    @Override
    public boolean applies(Styleable styleable) {
        boolean bl;
        boolean bl2;
        Object object;
        ObservableList<String> observableList;
        if (this.nodeOrientation != NodeOrientation.INHERIT && styleable instanceof Node && ((observableList = ((Node)(object = (Node)styleable)).getNodeOrientation()) == NodeOrientation.INHERIT ? ((Node)object).getEffectiveNodeOrientation() != this.nodeOrientation : observableList != this.nodeOrientation)) {
            return false;
        }
        if (this.matchOnId && !(bl2 = this.id.equals(object = styleable.getId()))) {
            return false;
        }
        if (this.matchOnName && !(bl = this.name.equals(object = styleable.getTypeSelector()))) {
            return false;
        }
        if (this.matchOnStyleClass) {
            int n;
            object = new StyleClassSet();
            observableList = styleable.getStyleClass();
            int n2 = observableList.size();
            for (n = 0; n < n2; ++n) {
                String string = (String)observableList.get(n);
                if (string == null || string.isEmpty()) continue;
                StyleClass styleClass = StyleClassSet.getStyleClass(string);
                ((StyleClassSet)object).add(styleClass);
            }
            n = this.matchStyleClasses((StyleClassSet)object) ? 1 : 0;
            if (n == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean applies(Styleable styleable, Set<PseudoClass>[] setArray, int n) {
        boolean bl = this.applies(styleable);
        if (bl && setArray != null && n < setArray.length) {
            if (setArray[n] == null) {
                setArray[n] = new PseudoClassState();
            }
            setArray[n].addAll(this.pseudoClassState);
        }
        return bl;
    }

    @Override
    public boolean stateMatches(Styleable styleable, Set<PseudoClass> set) {
        return set != null ? set.containsAll(this.pseudoClassState) : false;
    }

    private boolean matchStyleClasses(StyleClassSet styleClassSet) {
        return styleClassSet.containsAll(this.unwrappedStyleClassSet);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleSelector simpleSelector = (SimpleSelector)object;
        if (this.name == null ? simpleSelector.name != null : !this.name.equals(simpleSelector.name)) {
            return false;
        }
        if (this.id == null ? simpleSelector.id != null : !this.id.equals(simpleSelector.id)) {
            return false;
        }
        if (!this.styleClassSet.equals(simpleSelector.styleClassSet)) {
            return false;
        }
        return this.pseudoClassState.equals(simpleSelector.pseudoClassState);
    }

    public int hashCode() {
        int n = 7;
        n = 31 * (n + this.name.hashCode());
        n = 31 * (n + this.styleClassSet.hashCode());
        n = 31 * (n + this.styleClassSet.hashCode());
        n = this.id != null ? 31 * (n + this.id.hashCode()) : 0;
        n = 31 * (n + this.pseudoClassState.hashCode());
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            stringBuilder.append(this.name);
        } else {
            stringBuilder.append("*");
        }
        for (StyleClass object : this.styleClassSet) {
            stringBuilder.append('.').append(object.getStyleClassName());
        }
        if (this.id != null && !this.id.isEmpty()) {
            stringBuilder.append('#');
            stringBuilder.append(this.id);
        }
        for (PseudoClass pseudoClass : this.pseudoClassState) {
            stringBuilder.append(':').append(pseudoClass.getPseudoClassName());
        }
        return stringBuilder.toString();
    }

    @Override
    protected final void writeBinary(DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        super.writeBinary(dataOutputStream, stringStore);
        dataOutputStream.writeShort(stringStore.addString(this.name));
        dataOutputStream.writeShort(this.styleClassSet.size());
        for (StyleClass styleClass : this.styleClassSet) {
            dataOutputStream.writeShort(stringStore.addString(styleClass.getStyleClassName()));
        }
        dataOutputStream.writeShort(stringStore.addString(this.id));
        int n = this.pseudoClassState.size() + (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT || this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT ? 1 : 0);
        dataOutputStream.writeShort(n);
        for (PseudoClass pseudoClass : this.pseudoClassState) {
            dataOutputStream.writeShort(stringStore.addString(pseudoClass.getPseudoClassName()));
        }
        if (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            dataOutputStream.writeShort(stringStore.addString("dir(rtl)"));
        } else if (this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT) {
            dataOutputStream.writeShort(stringStore.addString("dir(ltr)"));
        }
    }

    static SimpleSelector readBinary(int n, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        int n2 = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(stringArray[dataInputStream.readShort()]);
        }
        String string2 = stringArray[dataInputStream.readShort()];
        int n3 = dataInputStream.readShort();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n3; ++i) {
            arrayList2.add(stringArray[dataInputStream.readShort()]);
        }
        return new SimpleSelector(string, arrayList, arrayList2, string2);
    }
}

