/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;

public final class SVGUtil {
    private SVGUtil() {
    }

    public static Image parseSVGFromFile(String svgFilePath) {
        return SVGUtil.parseSVGFromFile(new File(svgFilePath));
    }

    public static Image parseSVGFromFile(File svgFile) {
        return SVGUtil.parseSVGFromFile(svgFile, -1.0, -1.0);
    }

    public static Image parseSVGFromFile(File svgFile, double prefWidth, double prefHeight) {
        return SVGUtil.toImage(SVGUtil.loadSVGDocument(svgFile), prefWidth, prefHeight, 1.0, 1.0);
    }

    public static Image parseSVGFromUrl(String urlString) {
        try {
            URL url = new URI(urlString).toURL();
            return SVGUtil.parseSVGFromUrl(url);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Image parseSVGFromUrl(URL url) {
        return SVGUtil.parseSVGFromUrl(url, -1.0, -1.0);
    }

    public static Image parseSVGFromUrl(URL url, double prefWidth, double prefHeight) {
        return SVGUtil.toImage(SVGUtil.loadSVGDocument(url), prefWidth, prefHeight, 1.0, 1.0);
    }

    private static SVGDocument loadSVGDocument(File svgFile) {
        URL svgUrl;
        try {
            svgUrl = svgFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return SVGUtil.loadSVGDocument(svgUrl);
    }

    private static SVGDocument loadSVGDocument(URL url) {
        SVGLoader loader = new SVGLoader();
        return loader.load(url);
    }

    private static SVGDocument loadSVGDocument(InputStream is) {
        SVGLoader loader = new SVGLoader();
        return loader.load(is);
    }

    public static Image toImage(InputStream is, double requestedWidth, double requestedHeight, double outputScaleX, double outputScaleY) {
        return SVGUtil.toImage(SVGUtil.loadSVGDocument(is), requestedWidth, requestedHeight, outputScaleX, outputScaleY);
    }

    public static Image toImage(URL url, double requestedWidth, double requestedHeight, double outputScaleX, double outputScaleY) {
        return SVGUtil.toImage(SVGUtil.loadSVGDocument(url), requestedWidth, requestedHeight, outputScaleX, outputScaleY);
    }

    public static Image toImage(String urlStr, double requestedWidth, double requestedHeight, double outputScaleX, double outputScaleY) {
        try {
            return SVGUtil.toImage(new URI(urlStr).toURL(), requestedWidth, requestedHeight, outputScaleX, outputScaleY);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Image toImage(File svgFile, double requestedWidth, double requestedHeight, double outputScaleX, double outputScaleY) {
        return SVGUtil.toImage(SVGUtil.loadSVGDocument(svgFile), requestedWidth, requestedHeight, outputScaleX, outputScaleY);
    }

    private static Image toImage(SVGDocument svgDocument, double requestedWidth, double requestedHeight, double outputScaleX, double outputScaleY) {
        if (svgDocument == null) {
            return null;
        }
        BufferedImage image = SVGUtil.renderImage(svgDocument, requestedWidth, requestedHeight, outputScaleX, outputScaleY);
        return SwingFXUtils.toFXImage((BufferedImage)image, null);
    }

    private static BufferedImage renderImage(SVGDocument svgDocument, double requestedWidth, double requestedHeight, double outputScaleX, double outputScaleY) {
        FloatSize size = svgDocument.size();
        double width = size.width;
        double height = size.height;
        double aspectRatio = width / height;
        if (requestedWidth > 0.0) {
            requestedHeight = requestedWidth / aspectRatio;
        } else if (requestedHeight > 0.0) {
            requestedWidth = requestedHeight * aspectRatio;
        }
        width = requestedWidth > 0.0 ? requestedWidth : width * outputScaleX;
        height = requestedHeight > 0.0 ? requestedHeight : height * outputScaleY;
        BufferedImage image = new BufferedImage((int)width, (int)height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        svgDocument.render(null, g2d, new ViewBox(0.0f, 0.0f, (float)width, (float)height));
        g2d.dispose();
        return image;
    }
}

