/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.YearView;
import java.time.LocalDate;
import java.time.Year;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class YearViewSkin
extends SkinBase<YearView> {
    private final Label yearRangeLabel = new Label();
    private final HBox header;
    private final GridPane gridPane;
    private int offset = 0;

    public YearViewSkin(YearView yearView) {
        super((Control)yearView);
        this.yearRangeLabel.getStyleClass().add((Object)"year-range-label");
        this.yearRangeLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow((Node)this.yearRangeLabel, (Priority)Priority.ALWAYS);
        Region leftArrow = new Region();
        leftArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        leftArrow.getStyleClass().addAll((Object[])new String[]{"arrow", "left-arrow"});
        Region rightArrow = new Region();
        rightArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        rightArrow.getStyleClass().addAll((Object[])new String[]{"arrow", "right-arrow"});
        StackPane leftArrowButton = new StackPane(new Node[]{leftArrow});
        leftArrowButton.setMaxHeight(Double.MAX_VALUE);
        leftArrowButton.getStyleClass().addAll((Object[])new String[]{"arrow-button", "left-button"});
        leftArrowButton.setOnMouseClicked(evt -> {
            --this.offset;
            this.buildGrid();
            evt.consume();
        });
        StackPane rightArrowButton = new StackPane(new Node[]{rightArrow});
        rightArrowButton.getStyleClass().addAll((Object[])new String[]{"arrow-button", "right-button"});
        rightArrowButton.setOnMouseClicked(evt -> {
            ++this.offset;
            this.buildGrid();
            evt.consume();
        });
        this.header = new HBox(new Node[]{leftArrowButton, this.yearRangeLabel, rightArrowButton});
        this.header.addEventHandler(MouseEvent.MOUSE_CLICKED, Event::consume);
        this.header.getStyleClass().add((Object)"header");
        this.header.setViewOrder(Double.NEGATIVE_INFINITY);
        this.header.setFillHeight(true);
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add((Object)"grid-pane");
        for (int i = 0; i < 4; ++i) {
            ColumnConstraints col1 = new ColumnConstraints();
            col1.setPercentWidth(25.0);
            this.gridPane.getColumnConstraints().add((Object)col1);
        }
        int numberOfRows = 5;
        for (int i = 0; i < numberOfRows; ++i) {
            RowConstraints row = new RowConstraints();
            row.setPercentHeight(100.0 / (double)numberOfRows);
            this.gridPane.getRowConstraints().add((Object)row);
        }
        this.getChildren().addAll((Object[])new Node[]{this.header, this.gridPane});
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)yearView.widthProperty());
        clip.heightProperty().bind((ObservableValue)yearView.heightProperty());
        yearView.setClip((Node)clip);
        InvalidationListener buildGridListener = obs -> this.buildGrid();
        yearView.valueProperty().addListener(buildGridListener);
        yearView.rowsProperty().addListener(buildGridListener);
        yearView.colsProperty().addListener(buildGridListener);
        this.buildGrid();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double headerHeight = this.snapSizeY(this.header.prefHeight(-1.0));
        this.header.resizeRelocate(contentX, contentY, contentWidth, headerHeight);
        this.gridPane.resizeRelocate(contentX, contentY + headerHeight, contentWidth, contentHeight - headerHeight);
    }

    private void buildGrid() {
        YearView yearView = (YearView)this.getSkinnable();
        int rows = yearView.getRows();
        int cols = yearView.getCols();
        int visibleYears = rows * cols;
        Year selectedYear = yearView.getValue();
        int currentYear = LocalDate.now().getYear();
        int firstYear = Optional.ofNullable(selectedYear).map(Year::getValue).orElse(currentYear) / visibleYears * visibleYears + this.offset * visibleYears;
        this.gridPane.getChildren().clear();
        this.yearRangeLabel.setText(firstYear + "-" + (firstYear + visibleYears - 1));
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < cols; ++column) {
                int finalYear = firstYear;
                Node yearNode = this.createYearNode(finalYear);
                yearNode.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    Year earliestYear = yearView.getEarliestYear();
                    if (earliestYear != null && Year.of(finalYear).isBefore(earliestYear)) {
                        return true;
                    }
                    Year latestYear = yearView.getLatestYear();
                    if (latestYear != null && Year.of(finalYear).isAfter(latestYear)) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{yearView.earliestYearProperty(), yearView.latestYearProperty()}));
                yearNode.setOnMouseClicked(evt -> {
                    this.offset = 0;
                    yearView.setValue(Year.of(finalYear));
                });
                if (selectedYear != null && firstYear == selectedYear.getValue()) {
                    yearNode.getStyleClass().add((Object)"selected");
                }
                if (firstYear == currentYear) {
                    yearNode.getStyleClass().add((Object)"current");
                }
                this.gridPane.add(yearNode, column, row);
                ++firstYear;
            }
        }
    }

    private Node createYearNode(int year) {
        Label yearLabel = new Label(Integer.toString(year));
        yearLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        yearLabel.getStyleClass().add((Object)"year-label");
        YearView view = (YearView)this.getSkinnable();
        Region selectionIndicator = new Region();
        selectionIndicator.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> view.getYear() == year, (Observable[])new Observable[]{view.valueProperty()}));
        selectionIndicator.getStyleClass().add((Object)"selection-indicator");
        VBox box = new VBox(new Node[]{yearLabel, selectionIndicator});
        box.setMaxWidth(Double.NEGATIVE_INFINITY);
        box.setAlignment(Pos.CENTER);
        box.getStyleClass().add((Object)"year-box");
        return box;
    }
}

