/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.HistoryButton;
import com.dlsc.gemsfx.skins.SearchFieldPopup;
import com.dlsc.gemsfx.skins.SearchFieldSkin;
import com.dlsc.gemsfx.util.HistoryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.animation.RotateTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class SearchField<T>
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "search-field";
    private static final boolean DEFAULT_ADDING_ITEM_TO_HISTORY_ON_ENTER = true;
    private static final boolean DEFAULT_ADDING_ITEM_TO_HISTORY_ON_COMMIT = true;
    private static final boolean DEFAULT_ADDING_ITEM_TO_HISTORY_ON_FOCUS_LOST = true;
    private static final PseudoClass DISABLED_POPUP_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"disabled-popup");
    private final SearchService searchService = new SearchService();
    private final TextField editor = new TextField();
    private final SearchFieldPopup<T> popup;
    private final HistoryButton<String> historyButton;
    private boolean committing;
    private final ObjectProperty<Consumer<T>> onCommit = new SimpleObjectProperty((Object)this, "onCommit");
    private SearchEventHandlerProperty onSearchStarted;
    private SearchEventHandlerProperty onSearchFinished;
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic", (Object)new FontIcon((Ikon)MaterialDesign.MDI_MAGNIFY));
    private final ObjectProperty<Node> busyGraphic = new SimpleObjectProperty((Object)this, "busyGraphic", (Object)new FontIcon((Ikon)MaterialDesign.MDI_CACHED));
    private final ReadOnlyBooleanWrapper searching = new ReadOnlyBooleanWrapper((Object)this, "searching");
    private final BooleanProperty hidePopupWithSingleChoice = new SimpleBooleanProperty((Object)this, "hidePopupWithSingleChoice", false);
    private final BooleanProperty hidePopupWithNoChoice = new SimpleBooleanProperty((Object)this, "hidePopupWithNoChoice", false);
    private final ListProperty<T> suggestions = new SimpleListProperty((Object)this, "suggestions", FXCollections.observableArrayList());
    private final ObservableList<T> readOnlySuggestions = FXCollections.unmodifiableObservableList(this.suggestions);
    private final ReadOnlyBooleanWrapper newItem = new ReadOnlyBooleanWrapper((Object)this, "newItem");
    private final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final ObjectProperty<Comparator<T>> comparator = new SimpleObjectProperty((Object)this, "comparator");
    private final ObjectProperty<Callback<String, T>> newItemProducer = new SimpleObjectProperty((Object)this, "newItemProducer");
    private final DoubleProperty autoCompletionGap = new SimpleDoubleProperty((Object)this, "autoCompletionGap", 1.0);
    private final ReadOnlyStringWrapper fullText = new ReadOnlyStringWrapper((Object)this, "fullText");
    private final StringProperty text = new SimpleStringProperty((Object)this, "text", "");
    private final StringProperty promptText = new SimpleStringProperty((Object)this, "promptText", "");
    private final ReadOnlyStringWrapper autoCompletedText = new ReadOnlyStringWrapper((Object)this, "autoCompletedText");
    private final ObjectProperty<BiFunction<T, String, Boolean>> matcher = new SimpleObjectProperty((Object)this, "matcher");
    private final ObjectProperty<T> selectedItem = new SimpleObjectProperty((Object)this, "selectedItem");
    private final ObjectProperty<Callback<SearchFieldSuggestionRequest, Collection<T>>> suggestionProvider = new SimpleObjectProperty((Object)this, "suggestionProvider");
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");
    private ObjectProperty<Node> placeholder;
    private BooleanProperty autoCommitOnFocusLost;
    private final ObjectProperty<Node> left = new SimpleObjectProperty((Object)this, "left");
    private final ObjectProperty<Node> right = new SimpleObjectProperty((Object)this, "left");
    private final BooleanProperty showSearchIcon = new SimpleBooleanProperty((Object)this, "showSearchIcon", true);
    private ObjectProperty<Node> historyPlaceholder = new SimpleObjectProperty((Object)this, "historyPlaceholder");
    private BooleanProperty addingItemToHistoryOnEnter;
    private BooleanProperty addingItemToHistoryOnFocusLost;
    private BooleanProperty addingItemToHistoryOnCommit;
    private ObjectProperty<HistoryManager<String>> historyManager;

    public SearchField() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.historyButton = this.createHistoryButton();
        this.setGraphic((Node)this.historyButton);
        this.popup = new SearchFieldPopup(this);
        this.editor.textProperty().bindBidirectional((Property)this.textProperty());
        this.editor.promptTextProperty().bindBidirectional((Property)this.promptTextProperty());
        Label placeholder = new Label("No items.");
        placeholder.getStyleClass().add((Object)"history-placeholder");
        this.setHistoryPlaceholder((Node)placeholder);
        this.setPlaceholder((Node)new Label("No items found"));
        this.focusedProperty().addListener(it -> {
            if (this.isFocused()) {
                this.getEditor().requestFocus();
            }
        });
        this.editor.focusedProperty().addListener(it -> {
            if (!this.isAutoCommitOnFocusLost()) {
                if (this.popup.isShowing()) {
                    this.popup.hide();
                }
                return;
            }
            if (!this.editor.isFocused()) {
                if (this.isAddingItemToHistoryOnFocusLost()) {
                    this.addToHistory(this.editor.getText());
                }
                this.commit();
                if (this.getSelectedItem() == null) {
                    this.editor.setText("");
                } else {
                    this.invokeCommitHandler();
                }
            }
        });
        this.addEventFilter(KeyEvent.KEY_RELEASED, evt -> {
            boolean releasedEnter;
            KeyCode keyCode = evt.getCode();
            boolean lastHistoryPopupShowing = this.historyButton.isPopupShowing();
            if (keyCode != KeyCode.UP && keyCode != KeyCode.DOWN) {
                this.historyButton.hidePopup();
            }
            if ((releasedEnter = keyCode.equals((Object)KeyCode.ENTER)) && this.isAddingItemToHistoryOnEnter() && !lastHistoryPopupShowing) {
                this.addToHistory(this.editor.getText());
            }
            if ((keyCode.equals((Object)KeyCode.RIGHT) || releasedEnter) && !lastHistoryPopupShowing) {
                this.commit();
                evt.consume();
                this.invokeCommitHandler();
            } else if (keyCode.equals((Object)KeyCode.LEFT)) {
                this.editor.positionCaret(Math.max(0, this.editor.getCaretPosition() - 1));
            } else if (keyCode.equals((Object)KeyCode.ESCAPE)) {
                this.historyButton.hidePopup();
                this.cancel();
                evt.consume();
            } else if (KeyCombination.keyCombination((String)"shortcut+a").match(evt)) {
                this.editor.selectAll();
                evt.consume();
            }
        });
        this.setMatcher((item, searchText) -> this.getConverter().toString(item).startsWith(searchText.toLowerCase()));
        this.setConverter(new StringConverter<T>(){

            public String toString(T item) {
                if (item != null) {
                    return item.toString();
                }
                return "";
            }

            public T fromString(String s) {
                return null;
            }
        });
        this.setCellFactory(view -> new SearchFieldListCell(this));
        this.setComparator(Comparator.comparing(Object::toString));
        this.fullText.bind((ObservableValue)Bindings.createStringBinding(() -> this.editor.getText() + this.getAutoCompletedText(), (Observable[])new Observable[]{this.editor.textProperty(), this.autoCompletedText}));
        this.editor.textProperty().addListener(it -> {
            if (!this.committing) {
                if (StringUtils.isNotBlank((CharSequence)this.editor.getText())) {
                    this.searchService.restart();
                } else {
                    this.update(null);
                }
            }
        });
        this.selectedItem.addListener(it -> {
            T selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                String displayName = this.getConverter().toString(selectedItem);
                String text = this.editor.getText();
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.committing = true;
                    try {
                        this.editor.setText(displayName);
                    }
                    finally {
                        this.committing = false;
                    }
                } else if (StringUtils.startsWithIgnoreCase((CharSequence)displayName, (CharSequence)text)) {
                    this.autoCompletedText.set(displayName.substring(text.length()));
                } else {
                    this.autoCompletedText.set("");
                }
            } else {
                this.autoCompletedText.set("");
            }
        });
        this.editor.textProperty().addListener(it -> this.autoCompletedText.set(""));
        this.converter.addListener(it -> {
            if (this.getConverter() == null) {
                throw new IllegalArgumentException("converter can not be null");
            }
        });
        this.cellFactory.addListener(it -> {
            if (this.getCellFactory() == null) {
                throw new IllegalArgumentException("cell factory can not be null");
            }
        });
        this.suggestionProvider.addListener(it -> {
            if (this.getSuggestionProvider() == null) {
                throw new IllegalArgumentException("suggestion provider can not be null");
            }
        });
        this.comparator.addListener(it -> {
            if (this.getComparator() == null) {
                throw new IllegalArgumentException("comparator can not be null");
            }
        });
        this.matcher.addListener(it -> {
            if (this.getMatcher() == null) {
                throw new IllegalArgumentException("matcher can not be null");
            }
        });
        RotateTransition rotateTransition = new RotateTransition();
        rotateTransition.nodeProperty().bind(this.busyGraphicProperty());
        rotateTransition.setCycleCount(-1);
        rotateTransition.setByAngle(360.0);
        rotateTransition.setDuration(Duration.millis((double)500.0));
        this.searching.addListener(it -> {
            if (this.searching.get() && this.isShowSearchIcon()) {
                rotateTransition.play();
            } else {
                rotateTransition.stop();
            }
        });
        this.sceneProperty().addListener(it -> {
            if (this.getScene() == null) {
                rotateTransition.stop();
            }
        });
        this.searchService.setOnRunning(evt -> this.fireEvent(new SearchEvent(SearchEvent.SEARCH_STARTED, this.searchService.getText())));
        this.searchService.setOnSucceeded(evt -> {
            this.update((Collection)this.searchService.getValue());
            this.fireEvent(new SearchEvent(SearchEvent.SEARCH_FINISHED, this.searchService.getText()));
        });
        this.searching.bind((ObservableValue)this.searchService.runningProperty());
    }

    private void onHistoryItemConfirmed(String historyItem) {
        if (historyItem != null) {
            int oldLen = this.editor.textProperty().getValueSafe().length();
            this.editor.replaceText(0, oldLen, historyItem);
        }
        this.historyButton.hidePopup();
    }

    private HistoryButton<String> createHistoryButton() {
        HistoryButton<String> historyButton = new HistoryButton<String>((Node)this);
        historyButton.historyManagerProperty().bind(this.historyManagerProperty());
        historyButton.setOnItemSelected(value -> {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.setText((String)value);
            }
            historyButton.hidePopup();
        });
        Region graphic = new Region();
        graphic.getStyleClass().add((Object)"icon");
        historyButton.setGraphic((Node)graphic);
        historyButton.setFocusTraversable(false);
        return historyButton;
    }

    private void invokeCommitHandler() {
        Consumer<T> onCommit;
        T selectedItem = this.getSelectedItem();
        if (selectedItem != null && (onCommit = this.getOnCommit()) != null) {
            onCommit.accept(selectedItem);
        }
    }

    public void commit() {
        this.committing = true;
        try {
            T selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                String text = this.getConverter().toString(selectedItem);
                if (text != null) {
                    this.editor.setText(text);
                    this.editor.positionCaret(text.length());
                    if (this.isAddingItemToHistoryOnCommit()) {
                        this.addToHistory(text);
                    }
                } else {
                    this.clear();
                }
            } else {
                this.clear();
            }
            this.getProperties().put((Object)"committed", (Object)"");
        }
        finally {
            this.committing = false;
        }
    }

    private void addToHistory(String text) {
        HistoryManager<String> historyManager = this.getHistoryManager();
        if (historyManager != null && StringUtils.isNotBlank((CharSequence)text)) {
            historyManager.add(text);
        }
    }

    public final Consumer<T> getOnCommit() {
        return (Consumer)this.onCommit.get();
    }

    public final ObjectProperty<Consumer<T>> onCommitProperty() {
        return this.onCommit;
    }

    public void setOnCommit(Consumer<T> onCommit) {
        this.onCommit.set(onCommit);
    }

    public final ObjectProperty<EventHandler<SearchEvent>> onSearchStartedProperty() {
        if (this.onSearchStarted == null) {
            this.onSearchStarted = new SearchEventHandlerProperty("onSearchStartedProperty", SearchEvent.SEARCH_STARTED);
        }
        return this.onSearchStarted;
    }

    public final void setOnSearchStarted(EventHandler<SearchEvent> value) {
        this.onSearchStartedProperty().set(value);
    }

    public final EventHandler<SearchEvent> getOnSearchStarted() {
        return this.onSearchStarted == null ? null : (EventHandler)this.onSearchStartedProperty().get();
    }

    public final ObjectProperty<EventHandler<SearchEvent>> onSearchFinishedProperty() {
        if (this.onSearchFinished == null) {
            this.onSearchFinished = new SearchEventHandlerProperty("onSearchFinishedProperty", SearchEvent.SEARCH_FINISHED);
        }
        return this.onSearchFinished;
    }

    public final void setOnSearchFinished(EventHandler<SearchEvent> value) {
        this.onSearchFinishedProperty().set(value);
    }

    public final EventHandler<SearchEvent> getOnSearchFinished() {
        return this.onSearchFinished == null ? null : (EventHandler)this.onSearchFinishedProperty().get();
    }

    public final Node getGraphic() {
        return (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public final void setGraphic(Node graphic) {
        this.graphic.set((Object)graphic);
    }

    public final Node getBusyGraphic() {
        return (Node)this.busyGraphic.get();
    }

    public final ObjectProperty<Node> busyGraphicProperty() {
        return this.busyGraphic;
    }

    public final void setBusyGraphic(Node busyGraphic) {
        this.busyGraphic.set((Object)busyGraphic);
    }

    public final boolean isSearching() {
        return this.searching.get();
    }

    public final boolean isHidePopupWithSingleChoice() {
        return this.hidePopupWithSingleChoice.get();
    }

    public final BooleanProperty hidePopupWithSingleChoiceProperty() {
        return this.hidePopupWithSingleChoice;
    }

    public final void setHidePopupWithSingleChoice(boolean hidePopupWithSingleChoice) {
        this.hidePopupWithSingleChoice.set(hidePopupWithSingleChoice);
    }

    public final boolean isHidePopupWithNoChoice() {
        return this.hidePopupWithNoChoice.get();
    }

    public final BooleanProperty hidePopupWithNoChoiceProperty() {
        return this.hidePopupWithNoChoice;
    }

    public final void setHidePopupWithNoChoice(boolean hidePopupWithNoChoice) {
        this.hidePopupWithNoChoice.set(hidePopupWithNoChoice);
    }

    public final ReadOnlyBooleanProperty searchingProperty() {
        return this.searching.getReadOnlyProperty();
    }

    public final TextField getEditor() {
        return this.editor;
    }

    public void select(T item) {
        this.setSelectedItem(item);
        this.commit();
    }

    public final void cancel() {
        this.searchService.cancel();
        this.getProperties().put((Object)"cancelled", (Object)"");
        this.setSelectedItem(null);
        this.setText("");
    }

    protected void update(Collection<T> newSuggestions) {
        if (newSuggestions == null) {
            this.suggestions.clear();
            return;
        }
        this.suggestions.setAll(newSuggestions);
        String searchText = this.editor.getText();
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            try {
                BiFunction matcher = this.getMatcher();
                this.newItem.set(false);
                newSuggestions.stream().filter(item -> (Boolean)matcher.apply(item, searchText)).findFirst().ifPresentOrElse(arg_0 -> this.selectedItem.set(arg_0), () -> {
                    if (StringUtils.isNotBlank((CharSequence)searchText)) {
                        Callback<String, T> itemProducer = this.getNewItemProducer();
                        if (itemProducer != null) {
                            this.newItem.set(true);
                            this.selectedItem.set(itemProducer.call((Object)searchText));
                        } else {
                            this.selectedItem.set(null);
                        }
                    } else {
                        this.selectedItem.set(null);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.selectedItem.set(null);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new SearchFieldSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(SearchField.class.getResource("search-field.css")).toExternalForm();
    }

    public void clear() {
        this.getEditor().clear();
    }

    public final ObservableList<T> getSuggestions() {
        return this.readOnlySuggestions;
    }

    public final boolean isNewItem() {
        return this.newItem.get();
    }

    public final ReadOnlyBooleanProperty newItemProperty() {
        return this.newItem.getReadOnlyProperty();
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public final Comparator<T> getComparator() {
        return (Comparator)this.comparator.get();
    }

    public final ObjectProperty<Comparator<T>> comparatorProperty() {
        return this.comparator;
    }

    public final void setComparator(Comparator<T> comparator) {
        this.comparator.set(comparator);
    }

    public final Callback<String, T> getNewItemProducer() {
        return (Callback)this.newItemProducer.get();
    }

    public final ObjectProperty<Callback<String, T>> newItemProducerProperty() {
        return this.newItemProducer;
    }

    public final void setNewItemProducer(Callback<String, T> newItemProducer) {
        this.newItemProducer.set(newItemProducer);
    }

    public final double getAutoCompletionGap() {
        return this.autoCompletionGap.get();
    }

    public final DoubleProperty autoCompletionGapProperty() {
        return this.autoCompletionGap;
    }

    public final void setAutoCompletionGap(double autoCompletionGap) {
        this.autoCompletionGap.set(autoCompletionGap);
    }

    public final String getFullText() {
        return this.fullText.get();
    }

    public final ReadOnlyStringProperty fullTextProperty() {
        return this.fullText.getReadOnlyProperty();
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String text) {
        this.text.set((Object)text);
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final void setPromptText(String promptText) {
        this.promptText.set((Object)promptText);
    }

    public final String getAutoCompletedText() {
        return this.autoCompletedText.get();
    }

    public final ReadOnlyStringProperty autoCompletedTextProperty() {
        return this.autoCompletedText.getReadOnlyProperty();
    }

    public final BiFunction<T, String, Boolean> getMatcher() {
        return (BiFunction)this.matcher.get();
    }

    public final ObjectProperty<BiFunction<T, String, Boolean>> matcherProperty() {
        return this.matcher;
    }

    public final void setMatcher(BiFunction<T, String, Boolean> matcher) {
        this.matcher.set(matcher);
    }

    public final ObjectProperty<T> selectedItemProperty() {
        return this.selectedItem;
    }

    public final T getSelectedItem() {
        return (T)this.selectedItem.get();
    }

    public final void setSelectedItem(T selectedItem) {
        this.selectedItem.set(selectedItem);
    }

    public final Callback<SearchFieldSuggestionRequest, Collection<T>> getSuggestionProvider() {
        return (Callback)this.suggestionProvider.get();
    }

    public final ObjectProperty<Callback<SearchFieldSuggestionRequest, Collection<T>>> suggestionProviderProperty() {
        return this.suggestionProvider;
    }

    public final void setSuggestionProvider(Callback<SearchFieldSuggestionRequest, Collection<T>> suggestionProvider) {
        this.suggestionProvider.set(suggestionProvider);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> converter) {
        this.converter.set(converter);
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty((Object)this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node value) {
        this.placeholderProperty().set((Object)value);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final BooleanProperty autoCommitOnFocusLostProperty() {
        if (this.autoCommitOnFocusLost == null) {
            this.autoCommitOnFocusLost = new SimpleBooleanProperty((Object)this, "autoCommitOnFocusLost", true);
        }
        return this.autoCommitOnFocusLost;
    }

    public final boolean isAutoCommitOnFocusLost() {
        return this.autoCommitOnFocusLost == null || this.autoCommitOnFocusLost.get();
    }

    public final void setAutoCommitOnFocusLost(boolean value) {
        this.autoCommitOnFocusLostProperty().set(value);
    }

    public final Node getLeft() {
        return (Node)this.left.get();
    }

    public final ObjectProperty<Node> leftProperty() {
        return this.left;
    }

    public final void setLeft(Node left) {
        this.left.set((Object)left);
    }

    public final Node getRight() {
        return (Node)this.right.get();
    }

    public final ObjectProperty<Node> rightProperty() {
        return this.right;
    }

    public final void setRight(Node right) {
        this.right.set((Object)right);
    }

    public final boolean isShowSearchIcon() {
        return this.showSearchIcon.get();
    }

    public final BooleanProperty showSearchIconProperty() {
        return this.showSearchIcon;
    }

    public final void setShowSearchIcon(boolean showSearchIcon) {
        this.showSearchIcon.set(showSearchIcon);
    }

    public final ObjectProperty<Node> historyPlaceholderProperty() {
        if (this.historyPlaceholder == null) {
            this.historyPlaceholder = new SimpleObjectProperty((Object)this, "historyPlaceholder");
        }
        return this.historyPlaceholder;
    }

    public final Node getHistoryPlaceholder() {
        return this.historyPlaceholder == null ? null : (Node)this.historyPlaceholder.get();
    }

    public final void setHistoryPlaceholder(Node historyPlaceholder) {
        this.historyPlaceholderProperty().set((Object)historyPlaceholder);
    }

    public final BooleanProperty addingItemToHistoryOnEnterProperty() {
        if (this.addingItemToHistoryOnEnter == null) {
            this.addingItemToHistoryOnEnter = new SimpleBooleanProperty((Object)this, "addingItemToHistoryOnEnter", true);
        }
        return this.addingItemToHistoryOnEnter;
    }

    public final boolean isAddingItemToHistoryOnEnter() {
        return this.addingItemToHistoryOnEnter == null ? true : this.addingItemToHistoryOnEnter.get();
    }

    public final void setAddingItemToHistoryOnEnter(boolean addingItemToHistoryOnEnter) {
        this.addingItemToHistoryOnEnterProperty().set(addingItemToHistoryOnEnter);
    }

    public final BooleanProperty addingItemToHistoryOnFocusLostProperty() {
        if (this.addingItemToHistoryOnFocusLost == null) {
            this.addingItemToHistoryOnFocusLost = new SimpleBooleanProperty((Object)this, "addingItemToHistoryOnFocusLost", true);
        }
        return this.addingItemToHistoryOnFocusLost;
    }

    public final boolean isAddingItemToHistoryOnFocusLost() {
        return this.addingItemToHistoryOnFocusLost == null ? true : this.addingItemToHistoryOnFocusLost.get();
    }

    public final void setAddingItemToHistoryOnFocusLost(boolean addingItemToHistoryOnFocusLost) {
        this.addingItemToHistoryOnFocusLostProperty().set(addingItemToHistoryOnFocusLost);
    }

    public final BooleanProperty addingItemToHistoryOnCommitProperty() {
        if (this.addingItemToHistoryOnCommit == null) {
            this.addingItemToHistoryOnCommit = new SimpleBooleanProperty((Object)this, "addingItemToHistoryOnCommit", true);
        }
        return this.addingItemToHistoryOnCommit;
    }

    public final boolean isAddingItemToHistoryOnCommit() {
        return this.addingItemToHistoryOnCommit == null ? true : this.addingItemToHistoryOnCommit.get();
    }

    public final void setAddingItemToHistoryOnCommit(boolean addingItemToHistoryOnCommit) {
        this.addingItemToHistoryOnCommitProperty().set(addingItemToHistoryOnCommit);
    }

    public final ObjectProperty<HistoryManager<String>> historyManagerProperty() {
        if (this.historyManager == null) {
            this.historyManager = new SimpleObjectProperty<HistoryManager<String>>((Object)this, "historyManager"){

                protected void invalidated() {
                    SearchField.this.pseudoClassStateChanged(DISABLED_POPUP_PSEUDO_CLASS, this.get() == null);
                }
            };
        }
        return this.historyManager;
    }

    public final HistoryManager<String> getHistoryManager() {
        return this.historyManager == null ? null : (HistoryManager)this.historyManager.get();
    }

    public final void setHistoryManager(HistoryManager<String> historyManager) {
        this.historyManagerProperty().set(historyManager);
    }

    public final SearchFieldPopup<T> getPopup() {
        return this.popup;
    }

    private class SearchService
    extends Service<Collection<T>> {
        private String text;

        private SearchService() {
        }

        protected Task<Collection<T>> createTask() {
            this.text = SearchField.this.editor.getText();
            return new SearchTask(this.text);
        }

        public String getText() {
            return this.text;
        }
    }

    private class SearchEventHandlerProperty
    extends SimpleObjectProperty<EventHandler<SearchEvent>> {
        private final EventType<SearchEvent> eventType;

        public SearchEventHandlerProperty(String name, EventType<SearchEvent> eventType) {
            super((Object)SearchField.this, name);
            this.eventType = eventType;
        }

        protected void invalidated() {
            SearchField.this.setEventHandler(this.eventType, (EventHandler)this.get());
        }
    }

    public static class SearchEvent
    extends Event {
        public static final EventType<SearchEvent> SEARCH_STARTED = new EventType(Event.ANY, "SEARCH_STARTED");
        public static final EventType<SearchEvent> SEARCH_FINISHED = new EventType(Event.ANY, "SEARCH_FINISHED");
        private final String text;

        public SearchEvent(EventType<? extends SearchEvent> eventType, String text) {
            super(eventType);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("eventType", (Object)this.eventType).append("target", (Object)this.target).append("consumed", this.consumed).append("text", (Object)this.text).toString();
        }
    }

    public static class SearchFieldListCell<T>
    extends ListCell<T> {
        private final SearchField<T> searchField;
        private final Text text1 = new Text();
        private final Text text2 = new Text();
        private final Text text3 = new Text();

        public SearchFieldListCell(SearchField<T> searchField) {
            this.searchField = searchField;
            this.getStyleClass().add((Object)"search-field-list-cell");
            TextFlow textFlow = new TextFlow();
            textFlow.getChildren().setAll((Object[])new Node[]{this.text1, this.text2, this.text3});
            this.text1.getStyleClass().addAll((Object[])new String[]{"text", "start"});
            this.text2.getStyleClass().addAll((Object[])new String[]{"text", "middle"});
            this.text3.getStyleClass().addAll((Object[])new String[]{"text", "end"});
            this.setGraphic((Node)textFlow);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (item != null && !empty) {
                String cellText = this.searchField.getConverter().toString(item);
                String text = this.searchField.getEditor().getText();
                int index = cellText.toLowerCase().indexOf(text.toLowerCase());
                if (index >= 0) {
                    this.text1.setText(cellText.substring(0, index));
                    this.text2.setText(cellText.substring(index, index + text.length()));
                    this.text3.setText(cellText.substring(index + text.length()));
                } else {
                    this.text1.setText(cellText);
                    this.text2.setText("");
                    this.text3.setText("");
                }
            } else {
                this.text1.setText("");
                this.text2.setText("");
                this.text3.setText("");
            }
        }
    }

    public static interface SearchFieldSuggestionRequest {
        public boolean isCancelled();

        public String getUserText();
    }

    private class SearchTask
    extends Task<Collection<T>> {
        private final String searchText;

        public SearchTask(String searchText) {
            this.searchText = searchText;
        }

        protected Collection<T> call() throws Exception {
            Thread.sleep(250L);
            if (!this.isCancelled() && StringUtils.isNotBlank((CharSequence)this.searchText)) {
                return (Collection)SearchField.this.getSuggestionProvider().call((Object)new SearchFieldSuggestionRequest(){

                    @Override
                    public boolean isCancelled() {
                        return SearchTask.this.isCancelled();
                    }

                    @Override
                    public String getUserText() {
                        return SearchTask.this.searchText;
                    }
                });
            }
            return Collections.emptyList();
        }
    }
}

