/*
 * Decompiled with CFR 0.152.
 */
package net.harawata.appdirs.impl;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import net.harawata.appdirs.AppDirsException;
import net.harawata.appdirs.impl.WindowsAppDirs;
import net.harawata.appdirs.impl.WindowsFolderResolver;

public class ShellFolderResolver
implements WindowsFolderResolver {
    @Override
    public String resolveFolder(WindowsAppDirs.FolderId folderId) {
        try {
            return Shell32Util.getKnownFolderPath((Guid.GUID)this.convertFolderIdToGuid(folderId));
        }
        catch (Win32Exception e) {
            throw new AppDirsException("SHGetKnownFolderPath returns an error: " + e.getErrorCode());
        }
        catch (UnsatisfiedLinkError e) {
            try {
                int folder = this.convertFolderIdToCsidl(folderId);
                return Shell32Util.getFolderPath((int)folder);
            }
            catch (Win32Exception e2) {
                throw new AppDirsException("SHGetFolderPath returns an error: " + e2.getErrorCode());
            }
        }
    }

    private Guid.GUID convertFolderIdToGuid(WindowsAppDirs.FolderId folderId) {
        switch (folderId) {
            case APPDATA: {
                return KnownFolders.FOLDERID_RoamingAppData;
            }
            case LOCAL_APPDATA: {
                return KnownFolders.FOLDERID_LocalAppData;
            }
            case COMMON_APPDATA: {
                return KnownFolders.FOLDERID_ProgramData;
            }
            case DOWNLOADS: {
                return KnownFolders.FOLDERID_Downloads;
            }
        }
        throw new AppDirsException("Unknown folder ID " + (Object)((Object)folderId) + " was specified.");
    }

    protected int convertFolderIdToCsidl(WindowsAppDirs.FolderId folderId) {
        switch (folderId) {
            case APPDATA: {
                return 26;
            }
            case LOCAL_APPDATA: {
                return 28;
            }
            case COMMON_APPDATA: {
                return 35;
            }
        }
        throw new AppDirsException("Unknown folder ID " + (Object)((Object)folderId) + " was specified.");
    }
}

