/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.Severity;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;

public class ValidationStatus {
    private ListProperty<ValidationMessage> messages = new SimpleListProperty(FXCollections.observableArrayList());
    private ObservableList<ValidationMessage> unmodifiableMessages = FXCollections.unmodifiableObservableList(this.messages);
    private ObservableList<ValidationMessage> errorMessages = new FilteredList(this.unmodifiableMessages, message -> message.getSeverity().equals((Object)Severity.ERROR));
    private ObservableList<ValidationMessage> warningMessages = new FilteredList(this.unmodifiableMessages, message -> message.getSeverity().equals((Object)Severity.WARNING));

    protected ObservableList<ValidationMessage> getMessagesInternal() {
        return this.messages;
    }

    void addMessage(ValidationMessage message) {
        this.getMessagesInternal().add((Object)message);
    }

    void addMessage(Collection<ValidationMessage> messages) {
        this.getMessagesInternal().addAll(messages);
    }

    void removeMessage(ValidationMessage message) {
        this.getMessagesInternal().remove((Object)message);
    }

    void removeMessage(Collection<? extends ValidationMessage> messages) {
        this.getMessagesInternal().removeAll(messages);
    }

    void clearMessages() {
        this.getMessagesInternal().clear();
    }

    public ObservableList<ValidationMessage> getMessages() {
        return this.unmodifiableMessages;
    }

    public ObservableList<ValidationMessage> getErrorMessages() {
        return this.errorMessages;
    }

    public ObservableList<ValidationMessage> getWarningMessages() {
        return this.warningMessages;
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.messages.emptyProperty();
    }

    public boolean isValid() {
        return this.validProperty().get();
    }

    public Optional<ValidationMessage> getHighestMessage() {
        Optional<ValidationMessage> error = this.getMessages().stream().filter(message -> message.getSeverity().equals((Object)Severity.ERROR)).findFirst();
        if (error.isPresent()) {
            return error;
        }
        Optional<ValidationMessage> warning = this.getMessages().stream().filter(message -> message.getSeverity().equals((Object)Severity.WARNING)).findFirst();
        return warning;
    }
}

