/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;

public class ObservableRuleBasedValidator
implements Validator {
    private List<ObservableValue<Boolean>> booleanRules = new ArrayList<ObservableValue<Boolean>>();
    private List<ObservableValue<ValidationMessage>> complexRules = new ArrayList<ObservableValue<ValidationMessage>>();
    private ValidationStatus validationStatus = new ValidationStatus();

    public ObservableRuleBasedValidator() {
    }

    public ObservableRuleBasedValidator(ObservableValue<Boolean> rule, ValidationMessage message) {
        this.addRule(rule, message);
    }

    public ObservableRuleBasedValidator(ObservableValue<ValidationMessage> ... rules) {
        for (ObservableValue<ValidationMessage> rule : rules) {
            this.addRule(rule);
        }
    }

    public void addRule(ObservableValue<Boolean> rule, ValidationMessage message) {
        this.booleanRules.add(rule);
        rule.addListener((observable, oldValue, newValue) -> this.validateBooleanRule((boolean)newValue, message));
        this.validateBooleanRule((Boolean)rule.getValue(), message);
    }

    private void validateBooleanRule(boolean isValid, ValidationMessage message) {
        if (isValid) {
            this.validationStatus.removeMessage(message);
        } else {
            this.validationStatus.addMessage(message);
        }
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void addRule(ObservableValue<ValidationMessage> rule) {
        this.complexRules.add(rule);
        rule.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.validationStatus.removeMessage((ValidationMessage)oldValue);
            }
            if (newValue != null) {
                this.validationStatus.addMessage((ValidationMessage)newValue);
            }
        });
        if (rule.getValue() != null) {
            this.validationStatus.addMessage((ValidationMessage)rule.getValue());
        }
    }
}

