/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.script.AbstractScriptElement;
import net.sourceforge.jeuclid.elements.presentation.script.Mprescripts;
import net.sourceforge.jeuclid.elements.presentation.script.ScriptSupport;
import net.sourceforge.jeuclid.elements.support.Dimension2DImpl;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.MathMLNodeListImpl;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLMultiScriptsElement;
import org.w3c.dom.mathml.MathMLNodeList;

public final class Mmultiscripts
extends AbstractScriptElement
implements MathMLMultiScriptsElement {
    public static final String ELEMENT = "mmultiscripts";
    private static final long serialVersionUID = 1L;
    private static final int STATE_POSTSUB = 0;
    private static final int STATE_POSTSUPER = 1;
    private static final int STATE_PRESUB = 2;
    private static final int STATE_PRESUPER = 3;
    private final List<JEuclidElement> postsubscripts = new ArrayList<JEuclidElement>();
    private final List<JEuclidElement> postsuperscripts = new ArrayList<JEuclidElement>();
    private final List<JEuclidElement> presubscripts = new ArrayList<JEuclidElement>();
    private final List<JEuclidElement> presuperscripts = new ArrayList<JEuclidElement>();
    private boolean inRewriteChildren = false;

    public Mmultiscripts(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    protected Node newNode() {
        return new Mmultiscripts(this.nodeName, this.ownerDocument);
    }

    @Override
    public void changeHook() {
        super.changeHook();
        if (!this.inRewriteChildren) {
            this.parseChildren();
        }
    }

    private void parseChildren() {
        this.presubscripts.clear();
        this.presuperscripts.clear();
        this.postsubscripts.clear();
        this.postsuperscripts.clear();
        int n = this.getMathElementCount();
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            JEuclidElement jEuclidElement = this.getMathElement(i);
            if (jEuclidElement instanceof Mprescripts) {
                n2 = 2;
                continue;
            }
            if (n2 == 0) {
                this.postsubscripts.add(jEuclidElement);
                n2 = 1;
                continue;
            }
            if (n2 == 1) {
                this.postsuperscripts.add(jEuclidElement);
                n2 = 0;
                continue;
            }
            if (n2 == 2) {
                this.presubscripts.add(jEuclidElement);
                n2 = 3;
                continue;
            }
            this.presuperscripts.add(jEuclidElement);
            n2 = 2;
        }
        if (this.postsuperscripts.size() < this.postsubscripts.size()) {
            this.postsuperscripts.add((JEuclidElement)this.getOwnerDocument().createElement("none"));
        }
        if (this.presuperscripts.size() < this.presubscripts.size()) {
            this.presuperscripts.add((JEuclidElement)this.getOwnerDocument().createElement("none"));
        }
    }

    @Override
    protected void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        LayoutInfo layoutInfo2;
        LayoutInfo layoutInfo3;
        int n;
        JEuclidElement jEuclidElement = this.getBase();
        LayoutInfo layoutInfo4 = layoutView.getInfo(jEuclidElement);
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        String string = this.getSubscriptshift();
        String string2 = this.getSuperscriptshift();
        ScriptSupport.ShiftInfo shiftInfo = this.calculateTotalShift(layoutView, layoutStage, layoutInfo4, layoutContext2, string, string2);
        float f = 0.0f;
        float f2 = shiftInfo.getSubShift();
        float f3 = shiftInfo.getSuperShift();
        for (n = 0; n < this.presubscripts.size(); ++n) {
            layoutInfo3 = layoutView.getInfo(this.presubscripts.get(n));
            layoutInfo2 = layoutView.getInfo(this.presuperscripts.get(n));
            layoutInfo3.moveTo(f, f2, layoutStage);
            layoutInfo2.moveTo(f, -f3, layoutStage);
            f += Math.max(layoutInfo3.getWidth(layoutStage), layoutInfo2.getWidth(layoutStage));
        }
        layoutInfo4.moveTo(f, 0.0f, layoutStage);
        f += layoutInfo4.getWidth(layoutStage);
        for (n = 0; n < this.postsubscripts.size(); ++n) {
            layoutInfo3 = layoutView.getInfo(this.postsubscripts.get(n));
            layoutInfo2 = layoutView.getInfo(this.postsuperscripts.get(n));
            layoutInfo3.moveTo(f, f2, layoutStage);
            layoutInfo2.moveTo(f, -f3, layoutStage);
            f += Math.max(layoutInfo3.getWidth(layoutStage), layoutInfo2.getWidth(layoutStage));
        }
        Dimension2DImpl dimension2DImpl = new Dimension2DImpl(0.0f, 0.0f);
        ElementListSupport.fillInfoFromChildren(layoutView, layoutInfo, this, layoutStage, dimension2DImpl, dimension2DImpl);
    }

    private ScriptSupport.ShiftInfo calculateTotalShift(LayoutView layoutView, LayoutStage layoutStage, LayoutInfo layoutInfo, LayoutContext layoutContext, String string, String string2) {
        ScriptSupport.ShiftInfo shiftInfo;
        LayoutInfo layoutInfo2;
        LayoutInfo layoutInfo3;
        int n;
        ScriptSupport.ShiftInfo shiftInfo2 = new ScriptSupport.ShiftInfo(0.0f, 0.0f);
        for (n = 0; n < this.presubscripts.size(); ++n) {
            layoutInfo3 = layoutView.getInfo(this.presubscripts.get(n));
            layoutInfo2 = layoutView.getInfo(this.presuperscripts.get(n));
            shiftInfo = ScriptSupport.calculateScriptShfits(layoutStage, layoutContext, string, string2, layoutInfo, layoutInfo3, layoutInfo2);
            shiftInfo2.max(shiftInfo);
        }
        for (n = 0; n < this.postsubscripts.size(); ++n) {
            layoutInfo3 = layoutView.getInfo(this.postsubscripts.get(n));
            layoutInfo2 = layoutView.getInfo(this.postsuperscripts.get(n));
            shiftInfo = ScriptSupport.calculateScriptShfits(layoutStage, layoutContext, string, string2, layoutInfo, layoutInfo3, layoutInfo2);
            shiftInfo2.max(shiftInfo);
        }
        return shiftInfo2;
    }

    @Override
    public boolean hasChildPrescripts(JEuclidElement jEuclidElement) {
        return jEuclidElement.isSameNode(this.getBase()) && this.getNumprescriptcolumns() > 0;
    }

    @Override
    public boolean hasChildPostscripts(JEuclidElement jEuclidElement, LayoutContext layoutContext) {
        return jEuclidElement.isSameNode(this.getBase()) && this.getNumscriptcolumns() > 0;
    }

    @Override
    public JEuclidElement getBase() {
        JEuclidElement jEuclidElement = this.getMathElement(0);
        if (jEuclidElement == null) {
            return (JEuclidElement)this.getOwnerDocument().createElement("none");
        }
        return jEuclidElement;
    }

    @Override
    public void setBase(MathMLElement mathMLElement) {
        this.setMathElement(0, mathMLElement);
    }

    @Override
    public int getNumprescriptcolumns() {
        return this.presubscripts.size();
    }

    @Override
    public int getNumscriptcolumns() {
        return this.postsubscripts.size();
    }

    @Override
    public MathMLElement getPreSubScript(int n) {
        return this.presubscripts.get(n - 1);
    }

    @Override
    public MathMLElement getPreSuperScript(int n) {
        return this.presuperscripts.get(n - 1);
    }

    @Override
    public MathMLNodeList getPrescripts() {
        int n = this.presubscripts.size();
        ArrayList<Node> arrayList = new ArrayList<Node>(2 * n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.presubscripts.get(i));
            arrayList.add(this.presuperscripts.get(i));
        }
        return new MathMLNodeListImpl(arrayList);
    }

    @Override
    public MathMLNodeList getScripts() {
        int n = this.postsubscripts.size();
        ArrayList<Node> arrayList = new ArrayList<Node>(2 * n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.postsubscripts.get(i));
            arrayList.add(this.postsuperscripts.get(i));
        }
        return new MathMLNodeListImpl(arrayList);
    }

    @Override
    public MathMLElement getSubScript(int n) {
        if (n < 1 || n > this.postsubscripts.size()) {
            return null;
        }
        return this.postsubscripts.get(n - 1);
    }

    @Override
    public MathMLElement getSuperScript(int n) {
        if (n < 1 || n > this.postsuperscripts.size()) {
            return null;
        }
        return this.postsuperscripts.get(n - 1);
    }

    private void rewriteChildren() {
        int n;
        this.inRewriteChildren = true;
        NodeList nodeList = this.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = 1; n < n2; ++n) {
            this.removeChild(nodeList.item(1));
        }
        if (n2 == 0) {
            this.addMathElement((JEuclidElement)this.getOwnerDocument().createElement("none"));
        }
        for (n = 0; n < this.postsubscripts.size(); ++n) {
            this.addMathElement(this.postsubscripts.get(n));
            this.addMathElement(this.postsuperscripts.get(n));
        }
        n = this.presubscripts.size();
        if (n > 0) {
            this.addMathElement((Mprescripts)this.getOwnerDocument().createElement("mprescripts"));
            for (int i = 0; i < n; ++i) {
                this.addMathElement(this.presubscripts.get(i));
                this.addMathElement(this.presuperscripts.get(i));
            }
        }
        this.inRewriteChildren = false;
    }

    @Override
    public MathMLElement insertPreSubScriptBefore(int n, MathMLElement mathMLElement) {
        int n2 = n == 0 ? this.presubscripts.size() : n - 1;
        this.presubscripts.add(n2, (JEuclidElement)mathMLElement);
        this.presuperscripts.add(n2, (JEuclidElement)this.getOwnerDocument().createElement("none"));
        this.rewriteChildren();
        return mathMLElement;
    }

    @Override
    public MathMLElement insertPreSuperScriptBefore(int n, MathMLElement mathMLElement) {
        int n2 = n == 0 ? this.presubscripts.size() : n - 1;
        this.presubscripts.add(n2, (JEuclidElement)this.getOwnerDocument().createElement("none"));
        this.presuperscripts.add(n2, (JEuclidElement)mathMLElement);
        this.rewriteChildren();
        return mathMLElement;
    }

    @Override
    public MathMLElement insertSubScriptBefore(int n, MathMLElement mathMLElement) {
        int n2 = n == 0 ? this.postsubscripts.size() : n - 1;
        this.postsubscripts.add(n2, (JEuclidElement)mathMLElement);
        this.postsuperscripts.add(n2, (JEuclidElement)this.getOwnerDocument().createElement("none"));
        this.rewriteChildren();
        return mathMLElement;
    }

    @Override
    public MathMLElement insertSuperScriptBefore(int n, MathMLElement mathMLElement) {
        int n2 = n == 0 ? this.postsubscripts.size() : n - 1;
        this.postsubscripts.add(n2, (JEuclidElement)this.getOwnerDocument().createElement("none"));
        this.postsuperscripts.add(n2, (JEuclidElement)mathMLElement);
        this.rewriteChildren();
        return mathMLElement;
    }

    @Override
    public MathMLElement setPreSubScriptAt(int n, MathMLElement mathMLElement) {
        int n2 = n - 1;
        if (n2 == this.presubscripts.size()) {
            return this.insertPreSubScriptBefore(0, mathMLElement);
        }
        this.presubscripts.set(n2, (JEuclidElement)mathMLElement);
        this.rewriteChildren();
        return mathMLElement;
    }

    @Override
    public MathMLElement setPreSuperScriptAt(int n, MathMLElement mathMLElement) {
        int n2 = n - 1;
        if (n2 == this.presuperscripts.size()) {
            return this.insertPreSuperScriptBefore(0, mathMLElement);
        }
        this.presuperscripts.set(n2, (JEuclidElement)mathMLElement);
        this.rewriteChildren();
        return mathMLElement;
    }

    @Override
    public MathMLElement setSubScriptAt(int n, MathMLElement mathMLElement) {
        int n2 = n - 1;
        if (n2 == this.postsubscripts.size()) {
            return this.insertSubScriptBefore(0, mathMLElement);
        }
        this.postsubscripts.set(n2, (JEuclidElement)mathMLElement);
        this.rewriteChildren();
        return mathMLElement;
    }

    @Override
    public MathMLElement setSuperScriptAt(int n, MathMLElement mathMLElement) {
        int n2 = n - 1;
        if (n2 == this.postsuperscripts.size()) {
            return this.insertSuperScriptBefore(0, mathMLElement);
        }
        this.postsuperscripts.set(n2, (JEuclidElement)mathMLElement);
        this.rewriteChildren();
        return mathMLElement;
    }
}

