/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.unitfx.skins;

import com.dlsc.unitfx.DoubleInputField;
import com.dlsc.unitfx.QuantityInputField;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListCell;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javax.measure.Quantity;
import javax.measure.Unit;

public class QuantityInputFieldSkin<Q extends Quantity<Q>>
extends SkinBase<QuantityInputField<Q>> {
    private final DoubleInputField editor;
    private final ComboBox<Unit<Q>> switcher;
    private final Label editorDisabled;
    private final Label switcherDisabled;

    public QuantityInputFieldSkin(QuantityInputField<Q> control) {
        super(control);
        Region dirtyIcon = new Region();
        dirtyIcon.getStyleClass().add((Object)"dirty-icon");
        dirtyIcon.visibleProperty().bind((ObservableValue)control.valueDirtyProperty());
        dirtyIcon.managedProperty().bind((ObservableValue)dirtyIcon.visibleProperty());
        dirtyIcon.setOnMouseClicked(evt -> control.restoreValueProperty());
        this.editor = new DoubleInputField();
        this.editor.getStyleClass().add((Object)"editor");
        this.editor.setLeft((Node)dirtyIcon);
        this.editor.valueProperty().bindBidirectional(control.valueProperty());
        this.editor.numberOfIntegersProperty().bind((ObservableValue)control.numberOfIntegersProperty());
        this.editor.numberOfDecimalsProperty().bind((ObservableValue)control.numberOfDecimalsProperty());
        this.editor.allowNegativesProperty().bind((ObservableValue)control.allowNegativesProperty());
        this.editor.minimumValueProperty().bind(control.minimumValueProperty());
        this.editor.maximumValueProperty().bind(control.maximumValueProperty());
        this.editor.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                control.restoreValueProperty();
            }
        });
        this.editor.focusedProperty().addListener((obs, oldV, newV) -> {
            if (!newV.booleanValue()) {
                control.restoreValueProperty();
            }
        });
        this.editor.validatorProperty().bind(control.valueValidatorProperty());
        this.editor.invalidProperty().addListener(obs -> control.getProperties().put((Object)"invalid", (Object)this.editor.isInvalid()));
        this.switcher = new ComboBox();
        this.switcher.getStyleClass().add((Object)"unit-switcher");
        this.switcher.setItems(control.getAvailableUnits());
        this.switcher.valueProperty().bindBidirectional(control.unitProperty());
        this.switcher.converterProperty().bind(control.unitStringConverterProperty());
        this.switcher.setButtonCell((ListCell)new UnitListCell());
        this.switcher.setCellFactory(lv -> new UnitListCell());
        this.editorDisabled = new Label();
        this.editorDisabled.getStyleClass().add((Object)"editor");
        this.editorDisabled.getStyleClass().add((Object)"editor-disabled");
        this.editorDisabled.textProperty().bind((ObservableValue)this.editor.textProperty());
        SimpleBooleanProperty unitNotBaseUnit = new SimpleBooleanProperty();
        InvalidationListener unitsListener = arg_0 -> QuantityInputFieldSkin.lambda$new$5(control, (BooleanProperty)unitNotBaseUnit, arg_0);
        control.baseUnitProperty().addListener(unitsListener);
        control.unitProperty().addListener(unitsListener);
        unitsListener.invalidated(null);
        Label unitLbl = new Label();
        unitLbl.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.convertUnitToString(control.getUnit()), (Observable[])new Observable[]{control.unitProperty()}));
        QuantityInputFieldSkin.decorateUnitLabel((Labeled)unitLbl, (BooleanProperty)unitNotBaseUnit);
        this.switcherDisabled = new Label();
        this.switcherDisabled.setGraphic((Node)unitLbl);
        this.switcherDisabled.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.switcherDisabled.getStyleClass().add((Object)"unit-switcher");
        this.switcherDisabled.getStyleClass().add((Object)"unit-switcher-disabled");
        this.updateChildren();
        control.readOnlyProperty().addListener(obs -> this.updateChildren());
        control.autoFixValueProperty().addListener(obs -> this.updateChildren());
    }

    private void updateChildren() {
        if (((QuantityInputField)this.getSkinnable()).isReadOnly()) {
            if (((QuantityInputField)this.getSkinnable()).isAutoFixValue()) {
                this.getChildren().setAll((Object[])new Node[]{this.editorDisabled, this.switcher});
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.editorDisabled, this.switcherDisabled});
            }
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.editor, this.switcher});
        }
    }

    private String convertUnitToString(Unit<Q> unit) {
        String text = "";
        if (((QuantityInputField)this.getSkinnable()).getUnitStringConverter() != null) {
            text = ((QuantityInputField)this.getSkinnable()).getUnitStringConverter().toString(unit);
        } else if (unit != null) {
            text = unit.toString();
        }
        return text;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double switcherWidth = this.snapSize(this.switcher.prefWidth(-1.0));
        double fieldX = this.snapPosition(contentX);
        double fieldY = this.snapPosition(contentY);
        double fieldWidth = this.snapSize(contentWidth);
        double fieldHeight = this.snapSize(contentHeight);
        double textBoxWidth = fieldWidth - switcherWidth;
        double unitBoxX = fieldWidth - switcherWidth;
        this.editorDisabled.resizeRelocate(fieldX, fieldY, textBoxWidth, fieldHeight);
        this.switcherDisabled.resizeRelocate(unitBoxX, fieldY, switcherWidth, fieldHeight);
        this.editor.resizeRelocate(fieldX, fieldY, textBoxWidth, fieldHeight);
        this.switcher.resizeRelocate(unitBoxX, fieldY, switcherWidth, fieldHeight);
    }

    private static Label decorateUnitLabel(Labeled unitLabel, BooleanProperty iconVisibleProperty) {
        Label icon = new Label();
        icon.getStyleClass().add((Object)"indicator");
        icon.setPrefWidth(5.0);
        icon.visibleProperty().bind((ObservableValue)iconVisibleProperty);
        unitLabel.setGraphic((Node)icon);
        unitLabel.setGraphicTextGap(5.0);
        unitLabel.getStyleClass().add((Object)"unit-label");
        return icon;
    }

    private static /* synthetic */ void lambda$new$5(QuantityInputField control, BooleanProperty unitNotBaseUnit, Observable obs) {
        Unit baseUnit = control.getBaseUnit();
        Unit unit = control.getUnit();
        unitNotBaseUnit.set(unit != null && baseUnit != null && !unit.equals(baseUnit));
    }

    private class UnitListCell
    extends ListCell<Unit<Q>> {
        private final Label icon;
        private final BooleanProperty itemNoBaseUnit = new SimpleBooleanProperty();

        UnitListCell() {
            this.icon = QuantityInputFieldSkin.decorateUnitLabel((Labeled)this, this.itemNoBaseUnit);
            InvalidationListener listener = obs -> {
                Unit baseUnit = ((QuantityInputField)QuantityInputFieldSkin.this.getSkinnable()).getBaseUnit();
                Unit unit = (Unit)this.getItem();
                this.itemNoBaseUnit.set(unit != null && baseUnit != null && !unit.equals(baseUnit));
            };
            ((QuantityInputField)QuantityInputFieldSkin.this.getSkinnable()).baseUnitProperty().addListener(listener);
            this.itemProperty().addListener(listener);
            this.getStyleClass().add((Object)"unit-cell");
        }

        protected void updateItem(Unit<Q> item, boolean empty) {
            super.updateItem(item, empty);
            if (item != null && !empty) {
                this.setText(QuantityInputFieldSkin.this.convertUnitToString(item));
                this.setGraphic((Node)this.icon);
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
        }
    }
}

