/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

interface OrientationHelper {
    public Orientation getContentBias();

    public double getX(double var1, double var3);

    public double getY(double var1, double var3);

    public double length(Bounds var1);

    public double breadth(Bounds var1);

    public double minX(Bounds var1);

    public double minY(Bounds var1);

    default public double maxX(Bounds bounds) {
        return this.minX(bounds) + this.breadth(bounds);
    }

    default public double maxY(Bounds bounds) {
        return this.minY(bounds) + this.length(bounds);
    }

    public double layoutX(Node var1);

    public double layoutY(Node var1);

    public DoubleProperty layoutYProperty(Node var1);

    default public double length(Node node) {
        return this.length(node.getLayoutBounds());
    }

    default public double breadth(Node node) {
        return this.breadth(node.getLayoutBounds());
    }

    default public Val<Double> minYProperty(Node node) {
        return Val.combine((ObservableValue)this.layoutYProperty(node), (ObservableValue)node.layoutBoundsProperty(), (layoutY, layoutBounds) -> layoutY.doubleValue() + this.minY((Bounds)layoutBounds));
    }

    default public double minY(Node node) {
        return this.layoutY(node) + this.minY(node.getLayoutBounds());
    }

    default public double maxY(Node node) {
        return this.minY(node) + this.length(node);
    }

    default public double minX(Node node) {
        return this.layoutX(node) + this.minX(node.getLayoutBounds());
    }

    default public double maxX(Node node) {
        return this.minX(node) + this.breadth(node);
    }

    default public double length(Cell<?, ?> cell) {
        return this.length((Node)cell.getNode());
    }

    default public double breadth(Cell<?, ?> cell) {
        return this.breadth((Node)cell.getNode());
    }

    default public Val<Double> minYProperty(Cell<?, ?> cell) {
        return this.minYProperty((Node)cell.getNode());
    }

    default public double minY(Cell<?, ?> cell) {
        return this.minY((Node)cell.getNode());
    }

    default public double maxY(Cell<?, ?> cell) {
        return this.maxY((Node)cell.getNode());
    }

    default public double minX(Cell<?, ?> cell) {
        return this.minX((Node)cell.getNode());
    }

    default public double maxX(Cell<?, ?> cell) {
        return this.maxX((Node)cell.getNode());
    }

    public double minBreadth(Node var1);

    default public double minBreadth(Cell<?, ?> cell) {
        return this.minBreadth((Node)cell.getNode());
    }

    public double prefBreadth(Node var1);

    public double prefLength(Node var1, double var2);

    default public double prefLength(Cell<?, ?> cell, double breadth) {
        return this.prefLength((Node)cell.getNode(), breadth);
    }

    public void resizeRelocate(Node var1, double var2, double var4, double var6, double var8);

    public void resize(Node var1, double var2, double var4);

    public void relocate(Node var1, double var2, double var4);

    default public void resize(Cell<?, ?> cell, double breadth, double length) {
        this.resize((Node)cell.getNode(), breadth, length);
    }

    default public void relocate(Cell<?, ?> cell, double b0, double l0) {
        this.relocate((Node)cell.getNode(), b0, l0);
    }

    public Val<Double> widthEstimateProperty(VirtualFlow<?, ?> var1);

    public Val<Double> heightEstimateProperty(VirtualFlow<?, ?> var1);

    public Var<Double> estimatedScrollXProperty(VirtualFlow<?, ?> var1);

    public Var<Double> estimatedScrollYProperty(VirtualFlow<?, ?> var1);

    public void scrollHorizontallyBy(VirtualFlow<?, ?> var1, double var2);

    public void scrollVerticallyBy(VirtualFlow<?, ?> var1, double var2);

    public void scrollHorizontallyToPixel(VirtualFlow<?, ?> var1, double var2);

    public void scrollVerticallyToPixel(VirtualFlow<?, ?> var1, double var2);

    public <C extends Cell<?, ?>> VirtualFlowHit<C> hitBeforeCells(double var1, double var3);

    public <C extends Cell<?, ?>> VirtualFlowHit<C> hitAfterCells(double var1, double var3);

    public <C extends Cell<?, ?>> VirtualFlowHit<C> cellHit(int var1, C var2, double var3, double var5);
}

