/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.model.strings.StringUtil;

public class FilePreferences {
    public static final String[] DEFAULT_FILENAME_PATTERNS = new String[]{"[bibtexkey]", "[bibtexkey] - [title]"};
    private final StringProperty userAndHost = new SimpleStringProperty();
    private final SimpleStringProperty mainFileDirectory = new SimpleStringProperty();
    private final BooleanProperty storeFilesRelativeToBibFile = new SimpleBooleanProperty();
    private final StringProperty fileNamePattern = new SimpleStringProperty();
    private final StringProperty fileDirectoryPattern = new SimpleStringProperty();
    private final BooleanProperty downloadLinkedFiles = new SimpleBooleanProperty();
    private final BooleanProperty fulltextIndexLinkedFiles = new SimpleBooleanProperty();
    private final ObjectProperty<Path> workingDirectory = new SimpleObjectProperty();
    private final ObservableSet<ExternalFileType> externalFileTypes = FXCollections.observableSet(new TreeSet<ExternalFileType>(Comparator.comparing(ExternalFileType::getName)));
    private final BooleanProperty createBackup = new SimpleBooleanProperty();
    private final ObjectProperty<Path> backupDirectory = new SimpleObjectProperty();
    private final BooleanProperty confirmDeleteLinkedFile = new SimpleBooleanProperty();
    private final BooleanProperty moveToTrash = new SimpleBooleanProperty();

    public FilePreferences(String userAndHost, String mainFileDirectory, boolean storeFilesRelativeToBibFile, String fileNamePattern, String fileDirectoryPattern, boolean downloadLinkedFiles, boolean fulltextIndexLinkedFiles, Path workingDirectory, Set<ExternalFileType> externalFileTypes, boolean createBackup, Path backupDirectory, boolean confirmDeleteLinkedFile, boolean moveToTrash) {
        this.userAndHost.setValue(userAndHost);
        this.mainFileDirectory.setValue(mainFileDirectory);
        this.storeFilesRelativeToBibFile.setValue(Boolean.valueOf(storeFilesRelativeToBibFile));
        this.fileNamePattern.setValue(fileNamePattern);
        this.fileDirectoryPattern.setValue(fileDirectoryPattern);
        this.downloadLinkedFiles.setValue(Boolean.valueOf(downloadLinkedFiles));
        this.fulltextIndexLinkedFiles.setValue(Boolean.valueOf(fulltextIndexLinkedFiles));
        this.workingDirectory.setValue((Object)workingDirectory);
        this.externalFileTypes.addAll(externalFileTypes);
        this.createBackup.setValue(Boolean.valueOf(createBackup));
        this.backupDirectory.setValue((Object)backupDirectory);
        this.confirmDeleteLinkedFile.setValue(Boolean.valueOf(confirmDeleteLinkedFile));
        this.moveToTrash.setValue(Boolean.valueOf(moveToTrash));
    }

    public String getUserAndHost() {
        return this.userAndHost.getValue();
    }

    public StringProperty getUserAndHostProperty() {
        return this.userAndHost;
    }

    public Optional<Path> getMainFileDirectory() {
        if (StringUtil.isBlank(this.mainFileDirectory.getValue())) {
            return Optional.empty();
        }
        return Optional.of(Path.of(this.mainFileDirectory.getValue(), new String[0]));
    }

    public StringProperty mainFileDirectoryProperty() {
        return this.mainFileDirectory;
    }

    public void setMainFileDirectory(String mainFileDirectory) {
        this.mainFileDirectory.set(mainFileDirectory);
    }

    public boolean shouldStoreFilesRelativeToBibFile() {
        return this.storeFilesRelativeToBibFile.get();
    }

    public BooleanProperty storeFilesRelativeToBibFileProperty() {
        return this.storeFilesRelativeToBibFile;
    }

    public void setStoreFilesRelativeToBibFile(boolean shouldStoreFilesRelativeToBibFile) {
        this.storeFilesRelativeToBibFile.set(shouldStoreFilesRelativeToBibFile);
    }

    public String getFileNamePattern() {
        return (String)this.fileNamePattern.get();
    }

    public StringProperty fileNamePatternProperty() {
        return this.fileNamePattern;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern.set((Object)fileNamePattern);
    }

    public String getFileDirectoryPattern() {
        return (String)this.fileDirectoryPattern.get();
    }

    public StringProperty fileDirectoryPatternProperty() {
        return this.fileDirectoryPattern;
    }

    public void setFileDirectoryPattern(String fileDirectoryPattern) {
        this.fileDirectoryPattern.set((Object)fileDirectoryPattern);
    }

    public boolean shouldDownloadLinkedFiles() {
        return this.downloadLinkedFiles.get();
    }

    public BooleanProperty downloadLinkedFilesProperty() {
        return this.downloadLinkedFiles;
    }

    public void setDownloadLinkedFiles(boolean shouldDownloadLinkedFiles) {
        this.downloadLinkedFiles.set(shouldDownloadLinkedFiles);
    }

    public boolean shouldFulltextIndexLinkedFiles() {
        return this.fulltextIndexLinkedFiles.get();
    }

    public BooleanProperty fulltextIndexLinkedFilesProperty() {
        return this.fulltextIndexLinkedFiles;
    }

    public void setFulltextIndexLinkedFiles(boolean shouldFulltextIndexLinkedFiles) {
        this.fulltextIndexLinkedFiles.set(shouldFulltextIndexLinkedFiles);
    }

    public Path getWorkingDirectory() {
        return (Path)this.workingDirectory.get();
    }

    public ObjectProperty<Path> workingDirectoryProperty() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.workingDirectory.set((Object)workingDirectory);
    }

    public ObservableSet<ExternalFileType> getExternalFileTypes() {
        return this.externalFileTypes;
    }

    public void setCreateBackup(boolean createBackup) {
        this.createBackup.set(createBackup);
    }

    public boolean shouldCreateBackup() {
        return this.createBackup.getValue();
    }

    public BooleanProperty createBackupProperty() {
        return this.createBackup;
    }

    public ObjectProperty<Path> backupDirectoryProperty() {
        return this.backupDirectory;
    }

    public void setBackupDirectory(Path backupPath) {
        this.backupDirectory.set((Object)backupPath);
    }

    public Path getBackupDirectory() {
        return (Path)this.backupDirectory.getValue();
    }

    public boolean confirmDeleteLinkedFile() {
        return this.confirmDeleteLinkedFile.get();
    }

    public BooleanProperty confirmDeleteLinkedFileProperty() {
        return this.confirmDeleteLinkedFile;
    }

    public void confirmDeleteLinkedFile(boolean confirmLinkedFileDelete) {
        this.confirmDeleteLinkedFile.set(confirmLinkedFileDelete);
    }

    public boolean moveToTrash() {
        return this.moveToTrash.get();
    }

    public BooleanProperty moveToTrashProperty() {
        return this.moveToTrash;
    }

    public void moveToTrash(boolean moveToTrash) {
        this.moveToTrash.set(moveToTrash);
    }
}

