/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.FieldFormatterCleanups;

public class CleanupPreferences {
    private final ObservableSet<CleanupStep> activeJobs;
    private final ObjectProperty<FieldFormatterCleanups> fieldFormatterCleanups;

    public CleanupPreferences(EnumSet<CleanupStep> activeJobs) {
        this(activeJobs, new FieldFormatterCleanups(false, new ArrayList<FieldFormatterCleanup>()));
    }

    public CleanupPreferences(CleanupStep activeJob) {
        this(EnumSet.of(activeJob));
    }

    public CleanupPreferences(FieldFormatterCleanups formatterCleanups) {
        this(EnumSet.noneOf(CleanupStep.class), formatterCleanups);
    }

    public CleanupPreferences(EnumSet<CleanupStep> activeJobs, FieldFormatterCleanups formatterCleanups) {
        this.activeJobs = FXCollections.observableSet(activeJobs);
        this.fieldFormatterCleanups = new SimpleObjectProperty((Object)formatterCleanups);
    }

    public EnumSet<CleanupStep> getActiveJobs() {
        if (this.activeJobs.isEmpty()) {
            return EnumSet.noneOf(CleanupStep.class);
        }
        return EnumSet.copyOf(this.activeJobs);
    }

    public void setActive(CleanupStep job, boolean value) {
        if (this.activeJobs.contains((Object)job) && !value) {
            this.activeJobs.remove((Object)job);
        } else if (!this.activeJobs.contains((Object)job) && value) {
            this.activeJobs.add((Object)job);
        }
    }

    protected ObservableSet<CleanupStep> getObservableActiveJobs() {
        return this.activeJobs;
    }

    public void setActiveJobs(Set<CleanupStep> jobs) {
        this.activeJobs.clear();
        this.activeJobs.addAll(jobs);
    }

    public Boolean isActive(CleanupStep step) {
        return this.activeJobs.contains((Object)step);
    }

    public FieldFormatterCleanups getFieldFormatterCleanups() {
        return (FieldFormatterCleanups)this.fieldFormatterCleanups.get();
    }

    protected ObjectProperty<FieldFormatterCleanups> fieldFormatterCleanupsProperty() {
        return this.fieldFormatterCleanups;
    }

    public void setFieldFormatterCleanups(FieldFormatterCleanups fieldFormatters) {
        this.fieldFormatterCleanups.setValue((Object)fieldFormatters);
    }

    public static enum CleanupStep {
        CLEAN_UP_DOI,
        CLEANUP_EPRINT,
        CLEAN_UP_URL,
        MAKE_PATHS_RELATIVE,
        RENAME_PDF,
        RENAME_PDF_ONLY_RELATIVE_PATHS,
        CLEAN_UP_UPGRADE_EXTERNAL_LINKS,
        CLEAN_UP_DELETED_LINKED_FILES,
        CONVERT_TO_BIBLATEX,
        CONVERT_TO_BIBTEX,
        CONVERT_TIMESTAMP_TO_CREATIONDATE,
        CONVERT_TIMESTAMP_TO_MODIFICATIONDATE,
        DO_NOT_CONVERT_TIMESTAMP,
        MOVE_PDF,
        FIX_FILE_LINKS,
        CLEAN_UP_ISSN;

    }
}

