/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.texparser;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jabref.model.texparser.Citation;

public class LatexParserResult {
    private final Path path;
    private final Multimap<String, Citation> citations;
    private final List<Path> nestedFiles;
    private final List<Path> bibFiles;

    public LatexParserResult(Path path) {
        this.path = path;
        this.citations = HashMultimap.create();
        this.nestedFiles = new ArrayList<Path>();
        this.bibFiles = new ArrayList<Path>();
    }

    public Path getPath() {
        return this.path;
    }

    public Multimap<String, Citation> getCitations() {
        return this.citations;
    }

    public Collection<Citation> getCitationsByKey(String key) {
        return this.citations.get((Object)key);
    }

    public void addKey(String key, Path path, int lineNumber, int start, int end, String line) {
        this.citations.put((Object)key, (Object)new Citation(path, lineNumber, start, end, line));
    }

    public List<Path> getNestedFiles() {
        return this.nestedFiles;
    }

    public void addNestedFile(Path nestedFile) {
        this.nestedFiles.add(nestedFile);
    }

    public List<Path> getBibFiles() {
        return this.bibFiles;
    }

    public void addBibFile(Path bibFile) {
        this.bibFiles.add(bibFile);
    }

    public String toString() {
        return "TexParserResult{path=%s, citations=%s, nestedFiles=%s, bibFiles=%s}".formatted(this.path, this.citations, this.nestedFiles, this.bibFiles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatexParserResult that = (LatexParserResult)obj;
        return Objects.equals(this.path, that.path) && Objects.equals(this.citations, that.citations) && Objects.equals(this.nestedFiles, that.nestedFiles) && Objects.equals(this.bibFiles, that.bibFiles);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.citations, this.nestedFiles, this.bibFiles);
    }
}

