/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.strings;

import com.github.tomtung.latex2unicode.LaTeX2Unicode;
import fastparse.Parsed;
import java.text.Normalizer;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class LatexToUnicodeAdapter {
    private static final Pattern UNDERSCORE_MATCHER = Pattern.compile("_(?!\\{)");
    private static final String REPLACEMENT_CHAR = "\ufffd";
    private static final Pattern UNDERSCORE_PLACEHOLDER_MATCHER = Pattern.compile("\ufffd");

    public static String format(String inField) {
        Objects.requireNonNull(inField);
        return LatexToUnicodeAdapter.parse(inField).orElse(Normalizer.normalize(inField, Normalizer.Form.NFC));
    }

    public static Optional<String> parse(String inField) {
        Objects.requireNonNull(inField);
        String toFormat = UNDERSCORE_MATCHER.matcher(inField).replaceAll(REPLACEMENT_CHAR);
        Parsed parsingResult = LaTeX2Unicode.parse((String)toFormat);
        if (parsingResult instanceof Parsed.Success) {
            String text = (String)parsingResult.get().value();
            toFormat = Normalizer.normalize(text, Normalizer.Form.NFC);
            return Optional.of(UNDERSCORE_PLACEHOLDER_MATCHER.matcher(toFormat).replaceAll("_"));
        }
        return Optional.empty();
    }
}

