/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.search.rules.FullTextSearchRule;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.search.rules.SentenceAnalyzer;
import org.jabref.model.strings.StringUtil;

@AllowedToUseLogic(value="Because access to the lucene index is needed")
public class ContainsBasedSearchRule
extends FullTextSearchRule {
    public ContainsBasedSearchRule(EnumSet<SearchRules.SearchFlags> searchFlags) {
        super(searchFlags);
    }

    @Override
    public boolean validateSearchStrings(String query) {
        return true;
    }

    @Override
    public boolean applyRule(String query, BibEntry bibEntry) {
        String searchString = query;
        if (!this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
            searchString = searchString.toLowerCase(Locale.ROOT);
        }
        List<String> unmatchedWords = new SentenceAnalyzer(searchString).getWords();
        for (Field fieldKey : bibEntry.getFields()) {
            String formattedFieldContent = StringUtil.stripAccents(bibEntry.getFieldLatexFree(fieldKey).get());
            if (!this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
                formattedFieldContent = formattedFieldContent.toLowerCase(Locale.ROOT);
            }
            Iterator<String> unmatchedWordsIterator = unmatchedWords.iterator();
            while (unmatchedWordsIterator.hasNext()) {
                String word = StringUtil.stripAccents(unmatchedWordsIterator.next());
                if (!formattedFieldContent.contains(word)) continue;
                unmatchedWordsIterator.remove();
            }
            if (!unmatchedWords.isEmpty()) continue;
            return true;
        }
        if (!this.searchFlags.contains((Object)SearchRules.SearchFlags.FULLTEXT)) {
            return false;
        }
        return this.getFulltextResults(query, bibEntry).numSearchResults() > 0;
    }
}

